/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */
exports.types = {
    SHORT: 'short',
    LAZY: 'lazy',
    FULL: 'full'
};
var type = exports.types;
/**
 * List of all the licenses.
 * Currently only short substrings are used with regex.
 */
exports.licenses = {

    CC0: {
	licenseName: 'Creative Commons CC0 1.0 Universal',
	canonicalUrl: 'http://creativecommons.org/publicdomain/zero/1.0/legalcode',
	identifier: 'CC0-1.0',
	licenseFragments: []
    },


    gplv2: {
	licenseName: 'GNU General Public License (GPL) version 2',
	canonicalUrl: 'http://www.gnu.org/licenses/gpl-2.0.html',
	identifier: 'GNU-GPL-2.0',
	licenseFragments: [{text: "<THISPROGRAM> is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.", type: type.SHORT},
			   {text:"Alternatively, the contents of this file may be used under the terms of either the GNU General Public License Version 2 or later (the \"GPL\"), or the GNU Lesser General Public License Version 2.1 or later (the \"LGPL\"), in which case the provisions of the GPL or the LGPL are applicable instead of those above. If you wish to allow use of your version of this file only under the terms of either the GPL or the LGPL, and not to allow others to use your version of this file under the terms of the MPL, indicate your decision by deleting the provisions above and replace them with the notice and other provisions required by the GPL or the LGPL. If you do not delete the provisions above, a recipient may use your version of this file under the terms of any one of the MPL, the GPL or the LGPL.", type: type.SHORT}]
    },

    gplv3: {
	licenseName: 'GNU General Public License (GPL) version 3',
	canonicalUrl: 'http://www.gnu.org/licenses/gpl-3.0.html',
	identifier: 'GNU-GPL-3.0',
	licenseFragments: [
	    {text: "The JavaScript code in this page is free software: you can redistribute it and/or modify it under the terms of the GNU  General Public License (GNU GPL) as published by the Free Software  Foundation, either version 3 of the License, or (at your option)  any later version. The code is distributed WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU GPL for more details. As additional permission under GNU GPL version 3 section 7, you may distribute non-source (e.g., minimized or compacted) forms of that code without the copy of the GNU GPL normally required by section 4, provided you include this license notice and a URL through which recipients can access the Corresponding Source.", type: type.SHORT},
	    {text: "<THISPROGRAM> is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.", type: type.SHORT}]
    },

    gnuAllPermissive: {
	licenseName: 'GNU All-Permissive License',
	licenseFragments: [{text: "Copying and distribution of this file, with or without modification, are permitted in any medium without royalty provided the copyright notice and this notice are preserved. This file is offered as-is, without any warranty.", type: type.SHORT}]
    },

    apache_2License: {
	licenseName: 'Apache License, Version 2.0',
	canonicalUrl: 'http://www.apache.org/licenses/LICENSE-2.0',
	identifier: 'Apache-2.0',
	licenseFragments: [{text: "Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0", type: type.SHORT}]
    },

    lgpl21: {
	licenseName: 'GNU Lesser General Public License, version 2.1',
	canonicalUrl: 'http://www.gnu.org/licenses/lgpl-2.1.html',
	identifier: 'GNU-LGPL-2.1',
	licenseFragments: [{text: "<THISLIBRARY> is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.", type: type.SHORT}]
    },

    lgplv3: {
	licenseName: 'GNU Lesser General Public License, version 3',
	canonicalUrl: 'http://www.gnu.org/licenses/lgpl-3.0.html',
	identifier: 'GNU-LGPL-3.0',
	licenseFragments: [{text: "<THISPROGRAM> is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.", type: type.SHORT}]
    },

    agplv3: {
	licenseName: 'GNU AFFERO GENERAL PUBLIC LICENSE version 3',
	canonicalUrl: 'http://www.gnu.org/licenses/agpl-3.0.html',
	identifier: 'GNU-AGPL-3.0',
	licenseFragments: [{text: "<THISPROGRAM> is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.", type: type.SHORT}]
    },

    boostSoftware: {
	licenseName: 'Boost Software License',
	licenseFragments: [{text: "Boost Software License <VERSION> <DATE> Permission is hereby granted, free of charge, to any person or organization obtaining a copy of the software and accompanying documentation covered by this license (the \"Software\") to use, reproduce, display, distribute, execute, and transmit the Software, and to prepare derivative works of the Software, and to permit third-parties to whom the Software is furnished to do so, all subject to the following", type: type.SHORT}]
    },

    bsd3: {
	licenseName: "The BSD 3-Clause License",
	licenseFragments: [{text: "Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. Neither the name of <ORGANIZATION> nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.", type: type.SHORT}]
    },

    bsd2: {
	licenseName: "The BSD 2-Clause License",
	licenseFragments: [{text: "Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.", type: type.SHORT}]
    },

    mozillaPublicLicense_2_0: {
	licenseName: 'Mozilla Public License Version 2.0',
	identifier: 'MPL-2.0',
	canonicalUrl: 'http://www.mozilla.org/MPL/2.0',
	licenseFragments: [{text: "This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0. If a copy of the MPL was not distributed with this file, You can obtain one at http://mozilla.org/MPL/2.0/.", type: type.SHORT }]
    },

    expat: {
	licenseName: 'Expat License (sometimes called MIT Licensed)',
	identifier: 'Expat',
	canonicalUrl: 'http://www.jclark.com/xml/copying.txt',
	licenseFragments: [{text: "Copyright <YEAR> <NAME> Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.", type: type.SHORT}]
    },
    X11: {
	licenseName: 'X11 License',
	licenseFragments: [{text: "Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.", type: type.SHORT}]
    },
    XFree86: {
	licenseName: "XFree86 License",
	identifier: 'Modified-BSD',
	canonicalUrl: ['http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3', 'http://www.xfree86.org/current/LICENSE4.html'],
	licenseFragments: [{text: "All rights reserved.\nPermission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n1. Redistributions of source code must retain the above copyright notice, this list of conditions, and the following disclaimer.\n2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution, and in the same place and form as other copyright, license and disclaimer information.\n3. The end-user documentation included with the redistribution, if any, must include the following acknowledgment: \"This product includes software developed by The XFree86 Project, Inc (http://www.xfree86.org/) and its contributors\", in the same place and form as other third-party acknowledgments. Alternately, this acknowledgment may appear in the software itself, in the same form and location as other such third-party acknowledgments.4. Except as contained in this notice, the name of The XFree86 Project, Inc shall not be used in advertising or otherwise to promote the sale, use or other dealings in this Software without prior written authorization from The XFree86 Project, Inc.", type: type.SHORT}
			   ]
    },

    FreeBSD: {
	licenseName: "FreeBSD License",
	canonicalUrl: 'http://www.freebsd.org/copyright/freebsd-license.html',
	licenseFragments: [{text: "Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n\nRedistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\n\nRedistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.", type: type.SHORT}]
    },

    ISC: {
	licenseName: "The ISC License",
	canonicalUrl: 'http://www.isc.org/software/license',
	licenseFragments: [{text: "Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted, provided that the above copyright notice and this permission notice appear in all copies.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\" AND ISC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.", type: type.SHORT}]
    },

    jQueryTools: {
	licenseName: "jQuery Tools",
	licenseFragments: [{text: 'NO COPYRIGHTS OR LICENSES. DO WHAT YOU LIKE.', type: type.SHORT}]
    },

    ArtisticLicense2: {
	licenseName: "Artistic License 2.0",
	canonicalUrl: "http://www.perlfoundation.org/artistic_license_2_0",
	licenseFragments: []
    }
    
};