/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : ANA_PYTHON_INTERP
    Description :
    Author      :
    Date        :
----------------------------------------------------- 
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*#include <python1.5/Python.h>*/
/*#include <python2.3/Python.h>*/
#include <python2.5/Python.h>
//#include <python/Python.h>
/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class ANA_PYTHON_INTERP
***************************************************
*/
 
/* Types for allocation memory on output parameters*/
#define NO_PARAMETER   0
#define SIMPLE_TYPE    1
#define STRING_TYPE    2
#define BUFFER_TYPE    3


typedef struct output_params_t
{
  EPUint32      *pointer;
  ESint32       type;
} OPAR;
 

/* Python topics*/
static PyObject *
anna_new_obj (PyObject *self, PyObject *args)
{
  char    *classname;
  OBJID   obj;

  if (!PyArg_ParseTuple (args, "s", &classname))
    return NULL;

  if ((obj = edma_new_obj (classname)) == -1)
    return NULL;
  
  return Py_BuildValue ("i", obj);
}

static PyObject *
anna_free_obj (PyObject *self, PyObject *args)
{
  OBJID   obj;

  if (!PyArg_ParseTuple(args, "i", &obj))
    return NULL;
  
  edma_free_obj (obj);

  return Py_BuildValue ("i", 0);
}

static PyObject *
anna_met3 (PyObject *self, PyObject *args)
{
  OBJID    obj;
  EChar    aux[80];
  EPChar   method_name;
  EPChar   method_sig;
  PyObject *obj_args;
  ESint32  edma_args[10];

  if (!PyArg_ParseTuple (args, "iss|O", &obj, &method_name, &method_sig, &obj_args))
    return NULL;

  if (strlen (method_sig))
    {
      strncpy (aux, "|", 1);
      strncat (aux, method_sig, 80);
      if (!PyArg_ParseTuple (obj_args, method_sig, 
			     &edma_args[0],
			     &edma_args[1],
			     &edma_args[2],
			     &edma_args[3],
			     &edma_args[4],
			     &edma_args[5],
			     &edma_args[6],
			     &edma_args[7],
			     &edma_args[8],
			     &edma_args[9]
			     ))
	return NULL;
    }
  edma_met3_pargs (obj, method_name, NULL, 1, edma_args);

  return Py_BuildValue ("i", 0);
}

static int
anna_build_parameter_list (EPChar aux,PyObject *args, int indx, 
			   EPSint32 par, EPSint32 par_inc)
{
  int       inc; /* how much to go forward on signature string*/
  PyObject  *item;

  *par_inc = inc = 0;
  switch (*aux)
    {
    case 'Z':  /* String*/
      {
	edma_printf ("[anna_met3x] String");
	item = PyTuple_GET_ITEM(args, indx);
	*par = (ESint32)PyString_AsString (item);
	break;
      }
    case 'O':  /* Object */
      {
	edma_printf ("[anna_met3x] Object");
	item = PyTuple_GET_ITEM(args, indx);
	*par = PyLong_AsLong (item);
	
	break;
      }
    case 'A':  /* Buffer*/
      {
	edma_printf ("[anna_met3x] EDMAT_BUFFER");
	break;
      }
    case 'R':
      {
	aux++;
	switch (*aux)
	  {
	  case '3':
	    {
	      item = PyTuple_GET_ITEM(args, indx);
	      *par = (float) PyFloat_AsDouble (item);
	      break;
	    }
	  case '6':
	    {
	      item = PyTuple_GET_ITEM(args, indx);
	      *((EPReal64)par) = PyFloat_AsDouble (item);
	      *par_inc ++;
	      break;
	    }
	  }
	break;
      }
    case 'U':  /* FIXME: Rewrite this case to take in account unsigned vals*/
    case 'S':  /* Signed Int*/
      {
	aux++;
	inc++;
	switch (*aux)
	  {
	  case '8':
	    {
	      edma_printf ("[anna_met3x] 8 bit signed int");
	      item = PyTuple_GET_ITEM(args, indx);
	      *par = PyInt_AsLong(item);
	      break;
	    }
	  case '1':
	    {
	      edma_printf ("[anna_met3x] 16 bit signed int");
	      item = PyTuple_GET_ITEM(args, indx);
	      *par = PyInt_AsLong(item);
	      aux++;
	      inc++;
	      break;
	    }
	  case '3':
	    {
	      edma_printf ("[anna_met3x] 32 bit signed int");
	      item = PyTuple_GET_ITEM(args, indx);
	      if ((*par = PyLong_AsLong(item)) == -1)
		*par = PyInt_AsLong(item);
	      aux++;
	      inc++;
	      break;
	    }
	  }
	break;
      }
    }
  return inc;
}

static PyObject *
anna_met3x (PyObject *self, PyObject *args)
{
  OBJID    obj;
  CLASSID  cid;
  EPChar   method_name;
  EPChar   method_sig, aux;
  PyObject *obj_args, *item;
  ESint32  edma_args[10],i, met_indx, len, param_cnt, param_inc;

  /* get object reference. First argument*/
  item = PyTuple_GET_ITEM(args, 0);
  obj = PyInt_AsLong (item);
  item = PyTuple_GET_ITEM(args, 1);
  method_name = PyString_AsString (item);

  /* Only process signature if it exists */
  if (PyTuple_Size (args) >3)
    {
      item = PyTuple_GET_ITEM(args, 2);
      method_sig = PyString_AsString (item);
    }
  else
    method_sig = NULL;

  len = PyString_Size(item);
  /* Parsing parameters based on method signature */
  param_cnt=0;
  if (method_sig)
    {
      aux = method_sig;
      while ((aux-method_sig) < len)
	{
	  aux += anna_build_parameter_list (aux, args, 3 + param_cnt, 
					    &edma_args[param_cnt], &param_inc); 
	  param_cnt++;
	  param_cnt+=param_inc;
	  aux++;
	}
      edma_printf ("[anna_met3x] %ld parameters found!", param_cnt);
    }

  edma_met3_pargs (obj, method_name, NULL, 1, edma_args);
  return Py_BuildValue ("i", 0);
}

/* Object data accessors */
static PyObject*
anna_set_prop_sint32 (PyObject *self, PyObject *args)
{
  OBJID    obj;
  CLASSID  cid;
  EPChar   prop_name;
  PyObject *item;
  ESint32  value;

  /* get object reference. First argument*/
  item = PyTuple_GET_ITEM(args, 0);
  obj = PyInt_AsLong (item);
  item = PyTuple_GET_ITEM(args, 1);
  prop_name = PyString_AsString (item);
  item = PyTuple_GET_ITEM(args, 2);
  value = PyInt_AsLong(item);

#if 0
  edma_printf ("(ANNA-says) Setting property (sint32)'%s' "
	       "in object %ld to %ld", prop_name, obj, value);
#endif
  edma_wprop3 (obj, prop_name, value);

  return Py_BuildValue ("i", 0);
}

static PyObject *
anna_get_prop_sint32 (PyObject *self, PyObject *args)
{
  OBJID    obj;
  CLASSID  cid;
  EPChar   prop_name;
  PyObject *item;
  ESint32  value;

  /* get object reference. First argument*/
  item = PyTuple_GET_ITEM(args, 0);
  obj = PyInt_AsLong (item);
  item = PyTuple_GET_ITEM(args, 1);
  prop_name = PyString_AsString (item);

#if 0
  edma_printf ("(ANNA-says) Getting  property (sint32)'%s' "
	       "in object %ld",  prop_name, obj);
#endif

  return Py_BuildValue ("i", edma_get_prop_sint32 (obj, prop_name));

}


static PyObject*
anna_set_prop_uint32 (PyObject *self, PyObject *args)
{
  OBJID    obj;
  CLASSID  cid;
  EPChar   prop_name;
  PyObject *item;
  ESint32  value;

  /* get object reference. First argument*/
  item = PyTuple_GET_ITEM(args, 0);
  obj = PyInt_AsLong (item);
  item = PyTuple_GET_ITEM(args, 1);
  prop_name = PyString_AsString (item);
  item = PyTuple_GET_ITEM(args, 2);
  value = PyInt_AsLong(item);

#if 0
  edma_printf ("(ANNA-says) Setting property (sint32)'%s' "
	       "in object %ld to %ld", prop_name, obj, value);
#endif
  edma_wprop3 (obj, prop_name, value);

  return Py_BuildValue ("i", 0);
}

static PyObject *
anna_get_prop_uint32 (PyObject *self, PyObject *args)
{
  OBJID    obj;
  CLASSID  cid;
  EPChar   prop_name;
  PyObject *item;
  ESint32  value;

  /* get object reference. First argument*/
  item = PyTuple_GET_ITEM(args, 0);
  obj = PyInt_AsLong (item);
  item = PyTuple_GET_ITEM(args, 1);
  prop_name = PyString_AsString (item);

#if 0
  edma_printf ("(ANNA-says) Getting  property (sint32)'%s' "
	       "in object %ld",  prop_name, obj);
#endif

  return Py_BuildValue ("i", edma_get_prop_uint32 (obj, prop_name));

}



static PyObject*
anna_set_prop_strz (PyObject *self, PyObject *args)
{
  OBJID    obj;
  CLASSID  cid;
  EPChar   prop_name;
  PyObject *item;
  EPChar  value;

  /* get object reference. First argument*/
  item = PyTuple_GET_ITEM(args, 0);
  obj = PyInt_AsLong (item);
  item = PyTuple_GET_ITEM(args, 1);
  prop_name = PyString_AsString (item);
  item = PyTuple_GET_ITEM(args, 2);
  value = PyString_AsString(item);

#if 0
  edma_printf ("(ANNA-says) Setting property (sint32)'%s' "
	       "in object %ld to %ld", prop_name, obj, value);
#endif
  edma_wprop3 (obj, prop_name, value);

  return Py_BuildValue ("i", 0);
}

static PyObject *
anna_get_prop_strz (PyObject *self, PyObject *args)
{
  OBJID    obj;
  CLASSID  cid;
  EPChar   prop_name;
  PyObject *item;
  ESint32  value;
  EChar   str[1024]; // FIXME: Need to resize this dynamically

  /* get object reference. First argument*/
  item = PyTuple_GET_ITEM(args, 0);
  obj = PyInt_AsLong (item);
  item = PyTuple_GET_ITEM(args, 1);
  prop_name = PyString_AsString (item);

#if 0
  edma_printf ("(ANNA-says) Getting  property (sint32)'%s' "
	       "in object %ld",  prop_name, obj);
#endif
  edma_get_prop_strz (obj, prop_name, str);
  
  return PyString_FromString (str);

}



static PyObject*
anna_set_prop_real32 (PyObject *self, PyObject *args)
{
  OBJID    obj;
  CLASSID  cid;
  EPChar   prop_name;
  PyObject *item;
  EReal32  value;

  /* get object reference. First argument*/
  item = PyTuple_GET_ITEM(args, 0);
  obj = PyInt_AsLong (item);
  item = PyTuple_GET_ITEM(args, 1);
  prop_name = PyString_AsString (item);
  item = PyTuple_GET_ITEM(args, 2);
  value = (EReal32) PyFloat_AsDouble (item);

  edma_wprop3 (obj, prop_name, value);

  return Py_BuildValue ("i", 0);
}

static PyObject *
anna_get_prop_real32 (PyObject *self, PyObject *args)
{
  OBJID    obj;
  CLASSID  cid;
  EPChar   prop_name;
  PyObject *item;

  EReal32  value;

  /* get object reference. First argument*/
  item = PyTuple_GET_ITEM(args, 0);
  obj = PyInt_AsLong (item);
  item = PyTuple_GET_ITEM(args, 1);
  prop_name = PyString_AsString (item);

  edma_rprop3 (obj, prop_name, &value);
  
  return PyFloat_FromDouble ((double)value);

}




static PyMethodDef EDMAMethods[] = 
{
  {"new_obj", anna_new_obj, METH_VARARGS, "Create a new GNU/EDMA object"},
  {"free_obj", anna_free_obj, METH_VARARGS, "Destroy a new GNU/EDMA object"},
  {"met3", anna_met3, METH_VARARGS, "Run method on a GNU/EDMA object"},
  {"met3x", anna_met3x, METH_VARARGS, "Run method on a GNU/EDMA object"},
  {"get_sint32", anna_get_prop_sint32, METH_VARARGS, "Property Accessor"},
  {"set_sint32", anna_set_prop_sint32, METH_VARARGS, "Property Accessor"},
  {"get_uint32", anna_get_prop_sint32, METH_VARARGS, "Property Accessor"},
  {"set_uint32", anna_set_prop_sint32, METH_VARARGS, "Property Accessor"},
  {"get_strz", anna_get_prop_strz, METH_VARARGS, "Property Accessor"},
  {"set_strz", anna_set_prop_strz, METH_VARARGS, "Property Accessor"},
  {"get_real32", anna_get_prop_real32, METH_VARARGS, "Property Accessor"},
  {"set_real32", anna_set_prop_real32, METH_VARARGS, "Property Accessor"},

  {NULL, NULL, 0, NULL} /* End of Methods Mark*/
};



/*
***************************************************
  Method Declaration for class 
***************************************************
*/
 
ESint32 EDMAPROC 
ANNA_PYTHON_INTERPInitializerS32 (OBJID IdObj)
{
  Py_Initialize();
  (void) Py_InitModule ("edma", EDMAMethods);
  PyRun_SimpleString ("import edma");

  return  0;
}

ESint32 EDMAPROC 
ANNA_PYTHON_INTERPborn (OBJID IdObj)
{
  Py_Initialize();
  (void) Py_InitModule ("edma", EDMAMethods);
  PyRun_SimpleString ("import edma");
  return  0;
}


ESint32 EDMAPROC 
ANNA_PYTHON_INTERPFinalizerS32 (OBJID IdObj)
{
  Py_Finalize();
  return 0;
}

ESint32 EDMAPROC 
ANNA_PYTHON_INTERPrip (OBJID IdObj)
{
  Py_Finalize ();
  return 0;
}


ESint32 EDMAPROC 
ANNA_PYTHON_INTERPRun_SimpleStringZrS32 (OBJID IdObj, EPChar cmd)
{
  PyRun_SimpleString (cmd);
  return 0;
}


ESint32 EDMAPROC 
ANNA_PYTHON_INTERPRunZrS32 (OBJID IdObj, EPChar cmd)
{
  PyRun_SimpleString(cmd);
  return 0;
}


ESint32 EDMAPROC 
ANNA_PYTHON_INTERPRun_ScriptZrS32 (OBJID IdObj, EPChar file) 
{
  FILE *f;
  
  if ((f = fopen (file, "r")) == NULL)
    {
      edma_printf_obj (IdObj, "[ERROR] Can't open file %s", file);
      return -1;
    }
  PyRun_SimpleFile (f, file);
  fclose (f);
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
