/*
  Graphical EDMA ClassBrowser
  Copyright (C) 1998,1999,2002,2005,2010 David Martnez Oliveira

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* Revisions
 * ------------------------------------------------------------
 * November, 11th,2001
 * Modification for GNU EDMA 0.7.1 updates
 * Added support to show info about abstract and static methods
 * ---------------------------------------------------------------
 * November, 17th, 2001
 * Clode cleanup
 * -----------------------------------------------------------------
 * July, 20th, 2002
 * Added new list to show general class information
 * ----------------------------------------------------------------
 * 31 January 2010
 * Updated to properly manage local repositories
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <edma.h>

/* Constants */
#define COPYRIGHT "(c) David Martnez Oliveira"

/* Function prtotypes */
int  my_main  (int argc,char *argv[]);
void HandleEx (int);

/* Global vars */
static OBJID      id2 = -1;
static EUint32    crash = 0;
static GtkWidget  *prop_list = NULL;
static GtkWidget  *met_list = NULL;
static GtkWidget  *gen_list = NULL;
static CLASSID    cId=-1;


/* Callback function for main window delete event. Always allows delete. */
int 
delete_callback (GtkWidget *widget, gpointer data)
{
  return FALSE;
}

/* Callback function for main window destroy. Exits gtk_main_loop. */
void 
exit_callback (GtkWidget *widget, gpointer data)
{
  gtk_main_quit ();
}

void 
file_ok_sel (GtkWidget *w, GtkWidget *fs)
{
  g_print ("%s\n", gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  gtk_widget_destroy(fs);
}

void 
destroy (GtkWidget *widget, GtkWidget *fs)
{
  gtk_widget_destroy (fs);
}

void 
close_application( GtkWidget *widget, gpointer data )
{
  gtk_main_quit ();
}

/* Callback function for main window destroy. Exits gtk_main_loop. */
void 
install_callback (GtkWidget *widget, gpointer data)
{
  GtkWidget *filew;
  
  filew = gtk_file_selection_new ("EDMA Class Install");
  gtk_signal_connect (GTK_OBJECT (filew), "destroy",
		      (GtkSignalFunc) destroy, &filew);
  
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		      "clicked", (GtkSignalFunc) file_ok_sel, filew );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(filew)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (filew));
  
  gtk_widget_show (filew);
}


int
main (int argc, char *argv[])
{
  /* Initialize signal handler */
  signal (SIGSEGV, HandleEx);
  signal (SIGTERM, HandleEx);
  signal (SIGQUIT, HandleEx);
  signal (SIGINT,  HandleEx);
  
  /* Initialize EDMA System */
  EDMAInit ();
  
  my_main (argc, argv);

  return 0;
}


EUint32 
FillClassList (GtkWidget *list)
{
  EUint32   i, nC, cid, old_cid;
  EChar     aux[250];
  EChar     version[10];
  EChar     cversion[10];
  gchar     *row[] = {aux, version, cversion, 0};
  ESint32   v, vv, current;
  
  gtk_clist_clear (GTK_CLIST(list));  
  nC = edma_get_num_reg_classes ();
  edma_printf ("Current Number of Registered Classes is: %d", nC);
  cid = old_cid = 0;
  for (i = 0; i < nC; i++)
    {      
      cid = edma_get_next_class (old_cid);
      edma_printf ("Found class %d from base: %d", cid, old_cid);
      old_cid = cid + 1;
      if (cid < 0) break;

      edma_get_class_name (cid, aux);
      current = edma_get_class_current_version (cid);

      sprintf (version, "%d.%d", 
	       edma_get_class_major_version (cid),
	       edma_get_class_minor_version (cid));

      sprintf (cversion, "%d.%d", 
	       edma_get_class_major_version (current),
	       edma_get_class_minor_version (current)
	       );

      row[0] = strdup (aux);
      gtk_clist_append (GTK_CLIST(list), row);
    }
  
  return 0;
}

gboolean            
button_callback (GtkWidget      *widget, 
		 GdkEventKey *event,
		 gpointer     user_data) 
{
  GtkWidget   *list = (GtkWidget*) GTK_CLIST(user_data);

  edma_printf ("Key Pressed... %s", event->string);
  if (event->keyval == GDK_F5)
    FillClassList (list);
}

void 
class_click( GtkWidget *clist, gint row, gint column,
	     GdkEventButton *event, gpointer data)
{
  EPChar   text;
  EPChar   version;
  ESint32  n;
  EUint32  i, v, vv, sc, v1, v2;
  EChar    field[100], value[256];
  EChar    aux[80], name[80], type[80], access[80], array[80], *aux1;
  EChar    m_virtual[10], m_abstract[10], m_static[10];
  gchar    *prop_data[] = {name, type, access, array};
  gchar    *met_data[]  = {name, type, m_virtual, m_abstract, m_static};
  gchar    *gen_data[]  = {field, value};
  gchar    class_name[1024];
  
  //gtk_clist_get_text (GTK_CLIST(clist), row, column, &text);
  gtk_clist_get_text (GTK_CLIST(clist), row, 0, &text);

  gtk_clist_clear (GTK_CLIST(prop_list));
  gtk_clist_clear (GTK_CLIST(met_list));
  gtk_clist_clear (GTK_CLIST(gen_list));

#if 0
  if (cId != -1)
    edma_unload_class_int (cId);
#endif

  edma_printf ("Class %s selected", text);
  //cId = edma_get_class_id (text);
  gtk_clist_get_text (GTK_CLIST(clist), row, 1, &version);
  sscanf (version, "%d.%d", &v1, &v2);
  edma_printf ("Version is: '%s' (%d.%d)", version, v1, v2);
  cId = edma_get_class_id_with_version (text, v1, v2);

  if (cId < 0)
    {
      strcpy (field, "ClassName");
      strcpy (value, "Invalid Class Id");
      gtk_clist_append (GTK_CLIST(gen_list), gen_data);
      return;
    }

  edma_load_class_int (cId);

  /* Fill in General Information*/
  strcpy (field, "ClassName");
  edma_get_class_name (cId, value);
  gtk_clist_append (GTK_CLIST(gen_list), gen_data);

  strcpy (field, "NameSpace");
  edma_get_class_namespace (cId, value);
  gtk_clist_append (GTK_CLIST(gen_list), gen_data);  

  strcpy (field, "Version");
  sprintf (value, "%d.%d", 
	   edma_get_class_major_version (cId), 
	   edma_get_class_minor_version (cId));

  gtk_clist_append (GTK_CLIST(gen_list), gen_data);

  strcpy (field, "Last Version");
  printf ("Last version is: %d\n", edma_get_class_current_version (cId));
  sprintf (value, "%d.%d", 
	   edma_get_class_major_version (edma_get_class_current_version (cId)), 
	   edma_get_class_minor_version (edma_get_class_current_version (cId)));

  gtk_clist_append (GTK_CLIST(gen_list), gen_data);


  strcpy (field, "Repo Dir");


  aux1 = edma_get_class_repo_dir (cId);
  sprintf (value, "%s", aux1 == NULL ? "SYSTEM": aux1);
  gtk_clist_append (GTK_CLIST(gen_list), gen_data);

  strcpy (field, "Repo name");
  aux1 = edma_get_class_repo_name (cId);
  sprintf (value, "%s", aux1 == NULL ? "SYSTEM": aux1);
  gtk_clist_append (GTK_CLIST(gen_list), gen_data);


  strcpy (field, "Repo Type");
  sprintf (value, "%s", edma_get_class_repo_type (cId) == 0 ? 
	   "SHARED" : "LOCAL");
  gtk_clist_append (GTK_CLIST(gen_list), gen_data);


  strcpy (field, "Is IDF Parser");
  strcpy (value, edma_is_class_IDF_parser (cId) ? "YES" : "NO");
  gtk_clist_append (GTK_CLIST(gen_list), gen_data);

  strcpy (field, "Is SIU Proxy");
  strcpy (value, edma_is_class_SIU_proxy (cId) ? "YES" : "NO");
  gtk_clist_append (GTK_CLIST(gen_list), gen_data);

  strcpy (field, "Is EMI Handler");
  strcpy (value, edma_is_class_EMI_handler (cId) ? "YES" : "NO");
  gtk_clist_append (GTK_CLIST(gen_list), gen_data);

  strcpy (field, "SuperClasses");
  strcpy (value, "");
  n = edma_get_class_num_superclasses (cId);
  if (n >= 0)
    {
      for (i = 0; i < n; i++)
	{
	  printf ("%d: '%s'\n", i, value);
	  sc = edma_get_class_superclass (cId, i);
	  if (edma_get_class_name (sc, name) >=0 )
	    {
	      strcat (value, name);
	      strcat (value, ",");
	    }
	}
      gtk_clist_append (GTK_CLIST(gen_list), gen_data);
    }

  /* First read properties */
  n = edma_get_prop_num (cId);
  for (i = 0; i < n; i++) 
    {
      edma_get_prop_name (cId, i, name);
      edma_get_prop_type (cId,i,type);

      /* FIXME: We must read the real value.*/
      strcpy (access, "READ/WRITE");
      sprintf (array, "%d", edma_get_prop_num_elements (cId, i));
      gtk_clist_append (GTK_CLIST(prop_list), prop_data);
    }

  /*Then read methods */
  n = edma_get_met_num (cId);
  for (i = 0; i < n; i++) {
    edma_get_met_name (cId, i, name);
    edma_get_met_sig (cId, i, type);

    sprintf (m_virtual," %s", edma_is_met_virtual (cId, i) ? "YES" : " ");
    sprintf (m_abstract," %s",edma_is_met_abstract (cId, i) ? "YES" : " ");
    sprintf (m_static," %s", edma_is_met_static (cId, i) ? "YES" : " ");
    gtk_clist_append (GTK_CLIST(met_list), met_data);
  }
}

/*
 * This code'll be eventually moved to the main function
 * It was introducced here in an old version that worked with
 * guile, so it needed a new stack frame for the guile interpreter
*/
int 
my_main(int argc,char *argv[])
{
  EUint32   i;
  GtkWidget *app;
  GtkWidget *swindow,*swindow1,*swindow2, *swindow3;
  GtkWidget *window;
  GtkWidget *hpan;
  GtkWidget *vpan;
  GtkWidget *vpan1;
  GtkWidget *gen_box;
  GtkWidget *prop_box;
  GtkWidget *met_box;
  GtkWidget *class_list;
  GtkWidget *label1,*label2, *label3;


   gtk_init (&argc, &argv);
   app = gtk_window_new (GTK_WINDOW_TOPLEVEL);

   /* Connect window signals */
   gtk_signal_connect (GTK_OBJECT (app), "delete_event",
		       GTK_SIGNAL_FUNC (delete_callback), NULL);
   gtk_signal_connect (GTK_OBJECT (app), "destroy",
		       GTK_SIGNAL_FUNC (exit_callback), NULL);  


   
   window = gtk_vbox_new (FALSE, FALSE);   

   /* Scroll window for class list*/
   swindow = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swindow),
				   GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

   /* Scroll window for property list */
   swindow1 = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swindow1),
				   GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

   /* Scroll window for method list */
   swindow2 = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swindow2),
				   GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

   /* Scroll window for general class information list */
   swindow3 = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swindow3),
				   GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

   gtk_container_add (GTK_CONTAINER(app), window);
   /* Add horizontal panning */
   hpan = gtk_hpaned_new ();
   gtk_container_add (GTK_CONTAINER(window), hpan);

   /* Setup left side */
   class_list = gtk_clist_new (3);
   gtk_signal_connect (GTK_OBJECT (window), "key-press-event",
		       GTK_SIGNAL_FUNC (button_callback), class_list); 

   gtk_widget_set_usize (class_list, 250, 300);
   gtk_clist_set_column_title (GTK_CLIST(class_list), 0, "Class Name");
   gtk_clist_set_column_width (GTK_CLIST(class_list), 0, 150);
   gtk_clist_set_column_title (GTK_CLIST(class_list), 1, "Ver");
   gtk_clist_set_column_title (GTK_CLIST(class_list), 2, "Last Ver");
   gtk_clist_column_titles_show (GTK_CLIST(class_list));
   gtk_paned_add1 (GTK_PANED(hpan), swindow);
   gtk_container_add (GTK_CONTAINER(swindow), class_list);

   /* and now right side */
   vpan1 = gtk_vpaned_new ();
   gtk_paned_add2 (GTK_PANED(hpan), vpan1);
   gen_box = gtk_vbox_new (FALSE, 0);

   gtk_paned_add1 (GTK_PANED(vpan1), gen_box);
   gen_list = gtk_clist_new (2);
   gtk_widget_set_usize (gen_list, 300, 100);

   label3 = gtk_label_new ("General Info");
   gtk_clist_set_column_title (GTK_CLIST(gen_list), 0, "Field");
   gtk_clist_set_column_width (GTK_CLIST(gen_list), 0, 100);
   gtk_clist_set_column_title (GTK_CLIST(gen_list), 1, "Value");
   gtk_clist_set_column_width (GTK_CLIST(gen_list), 1, 60);
   gtk_clist_column_titles_show (GTK_CLIST(gen_list));
   gtk_box_pack_start (GTK_BOX(gen_box), label3, FALSE, FALSE, 2);
   gtk_box_pack_start (GTK_BOX(gen_box), swindow3, TRUE, TRUE, 2);
   gtk_container_add (GTK_CONTAINER(swindow3), gen_list);

   vpan = gtk_vpaned_new ();
   gtk_paned_add2 (GTK_PANED(vpan1), vpan);

   prop_box = gtk_vbox_new(FALSE, 0);
   met_box  = gtk_vbox_new(FALSE, 0);
   gtk_paned_add1 (GTK_PANED(vpan), prop_box);
   gtk_paned_add2 (GTK_PANED(vpan), met_box);

   label1 = gtk_label_new ("Property List");

   prop_list = gtk_clist_new (4);
   gtk_widget_set_usize (prop_list, 300, 100);

   gtk_clist_set_column_title (GTK_CLIST(prop_list), 0, "Name");
   gtk_clist_set_column_width (GTK_CLIST(prop_list), 0, 100);
   gtk_clist_set_column_title (GTK_CLIST(prop_list), 1, "Type");
   gtk_clist_set_column_width (GTK_CLIST(prop_list), 1, 60);
   gtk_clist_set_column_title (GTK_CLIST(prop_list), 2, "Access");
   gtk_clist_set_column_width (GTK_CLIST(prop_list), 2, 100);
   gtk_clist_set_column_title (GTK_CLIST(prop_list), 3, "Array");
   gtk_clist_set_column_width (GTK_CLIST(prop_list), 3, 20);
   gtk_clist_column_titles_show (GTK_CLIST(prop_list));
   gtk_box_pack_start (GTK_BOX(prop_box), label1, FALSE, FALSE, 2);
   gtk_box_pack_start (GTK_BOX(prop_box), swindow1, TRUE, TRUE, 2);
   gtk_container_add (GTK_CONTAINER(swindow1), prop_list);

   label2 = gtk_label_new ("Method List");

   met_list = gtk_clist_new (5);
   gtk_widget_set_usize (met_list, 400, 100);

   gtk_clist_set_column_title (GTK_CLIST(met_list), 0, "Name");
   gtk_clist_set_column_width (GTK_CLIST(met_list), 0, 100);
   gtk_clist_set_column_title (GTK_CLIST(met_list), 1, "Signature");
   gtk_clist_set_column_width (GTK_CLIST(met_list), 1, 100);
   gtk_clist_set_column_title (GTK_CLIST(met_list), 2, "Virtual");
   gtk_clist_set_column_width (GTK_CLIST(met_list), 2, 40);
   gtk_clist_set_column_title (GTK_CLIST(met_list), 3, "Abstract");
   gtk_clist_set_column_width (GTK_CLIST(met_list), 3, 60);
   gtk_clist_set_column_title (GTK_CLIST(met_list), 4, "Static");
   gtk_clist_set_column_width (GTK_CLIST(met_list), 4, 40);

   gtk_clist_column_titles_show (GTK_CLIST(met_list));
   gtk_box_pack_start (GTK_BOX(met_box), label2, FALSE, FALSE, 2);
   gtk_box_pack_start (GTK_BOX(met_box), swindow2, TRUE, TRUE, 2);
   gtk_container_add (GTK_CONTAINER(swindow2), met_list);

   FillClassList (class_list);

   gtk_signal_connect (GTK_OBJECT (class_list), "select_row",
		       GTK_SIGNAL_FUNC (class_click), NULL);

   gtk_container_add (GTK_CONTAINER(swindow1), prop_box);

   gtk_widget_show (vpan1);
   gtk_widget_show (gen_box);
   gtk_widget_show (gen_list);
   gtk_widget_show (label3);
   gtk_widget_show (vpan);
   gtk_widget_show (prop_box);
   gtk_widget_show (met_box);
   gtk_widget_show (prop_list);
   gtk_widget_show (label1);
   gtk_widget_show (met_list);
   gtk_widget_show (label2);
   gtk_widget_show (swindow1);
   gtk_widget_show (swindow2);   
   gtk_widget_show (swindow3);   
   gtk_widget_show (hpan);
   gtk_widget_show (swindow);
   gtk_widget_show (class_list);
   gtk_widget_show (window);
   gtk_widget_show (app);

   gtk_main ();
   printf ("\nAll Done!!");
   EDMAEnd ();
   printf ("\nEDMA unloaded\n");
   return 0;
}

/* Exception handler */
void 
HandleEx (int s)
{
  if (crash)
    {
      printf ("\nException received while shutdown");
      exit(1);
    }
  else
    {
      crash = 1;
      printf ("\n Signal recived: %d", s);
      printf ("\n%s", strsignal(s));
      printf ("\n EDMA abrupt shutdown required");
      EDMAEnd ();
      exit (1);
    }
}
