set -e

if [ "$#" != "4" ] ; then
	echo "postproc.sh {lo,hi} <filename> <scenename> <framenumber>"
	exit 10
fi

echo
echo "postproc.sh | $1 | $2 | $3 | $4 |"

case "$1" in
	big)
		CATFILE="cat $2"
		;;
	qu*)
		CATFILE="cat $2"
		;;
	lo*)
		CATFILE="cat $2"
		;;
	hi*)
		CATFILE="pnmscale 0.5 $2"
		;;
	*) 	echo "unknown quality identifier '$1'"
		exit 1
esac

PART=$(( (($4 - 1) % 3)+1 ))
RUN=$(( ($4 - 1) / 3))

echo "guessing part $PART of run $RUN"

case "$3" in
    *Special*)
	case "$RUN" in
	0) NAME=L  ; EPMCUT="pnmcut 0 24 64 66";;
	1) NAME=L1 ; EPMCUT="pnmcut 0 24 64 66";;
	2) NAME=L2 ; EPMCUT="pnmcut 0 24 64 66";;
	3) NAME=W  ; EPMCUT="pnmcut 0 12 64 78";;
	4) NAME=W2 ; EPMCUT="pnmcut 0 12 64 78";;
	5) NAME=W3 ; EPMCUT="pnmcut 0 18 64 72";;
	6) NAME=DD ; EPMCUT="pnmcut 0 24 64 72";;
	7) NAME=DL ; EPMCUT="pnmcut 0 36 64 60";;
	8) NAME=DU ; EPMCUT="pnmcut 0 42 64 48";;
	9) NAME=DR ; EPMCUT="pnmcut 0 36 64 60";;
	esac
	;;
    *Animation*)
	case $(( $RUN / 5 )) in
	0) NAME=D ; EPMCUT="pnmcut 0 18 64 78";;
	1) NAME=L ; EPMCUT="pnmcut 0 24 64 72";;
	2) NAME=U ; EPMCUT="pnmcut 0 24 64 66";;
	3) NAME=R ; EPMCUT="pnmcut 0 24 64 66";;
	esac
	case $(( $RUN % 5 )) in
	0) NAME=${NAME}_S ;;
	1) NAME=${NAME}_0 ;;
	2) NAME=${NAME}_1 ;;
	3) NAME=${NAME}_2 ;;
	4) NAME=${NAME}_3 ;;
	esac
	;;
    *Winner*)
    	NAME=B ; EPMCUT="pnmcut 0 30 128 152"
	;;
    *) echo "Unknown scene name!" >&2
    	;;
esac

echo "$CATFILE | $EPMCUT |gzip > ${DESTNAME}_${NAME}_${PART}.ppm.gz"
$CATFILE | $EPMCUT |gzip > ${DESTNAME}_${NAME}_${PART}.ppm.gz && rm $2

