/* Copyright (C) 2020 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// This file is generated by generate-gpup-webgl. Do not edit.
// This file should be included in the private section of the
// RemoteGraphicsContextGL implementations.
#pragma once
    void activeTexture(uint32_t texture)
    {
        assertIsCurrent(workQueue());
        m_context->activeTexture(texture);
    }
    void attachShader(uint32_t program, uint32_t shader)
    {
        assertIsCurrent(workQueue());
        m_context->attachShader(program, shader);
    }
    void bindAttribLocation(uint32_t arg0, uint32_t index, String&& name)
    {
        assertIsCurrent(workQueue());
        m_context->bindAttribLocation(arg0, index, name);
    }
    void bindBuffer(uint32_t target, uint32_t arg1)
    {
        assertIsCurrent(workQueue());
        m_context->bindBuffer(target, arg1);
    }
    void bindFramebuffer(uint32_t target, uint32_t arg1)
    {
        assertIsCurrent(workQueue());
        m_context->bindFramebuffer(target, arg1);
    }
    void bindRenderbuffer(uint32_t target, uint32_t arg1)
    {
        assertIsCurrent(workQueue());
        m_context->bindRenderbuffer(target, arg1);
    }
    void bindTexture(uint32_t target, uint32_t arg1)
    {
        assertIsCurrent(workQueue());
        m_context->bindTexture(target, arg1);
    }
    void blendColor(float red, float green, float blue, float alpha)
    {
        assertIsCurrent(workQueue());
        m_context->blendColor(red, green, blue, alpha);
    }
    void blendEquation(uint32_t mode)
    {
        assertIsCurrent(workQueue());
        m_context->blendEquation(mode);
    }
    void blendEquationSeparate(uint32_t modeRGB, uint32_t modeAlpha)
    {
        assertIsCurrent(workQueue());
        m_context->blendEquationSeparate(modeRGB, modeAlpha);
    }
    void blendFunc(uint32_t sfactor, uint32_t dfactor)
    {
        assertIsCurrent(workQueue());
        m_context->blendFunc(sfactor, dfactor);
    }
    void blendFuncSeparate(uint32_t srcRGB, uint32_t dstRGB, uint32_t srcAlpha, uint32_t dstAlpha)
    {
        assertIsCurrent(workQueue());
        m_context->blendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
    }
    void checkFramebufferStatus(uint32_t target, CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        GCGLenum returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->checkFramebufferStatus(target);
        completionHandler(returnValue);
    }
    void clear(uint32_t mask)
    {
        assertIsCurrent(workQueue());
        m_context->clear(mask);
    }
    void clearColor(float red, float green, float blue, float alpha)
    {
        assertIsCurrent(workQueue());
        m_context->clearColor(red, green, blue, alpha);
    }
    void clearDepth(float depth)
    {
        assertIsCurrent(workQueue());
        m_context->clearDepth(depth);
    }
    void clearStencil(int32_t s)
    {
        assertIsCurrent(workQueue());
        m_context->clearStencil(s);
    }
    void colorMask(bool red, bool green, bool blue, bool alpha)
    {
        assertIsCurrent(workQueue());
        m_context->colorMask(static_cast<GCGLboolean>(red), static_cast<GCGLboolean>(green), static_cast<GCGLboolean>(blue), static_cast<GCGLboolean>(alpha));
    }
    void compileShader(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->compileShader(arg0);
    }
    void copyTexImage2D(uint32_t target, int32_t level, uint32_t internalformat, int32_t x, int32_t y, int32_t width, int32_t height, int32_t border)
    {
        assertIsCurrent(workQueue());
        m_context->copyTexImage2D(target, level, internalformat, x, y, width, height, border);
    }
    void copyTexSubImage2D(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t x, int32_t y, int32_t width, int32_t height)
    {
        assertIsCurrent(workQueue());
        m_context->copyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    }
    void createBuffer(CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createBuffer();
        completionHandler(returnValue);
    }
    void createFramebuffer(CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createFramebuffer();
        completionHandler(returnValue);
    }
    void createProgram(CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createProgram();
        completionHandler(returnValue);
    }
    void createRenderbuffer(CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createRenderbuffer();
        completionHandler(returnValue);
    }
    void createShader(uint32_t arg0, CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createShader(arg0);
        completionHandler(returnValue);
    }
    void createTexture(CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createTexture();
        completionHandler(returnValue);
    }
    void cullFace(uint32_t mode)
    {
        assertIsCurrent(workQueue());
        m_context->cullFace(mode);
    }
    void deleteBuffer(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->deleteBuffer(arg0);
    }
    void deleteFramebuffer(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->deleteFramebuffer(arg0);
    }
    void deleteProgram(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->deleteProgram(arg0);
    }
    void deleteRenderbuffer(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->deleteRenderbuffer(arg0);
    }
    void deleteShader(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->deleteShader(arg0);
    }
    void deleteTexture(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->deleteTexture(arg0);
    }
    void depthFunc(uint32_t func)
    {
        assertIsCurrent(workQueue());
        m_context->depthFunc(func);
    }
    void depthMask(bool flag)
    {
        assertIsCurrent(workQueue());
        m_context->depthMask(static_cast<GCGLboolean>(flag));
    }
    void depthRange(float zNear, float zFar)
    {
        assertIsCurrent(workQueue());
        m_context->depthRange(zNear, zFar);
    }
    void destroyEGLImage(uint64_t handle)
    {
        assertIsCurrent(workQueue());
        m_context->destroyEGLImage(reinterpret_cast<GCEGLImage>(static_cast<intptr_t>(handle)));
    }
    void detachShader(uint32_t arg0, uint32_t arg1)
    {
        assertIsCurrent(workQueue());
        m_context->detachShader(arg0, arg1);
    }
    void disable(uint32_t cap)
    {
        assertIsCurrent(workQueue());
        m_context->disable(cap);
    }
    void disableVertexAttribArray(uint32_t index)
    {
        assertIsCurrent(workQueue());
        m_context->disableVertexAttribArray(index);
    }
    void drawArrays(uint32_t mode, int32_t first, int32_t count)
    {
        assertIsCurrent(workQueue());
        m_context->drawArrays(mode, first, count);
    }
    void drawElements(uint32_t mode, int32_t count, uint32_t type, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->drawElements(mode, count, type, static_cast<GCGLintptr>(offset));
    }
    void enable(uint32_t cap)
    {
        assertIsCurrent(workQueue());
        m_context->enable(cap);
    }
    void enableVertexAttribArray(uint32_t index)
    {
        assertIsCurrent(workQueue());
        m_context->enableVertexAttribArray(index);
    }
    void finish()
    {
        assertIsCurrent(workQueue());
        m_context->finish();
    }
    void flush()
    {
        assertIsCurrent(workQueue());
        m_context->flush();
    }
    void framebufferRenderbuffer(uint32_t target, uint32_t attachment, uint32_t renderbuffertarget, uint32_t arg3)
    {
        assertIsCurrent(workQueue());
        m_context->framebufferRenderbuffer(target, attachment, renderbuffertarget, arg3);
    }
    void framebufferTexture2D(uint32_t target, uint32_t attachment, uint32_t textarget, uint32_t arg3, int32_t level)
    {
        assertIsCurrent(workQueue());
        m_context->framebufferTexture2D(target, attachment, textarget, arg3, level);
    }
    void frontFace(uint32_t mode)
    {
        assertIsCurrent(workQueue());
        m_context->frontFace(mode);
    }
    void generateMipmap(uint32_t target)
    {
        assertIsCurrent(workQueue());
        m_context->generateMipmap(target);
    }
    void getActiveAttrib(uint32_t program, uint32_t index, CompletionHandler<void(bool, struct WebCore::GraphicsContextGLActiveInfo&&)>&& completionHandler)
    {
        bool returnValue = { };
        struct WebCore::GraphicsContextGLActiveInfo arg2 { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getActiveAttrib(program, index, arg2);
        completionHandler(returnValue, WTFMove(arg2));
    }
    void getActiveUniform(uint32_t program, uint32_t index, CompletionHandler<void(bool, struct WebCore::GraphicsContextGLActiveInfo&&)>&& completionHandler)
    {
        bool returnValue = { };
        struct WebCore::GraphicsContextGLActiveInfo arg2 { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getActiveUniform(program, index, arg2);
        completionHandler(returnValue, WTFMove(arg2));
    }
    void getAttribLocation(uint32_t arg0, String&& name, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getAttribLocation(arg0, name);
        completionHandler(returnValue);
    }
    void getBufferParameteri(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getBufferParameteri(target, pname);
        completionHandler(returnValue);
    }
    void getString(uint32_t name, CompletionHandler<void(String&&)>&& completionHandler)
    {
        String returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getString(name);
        completionHandler(WTFMove(returnValue));
    }
    void getFloatv(uint32_t pname, size_t valueSize, CompletionHandler<void(IPC::ArrayReference<float>)>&& completionHandler)
    {
        Vector<GCGLfloat, 16> value(valueSize, 0);
        assertIsCurrent(workQueue());
        m_context->getFloatv(pname, value);
        completionHandler(IPC::ArrayReference<float>(reinterpret_cast<float*>(value.data()), value.size()));
    }
    void getIntegerv(uint32_t pname, size_t valueSize, CompletionHandler<void(IPC::ArrayReference<int32_t>)>&& completionHandler)
    {
        Vector<GCGLint, 4> value(valueSize, 0);
        assertIsCurrent(workQueue());
        m_context->getIntegerv(pname, value);
        completionHandler(IPC::ArrayReference<int32_t>(reinterpret_cast<int32_t*>(value.data()), value.size()));
    }
    void getIntegeri_v(uint32_t pname, uint32_t index, CompletionHandler<void(IPC::ArrayReference<int32_t, 4>)>&& completionHandler) // NOLINT
    {
        std::array<GCGLint, 4> value { };
        assertIsCurrent(workQueue());
        m_context->getIntegeri_v(pname, index, value);
        completionHandler(IPC::ArrayReference<int32_t, 4>(reinterpret_cast<int32_t*>(value.data()), value.size()));
    }
    void getInteger64(uint32_t pname, CompletionHandler<void(int64_t)>&& completionHandler)
    {
        GCGLint64 returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getInteger64(pname);
        completionHandler(static_cast<int64_t>(returnValue));
    }
    void getInteger64i(uint32_t pname, uint32_t index, CompletionHandler<void(int64_t)>&& completionHandler)
    {
        GCGLint64 returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getInteger64i(pname, index);
        completionHandler(static_cast<int64_t>(returnValue));
    }
    void getProgrami(uint32_t program, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getProgrami(program, pname);
        completionHandler(returnValue);
    }
    void getBooleanv(uint32_t pname, size_t valueSize, CompletionHandler<void(IPC::ArrayReference<bool>)>&& completionHandler)
    {
        Vector<GCGLboolean, 4> value(valueSize, 0);
        assertIsCurrent(workQueue());
        m_context->getBooleanv(pname, value);
        completionHandler(IPC::ArrayReference<bool>(reinterpret_cast<bool*>(value.data()), value.size()));
    }
    void getFramebufferAttachmentParameteri(uint32_t target, uint32_t attachment, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getFramebufferAttachmentParameteri(target, attachment, pname);
        completionHandler(returnValue);
    }
    void getProgramInfoLog(uint32_t arg0, CompletionHandler<void(String&&)>&& completionHandler)
    {
        String returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getProgramInfoLog(arg0);
        completionHandler(WTFMove(returnValue));
    }
    void getRenderbufferParameteri(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getRenderbufferParameteri(target, pname);
        completionHandler(returnValue);
    }
    void getShaderi(uint32_t arg0, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getShaderi(arg0, pname);
        completionHandler(returnValue);
    }
    void getShaderInfoLog(uint32_t arg0, CompletionHandler<void(String&&)>&& completionHandler)
    {
        String returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getShaderInfoLog(arg0);
        completionHandler(WTFMove(returnValue));
    }
    void getShaderPrecisionFormat(uint32_t shaderType, uint32_t precisionType, CompletionHandler<void(IPC::ArrayReference<int32_t, 2>, int32_t)>&& completionHandler)
    {
        std::array<GCGLint, 2> range { };
        GCGLint precision = { };
        assertIsCurrent(workQueue());
        m_context->getShaderPrecisionFormat(shaderType, precisionType, range, &precision);
        completionHandler(IPC::ArrayReference<int32_t, 2>(reinterpret_cast<int32_t*>(range.data()), range.size()), precision);
    }
    void getShaderSource(uint32_t arg0, CompletionHandler<void(String&&)>&& completionHandler)
    {
        String returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getShaderSource(arg0);
        completionHandler(WTFMove(returnValue));
    }
    void getTexParameterf(uint32_t target, uint32_t pname, CompletionHandler<void(float)>&& completionHandler)
    {
        GCGLfloat returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getTexParameterf(target, pname);
        completionHandler(returnValue);
    }
    void getTexParameteri(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getTexParameteri(target, pname);
        completionHandler(returnValue);
    }
    void getUniformfv(uint32_t program, int32_t location, size_t valueSize, CompletionHandler<void(IPC::ArrayReference<float>)>&& completionHandler)
    {
        Vector<GCGLfloat, 16> value(valueSize, 0);
        assertIsCurrent(workQueue());
        m_context->getUniformfv(program, location, value);
        completionHandler(IPC::ArrayReference<float>(reinterpret_cast<float*>(value.data()), value.size()));
    }
    void getUniformiv(uint32_t program, int32_t location, size_t valueSize, CompletionHandler<void(IPC::ArrayReference<int32_t>)>&& completionHandler)
    {
        Vector<GCGLint, 4> value(valueSize, 0);
        assertIsCurrent(workQueue());
        m_context->getUniformiv(program, location, value);
        completionHandler(IPC::ArrayReference<int32_t>(reinterpret_cast<int32_t*>(value.data()), value.size()));
    }
    void getUniformuiv(uint32_t program, int32_t location, size_t valueSize, CompletionHandler<void(IPC::ArrayReference<uint32_t>)>&& completionHandler)
    {
        Vector<GCGLuint, 4> value(valueSize, 0);
        assertIsCurrent(workQueue());
        m_context->getUniformuiv(program, location, value);
        completionHandler(IPC::ArrayReference<uint32_t>(reinterpret_cast<uint32_t*>(value.data()), value.size()));
    }
    void getUniformLocation(uint32_t arg0, String&& name, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getUniformLocation(arg0, name);
        completionHandler(returnValue);
    }
    void getVertexAttribOffset(uint32_t index, uint32_t pname, CompletionHandler<void(uint64_t)>&& completionHandler)
    {
        GCGLsizeiptr returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getVertexAttribOffset(index, pname);
        completionHandler(static_cast<uint64_t>(returnValue));
    }
    void hint(uint32_t target, uint32_t mode)
    {
        assertIsCurrent(workQueue());
        m_context->hint(target, mode);
    }
    void isBuffer(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isBuffer(arg0);
        completionHandler(static_cast<bool>(returnValue));
    }
    void isEnabled(uint32_t cap, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isEnabled(cap);
        completionHandler(static_cast<bool>(returnValue));
    }
    void isFramebuffer(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isFramebuffer(arg0);
        completionHandler(static_cast<bool>(returnValue));
    }
    void isProgram(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isProgram(arg0);
        completionHandler(static_cast<bool>(returnValue));
    }
    void isRenderbuffer(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isRenderbuffer(arg0);
        completionHandler(static_cast<bool>(returnValue));
    }
    void isShader(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isShader(arg0);
        completionHandler(static_cast<bool>(returnValue));
    }
    void isTexture(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isTexture(arg0);
        completionHandler(static_cast<bool>(returnValue));
    }
    void lineWidth(float arg0)
    {
        assertIsCurrent(workQueue());
        m_context->lineWidth(arg0);
    }
    void linkProgram(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->linkProgram(arg0);
    }
    void pixelStorei(uint32_t pname, int32_t param)
    {
        assertIsCurrent(workQueue());
        m_context->pixelStorei(pname, param);
    }
    void polygonOffset(float factor, float units)
    {
        assertIsCurrent(workQueue());
        m_context->polygonOffset(factor, units);
    }
    void renderbufferStorage(uint32_t target, uint32_t internalformat, int32_t width, int32_t height)
    {
        assertIsCurrent(workQueue());
        m_context->renderbufferStorage(target, internalformat, width, height);
    }
    void sampleCoverage(float value, bool invert)
    {
        assertIsCurrent(workQueue());
        m_context->sampleCoverage(value, static_cast<GCGLboolean>(invert));
    }
    void scissor(int32_t x, int32_t y, int32_t width, int32_t height)
    {
        assertIsCurrent(workQueue());
        m_context->scissor(x, y, width, height);
    }
    void shaderSource(uint32_t arg0, String&& arg1)
    {
        assertIsCurrent(workQueue());
        m_context->shaderSource(arg0, arg1);
    }
    void stencilFunc(uint32_t func, int32_t ref, uint32_t mask)
    {
        assertIsCurrent(workQueue());
        m_context->stencilFunc(func, ref, mask);
    }
    void stencilFuncSeparate(uint32_t face, uint32_t func, int32_t ref, uint32_t mask)
    {
        assertIsCurrent(workQueue());
        m_context->stencilFuncSeparate(face, func, ref, mask);
    }
    void stencilMask(uint32_t mask)
    {
        assertIsCurrent(workQueue());
        m_context->stencilMask(mask);
    }
    void stencilMaskSeparate(uint32_t face, uint32_t mask)
    {
        assertIsCurrent(workQueue());
        m_context->stencilMaskSeparate(face, mask);
    }
    void stencilOp(uint32_t fail, uint32_t zfail, uint32_t zpass)
    {
        assertIsCurrent(workQueue());
        m_context->stencilOp(fail, zfail, zpass);
    }
    void stencilOpSeparate(uint32_t face, uint32_t fail, uint32_t zfail, uint32_t zpass)
    {
        assertIsCurrent(workQueue());
        m_context->stencilOpSeparate(face, fail, zfail, zpass);
    }
    void texParameterf(uint32_t target, uint32_t pname, float param)
    {
        assertIsCurrent(workQueue());
        m_context->texParameterf(target, pname, param);
    }
    void texParameteri(uint32_t target, uint32_t pname, int32_t param)
    {
        assertIsCurrent(workQueue());
        m_context->texParameteri(target, pname, param);
    }
    void uniform1f(int32_t location, float x)
    {
        assertIsCurrent(workQueue());
        m_context->uniform1f(location, x);
    }
    void uniform1fv(int32_t location, IPC::ArrayReference<float>&& v)
    {
        assertIsCurrent(workQueue());
        m_context->uniform1fv(location, std::span(reinterpret_cast<const GCGLfloat*>(v.data()), v.size()));
    }
    void uniform1i(int32_t location, int32_t x)
    {
        assertIsCurrent(workQueue());
        m_context->uniform1i(location, x);
    }
    void uniform1iv(int32_t location, IPC::ArrayReference<int32_t>&& v)
    {
        assertIsCurrent(workQueue());
        m_context->uniform1iv(location, std::span(reinterpret_cast<const GCGLint*>(v.data()), v.size()));
    }
    void uniform2f(int32_t location, float x, float y)
    {
        assertIsCurrent(workQueue());
        m_context->uniform2f(location, x, y);
    }
    void uniform2fv(int32_t location, IPC::ArrayReference<float>&& v)
    {
        assertIsCurrent(workQueue());
        m_context->uniform2fv(location, std::span(reinterpret_cast<const GCGLfloat*>(v.data()), v.size()));
    }
    void uniform2i(int32_t location, int32_t x, int32_t y)
    {
        assertIsCurrent(workQueue());
        m_context->uniform2i(location, x, y);
    }
    void uniform2iv(int32_t location, IPC::ArrayReference<int32_t>&& v)
    {
        assertIsCurrent(workQueue());
        m_context->uniform2iv(location, std::span(reinterpret_cast<const GCGLint*>(v.data()), v.size()));
    }
    void uniform3f(int32_t location, float x, float y, float z)
    {
        assertIsCurrent(workQueue());
        m_context->uniform3f(location, x, y, z);
    }
    void uniform3fv(int32_t location, IPC::ArrayReference<float>&& v)
    {
        assertIsCurrent(workQueue());
        m_context->uniform3fv(location, std::span(reinterpret_cast<const GCGLfloat*>(v.data()), v.size()));
    }
    void uniform3i(int32_t location, int32_t x, int32_t y, int32_t z)
    {
        assertIsCurrent(workQueue());
        m_context->uniform3i(location, x, y, z);
    }
    void uniform3iv(int32_t location, IPC::ArrayReference<int32_t>&& v)
    {
        assertIsCurrent(workQueue());
        m_context->uniform3iv(location, std::span(reinterpret_cast<const GCGLint*>(v.data()), v.size()));
    }
    void uniform4f(int32_t location, float x, float y, float z, float w)
    {
        assertIsCurrent(workQueue());
        m_context->uniform4f(location, x, y, z, w);
    }
    void uniform4fv(int32_t location, IPC::ArrayReference<float>&& v)
    {
        assertIsCurrent(workQueue());
        m_context->uniform4fv(location, std::span(reinterpret_cast<const GCGLfloat*>(v.data()), v.size()));
    }
    void uniform4i(int32_t location, int32_t x, int32_t y, int32_t z, int32_t w)
    {
        assertIsCurrent(workQueue());
        m_context->uniform4i(location, x, y, z, w);
    }
    void uniform4iv(int32_t location, IPC::ArrayReference<int32_t>&& v)
    {
        assertIsCurrent(workQueue());
        m_context->uniform4iv(location, std::span(reinterpret_cast<const GCGLint*>(v.data()), v.size()));
    }
    void uniformMatrix2fv(int32_t location, bool transpose, IPC::ArrayReference<float>&& value)
    {
        assertIsCurrent(workQueue());
        m_context->uniformMatrix2fv(location, static_cast<GCGLboolean>(transpose), std::span(reinterpret_cast<const GCGLfloat*>(value.data()), value.size()));
    }
    void uniformMatrix3fv(int32_t location, bool transpose, IPC::ArrayReference<float>&& value)
    {
        assertIsCurrent(workQueue());
        m_context->uniformMatrix3fv(location, static_cast<GCGLboolean>(transpose), std::span(reinterpret_cast<const GCGLfloat*>(value.data()), value.size()));
    }
    void uniformMatrix4fv(int32_t location, bool transpose, IPC::ArrayReference<float>&& value)
    {
        assertIsCurrent(workQueue());
        m_context->uniformMatrix4fv(location, static_cast<GCGLboolean>(transpose), std::span(reinterpret_cast<const GCGLfloat*>(value.data()), value.size()));
    }
    void useProgram(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->useProgram(arg0);
    }
    void validateProgram(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->validateProgram(arg0);
    }
    void vertexAttrib1f(uint32_t index, float x)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttrib1f(index, x);
    }
    void vertexAttrib1fv(uint32_t index, IPC::ArrayReference<float, 1>&& values)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttrib1fv(index, std::span<const GCGLfloat, 1> { reinterpret_cast<const GCGLfloat*>(values.data()), 1 });
    }
    void vertexAttrib2f(uint32_t index, float x, float y)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttrib2f(index, x, y);
    }
    void vertexAttrib2fv(uint32_t index, IPC::ArrayReference<float, 2>&& values)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttrib2fv(index, std::span<const GCGLfloat, 2> { reinterpret_cast<const GCGLfloat*>(values.data()), 2 });
    }
    void vertexAttrib3f(uint32_t index, float x, float y, float z)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttrib3f(index, x, y, z);
    }
    void vertexAttrib3fv(uint32_t index, IPC::ArrayReference<float, 3>&& values)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttrib3fv(index, std::span<const GCGLfloat, 3> { reinterpret_cast<const GCGLfloat*>(values.data()), 3 });
    }
    void vertexAttrib4f(uint32_t index, float x, float y, float z, float w)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttrib4f(index, x, y, z, w);
    }
    void vertexAttrib4fv(uint32_t index, IPC::ArrayReference<float, 4>&& values)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttrib4fv(index, std::span<const GCGLfloat, 4> { reinterpret_cast<const GCGLfloat*>(values.data()), 4 });
    }
    void vertexAttribPointer(uint32_t index, int32_t size, uint32_t type, bool normalized, int32_t stride, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttribPointer(index, size, type, static_cast<GCGLboolean>(normalized), stride, static_cast<GCGLintptr>(offset));
    }
    void viewport(int32_t x, int32_t y, int32_t width, int32_t height)
    {
        assertIsCurrent(workQueue());
        m_context->viewport(x, y, width, height);
    }
    void bufferData0(uint32_t target, uint64_t arg1, uint32_t usage)
    {
        assertIsCurrent(workQueue());
        m_context->bufferData(target, static_cast<GCGLsizeiptr>(arg1), usage);
    }
    void bufferData1(uint32_t target, IPC::ArrayReference<uint8_t>&& data, uint32_t usage)
    {
        assertIsCurrent(workQueue());
        m_context->bufferData(target, std::span(reinterpret_cast<const uint8_t*>(data.data()), data.size()), usage);
    }
    void bufferSubData(uint32_t target, uint64_t offset, IPC::ArrayReference<uint8_t>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->bufferSubData(target, static_cast<GCGLintptr>(offset), std::span(reinterpret_cast<const uint8_t*>(data.data()), data.size()));
    }
    void readPixelsBufferObject(WebCore::IntRect&& arg0, uint32_t format, uint32_t type, uint64_t offset, int32_t alignment, int32_t rowLength)
    {
        assertIsCurrent(workQueue());
        m_context->readPixelsBufferObject(arg0, format, type, static_cast<GCGLintptr>(offset), alignment, rowLength);
    }
    void texImage2D0(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, uint32_t format, uint32_t type, IPC::ArrayReference<uint8_t>&& pixels)
    {
        assertIsCurrent(workQueue());
        m_context->texImage2D(target, level, internalformat, width, height, border, format, type, std::span(reinterpret_cast<const uint8_t*>(pixels.data()), pixels.size()));
    }
    void texImage2D1(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, uint32_t format, uint32_t type, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->texImage2D(target, level, internalformat, width, height, border, format, type, static_cast<GCGLintptr>(offset));
    }
    void texSubImage2D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, uint32_t type, IPC::ArrayReference<uint8_t>&& pixels)
    {
        assertIsCurrent(workQueue());
        m_context->texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, std::span(reinterpret_cast<const uint8_t*>(pixels.data()), pixels.size()));
    }
    void texSubImage2D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, uint32_t type, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, static_cast<GCGLintptr>(offset));
    }
    void compressedTexImage2D0(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, int32_t imageSize, IPC::ArrayReference<uint8_t>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->compressedTexImage2D(target, level, internalformat, width, height, border, imageSize, std::span(reinterpret_cast<const uint8_t*>(data.data()), data.size()));
    }
    void compressedTexImage2D1(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, int32_t imageSize, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->compressedTexImage2D(target, level, internalformat, width, height, border, imageSize, static_cast<GCGLintptr>(offset));
    }
    void compressedTexSubImage2D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, int32_t imageSize, IPC::ArrayReference<uint8_t>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->compressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, std::span(reinterpret_cast<const uint8_t*>(data.data()), data.size()));
    }
    void compressedTexSubImage2D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, int32_t imageSize, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->compressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, static_cast<GCGLintptr>(offset));
    }
    void drawArraysInstanced(uint32_t mode, int32_t first, int32_t count, int32_t primcount)
    {
        assertIsCurrent(workQueue());
        m_context->drawArraysInstanced(mode, first, count, primcount);
    }
    void drawElementsInstanced(uint32_t mode, int32_t count, uint32_t type, uint64_t offset, int32_t primcount)
    {
        assertIsCurrent(workQueue());
        m_context->drawElementsInstanced(mode, count, type, static_cast<GCGLintptr>(offset), primcount);
    }
    void vertexAttribDivisor(uint32_t index, uint32_t divisor)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttribDivisor(index, divisor);
    }
    void createVertexArray(CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createVertexArray();
        completionHandler(returnValue);
    }
    void deleteVertexArray(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->deleteVertexArray(arg0);
    }
    void isVertexArray(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isVertexArray(arg0);
        completionHandler(static_cast<bool>(returnValue));
    }
    void bindVertexArray(uint32_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->bindVertexArray(arg0);
    }
    void copyBufferSubData(uint32_t readTarget, uint32_t writeTarget, uint64_t readOffset, uint64_t writeOffset, uint64_t arg4)
    {
        assertIsCurrent(workQueue());
        m_context->copyBufferSubData(readTarget, writeTarget, static_cast<GCGLintptr>(readOffset), static_cast<GCGLintptr>(writeOffset), static_cast<GCGLsizeiptr>(arg4));
    }
    void getBufferSubData(uint32_t target, uint64_t offset, size_t dataSize, CompletionHandler<void(IPC::ArrayReference<uint8_t>)>&& completionHandler)
    {
        Vector<uint8_t, 4> data(dataSize, 0);
        assertIsCurrent(workQueue());
        m_context->getBufferSubData(target, static_cast<GCGLintptr>(offset), data);
        completionHandler(IPC::ArrayReference<uint8_t>(reinterpret_cast<uint8_t*>(data.data()), data.size()));
    }
    void blitFramebuffer(int32_t srcX0, int32_t srcY0, int32_t srcX1, int32_t srcY1, int32_t dstX0, int32_t dstY0, int32_t dstX1, int32_t dstY1, uint32_t mask, uint32_t filter)
    {
        assertIsCurrent(workQueue());
        m_context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
    void framebufferTextureLayer(uint32_t target, uint32_t attachment, uint32_t texture, int32_t level, int32_t layer)
    {
        assertIsCurrent(workQueue());
        m_context->framebufferTextureLayer(target, attachment, texture, level, layer);
    }
    void invalidateFramebuffer(uint32_t target, IPC::ArrayReference<uint32_t>&& attachments)
    {
        assertIsCurrent(workQueue());
        m_context->invalidateFramebuffer(target, std::span(reinterpret_cast<const GCGLenum*>(attachments.data()), attachments.size()));
    }
    void invalidateSubFramebuffer(uint32_t target, IPC::ArrayReference<uint32_t>&& attachments, int32_t x, int32_t y, int32_t width, int32_t height)
    {
        assertIsCurrent(workQueue());
        m_context->invalidateSubFramebuffer(target, std::span(reinterpret_cast<const GCGLenum*>(attachments.data()), attachments.size()), x, y, width, height);
    }
    void readBuffer(uint32_t src)
    {
        assertIsCurrent(workQueue());
        m_context->readBuffer(src);
    }
    void renderbufferStorageMultisample(uint32_t target, int32_t samples, uint32_t internalformat, int32_t width, int32_t height)
    {
        assertIsCurrent(workQueue());
        m_context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
    }
    void texStorage2D(uint32_t target, int32_t levels, uint32_t internalformat, int32_t width, int32_t height)
    {
        assertIsCurrent(workQueue());
        m_context->texStorage2D(target, levels, internalformat, width, height);
    }
    void texStorage3D(uint32_t target, int32_t levels, uint32_t internalformat, int32_t width, int32_t height, int32_t depth)
    {
        assertIsCurrent(workQueue());
        m_context->texStorage3D(target, levels, internalformat, width, height, depth);
    }
    void texImage3D0(uint32_t target, int32_t level, int32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, uint32_t format, uint32_t type, IPC::ArrayReference<uint8_t>&& pixels)
    {
        assertIsCurrent(workQueue());
        m_context->texImage3D(target, level, internalformat, width, height, depth, border, format, type, std::span(reinterpret_cast<const uint8_t*>(pixels.data()), pixels.size()));
    }
    void texImage3D1(uint32_t target, int32_t level, int32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, uint32_t format, uint32_t type, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->texImage3D(target, level, internalformat, width, height, depth, border, format, type, static_cast<GCGLintptr>(offset));
    }
    void texSubImage3D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, uint32_t type, IPC::ArrayReference<uint8_t>&& pixels)
    {
        assertIsCurrent(workQueue());
        m_context->texSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, std::span(reinterpret_cast<const uint8_t*>(pixels.data()), pixels.size()));
    }
    void texSubImage3D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, uint32_t type, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->texSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, static_cast<GCGLintptr>(offset));
    }
    void copyTexSubImage3D(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t x, int32_t y, int32_t width, int32_t height)
    {
        assertIsCurrent(workQueue());
        m_context->copyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    void compressedTexImage3D0(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, int32_t imageSize, IPC::ArrayReference<uint8_t>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->compressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, std::span(reinterpret_cast<const uint8_t*>(data.data()), data.size()));
    }
    void compressedTexImage3D1(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, int32_t imageSize, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->compressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, static_cast<GCGLintptr>(offset));
    }
    void compressedTexSubImage3D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, int32_t imageSize, IPC::ArrayReference<uint8_t>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->compressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, std::span(reinterpret_cast<const uint8_t*>(data.data()), data.size()));
    }
    void compressedTexSubImage3D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, int32_t imageSize, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->compressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, static_cast<GCGLintptr>(offset));
    }
    void getFragDataLocation(uint32_t program, String&& name, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getFragDataLocation(program, name);
        completionHandler(returnValue);
    }
    void uniform1ui(int32_t location, uint32_t v0)
    {
        assertIsCurrent(workQueue());
        m_context->uniform1ui(location, v0);
    }
    void uniform2ui(int32_t location, uint32_t v0, uint32_t v1)
    {
        assertIsCurrent(workQueue());
        m_context->uniform2ui(location, v0, v1);
    }
    void uniform3ui(int32_t location, uint32_t v0, uint32_t v1, uint32_t v2)
    {
        assertIsCurrent(workQueue());
        m_context->uniform3ui(location, v0, v1, v2);
    }
    void uniform4ui(int32_t location, uint32_t v0, uint32_t v1, uint32_t v2, uint32_t v3)
    {
        assertIsCurrent(workQueue());
        m_context->uniform4ui(location, v0, v1, v2, v3);
    }
    void uniform1uiv(int32_t location, IPC::ArrayReference<uint32_t>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->uniform1uiv(location, std::span(reinterpret_cast<const GCGLuint*>(data.data()), data.size()));
    }
    void uniform2uiv(int32_t location, IPC::ArrayReference<uint32_t>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->uniform2uiv(location, std::span(reinterpret_cast<const GCGLuint*>(data.data()), data.size()));
    }
    void uniform3uiv(int32_t location, IPC::ArrayReference<uint32_t>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->uniform3uiv(location, std::span(reinterpret_cast<const GCGLuint*>(data.data()), data.size()));
    }
    void uniform4uiv(int32_t location, IPC::ArrayReference<uint32_t>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->uniform4uiv(location, std::span(reinterpret_cast<const GCGLuint*>(data.data()), data.size()));
    }
    void uniformMatrix2x3fv(int32_t location, bool transpose, IPC::ArrayReference<float>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->uniformMatrix2x3fv(location, static_cast<GCGLboolean>(transpose), std::span(reinterpret_cast<const GCGLfloat*>(data.data()), data.size()));
    }
    void uniformMatrix3x2fv(int32_t location, bool transpose, IPC::ArrayReference<float>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->uniformMatrix3x2fv(location, static_cast<GCGLboolean>(transpose), std::span(reinterpret_cast<const GCGLfloat*>(data.data()), data.size()));
    }
    void uniformMatrix2x4fv(int32_t location, bool transpose, IPC::ArrayReference<float>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->uniformMatrix2x4fv(location, static_cast<GCGLboolean>(transpose), std::span(reinterpret_cast<const GCGLfloat*>(data.data()), data.size()));
    }
    void uniformMatrix4x2fv(int32_t location, bool transpose, IPC::ArrayReference<float>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->uniformMatrix4x2fv(location, static_cast<GCGLboolean>(transpose), std::span(reinterpret_cast<const GCGLfloat*>(data.data()), data.size()));
    }
    void uniformMatrix3x4fv(int32_t location, bool transpose, IPC::ArrayReference<float>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->uniformMatrix3x4fv(location, static_cast<GCGLboolean>(transpose), std::span(reinterpret_cast<const GCGLfloat*>(data.data()), data.size()));
    }
    void uniformMatrix4x3fv(int32_t location, bool transpose, IPC::ArrayReference<float>&& data)
    {
        assertIsCurrent(workQueue());
        m_context->uniformMatrix4x3fv(location, static_cast<GCGLboolean>(transpose), std::span(reinterpret_cast<const GCGLfloat*>(data.data()), data.size()));
    }
    void vertexAttribI4i(uint32_t index, int32_t x, int32_t y, int32_t z, int32_t w)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttribI4i(index, x, y, z, w);
    }
    void vertexAttribI4iv(uint32_t index, IPC::ArrayReference<int32_t, 4>&& values)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttribI4iv(index, std::span<const GCGLint, 4> { reinterpret_cast<const GCGLint*>(values.data()), 4 });
    }
    void vertexAttribI4ui(uint32_t index, uint32_t x, uint32_t y, uint32_t z, uint32_t w)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttribI4ui(index, x, y, z, w);
    }
    void vertexAttribI4uiv(uint32_t index, IPC::ArrayReference<uint32_t, 4>&& values)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttribI4uiv(index, std::span<const GCGLuint, 4> { reinterpret_cast<const GCGLuint*>(values.data()), 4 });
    }
    void vertexAttribIPointer(uint32_t index, int32_t size, uint32_t type, int32_t stride, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->vertexAttribIPointer(index, size, type, stride, static_cast<GCGLintptr>(offset));
    }
    void drawRangeElements(uint32_t mode, uint32_t start, uint32_t end, int32_t count, uint32_t type, uint64_t offset)
    {
        assertIsCurrent(workQueue());
        m_context->drawRangeElements(mode, start, end, count, type, static_cast<GCGLintptr>(offset));
    }
    void drawBuffers(IPC::ArrayReference<uint32_t>&& bufs)
    {
        assertIsCurrent(workQueue());
        m_context->drawBuffers(std::span(reinterpret_cast<const GCGLenum*>(bufs.data()), bufs.size()));
    }
    void clearBufferiv(uint32_t buffer, int32_t drawbuffer, IPC::ArrayReference<int32_t>&& values)
    {
        assertIsCurrent(workQueue());
        m_context->clearBufferiv(buffer, drawbuffer, std::span(reinterpret_cast<const GCGLint*>(values.data()), values.size()));
    }
    void clearBufferuiv(uint32_t buffer, int32_t drawbuffer, IPC::ArrayReference<uint32_t>&& values)
    {
        assertIsCurrent(workQueue());
        m_context->clearBufferuiv(buffer, drawbuffer, std::span(reinterpret_cast<const GCGLuint*>(values.data()), values.size()));
    }
    void clearBufferfv(uint32_t buffer, int32_t drawbuffer, IPC::ArrayReference<float>&& values)
    {
        assertIsCurrent(workQueue());
        m_context->clearBufferfv(buffer, drawbuffer, std::span(reinterpret_cast<const GCGLfloat*>(values.data()), values.size()));
    }
    void clearBufferfi(uint32_t buffer, int32_t drawbuffer, float depth, int32_t stencil)
    {
        assertIsCurrent(workQueue());
        m_context->clearBufferfi(buffer, drawbuffer, depth, stencil);
    }
    void createQuery(CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createQuery();
        completionHandler(returnValue);
    }
    void deleteQuery(uint32_t query)
    {
        assertIsCurrent(workQueue());
        m_context->deleteQuery(query);
    }
    void isQuery(uint32_t query, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isQuery(query);
        completionHandler(static_cast<bool>(returnValue));
    }
    void beginQuery(uint32_t target, uint32_t query)
    {
        assertIsCurrent(workQueue());
        m_context->beginQuery(target, query);
    }
    void endQuery(uint32_t target)
    {
        assertIsCurrent(workQueue());
        m_context->endQuery(target);
    }
    void getQuery(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getQuery(target, pname);
        completionHandler(returnValue);
    }
    void getQueryObjectui(uint32_t query, uint32_t pname, CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        GCGLuint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getQueryObjectui(query, pname);
        completionHandler(returnValue);
    }
    void createSampler(CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createSampler();
        completionHandler(returnValue);
    }
    void deleteSampler(uint32_t sampler)
    {
        assertIsCurrent(workQueue());
        m_context->deleteSampler(sampler);
    }
    void isSampler(uint32_t sampler, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isSampler(sampler);
        completionHandler(static_cast<bool>(returnValue));
    }
    void bindSampler(uint32_t unit, uint32_t sampler)
    {
        assertIsCurrent(workQueue());
        m_context->bindSampler(unit, sampler);
    }
    void samplerParameteri(uint32_t sampler, uint32_t pname, int32_t param)
    {
        assertIsCurrent(workQueue());
        m_context->samplerParameteri(sampler, pname, param);
    }
    void samplerParameterf(uint32_t sampler, uint32_t pname, float param)
    {
        assertIsCurrent(workQueue());
        m_context->samplerParameterf(sampler, pname, param);
    }
    void getSamplerParameterf(uint32_t sampler, uint32_t pname, CompletionHandler<void(float)>&& completionHandler)
    {
        GCGLfloat returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getSamplerParameterf(sampler, pname);
        completionHandler(returnValue);
    }
    void getSamplerParameteri(uint32_t sampler, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getSamplerParameteri(sampler, pname);
        completionHandler(returnValue);
    }
    void fenceSync(uint32_t condition, uint32_t flags, CompletionHandler<void(uint64_t)>&& completionHandler)
    {
        GCGLsync returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->fenceSync(condition, flags);
        completionHandler(static_cast<uint64_t>(reinterpret_cast<intptr_t>(returnValue)));
    }
    void isSync(uint64_t arg0, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isSync(reinterpret_cast<GCGLsync>(static_cast<intptr_t>(arg0)));
        completionHandler(static_cast<bool>(returnValue));
    }
    void deleteSync(uint64_t arg0)
    {
        assertIsCurrent(workQueue());
        m_context->deleteSync(reinterpret_cast<GCGLsync>(static_cast<intptr_t>(arg0)));
    }
    void clientWaitSync(uint64_t arg0, uint32_t flags, uint64_t timeout, CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        GCGLenum returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->clientWaitSync(reinterpret_cast<GCGLsync>(static_cast<intptr_t>(arg0)), flags, static_cast<GCGLuint64>(timeout));
        completionHandler(returnValue);
    }
    void waitSync(uint64_t arg0, uint32_t flags, int64_t timeout)
    {
        assertIsCurrent(workQueue());
        m_context->waitSync(reinterpret_cast<GCGLsync>(static_cast<intptr_t>(arg0)), flags, static_cast<GCGLint64>(timeout));
    }
    void getSynci(uint64_t arg0, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getSynci(reinterpret_cast<GCGLsync>(static_cast<intptr_t>(arg0)), pname);
        completionHandler(returnValue);
    }
    void createTransformFeedback(CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createTransformFeedback();
        completionHandler(returnValue);
    }
    void deleteTransformFeedback(uint32_t id)
    {
        assertIsCurrent(workQueue());
        m_context->deleteTransformFeedback(id);
    }
    void isTransformFeedback(uint32_t id, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isTransformFeedback(id);
        completionHandler(static_cast<bool>(returnValue));
    }
    void bindTransformFeedback(uint32_t target, uint32_t id)
    {
        assertIsCurrent(workQueue());
        m_context->bindTransformFeedback(target, id);
    }
    void beginTransformFeedback(uint32_t primitiveMode)
    {
        assertIsCurrent(workQueue());
        m_context->beginTransformFeedback(primitiveMode);
    }
    void endTransformFeedback()
    {
        assertIsCurrent(workQueue());
        m_context->endTransformFeedback();
    }
    void transformFeedbackVaryings(uint32_t program, Vector<String>&& varyings, uint32_t bufferMode)
    {
        assertIsCurrent(workQueue());
        m_context->transformFeedbackVaryings(program, varyings, bufferMode);
    }
    void getTransformFeedbackVarying(uint32_t program, uint32_t index, CompletionHandler<void(struct WebCore::GraphicsContextGLActiveInfo&&)>&& completionHandler)
    {
        struct WebCore::GraphicsContextGLActiveInfo arg2 { };
        assertIsCurrent(workQueue());
        m_context->getTransformFeedbackVarying(program, index, arg2);
        completionHandler(WTFMove(arg2));
    }
    void pauseTransformFeedback()
    {
        assertIsCurrent(workQueue());
        m_context->pauseTransformFeedback();
    }
    void resumeTransformFeedback()
    {
        assertIsCurrent(workQueue());
        m_context->resumeTransformFeedback();
    }
    void bindBufferBase(uint32_t target, uint32_t index, uint32_t buffer)
    {
        assertIsCurrent(workQueue());
        m_context->bindBufferBase(target, index, buffer);
    }
    void bindBufferRange(uint32_t target, uint32_t index, uint32_t buffer, uint64_t offset, uint64_t arg4)
    {
        assertIsCurrent(workQueue());
        m_context->bindBufferRange(target, index, buffer, static_cast<GCGLintptr>(offset), static_cast<GCGLsizeiptr>(arg4));
    }
    void getUniformIndices(uint32_t program, Vector<String>&& uniformNames, CompletionHandler<void(Vector<uint32_t>&&)>&& completionHandler)
    {
        Vector<GCGLuint> returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getUniformIndices(program, uniformNames);
        completionHandler(WTFMove(returnValue));
    }
    void getActiveUniforms(uint32_t program, Vector<uint32_t>&& uniformIndices, uint32_t pname, CompletionHandler<void(Vector<int32_t>&&)>&& completionHandler)
    {
        Vector<GCGLint> returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getActiveUniforms(program, uniformIndices, pname);
        completionHandler(WTFMove(returnValue));
    }
    void getUniformBlockIndex(uint32_t program, String&& uniformBlockName, CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        GCGLuint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getUniformBlockIndex(program, uniformBlockName);
        completionHandler(returnValue);
    }
    void getActiveUniformBlockName(uint32_t program, uint32_t uniformBlockIndex, CompletionHandler<void(String&&)>&& completionHandler)
    {
        String returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getActiveUniformBlockName(program, uniformBlockIndex);
        completionHandler(WTFMove(returnValue));
    }
    void uniformBlockBinding(uint32_t program, uint32_t uniformBlockIndex, uint32_t uniformBlockBinding)
    {
        assertIsCurrent(workQueue());
        m_context->uniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
    }
    void getActiveUniformBlockiv(uint32_t program, uint32_t uniformBlockIndex, uint32_t pname, size_t paramsSize, CompletionHandler<void(IPC::ArrayReference<int32_t>)>&& completionHandler)
    {
        Vector<GCGLint, 4> params(paramsSize, 0);
        assertIsCurrent(workQueue());
        m_context->getActiveUniformBlockiv(program, uniformBlockIndex, pname, params);
        completionHandler(IPC::ArrayReference<int32_t>(reinterpret_cast<int32_t*>(params.data()), params.size()));
    }
    void getTranslatedShaderSourceANGLE(uint32_t arg0, CompletionHandler<void(String&&)>&& completionHandler)
    {
        String returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getTranslatedShaderSourceANGLE(arg0);
        completionHandler(WTFMove(returnValue));
    }
    void drawBuffersEXT(IPC::ArrayReference<uint32_t>&& bufs)
    {
        assertIsCurrent(workQueue());
        m_context->drawBuffersEXT(std::span(reinterpret_cast<const GCGLenum*>(bufs.data()), bufs.size()));
    }
    void createQueryEXT(CompletionHandler<void(uint32_t)>&& completionHandler)
    {
        PlatformGLObject returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->createQueryEXT();
        completionHandler(returnValue);
    }
    void deleteQueryEXT(uint32_t query)
    {
        assertIsCurrent(workQueue());
        m_context->deleteQueryEXT(query);
    }
    void isQueryEXT(uint32_t query, CompletionHandler<void(bool)>&& completionHandler)
    {
        GCGLboolean returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->isQueryEXT(query);
        completionHandler(static_cast<bool>(returnValue));
    }
    void beginQueryEXT(uint32_t target, uint32_t query)
    {
        assertIsCurrent(workQueue());
        m_context->beginQueryEXT(target, query);
    }
    void endQueryEXT(uint32_t target)
    {
        assertIsCurrent(workQueue());
        m_context->endQueryEXT(target);
    }
    void queryCounterEXT(uint32_t query, uint32_t target)
    {
        assertIsCurrent(workQueue());
        m_context->queryCounterEXT(query, target);
    }
    void getQueryiEXT(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getQueryiEXT(target, pname);
        completionHandler(returnValue);
    }
    void getQueryObjectiEXT(uint32_t query, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
    {
        GCGLint returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getQueryObjectiEXT(query, pname);
        completionHandler(returnValue);
    }
    void getQueryObjectui64EXT(uint32_t query, uint32_t pname, CompletionHandler<void(uint64_t)>&& completionHandler)
    {
        GCGLuint64 returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getQueryObjectui64EXT(query, pname);
        completionHandler(static_cast<uint64_t>(returnValue));
    }
    void getInteger64EXT(uint32_t pname, CompletionHandler<void(int64_t)>&& completionHandler)
    {
        GCGLint64 returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->getInteger64EXT(pname);
        completionHandler(static_cast<int64_t>(returnValue));
    }
    void enableiOES(uint32_t target, uint32_t index)
    {
        assertIsCurrent(workQueue());
        m_context->enableiOES(target, index);
    }
    void disableiOES(uint32_t target, uint32_t index)
    {
        assertIsCurrent(workQueue());
        m_context->disableiOES(target, index);
    }
    void blendEquationiOES(uint32_t buf, uint32_t mode)
    {
        assertIsCurrent(workQueue());
        m_context->blendEquationiOES(buf, mode);
    }
    void blendEquationSeparateiOES(uint32_t buf, uint32_t modeRGB, uint32_t modeAlpha)
    {
        assertIsCurrent(workQueue());
        m_context->blendEquationSeparateiOES(buf, modeRGB, modeAlpha);
    }
    void blendFunciOES(uint32_t buf, uint32_t src, uint32_t dst)
    {
        assertIsCurrent(workQueue());
        m_context->blendFunciOES(buf, src, dst);
    }
    void blendFuncSeparateiOES(uint32_t buf, uint32_t srcRGB, uint32_t dstRGB, uint32_t srcAlpha, uint32_t dstAlpha)
    {
        assertIsCurrent(workQueue());
        m_context->blendFuncSeparateiOES(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }
    void colorMaskiOES(uint32_t buf, bool red, bool green, bool blue, bool alpha)
    {
        assertIsCurrent(workQueue());
        m_context->colorMaskiOES(buf, static_cast<GCGLboolean>(red), static_cast<GCGLboolean>(green), static_cast<GCGLboolean>(blue), static_cast<GCGLboolean>(alpha));
    }
    void drawArraysInstancedBaseInstanceANGLE(uint32_t mode, int32_t first, int32_t count, int32_t instanceCount, uint32_t baseInstance)
    {
        assertIsCurrent(workQueue());
        m_context->drawArraysInstancedBaseInstanceANGLE(mode, first, count, instanceCount, baseInstance);
    }
    void drawElementsInstancedBaseVertexBaseInstanceANGLE(uint32_t mode, int32_t count, uint32_t type, uint64_t offset, int32_t instanceCount, int32_t baseVertex, uint32_t baseInstance)
    {
        assertIsCurrent(workQueue());
        m_context->drawElementsInstancedBaseVertexBaseInstanceANGLE(mode, count, type, static_cast<GCGLintptr>(offset), instanceCount, baseVertex, baseInstance);
    }
    void clipControlEXT(uint32_t origin, uint32_t depth)
    {
        assertIsCurrent(workQueue());
        m_context->clipControlEXT(origin, depth);
    }
    void provokingVertexANGLE(uint32_t provokeMode)
    {
        assertIsCurrent(workQueue());
        m_context->provokingVertexANGLE(provokeMode);
    }
    void polygonModeANGLE(uint32_t face, uint32_t mode)
    {
        assertIsCurrent(workQueue());
        m_context->polygonModeANGLE(face, mode);
    }
    void polygonOffsetClampEXT(float factor, float units, float clamp)
    {
        assertIsCurrent(workQueue());
        m_context->polygonOffsetClampEXT(factor, units, clamp);
    }
    void renderbufferStorageMultisampleANGLE(uint32_t target, int32_t samples, uint32_t internalformat, int32_t width, int32_t height)
    {
        assertIsCurrent(workQueue());
        m_context->renderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height);
    }
    void blitFramebufferANGLE(int32_t srcX0, int32_t srcY0, int32_t srcX1, int32_t srcY1, int32_t dstX0, int32_t dstY0, int32_t dstX1, int32_t dstY1, uint32_t mask, uint32_t filter)
    {
        assertIsCurrent(workQueue());
        m_context->blitFramebufferANGLE(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
    void getInternalformativ(uint32_t target, uint32_t internalformat, uint32_t pname, size_t paramsSize, CompletionHandler<void(IPC::ArrayReference<int32_t>)>&& completionHandler)
    {
        Vector<GCGLint, 4> params(paramsSize, 0);
        assertIsCurrent(workQueue());
        m_context->getInternalformativ(target, internalformat, pname, params);
        completionHandler(IPC::ArrayReference<int32_t>(reinterpret_cast<int32_t*>(params.data()), params.size()));
    }
    void setDrawingBufferColorSpace(WebCore::DestinationColorSpace&& arg0)
    {
        assertIsCurrent(workQueue());
        m_context->setDrawingBufferColorSpace(arg0);
    }
    void drawingBufferToPixelBuffer(WebCore::GraphicsContextGL::FlipY&& arg0, CompletionHandler<void(RefPtr<WebCore::PixelBuffer>&&)>&& completionHandler)
    {
        RefPtr<WebCore::PixelBuffer> returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->drawingBufferToPixelBuffer(arg0);
        completionHandler(WTFMove(returnValue));
    }
    void destroyEGLSync(uint64_t arg0, CompletionHandler<void(bool)>&& completionHandler)
    {
        bool returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->destroyEGLSync(reinterpret_cast<GCEGLSync>(static_cast<intptr_t>(arg0)));
        completionHandler(returnValue);
    }
    void clientWaitEGLSyncWithFlush(uint64_t arg0, uint64_t timeout)
    {
        assertIsCurrent(workQueue());
        m_context->clientWaitEGLSyncWithFlush(reinterpret_cast<GCEGLSync>(static_cast<intptr_t>(arg0)), timeout);
    }
    void enableRequiredWebXRExtensions(CompletionHandler<void(bool)>&& completionHandler)
    {
        bool returnValue = { };
        assertIsCurrent(workQueue());
        returnValue = m_context->enableRequiredWebXRExtensions();
        completionHandler(returnValue);
    }

