c###outpar.for
      SUBROUTINE OUTPAR
C--------------------------------
C
C     THIS ROUTINE OUTPUTS IONOSPHERIC PARAMETERS
C
      COMMON / CON / D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RZ, VOFL
      COMMON / ES / FS(3,5), HS(5)
      COMMON / GEOG / GYZ(5), RAT(5), GMDIP(5), CLCK(5), ABIY(5),
     1 ARTIC(5), SIGPAT(5), EPSPAT(5)
      COMMON / MFAC / F2M3(5),HPF2(5),ZENANG(5),ZENMAX(5),IEDP,FSECV(3)
      COMMON / OUTLAB / LABEL(11), LAYTYP(5), IEAST, INORTH, ISOUTH,
     A IWEST, LABLI, LABLJ, LABLK
      CHARACTER IEAST*1, ISOUTH*1, INORTH*1, IWEST*1, LABEL*5, LAYTYP*2,
     A LABLI*5, LABLJ*5, LABLK*5
      COMMON / OUTPRT / LINBOT(26), LINBD(14), LINTOP(15), LINTP(14),
     A GRPTYP, JOUT, LINBYP, LINES, LINMAX, LINTYP, LPAGES, NLINE
      COMMON /RON /CLAT(5), CLONG(5), GLAT(5), RD(5), FI(3,5), YI(3,5),
     1HI(3,5), HPRIM(30,5), HTRUE(30,5), FVERT(30,5),KM,KFX, AFAC(30,5),
     2HTR(50,3), FNSQ(50,3)
      COMMON / TIME / IT, GMT, UTIME(24), GMTR, XLMT(24), ITIM, JTX
      COMMON / FILES / LUI, LUO, LU2, LU5, LU6, LU15, LU16, LU20, LU25,
     A LU26, LU35
      CHARACTER IGLAT*1, ISLAT*1, ISLONG*1
      DO 160 K=1,KM
      LINES = LINES + 1
      IF(LINES - LINMAX) 110, 110, 100
C.....CALL SUBROUTINE OUTTOP TO OUTPUT HEADER INFORMATION
  100 CALL OUTTOP
      WRITE(LUO,503)
      WRITE(LUO,500) YI(1,1), HI(1,1), HS(1)
      WRITE(LUO,501)
      LINES = LINTOP(15)
  110 GL = ABS(GLAT(K) * R2D)
      XLAT = ABS(CLAT(K) * R2D)
      XLONG = ABS(CLONG(K) * R2D)
      GYZH = GYZ(K) / 2.
      IGLAT = INORTH
      ISLAT = INORTH
      ISLONG = IEAST
      IF(GLAT(K)) 115, 120, 120
  115 IGLAT = ISOUTH
  120 IF(CLAT(K)) 125, 130, 130
  125 ISLAT = ISOUTH
  130 IF(CLONG(K)) 140, 150, 150
  140 ISLONG = IWEST
  150 WRITE(LUO,502) XLAT, ISLAT, XLONG, ISLONG, CLCK(K), GMT, FI(1,K),
     1 FI(2,K), YI(2,K), HI(2,K), GYZH, FI(3,K), YI(3,K), HI(3,K),
     2 FS(1,K), FS(2,K), FS(3,K), F2M3(K), HPF2(K), RAT(K), ZENANG(K),
     3 ZENMAX(K), GL, IGLAT
  160 CONTINUE
      RETURN
  500 FORMAT(' ',32X,'YE = ',F5.1,5X,'HE = ',F5.1,5X,'HS = ',F5.1,/)
  501 FORMAT(' ',2X,'LAT',3X,'LONG',4X,'LMT',4X,'UT',4X,'E',5X,'F1',4X,
     A 'Y1',5X,'H1',2X,'FH/2',3X,'F2Z',4X,'Y2',5X,'H2',3X,'ES',2X,'MED',
     B 3X,'HI',1X,'M3000',3X,'HPF2',3X,'RAT',4X,'ZEN',2X,'ZMAX',2X,
     C 'MAGL')
  502 FORMAT(2(1X,F5.1,A1),2F6.1,F6.2,2F6.1,F7.1,3F6.1,F7.1,
     1 3F5.1,F6.2,2(F7.1,F6.1),F6.1,A1)
  503 FORMAT(' ')
      END
C--------------------------------
