--
--  $Id: tdav_meta_checks.sql,v 1.7.6.1.4.1 2013/01/02 16:15:02 source Exp $
--
--  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
--  project.
--
--  Copyright (C) 1998-2018 OpenLink Software
--
--  This project is free software; you can redistribute it and/or modify it
--  under the terms of the GNU General Public License as published by the
--  Free Software Foundation; only version 2 of the License, dated June 1991.
--
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
--  General Public License for more details.
--
--  You should have received a copy of the GNU General Public License along
--  with this program; if not, write to the Free Software Foundation, Inc.,
--  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
--
--
TDAV_META_CHECK ('Dimitar Dimitrov.vcf', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'text^2fdirectory');
TDAV_META_CHECK ('Dimitar Dimitrov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#EMAIL', 'ddimitrov@openlinksw.com (PREF)');
TDAV_META_CHECK ('Dimitar Dimitrov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#FN', 'Dimitar Dimitrov');
TDAV_META_CHECK ('Dimitar Dimitrov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#N', 'Dimitrov;Dimitar;;;');
TDAV_META_CHECK ('Dimitar Dimitrov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Name-Family', 'Dimitrov');
TDAV_META_CHECK ('Dimitar Dimitrov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Name-Given', 'Dimitar');
TDAV_META_CHECK ('Dimitar Dimitrov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Org-Orgname', 'OpenLink Bulgaria');
TDAV_META_CHECK ('Dimitar Dimitrov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#REV', '20050411T183643Z');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'text^2fdirectory');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#ADR', ';;8 Bulair Str.;Plovdiv;Plovdiv;4003;Bulgaria (POSTAL)');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#ADR', ';;My postal address is ^3a=0D=0A12 Surnena Gora . . .');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Address-Country', 'Bulgaria');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Address-Extadd', '! empty property value !');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Address-Locality', 'Plovdiv');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Address-Locality', 'Plovdiv,');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Address-Pcode', '4003');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Address-Pobox', '! empty property value !');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Address-Region', '! empty property value !');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Address-Region', 'Plovdiv');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Address-Street', '8 Bulair Str.');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Address-Street', 'My postal address is ^3a=0D=0A12 Surnena Gora Str.');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#EMAIL', 'gkodinov@openlinksw.co.uk (PREF)');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#FN', 'George Kodinov');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#LABEL', ' 4003=0D=0ABulgaria (WORK)');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#LABEL', ' Plovdiv 4003=0D=0ABulgaria (POSTAL)');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#LABEL', '8 Bulair Str.=0D=0APlovdiv (POSTAL)');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#LABEL', 'My postal address is ^3a=0D=0A12 Surnena Gora Str.=0D=0APlovdiv (WORK)');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#N', 'Kodinov;George;;;');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#NOTE', '562391=0D=0A=0D=0A+359 32 637 475=0D=0A+359 32 637 . . .');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Name-Family', 'Kodinov');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Name-Given', 'George');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Org-Orgname', 'OpenLink Software');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Org-Orgunit', 'Virtuoso');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#REV', '20050411T183644Z');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#TEL', '+359 (32) 637 476 (WORK)');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#TEL', '+359 (3254) 27 34 (HOME)');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#TEL', '+359 32637475 (WORK)');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#TEL', '+359 887 700566 (CELL)');
TDAV_META_CHECK ('George Kodinov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#TITLE', 'Developer');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'text^2fdirectory');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#EMAIL', 'imitko@openlinksw.co.uk (PREF)');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#FN', 'Mitko Iliev');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#N', 'Iliev;Mitko;;;');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#NOTE', '+359 32 637 476=0D=0A');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Name-Family', 'Iliev');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Name-Given', 'Mitko');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Org-Orgname', 'OpenLink Software');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#REV', '20050411T183644Z');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#TEL', '+359 (32) 637 475 (WORK)');
TDAV_META_CHECK ('Mitko Iliev.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#TEL', '+359 (32) 637 476 (WORK)');
TDAV_META_CHECK ('News_Feeds.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('News_Feeds.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('News_Feeds.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('Ruslan Abdulkhalikov.vcf', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'text^2fdirectory');
TDAV_META_CHECK ('Ruslan Abdulkhalikov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#EMAIL', 'ruslan@openlinksw.com (PREF)');
TDAV_META_CHECK ('Ruslan Abdulkhalikov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#FN', 'Ruslan Abdulkhalikov');
TDAV_META_CHECK ('Ruslan Abdulkhalikov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#N', 'Abdulkhalikov;Ruslan;;;');
TDAV_META_CHECK ('Ruslan Abdulkhalikov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Name-Family', 'Abdulkhalikov');
TDAV_META_CHECK ('Ruslan Abdulkhalikov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Name-Given', 'Ruslan');
TDAV_META_CHECK ('Ruslan Abdulkhalikov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#Org-Orgname', 'OpenLink Software');
TDAV_META_CHECK ('Ruslan Abdulkhalikov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#REV', '20050411T183644Z');
TDAV_META_CHECK ('Ruslan Abdulkhalikov.vcf', 'http://www.w3.org/2001/vcard-rdf/3.0#TITLE', 'Developer - Virtuoso Team');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.openlinksw.com/virtdav#dynArchiver', 'XBEL');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fxbel+xml');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', '.NET Common Data Classes');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', '.Net Ports and Implementations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', '3G Wireless');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', '3rd Party Data Access Components');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'AD Creation etc.');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ADO');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ADO For Java');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ADO.NET');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'API Implementations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'APIS');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'APIS & SDKS');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'APIs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'APIs & Frameworks');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ASPZone');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Abstraction Layers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Account & Integrated Biz Systems Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Accounting');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Acquisition or Partner Prospects');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Active Server Page Components');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Active Server Pages Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ActiveX');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Advertising');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Africa Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Agent Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Agent Technology Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Aggregators');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Agriculture');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'All Inclusive Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'All Purpose Collaboration');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Animated Demo Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Animation Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Animations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Animations & Grpahics Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Anti Spam');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Apache');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'AppFoundry (Netscape App Centre)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Apple');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Applets & Applications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Appliances');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Assembly Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Demos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Design & Modelling');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Dev Frameworks');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Development');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Server & Xml ASPs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Servers & Web Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Service Providers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles & Essays');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles & Samples');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles & White Papers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles & Whitepapers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles and White Papers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles and Whitepapers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Artificial Intelligence');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Assembly environments');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Auction Prowlers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Auctions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Authoring Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Authoring and Browsing Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Auto Discovery');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Automobiles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'B2B Exchanges');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'B2B Integration');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'B2B Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'BNFs & Grammers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'BSD');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Backbone Providers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bandwidth Aggregators');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Banking');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Banner AD Utilities');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bargain Searchers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Barter Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bash');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Benchmark Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Benchmark Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Benchmarking');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Benchmarks');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Berlin - GUI & DOM & CORBA');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Biologial Warfare');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Biometrics');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Biotechnology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Blog Databases ');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Blog Search Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Blogging & WebLogs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bluetooth');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bookmark & Favorites Handling');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bookmarklets');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bookmarks Formats');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bookmarks Storage');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Books');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Brazil (Sun)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Broadcasters');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Browser Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Browsers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bulk E-mail Packages');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Busines to Consumer');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Activity Monitoring');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Integration Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Networking');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Oriented');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Process Management');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Processing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Rules & Inference Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business To Business');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business To Consumer (B2C)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'C & C++');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'C Development');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'C and C++');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'CD-ROM & DVD Dupliaction');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'CLR Ports (.NET)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'CRM & SFA Focused');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'CRM & SFA Solutions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendar & Scheduling');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendar Data Storage');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendar Diary Discussion  and Folders');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendaring');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendering');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendering & Group Scheduling');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendering & Scheduling');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Case Studies - Succcessful Projects');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Catalog  & Merchant Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Catalog Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Class Libraries');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Classification Schemes');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Client  Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Clients');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Clothing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Clustering');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Clustering Oriented');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Code & Algorithms');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Code Factories (International)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Collaboration');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Collaboration & Analysis');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Collaboration Products & Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Collaborative Information Filtering');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Commercial');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Commercial Sites Generated By Blogware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Comms Layers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Communities');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Companies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Company & Software Developer Matching Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Company Position Papers and Statements');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Comparative Analysis');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Competitive Analysis');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Competitor or Co-opetitor Roadmaps');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Compiler Construction & Meta Lang Assemblers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Compilers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Complaint Data Sources');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Compliance & Stress Testing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Compliant Browsers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Compliant Tools & Compilers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Component DBs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Components');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Componentware & Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Computer Fabrics related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Computer Telephony Integration');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Computers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Configuration MGMT');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Connectivity');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Consortia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Consultant Directories');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Consumer Food & Beverages');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Consumer Opinion & Disccusion');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Consumer To Consumer');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Contact Management');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Contacts Storage (vCard)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content - Directories & Encylopedia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Archives');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Bookmarking ');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Integration Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Management');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Management & Syndication');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Syndication & Aggregation');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Applications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Blogs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Demos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Examples');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Platforms & Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Web Services Consumer Apps & Add-ins');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Course Developers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Courseware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Currency & Cash');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Custom Books and Documenation');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customer Asset Management');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customer Asset Management & E-Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customer Asset Mgmt. & SFA');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customer Service');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customer Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customization Techniques');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DB Admin Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DB Application RAD Environements');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DB Based File systems & Commom Data Sorage');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DB Front-Ends');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DCOM');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DNS Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DOM');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DSL');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DTDs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data  Access Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access & Data Exchange');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access & ODBC');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access Abstraction Layers & APIs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access Components');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access Middleware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access Network Layers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access Query & Management Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Admin Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Backup & Recovery Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Capture & Exchange Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Carrier Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Driven  Animation Tools (ODBC or JDBC)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Encryption & Security');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Feeds');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Migration & Cleansing Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Mining');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Modelling Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Providers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Storage');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Storage & File Sharing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Storage (Web Briefcase)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Transmission');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Visualization');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Visualization & Modelling Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Warehousing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database & Data Access Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database & Search Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database APIs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Connectivity');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Driven');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Engine');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database IDEs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database to Database');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Databases');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Databases General');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dedicated Hardware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dedicated XML Information Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Deductive & Other New Format Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Delivery and Personal Assistance');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Demo Applications (Complete Solutions)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Demos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Demos & Tutorials');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Design & Modelling Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Design Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Desktop');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Desktop & Window Managers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Desktop Productivity Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Desktop Productivity Tools - Office etc');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Desktop applications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DevX Articles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Developer Sources');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Developer Specific');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Developer Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Development');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Development & Integration Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Development Libraries');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Development Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Development Tools & Components');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Devices');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dictionaries & Encylopedia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital  Books & Publishing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Asset Management');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Entertainement');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Formas & Codecs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital IDs & Certificates Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Identities Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Imaging');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Libraries');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Music');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Rights Management');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital UNIX');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Video Cameras');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Directories');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Directory Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion & Collaboration');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion & News Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion Clients');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion Forum & News Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion Forums');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion Forums Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion Services (NNTP etc..)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Display Devices');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Display Devices (Monitors etc.)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Display Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Display Technology''');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distribubted Computing (CORBA Based)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributed Components Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributed Computing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributed Database Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributed IPCs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributed Transactions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distribution');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Documentation & KBASE Projects');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Drivers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Drivers & Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dublin Core Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dynamic DB Driven Web Middleware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dynamic HTML');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dynamic Service Discovry & UDDI Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dynamic XML');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-Business');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-Commerce');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-Commerce & Biz related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-Commerce Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-Tailing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-business');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-commerce');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-mail');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-mail Marketing & Mail Merge');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-mail Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-mail Spec');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'EAI');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ECMA');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'EII ');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ERP  Systems');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Editors');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Electronic Ink');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Electronic Stock Trading Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Email Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Embedded');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Embedded DB Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Encoding Schemes');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Encryption - Technology & Export Rules');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Encryption Technologies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Encyclopedia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Engine Implmentations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Engine Models');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'English Language');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Enterprise Application Integration');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Enterprise GroupWare');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Enterprise Information Portal Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Enterprise Information Portals');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Enterprise Java Beans');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Entertainment');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Environments');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Ethernet');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Event Planning');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Examples & Practical Use');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Exchange Building Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Eye');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'FAQs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'FOAF');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'FTP Clients');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Facial');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Fashion');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Fashion Retail');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Fiberless Optics');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'File Sharing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'File System Driver Development');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'File Systems');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'File Systems & Server Devices');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Files System & Sharing Protocols');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Filtering Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Finance & Corporate Information');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Finance & Reporting');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Finance Industry Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Finger Prints');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Firewall Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Flash');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Flash Based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Food & Groceries');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Frameworks');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Frameworks & Environments');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Frameworks and SDKs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Frameworks etc');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Free ORB Directory');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Free Source Code');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Free with Source');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Free-Space-Optics');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Freedom & Free Speech etc');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Fulfillment  Processing Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Futuristic Visions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GUI');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GUI Application Tools & Technologies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GUI Toolkits & Frameworks');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GUI and Human-Computer Interaction');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GUI related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Game Consoles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Games');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General - CTO Level');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General Information');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General Java Information Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General TV');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General XML related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Genetics');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Geography');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Glossaries');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Gnome');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Graphical User Interfaces');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Graphics');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Graphics & Animation & 3D Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Graphics Related - Very Cool');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Grid Computing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Group Development & Testing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GroupWare');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HOWTOS');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HR');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HTML Based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HTML Editors & Publishing Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HTML UI');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HTML for Conversion');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HTTP Protocol Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Handhelds');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Handhelds & PDAs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Handsets');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Handwriting');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hardware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hardware Providers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Healthcare');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HelpDesk');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HelpDesk & CRM');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Helpdesk');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Helpdesk & Support');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'High Level Dev. Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'High Level Object Languages');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'High Tech');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'High-Tech');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'High-Tech Equipment Companies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Home');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Home Appliances');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Home Furniture');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted Applications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted Solutions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted Solutions (ASP Model)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HotSpots');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'How To Docs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hubs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Human Interface');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Human Resource Management etc');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hypertext Systems');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IBM');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IDES');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IDEs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IETF Protocols');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IP Based Telephony');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IRIX');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IVR Solutions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Immunology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Independent Artists');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Independent Films');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Indexing & Search Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'India');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Industry Players');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Industry Specific');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Inferno');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Info Directories');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Info Sources');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information & Intelligent Consumer Electronics');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Appliances');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Appliances - Thin Clients');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Application & Retrieval Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Casting');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Casting & Retrieval');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Directories');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Mediation & Dissemination');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Search');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Sources');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Infrastructure Providers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Infrastructure Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Initiatives and Specifications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Initiatives of Interest');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Innovative Solutions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Installer Programs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Installer Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Instant Messaging');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Instant Messaging Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Instant Messaging Software');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Insurance');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Integrated Development Environments (IDEs)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Integration Servers (Middleware)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Intelligent Devices');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Interesting Database Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Interesting WIKIs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internationalization');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internationalization and Localization');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Appliances & Technologies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Assistants');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Commerce');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Infrastructure Technology & Providers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Interactivity - Realtime Chat & User Discovery Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Intranet Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Intranet Solutions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Intranet Suites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JDBC');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JDBC Aware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JDBC Based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JDBC Based Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JDBC v ADO Technical Comparisons');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JSP Engine');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Jav Bean Generation');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java & New Generation');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java Based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java Based Technologies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java Developers Journal Code Library');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java ServLet Containers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Journal & Publishing Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Journals & Publishing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Key Contact Web Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Key Personalities');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Key Researchers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Knowledge & Information & Agent Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Knowledge & Information Casting & Corporate Portal Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Knowledge & Information Processing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Knowledge-Information-Metadata');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Knowledgebases & Agent Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'LDAP');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'LDAP Classes');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Labs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Language Comparisons (Java n Python)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Lead Sources');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Legacy Application Logic for Conversion');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Licence Enforcement Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Licensing Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Life Style');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Linux');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Linux Based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Linux based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Linux on CDROM');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Locator Portals');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MP3 - Music over NET Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MP3 Casting and Content Production');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MP3 Players');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MP3 search Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MPEG-4');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MPEG-7');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mac OS X Based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MacOS');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mach');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Macintosh');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Macintosh 68K Versions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mag Articles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mail');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mail Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mail Transfer Agents (MTAs)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mail to SMS Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mapping & GIS');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Maps & Catography');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Market Analysis');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Market Research');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Marketing Automation Software');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Marketing Presntations Portals');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Markup Languages');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Meeting Facilitators (Face to Face)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Merchant Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Message Oriented Middleware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Messaging');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Metadata');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Metadata & Resource Definition Framework (RDF)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Metadatea Specs & Consortia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Methodology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft Articles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft Java APIs & SDKs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft Provided');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft.NET');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft.NET Demos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Middleware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Middleware and Management Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mixed Data Access Mechanisms');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mixing Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mixtapes');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Calendar Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Computing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Enterprise');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Network Providers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Office Solutions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Players for Cars');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Modeling (XML Vocabularies, Data, and Systems)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Modelling Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mono');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mortgages & Loans');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Movie Creation');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Movie Industry');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Movies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Movies Database');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mozilla');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Multi Purpose');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Multimedia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Multimedia & Graphics');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Multimedia Appliances');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Multimedia Sharing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Music');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Music Industry');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MySQL');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MySQL Based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MySQL Specific');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'NIC Drivers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'NNTP Clients');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'NNTP Clients & Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'NNTP Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Naming & Directory Interface (JNDI)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Native Based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Native XML Databases');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Natural Language Processing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Natural Language Query Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Natural Language Query Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Net Conferencing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Net Life Style');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Netcasting');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Netscape');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Network Computers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Network Diagnostic Utilities');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Network Management & Design Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Network Monitoring');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Network Programming Matters');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Networking');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Networking Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Networks');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'New Media');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'New Media Broadcasting');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'New Media Innovations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'New Product Ideas');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'New Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'News');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'News Collection & Distribution');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'News Delivery & Exchange');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'News Specific Crawlers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Newton');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Next Generation Computer Interconnects');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Nokia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Notations and Style');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OCS Data');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ODBC Based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OLAP');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OLAP Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OLE DB related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OLE-DB');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OMG Papers (New OMA Architecture)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OMG Specs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ORBS');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OS390');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object Databases');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object Description Language');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object Frameworks & APIs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object Modelling Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object Request Brokers & Technologies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object-Relational');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object-Relational Mappers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Offshore');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Offshore Development Companies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Ad Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Demos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Gaming');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Labs & Compile Farms');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Record Companies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Research Labs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Trading');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Training');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online demos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Ontologies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Ontology Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open APIs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Directories');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Software & GNU World');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Software Desc (ODS) Spec - Push & Replication');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Source');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Source Projects');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Source Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open source');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OpenVMS');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Operating Environments');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Operating Environments (VMs)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Operating Systems');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Operational Resource Management (ORM)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Optical Character Reconition');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Optical Networking');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Oracle');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Organizations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Organizations & Consortia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Other DB Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Other Projects');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Others');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'P2P Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PABX');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PC Cards');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PCs & Workstations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PDA & Embedded DB Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PDA & Embedded Edition Kernel Ports');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PDA Applications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PDA related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PDAs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PERL Interfaces');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PPC Version');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PR');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PThreads');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Parallel Programming Technology & Issues');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Parser Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Parsers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Parsers & Compilers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Patent Monitoring Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Patents');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Payment Processing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Payment Processing & E-Currency');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Peer to Peer');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Peer-Peer Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Pen Like Devices');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Perl');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Perl DBI');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Personal & Small Business Site Building');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Personal Networking');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Personalities');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Pharmaceuticals & Drug Stores');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Phones');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Photos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Photos & Digital Art');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Players');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Podcasting');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Polls and Surveys');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Portability & Binary Interface Standards');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Portability kits');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Portable Players');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Portal (All in One)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Portals');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Ports');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Potential Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Presentations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Presentations & Demos - Video Streaming');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Presentations & White Papers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Privacy Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Processor Architectures');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Processor Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Processors');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Product Comparisons');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Product Directories');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Product Directory');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Product Reviews');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Products & API Implementations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Professional Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Profiling');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Programming Langs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Programming Languages');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Programming Techniques');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Programming Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Project Management');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Projects');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Protocols');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Public Key Infrastructure Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Publishing Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Push Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Python');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'QA Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Engines etc');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Languages');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Languages & Protocols');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Tools & Components');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Tools & Report Writers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Querying RDF Data');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'RDF');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'RDFSchemas');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'RPC Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'RSS Data');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Radio');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Radio Frequency Identification (RFID)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Raw XML for Transformation');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Real Estate');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Real Names & URI related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'RealVideo');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Rebol');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Recommendations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Recrruitment');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Relational');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Rentable Applications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Replication');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Replication & Synchronization');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Replication Technologies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Report Generation Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Report Writers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Reporting');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Reports and Analysis');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Repositories');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Articles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Directories');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Groups');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Labs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Projects');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Projects & Teams');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research articles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Researchers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Resource & Project Management');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Resource Binder Research');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Resource Description Framework (RDF)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Resource Directories');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Response Managers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Restaurant Reservations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Retail');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Retailers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Rotor');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'S390 - IBM Mainframe');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SAML');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SDKs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SDKs & Toolkits');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SET Compliant Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SGML');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SMIL Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SMS');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SMTP & MIME Data');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SOAP Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SQL');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SQL-XML');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SQL-XML Middleware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SVG');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sales Configuration Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sales Force Automation & CRM');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sample Applications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sample Apps');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sample Data');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sample Use Of Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Samples');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Samples & Demos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'San Francisco Project');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sash');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Satellite');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Scenarios & Usage');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Schema Registries');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Schemas');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Screen Capture & Demo Recording Software');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Scripting Langs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Search Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Search Engines & Web Resource Retrieval');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Secure Shells');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Security');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Security & Encryption & Cryptography');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Security & Hacking Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Semantic Agent Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Semantic Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Semantic Web');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Semantic Web Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Semiconductor & Memory Chip Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Seminars & Presentations (Webcasting)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Server Appliances');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Serverlet Technologies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Servers & Systems');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Service Bus Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Service Dicovery & Brokering');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Service Directories');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Service Location Protocol (SLP)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Service Providers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Set-Top & TV Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SetTop Box technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SetTop Boxes');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SeverLet Technologies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Shopping Cart Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Short Films Portal');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sign-On & Authentication Protocols');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Site Design');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Site Development Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Site Optimization and Analysis');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Site Ratings');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Small Business');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Small Business Suites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Small business');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Smart Card Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Smart Cards Embedding (JavaOS)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Soap Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Social Networking');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Software');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Software Distribution');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Software Distribution Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Software Updates etc');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Source Code');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Specifications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Specs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Speech');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Speech & Voice Recognition');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Speech & Writing  Recongnition Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sports');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Spreadsheet');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards & Initiatives');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards & Specifications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards & Specs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards & Standards Bodies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Bodies & Assoc');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Bodies & Consortia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Consortia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Issues');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Organizations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Specs & Consortia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards and Specs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Storage');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Storage Technology (SANS)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Storage and Query Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Store Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Stress Testing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Study Material & Samples etc');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sun');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Support');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Support Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Synchronization');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Synchronization & Replication');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Syndicates');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Syndication');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Systems & Event Management Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Systems Management Software');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'TCL Interfaces');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'TP Monitors');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'TV');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'TV Listings');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tablet PCs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Taxonomies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Team & Project Management');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technical Articles & White Papers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technical Support');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technical Support & Help Desk');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology & Terminology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology Application Case Studies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology Demo Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology Demos & Samples');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology Demos & Testbeds');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology Parks');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Telephone');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Telephony');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Telephony Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Terminal Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Test Suites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Testsuites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'The Future');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Thin Client & Network Computers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Third Party VM & Compilers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Third Party VMs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Threaded Discussion');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Time Management');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tips and Tricks');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Training');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Training Specialist Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Transaction Processing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Translation Services & Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Transport Protocols');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Travel Industry');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Troubleshooting Utilities');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Troubleshooting and Benchmark Utilities');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tutorials');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tutorials & Demos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tutorials & Learning');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tutorials Sites');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tutorials and White Papers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'UK');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'UK Players');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'UNIX');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'UNIX Driver Managers etc');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Universal Data Access Technologies');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Universal Modelling Language Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Universities (Projects)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Universities Courses');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'University Research');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'University Research & Grad Student Pages');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Use Cases');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'User Interface & Interaction');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'User Interface Definition');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Using XSL & CSS Together');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Utilities');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Utilities and Add-ins');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'VB Components');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'VPN Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Variants');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Various Schemas');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Various Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Vector Markup Language (VML)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Vendor Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Vendor Specific');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Venture Incubators');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video & Audio Streaming');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video & Audio Streaming Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video & Voice Streaming');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Blogging');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Clips & Broadcasts');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Conferencing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Conferencing & Collaboration');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Search Engines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Streaming Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video over IP');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Videos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Virtual  Labs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Virtual Component Databases');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Virtual Databases');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Virtual Machines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Virtual Machines & Compilers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visionaries & Players');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visual Bsic Specific');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visual IDEs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visual Interdev');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visual Mapping & Integration Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visualization and Drawing Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Voice');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Voice & Telephony');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Voice Infomediaries');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Voice over IP');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Voice over IP related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WAP');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WAP Clients');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WAP Development');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WIFI');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WIKIs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WIN64');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WLAN');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Wearable Computer Devices');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web  & Internet Based Artificial Intelligence');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Application Development & Solutions');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Bots and Crawlers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Content Syndicators');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Data');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Editing & Publishing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web IDEs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Innovation');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Innovations');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Management Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Page Formating and Display');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Publishing & Management Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Servers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Servers (HHTPD)');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Servers Supporting ServeLets');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Services');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Services Hosting');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Site & Application Modelling');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Site Building');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Technology Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web To DB Products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Utilities');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WebCasts');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WebDAV');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Webdav');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Webzines');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'White Paper & Articles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'White Papers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'White Papers & Articles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'White Papers & Tutorials');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'White Papers and Articles');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Whitepapers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Wikis');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Wikki');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Windows');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Windows Portability & Crossover');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Windows based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Winsock & Network Programming');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Winsock Compliant');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Wireless');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Wireless Communications');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WorkFlow Specification');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Workflow');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Workflow Technology');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Workflow and Process Integration');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Working Groups & Charters');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Works In Progress');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'X-OQL');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XBRL');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XBRL Data');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XForms');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XHTML');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XInclude');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Application & Use');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Data');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Doc Generators');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML For Analysis');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Protocols');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Query Language Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Repositories & DBs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML and RDF Frameworks');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML based Markup Languages Index');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML-HTML Conversion Tools');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML-QL');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XMLRPC Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XMLSchema');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XMlLRPC');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XPath related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XPointer related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XQL');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XSL Processors');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XSL Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XUL');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Xlink Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Zero Config Networking');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'books');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ch');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'e-commerce');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'e-mail packages');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eBook Readers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eBooks');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eBooks & ePublishing');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eCRM');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eGov');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eLibraries');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eMeetings & eDemos');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ePayment and Digicash Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eXtensible Markup Language');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ebXML');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'fiber optics');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'hip hop');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'iODBC');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'iODBC Language Interfaces');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'iodbc based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'kde');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'lua');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'mailing list information');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'middleware');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'odbc');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'odmg');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ole-db');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'open source');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'p2p based');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'portals');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'products');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'projects');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'protocols');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'scripting languages');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'specifications & consotia');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'specs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'standards');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'standards & specs');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'tcl');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'utilities');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'vXML Related');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/folderTitle', 'white papers');
TDAV_META_CHECK ('bookmarks.xml', 'http://www.python.org/topics/xml/xbel/title', 'Advanced Research');
TDAV_META_CHECK ('business_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('business_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('business_blogs.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('ceo_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('ceo_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('ceo_blogs.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('community_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('community_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('community_blogs.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('daily_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('daily_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('daily_blogs.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('ed.foaf', 'http://xmlns.com/foaf/0.1/mbox-uri', 'mailto^3afred1@example.com');
TDAV_META_CHECK ('ed.foaf', 'http://xmlns.com/foaf/0.1/name', 'Fictional Fred');
TDAV_META_CHECK ('female_bloggers.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('female_bloggers.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('female_bloggers.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('industry_news.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('industry_news.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('industry_news.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('kingsley_rss.xml', 'http://purl.org/rss/1.0/description', 'Knowledge, Information, and Data Dispatch Outlet');
TDAV_META_CHECK ('kingsley_rss.xml', 'http://purl.org/rss/1.0/lastBuildDate', '2005-04-25T21^3a12^3a20');
TDAV_META_CHECK ('kingsley_rss.xml', 'http://purl.org/rss/1.0/link', 'http^3a^2f^2fwww.openlinksw.com^3a80^2fblog^2f~kidehen^2f');
TDAV_META_CHECK ('kingsley_rss.xml', 'http://purl.org/rss/1.0/title', 'Kingsley Idehen''s Weblog');
TDAV_META_CHECK ('microsoft_bloggers.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('microsoft_bloggers.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('microsoft_bloggers.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('my_analyst_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('my_analyst_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('my_analyst_blogroll.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('my_complete_feed_list.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('my_complete_feed_list.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('my_complete_feed_list.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('my_daily_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('my_daily_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('my_daily_blogroll.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('my_journalist_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('my_journalist_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('my_journalist_blogroll.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('my_other_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('my_other_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('my_other_blogroll.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('my_semweb_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('my_semweb_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('my_semweb_blogroll.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('my_yasn_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('my_yasn_blogroll.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('my_yasn_blogroll.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('mybookmarks.xbel', 'http://www.openlinksw.com/virtdav#dynArchiver', 'XBEL');
TDAV_META_CHECK ('mybookmarks.xbel', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fxbel+xml');
TDAV_META_CHECK ('mybookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Blogs');
TDAV_META_CHECK ('mybookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OpenLink');
TDAV_META_CHECK ('mybookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Blogs');
TDAV_META_CHECK ('mybookmarks.xbel', 'http://www.python.org/topics/xml/xbel/title', 'RSS Feeds');
TDAV_META_CHECK ('openlink_internal_feeds.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('openlink_internal_feeds.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('openlink_internal_feeds.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('other_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('other_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('other_blogs.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('product_weblogs.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('product_weblogs.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('product_weblogs.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.openlinksw.com/virtdav#dynArchiver', 'XBEL');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fxbel+xml');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', '.NET Common Data Classes');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', '.Net Ports and Implementations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', '3G Wireless');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', '3rd Party Data Access Components');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'AD Creation etc.');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ADO');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ADO For Java');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ADO.NET');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'API Implementations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'APIS');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'APIS & SDKS');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'APIs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'APIs & Frameworks');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ASPZone');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Abstraction Layers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Account & Integrated Biz Systems Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Accounting');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Acquisition or Partner Prospects');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Active Server Page Components');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Active Server Pages Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ActiveX');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Advertising');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Africa Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Agent Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Agent Technology Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Aggregators');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Agriculture');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'All Inclusive Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'All Purpose Collaboration');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Animated Demo Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Animation Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Animations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Animations & Grpahics Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Anti Spam');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Apache');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'AppFoundry (Netscape App Centre)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Apple');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Applets & Applications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Appliances');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Assembly Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Demos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Design & Modelling');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Dev Frameworks');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Development');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Server & Xml ASPs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Servers & Web Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Application Service Providers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Article Annotation');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles & Essays');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles & Samples');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles & White Papers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles & Whitepapers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles and White Papers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Articles and Whitepapers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Artificial Intelligence');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Assembly environments');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Auction Prowlers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Auctions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Authoring Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Authoring and Browsing Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Auto Discovery');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Automobiles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'B2B Exchanges');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'B2B Integration');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'B2B Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'BNFs & Grammers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'BSD');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Backbone Providers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bandwidth Aggregators');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Banking');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Banner AD Utilities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bargain Searchers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Barter Sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bash');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Benchmark Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Benchmark Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Benchmarking');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Benchmarks');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Berlin - GUI & DOM & CORBA');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bibliography');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Biologial Warfare');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Biometrics');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Biotechnology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Blog Databases ');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Blog Search Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Blogging & WebLogs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bluetooth');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bookmark & Favorites Handling');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bookmarking & Tagging');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bookmarklets');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bookmarks Formats');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bookmarks Storage');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Books');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Brazil (Sun)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Broadcasters');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Broadcasting');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Browser Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Browsers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Bulk E-mail Packages');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Busines to Consumer');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Activity Monitoring');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Integration Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Networking');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Oriented');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Process Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Processing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business Rules & Inference Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business To Business');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Business To Consumer (B2C)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'C & C++');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'C Development');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'C and C++');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'CD-ROM & DVD Dupliaction');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'CLR Ports (.NET)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'CRM & SFA Focused');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'CRM & SFA Solutions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendar & Scheduling');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendar Data Storage');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendar Diary Discussion  and Folders');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendaring');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendering');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendering & Group Scheduling');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Calendering & Scheduling');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Case Studies - Succcessful Projects');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Catalog  & Merchant Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Catalog Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Chat & Instant Messaging');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Class Libraries');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Classification Schemes');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Client  Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Clients');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Clothing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Clustering');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Clustering Oriented');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Code & Algorithms');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Code Factories (International)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Collaboration');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Collaboration & Analysis');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Collaboration Products & Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Collaborative Information Filtering');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Commercial');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Commercial Sites Generated By Blogware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Comms Layers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Communities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Community');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Companies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Company & Software Developer Matching Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Company Position Papers and Statements');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Comparative Analysis');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Competitive Analysis');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Competitor or Co-opetitor Roadmaps');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Compiler Construction & Meta Lang Assemblers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Compilers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Complaint Data Sources');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Compliance & Stress Testing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Compliant Browsers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Compliant Tools & Compilers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Component DBs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Components');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Componentware & Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Computer Fabrics related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Computer Telephony Integration');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Computers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Configuration MGMT');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Connectivity');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Consortia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Consultant Directories');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Consumer Food & Beverages');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Consumer Opinion & Disccusion');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Consumer To Consumer');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Contact Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Contacts Storage (vCard)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content - Directories & Encylopedia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Archives');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Integration Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Management & Syndication');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Content Syndication & Aggregation');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Conversation & Bibliographic Tagging');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Applications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Blogs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Demos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Examples');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Platforms & Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Cool Web Services Consumer Apps & Add-ins');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Course Developers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Courseware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Currency & Cash');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Custom Books and Documenation');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customer Asset Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customer Asset Management & E-Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customer Asset Mgmt. & SFA');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customer Service');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customer Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Customization Techniques');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DB Admin Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DB Application RAD Environements');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DB Based File systems & Commom Data Sorage');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DB Front-Ends');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DCOM');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DNS Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DOM');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DSL');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DTDs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data  Access Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access & Data Exchange');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access & ODBC');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access Abstraction Layers & APIs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access Components');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access Middleware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access Network Layers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Access Query & Management Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Admin Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Backup & Recovery Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Capture & Exchange Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Carrier Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Driven  Animation Tools (ODBC or JDBC)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Encryption & Security');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Feeds');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Mining');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Modelling Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Providers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Storage');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Storage & File Sharing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Storage (Web Briefcase)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Transmission');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Visualization');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Visualization & Modelling Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Data Warehousing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database & Data Access Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database & Search Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database APIs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Connectivity');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Driven');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Engine');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database IDEs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Middleware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Database to Database');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Databases');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Databases General');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dedicated Hardware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dedicated XML Information Sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Deductive & Other New Format Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Delivery and Personal Assistance');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Demo Applications (Complete Solutions)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Demos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Demos & Tutorials');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Design & Modelling Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Design Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Desktop');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Desktop & Window Managers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Desktop Productivity Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Desktop Productivity Tools - Office etc');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Desktop applications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'DevX Articles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Developer Sources');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Developer Specific');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Developer Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Development');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Development & Integration Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Development Libraries');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Development Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Development Tools & Components');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Devices');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dictionaries & Encylopedia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital  Books & Publishing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Asset Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Entertainement');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Formas & Codecs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital IDs & Certificates Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Identities Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Imaging');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Libraries');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Music');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Rights Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital UNIX');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Digital Video Cameras');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Directories');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Directory Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion & Collaboration');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion & News Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion Clients');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion Forum & News Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion Forums');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion Forums Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Discussion Services (NNTP etc..)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Display Devices');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Display Devices (Monitors etc.)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Display Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Display Technology''');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distribubted Computing (CORBA Based)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributed Components Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributed Computing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributed Database Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributed IPCs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributed Transactions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distribution');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Distributions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Documentation & KBASE Projects');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Drivers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Drivers & Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dublin Core Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dynamic DB Driven Web Middleware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dynamic HTML');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dynamic Service Discovry & UDDI Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Dynamic XML');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-Business');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-Commerce');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-Commerce & Biz related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-Commerce Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-Tailing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-business');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-commerce');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-mail');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-mail Marketing & Mail Merge');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-mail Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'E-mail Spec');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'EAI');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ECMA');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'EII ');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ERP  Systems');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ETL and Replication');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Editors');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Electronic Ink');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Electronic Stock Trading Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Email');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Email Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Embedded');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Embedded DB Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Encoding Schemes');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Encryption - Technology & Export Rules');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Encryption Technologies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Encyclopedia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Engine Implmentations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Engine Models');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'English Language');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Enterprise Application Integration');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Enterprise GroupWare');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Enterprise Information Portal Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Enterprise Information Portals');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Enterprise Java Beans');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Entertainment');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Environments');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Ethernet');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Event Planning');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Examples & Practical Use');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Exchange Building Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Eye');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'FAQs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'FOAF');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'FTP Clients');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Facial');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Fashion');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Fashion Retail');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Feed Generators');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Fiberless Optics');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'File Sharing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'File System Driver Development');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'File Systems');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'File Systems & Server Devices');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Files System & Sharing Protocols');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Filtering Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Finance & Corporate Information');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Finance & Reporting');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Finance Industry Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Finger Prints');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Firewall Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Flash');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Flash Based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Food & Groceries');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Frameworks');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Frameworks & Environments');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Frameworks and SDKs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Frameworks etc');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Free ORB Directory');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Free Source Code');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Free with Source');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Free-Space-Optics');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Freedom & Free Speech etc');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Fulfillment  Processing Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Futuristic Visions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GUI');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GUI Application Tools & Technologies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GUI Toolkits & Frameworks');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GUI and Human-Computer Interaction');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GUI related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Game Consoles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Games');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General - CTO Level');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General Information');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General Java Information Sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General TV');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'General XML related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Genetics');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Geography');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Glossaries');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Gnome');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Graphical User Interfaces');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Graphics');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Graphics & Animation & 3D Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Graphics Related - Very Cool');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Grid Computing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Group Development & Testing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'GroupWare');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HOWTOS');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HR');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HTML Based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HTML Editors & Publishing Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HTML UI');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HTML for Conversion');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HTTP Protocol Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Handhelds');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Handhelds & PDAs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Handsets');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Handwriting');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hardware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hardware Providers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Healthcare');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HelpDesk');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HelpDesk & CRM');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Helpdesk');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Helpdesk & Support');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'High Level Dev. Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'High Level Object Languages');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'High Tech');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'High-Tech');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'High-Tech Equipment Companies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'History');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Home');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Home Appliances');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Home Furniture');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted Applications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted Communities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted Solutions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hosted Solutions (ASP Model)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'HotSpots');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'How To Docs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hubs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Human Interface');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Human Resource Management etc');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Hypertext Systems');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IBM');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IDES');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IDEs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IETF Protocols');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IP Based Telephony');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IRIX');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'IVR Solutions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Immunology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Independent Artists');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Independent Films');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Indexing & Search Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'India');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Industry Players');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Industry Specific');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Inferno');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Info Directories');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Info Sources');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information & Intelligent Consumer Electronics');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Appliances');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Appliances - Thin Clients');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Application & Retrieval Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Casting');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Casting & Retrieval');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Directories');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Mediation & Dissemination');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Search');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Information Sources');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Infrastructure Providers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Infrastructure Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Initiatives and Specifications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Initiatives of Interest');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Innovative Solutions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Installer Programs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Installer Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Instant Messaging');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Instant Messaging Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Instant Messaging Software');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Insurance');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Integrated Development Environments (IDEs)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Integration Servers (Middleware)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Intelligent Devices');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Interesting Database Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Interesting WIKIs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internationalization');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internationalization and Localization');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Appliances & Technologies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Assistants');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Commerce');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Infrastructure Technology & Providers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Interactivity - Realtime Chat & User Discovery Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Internet Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Intranet Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Intranet Solutions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Intranet Suites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JDBC');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JDBC Aware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JDBC Based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JDBC Based Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JDBC v ADO Technical Comparisons');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'JSP Engine');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Jav Bean Generation');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java & New Generation');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java Based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java Based Technologies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java Developers Journal Code Library');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java ServLet Containers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Java based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Javascript Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Journal & Publishing Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Journals & Publishing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Key Contact Web Sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Key Personalities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Key Researchers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Knowledge & Information & Agent Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Knowledge & Information Casting & Corporate Portal Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Knowledge & Information Processing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Knowledge-Information-Metadata');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Knowledgebases & Agent Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'LDAP');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'LDAP Classes');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Labs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Language Comparisons (Java n Python)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Lead Sources');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Legacy Application Logic for Conversion');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Licence Enforcement Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Licensing Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Life Style');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Linux');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Linux Based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Linux based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Linux on CDROM');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Locator Portals');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Lookup Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MP3 - Music over NET Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MP3 Casting and Content Production');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MP3 Players');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MP3 search Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MPEG-4');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MPEG-7');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mac OS X Based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MacOS');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mach');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Macintosh');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Macintosh 68K Versions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mag Articles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mail');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mail Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mail Transfer Agents (MTAs)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mail to SMS Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mapping & GIS');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Maps & Catography');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Market Analysis');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Market Research');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Marketing Automation Software');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Marketing Presntations Portals');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Markup Languages');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Meeting Facilitators (Face to Face)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Merchant Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Message Oriented Middleware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Messaging');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Metadata');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Metadata & Resource Definition Framework (RDF)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Metadatea Specs & Consortia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Methodology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft Articles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft Java APIs & SDKs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft Provided');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft.NET');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Microsoft.NET Demos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Middleware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Middleware and Management Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mixed Data Access Mechanisms');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mixing Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mixtapes');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Calendar Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Computing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Enterprise');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Network Providers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Office Solutions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mobile Players for Cars');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Modeling (XML Vocabularies, Data, and Systems)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Modelling Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mono');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mortgages & Loans');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Movie Creation');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Movie Industry');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Movies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Movies Database');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Mozilla');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Multi Purpose');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Multimedia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Multimedia & Graphics');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Multimedia Appliances');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Multimedia Sharing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Music');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Music Databases');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Music Industry');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MySQL');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MySQL Based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'MySQL Specific');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'NIC Drivers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'NNTP Clients');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'NNTP Clients & Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'NNTP Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Naming & Directory Interface (JNDI)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Native Based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Native XML Databases');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Natural Language Processing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Natural Language Query Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Natural Language Query Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Net Conferencing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Net Life Style');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Netcasting');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Netscape');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Network Computers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Network Diagnostic Utilities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Network Management & Design Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Network Monitoring');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Network Programming Matters');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Networking');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Networking Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Networks');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'New Media');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'New Media Broadcasting');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'New Media Innovations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'New Product Ideas');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'New Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'News');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'News Collection & Distribution');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'News Delivery & Exchange');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'News Specific Crawlers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Newton');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Next Generation Computer Interconnects');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Nokia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Notations and Style');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OCS Data');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ODBC Based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OLAP');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OLAP Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OLE DB related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OLE-DB');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OMG Papers (New OMA Architecture)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OMG Specs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ORBS');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OS390');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object Databases');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object Description Language');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object Frameworks & APIs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object Modelling Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object Request Brokers & Technologies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object-Relational');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Object-Relational Mappers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Offshore');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Offshore Development Companies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Ad Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Demos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Gaming');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Labs & Compile Farms');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Record Companies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Research Labs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Trading');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online Training');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Online demos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Ontologies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Ontology Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open APIs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Directories');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Software & GNU World');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Software Desc (ODS) Spec - Push & Replication');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Source');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Source Projects');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open Source Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Open source');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'OpenVMS');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Operating Environments');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Operating Environments (VMs)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Operating Systems');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Operational Resource Management (ORM)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Optical Character Reconition');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Optical Networking');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Oracle');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Organizations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Organizations & Consortia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Other DB Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Other Projects');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Others');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'P2P Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PABX');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PC Cards');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PCs & Workstations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PDA & Embedded DB Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PDA & Embedded Edition Kernel Ports');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PDA Applications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PDA related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PDAs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PERL Interfaces');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PPC Version');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PR');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'PThreads');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Parallel Programming Technology & Issues');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Parser Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Parsers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Parsers & Compilers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Patent Monitoring Sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Patents');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Payment Processing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Payment Processing & E-Currency');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Peer to Peer');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Peer-Peer Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Pen Like Devices');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Perl');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Perl DBI');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Personal & Small Business Site Building');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Personal Networking');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Personalities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Pharmaceuticals & Drug Stores');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Phones');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Photo Sharing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Photos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Photos & Digital Art');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Players');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Podcasting');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Polls and Surveys');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Portability & Binary Interface Standards');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Portability kits');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Portable Players');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Portal (All in One)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Portals');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Ports');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Potential Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Presentations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Presentations & Demos - Video Streaming');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Presentations & White Papers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Privacy Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Processor Architectures');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Processor Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Processors');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Product Comparisons');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Product Directories');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Product Directory');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Product Reviews');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Production Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Products & API Implementations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Professional Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Profiling');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Programming Langs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Programming Languages');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Programming Techniques');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Programming Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Project Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Projects');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Protocols');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Public Key Infrastructure Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Publishing Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Push Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Python');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'QA Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Engines etc');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Languages');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Languages & Protocols');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Tools & Components');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Query Tools & Report Writers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Querying RDF Data');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'RDF');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'RDFSchemas');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'RPC Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'RSS Data');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Radio');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Radio Frequency Identification (RFID)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Raw XML for Transformation');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Real Estate');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Real Names & URI related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'RealVideo');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Rebol');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Recommendations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Recrruitment');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Relational');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Rentable Applications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Replication');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Replication & Synchronization');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Replication Technologies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Report Generation Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Report Writers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Reporting');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Reports and Analysis');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Repositories');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Articles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Directories');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Groups');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Labs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Projects');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Projects & Teams');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research Sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research articles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Research sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Researchers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Resource & Project Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Resource Binder Research');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Resource Description Framework (RDF)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Resource Directories');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Response Managers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Restaurant Reservations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Retail');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Retailers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Rotor');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'S390 - IBM Mainframe');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SAML');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SDKs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SDKs & Toolkits');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SET Compliant Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SGML');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SMIL Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SMS');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SMTP & MIME Data');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SOAP Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SQL');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SQL-XML');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SQL-XML Middleware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SVG');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sales Configuration Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sales Force Automation & CRM');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sample Applications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sample Apps');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sample Data');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sample Use Of Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Samples');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Samples & Demos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'San Francisco Project');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sash');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Satellite');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Scenarios & Usage');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Scheduling & Task Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Schema Registries');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Schemas');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Screen Capture & Demo Recording Software');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Scripting Langs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Search Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Search Engines & Web Resource Retrieval');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Secure Shells');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Security');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Security & Encryption & Cryptography');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Security & Hacking Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Semantic Agent Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Semantic Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Semantic Web');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Semantic Web Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Semiconductor & Memory Chip Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Seminars & Presentations (Webcasting)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Server Appliances');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Serverlet Technologies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Servers & Systems');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Service Bus Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Service Dicovery & Brokering');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Service Directories');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Service Location Protocol (SLP)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Service Providers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Set-Top & TV Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SetTop Box technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SetTop Boxes');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'SeverLet Technologies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Shopping Cart Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Short Films Portal');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sign-On & Authentication Protocols');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Site Design');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Site Development Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Site Optimization and Analysis');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Site Ratings');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Small Business');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Small Business Suites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Small business');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Smart Card Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Smart Cards Embedding (JavaOS)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Soap Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Social Networking');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Software');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Software Distribution');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Software Distribution Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Software Updates etc');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Source Code');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Specifications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Specs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Speech');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Speech & Voice Recognition');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Speech & Writing  Recongnition Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sports');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Spreadsheet');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards & Initiatives');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards & Specifications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards & Specs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards & Standards Bodies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Bodies & Assoc');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Bodies & Consortia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Consortia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Issues');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Organizations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards Specs & Consortia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Standards and Specs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Storage');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Storage Technology (SANS)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Storage and Query Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Store Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Stress Testing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Study Material & Samples etc');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Stylesheets Library');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Sun');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Support');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Support Sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Synchronization');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Synchronization & Replication');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Syndicates');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Syndication');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Systems & Event Management Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Systems Management Software');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'TCL Interfaces');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'TP Monitors');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'TV');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'TV Listings');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tablet PCs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Taxonomies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Team & Project Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technical Articles & White Papers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technical Support');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technical Support & Help Desk');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology & Terminology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology Application Case Studies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology Demo Sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology Demos & Samples');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology Demos & Testbeds');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Technology Parks');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Telephone');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Telephony');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Telephony Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Terminal Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Test Suites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Testsuites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'The Future');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Thin Client & Network Computers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Third Party VM & Compilers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Third Party VMs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Threaded Discussion');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Time Management');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tips and Tricks');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Training');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Training Specialist Sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Transaction Processing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Translation Services & Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Transport Protocols');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Travel Industry');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Triple Storage Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Troubleshooting Utilities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Troubleshooting and Benchmark Utilities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tutorials');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tutorials & Demos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tutorials & Learning');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tutorials Sites');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Tutorials and White Papers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'UK');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'UK Players');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'UNIX');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'UNIX Driver Managers etc');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Universal Data Access Technologies');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Universal Modelling Language Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Universities (Projects)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Universities Courses');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'University Research');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'University Research & Grad Student Pages');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Use Cases');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'User Interface & Interaction');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'User Interface Definition');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Using XSL & CSS Together');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Utilities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Utilities and Add-ins');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'VB Components');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'VPN Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Variants');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Various Schemas');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Various Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Vector Markup Language (VML)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Vendor Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Vendor Specific');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Venture Incubators');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video & Audio Streaming');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video & Audio Streaming Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video & Voice Streaming');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Blogging');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Clips & Broadcasts');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Conferencing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Conferencing & Collaboration');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Search Engines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Sharing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video Streaming Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Video over IP');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Videos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Virtual  Labs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Virtual Component Databases');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Virtual Databases');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Virtual Machines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Virtual Machines & Compilers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visionaries & Players');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visual Bsic Specific');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visual IDEs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visual Interdev');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visual Mapping & Integration Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Visualization and Drawing Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Voice');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Voice & Telephony');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Voice Infomediaries');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Voice over IP');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Voice over IP related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WAP');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WAP Clients');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WAP Development');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WIFI');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WIKIs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WIN64');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WLAN');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Wearable Computer Devices');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web  & Internet Based Artificial Intelligence');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Application Development & Solutions');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Bots and Crawlers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Content Syndicators');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Data');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Editing & Publishing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web IDEs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Innovation');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Innovations');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Management Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Page Formating and Display');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Publishing & Management Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Servers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Servers (HHTPD)');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Servers Supporting ServeLets');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Services');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Services Hosting');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Site & Application Modelling');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Site Building');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Statistics');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Technology Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web To DB Products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Web Utilities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WebCasts');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WebDAV');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Webdav');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Webzines');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'White Paper & Articles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'White Papers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'White Papers & Articles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'White Papers & Tutorials');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'White Papers and Articles');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Whitepapers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Wikis');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Wikki');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Windows');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Windows Portability & Crossover');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Windows based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Winsock & Network Programming');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Winsock Compliant');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Wireless');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Wireless Communications');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'WorkFlow Specification');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Workflow');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Workflow Technology');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Workflow and Process Integration');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Working Groups & Charters');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Works In Progress');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'X-OQL');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XBRL');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XBRL Data');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XForms');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XHTML');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XInclude');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Application & Use');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Data');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Doc Generators');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML For Analysis');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Protocols');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Query Language Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML Repositories & DBs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML and RDF Frameworks');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML based Markup Languages Index');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML-HTML Conversion Tools');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XML-QL');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XMLRPC Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XMLSchema');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XMlLRPC');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XPath related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XPointer related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XQL');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XSL Processors');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XSL Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'XUL');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Xlink Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'Zero Config Networking');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'books');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ch');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'e-commerce');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'e-mail packages');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eBook Readers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eBooks');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eBooks & ePublishing');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eCRM');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eGov');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eLibraries');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eMeetings & eDemos');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ePayment and Digicash Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'eXtensible Markup Language');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ebXML');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'fiber optics');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'hip hop');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'iODBC');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'iODBC Language Interfaces');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'iodbc based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'kde');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'lua');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'mailing list information');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'middleware');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'odbc');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'odmg');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'ole-db');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'open source');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'p2p based');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'portals');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'products');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'projects');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'protocols');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'scripting languages');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'specifications & consotia');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'specs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'standards');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'standards & specs');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'tcl');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'utilities');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'vXML Related');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/folderTitle', 'white papers');
TDAV_META_CHECK ('technology_bookmarks.xbel', 'http://www.python.org/topics/xml/xbel/title', 'Advanced Research');
TDAV_META_CHECK ('vc_bloggers.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('vc_bloggers.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('vc_bloggers.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('weblogs_I_follow.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('weblogs_I_follow.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('weblogs_I_follow.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
TDAV_META_CHECK ('yasn_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#ownerName', 'Unknown OPML owner');
TDAV_META_CHECK ('yasn_blogs.opml', 'http://www.openlinksw.com/schemas/OPML#title', 'Untitled OPML');
TDAV_META_CHECK ('yasn_blogs.opml', 'http://www.openlinksw.com/virtdav#dynRdfExtractor', 'application^2fopml+xml');
