//
// Copyright 2024 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: global_regs_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // COMPAT_NUM_REG         : 0x0 (x4xx_global_regs.v)
  // DATESTAMP_REG          : 0x4 (x4xx_global_regs.v)
  // GIT_HASH_REG           : 0x8 (x4xx_global_regs.v)
  // SCRATCH_REG            : 0xC (x4xx_global_regs.v)
  // DEVICE_ID_REG          : 0x10 (x4xx_global_regs.v)
  // RFNOC_INFO_REG         : 0x14 (x4xx_global_regs.v)
  // CLOCK_CTRL_REG         : 0x18 (x4xx_global_regs.v)
  // PPS_CTRL_REG           : 0x1C (x4xx_global_regs.v)
  // CHDR_CLK_RATE_REG      : 0x20 (x4xx_global_regs.v)
  // CHDR_CLK_COUNT_REG     : 0x24 (x4xx_global_regs.v)
  // BUILD_SEED_REG         : 0x28 (x4xx_global_regs.v)
  // PPS_CROSSING_REG       : 0x30 (x4xx_global_regs.v)
  // GPS_CTRL_REG           : 0x38 (x4xx_global_regs.v)
  // GPS_STATUS_REG         : 0x3C (x4xx_global_regs.v)
  // DBOARD_CTRL_REG        : 0x40 (x4xx_global_regs.v)
  // DBOARD_STATUS_REG      : 0x44 (x4xx_global_regs.v)
  // NUM_TIMEKEEPERS_REG    : 0x48 (x4xx_global_regs.v)
  // SERIAL_NUM_LOW_REG     : 0x4C (x4xx_global_regs.v)
  // SERIAL_NUM_HIGH_REG    : 0x50 (x4xx_global_regs.v)
  // MFG_TEST_CTRL_REG      : 0x54 (x4xx_global_regs.v)
  // MFG_TEST_STATUS_REG    : 0x58 (x4xx_global_regs.v)
  // QSFP_PORT_0_0_INFO_REG : 0x60 (x4xx_global_regs.v)
  // QSFP_PORT_0_1_INFO_REG : 0x64 (x4xx_global_regs.v)
  // QSFP_PORT_0_2_INFO_REG : 0x68 (x4xx_global_regs.v)
  // QSFP_PORT_0_3_INFO_REG : 0x6C (x4xx_global_regs.v)
  // QSFP_PORT_1_0_INFO_REG : 0x70 (x4xx_global_regs.v)
  // QSFP_PORT_1_1_INFO_REG : 0x74 (x4xx_global_regs.v)
  // QSFP_PORT_1_2_INFO_REG : 0x78 (x4xx_global_regs.v)
  // QSFP_PORT_1_3_INFO_REG : 0x7C (x4xx_global_regs.v)
  // DEVICE_DNA0_REG        : 0x100 (x4xx_global_regs.v)
  // DEVICE_DNA1_REG        : 0x104 (x4xx_global_regs.v)
  // DEVICE_DNA2_REG        : 0x108 (x4xx_global_regs.v)

//===============================================================================
// RegTypes
//===============================================================================

//===============================================================================
// Register Group GLOBAL_REGS
//===============================================================================

  // COMPAT_NUM_REG Register (from x4xx_global_regs.v)
  localparam COMPAT_NUM_REG = 'h0; // Register Offset
  localparam COMPAT_NUM_REG_SIZE = 32;  // register width in bits
  localparam COMPAT_NUM_REG_MASK = 32'hFFFFFFFF;
  localparam COMPAT_MINOR_SIZE = 16;  //COMPAT_NUM_REG:COMPAT_MINOR
  localparam COMPAT_MINOR_MSB  = 15;  //COMPAT_NUM_REG:COMPAT_MINOR
  localparam COMPAT_MINOR      =  0;  //COMPAT_NUM_REG:COMPAT_MINOR
  localparam COMPAT_MAJOR_SIZE = 16;  //COMPAT_NUM_REG:COMPAT_MAJOR
  localparam COMPAT_MAJOR_MSB  = 31;  //COMPAT_NUM_REG:COMPAT_MAJOR
  localparam COMPAT_MAJOR      = 16;  //COMPAT_NUM_REG:COMPAT_MAJOR

  // DATESTAMP_REG Register (from x4xx_global_regs.v)
  localparam DATESTAMP_REG = 'h4; // Register Offset
  localparam DATESTAMP_REG_SIZE = 32;  // register width in bits
  localparam DATESTAMP_REG_MASK = 32'hFFFFFFFF;
  localparam SECONDS_SIZE = 6;  //DATESTAMP_REG:SECONDS
  localparam SECONDS_MSB  = 5;  //DATESTAMP_REG:SECONDS
  localparam SECONDS      = 0;  //DATESTAMP_REG:SECONDS
  localparam MINUTES_SIZE =  6;  //DATESTAMP_REG:MINUTES
  localparam MINUTES_MSB  = 11;  //DATESTAMP_REG:MINUTES
  localparam MINUTES      =  6;  //DATESTAMP_REG:MINUTES
  localparam HOUR_SIZE =  5;  //DATESTAMP_REG:HOUR
  localparam HOUR_MSB  = 16;  //DATESTAMP_REG:HOUR
  localparam HOUR      = 12;  //DATESTAMP_REG:HOUR
  localparam YEAR_SIZE =  6;  //DATESTAMP_REG:YEAR
  localparam YEAR_MSB  = 22;  //DATESTAMP_REG:YEAR
  localparam YEAR      = 17;  //DATESTAMP_REG:YEAR
  localparam MONTH_SIZE =  4;  //DATESTAMP_REG:MONTH
  localparam MONTH_MSB  = 26;  //DATESTAMP_REG:MONTH
  localparam MONTH      = 23;  //DATESTAMP_REG:MONTH
  localparam DAY_SIZE =  5;  //DATESTAMP_REG:DAY
  localparam DAY_MSB  = 31;  //DATESTAMP_REG:DAY
  localparam DAY      = 27;  //DATESTAMP_REG:DAY

  // GIT_HASH_REG Register (from x4xx_global_regs.v)
  localparam GIT_HASH_REG = 'h8; // Register Offset
  localparam GIT_HASH_REG_SIZE = 32;  // register width in bits
  localparam GIT_HASH_REG_MASK = 32'h0;

  // SCRATCH_REG Register (from x4xx_global_regs.v)
  localparam SCRATCH_REG = 'hC; // Register Offset
  localparam SCRATCH_REG_SIZE = 32;  // register width in bits
  localparam SCRATCH_REG_MASK = 32'h0;

  // DEVICE_ID_REG Register (from x4xx_global_regs.v)
  localparam DEVICE_ID_REG = 'h10; // Register Offset
  localparam DEVICE_ID_REG_SIZE = 32;  // register width in bits
  localparam DEVICE_ID_REG_MASK = 32'h8000FFFF;
  localparam DEVICE_ID_SIZE = 16;  //DEVICE_ID_REG:DEVICE_ID
  localparam DEVICE_ID_MSB  = 15;  //DEVICE_ID_REG:DEVICE_ID
  localparam DEVICE_ID      =  0;  //DEVICE_ID_REG:DEVICE_ID
  localparam PCIE_PRESENT_BIT_SIZE =  1;  //DEVICE_ID_REG:PCIE_PRESENT_BIT
  localparam PCIE_PRESENT_BIT_MSB  = 31;  //DEVICE_ID_REG:PCIE_PRESENT_BIT
  localparam PCIE_PRESENT_BIT      = 31;  //DEVICE_ID_REG:PCIE_PRESENT_BIT

  // RFNOC_INFO_REG Register (from x4xx_global_regs.v)
  localparam RFNOC_INFO_REG = 'h14; // Register Offset
  localparam RFNOC_INFO_REG_SIZE = 32;  // register width in bits
  localparam RFNOC_INFO_REG_MASK = 32'hFFFFFFFF;
  localparam RFNOC_PROTO_MINOR_SIZE = 8;  //RFNOC_INFO_REG:RFNOC_PROTO_MINOR
  localparam RFNOC_PROTO_MINOR_MSB  = 7;  //RFNOC_INFO_REG:RFNOC_PROTO_MINOR
  localparam RFNOC_PROTO_MINOR      = 0;  //RFNOC_INFO_REG:RFNOC_PROTO_MINOR
  localparam RFNOC_PROTO_MAJOR_SIZE =  8;  //RFNOC_INFO_REG:RFNOC_PROTO_MAJOR
  localparam RFNOC_PROTO_MAJOR_MSB  = 15;  //RFNOC_INFO_REG:RFNOC_PROTO_MAJOR
  localparam RFNOC_PROTO_MAJOR      =  8;  //RFNOC_INFO_REG:RFNOC_PROTO_MAJOR
  localparam CHDR_WIDTH_SIZE = 16;  //RFNOC_INFO_REG:CHDR_WIDTH
  localparam CHDR_WIDTH_MSB  = 31;  //RFNOC_INFO_REG:CHDR_WIDTH
  localparam CHDR_WIDTH      = 16;  //RFNOC_INFO_REG:CHDR_WIDTH

  // CLOCK_CTRL_REG Register (from x4xx_global_regs.v)
  localparam CLOCK_CTRL_REG = 'h18; // Register Offset
  localparam CLOCK_CTRL_REG_SIZE = 32;  // register width in bits
  localparam CLOCK_CTRL_REG_MASK = 32'hFFFF033F;
  localparam PPS_SELECT_SIZE = 2;  //CLOCK_CTRL_REG:PPS_SELECT
  localparam PPS_SELECT_MSB  = 1;  //CLOCK_CTRL_REG:PPS_SELECT
  localparam PPS_SELECT      = 0;  //CLOCK_CTRL_REG:PPS_SELECT
    localparam PPS_ENUM_SIZE = 3;
    localparam PPS_INT_25MHZ  = 'h0;  // enum value
    localparam PPS_INT_10MHZ  = 'h1;  // enum value
    localparam PPS_EXT        = 'h2;  // enum value
  localparam REF_SELECT_SIZE = 1;  //CLOCK_CTRL_REG:REF_SELECT
  localparam REF_SELECT_MSB  = 2;  //CLOCK_CTRL_REG:REF_SELECT
  localparam REF_SELECT      = 2;  //CLOCK_CTRL_REG:REF_SELECT
  localparam REFCLK_LOCKED_SIZE = 1;  //CLOCK_CTRL_REG:REFCLK_LOCKED
  localparam REFCLK_LOCKED_MSB  = 3;  //CLOCK_CTRL_REG:REFCLK_LOCKED
  localparam REFCLK_LOCKED      = 3;  //CLOCK_CTRL_REG:REFCLK_LOCKED
  localparam TRIGGER_IO_SELECT_SIZE = 2;  //CLOCK_CTRL_REG:TRIGGER_IO_SELECT
  localparam TRIGGER_IO_SELECT_MSB  = 5;  //CLOCK_CTRL_REG:TRIGGER_IO_SELECT
  localparam TRIGGER_IO_SELECT      = 4;  //CLOCK_CTRL_REG:TRIGGER_IO_SELECT
    localparam TRIG_IO_ENUM_SIZE = 2;
    localparam TRIG_IO_INPUT       = 'h0;  // enum value
    localparam TRIG_IO_PPS_OUTPUT  = 'h1;  // enum value
  localparam PLL_SYNC_TRIGGER_SIZE = 1;  //CLOCK_CTRL_REG:PLL_SYNC_TRIGGER
  localparam PLL_SYNC_TRIGGER_MSB  = 8;  //CLOCK_CTRL_REG:PLL_SYNC_TRIGGER
  localparam PLL_SYNC_TRIGGER      = 8;  //CLOCK_CTRL_REG:PLL_SYNC_TRIGGER
  localparam PLL_SYNC_DONE_SIZE = 1;  //CLOCK_CTRL_REG:PLL_SYNC_DONE
  localparam PLL_SYNC_DONE_MSB  = 9;  //CLOCK_CTRL_REG:PLL_SYNC_DONE
  localparam PLL_SYNC_DONE      = 9;  //CLOCK_CTRL_REG:PLL_SYNC_DONE
  localparam PLL_SYNC_DELAY_SIZE =  8;  //CLOCK_CTRL_REG:PLL_SYNC_DELAY
  localparam PLL_SYNC_DELAY_MSB  = 23;  //CLOCK_CTRL_REG:PLL_SYNC_DELAY
  localparam PLL_SYNC_DELAY      = 16;  //CLOCK_CTRL_REG:PLL_SYNC_DELAY
  localparam PPS_BRC_DELAY_SIZE =  8;  //CLOCK_CTRL_REG:PPS_BRC_DELAY
  localparam PPS_BRC_DELAY_MSB  = 31;  //CLOCK_CTRL_REG:PPS_BRC_DELAY
  localparam PPS_BRC_DELAY      = 24;  //CLOCK_CTRL_REG:PPS_BRC_DELAY

  // PPS_CTRL_REG Register (from x4xx_global_regs.v)
  localparam PPS_CTRL_REG = 'h1C; // Register Offset
  localparam PPS_CTRL_REG_SIZE = 32;  // register width in bits
  localparam PPS_CTRL_REG_MASK = 32'h83FFFFFF;
  localparam PPS_PRC_DELAY_SIZE = 26;  //PPS_CTRL_REG:PPS_PRC_DELAY
  localparam PPS_PRC_DELAY_MSB  = 25;  //PPS_CTRL_REG:PPS_PRC_DELAY
  localparam PPS_PRC_DELAY      =  0;  //PPS_CTRL_REG:PPS_PRC_DELAY
  localparam PPS_RC_ENABLED_SIZE =  1;  //PPS_CTRL_REG:PPS_RC_ENABLED
  localparam PPS_RC_ENABLED_MSB  = 31;  //PPS_CTRL_REG:PPS_RC_ENABLED
  localparam PPS_RC_ENABLED      = 31;  //PPS_CTRL_REG:PPS_RC_ENABLED

  // CHDR_CLK_RATE_REG Register (from x4xx_global_regs.v)
  localparam CHDR_CLK_RATE_REG = 'h20; // Register Offset
  localparam CHDR_CLK_RATE_REG_SIZE = 32;  // register width in bits
  localparam CHDR_CLK_RATE_REG_MASK = 32'hFFFFFFFF;
  localparam CHDR_CLK_SIZE = 32;  //CHDR_CLK_RATE_REG:CHDR_CLK
  localparam CHDR_CLK_MSB  = 31;  //CHDR_CLK_RATE_REG:CHDR_CLK
  localparam CHDR_CLK      =  0;  //CHDR_CLK_RATE_REG:CHDR_CLK

  // CHDR_CLK_COUNT_REG Register (from x4xx_global_regs.v)
  localparam CHDR_CLK_COUNT_REG = 'h24; // Register Offset
  localparam CHDR_CLK_COUNT_REG_SIZE = 32;  // register width in bits
  localparam CHDR_CLK_COUNT_REG_MASK = 32'h0;

  // BUILD_SEED_REG Register (from x4xx_global_regs.v)
  localparam BUILD_SEED_REG = 'h28; // Register Offset
  localparam BUILD_SEED_REG_SIZE = 32;  // register width in bits
  localparam BUILD_SEED_REG_MASK = 32'h0;

  // PPS_CROSSING_REG Register (from x4xx_global_regs.v)
  localparam PPS_CROSSING_REG = 'h30; // Register Offset
  localparam PPS_CROSSING_REG_SIZE = 32;  // register width in bits
  localparam PPS_CROSSING_REG_MASK = 32'h1F001F;
  localparam PRC_RC0_DIVIDER_SIZE = 5;  //PPS_CROSSING_REG:PRC_RC0_DIVIDER
  localparam PRC_RC0_DIVIDER_MSB  = 4;  //PPS_CROSSING_REG:PRC_RC0_DIVIDER
  localparam PRC_RC0_DIVIDER      = 0;  //PPS_CROSSING_REG:PRC_RC0_DIVIDER
  localparam PRC_RC1_DIVIDER_SIZE =  5;  //PPS_CROSSING_REG:PRC_RC1_DIVIDER
  localparam PRC_RC1_DIVIDER_MSB  = 20;  //PPS_CROSSING_REG:PRC_RC1_DIVIDER
  localparam PRC_RC1_DIVIDER      = 16;  //PPS_CROSSING_REG:PRC_RC1_DIVIDER

  // GPS_CTRL_REG Register (from x4xx_global_regs.v)
  localparam GPS_CTRL_REG = 'h38; // Register Offset
  localparam GPS_CTRL_REG_SIZE = 32;  // register width in bits
  localparam GPS_CTRL_REG_MASK = 32'h0;

  // GPS_STATUS_REG Register (from x4xx_global_regs.v)
  localparam GPS_STATUS_REG = 'h3C; // Register Offset
  localparam GPS_STATUS_REG_SIZE = 32;  // register width in bits
  localparam GPS_STATUS_REG_MASK = 32'h0;

  // DBOARD_CTRL_REG Register (from x4xx_global_regs.v)
  localparam DBOARD_CTRL_REG = 'h40; // Register Offset
  localparam DBOARD_CTRL_REG_SIZE = 32;  // register width in bits
  localparam DBOARD_CTRL_REG_MASK = 32'h0;

  // DBOARD_STATUS_REG Register (from x4xx_global_regs.v)
  localparam DBOARD_STATUS_REG = 'h44; // Register Offset
  localparam DBOARD_STATUS_REG_SIZE = 32;  // register width in bits
  localparam DBOARD_STATUS_REG_MASK = 32'h0;

  // NUM_TIMEKEEPERS_REG Register (from x4xx_global_regs.v)
  localparam NUM_TIMEKEEPERS_REG = 'h48; // Register Offset
  localparam NUM_TIMEKEEPERS_REG_SIZE = 32;  // register width in bits
  localparam NUM_TIMEKEEPERS_REG_MASK = 32'h0;

  // SERIAL_NUM_LOW_REG Register (from x4xx_global_regs.v)
  localparam SERIAL_NUM_LOW_REG = 'h4C; // Register Offset
  localparam SERIAL_NUM_LOW_REG_SIZE = 32;  // register width in bits
  localparam SERIAL_NUM_LOW_REG_MASK = 32'h0;

  // SERIAL_NUM_HIGH_REG Register (from x4xx_global_regs.v)
  localparam SERIAL_NUM_HIGH_REG = 'h50; // Register Offset
  localparam SERIAL_NUM_HIGH_REG_SIZE = 32;  // register width in bits
  localparam SERIAL_NUM_HIGH_REG_MASK = 32'h0;

  // MFG_TEST_CTRL_REG Register (from x4xx_global_regs.v)
  localparam MFG_TEST_CTRL_REG = 'h54; // Register Offset
  localparam MFG_TEST_CTRL_REG_SIZE = 32;  // register width in bits
  localparam MFG_TEST_CTRL_REG_MASK = 32'h3;
  localparam MFG_TEST_EN_GTY_RCV_CLK_SIZE = 1;  //MFG_TEST_CTRL_REG:MFG_TEST_EN_GTY_RCV_CLK
  localparam MFG_TEST_EN_GTY_RCV_CLK_MSB  = 0;  //MFG_TEST_CTRL_REG:MFG_TEST_EN_GTY_RCV_CLK
  localparam MFG_TEST_EN_GTY_RCV_CLK      = 0;  //MFG_TEST_CTRL_REG:MFG_TEST_EN_GTY_RCV_CLK
  localparam MFG_TEST_EN_FABRIC_CLK_SIZE = 1;  //MFG_TEST_CTRL_REG:MFG_TEST_EN_FABRIC_CLK
  localparam MFG_TEST_EN_FABRIC_CLK_MSB  = 1;  //MFG_TEST_CTRL_REG:MFG_TEST_EN_FABRIC_CLK
  localparam MFG_TEST_EN_FABRIC_CLK      = 1;  //MFG_TEST_CTRL_REG:MFG_TEST_EN_FABRIC_CLK

  // MFG_TEST_STATUS_REG Register (from x4xx_global_regs.v)
  localparam MFG_TEST_STATUS_REG = 'h58; // Register Offset
  localparam MFG_TEST_STATUS_REG_SIZE = 32;  // register width in bits
  localparam MFG_TEST_STATUS_REG_MASK = 32'h3FFFFFF;
  localparam MFG_TEST_FPGA_AUX_REF_FREQ_SIZE = 26;  //MFG_TEST_STATUS_REG:MFG_TEST_FPGA_AUX_REF_FREQ
  localparam MFG_TEST_FPGA_AUX_REF_FREQ_MSB  = 25;  //MFG_TEST_STATUS_REG:MFG_TEST_FPGA_AUX_REF_FREQ
  localparam MFG_TEST_FPGA_AUX_REF_FREQ      =  0;  //MFG_TEST_STATUS_REG:MFG_TEST_FPGA_AUX_REF_FREQ

  // QSFP_PORT_0_0_INFO_REG Register (from x4xx_global_regs.v)
  localparam QSFP_PORT_0_0_INFO_REG = 'h60; // Register Offset
  localparam QSFP_PORT_0_0_INFO_REG_SIZE = 32;  // register width in bits
  localparam QSFP_PORT_0_0_INFO_REG_MASK = 32'h0;

  // QSFP_PORT_0_1_INFO_REG Register (from x4xx_global_regs.v)
  localparam QSFP_PORT_0_1_INFO_REG = 'h64; // Register Offset
  localparam QSFP_PORT_0_1_INFO_REG_SIZE = 32;  // register width in bits
  localparam QSFP_PORT_0_1_INFO_REG_MASK = 32'h0;

  // QSFP_PORT_0_2_INFO_REG Register (from x4xx_global_regs.v)
  localparam QSFP_PORT_0_2_INFO_REG = 'h68; // Register Offset
  localparam QSFP_PORT_0_2_INFO_REG_SIZE = 32;  // register width in bits
  localparam QSFP_PORT_0_2_INFO_REG_MASK = 32'h0;

  // QSFP_PORT_0_3_INFO_REG Register (from x4xx_global_regs.v)
  localparam QSFP_PORT_0_3_INFO_REG = 'h6C; // Register Offset
  localparam QSFP_PORT_0_3_INFO_REG_SIZE = 32;  // register width in bits
  localparam QSFP_PORT_0_3_INFO_REG_MASK = 32'h0;

  // QSFP_PORT_1_0_INFO_REG Register (from x4xx_global_regs.v)
  localparam QSFP_PORT_1_0_INFO_REG = 'h70; // Register Offset
  localparam QSFP_PORT_1_0_INFO_REG_SIZE = 32;  // register width in bits
  localparam QSFP_PORT_1_0_INFO_REG_MASK = 32'h0;

  // QSFP_PORT_1_1_INFO_REG Register (from x4xx_global_regs.v)
  localparam QSFP_PORT_1_1_INFO_REG = 'h74; // Register Offset
  localparam QSFP_PORT_1_1_INFO_REG_SIZE = 32;  // register width in bits
  localparam QSFP_PORT_1_1_INFO_REG_MASK = 32'h0;

  // QSFP_PORT_1_2_INFO_REG Register (from x4xx_global_regs.v)
  localparam QSFP_PORT_1_2_INFO_REG = 'h78; // Register Offset
  localparam QSFP_PORT_1_2_INFO_REG_SIZE = 32;  // register width in bits
  localparam QSFP_PORT_1_2_INFO_REG_MASK = 32'h0;

  // QSFP_PORT_1_3_INFO_REG Register (from x4xx_global_regs.v)
  localparam QSFP_PORT_1_3_INFO_REG = 'h7C; // Register Offset
  localparam QSFP_PORT_1_3_INFO_REG_SIZE = 32;  // register width in bits
  localparam QSFP_PORT_1_3_INFO_REG_MASK = 32'h0;

  // DEVICE_DNA0_REG Register (from x4xx_global_regs.v)
  localparam DEVICE_DNA0_REG = 'h100; // Register Offset
  localparam DEVICE_DNA0_REG_SIZE = 32;  // register width in bits
  localparam DEVICE_DNA0_REG_MASK = 32'h0;

  // DEVICE_DNA1_REG Register (from x4xx_global_regs.v)
  localparam DEVICE_DNA1_REG = 'h104; // Register Offset
  localparam DEVICE_DNA1_REG_SIZE = 32;  // register width in bits
  localparam DEVICE_DNA1_REG_MASK = 32'h0;

  // DEVICE_DNA2_REG Register (from x4xx_global_regs.v)
  localparam DEVICE_DNA2_REG = 'h108; // Register Offset
  localparam DEVICE_DNA2_REG_SIZE = 32;  // register width in bits
  localparam DEVICE_DNA2_REG_MASK = 32'h0;
