/**
 * UGENE - Integrated Bioinformatics Tools.
 * Copyright (C) 2008-2024 UniPro <ugene@unipro.ru>
 * http://ugene.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include "McaRowHeightController.h"

#include "ov_mca/McaEditor.h"
#include "ov_mca/SequenceWithChromatogramAreaRenderer.h"

namespace U2 {

McaRowHeightController::McaRowHeightController(McaEditorWgt* mcaEditorWgt)
    : RowHeightController(mcaEditorWgt) {
}

int McaRowHeightController::getRowHeightByMaIndex(int maRowIndex) const {
    MaEditor* editor = ui->getEditor();
    const int fontHeight = QFontMetrics(editor->getFont(), ui).height();

    int rowHeigth = fontHeight;
    if (!editor->getCollapseModel()->isGroupWithMaRowIndexCollapsed(maRowIndex)) {
        rowHeigth += SequenceWithChromatogramAreaRenderer::CHROMATOGRAM_MAX_HEIGHT;
    }
    rowHeigth = qRound(rowHeigth * editor->zoomMult);
    return rowHeigth;
}

}  // namespace U2
