---
myst:
  html_meta:
    keywords: LaTeX, musique, écrire de la musique, partitions, portées, musixtex, musictex, lilypond, 
---
# Comment écrire de la musique sous LaTeX ?

## Avec l'éditeur `Lilypond`

`LilyPond` est un outil permettant, entre autres, de produire du code TeX/LaTeX. `LilyPond` permet d'écrire de la polyphonie, d'ajouter des paroles à la musique, de générer des fichiers midi et offre une large gamme de notations musicales : du grégorien (neumes et ligatures) au contemporain (clusters) en passant par la renaissance (notes carrées) et le baroque (basse chiffrée). Sa syntaxe d'entrée est moins cryptique que celle de [MusiXTeX](ctanpkg:musixtex), à niveau de qualité équivalent.

Disponible sur [son site officiel](https://lilypond.org/), `Lilypond` accepte en particulier une [liste d'éditeurs](http://lilypond.org/easier-editing.fr.html) permettant de travailler plus facilement avec lui. En matière d'exemples, le site du [projet Mutopia](https://www.mutopiaproject.org/) propose plusieurs centaines de partitions mises en pages à l'aide de `LilyPond`.

### L'extension <ctanpkg:lilyglyphs>

Pour les références musicales occasionnelles (signes dièses et bémols, notes, clefs, etc.), il existe une extension appelée <ctanpkg:lilyglyphs>. Elle utilise les polices `lilypond` (incluses dans l'extension) et fournit également les moyens d'ajouter des éléments provenant d'autres sources.


## Avec l'extension [MusiXTeX](ctanpkg:musixtex)

L'extension [MusiXTeX](ctanpkg:musixtex) de Daniel Taupin, Ross Mitchell et Andreas Egler permet d'écrire des partitions pour orchestres ou de la musique polyphonique. Bien sûr, [MusiXTeX](ctanpkg:musixtex) requiert des polices musicales et celles-ci sont disponibles dans une extension séparée. [MusiXTeX](ctanpkg:musixtex) fonctionne avec trois compilation :

- une basée sur TeX ;
- une passe de traitement effectuée par `musixflx` qui optimise l'espacement et les liaisons ;
- une autre passe TeX.

L'extension <ctanpkg:Musixtex> est gourmande en ressources. Toute partition importante nécessite que la composition soit réalisée avec [eTeX](/1_generalites/glossaire/etex.md) (et donc LaTeX), dont les gammes élargies de registres de variables et de boîtes permettent davantage d'activités "parallèles" qui abondent dans une partition musicale.

Une difficulté de [MusiXTeX](ctanpkg:Musixtex) réside dans sa syntaxe, quelque peu abrupte. Des solutions, présentées ci-après, permettent de simplifier cette syntaxe.

Voici quelques sources documentaires complémentaires :

- le [Cahier GUTenberg n°21](http://www.numdam.org/issues/CG_1995___21/) ;
- le [site web de Werner Icking](http://icking-music-archive.org/), mine d'informations, propose en particulier des partitions générées avec [MusiXTeX](ctanpkg:musixtex) ;
- la liste de discussion « [Tex-music](https://tug.org/mailman/listinfo/tex-music) » (en anglais) sur ce sujet.

### Le programme `PMX`

`PMX` est un programme d'aide à l'utilisation de MusiXTeX disponible à l'URL : <http://icking-music-archive.org/software/pmx/>.

### Le programme `M-Tx`

Le programme `M-Tx` (Music-from-TeXt) est un autre pré-processeur pour [MusixTeX](ctanpkg:musixtex) qui facilite la saisie des chœurs. La sortie de `M-Tx` est transmise à `pmx` et, de là, à [MusixTeX](ctanpkg:musixtex). Une documentation de ce programme est disponible [ici](https://www.icking-music-archive.org/software/mtx/mtx060.pdf).

### Le programme `abc2mtex`

Une autre alternative pour écrire de la musique sous forme de texte est [notation ABC](https://abcnotation.com/), développée pour la musique traditionnelle d'Europe occidentale (qui peut être écrite sur une seule portée), bien qu'elle puisse être utilisée beaucoup plus largement. Un frontal à [MusiXTeX](ctanpkg:Musixtex), `abc2mtex`, rend la composition ABC possible.

### Le programme `midi2tex`

Cas particulier, le programme `midi2tex` peut également générer une sortie [MusiXTeX](ctanpkg:Musixtex) à partir de fichiers MIDI.


## Avec le programme <ctanpkg:gregoriotex>

Pour le chant grégorien, il existe <ctanpkg:gregoriotex>, un logiciel d'écriture de partitions de chant grégorien.


## Avec des outils plus anciens

:::{warning}
Ce qui suit n'a qu'une valeur historique et les extensions citées, [obsolètes](/1_generalites/histoire/liste_des_packages_obsoletes.md), ne sont pas recommandées.

L'histoire de la musique dans TeX remonte à un certain temps. Les premières "commandes" traitant ce sujet constituaient l'extension <ctanpkg:mtex> (aussi nommé MuTeX), par Angelika Schofer et Andrea Steinbach. Datant de 1986, MuTeX était assez limité et il a fallu un certain temps avant que Daniel Taupin ne prenne le relais et ne développe [MusicTeX](ctanpkg:musictex), qui permet la composition de musique polyphonique et d'autres musiques à plusieurs portées.

Une fois qu'Andreas Egler s'est retiré, Daniel Taupin a repris le développement, ce qui a conduit au [MusiXTeX](ctanpkg:musixtex) utilisé aujourd'hui.
:::

:::{sources}
[Typesetting music in TeX](faquk:FAQ-music)
:::
