---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, notes de bas de page, chapitre, 
              numérotation
---

# Comment éviter la renumérotation des notes de bas de page à chaque chapitre ?

Certaines classes (par exemple <ctanpkg:book> et <ctanpkg:report>) 
considèrent que les notes de bas de page de chaque chapitre sont isolées 
des autres : la numérotation de ces notes est ainsi réinitialisée à 1 
à chaque chapitre. Ceci correspond au comportement de la numérotation 
des équations, figures et tables, à ceci près la numérotation 
des notes de bas de page n'intègre pas le numéro du chapitre en cours.

Du fait de cette correspondance, la solution pour éviter ce comportement 
pour les notes de base de page est similaire à la 
[solution pour les équations, figures et tables](/3_composition/texte/renvois/numeroter_les_equations_et_figures_en_continu). 
Elle requiert donc l'extension <ctanpkg:chngcntr> pour les versions de LaTeX 
antérieures à 2018. Comme les numéros ne sont pas "décorés", vous pouvez utiliser 
la commande `\counterwithout*` et le code se limite alors à ce qui suit.

```{noedit}
\counterwithout*{footnote}{chapter}
```

:::{sources}
[Not resetting footnote numbers per chapter](faquk:FAQ-run-fn-nos)
:::