[vset VERSION 0.2.2]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctools::toc::export n [vset VERSION]]
[keywords conversion]
[keywords doctoc]
[keywords documentation]
[keywords export]
[keywords formatting]
[keywords generation]
[keywords HTML]
[keywords json]
[keywords manpage]
[keywords markup]
[keywords nroff]
[keywords plugin]
[keywords reference]
[keywords table]
[keywords {table of contents}]
[keywords {tcler's wiki}]
[keywords text]
[keywords url]
[keywords wiki]
[copyright {2009-2019 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Exporting tables of contents}]
[category  {Documentation tools}]
[require doctools::toc::export [opt [vset VERSION]]]
[require Tcl "8.5 9"]
[require struct::map]
[require doctools::toc::structure]
[require snit]
[require pluginmgr]
[description]

This package provides a class to manage the plugins for the export of
tables of contents to other formats, i.e. their conversion to, for
example [term doctoc], [term HTML], etc.

[para]

This is one of the three public pillars the management of tables of
contents resides on. The other two pillars are

[list_begin enum]
[enum] [manpage {Importing tables of contents}], and
[enum] [manpage {Holding tables of contents}]
[list_end]

[para]

For information about the [sectref Concepts] of tables of contents,
and their parts, see the same-named section.

For information about the data structure which is the major input to
the manager objects provided by this package see the section
[sectref {ToC serialization format}].

[para]

The plugin system of our class is based on the package
[package pluginmgr], and configured to look for plugins using

[list_begin enum]
[enum] the environment variable [var DOCTOOLS_TOC_EXPORT_PLUGINS],
[enum] the environment variable [var DOCTOOLS_TOC_PLUGINS],
[enum] the environment variable [var DOCTOOLS_PLUGINS],
[enum] the path [file {~/.doctools/toc/export/plugin}]
[enum] the path [file {~/.doctools/toc/plugin}]
[enum] the path [file {~/.doctools/plugin}]
[enum] the path [file {~/.doctools/toc/export/plugins}]
[enum] the path [file {~/.doctools/toc/plugins}]
[enum] the path [file {~/.doctools/plugins}]
[enum] the registry entry "HKEY_CURRENT_USER\SOFTWARE\DOCTOOLS\TOC\EXPORT\PLUGINS"
[enum] the registry entry "HKEY_CURRENT_USER\SOFTWARE\DOCTOOLS\TOC\PLUGINS"
[enum] the registry entry "HKEY_CURRENT_USER\SOFTWARE\DOCTOOLS\PLUGINS"
[list_end]

The last three are used only when the package is run on a machine
using Windows(tm) operating system.

[para]

The whole system is delivered with six predefined export plugins,
namely

[list_begin definitions]
[def doctoc]  See [manpage {doctoc export plugin}] for details.
[def html]    See [manpage {html export plugin}] for details.
[def json]    See [manpage {json export plugin}] for details.
[def nroff]   See [manpage {nroff export plugin}] for details.
[def text]    See [manpage {text export plugin}] for details.
[def wiki]    See [manpage {wiki export plugin}] for details.
[list_end]

[para]

Readers wishing to write their own export plugin for some format, i.e.
[term {plugin writer}]s reading and understanding the section
containing the [sectref {Export plugin API v2 reference}] is an
absolute necessity, as it specifies the interaction between this
package and its plugins in detail.

[section Concepts] [include include/concept.inc]

[section API]
[subsection {Package commands}]

[list_begin definitions]

[call [cmd ::doctools::toc::export] [arg objectName]]

This command creates a new export manager object with an associated
Tcl command whose name is [arg objectName]. This [term object] command
is explained in full detail in the sections [sectref {Object command}]
and [sectref {Object methods}]. The object command will be created
under the current namespace if the [arg objectName] is not fully
qualified, and in the specified namespace otherwise.

[list_end]

[subsection {Object command}]

All objects created by the [cmd ::doctools::toc::export] command have
the following general form:

[list_begin definitions]

[call [cmd objectName] [method method] [opt [arg "arg arg ..."]]]

The method [method method] and its [arg arg]'uments determine the
exact behavior of the command.

See section [sectref {Object methods}] for the detailed
specifications.

[list_end]

[subsection {Object methods}]

[list_begin definitions]

[call [arg objectName] [method destroy]]

This method destroys the object it is invoked for.

[call [arg objectName] [method {export serial}] [arg serial] [opt [arg format]]]

This method takes the canonical serialization of a table of contents
stored in [arg serial] and converts it to the specified [arg format],
using the export plugin for the format. An error is thrown if no
plugin could be found for the format.

The string generated by the conversion process is returned as
the result of this method.

[para]

If no format is specified the method defaults to [const doctoc].

[para]

The specification of what a [term canonical] serialization is can be
found in the section [sectref {ToC serialization format}].

[para]

The plugin has to conform to the interface specified in section
[sectref {Export plugin API v2 reference}].

[call [arg objectName] [method {export object}] [arg object] [opt [arg format]]]

This method is a convenient wrapper around the [method {export serial}]
method described by the previous item.

It expects that [arg object] is an object command supporting a
[method serialize] method returning the canonical serialization of a
table of contents. It invokes that method, feeds the result into
[method {export serial}] and returns the resulting string as its own
result.

[call [arg objectName] [method {config names}]]

This method returns a list containing the names of all configuration
variables currently known to the object.

[call [arg objectName] [method {config get}]]

This method returns a dictionary containing the names and values of
all configuration variables currently known to the object.

[call [arg objectName] [method {config set}] [arg name] [opt [arg value]]]

This method sets the configuration variable [arg name] to the
specified [arg value] and returns the new value of the variable.

[para]

If no value is specified it simply returns the current value, without
changing it.

[para]

Note that while the user can set the predefined configuration
variables [const user] and [const format] doing so will have no
effect, these values will be internally overridden when invoking an
import plugin.

[call [arg objectName] [method {config unset}] [arg pattern]...]

This method unsets all configuration variables matching the specified
glob [arg pattern]s. If no pattern is specified it will unset all
currently defined configuration variables.

[list_end]

[section {Export plugin API v2 reference}]

Plugins are what this package uses to manage the support for any
output format beyond the [sectref {ToC serialization format}]. Here we
specify the API the objects created by this package use to interact
with their plugins.

[para]

A plugin for this package has to follow the rules listed below:

[list_begin enumerated]

[enum] A plugin is a package.

[enum] The name of a plugin package has the form

		doctools::toc::export::[var FOO],

       where [var FOO] is the name of the format the plugin will
       generate output for. This name is also the argument to provide
       to the various [method export] methods of export manager
       objects to get a string encoding a table of contents in that
       format.

[enum] The plugin can expect that the package
       [package doctools::toc::export::plugin] is present, as
       indicator that it was invoked from a genuine plugin manager.

[enum] A plugin has to provide one command, with the signature shown
       below.

[list_begin definitions]
[call [cmd export] [arg serial] [arg configuration]]

Whenever an export manager of [package doctools::toc] has to generate
output for a table of contents it will invoke this command.

[list_begin arguments]

[arg_def string serial]

This argument will contain the [term canonical] serialization of the
table of contents for which to generate the output.

The specification of what a [term canonical] serialization is can be
found in the section [sectref {ToC serialization format}].

[arg_def dictionary configuration]

This argument will contain the current configuration to apply to the
generation, as a dictionary mapping from variable names to values.

[para]

The following configuration variables have a predefined meaning all
plugins have to obey, although they can ignore this information at
their discretion. Any other other configuration variables recognized
by a plugin will be described in the manpage for that plugin.

[list_begin definitions]

[def user] This variable is expected to contain the name of the user
           owning the process invoking the plugin.

[def format] This variable is expected to contain the name of the
             format whose plugin is invoked.

[def file] This variable, if defined by the user of the table object
           is expected to contain the name of the input file for which
           the plugin is generating its output for.

[def map] This variable, if defined by the user of the table object is
          expected to contain a dictionary mapping from symbolic
          document ids used in the table entries to actual paths (or
          urls). A plugin has to be able to handle the possibility
          that a document id is without entry in this mapping.

[list_end][comment {-- predefined configuration variables --}]
[list_end][comment {-- arguments --}]
[list_end][comment {-- api command signatures --}]

[enum] A single usage cycle of a plugin consists of the invokations of
       the command [cmd export]. This call has to leave the plugin in
       a state where another usage cycle can be run without problems.

[list_end]

[include include/serialization.inc]
[vset CATEGORY doctools]
[include ../common-text/feedback.inc]
[manpage_end]
