#ifndef _INTERNAL_PARSE_H
#define _INTERNAL_PARSE_H

#include <string_view>

namespace Tango::detail
{

/// @brief Parse a string as the given type.
///
/// This function is actually instantiated only for `int`, `long`, `double` and `size_t`.
///
/// @throws std::runtime_error The string cannot be entirely parsed to the type T.
template <typename T>
T parse_as(std::string_view str);

} // namespace Tango::detail

#endif
