#define XERR
#include "loop.ih"

// perform a screening

void Loop::screen(double screeningAge)
{
    // visit all modalities: for (ModBase *...) or comparable

                                            // org/screen: 4, screen.txt: 1
    for (ModBase *modBase: d_modalities.use(
                                d_screening.round(d_round).modalityIndices())
    )
    { 
        if (not use(modBase))
            continue;
                                            // adds the basic costs: screening
                                            // for lungcancer, 'costs:' for
                                            // other modalities
        addCost(d_costs.screening(screeningAge, modBase->cost()));

                                            // determine the tumor
                                            // characteristics. 
        if (d_tumor.selfDetectable())                        
            d_tumor.characteristics(screeningAge); 

                        // test2 (see below)
        if (d_tumor.selfDetectable() and screeningAge >= d_tumor.detectableAge()) 
            maybeDetect(modBase, screeningAge);
        else 
            maybeFalsePositive(modBase, screeningAge);
    }
}

// tumor   test2   selfDetectabledetect selfDetectablefalsepos
//   1       1         1           0
//   1       0         0           1
//   0       1         0           1
//   0       0         0           1
// 
// -> calling selfDetectableFalsePositive may not be called when just 'not d_tumor'
//    is true.



// Sensitivity (true positive rate) refers to the probability of a positive
// test, conditioned on truly being positive (so: the power)
// 
// Specificity (true negative rate) refers to the probability of a negative
// test, conditioned on truly being negative. (so: 1 - alpha)


//xerr("");
//for (auto const &id: d_screening.round(d_round).modalityIDs())
//cerr<<"     id: " << id <<'\n';


//xerr("use " << modBase->id());

//xerr("cpt costs");

