#version 330
in vec3 Normal;
in vec3 nor;

uniform vec4 Color=vec4(1,1,0,1);
uniform vec3 lightPos;
uniform int inFocus = -1;

out vec4 fragColor;

const float a = 4.0 / sqrt(10.0 + 2.0 * sqrt(5.0));
const float re = 0.25 * (1.0 + sqrt(5.0)) * a;
const float ri = sqrt(3.0) / 12.0 * (3.0 + sqrt(5.0)) * a;
const float r1 =(re+ri+ri)/3;
const float r2 =(re+re+1)/3;

vec3 blinnPhongDirectional( vec3 n , vec3 kd) {
  vec3 ambient = kd * 0.5;//Light.La * Material.Ka;
  vec3 intensity = vec3(0.8, 0.8, 0.8);
  vec3 s = normalize(lightPos);// directional light
  float sDotN = abs(dot(s, n));
  vec3 diffuse = kd * sDotN;
  vec3 spec = vec3(0.0);
  float Shininess = 48.0;
  if (sDotN > 0.0) {
    spec = vec3(1,1,1) * pow(max(dot(s,n), 0.0), Shininess);
  }
  return ambient + intensity * (diffuse + spec);
}

void main( void ){
    float v = length(nor);
    // edge raius of icosahedron re = 0.25 * (1 + sqrt(5)) = 0.809016994 * a
    // inner radius of icosahedron ri = sqrt(3)/12 * (3 + sqrt(5) = 0.755761314 * a
    // {\displaystyle r_{i}={\frac {\sqrt {3}}{12}}(3+{\sqrt {5}})\cdot a}  ≈ 0,756 ⋅ a {\displaystyle \approx 0{,}756\cdot a}
    if (inFocus>-1){
        if (v<re) discard;
    }else {
    if (v<r1) discard;// round hole
    if ((v>re)&&(v<r2)) discard;// pentagon hole
    }
    if (gl_FrontFacing) {
       /*if (inFocus==-2) fragColor = vec4(blinnPhongDirectional( Normal, vec3(0.8,0.2,1.0)), 1.0);
       else if (inFocus>-1) fragColor = vec4(blinnPhongDirectional( Normal, vec3(0.4,0.8,1.0)), 1.0);
       else */
           fragColor = vec4(blinnPhongDirectional( Normal, Color.rgb), 0.5);
            //vec4(blinnPhongDirectional( Normal, abs(nor), 0.5);//
    }
    else discard;
}
