/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.output.xsd.BuiltinSimpleTypeHierarchy;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeComplexContentExtension;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeSelector;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeSimpleContentExtension;
import com.thaiopensource.relaxng.output.xsd.NamespaceManager;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexType;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeNotAllowedContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeSimpleContent;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRef;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRestriction;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AbstractElementTypeSelector {
    private final Schema schema;
    private final NamespaceManager nsm;
    private final ComplexTypeSelector complexTypeSelector;
    private final Map<Name, ComplexType> abstractElementComplexTypeMap = new HashMap<Name, ComplexType>();
    private final ComplexType urType = new ComplexTypeNotAllowedContent();

    AbstractElementTypeSelector(Schema schema, NamespaceManager namespaceManager, ComplexTypeSelector complexTypeSelector) {
        this.schema = schema;
        this.nsm = namespaceManager;
        this.complexTypeSelector = complexTypeSelector;
    }

    ComplexType getAbstractElementType(Name name) {
        ComplexType complexType = this.abstractElementComplexTypeMap.get(name);
        if (complexType == null) {
            complexType = this.computeAbstractElementType(name);
            if (complexType == null) {
                complexType = this.urType;
            }
            this.abstractElementComplexTypeMap.put(name, complexType);
        }
        if (complexType == this.urType) {
            return null;
        }
        return complexType;
    }

    private ComplexType computeAbstractElementType(Name name) {
        List<Name> list = this.nsm.getAbstractElementSubstitutionGroupMembers(name);
        if (list == null) {
            return null;
        }
        ComplexType complexType = null;
        for (Name name2 : list) {
            ComplexType complexType2 = this.getElementType(name2, this.nsm);
            if (complexType2 == null) {
                return null;
            }
            if (complexType == null) {
                complexType = complexType2;
                continue;
            }
            if ((complexType = this.commonBaseType(complexType, complexType2)) != null) continue;
            return null;
        }
        return complexType;
    }

    private ComplexType commonBaseType(ComplexType complexType, ComplexType complexType2) {
        if (complexType.equals(complexType2)) {
            return complexType;
        }
        if (this.isValidlyDerived(complexType, complexType2)) {
            return complexType2;
        }
        if (this.isValidlyDerived(complexType2, complexType)) {
            return complexType;
        }
        return null;
    }

    private boolean isValidlyDerived(ComplexType complexType, ComplexType complexType2) {
        if (complexType instanceof ComplexTypeComplexContent && complexType2 instanceof ComplexTypeComplexContent) {
            return this.isComplexContentValidlyDerived((ComplexTypeComplexContent)complexType, (ComplexTypeComplexContent)complexType2);
        }
        if (complexType instanceof ComplexTypeSimpleContent && complexType2 instanceof ComplexTypeSimpleContent) {
            return this.isSimpleContentValidlyDerived((ComplexTypeSimpleContent)complexType, (ComplexTypeSimpleContent)complexType2);
        }
        return false;
    }

    private boolean isComplexContentValidlyDerived(ComplexTypeComplexContent complexTypeComplexContent, ComplexTypeComplexContent complexTypeComplexContent2) {
        ComplexTypeComplexContentExtension complexTypeComplexContentExtension = this.complexTypeSelector.transformComplexContent(complexTypeComplexContent2);
        String string = complexTypeComplexContentExtension.getBase();
        if (string == null || complexTypeComplexContentExtension.getParticle() != null || !complexTypeComplexContentExtension.getAttributeUses().equals(AttributeGroup.EMPTY) || complexTypeComplexContentExtension.isMixed()) {
            return false;
        }
        Particle particle = complexTypeComplexContent.getParticle();
        while (true) {
            String string2;
            if (string.equals(string2 = this.complexTypeSelector.particleBase(particle))) {
                return true;
            }
            if (string2 == null || !this.complexTypeSelector.isComplexType(string2)) break;
            particle = this.schema.getGroup(string2).getParticle();
        }
        return false;
    }

    private boolean isSimpleContentValidlyDerived(ComplexTypeSimpleContent complexTypeSimpleContent, ComplexTypeSimpleContent complexTypeSimpleContent2) {
        ComplexTypeSimpleContentExtension complexTypeSimpleContentExtension = this.complexTypeSelector.transformSimpleContent(complexTypeSimpleContent2);
        if (!complexTypeSimpleContentExtension.getAttributeUses().equals(AttributeGroup.EMPTY)) {
            return false;
        }
        String string = complexTypeSimpleContentExtension.getBase();
        if (string == null) {
            return this.isSimpleTypeValidlyDerived(complexTypeSimpleContent.getSimpleType(), complexTypeSimpleContentExtension.getSimpleType());
        }
        return this.isSimpleTypeValidlyDerivedFromName(complexTypeSimpleContent.getSimpleType(), string);
    }

    private boolean isSimpleTypeValidlyDerived(SimpleType simpleType, SimpleType simpleType2) {
        if (simpleType2.getAnnotation() != null) {
            return false;
        }
        if (simpleType2 instanceof SimpleTypeRef) {
            return this.isSimpleTypeValidlyDerivedFromName(simpleType, ((SimpleTypeRef)simpleType2).getName());
        }
        if (simpleType2 instanceof SimpleTypeRestriction) {
            SimpleTypeRestriction simpleTypeRestriction = (SimpleTypeRestriction)simpleType2;
            if (simpleTypeRestriction.getFacets().size() > 0) {
                return false;
            }
            return this.isSimpleTypeValidlyDerivedFromBuiltin(simpleType, simpleTypeRestriction.getName());
        }
        return false;
    }

    private boolean isSimpleTypeValidlyDerivedFromName(SimpleType simpleType, String string) {
        while (simpleType instanceof SimpleTypeRef) {
            String string2 = ((SimpleTypeRef)simpleType).getName();
            if (string2.equals(string)) {
                return true;
            }
            simpleType = this.schema.getSimpleType(string2).getSimpleType();
        }
        return false;
    }

    private boolean isSimpleTypeValidlyDerivedFromBuiltin(SimpleType simpleType, String string) {
        while (simpleType instanceof SimpleTypeRef) {
            simpleType = this.schema.getSimpleType(((SimpleTypeRef)simpleType).getName()).getSimpleType();
        }
        if (!(simpleType instanceof SimpleTypeRestriction)) {
            return false;
        }
        String string2 = ((SimpleTypeRestriction)simpleType).getName();
        do {
            if (!string2.equals(string)) continue;
            return true;
        } while ((string2 = BuiltinSimpleTypeHierarchy.getParentType(string2)) != null);
        return false;
    }

    private ComplexType getElementType(Name name, NamespaceManager namespaceManager) {
        Element element = namespaceManager.getGlobalElement(name);
        if (element != null) {
            return element.getComplexType();
        }
        return this.getAbstractElementType(name);
    }
}

