// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ServerMonitor.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.servermon {
  public class ServerMonitor : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor:1.0.0", null);

    public ServerMonitor(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public ServerMonitor(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new ServerMonitor StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new ServerMonitor(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum ServerReachability {
      WAITING,
      REACHABLE,
      UNREACHABLE,
      ERROR,
    }

    public class ServerSettings : ICloneable {
      public object Clone() {
        ServerSettings copy = new ServerSettings();
        copy.host = this.host;
        copy.enabled = this.enabled;
        copy.pingInterval = this.pingInterval;
        copy.retryInterval = this.retryInterval;
        copy.activationCount = this.activationCount;
        copy.failureCount = this.failureCount;
        copy.resumeDelay = this.resumeDelay;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["host"] = this.host;
        json["enabled"] = this.enabled;
        json["pingInterval"] = this.pingInterval;
        json["retryInterval"] = this.retryInterval;
        json["activationCount"] = this.activationCount;
        json["failureCount"] = this.failureCount;
        json["resumeDelay"] = this.resumeDelay;
        return json;
      }

      public static ServerSettings Decode(LightJson.JsonObject json, Agent agent) {
        ServerSettings inst = new ServerSettings();
        inst.host = (string)json["host"];
        inst.enabled = (bool)json["enabled"];
        inst.pingInterval = (int)json["pingInterval"];
        inst.retryInterval = (int)json["retryInterval"];
        inst.activationCount = (int)json["activationCount"];
        inst.failureCount = (int)json["failureCount"];
        inst.resumeDelay = (int)json["resumeDelay"];
        return inst;
      }

      public string host = "";
      public bool enabled = false;
      public int pingInterval = 0;
      public int retryInterval = 0;
      public int activationCount = 0;
      public int failureCount = 0;
      public int resumeDelay = 0;
    }

    public class ServerStatus : ICloneable {
      public object Clone() {
        ServerStatus copy = new ServerStatus();
        copy.reachable = this.reachable;
        copy.lastRequest = this.lastRequest;
        copy.lastResponse = this.lastResponse;
        copy.requests = this.requests;
        copy.responses = this.responses;
        copy.failures = this.failures;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["reachable"] = (int)this.reachable;
        json["lastRequest"] = this.lastRequest.Ticks;
        json["lastResponse"] = this.lastResponse.Ticks;
        json["requests"] = this.requests;
        json["responses"] = this.responses;
        json["failures"] = this.failures;
        return json;
      }

      public static ServerStatus Decode(LightJson.JsonObject json, Agent agent) {
        ServerStatus inst = new ServerStatus();
        inst.reachable = (Com.Raritan.Idl.servermon.ServerMonitor.ServerReachability)(int)json["reachable"];
        inst.lastRequest = new System.DateTime(json["lastRequest"]);
        inst.lastResponse = new System.DateTime(json["lastResponse"]);
        inst.requests = (int)json["requests"];
        inst.responses = (int)json["responses"];
        inst.failures = (int)json["failures"];
        return inst;
      }

      public Com.Raritan.Idl.servermon.ServerMonitor.ServerReachability reachable = Com.Raritan.Idl.servermon.ServerMonitor.ServerReachability.WAITING;
      public System.DateTime lastRequest = new System.DateTime(0);
      public System.DateTime lastResponse = new System.DateTime(0);
      public int requests = 0;
      public int responses = 0;
      public int failures = 0;
    }

    public class Server : ICloneable {
      public object Clone() {
        Server copy = new Server();
        copy.settings = this.settings;
        copy.status = this.status;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["settings"] = this.settings.Encode();
        json["status"] = this.status.Encode();
        return json;
      }

      public static Server Decode(LightJson.JsonObject json, Agent agent) {
        Server inst = new Server();
        inst.settings = Com.Raritan.Idl.servermon.ServerMonitor.ServerSettings.Decode(json["settings"], agent);
        inst.status = Com.Raritan.Idl.servermon.ServerMonitor.ServerStatus.Decode(json["status"], agent);
        return inst;
      }

      public Com.Raritan.Idl.servermon.ServerMonitor.ServerSettings settings = new Com.Raritan.Idl.servermon.ServerMonitor.ServerSettings();
      public Com.Raritan.Idl.servermon.ServerMonitor.ServerStatus status = new Com.Raritan.Idl.servermon.ServerMonitor.ServerStatus();
    }

    public const int MAX_SERVERS = 8;

    public const int ERR_NO_SUCH_ID = 1;

    public const int ERR_INVALID_SETTINGS = 2;

    public const int ERR_DUPLICATE_HOSTNAME = 3;

    public const int ERR_MAX_SERVERS_REACHED = 4;

    public class AddServerResult {
      public int _ret_;
      public int id;
    }

    public AddServerResult addServer(Com.Raritan.Idl.servermon.ServerMonitor.ServerSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("addServer", _parameters);
      var _ret = new AddServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.id = (int)_result["id"];
      return _ret;
    }

    public AsyncRequest addServer(Com.Raritan.Idl.servermon.ServerMonitor.ServerSettings settings, AsyncRpcResponse<AddServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addServer(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addServer(Com.Raritan.Idl.servermon.ServerMonitor.ServerSettings settings, AsyncRpcResponse<AddServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addServer", _parameters,
        _result => {
          try {
            var _ret = new AddServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.id = (int)_result["id"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ModifyServerResult {
      public int _ret_;
    }

    public ModifyServerResult modifyServer(int id, Com.Raritan.Idl.servermon.ServerMonitor.ServerSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("modifyServer", _parameters);
      var _ret = new ModifyServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest modifyServer(int id, Com.Raritan.Idl.servermon.ServerMonitor.ServerSettings settings, AsyncRpcResponse<ModifyServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return modifyServer(id, settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest modifyServer(int id, Com.Raritan.Idl.servermon.ServerMonitor.ServerSettings settings, AsyncRpcResponse<ModifyServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("modifyServer", _parameters,
        _result => {
          try {
            var _ret = new ModifyServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteServerResult {
      public int _ret_;
    }

    public DeleteServerResult deleteServer(int id) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;

      var _result = RpcCall("deleteServer", _parameters);
      var _ret = new DeleteServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteServer(int id, AsyncRpcResponse<DeleteServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteServer(id, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteServer(int id, AsyncRpcResponse<DeleteServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteServer", _parameters,
        _result => {
          try {
            var _ret = new DeleteServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetServerResult {
      public int _ret_;
      public Com.Raritan.Idl.servermon.ServerMonitor.Server server;
    }

    public GetServerResult getServer(int id) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;

      var _result = RpcCall("getServer", _parameters);
      var _ret = new GetServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.server = Com.Raritan.Idl.servermon.ServerMonitor.Server.Decode(_result["server"], agent);
      return _ret;
    }

    public AsyncRequest getServer(int id, AsyncRpcResponse<GetServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getServer(id, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getServer(int id, AsyncRpcResponse<GetServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getServer", _parameters,
        _result => {
          try {
            var _ret = new GetServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.server = Com.Raritan.Idl.servermon.ServerMonitor.Server.Decode(_result["server"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ListServersResult {
      public System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.servermon.ServerMonitor.Server> _ret_;
    }

    public ListServersResult listServers() {
      JsonObject _parameters = null;
      var _result = RpcCall("listServers", _parameters);
      var _ret = new ListServersResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.servermon.ServerMonitor.Server>(_value["key"], Com.Raritan.Idl.servermon.ServerMonitor.Server.Decode(_value["value"], agent))));
      return _ret;
    }

    public AsyncRequest listServers(AsyncRpcResponse<ListServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listServers(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listServers(AsyncRpcResponse<ListServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("listServers", _parameters,
        _result => {
          try {
            var _ret = new ListServersResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.servermon.ServerMonitor.Server>(_value["key"], Com.Raritan.Idl.servermon.ServerMonitor.Server.Decode(_value["value"], agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
