% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solr_json_request.R
\name{solr_json_request}
\alias{solr_json_request}
\title{Solr json request}
\usage{
solr_json_request(conn, name = NULL, body = NULL, callopts = list(),
  progress = NULL)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{Name of a collection or core. Or leave as \code{NULL} if not needed.}

\item{body}{(list) a named list, or a valid JSON character string}

\item{callopts}{Call options passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{progress}{a function with logic for printing a progress
bar for an HTTP request, ultimately passed down to \pkg{curl}.
only supports \code{httr::progress} for now. See the README for an example.}
}
\value{
JSON character string
}
\description{
search using the JSON request API
}
\note{
SOLR v7.1 was first version to support this. See
\url{https://issues.apache.org/jira/browse/SOLR-11244}

POST request only, no GET request available
}
\examples{
\dontrun{
# Connect to a local Solr instance
(conn <- SolrClient$new())

## body as JSON 
a <- conn$json_request("gettingstarted", body = '{"query":"*:*"}')
jsonlite::fromJSON(a)
## body as named list
b <- conn$json_request("gettingstarted", body = list(query = "*:*"))
jsonlite::fromJSON(b)

## body as JSON 
a <- solr_json_request(conn, "gettingstarted", body = '{"query":"*:*"}')
jsonlite::fromJSON(a)
## body as named list
b <- solr_json_request(conn, "gettingstarted", body = list(query = "*:*"))
jsonlite::fromJSON(b)
}
}
\references{
See https://lucene.apache.org/solr/guide/7_6/json-request-api.html
for more information.
}
