% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superseded-map-df.R
\name{map_dfr}
\alias{map_dfr}
\alias{map_df}
\alias{map_dfc}
\alias{imap_dfr}
\alias{imap_dfc}
\alias{map2_dfr}
\alias{map2_dfc}
\alias{map2_df}
\alias{pmap_dfr}
\alias{pmap_dfc}
\alias{pmap_df}
\title{Functions that return data frames}
\usage{
map_dfr(.x, .f, ..., .id = NULL)

map_dfc(.x, .f, ...)

imap_dfr(.x, .f, ..., .id = NULL)

imap_dfc(.x, .f, ...)

map2_dfr(.x, .y, .f, ..., .id = NULL)

map2_dfc(.x, .y, .f, ...)

pmap_dfr(.l, .f, ..., .id = NULL)

pmap_dfc(.l, .f, ...)
}
\arguments{
\item{.id}{Either a string or \code{NULL}. If a string, the output will contain
a variable with that name, storing either the name (if \code{.x} is named) or
the index (if \code{.x} is unnamed) of the input. If \code{NULL}, the default, no
variable will be created.

Only applies to \verb{_dfr} variant.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

These \code{\link[=map]{map()}}, \code{\link[=map2]{map2()}}, \code{\link[=imap]{imap()}}, and \code{\link[=pmap]{pmap()}} variants return data
frames by row-binding or column-binding the outputs together.

The functions were superseded in purrr 1.0.0 because their names
suggest they work like \verb{_lgl()}, \verb{_int()}, etc which require length
1 outputs, but actually they return results of any size because the results
are combined without any size checks. Additionally, they use
\code{dplyr::bind_rows()} and \code{dplyr::bind_cols()} which require dplyr to be
installed and have confusing semantics with edge cases. Superseded
functions will not go away, but will only receive critical bug fixes.

Instead, we recommend using \code{map()}, \code{map2()}, etc with \code{\link[=list_rbind]{list_rbind()}} and
\code{\link[=list_cbind]{list_cbind()}}. These use \code{\link[vctrs:vec_bind]{vctrs::vec_rbind()}} and \code{\link[vctrs:vec_bind]{vctrs::vec_cbind()}}
under the hood, and have names that more clearly reflect their semantics.
}
\examples{
# map ---------------------------------------------
# Was:
mtcars |>
  split(mtcars$cyl) |>
  map(\(df) lm(mpg ~ wt, data = df)) |>
  map_dfr(\(mod) as.data.frame(t(as.matrix(coef(mod)))))

# Now:
mtcars |>
  split(mtcars$cyl) |>
  map(\(df) lm(mpg ~ wt, data = df)) |>
  map(\(mod) as.data.frame(t(as.matrix(coef(mod))))) |>
  list_rbind()

# for certain pathological inputs `map_dfr()` and `map_dfc()` actually
# both combine the list by column
df <- data.frame(
  x = c(" 13", "  15 "),
  y = c("  34",  " 67 ")
)

# Was:
map_dfr(df, trimws)
map_dfc(df, trimws)

# But list_rbind()/list_cbind() fail because they require data frame inputs
try(map(df, trimws) |> list_rbind())

# Instead, use modify() to apply a function to each column of a data frame
modify(df, trimws)

# map2 ---------------------------------------------

ex_fun <- function(arg1, arg2){
  col <- arg1 + arg2
  x <- as.data.frame(col)
}
arg1 <- 1:4
arg2 <- 10:13

# was
map2_dfr(arg1, arg2, ex_fun)
# now
map2(arg1, arg2, ex_fun) |> list_rbind()

# was
map2_dfc(arg1, arg2, ex_fun)
# now
map2(arg1, arg2, ex_fun) |> list_cbind()
}
\keyword{internal}
