% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project}
\alias{project}
\title{Projection to submodels}
\usage{
project(
  object,
  nterms = NULL,
  solution_terms = NULL,
  cv_search = TRUE,
  ndraws = 400,
  nclusters = NULL,
  intercept = NULL,
  seed = NULL,
  regul = 1e-04,
  ...
)
}
\arguments{
\item{object}{Either a \code{refmodel}-type object created by
\link[=get_refmodel]{get_refmodel} or \link[=init_refmodel]{init_refmodel},
or an object which can be converted to a reference model using
\link[=get_refmodel]{get_refmodel}.}

\item{nterms}{Number of terms in the submodel (the variable combination is
taken from the \code{varsel} information). If a list, then the projection
is performed for each model size. Default is the model size suggested by
the variable selection (see function \code{suggest_size}). Ignored if
\code{solution_terms} is specified.}

\item{solution_terms}{Variable indices onto which the projection is done. If
specified, \code{nterms} is ignored.}

\item{cv_search}{If TRUE, then the projected coefficients after L1-selection
are computed without any penalization (or using only the regularization
determined by \code{regul}). If FALSE, then the coefficients are the
solution from the L1-penalized projection. This option is relevant only if
L1-search was used. Default is TRUE for genuine reference models and FALSE
if \code{object} is datafit (see \link[=init_refmodel]{init_refmodel}).}

\item{ndraws}{Number of posterior draws to be projected. Ignored if
\code{nclusters} is specified. Default is 400.}

\item{nclusters}{Number of clusters in the clustered projection.}

\item{intercept}{Whether to use intercept. Default is \code{TRUE}.}

\item{seed}{A seed used in the clustering (if \code{nclusters!=ndraws}). Can
be used to ensure same results every time. @param regul Amount of
regularization in the projection. Usually there is no need for
regularization, but sometimes for some models the projection can be
ill-behaved and we need to add some regularization to avoid numerical
problems.}

\item{regul}{Ridgre regularization constant to fit the projections.}

\item{...}{Currently ignored.}
}
\value{
A list of submodels (or a single submodel if projection was
  performed onto a single variable combination), each of which contains the
  following elements:
\describe{
 \item{\code{kl}}{The KL divergence from the reference model to the
  submodel.} \item{\code{weights}}{Weights for each draw of the projected
  model.}
 \item{\code{dis}}{Draws from the projected dispersion parameter.}
 \item{\code{alpha}}{Draws from the projected intercept.}
 \item{\code{beta}}{Draws from the projected weight vector.}
 \item{\code{solution_terms}}{The order in which the variables were added to
  the submodel.}
  \item{\code{intercept}}{Whether or not the model contains an
  intercept.}
 \item{\code{family}}{A modified \code{\link{family}}-object.}
}
}
\description{
Perform projection onto submodels of selected sizes or a specified feature
combination.
}
\examples{
\donttest{
if (requireNamespace("rstanarm", quietly = TRUE)) {
  ### Usage with stanreg objects
  n <- 30
  d <- 5
  x <- matrix(rnorm(n * d), nrow = n)
  y <- x[, 1] + 0.5 * rnorm(n)
  data <- data.frame(x, y)

  fit <- rstanarm::stan_glm(y ~ X1 + X2 + X3 + X4 + X5, gaussian(),
    data = data, chains = 2, iter = 500)
  vs <- varsel(fit)

  # project onto the best model with 4 variables
  proj4 <- project(vs, nterms = 4)

  # project onto an arbitrary variable combination (variable indices 1, 3 and 5)
  proj <- project(fit, solution_terms = c(1, 3, 5))
}
}

}
