% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind-fill.r
\name{rbind.fill}
\alias{rbind.fill}
\title{Combine data.frames by row, filling in missing columns.}
\usage{
rbind.fill(...)
}
\arguments{
\item{...}{input data frames to row bind together.  The first argument can
be a list of data frames, in which case all other arguments are ignored.
Any NULL inputs are silently dropped. If all inputs are NULL, the output
is NULL.}
}
\value{
a single data frame
}
\description{
\code{rbind}s a list of data frames filling missing columns with NA.
}
\details{
This is an enhancement to \code{\link{rbind}} that adds in columns
that are not present in all inputs, accepts a list of data frames, and
operates substantially faster.

Column names and types in the output will appear in the order in which
they were encountered.

Unordered factor columns will have their levels unified and
character data bound with factors will be converted to
character. POSIXct data will be converted to be in the same time
zone. Array and matrix columns must have identical dimensions after
the row count. Aside from these there are no general checks that
each column is of consistent data type.
}
\examples{
rbind.fill(mtcars[c("mpg", "wt")], mtcars[c("wt", "cyl")])
}
\seealso{
Other binding functions: 
\code{\link{rbind.fill.matrix}()}
}
\concept{binding functions}
\keyword{manip}
