% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmcClassesAndMethods.R
\docType{class}
\name{ctmc-class}
\alias{ctmc-class}
\alias{dim,ctmc-method}
\alias{initialize,ctmc_method}
\alias{states,ctmc-method}
\alias{steadyStates,ctmc-method}
\alias{plot,ctmc,missing-method}
\title{Continuous time Markov Chains class}
\arguments{
\item{states}{Name of the states. Must be the same of
\code{colnames} and \code{rownames} of the generator matrix}

\item{byrow}{TRUE or FALSE. Indicates whether the given matrix is
stochastic by rows or by columns}

\item{generator}{Square generator matrix}

\item{name}{Optional character name of the Markov chain}
}
\description{
The S4 class that describes \code{ctmc} (continuous 
time Markov chain) objects.
}
\note{
\enumerate{
\item \code{ctmc} classes are written using S4 classes
\item Validation method is used to assess whether either columns or rows totals to zero. 
Rounding is used up to 5th decimal. If state names are not properly defined
for a generator  \code{matrix}, coercing to \code{ctmc} object leads to overriding
states name with artificial "s1", "s2", ... sequence
}
}
\section{Methods}{


\describe{
\item{dim}{\code{signature(x = "ctmc")}: method to get the size} 
\item{initialize}{\code{signature(.Object = "ctmc")}: initialize
  method }
\item{states}{\code{signature(object = "ctmc")}: states method. }
\item{steadyStates}{\code{signature(object = "ctmc")}: method to get the
  steady state vector. } 
\item{plot}{\code{signature(x = "ctmc", y = "missing")}: plot method 
  for \code{ctmc} objects }
}
}

\examples{
energyStates <- c("sigma", "sigma_star")
byRow <- TRUE
gen <- matrix(data = c(-3, 3,
                       1, -1), nrow = 2,
              byrow = byRow, dimnames = list(energyStates, energyStates))
molecularCTMC <- new("ctmc", states = energyStates, 
                     byrow = byRow, generator = gen, 
                     name = "Molecular Transition Model")
                     steadyStates(molecularCTMC)
\dontrun{plot(molecularCTMC)}

}
\references{
Introduction to Stochastic Processes with Applications in the Biosciences
(2013), David F. Anderson, University of Wisconsin at Madison. Sai Bhargav
Yalamanchi, Giorgio Spedicato
}
\seealso{
\code{\link{generatorToTransitionMatrix}},\code{\link{rctmc}}
}
\keyword{classes}
