% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redundant_equals_linter.R
\name{redundant_equals_linter}
\alias{redundant_equals_linter}
\title{Block usage of \code{==}, \code{!=} on logical vectors}
\usage{
redundant_equals_linter()
}
\description{
Testing \code{x == TRUE} is redundant if \code{x} is a logical vector. Wherever this is
used to improve readability, the solution should instead be to improve the
naming of the object to better indicate that its contents are logical. This
can be done using prefixes (is, has, can, etc.). For example, \code{is_child},
\code{has_parent_supervision}, \code{can_watch_horror_movie} clarify their logical
nature, while \code{child}, \code{parent_supervision}, \code{watch_horror_movie} don't.
}
\examples{
# will produce lints
lint(
  text = "if (any(x == TRUE)) 1",
  linters = redundant_equals_linter()
)

lint(
  text = "if (any(x != FALSE)) 0",
  linters = redundant_equals_linter()
)

lint(
  text = "dt[is_tall == FALSE, y]",
  linters = redundant_equals_linter()
)

# okay
lint(
  text = "if (any(x)) 1",
  linters = redundant_equals_linter()
)

lint(
  text = "if (!all(x)) 0",
  linters = redundant_equals_linter()
)

# in `{data.table}` semantics, `dt[x]` is a join, `dt[(x)]` is a subset
lint(
  text = "dt[(!is_tall), y]",
  linters = redundant_equals_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \code{\link[=outer_negation_linter]{outer_negation_linter()}}
}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=common_mistakes_linters]{common_mistakes}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
