% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_font.R
\name{setup_font}
\alias{setup_font}
\title{Setup a font to be used in Shiny or Markdown}
\usage{
setup_font(
  id,
  output_dir,
  variants = NULL,
  subsets = NULL,
  prefer_local_source = TRUE,
  browser_support = c("best", "modern"),
  ...
)
}
\arguments{
\item{id}{Id of the font, correspond to column \code{id} from \code{\link{get_all_fonts}}.}

\item{output_dir}{Output directory where to save font and CSS files. Must be a directory.}

\item{variants}{Variant(s) to download, default is to includes all available ones.}

\item{subsets}{Subsets to download.}

\item{prefer_local_source}{Generate CSS font-face rules in which user installed fonts are
preferred. Use \code{FALSE} if you want to force the use of the downloaded font.}

\item{browser_support}{Browser to support, choose \code{"best"} to support
old browser or \code{"modern"} for only recent ones.}

\item{...}{Arguments passed to \code{crul::HttpClient$new}.}
}
\value{
None.
}
\description{
This function will download the specified font into a directory of your project
 and generate CSS code to use it in a Shiny application or RMarkdown document.
}
\note{
Two directories will be created (if they do not exist)
 in the \code{output_dir} specified: \strong{fonts/} and \strong{css/}.
}
\examples{
if (interactive()) {

# For example, we use a temporary directory
path_to_www <- tempfile()
dir.create(path_to_www)

# In a Shiny app, you can use the www/ directory
# in Markdown, use a subfolder of your Rmd directory
setup_font(
  id = "open-sans-condensed",
  output_dir = path_to_www
)

# Clean up
unlink(path_to_www, recursive = TRUE)

}
}
