% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped-df.r, R/rowwise.r
\name{new_grouped_df}
\alias{new_grouped_df}
\alias{validate_grouped_df}
\alias{new_rowwise_df}
\alias{validate_rowwise_df}
\title{Low-level construction and validation for the grouped_df and rowwise_df classes}
\usage{
new_grouped_df(x, groups, ..., class = character())

validate_grouped_df(x, check_bounds = FALSE)

new_rowwise_df(data, group_data = NULL, ..., class = character())

validate_rowwise_df(x)
}
\arguments{
\item{x}{A data frame}

\item{groups}{The grouped structure, \code{groups} should be a data frame.
Its last column should be called \code{.rows} and be
a list of 1 based integer vectors that all are between 1 and the number of rows of \code{.data}.}

\item{...}{additional attributes}

\item{class}{additional class, will be prepended to canonical classes.}

\item{check_bounds}{whether to check all indices for out of bounds problems in \code{grouped_df} objects}
}
\description{
\code{new_grouped_df()} and \code{new_rowwise_df()} are constructors designed to be high-performance so only
check types, not values. This means it is the caller's responsibility
to create valid values, and hence this is for expert use only.

\code{validate_grouped_df()} and \code{validate_rowwise_df()} validate the attributes
of a \code{grouped_df} or a \code{rowwise_df}.
}
\examples{
# 5 bootstrap samples
tbl <- new_grouped_df(
  tibble(x = rnorm(10)),
  groups = tibble(".rows" := replicate(5, sample(1:10, replace = TRUE), simplify = FALSE))
)
# mean of each bootstrap sample
summarise(tbl, x = mean(x))

}
\keyword{internal}
