% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paginator.R
\name{Paginator}
\alias{Paginator}
\title{Paginator client}
\value{
a list, with objects of class \code{\link[=HttpResponse]{HttpResponse()}}.
Responses are returned in the order they are passed in.
}
\description{
A client to help you paginate
}
\details{
See \code{\link[=HttpClient]{HttpClient()}} for information on parameters
}
\section{R6 classes}{

This is an R6 class from the package \pkg{R6}. Find out more
about R6 at \url{https://r6.r-lib.org/}. After creating an instance of an R6
class (e.g., \code{x <- HttpClient$new(url = "https://httpbin.org")}) you can
access values and methods on the object \code{x}.
}

\section{Methods to paginate}{


Supported now:
\itemize{
\item \code{limit_offset}: the most common way (in my experience), so is the default.
This method involves setting how many records and what record to start at
for each request. We send these query parameters for you.
\item \code{page_perpage}: set the page to fetch and (optionally) how many records
to get per page
}

Supported later, hopefully:
\itemize{
\item \code{link_headers}: link headers are URLS for the next/previous/last
request given in the response header from the server. This is relatively
uncommon, though is recommended by JSONAPI and is implemented by a
well known API (GitHub).
\item \code{cursor}: this works by a single string given back in each response, to
be passed in the subsequent response, and so on until no more records
remain. This is common in Solr
}
}

\examples{
\dontrun{
if (interactive()) {
# limit/offset approach
con <- HttpClient$new(url = "https://api.crossref.org")
cc <- Paginator$new(client = con, limit_param = "rows",
   offset_param = "offset", limit = 50, chunk = 10)
cc
cc$get('works')
cc
cc$responses()
cc$status()
cc$status_code()
cc$times()
# cc$content()
cc$parse()
lapply(cc$parse(), jsonlite::fromJSON)

# page/per page approach (with no per_page param allowed)
conn <- HttpClient$new(url = "https://discuss.ropensci.org")
cc <- Paginator$new(client = conn, by = "page_perpage",
 page_param = "page", per_page_param = "per_page", limit = 90, chunk = 30)
cc
cc$get('c/usecases/l/latest.json')
cc$responses()
lapply(cc$parse(), jsonlite::fromJSON)

# page/per_page
conn <- HttpClient$new('https://api.inaturalist.org')
cc <- Paginator$new(conn, by = "page_perpage", page_param = "page",
 per_page_param = "per_page", limit = 90, chunk = 30)
cc
cc$get('v1/observations', query = list(taxon_name="Helianthus"))
cc$responses()
res <- lapply(cc$parse(), jsonlite::fromJSON)
res[[1]]$total_results
vapply(res, "[[", 1L, "page")
vapply(res, "[[", 1L, "per_page")
vapply(res, function(w) NROW(w$results), 1L)
## another
ccc <- Paginator$new(conn, by = "page_perpage", page_param = "page",
 per_page_param = "per_page", limit = 500, chunk = 30, progress = TRUE)
ccc
ccc$get('v1/observations', query = list(taxon_name="Helianthus"))
res2 <- lapply(ccc$parse(), jsonlite::fromJSON)
vapply(res2, function(w) NROW(w$results), 1L)

# progress bar
(con <- HttpClient$new(url = "https://api.crossref.org"))
cc <- Paginator$new(client = con, limit_param = "rows",
   offset_param = "offset", limit = 50, chunk = 10,
   progress = TRUE)
cc
cc$get('works')
}}

## ------------------------------------------------
## Method `Paginator$url_fetch`
## ------------------------------------------------

\dontrun{
cli <- HttpClient$new(url = "https://api.crossref.org")
cc <- Paginator$new(client = cli, limit_param = "rows",
   offset_param = "offset", limit = 50, chunk = 10)
cc$url_fetch('works')
cc$url_fetch('works', query = list(query = "NSF"))
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{http_req}}{an object of class \code{HttpClient}}

\item{\code{by}}{(character) how to paginate. Only 'limit_offset' supported
for now. In the future will support 'link_headers' and 'cursor'.
See Details.}

\item{\code{chunk}}{(numeric/integer) the number by which to chunk
requests, e.g., 10 would be be each request gets 10 records.
number is passed through \code{\link[=format]{format()}} to prevent larger numbers
from being scientifically formatted}

\item{\code{limit_param}}{(character) the name of the limit parameter.
Default: limit}

\item{\code{offset_param}}{(character) the name of the offset parameter.
Default: offset}

\item{\code{limit}}{(numeric/integer) the maximum records wanted.
number is passed through \code{\link[=format]{format()}} to prevent larger numbers
from being scientifically formatted}

\item{\code{page_param}}{(character) the name of the page parameter.
Default: NULL}

\item{\code{per_page_param}}{(character) the name of the per page parameter.
Default: NULL}

\item{\code{progress}}{(logical) print a progress bar, using \link[utils:txtProgressBar]{utils::txtProgressBar}.
Default: \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Paginator-print}{\code{Paginator$print()}}
\item \href{#method-Paginator-new}{\code{Paginator$new()}}
\item \href{#method-Paginator-get}{\code{Paginator$get()}}
\item \href{#method-Paginator-post}{\code{Paginator$post()}}
\item \href{#method-Paginator-put}{\code{Paginator$put()}}
\item \href{#method-Paginator-patch}{\code{Paginator$patch()}}
\item \href{#method-Paginator-delete}{\code{Paginator$delete()}}
\item \href{#method-Paginator-head}{\code{Paginator$head()}}
\item \href{#method-Paginator-responses}{\code{Paginator$responses()}}
\item \href{#method-Paginator-status_code}{\code{Paginator$status_code()}}
\item \href{#method-Paginator-status}{\code{Paginator$status()}}
\item \href{#method-Paginator-parse}{\code{Paginator$parse()}}
\item \href{#method-Paginator-content}{\code{Paginator$content()}}
\item \href{#method-Paginator-times}{\code{Paginator$times()}}
\item \href{#method-Paginator-url_fetch}{\code{Paginator$url_fetch()}}
\item \href{#method-Paginator-clone}{\code{Paginator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-print"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-print}{}}}
\subsection{Method \code{print()}}{
print method for \code{Paginator} objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-new"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Paginator} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$new(
  client,
  by = "limit_offset",
  limit_param = NULL,
  offset_param = NULL,
  limit = NULL,
  chunk = NULL,
  page_param = NULL,
  per_page_param = NULL,
  progress = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{an object of class \code{HttpClient}, from a call to \link{HttpClient}}

\item{\code{by}}{(character) how to paginate. Only 'limit_offset' supported for
now. In the future will support 'link_headers' and 'cursor'. See Details.}

\item{\code{limit_param}}{(character) the name of the limit parameter.
Default: limit}

\item{\code{offset_param}}{(character) the name of the offset parameter.
Default: offset}

\item{\code{limit}}{(numeric/integer) the maximum records wanted}

\item{\code{chunk}}{(numeric/integer) the number by which to chunk requests,
e.g., 10 would be be each request gets 10 records}

\item{\code{page_param}}{(character) the name of the page parameter.}

\item{\code{per_page_param}}{(character) the name of the per page parameter.}

\item{\code{progress}}{(logical) print a progress bar, using \link[utils:txtProgressBar]{utils::txtProgressBar}.
Default: \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Paginator} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-get"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-get}{}}}
\subsection{Method \code{get()}}{
make a paginated GET request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$get(path = NULL, query = list(), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-post"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-post}{}}}
\subsection{Method \code{post()}}{
make a paginated POST request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$post(
  path = NULL,
  query = list(),
  body = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{body}}{body as an R list}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-put"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-put}{}}}
\subsection{Method \code{put()}}{
make a paginated PUT request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$put(
  path = NULL,
  query = list(),
  body = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{body}}{body as an R list}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-patch"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-patch}{}}}
\subsection{Method \code{patch()}}{
make a paginated PATCH request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$patch(
  path = NULL,
  query = list(),
  body = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{body}}{body as an R list}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-delete}{}}}
\subsection{Method \code{delete()}}{
make a paginated DELETE request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$delete(
  path = NULL,
  query = list(),
  body = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}

\item{\code{body}}{body as an R list}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-head"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-head}{}}}
\subsection{Method \code{head()}}{
make a paginated HEAD request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$head(path = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{...}}{For \code{retry}, the options to be passed on to the method
implementing the requested verb, including curl options. Otherwise,
curl options, only those in the acceptable set from \code{\link[curl:curl_options]{curl::curl_options()}}
except the following: httpget, httppost, post, postfields, postfieldsize,
and customrequest}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
not sure if this makes any sense or not yet
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-responses"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-responses}{}}}
\subsection{Method \code{responses()}}{
list responses
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$responses()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of \code{HttpResponse} objects, empty list before requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-status_code"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-status_code}{}}}
\subsection{Method \code{status_code()}}{
Get HTTP status codes for each response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$status_code()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
numeric vector, empty numeric vector before requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-status"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-status}{}}}
\subsection{Method \code{status()}}{
List HTTP status objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$status()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of \code{http_code} objects, empty list before requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-parse"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-parse}{}}}
\subsection{Method \code{parse()}}{
parse content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$parse(encoding = "UTF-8")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{encoding}}{(character) the encoding to use in parsing.
default:"UTF-8"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector, empty character vector before
requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-content"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-content}{}}}
\subsection{Method \code{content()}}{
Get raw content for each response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$content()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
raw list, empty list before requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-times"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-times}{}}}
\subsection{Method \code{times()}}{
curl request times
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$times()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list of named numeric vectors, empty list before requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-url_fetch"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-url_fetch}{}}}
\subsection{Method \code{url_fetch()}}{
get the URL that would be sent (i.e., before executing
the request) the only things that change the URL are path and query
parameters; body and any curl options don't change the URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$url_fetch(path = NULL, query = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list. any numeric values are
passed through \code{\link[=format]{format()}} to prevent larger numbers from being
scientifically formatted}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
URLs (character)
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
cli <- HttpClient$new(url = "https://api.crossref.org")
cc <- Paginator$new(client = cli, limit_param = "rows",
   offset_param = "offset", limit = 50, chunk = 10)
cc$url_fetch('works')
cc$url_fetch('works', query = list(query = "NSF"))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Paginator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Paginator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Paginator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
