% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BEAM.R
\name{calILRs}
\alias{calILRs}
\title{Calculate the Instantaneous Log Ratio between two branches}
\usage{
calILRs(cds, trend_formula = "~sm.ns(Pseudotime, df = 3)*Branch",
  branch_point = 1, trajectory_states = NULL, relative_expr = TRUE,
  stretch = TRUE, cores = 1, ILRs_limit = 3, label_by_short_name = TRUE,
  useVST = FALSE, round_exprs = FALSE, output_type = "all",
  branch_labels = NULL, file = NULL, return_all = F, verbose = FALSE,
  ...)
}
\arguments{
\item{cds}{CellDataSet for the experiment}

\item{trend_formula}{trend_formula a formula string specifying the full model in differential expression tests (i.e. likelihood ratio tests) for each gene/feature.}

\item{branch_point}{the point where two branches diverge}

\item{trajectory_states}{states corresponding to two branches}

\item{relative_expr}{A logic flag to determine whether or not the relative expressed should be used when we fitting the spline curves}

\item{stretch}{a logic flag to determine whether or not each branch should be stretched}

\item{cores}{Number of cores when fitting the spline curves}

\item{ILRs_limit}{the minimum Instant Log Ratio used to make the heatmap plot}

\item{label_by_short_name}{label the rows of the returned matrix by gene_short_name (TRUE) or feature id (FALSE)}

\item{useVST}{A logic flag to determine whether or not the Variance Stablization Transformation should be used to stablize the gene expression.
When VST is used, the difference between two branchs are used instead of the log-ratio.}

\item{round_exprs}{A logic flag to determine whether or not the expression value should be rounded into integer}

\item{output_type}{A character either of "all" or "after_bifurcation". If "after_bifurcation" is used, only the time points after the bifurcation point will be selected}

\item{branch_labels}{the name for each branch, for example, AT1 or AT2}

\item{file}{the name for storing the data. Since the calculation of the Instant Log Ratio is very time consuming, so by default the result will be stored}

\item{return_all}{A logic flag to determine whether or not all the results from the analysis should be returned, this includes 
a dataframe for the log fold change, normalized log fold change, raw divergence, normalized divergence, fitting curves for each branch}

\item{verbose}{Whether or not detailed running information should be returned}

\item{...}{Additional arguments passed to buildBranchCellDataSet}
}
\value{
a ggplot2 plot object
}
\description{
This function is used to calculate the Instant Log Ratio between two branches which can be used to prepare the heatmap demonstrating the branch gene expression divergence hirearchy. If "stretch" is specifified, each  
branch will be firstly stretched into maturation level from 0-100. Since the results when we use "stretching" are always better and 
IRLs for non-stretched spline curves are often mismatched, we may only turn down "non-stretch" functionality in future versions. Then, we fit two separate nature spline curves for each 
individual linages. The log-ratios of the value on each spline curve corresponding to each branch are calculated, which can be  
used as a measure for the magnitude of divergence between two branching branchs.
}
