% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowWeightedMedians.R
\name{rowWeightedMedians}
\alias{rowWeightedMedians}
\alias{rowWeightedMedians,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowWeightedMedians,ANY-method}
\alias{colWeightedMedians}
\alias{colWeightedMedians,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colWeightedMedians,ANY-method}
\title{Calculates the weighted median for each row (column) of a matrix-like object}
\usage{
rowWeightedMedians(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE, ...)

\S4method{rowWeightedMedians}{matrix_OR_array_OR_table_OR_numeric}(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE, ...)

\S4method{rowWeightedMedians}{ANY}(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE, ...)

colWeightedMedians(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE, ...)

\S4method{colWeightedMedians}{matrix_OR_array_OR_table_OR_numeric}(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE, ...)

\S4method{colWeightedMedians}{ANY}(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{w}{A \code{\link{numeric}} vector of length K (N) that specifies by
how much each element is weighted.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the weighted median for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowWeightedMedians}
/ \code{matrixStats::colWeightedMedians}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  w <- rnorm(n = 5, mean = 3)
  rowWeightedMedians(mat, w = w[1:3])
  colWeightedMedians(mat, w = w)
  
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowWeightedMedians}()} and
\code{matrixStats::\link[matrixStats:rowWeightedMedians]{colWeightedMedians}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \link{rowMedians} for the corresponding unweighted function.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
