# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.workloads import WorkloadsClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-workloads
# USAGE
    python php_workloads_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = WorkloadsClient(
        credential=DefaultAzureCredential(),
        subscription_id="8e17e36c-42e9-4cd5-a078-7b44883414e0",
    )

    response = client.php_workloads.begin_create_or_update(
        resource_group_name="test-rg",
        php_workload_name="wp39",
        php_workload_resource={
            "kind": "WordPress",
            "location": "eastus2",
            "properties": {
                "adminUserProfile": {"sshPublicKey": "===SSH=PUBLIC=KEY===", "userName": "wpadmin"},
                "appLocation": "eastus",
                "backupProfile": {"backupEnabled": "Disabled"},
                "cacheProfile": {"capacity": 0, "family": "C", "name": "wp-cache", "skuName": "Basic"},
                "controllerProfile": {
                    "dataDisks": [{"sizeInGB": 100, "storageType": "Premium_LRS"}],
                    "name": "contoller-vm",
                    "nodeSku": "Standard_DS2_v2",
                    "osDisk": {"storageType": "Premium_LRS"},
                    "osImage": {
                        "offer": "UbuntuServer",
                        "publisher": "Canonical",
                        "sku": "18.0-LTS",
                        "version": "latest",
                    },
                },
                "databaseProfile": {
                    "backupRetentionDays": 7,
                    "haEnabled": "Disabled",
                    "serverName": "wp-db-server",
                    "sku": "Standard_D32s_v4",
                    "sslEnforcementEnabled": "Enabled",
                    "storageInGB": 128,
                    "storageIops": 200,
                    "storageSku": "Premium_LRS",
                    "tier": "GeneralPurpose",
                    "type": "MySql",
                    "version": "5.7",
                },
                "fileshareProfile": {"shareSizeInGB": 100, "shareType": "AzureFiles", "storageType": "Premium_LRS"},
                "managedResourceGroupConfiguration": {"name": "php-mrg-wp39"},
                "networkProfile": {
                    "azureFrontDoorEnabled": "Enabled",
                    "loadBalancerSku": "Standard",
                    "loadBalancerType": "LoadBalancer",
                },
                "phpProfile": {"version": "7.3"},
                "searchProfile": {
                    "nodeSku": "Standard_DS2_v2",
                    "osDisk": {"storageType": "Premium_LRS"},
                    "osImage": {
                        "offer": "UbuntuServer",
                        "publisher": "Canonical",
                        "sku": "18.0-LTS",
                        "version": "latest",
                    },
                    "searchType": "Elastic",
                },
                "siteProfile": {"domainName": "www.example.com"},
                "webNodesProfile": {
                    "autoScaleMaxCount": 1,
                    "autoScaleMinCount": 1,
                    "name": "web-server",
                    "nodeSku": "Standard_DS2_v2",
                    "osDisk": {"storageType": "Premium_LRS"},
                    "osImage": {
                        "offer": "UbuntuServer",
                        "publisher": "Canonical",
                        "sku": "18.0-LTS",
                        "version": "latest",
                    },
                },
            },
            "sku": {"name": "Large"},
            "tags": {},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/workloads/resource-manager/Microsoft.Workloads/preview/2021-12-01-preview/examples/phpworkloads/PhpWorkloads_CreateOrUpdate.json
if __name__ == "__main__":
    main()
