# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AzureTrackedResourceLocation(_serialization.Model):
    """Describes an Azure resource with location.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs):
        """
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2021_07_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2021_07_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class CloudOffering(_serialization.Model):
    """The security offering details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CspmMonitorAwsOffering, DefenderForContainersAwsOffering, DefenderForServersAwsOffering,
    InformationProtectionAwsOffering

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws", and
     "InformationProtectionAws".
    :vartype offering_type: str or ~azure.mgmt.security.v2021_07_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    _subtype_map = {
        "offering_type": {
            "CspmMonitorAws": "CspmMonitorAwsOffering",
            "DefenderForContainersAws": "DefenderForContainersAwsOffering",
            "DefenderForServersAws": "DefenderForServersAwsOffering",
            "InformationProtectionAws": "InformationProtectionAwsOffering",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.offering_type = None  # type: Optional[str]
        self.description = None


class CspmMonitorAwsOffering(CloudOffering):
    """The CSPM monitoring for AWS offering configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws", and
     "InformationProtectionAws".
    :vartype offering_type: str or ~azure.mgmt.security.v2021_07_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar native_cloud_connection: The native cloud connection configuration.
    :vartype native_cloud_connection:
     ~azure.mgmt.security.v2021_07_01_preview.models.CspmMonitorAwsOfferingNativeCloudConnection
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "native_cloud_connection": {
            "key": "nativeCloudConnection",
            "type": "CspmMonitorAwsOfferingNativeCloudConnection",
        },
    }

    def __init__(
        self,
        *,
        native_cloud_connection: Optional["_models.CspmMonitorAwsOfferingNativeCloudConnection"] = None,
        **kwargs
    ):
        """
        :keyword native_cloud_connection: The native cloud connection configuration.
        :paramtype native_cloud_connection:
         ~azure.mgmt.security.v2021_07_01_preview.models.CspmMonitorAwsOfferingNativeCloudConnection
        """
        super().__init__(**kwargs)
        self.offering_type = "CspmMonitorAws"  # type: str
        self.native_cloud_connection = native_cloud_connection


class CspmMonitorAwsOfferingNativeCloudConnection(_serialization.Model):
    """The native cloud connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs):
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class CustomAssessmentAutomation(Resource):  # pylint: disable=too-many-instance-attributes
    """Custom Assessment Automation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.v2021_07_01_preview.models.SystemData
    :ivar compressed_query: GZip encoded KQL query representing the assessment automation results
     required.
    :vartype compressed_query: str
    :ivar supported_cloud: Relevant cloud for the custom assessment automation. Known values are:
     "AWS" and "GCP".
    :vartype supported_cloud: str or
     ~azure.mgmt.security.v2021_07_01_preview.models.SupportedCloudEnum
    :ivar severity: The severity to relate to the assessments generated by this assessment
     automation. Known values are: "High", "Medium", and "Low".
    :vartype severity: str or ~azure.mgmt.security.v2021_07_01_preview.models.SeverityEnum
    :ivar display_name: The display name of the assessments generated by this assessment
     automation.
    :vartype display_name: str
    :ivar description: The description to relate to the assessments generated by this assessment
     automation.
    :vartype description: str
    :ivar remediation_description: The remediation description to relate to the assessments
     generated by this assessment automation.
    :vartype remediation_description: str
    :ivar assessment_key: The assessment metadata key used when an assessment is generated for this
     assessment automation.
    :vartype assessment_key: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "compressed_query": {"key": "properties.compressedQuery", "type": "str"},
        "supported_cloud": {"key": "properties.supportedCloud", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_description": {"key": "properties.remediationDescription", "type": "str"},
        "assessment_key": {"key": "properties.assessmentKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        compressed_query: Optional[str] = None,
        supported_cloud: Optional[Union[str, "_models.SupportedCloudEnum"]] = None,
        severity: Optional[Union[str, "_models.SeverityEnum"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        assessment_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword compressed_query: GZip encoded KQL query representing the assessment automation
         results required.
        :paramtype compressed_query: str
        :keyword supported_cloud: Relevant cloud for the custom assessment automation. Known values
         are: "AWS" and "GCP".
        :paramtype supported_cloud: str or
         ~azure.mgmt.security.v2021_07_01_preview.models.SupportedCloudEnum
        :keyword severity: The severity to relate to the assessments generated by this assessment
         automation. Known values are: "High", "Medium", and "Low".
        :paramtype severity: str or ~azure.mgmt.security.v2021_07_01_preview.models.SeverityEnum
        :keyword display_name: The display name of the assessments generated by this assessment
         automation.
        :paramtype display_name: str
        :keyword description: The description to relate to the assessments generated by this assessment
         automation.
        :paramtype description: str
        :keyword remediation_description: The remediation description to relate to the assessments
         generated by this assessment automation.
        :paramtype remediation_description: str
        :keyword assessment_key: The assessment metadata key used when an assessment is generated for
         this assessment automation.
        :paramtype assessment_key: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.compressed_query = compressed_query
        self.supported_cloud = supported_cloud
        self.severity = severity
        self.display_name = display_name
        self.description = description
        self.remediation_description = remediation_description
        self.assessment_key = assessment_key


class CustomAssessmentAutomationRequest(Resource):
    """Custom Assessment Automation request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar compressed_query: Base 64 encoded KQL query representing the assessment automation
     results required.
    :vartype compressed_query: str
    :ivar supported_cloud: Relevant cloud for the custom assessment automation. Known values are:
     "AWS" and "GCP".
    :vartype supported_cloud: str or
     ~azure.mgmt.security.v2021_07_01_preview.models.SupportedCloudEnum
    :ivar severity: The severity to relate to the assessments generated by this assessment
     automation. Known values are: "High", "Medium", and "Low".
    :vartype severity: str or ~azure.mgmt.security.v2021_07_01_preview.models.SeverityEnum
    :ivar display_name: The display name of the assessments generated by this assessment
     automation.
    :vartype display_name: str
    :ivar description: The description to relate to the assessments generated by this assessment
     automation.
    :vartype description: str
    :ivar remediation_description: The remediation description to relate to the assessments
     generated by this assessment automation.
    :vartype remediation_description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "compressed_query": {"key": "properties.compressedQuery", "type": "str"},
        "supported_cloud": {"key": "properties.supportedCloud", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_description": {"key": "properties.remediationDescription", "type": "str"},
    }

    def __init__(
        self,
        *,
        compressed_query: Optional[str] = None,
        supported_cloud: Optional[Union[str, "_models.SupportedCloudEnum"]] = None,
        severity: Optional[Union[str, "_models.SeverityEnum"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword compressed_query: Base 64 encoded KQL query representing the assessment automation
         results required.
        :paramtype compressed_query: str
        :keyword supported_cloud: Relevant cloud for the custom assessment automation. Known values
         are: "AWS" and "GCP".
        :paramtype supported_cloud: str or
         ~azure.mgmt.security.v2021_07_01_preview.models.SupportedCloudEnum
        :keyword severity: The severity to relate to the assessments generated by this assessment
         automation. Known values are: "High", "Medium", and "Low".
        :paramtype severity: str or ~azure.mgmt.security.v2021_07_01_preview.models.SeverityEnum
        :keyword display_name: The display name of the assessments generated by this assessment
         automation.
        :paramtype display_name: str
        :keyword description: The description to relate to the assessments generated by this assessment
         automation.
        :paramtype description: str
        :keyword remediation_description: The remediation description to relate to the assessments
         generated by this assessment automation.
        :paramtype remediation_description: str
        """
        super().__init__(**kwargs)
        self.compressed_query = compressed_query
        self.supported_cloud = supported_cloud
        self.severity = severity
        self.display_name = display_name
        self.description = description
        self.remediation_description = remediation_description


class CustomAssessmentAutomationsListResult(_serialization.Model):
    """A list of Custom Assessment Automations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of Custom Assessment Automations.
    :vartype value:
     list[~azure.mgmt.security.v2021_07_01_preview.models.CustomAssessmentAutomation]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomAssessmentAutomation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CustomEntityStoreAssignment(Resource):
    """Custom entity store assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.v2021_07_01_preview.models.SystemData
    :ivar principal: The principal assigned with entity store. Format of principal is: [AAD
     type]=[PrincipalObjectId];[TenantId].
    :vartype principal: str
    :ivar entity_store_database_link: The link to entity store database.
    :vartype entity_store_database_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "principal": {"key": "properties.principal", "type": "str"},
        "entity_store_database_link": {"key": "properties.entityStoreDatabaseLink", "type": "str"},
    }

    def __init__(self, *, principal: Optional[str] = None, entity_store_database_link: Optional[str] = None, **kwargs):
        """
        :keyword principal: The principal assigned with entity store. Format of principal is: [AAD
         type]=[PrincipalObjectId];[TenantId].
        :paramtype principal: str
        :keyword entity_store_database_link: The link to entity store database.
        :paramtype entity_store_database_link: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.principal = principal
        self.entity_store_database_link = entity_store_database_link


class CustomEntityStoreAssignmentRequest(_serialization.Model):
    """describes the custom entity store assignment request.

    :ivar principal: The principal assigned with entity store. If not provided, will use caller
     principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId].
    :vartype principal: str
    """

    _attribute_map = {
        "principal": {"key": "properties.principal", "type": "str"},
    }

    def __init__(self, *, principal: Optional[str] = None, **kwargs):
        """
        :keyword principal: The principal assigned with entity store. If not provided, will use caller
         principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId].
        :paramtype principal: str
        """
        super().__init__(**kwargs)
        self.principal = principal


class CustomEntityStoreAssignmentsListResult(_serialization.Model):
    """A list of custom entity store assignments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of custom entity store assignments.
    :vartype value:
     list[~azure.mgmt.security.v2021_07_01_preview.models.CustomEntityStoreAssignment]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomEntityStoreAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class DefenderForContainersAwsOffering(CloudOffering):
    """The Defender for Containers AWS offering configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws", and
     "InformationProtectionAws".
    :vartype offering_type: str or ~azure.mgmt.security.v2021_07_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar kubernetes_service: The kubernetes service connection configuration.
    :vartype kubernetes_service:
     ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForContainersAwsOfferingKubernetesService
    :ivar kubernetes_scuba_reader: The kubernetes to scuba connection configuration.
    :vartype kubernetes_scuba_reader:
     ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForContainersAwsOfferingKubernetesScubaReader
    :ivar cloud_watch_to_kinesis: The cloudwatch to kinesis connection configuration.
    :vartype cloud_watch_to_kinesis:
     ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForContainersAwsOfferingCloudWatchToKinesis
    :ivar kinesis_to_s3: The kinesis to s3 connection configuration.
    :vartype kinesis_to_s3:
     ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForContainersAwsOfferingKinesisToS3
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "kubernetes_service": {"key": "kubernetesService", "type": "DefenderForContainersAwsOfferingKubernetesService"},
        "kubernetes_scuba_reader": {
            "key": "kubernetesScubaReader",
            "type": "DefenderForContainersAwsOfferingKubernetesScubaReader",
        },
        "cloud_watch_to_kinesis": {
            "key": "cloudWatchToKinesis",
            "type": "DefenderForContainersAwsOfferingCloudWatchToKinesis",
        },
        "kinesis_to_s3": {"key": "kinesisToS3", "type": "DefenderForContainersAwsOfferingKinesisToS3"},
    }

    def __init__(
        self,
        *,
        kubernetes_service: Optional["_models.DefenderForContainersAwsOfferingKubernetesService"] = None,
        kubernetes_scuba_reader: Optional["_models.DefenderForContainersAwsOfferingKubernetesScubaReader"] = None,
        cloud_watch_to_kinesis: Optional["_models.DefenderForContainersAwsOfferingCloudWatchToKinesis"] = None,
        kinesis_to_s3: Optional["_models.DefenderForContainersAwsOfferingKinesisToS3"] = None,
        **kwargs
    ):
        """
        :keyword kubernetes_service: The kubernetes service connection configuration.
        :paramtype kubernetes_service:
         ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForContainersAwsOfferingKubernetesService
        :keyword kubernetes_scuba_reader: The kubernetes to scuba connection configuration.
        :paramtype kubernetes_scuba_reader:
         ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForContainersAwsOfferingKubernetesScubaReader
        :keyword cloud_watch_to_kinesis: The cloudwatch to kinesis connection configuration.
        :paramtype cloud_watch_to_kinesis:
         ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForContainersAwsOfferingCloudWatchToKinesis
        :keyword kinesis_to_s3: The kinesis to s3 connection configuration.
        :paramtype kinesis_to_s3:
         ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForContainersAwsOfferingKinesisToS3
        """
        super().__init__(**kwargs)
        self.offering_type = "DefenderForContainersAws"  # type: str
        self.kubernetes_service = kubernetes_service
        self.kubernetes_scuba_reader = kubernetes_scuba_reader
        self.cloud_watch_to_kinesis = cloud_watch_to_kinesis
        self.kinesis_to_s3 = kinesis_to_s3


class DefenderForContainersAwsOfferingCloudWatchToKinesis(_serialization.Model):
    """The cloudwatch to kinesis connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs):
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingKinesisToS3(_serialization.Model):
    """The kinesis to s3 connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs):
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingKubernetesScubaReader(_serialization.Model):
    """The kubernetes to scuba connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs):
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingKubernetesService(_serialization.Model):
    """The kubernetes service connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs):
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForServersAwsOffering(CloudOffering):
    """The Defender for Servers AWS offering configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws", and
     "InformationProtectionAws".
    :vartype offering_type: str or ~azure.mgmt.security.v2021_07_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar defender_for_servers: The Defender for servers connection configuration.
    :vartype defender_for_servers:
     ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForServersAwsOfferingDefenderForServers
    :ivar arc_auto_provisioning: The ARC autoprovisioning configuration.
    :vartype arc_auto_provisioning:
     ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForServersAwsOfferingArcAutoProvisioning
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "defender_for_servers": {
            "key": "defenderForServers",
            "type": "DefenderForServersAwsOfferingDefenderForServers",
        },
        "arc_auto_provisioning": {
            "key": "arcAutoProvisioning",
            "type": "DefenderForServersAwsOfferingArcAutoProvisioning",
        },
    }

    def __init__(
        self,
        *,
        defender_for_servers: Optional["_models.DefenderForServersAwsOfferingDefenderForServers"] = None,
        arc_auto_provisioning: Optional["_models.DefenderForServersAwsOfferingArcAutoProvisioning"] = None,
        **kwargs
    ):
        """
        :keyword defender_for_servers: The Defender for servers connection configuration.
        :paramtype defender_for_servers:
         ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForServersAwsOfferingDefenderForServers
        :keyword arc_auto_provisioning: The ARC autoprovisioning configuration.
        :paramtype arc_auto_provisioning:
         ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForServersAwsOfferingArcAutoProvisioning
        """
        super().__init__(**kwargs)
        self.offering_type = "DefenderForServersAws"  # type: str
        self.defender_for_servers = defender_for_servers
        self.arc_auto_provisioning = arc_auto_provisioning


class DefenderForServersAwsOfferingArcAutoProvisioning(_serialization.Model):
    """The ARC autoprovisioning configuration.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar service_principal_secret_metadata: Metadata of Service Principal secret for
     autoprovisioning.
    :vartype service_principal_secret_metadata:
     ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForServersAwsOfferingArcAutoProvisioningServicePrincipalSecretMetadata
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "service_principal_secret_metadata": {
            "key": "servicePrincipalSecretMetadata",
            "type": "DefenderForServersAwsOfferingArcAutoProvisioningServicePrincipalSecretMetadata",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        service_principal_secret_metadata: Optional[
            "_models.DefenderForServersAwsOfferingArcAutoProvisioningServicePrincipalSecretMetadata"
        ] = None,
        **kwargs
    ):
        """
        :keyword enabled: Is arc auto provisioning enabled.
        :paramtype enabled: bool
        :keyword service_principal_secret_metadata: Metadata of Service Principal secret for
         autoprovisioning.
        :paramtype service_principal_secret_metadata:
         ~azure.mgmt.security.v2021_07_01_preview.models.DefenderForServersAwsOfferingArcAutoProvisioningServicePrincipalSecretMetadata
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.service_principal_secret_metadata = service_principal_secret_metadata


class DefenderForServersAwsOfferingArcAutoProvisioningServicePrincipalSecretMetadata(_serialization.Model):
    """Metadata of Service Principal secret for autoprovisioning.

    :ivar expiry_date: expiration date of service principal secret.
    :vartype expiry_date: str
    :ivar parameter_store_region: region of parameter store where secret is kept.
    :vartype parameter_store_region: str
    :ivar parameter_name_in_store: name of secret resource in parameter store.
    :vartype parameter_name_in_store: str
    """

    _attribute_map = {
        "expiry_date": {"key": "expiryDate", "type": "str"},
        "parameter_store_region": {"key": "parameterStoreRegion", "type": "str"},
        "parameter_name_in_store": {"key": "parameterNameInStore", "type": "str"},
    }

    def __init__(
        self,
        *,
        expiry_date: Optional[str] = None,
        parameter_store_region: Optional[str] = None,
        parameter_name_in_store: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword expiry_date: expiration date of service principal secret.
        :paramtype expiry_date: str
        :keyword parameter_store_region: region of parameter store where secret is kept.
        :paramtype parameter_store_region: str
        :keyword parameter_name_in_store: name of secret resource in parameter store.
        :paramtype parameter_name_in_store: str
        """
        super().__init__(**kwargs)
        self.expiry_date = expiry_date
        self.parameter_store_region = parameter_store_region
        self.parameter_name_in_store = parameter_name_in_store


class DefenderForServersAwsOfferingDefenderForServers(_serialization.Model):
    """The Defender for servers connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs):
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ETag(_serialization.Model):
    """Entity tag is used for comparing two or more entities from the same requested resource.

    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    """

    _attribute_map = {
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.etag = etag


class InformationProtectionAwsOffering(CloudOffering):
    """The information protection for AWS offering configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws", and
     "InformationProtectionAws".
    :vartype offering_type: str or ~azure.mgmt.security.v2021_07_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar information_protection: The native cloud connection configuration.
    :vartype information_protection:
     ~azure.mgmt.security.v2021_07_01_preview.models.InformationProtectionAwsOfferingInformationProtection
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "information_protection": {
            "key": "informationProtection",
            "type": "InformationProtectionAwsOfferingInformationProtection",
        },
    }

    def __init__(
        self,
        *,
        information_protection: Optional["_models.InformationProtectionAwsOfferingInformationProtection"] = None,
        **kwargs
    ):
        """
        :keyword information_protection: The native cloud connection configuration.
        :paramtype information_protection:
         ~azure.mgmt.security.v2021_07_01_preview.models.InformationProtectionAwsOfferingInformationProtection
        """
        super().__init__(**kwargs)
        self.offering_type = "InformationProtectionAws"  # type: str
        self.information_protection = information_protection


class InformationProtectionAwsOfferingInformationProtection(_serialization.Model):
    """The native cloud connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs):
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class Kind(_serialization.Model):
    """Describes an Azure resource with kind.

    :ivar kind: Kind of the resource.
    :vartype kind: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs):
        """
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.kind = kind


class Tags(_serialization.Model):
    """A list of key value pairs that describe the resource.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class TrackedResource(Resource, AzureTrackedResourceLocation, Kind, ETag, Tags):
    """Describes an Azure tracked resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        """
        super().__init__(location=location, kind=kind, etag=etag, tags=tags, **kwargs)
        self.tags = tags
        self.etag = etag
        self.kind = kind
        self.location = location
        self.id = None
        self.name = None
        self.type = None


class SecurityConnector(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The security connector resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.v2021_07_01_preview.models.SystemData
    :ivar hierarchy_identifier: The multi cloud resource identifier (account id in case of AWS
     connector).
    :vartype hierarchy_identifier: str
    :ivar cloud_name: The multi cloud resource's cloud name. Known values are: "Azure", "AWS", and
     "GCP".
    :vartype cloud_name: str or ~azure.mgmt.security.v2021_07_01_preview.models.CloudName
    :ivar offerings: A collection of offerings for the security connector.
    :vartype offerings: list[~azure.mgmt.security.v2021_07_01_preview.models.CloudOffering]
    :ivar organizational_data: The multi cloud account's organizational data.
    :vartype organizational_data:
     ~azure.mgmt.security.v2021_07_01_preview.models.SecurityConnectorPropertiesOrganizationalData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "hierarchy_identifier": {"key": "properties.hierarchyIdentifier", "type": "str"},
        "cloud_name": {"key": "properties.cloudName", "type": "str"},
        "offerings": {"key": "properties.offerings", "type": "[CloudOffering]"},
        "organizational_data": {
            "key": "properties.organizationalData",
            "type": "SecurityConnectorPropertiesOrganizationalData",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        hierarchy_identifier: Optional[str] = None,
        cloud_name: Optional[Union[str, "_models.CloudName"]] = None,
        offerings: Optional[List["_models.CloudOffering"]] = None,
        organizational_data: Optional["_models.SecurityConnectorPropertiesOrganizationalData"] = None,
        **kwargs
    ):
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        :keyword hierarchy_identifier: The multi cloud resource identifier (account id in case of AWS
         connector).
        :paramtype hierarchy_identifier: str
        :keyword cloud_name: The multi cloud resource's cloud name. Known values are: "Azure", "AWS",
         and "GCP".
        :paramtype cloud_name: str or ~azure.mgmt.security.v2021_07_01_preview.models.CloudName
        :keyword offerings: A collection of offerings for the security connector.
        :paramtype offerings: list[~azure.mgmt.security.v2021_07_01_preview.models.CloudOffering]
        :keyword organizational_data: The multi cloud account's organizational data.
        :paramtype organizational_data:
         ~azure.mgmt.security.v2021_07_01_preview.models.SecurityConnectorPropertiesOrganizationalData
        """
        super().__init__(tags=tags, etag=etag, kind=kind, location=location, **kwargs)
        self.system_data = None
        self.hierarchy_identifier = hierarchy_identifier
        self.cloud_name = cloud_name
        self.offerings = offerings
        self.organizational_data = organizational_data


class SecurityConnectorPropertiesOrganizationalData(_serialization.Model):
    """The multi cloud account's organizational data.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.v2021_07_01_preview.models.OrganizationMembershipType
    :ivar parent_hierarchy_id: If the multi cloud account is not of membership type organization,
     this will be the ID of the account's parent.
    :vartype parent_hierarchy_id: str
    :ivar stackset_name: If the multi cloud account is of membership type organization, this will
     be the name of the onboarding stackset.
    :vartype stackset_name: str
    :ivar excluded_account_ids: If the multi cloud account is of membership type organization, list
     of accounts excluded from offering.
    :vartype excluded_account_ids: list[str]
    """

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
        "parent_hierarchy_id": {"key": "parentHierarchyId", "type": "str"},
        "stackset_name": {"key": "stacksetName", "type": "str"},
        "excluded_account_ids": {"key": "excludedAccountIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        organization_membership_type: Optional[Union[str, "_models.OrganizationMembershipType"]] = None,
        parent_hierarchy_id: Optional[str] = None,
        stackset_name: Optional[str] = None,
        excluded_account_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword organization_membership_type: The multi cloud account's membership type in the
         organization. Known values are: "Member" and "Organization".
        :paramtype organization_membership_type: str or
         ~azure.mgmt.security.v2021_07_01_preview.models.OrganizationMembershipType
        :keyword parent_hierarchy_id: If the multi cloud account is not of membership type
         organization, this will be the ID of the account's parent.
        :paramtype parent_hierarchy_id: str
        :keyword stackset_name: If the multi cloud account is of membership type organization, this
         will be the name of the onboarding stackset.
        :paramtype stackset_name: str
        :keyword excluded_account_ids: If the multi cloud account is of membership type organization,
         list of accounts excluded from offering.
        :paramtype excluded_account_ids: list[str]
        """
        super().__init__(**kwargs)
        self.organization_membership_type = organization_membership_type
        self.parent_hierarchy_id = parent_hierarchy_id
        self.stackset_name = stackset_name
        self.excluded_account_ids = excluded_account_ids


class SecurityConnectorsList(_serialization.Model):
    """List of security connectors response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of security connectors under the given scope. Required.
    :vartype value: list[~azure.mgmt.security.v2021_07_01_preview.models.SecurityConnector]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityConnector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SecurityConnector"], **kwargs):
        """
        :keyword value: The list of security connectors under the given scope. Required.
        :paramtype value: list[~azure.mgmt.security.v2021_07_01_preview.models.SecurityConnector]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.security.v2021_07_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.security.v2021_07_01_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.security.v2021_07_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.security.v2021_07_01_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
