/* $Cambridge: hermes/src/prayer/cmd/cmd_logout.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_logout(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct request *request = session->request;
    struct prefs *prefs = session->options->prefs;
    struct buffer *b = request->write_buffer;
    char *back = pool_join(request->pool, '/', &request->argv[1]);

    if (!prefs->confirm_logout) {
        session_redirect(session, request, "exit");
        return;
    }

    template_vals_string(tvals, "cancel", back);
    session_seed_template(session, tvals);
    template_expand("logout", tvals, b);
    response_html(request, 200);
}
