/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class TimingNote {
    private final TimeTick when;
    private final Player player;
    private final Display note;
    private final Position position;
    private final ISkinParam skinParam;

    public TimingNote(TimeTick when, Player player, Display note, Position position, ISkinParam skinParam) {
        this.note = note;
        this.player = player;
        this.when = when;
        this.skinParam = skinParam;
        this.position = position;
    }

    public void drawU(UGraphic ug) {
        if (this.position == Position.BOTTOM) {
            ug = ug.apply(UTranslate.dy(this.getMarginY() / 2.0));
        }
        this.createOpale().drawU(ug);
    }

    private Opale createOpale() {
        FontConfiguration fc = new FontConfiguration(this.skinParam, FontParam.NOTE, null);
        Rose rose = new Rose();
        HColor noteBackgroundColor = rose.getHtmlColor(this.skinParam, ColorParam.noteBackground);
        HColor borderColor = rose.getHtmlColor(this.skinParam, ColorParam.noteBorder);
        Sheet sheet = Parser.build(fc, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.skinParam, CreoleMode.FULL).createSheet(this.note);
        SheetBlock1 sheet1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        double shadowing = this.skinParam.shadowing(null) ? 4.0 : 0.0;
        Opale opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheet1, false);
        return opale;
    }

    public double getHeight(StringBounder stringBounder) {
        return this.createOpale().calculateDimension(stringBounder).getHeight() + this.getMarginY();
    }

    private double getMarginY() {
        return 10.0;
    }

    public TimeTick getWhen() {
        return this.when;
    }

    public final Position getPosition() {
        return this.position;
    }
}

