/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.turbine.util.Log;
import org.chefproject.core.Event;
import org.chefproject.service.EventTrackingService;
import org.chefproject.util.ObservingCourier;

public class EventObservingCourier
extends ObservingCourier
implements SessionStateBindingListener {
    protected String m_resourcePattern = null;

    public EventObservingCourier(String deliveryId, String elementId, String resourcePattern) {
        super(deliveryId, elementId);
        this.m_resourcePattern = resourcePattern;
        EventTrackingService.addObserver(this);
    }

    public String getResourcePattern() {
        return this.m_resourcePattern;
    }

    public void setResourcePattern(String pattern) {
        this.m_resourcePattern = pattern;
    }

    protected boolean check(Object arg) {
        if (!(arg instanceof Event)) {
            return false;
        }
        Event event = (Event)arg;
        if (!event.getModify()) {
            return false;
        }
        String key = null;
        if (this.m_resourcePattern != null && !(key = event.getResource()).startsWith(this.m_resourcePattern)) {
            return false;
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".update() [" + this.m_resourcePattern + "] resource: " + key + " event: " + event.getEvent());
        }
        return true;
    }

    protected void finalize() {
        EventTrackingService.deleteObserver(this);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".finalize()");
        }
    }

    public void valueBound(String sessionStateKey, String attributeName) {
    }

    public void valueUnbound(String sessionStateKey, String attributeName) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".valueUnbound()");
        }
        EventTrackingService.deleteObserver(this);
    }
}

