/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.turbine.util.Log;
import org.chefproject.core.DiscussionChannel;
import org.chefproject.core.DiscussionChannelEdit;
import org.chefproject.core.DiscussionMessage;
import org.chefproject.core.DiscussionMessageEdit;
import org.chefproject.core.DiscussionMessageHeader;
import org.chefproject.core.DiscussionMessageHeaderEdit;
import org.chefproject.core.Edit;
import org.chefproject.core.Filter;
import org.chefproject.core.Message;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.MessageHeader;
import org.chefproject.core.MessageHeaderEdit;
import org.chefproject.core.Resource;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.SecurityService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.component.BaseMessageService;
import org.chefproject.service.generic.GenericDiscussionService;
import org.chefproject.util.Different;
import org.chefproject.util.ReferenceVector;
import org.chefproject.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseDiscussionService
extends BaseMessageService
implements GenericDiscussionService {
    public Resource newContainer(String ref) {
        return new BaseDiscussionChannelEdit(ref);
    }

    public Resource newContainer(Element element) {
        return new BaseDiscussionChannelEdit(element);
    }

    public Resource newContainer(Resource other) {
        return new BaseDiscussionChannelEdit((MessageChannel)other);
    }

    public Resource newResource(Resource container, String id, Object[] others) {
        return new BaseDiscussionMessageEdit((MessageChannel)container, id);
    }

    public Resource newResource(Resource container, Element element) {
        return new BaseDiscussionMessageEdit((MessageChannel)container, element);
    }

    public Resource newResource(Resource container, Resource other) {
        return new BaseDiscussionMessageEdit((MessageChannel)container, (Message)other);
    }

    public Edit newContainerEdit(String ref) {
        BaseDiscussionChannelEdit rv = new BaseDiscussionChannelEdit(ref);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Element element) {
        BaseDiscussionChannelEdit rv = new BaseDiscussionChannelEdit(element);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Resource other) {
        BaseDiscussionChannelEdit rv = new BaseDiscussionChannelEdit((MessageChannel)other);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, String id, Object[] others) {
        BaseDiscussionMessageEdit rv = new BaseDiscussionMessageEdit((MessageChannel)container, id);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, Element element) {
        BaseDiscussionMessageEdit rv = new BaseDiscussionMessageEdit((MessageChannel)container, element);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, Resource other) {
        BaseDiscussionMessageEdit rv = new BaseDiscussionMessageEdit((MessageChannel)container, (Message)other);
        rv.activate();
        return rv;
    }

    public Object[] storageFields(Resource r) {
        Object[] rv = new Object[]{((Message)r).getHeader().getDate()};
        return rv;
    }

    protected MessageHeaderEdit newMessageHeader(String id) {
        return new BaseDiscussionMessageHeaderEdit(id);
    }

    protected MessageHeaderEdit newMessageHeader(Element el) {
        return new BaseDiscussionMessageHeaderEdit(el);
    }

    protected MessageHeaderEdit newMessageHeader(MessageHeader other) {
        return new BaseDiscussionMessageHeaderEdit(other);
    }

    protected String eventId(String secure) {
        return "disc." + secure;
    }

    protected String getReferenceRoot() {
        return "/discussion";
    }

    public DiscussionChannel getDiscussionChannel(String ref) throws IdUnusedException, PermissionException {
        return (DiscussionChannel)this.getChannel(ref);
    }

    public DiscussionChannelEdit addDiscussionChannel(String ref) throws IdUsedException, IdInvalidException, PermissionException {
        return (DiscussionChannelEdit)this.addChannel(ref);
    }

    protected class PrivacyFilter
    implements Filter {
        protected Filter m_filter = null;

        public PrivacyFilter(Filter filter) {
            this.m_filter = filter;
        }

        public boolean accept(Object o) {
            DiscussionMessage msg;
            if (o instanceof DiscussionMessage && (msg = (DiscussionMessage)o).getDiscussionHeader().getDraft() && !SecurityService.isSuperUser() && !msg.getHeader().getFrom().equals(UsageSessionService.getSessionUser()) && !BaseDiscussionService.this.unlockCheck("read.drafts", msg.getReference())) {
                return false;
            }
            if (this.m_filter != null) {
                return this.m_filter.accept(o);
            }
            return true;
        }
    }

    public class BaseDiscussionMessageHeaderEdit
    extends BaseMessageService.BaseMessageHeaderEdit
    implements DiscussionMessageHeaderEdit {
        protected String m_subject = null;
        protected boolean m_draft = true;
        protected String m_category = null;
        protected String m_replyTo = null;

        public BaseDiscussionMessageHeaderEdit(String id) {
            super((BaseMessageService)BaseDiscussionService.this, id);
        }

        public BaseDiscussionMessageHeaderEdit(Element el) {
            super((BaseMessageService)BaseDiscussionService.this, el);
            this.m_subject = el.getAttribute("subject");
            this.m_draft = new Boolean(el.getAttribute("draft"));
            this.m_category = el.getAttribute("category");
            this.m_replyTo = el.getAttribute("replyTo");
        }

        public BaseDiscussionMessageHeaderEdit(MessageHeader other) {
            super((BaseMessageService)BaseDiscussionService.this, other);
            this.m_draft = ((DiscussionMessageHeader)other).getDraft();
            this.m_subject = ((DiscussionMessageHeader)other).getSubject();
            this.m_category = ((DiscussionMessageHeader)other).getCategory();
            this.m_replyTo = ((DiscussionMessageHeader)other).getReplyTo();
        }

        public String getSubject() {
            return this.m_subject == null ? "" : this.m_subject;
        }

        public void setSubject(String subject) {
            if (Different.different(subject, this.m_subject)) {
                this.m_subject = subject;
            }
        }

        public boolean getDraft() {
            return this.m_draft;
        }

        public void setDraft(boolean draft) {
            if (draft != this.m_draft) {
                this.m_draft = draft;
            }
        }

        public String getCategory() {
            return this.m_category == null ? "" : this.m_category;
        }

        public void setCategory(String category) {
            if (Different.different(category, this.m_category)) {
                this.m_category = category;
            }
        }

        public String getReplyTo() {
            return this.m_replyTo == null ? "" : this.m_replyTo;
        }

        public void setReplyTo(String id) {
            if (Different.different(id, this.m_replyTo)) {
                this.m_replyTo = id;
            }
        }

        public Element toXml(Document doc, Stack stack) {
            Element header = super.toXml(doc, stack);
            header.setAttribute("subject", this.getSubject());
            header.setAttribute("draft", new Boolean(this.getDraft()).toString());
            header.setAttribute("category", this.getCategory());
            header.setAttribute("replyTo", this.getReplyTo());
            return header;
        }
    }

    public class BaseDiscussionMessageEdit
    extends BaseMessageService.BaseMessageEdit
    implements DiscussionMessageEdit {
        public BaseDiscussionMessageEdit(MessageChannel channel, String id) {
            super((BaseMessageService)BaseDiscussionService.this, channel, id);
        }

        public BaseDiscussionMessageEdit(MessageChannel channel, Message other) {
            super((BaseMessageService)BaseDiscussionService.this, channel, other);
        }

        public BaseDiscussionMessageEdit(MessageChannel channel, Element el) {
            super((BaseMessageService)BaseDiscussionService.this, channel, el);
        }

        public DiscussionMessageHeader getDiscussionHeader() {
            return (DiscussionMessageHeader)this.getHeader();
        }

        public DiscussionMessageHeaderEdit getDiscussionHeaderEdit() {
            return (DiscussionMessageHeaderEdit)this.getHeader();
        }

        public Iterator getReplies() {
            String id = this.getId();
            Filter filter = new Filter(this, id){
                private final /* synthetic */ String val$id;
                private final /* synthetic */ BaseDiscussionMessageEdit this$1;
                {
                    this.this$1 = this$1;
                    this.val$id = val$id;
                }

                public boolean accept(Object o) {
                    DiscussionMessage message = (DiscussionMessage)o;
                    return message.getDiscussionHeader().getReplyTo().equals(this.val$id) && (!message.getDiscussionHeader().getDraft() || SecurityService.isSuperUser() || message.getHeader().getFrom().equals(UsageSessionService.getSessionUser()) || BaseDiscussionMessageEdit.access$100(this.this$1).unlockCheck("read.drafts", message.getReference()));
                }
            };
            return ((BaseMessageService.BaseMessageChannelEdit)this.m_channel).findFilterMessages(filter, true).iterator();
        }

        public boolean hasReplies() {
            return this.getReplies().hasNext();
        }

        public int getReplyToDepth() {
            return this.getReplyToDepth(new HashSet());
        }

        protected int getReplyToDepth(HashSet messages) {
            if (this.getDiscussionHeader().getReplyTo().length() == 0) {
                return 0;
            }
            if (messages.contains(this)) {
                Log.warn("chef", this + ".getReplyToDepth(): looping found: " + this.getId());
                return 0;
            }
            try {
                messages.add(this);
                BaseDiscussionMessageEdit replyTo = (BaseDiscussionMessageEdit)((DiscussionChannel)this.m_channel).getDiscussionMessage(this.getDiscussionHeader().getReplyTo());
                return replyTo.getReplyToDepth(messages) + 1;
            }
            catch (IdUnusedException e) {
                Log.warn("chef", this + ".getReplyToDepth(): exception: " + e.toString());
                return 0;
            }
            catch (PermissionException e) {
                Log.warn("chef", this + ".getReplyToDepth(): exception: " + e.toString());
                return 0;
            }
        }

        public DiscussionMessage getLatestReply() {
            DiscussionMessage latest = null;
            Iterator replies = this.getReplies();
            while (replies.hasNext()) {
                latest = (DiscussionMessage)replies.next();
            }
            return latest;
        }

        public int getNumberOfReplies() {
            int count = 0;
            Iterator replies = this.getReplies();
            while (replies.hasNext()) {
                replies.next();
                ++count;
            }
            return count;
        }

        static /* synthetic */ BaseDiscussionService access$100(BaseDiscussionMessageEdit x0) {
            return x0.BaseDiscussionService.this;
        }
    }

    public class BaseDiscussionChannelEdit
    extends BaseMessageService.BaseMessageChannelEdit
    implements DiscussionChannelEdit {
        protected Vector m_categories = new Vector();

        public BaseDiscussionChannelEdit(String ref) {
            super((BaseMessageService)BaseDiscussionService.this, ref);
        }

        public BaseDiscussionChannelEdit(MessageChannel other) {
            super((BaseMessageService)BaseDiscussionService.this, other);
            this.m_categories.addAll(((BaseDiscussionChannelEdit)other).m_categories);
        }

        public BaseDiscussionChannelEdit(Element el) {
            super((BaseMessageService)BaseDiscussionService.this, el);
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("categories")) {
                    NodeList categories = element.getChildNodes();
                    int j = 0;
                    while (j < categories.getLength()) {
                        String cat;
                        Element eCategory;
                        Node category = categories.item(j);
                        if (category.getNodeType() == 1 && (eCategory = (Element)category).getTagName().equals("category") && (cat = eCategory.getAttribute("name")) != null && cat.length() != 0 && !this.m_categories.contains(cat)) {
                            this.m_categories.add(cat);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            String categories = this.getProperties().getProperty("CHEF:discussion-categories");
            if (categories != null && categories.length() > 0) {
                String[] cats = StringUtil.split(categories, ",");
                int i2 = 0;
                while (i2 < cats.length) {
                    if (cats[i2] != null && cats[i2].length() > 0 && !this.m_categories.contains(cats[i2])) {
                        this.m_categories.add(cats[i2]);
                    }
                    ++i2;
                }
                this.getPropertiesEdit().removeProperty("CHEF:discussion-categories");
            }
        }

        public Element toXml(Document doc, Stack stack) {
            Element channel = super.toXml(doc, stack);
            Element categories = doc.createElement("categories");
            channel.appendChild(categories);
            int i = 0;
            while (i < this.m_categories.size()) {
                Element cElement = doc.createElement("category");
                categories.appendChild(cElement);
                cElement.setAttribute("name", (String)this.m_categories.elementAt(i));
                ++i;
            }
            return channel;
        }

        public DiscussionMessage getDiscussionMessage(String messageId) throws IdUnusedException, PermissionException {
            DiscussionMessage msg = (DiscussionMessage)this.getMessage(messageId);
            if (msg.getDiscussionHeader().getDraft() && !SecurityService.isSuperUser() && !msg.getHeader().getFrom().equals(UsageSessionService.getSessionUser()) && !BaseDiscussionService.this.unlockCheck("read.drafts", msg.getReference())) {
                throw new PermissionException(UsageSessionService.getSessionUser().getId(), "read", msg.getReference());
            }
            return msg;
        }

        public List getMessages(Filter filter, boolean ascending) throws PermissionException {
            filter = new PrivacyFilter(filter);
            return super.getMessages(filter, ascending);
        }

        public DiscussionMessageEdit editDiscussionMessage(String messageId) throws IdUnusedException, PermissionException, InUseException {
            return (DiscussionMessageEdit)this.editMessage(messageId);
        }

        public boolean allowAddTopicMessage() {
            return BaseDiscussionService.this.unlockCheck("new.topic", this.getReference());
        }

        public DiscussionMessageEdit addDiscussionMessage(String replyTo) throws PermissionException {
            if (replyTo == null || replyTo.trim().length() == 0) {
                BaseDiscussionService.this.unlock("new.topic", this.getReference());
            }
            DiscussionMessageEdit edit = (DiscussionMessageEdit)this.addMessage();
            edit.getDiscussionHeaderEdit().setReplyTo(replyTo);
            return edit;
        }

        public DiscussionMessage addDiscussionMessage(String category, String subject, boolean draft, String replyTo, ReferenceVector attachments, String body) throws PermissionException {
            DiscussionMessageEdit edit = (DiscussionMessageEdit)this.addMessage();
            DiscussionMessageHeaderEdit header = edit.getDiscussionHeaderEdit();
            edit.setBody(body);
            header.replaceAttachments(attachments);
            header.setSubject(subject);
            header.setDraft(draft);
            header.setReplyTo(replyTo);
            header.setCategory(category);
            this.commitMessage(edit);
            return edit;
        }

        public String[] getCategories() {
            HashSet<String> categories = new HashSet<String>();
            categories.addAll(this.m_categories);
            Iterator it = this.findMessages().iterator();
            while (it.hasNext()) {
                DiscussionMessage msg = (DiscussionMessage)it.next();
                categories.add(msg.getDiscussionHeader().getCategory());
            }
            if (categories.size() == 0) {
                return null;
            }
            return categories.toArray(new String[categories.size()]);
        }

        public boolean addCategory(String category) throws PermissionException {
            BaseDiscussionService.this.unlock("new.topic", this.getReference());
            if (category != null && category.length() > 0 && !this.m_categories.contains(category)) {
                this.m_categories.add(category);
                return true;
            }
            return false;
        }

        public boolean removeCategory(String category) throws PermissionException {
            BaseDiscussionService.this.unlock("new.topic", this.getReference());
            if (category != null && category.length() > 0 && this.m_categories.contains(category)) {
                this.m_categories.remove(category);
                return true;
            }
            return false;
        }

        public Iterator getTopics(String category) {
            String catToMatch = category;
            Filter filter = new Filter(this, catToMatch){
                private final /* synthetic */ String val$catToMatch;
                private final /* synthetic */ BaseDiscussionChannelEdit this$1;
                {
                    this.this$1 = this$1;
                    this.val$catToMatch = val$catToMatch;
                }

                public boolean accept(Object o) {
                    DiscussionMessage message = (DiscussionMessage)o;
                    return !(message.getDiscussionHeader().getReplyTo().length() != 0 || this.val$catToMatch != null && this.val$catToMatch.length() != 0 && !this.val$catToMatch.equals(((DiscussionMessageHeader)message.getHeader()).getCategory()) || message.getDiscussionHeader().getDraft() && !SecurityService.isSuperUser() && !message.getHeader().getFrom().equals(UsageSessionService.getSessionUser()) && !BaseDiscussionChannelEdit.access$000(this.this$1).unlockCheck("read.drafts", message.getReference()));
                }
            };
            return this.findFilterMessages(filter, true).iterator();
        }

        protected Iterator threadIterator(Iterator topLevel) {
            Stack<Iterator> stack = new Stack<Iterator>();
            stack.push(topLevel);
            return new Iterator(this, stack){
                private Object m_next;
                private Stack m_stack;
                private Set m_alreadyReturned;
                private final /* synthetic */ Stack val$stack;
                private final /* synthetic */ BaseDiscussionChannelEdit this$1;
                {
                    this.this$1 = this$1;
                    this.val$stack = val$stack;
                    this.m_next = null;
                    this.m_stack = this.val$stack;
                    this.m_alreadyReturned = new HashSet<E>();
                }

                public Object next() {
                    this.hasNext();
                    if (this.m_next == null) {
                        throw new NoSuchElementException();
                    }
                    Object rv = this.m_next;
                    this.m_next = null;
                    this.m_alreadyReturned.add(rv);
                    return rv;
                }

                /*
                 * Unable to fully structure code
                 */
                public boolean hasNext() {
                    if (this.m_next == null) ** GOTO lbl5
                    return true;
lbl-1000:
                    // 1 sources

                    {
                        this.m_stack.pop();
lbl5:
                        // 2 sources

                        ** while (!this.m_stack.empty() && !((Iterator)this.m_stack.peek()).hasNext())
                    }
lbl6:
                    // 1 sources

                    if (this.m_stack.empty()) {
                        return false;
                    }
                    this.m_next = ((Iterator)this.m_stack.peek()).next();
                    if (!this.m_alreadyReturned.contains(this.m_next) && (replies = ((DiscussionMessage)this.m_next).getReplies()).hasNext()) {
                        this.m_stack.push(replies);
                    }
                    return true;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Iterator getThread(DiscussionMessage message) {
            Iterator topLevel = message.getReplies();
            return this.threadIterator(topLevel);
        }

        public Iterator getThreads(String category) {
            Iterator topLevel = this.getTopics(category);
            return this.threadIterator(topLevel);
        }

        public DiscussionMessage getThreadLatestReply(DiscussionMessage message) {
            DiscussionMessage latest = null;
            Iterator replies = this.getThread(message);
            while (replies.hasNext()) {
                if (latest == null) {
                    latest = (DiscussionMessage)replies.next();
                    continue;
                }
                DiscussionMessage test = (DiscussionMessage)replies.next();
                if (!test.getHeader().getDate().after(latest.getHeader().getDate())) continue;
                latest = test;
            }
            return latest;
        }

        public int getThreadNumberOfReplies(DiscussionMessage message) {
            int count = 0;
            Iterator replies = this.getThread(message);
            while (replies.hasNext()) {
                replies.next();
                ++count;
            }
            return count;
        }

        static /* synthetic */ BaseDiscussionService access$000(BaseDiscussionChannelEdit x0) {
            return x0.BaseDiscussionService.this;
        }
    }
}

