/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.rundata;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.pool.PoolService;
import org.apache.turbine.services.rundata.RunDataService;
import org.apache.turbine.services.rundata.TurbineRunData;
import org.apache.turbine.util.CookieParser;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.runtime.configuration.Configuration;

public class TurbineRunDataService
extends TurbineBaseService
implements RunDataService {
    public static final String RUN_DATA = "run.data";
    public static final String PARAMETER_PARSER = "parameter.parser";
    public static final String COOKIE_PARSER = "cookie.parser";
    private static final String DEFAULT_RUN_DATA = "org.apache.turbine.services.rundata.DefaultTurbineRunData";
    private static final String DEFAULT_PARAMETER_PARSER = "org.apache.turbine.util.parser.DefaultParameterParser";
    private static final String DEFAULT_COOKIE_PARSER = "org.apache.turbine.util.parser.DefaultCookieParser";
    private HashMap configurations = new HashMap();
    private Method getContextPath;
    private static /* synthetic */ Class class$Ljavax$servlet$http$HttpServletRequest;

    public void init() throws InitializationException {
        String[] def = new String[]{DEFAULT_RUN_DATA, DEFAULT_PARAMETER_PARSER, DEFAULT_COOKIE_PARSER};
        this.configurations.put("default", def.clone());
        Configuration conf = this.getConfiguration();
        if (conf != null) {
            String[] plist = new String[]{RUN_DATA, PARAMETER_PARSER, COOKIE_PARSER};
            Iterator i = conf.getKeys();
            block0: while (i.hasNext()) {
                String key = (String)i.next();
                String value = conf.getString(key);
                int j = 0;
                while (j < plist.length) {
                    if (key.endsWith(plist[j]) && key.length() > plist[j].length() + 1) {
                        String[] config = (String[])this.configurations.get(key = key.substring(0, key.length() - plist[j].length() - 1));
                        if (config == null) {
                            config = (String[])def.clone();
                            this.configurations.put(key, config);
                        }
                        config[j] = value;
                        continue block0;
                    }
                    ++j;
                }
            }
        }
        this.setInit(true);
    }

    public RunData getRunData(HttpServletRequest req, HttpServletResponse res, ServletConfig config) throws TurbineException {
        return this.getRunData("default", req, res, config);
    }

    public RunData getRunData(String key, HttpServletRequest req, HttpServletResponse res, ServletConfig config) throws TurbineException, IllegalArgumentException {
        String contextPath;
        TurbineRunData data;
        if (req == null || res == null || config == null) {
            throw new IllegalArgumentException("RunDataFactory fatal error: HttpServletRequest, HttpServletResponse or ServletConfig was null.");
        }
        String[] cfg = (String[])this.configurations.get(key);
        if (cfg == null) {
            throw new TurbineException("RunTime configuration '" + key + "' is undefined");
        }
        PoolService pool = (PoolService)TurbineServices.getInstance().getService("PoolService");
        try {
            data = (TurbineRunData)pool.getInstance(cfg[0]);
            data.setParameterParser((ParameterParser)pool.getInstance(cfg[1]));
            data.setCookieParser((CookieParser)pool.getInstance(cfg[2]));
        }
        catch (ClassCastException x) {
            throw new TurbineException("RunData configuration '" + key + "' is illegal", x);
        }
        data.setRequest(req);
        data.setResponse(res);
        data.setSession(data.getRequest().getSession(true));
        data.setServletConfig(config);
        try {
            String x = this.getContextPath != null ? (String)this.getContextPath.invoke((Object)req, null) : "";
        }
        catch (Exception x) {
            contextPath = "";
        }
        String scriptName = contextPath + req.getServletPath();
        data.setServerData(new ServerData(req.getServerName(), req.getServerPort(), req.getScheme(), scriptName, contextPath));
        return data;
    }

    public boolean putRunData(RunData data) {
        if (data instanceof TurbineRunData) {
            PoolService pool = (PoolService)TurbineServices.getInstance().getService("PoolService");
            pool.putInstance(((TurbineRunData)data).getParameterParser());
            pool.putInstance(((TurbineRunData)data).getCookieParser());
            return pool.putInstance(data);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TurbineRunDataService() {
        try {
            this.getContextPath = (class$Ljavax$servlet$http$HttpServletRequest != null ? class$Ljavax$servlet$http$HttpServletRequest : (class$Ljavax$servlet$http$HttpServletRequest = TurbineRunDataService.class$("javax.servlet.http.HttpServletRequest"))).getDeclaredMethod("getContextPath", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

