// |reftest| skip-if(!this.hasOwnProperty("Intl"))

// Generated by make_intl_data.py. DO NOT EDIT.

const sanctionedSimpleUnitIdentifiers = [
    "acre",
    "bit",
    "byte",
    "celsius",
    "centimeter",
    "day",
    "degree",
    "fahrenheit",
    "fluid-ounce",
    "foot",
    "gallon",
    "gigabit",
    "gigabyte",
    "gram",
    "hectare",
    "hour",
    "inch",
    "kilobit",
    "kilobyte",
    "kilogram",
    "kilometer",
    "liter",
    "megabit",
    "megabyte",
    "meter",
    "mile",
    "mile-scandinavian",
    "milliliter",
    "millimeter",
    "millisecond",
    "minute",
    "month",
    "ounce",
    "percent",
    "petabyte",
    "pound",
    "second",
    "stone",
    "terabit",
    "terabyte",
    "week",
    "yard",
    "year"
];

const allUnits = [
    "acceleration-g-force",
    "acceleration-meter-per-square-second",
    "angle-arc-minute",
    "angle-arc-second",
    "angle-degree",
    "angle-radian",
    "angle-revolution",
    "area-acre",
    "area-dunam",
    "area-hectare",
    "area-square-centimeter",
    "area-square-foot",
    "area-square-inch",
    "area-square-kilometer",
    "area-square-meter",
    "area-square-mile",
    "area-square-yard",
    "concentr-item",
    "concentr-karat",
    "concentr-milligram-ofglucose-per-deciliter",
    "concentr-millimole-per-liter",
    "concentr-mole",
    "concentr-percent",
    "concentr-permille",
    "concentr-permillion",
    "concentr-permyriad",
    "consumption-liter-per-100-kilometer",
    "consumption-liter-per-kilometer",
    "consumption-mile-per-gallon",
    "consumption-mile-per-gallon-imperial",
    "digital-bit",
    "digital-byte",
    "digital-gigabit",
    "digital-gigabyte",
    "digital-kilobit",
    "digital-kilobyte",
    "digital-megabit",
    "digital-megabyte",
    "digital-petabyte",
    "digital-terabit",
    "digital-terabyte",
    "duration-century",
    "duration-day",
    "duration-day-person",
    "duration-decade",
    "duration-hour",
    "duration-microsecond",
    "duration-millisecond",
    "duration-minute",
    "duration-month",
    "duration-month-person",
    "duration-nanosecond",
    "duration-second",
    "duration-week",
    "duration-week-person",
    "duration-year",
    "duration-year-person",
    "electric-ampere",
    "electric-milliampere",
    "electric-ohm",
    "electric-volt",
    "energy-british-thermal-unit",
    "energy-calorie",
    "energy-electronvolt",
    "energy-foodcalorie",
    "energy-joule",
    "energy-kilocalorie",
    "energy-kilojoule",
    "energy-kilowatt-hour",
    "energy-therm-us",
    "force-kilowatt-hour-per-100-kilometer",
    "force-newton",
    "force-pound-force",
    "frequency-gigahertz",
    "frequency-hertz",
    "frequency-kilohertz",
    "frequency-megahertz",
    "graphics-dot",
    "graphics-dot-per-centimeter",
    "graphics-dot-per-inch",
    "graphics-em",
    "graphics-megapixel",
    "graphics-pixel",
    "graphics-pixel-per-centimeter",
    "graphics-pixel-per-inch",
    "length-astronomical-unit",
    "length-centimeter",
    "length-decimeter",
    "length-earth-radius",
    "length-fathom",
    "length-foot",
    "length-furlong",
    "length-inch",
    "length-kilometer",
    "length-light-year",
    "length-meter",
    "length-micrometer",
    "length-mile",
    "length-mile-scandinavian",
    "length-millimeter",
    "length-nanometer",
    "length-nautical-mile",
    "length-parsec",
    "length-picometer",
    "length-point",
    "length-solar-radius",
    "length-yard",
    "light-candela",
    "light-lumen",
    "light-lux",
    "light-solar-luminosity",
    "mass-carat",
    "mass-dalton",
    "mass-earth-mass",
    "mass-grain",
    "mass-gram",
    "mass-kilogram",
    "mass-metric-ton",
    "mass-microgram",
    "mass-milligram",
    "mass-ounce",
    "mass-ounce-troy",
    "mass-pound",
    "mass-solar-mass",
    "mass-stone",
    "mass-ton",
    "power-gigawatt",
    "power-horsepower",
    "power-kilowatt",
    "power-megawatt",
    "power-milliwatt",
    "power-watt",
    "pressure-atmosphere",
    "pressure-bar",
    "pressure-hectopascal",
    "pressure-inch-ofhg",
    "pressure-kilopascal",
    "pressure-megapascal",
    "pressure-millibar",
    "pressure-millimeter-ofhg",
    "pressure-pascal",
    "pressure-pound-force-per-square-inch",
    "speed-kilometer-per-hour",
    "speed-knot",
    "speed-meter-per-second",
    "speed-mile-per-hour",
    "temperature-celsius",
    "temperature-fahrenheit",
    "temperature-generic",
    "temperature-kelvin",
    "torque-newton-meter",
    "torque-pound-force-foot",
    "volume-acre-foot",
    "volume-barrel",
    "volume-bushel",
    "volume-centiliter",
    "volume-cubic-centimeter",
    "volume-cubic-foot",
    "volume-cubic-inch",
    "volume-cubic-kilometer",
    "volume-cubic-meter",
    "volume-cubic-mile",
    "volume-cubic-yard",
    "volume-cup",
    "volume-cup-metric",
    "volume-deciliter",
    "volume-dessert-spoon",
    "volume-dessert-spoon-imperial",
    "volume-dram",
    "volume-drop",
    "volume-fluid-ounce",
    "volume-fluid-ounce-imperial",
    "volume-gallon",
    "volume-gallon-imperial",
    "volume-hectoliter",
    "volume-jigger",
    "volume-liter",
    "volume-megaliter",
    "volume-milliliter",
    "volume-pinch",
    "volume-pint",
    "volume-pint-metric",
    "volume-quart",
    "volume-quart-imperial",
    "volume-tablespoon",
    "volume-teaspoon"
];

// Test only sanctioned unit identifiers are allowed.

for (const typeAndUnit of allUnits) {
    const [_, type, unit] = typeAndUnit.match(/(\w+)-(.+)/);

    let allowed;
    if (unit.includes("-per-")) {
        const [numerator, denominator] = unit.split("-per-");
        allowed = sanctionedSimpleUnitIdentifiers.includes(numerator) &&
                  sanctionedSimpleUnitIdentifiers.includes(denominator);
    } else {
        allowed = sanctionedSimpleUnitIdentifiers.includes(unit);
    }

    if (allowed) {
        const nf = new Intl.NumberFormat("en", {style: "unit", unit});
        assertEq(nf.format(1), nf.formatToParts(1).map(p => p.value).join(""));
    } else {
        assertThrowsInstanceOf(() => new Intl.NumberFormat("en", {style: "unit", unit}),
                               RangeError, `Missing error for "${typeAndUnit}"`);
    }
}

if (typeof reportCompare === "function")
    reportCompare(true, true);
