# Mixxx Code of Conduct

The Mixxx team is committed to preserving and fostering a
diverse, welcoming community. Below is our community code of conduct, which
applies to our repos and organizations, mailing lists, forums, IRC channels,
blog content, and any
other Mixxx-supported communication group, as well as any private
communication initiated in the context of these spaces.

Simply put, community discussions should be

* respectful and kind;
* about Mixxx;
* about features and code, not the individuals involved.

## Be respectful and constructive

Treat everyone with respect. Build on each other's ideas. Each of us has the
right to enjoy our experience and participate without fear of harassment,
discrimination, or condescension, whether blatant or subtle. Remember that
Mixxx is a geographically distributed team and that you may not be
communicating with someone in their primary language. We all get frustrated
when working on hard problems, but we cannot allow that frustration to turn
into personal attacks.

## Speak up if you see or hear something

You are empowered to politely engage when you feel that you or others are
disrespected. The person making you feel uncomfortable may not be aware of what
they are doing - politely bringing their behavior to their attention is
encouraged.

If you are uncomfortable speaking up, or feel that your concerns are not being
duly considered, you can email community@mixxx.org to request involvement
from a community manager. You may also email any of the community managers
directly. All concerns shared with community managers will be kept
confidential. In cases where a public response is deemed necessary, the
identities of victims and reporters will remain confidential unless those
individuals instruct us otherwise.

While all reports will be taken seriously, the Mixxx community managers may
not act on complaints that they feel are not violations of this code of
conduct.

## No Tolerance for Harassment

We will not tolerate harassment of any kind, including but not limited to:

* Harassing comments
* Intimidation
* Encouraging a person to engage in self-harm.
* Sustained disruption or derailing of threads, channels, lists, etc.
* Offensive or violent comments, jokes or otherwise
* Inappropriate sexual content
* Unwelcome sexual or otherwise aggressive attention
* Continued one-on-one communication after requests to cease
* Distribution or threat of distribution of people's personally identifying
  information, AKA “doxing”

## Consequences for failing to comply with this policy

Consequences for failing to comply with this policy may include, at the sole
discretion of the Mixxx community managers:

* a request for an apology;
* a private or public warning or reprimand;
* a temporary ban from the mailing list, blog, Mixxx repository or
  organization, or other Mixxx-supported communication group, including
  loss of committer status;
* a permanent ban from any of the above, or from all current and future
  Mixxx-supported communities, including loss of
  committer status.

Participants warned to stop any harassing behavior are expected to comply
immediately; failure to do so will result in an escalation of consequences.

## Acknowledgements

This Code of Conduct is based on the Chromium Code of Conduct, which credits
the Geek Feminism Code of Conduct, the Django Code of Conduct and the Geek
Feminism Wiki "Effective codes of conduct" guide.

## License

This Code of Conduct is available for reuse under the Creative Commons Zero
(CC0) license.
