// Copyright (c) 2009, Jens Peter Secher <jpsecher@gmail.com>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

// Structure for holding an expanded Debian package version number, see Debian
// Policy section 5.6.2.

class DebianPackageVersion
{
	public var epoch (default,null) : Null<String>;
	public var upstream (default,null) : String;
	public var debianRevision (default,null) : Null<String>;

	public function new( v : String )
	{
		epoch = null;
		debianRevision = null;
		// Is there a Debian revision number?
		var debianRevisionRegExp = ~/^(.*)-([a-z0-9+.~]+)$/i;
		if( debianRevisionRegExp.match( v ) )
		{
			debianRevision = debianRevisionRegExp.matched( 2 );
			// Is there an epoch?
			var epochRegExp = ~/^([0-9]+):(.*)$/;
			if( epochRegExp.match( debianRevisionRegExp.matched( 1 ) ) )
			{
				epoch = epochRegExp.matched( 1 );
				upstream = epochRegExp.matched( 2 );
			}
			else
			{
				// No epoch.
				upstream = debianRevisionRegExp.matched( 1 );				
			}
		}
		else
		{
			// No Debian revision.
			// Is there an epoch?
			var epochRegExp = ~/^([0-9]+):(.*)$/;
			if( epochRegExp.match( v ) )
			{
				epoch = epochRegExp.matched( 1 );
				upstream = epochRegExp.matched( 2 );
			}
			else
			{
				// No epoch.
				upstream = v;
			}
			
		}
	}

	public function toString() : String
	{
		if( epoch != null ) return epoch + ':' + archiveVersion();
		else return archiveVersion();
	}

	//
	// The full version but without epoch.  Used for filename creation.
	//
	public function archiveVersion() : String
	{
		if( debianRevision != null ) return upstream + '-' + debianRevision;
		else return upstream;
	}
}
