document {
    Key => Matrix,
    Headline => "the class of all matrices",
    "A matrix is a homomorphism between two modules, together with
    an integer (or vector of integers) called its degree, which is
    used when determining whether the map is homogeneous.  The matrix
    is stored in the usual way as a rectangular array of ring elements.
    When the source or target modules are not free, the matrix is
    interpreted as a linear transformation in terms of the generators
    of the modules.",
    SeeAlso => "matrices",
    PARA{},
    "A matrix ", TT "f", " is an immutable object, so if you want to
    cache information about it, put it in the hash table ", TT "f.cache", ".",
    PARA{},
    "Common ways to make a matrix:",
    UL {
	TO "map",
	TO "matrix",
    },
    "Common ways to get information about matrices:",
    UL {
	TO (degree, Matrix),
	TO (isHomogeneous, Matrix),
	TO (matrix, Matrix),
    },
    "Common operations on matrices:",
    UL {
	TO (symbol +, Matrix, Matrix),
	TO (symbol -, Matrix, Matrix),
	TO (symbol *, RingElement, Matrix),
	TO (symbol *, Matrix, Matrix),
	TO (symbol ==, Matrix, Matrix),
	TO (symbol ++, Matrix, Matrix),
	TO (symbol **, Matrix, Matrix),
	TO (symbol %, Matrix, Matrix),
	TO (symbol //, Matrix, Matrix),
	TO (symbol |, Matrix, Matrix),
	TO (symbol ||, Matrix, Matrix),
	TO (symbol ^, Matrix, List),
	TO (symbol _, Matrix, List)
    },
    "Common ways to use a matrix:",
    UL {
	TO (cokernel, Matrix),
	TO (image, Matrix),
	TO (kernel, Matrix),
	TO (homology, Matrix, Matrix),
    },
    -- TODO: merge these with the lists above
    Subnodes => {
	TO isWellDefined,
	TO (entries, Matrix),
	TO eigenvalues,
	TO eigenvectors,
	TO transpose,
	TO dual,
	TO support,
	TO (leadTerm, Matrix),
	TO (leadTerm, ZZ, Matrix),
	TO leadComponent,
	TO (borel, Matrix),
	TO (dual, Matrix),
	TO (modulo, Matrix, Matrix),
	TO (complement, Matrix),
	TO "Complexes :: extend(Complex,Complex,Matrix)",
	TO (symbol **, Matrix, RingElement),
	TO (ambient, Matrix),
	TO (contract, Matrix, Matrix),
	TO (cover, Matrix),
	TO (degrees, Matrix),
	TO diagonalMatrix,
	TO (symbol ++, Matrix, Matrix),
	TO (markedGB, Matrix, Matrix),
	TO (homology, Matrix, Matrix),
	TO (inverse, Matrix),
	TO (jacobian, Matrix),
	TO (koszul, Matrix),
	TO (koszul, ZZ, Matrix),
	TO (map, Ring, Matrix),
	TO (minimalPresentation, Matrix),
	TO (pivots, Matrix),
	TO (smithNormalForm, Matrix),
	TO (source, Matrix),
	TO (syz, Matrix),
	TO (target, Matrix),
	TO (compress, Matrix),
	TO (tensor, RingMap, Matrix),
	TO (tensor, Matrix, Matrix),
	TO (symbol **, Matrix, Ring),
	TO (symbol ^, Matrix, ZZ),
	TO (symbol |, Matrix, Matrix),
	TO (symbol ||, Matrix, Matrix),
	TO (symbol /, Matrix, Number),
	TO (symbol //, Matrix, Matrix),
	TO (symbol %, Matrix, GroebnerBasis),
	TO (symbol *, Matrix, Matrix),
	TO (symbol _, Matrix, Sequence),
	TO selectInSubring,
	TO solve,
	TO divideByVariable,
    },
}
