/*
 *  sysync_crc16.cpp
 *    CRC 16 checksumming functions
 *
 *  Copyright (c) 2002-2011 by Synthesis AG + plan44.ch
 *
 */

#include "prefix_file.h"
#include "sysync_crc16.h"

namespace sysync {

#define TAB_DRIVEN      1     /* 1 - fast ;  0 - small   */
#define CRC_CCITT       0     /* 1 for CCITT algorithm   */
#define CRC_CRC16       1     /* 1 for CRC16 algorithm   */


#if TAB_DRIVEN

#if CRC_CCITT
/* CCITT 16 bit CRC table build using feedback value of 0x8408 */
static const uInt16 crc16_table[256] = {
  0x0000,0x1189,0x2312,0x329b,0x4624,0x57ad,0x6536,0x74bf,
  0x8c48,0x9dc1,0xaf5a,0xbed3,0xca6c,0xdbe5,0xe97e,0xf8f7,
  0x1891,0x0918,0x3b83,0x2a0a,0x5eb5,0x4f3c,0x7da7,0x6c2e,
  0x94d9,0x8550,0xb7cb,0xa642,0xd2fd,0xc374,0xf1ef,0xe066,
  0x3122,0x20ab,0x1230,0x03b9,0x7706,0x668f,0x5414,0x459d,
  0xbd6a,0xace3,0x9e78,0x8ff1,0xfb4e,0xeac7,0xd85c,0xc9d5,
  0x29b3,0x383a,0x0aa1,0x1b28,0x6f97,0x7e1e,0x4c85,0x5d0c,
  0xa5fb,0xb472,0x86e9,0x9760,0xe3df,0xf256,0xc0cd,0xd144,
  0x6244,0x73cd,0x4156,0x50df,0x2460,0x35e9,0x0772,0x16fb,
  0xee0c,0xff85,0xcd1e,0xdc97,0xa828,0xb9a1,0x8b3a,0x9ab3,
  0x7ad5,0x6b5c,0x59c7,0x484e,0x3cf1,0x2d78,0x1fe3,0x0e6a,
  0xf69d,0xe714,0xd58f,0xc406,0xb0b9,0xa130,0x93ab,0x8222,
  0x5366,0x42ef,0x7074,0x61fd,0x1542,0x04cb,0x3650,0x27d9,
  0xdf2e,0xcea7,0xfc3c,0xedb5,0x990a,0x8883,0xba18,0xab91,
  0x4bf7,0x5a7e,0x68e5,0x796c,0x0dd3,0x1c5a,0x2ec1,0x3f48,
  0xc7bf,0xd636,0xe4ad,0xf524,0x819b,0x9012,0xa289,0xb300,
  0xc488,0xd501,0xe79a,0xf613,0x82ac,0x9325,0xa1be,0xb037,
  0x48c0,0x5949,0x6bd2,0x7a5b,0x0ee4,0x1f6d,0x2df6,0x3c7f,
  0xdc19,0xcd90,0xff0b,0xee82,0x9a3d,0x8bb4,0xb92f,0xa8a6,
  0x5051,0x41d8,0x7343,0x62ca,0x1675,0x07fc,0x3567,0x24ee,
  0xf5aa,0xe423,0xd6b8,0xc731,0xb38e,0xa207,0x909c,0x8115,
  0x79e2,0x686b,0x5af0,0x4b79,0x3fc6,0x2e4f,0x1cd4,0x0d5d,
  0xed3b,0xfcb2,0xce29,0xdfa0,0xab1f,0xba96,0x880d,0x9984,
  0x6173,0x70fa,0x4261,0x53e8,0x2757,0x36de,0x0445,0x15cc,
  0xa6cc,0xb745,0x85de,0x9457,0xe0e8,0xf161,0xc3fa,0xd273,
  0x2a84,0x3b0d,0x0996,0x181f,0x6ca0,0x7d29,0x4fb2,0x5e3b,
  0xbe5d,0xafd4,0x9d4f,0x8cc6,0xf879,0xe9f0,0xdb6b,0xcae2,
  0x3215,0x239c,0x1107,0x008e,0x7431,0x65b8,0x5723,0x46aa,
  0x97ee,0x8667,0xb4fc,0xa575,0xd1ca,0xc043,0xf2d8,0xe351,
  0x1ba6,0x0a2f,0x38b4,0x293d,0x5d82,0x4c0b,0x7e90,0x6f19,
  0x8f7f,0x9ef6,0xac6d,0xbde4,0xc95b,0xd8d2,0xea49,0xfbc0,
  0x0337,0x12be,0x2025,0x31ac,0x4513,0x549a,0x6601,0x7788
  };
#elif defined(CRC_CRC16)
static const uInt16 crc16_table[256] = {
    0x0000,0x1189,0x2312,0x329B,0x4624,0x57AD,0x6536,0x74BF,
    0x8C48,0x9DC1,0xAF5A,0xBED3,0xCA6C,0xDBE5,0xE97E,0xF8F7,
    0x1081,0x0108,0x3393,0x221A,0x56A5,0x472C,0x75B7,0x643E,
    0x9CC9,0x8D40,0xBFDB,0xAE52,0xDAED,0xCB64,0xF9FF,0xE876,
    0x2102,0x308B,0x0210,0x1399,0x6726,0x76AF,0x4434,0x55BD,
    0xAD4A,0xBCC3,0x8E58,0x9FD1,0xEB6E,0xFAE7,0xC87C,0xD9F5,
    0x3183,0x200A,0x1291,0x0318,0x77A7,0x662E,0x54B5,0x453C,
    0xBDCB,0xAC42,0x9ED9,0x8F50,0xFBEF,0xEA66,0xD8FD,0xC974,
    0x4204,0x538D,0x6116,0x709F,0x0420,0x15A9,0x2732,0x36BB,
    0xCE4C,0xDFC5,0xED5E,0xFCD7,0x8868,0x99E1,0xAB7A,0xBAF3,
    0x5285,0x430C,0x7197,0x601E,0x14A1,0x0528,0x37B3,0x263A,
    0xDECD,0xCF44,0xFDDF,0xEC56,0x98E9,0x8960,0xBBFB,0xAA72,
    0x6306,0x728F,0x4014,0x519D,0x2522,0x34AB,0x0630,0x17B9,
    0xEF4E,0xFEC7,0xCC5C,0xDDD5,0xA96A,0xB8E3,0x8A78,0x9BF1,
    0x7387,0x620E,0x5095,0x411C,0x35A3,0x242A,0x16B1,0x0738,
    0xFFCF,0xEE46,0xDCDD,0xCD54,0xB9EB,0xA862,0x9AF9,0x8B70,
    0x8408,0x9581,0xA71A,0xB693,0xC22C,0xD3A5,0xE13E,0xF0B7,
    0x0840,0x19C9,0x2B52,0x3ADB,0x4E64,0x5FED,0x6D76,0x7CFF,
    0x9489,0x8500,0xB79B,0xA612,0xD2AD,0xC324,0xF1BF,0xE036,
    0x18C1,0x0948,0x3BD3,0x2A5A,0x5EE5,0x4F6C,0x7DF7,0x6C7E,
    0xA50A,0xB483,0x8618,0x9791,0xE32E,0xF2A7,0xC03C,0xD1B5,
    0x2942,0x38CB,0x0A50,0x1BD9,0x6F66,0x7EEF,0x4C74,0x5DFD,
    0xB58B,0xA402,0x9699,0x8710,0xF3AF,0xE226,0xD0BD,0xC134,
    0x39C3,0x284A,0x1AD1,0x0B58,0x7FE7,0x6E6E,0x5CF5,0x4D7C,
    0xC60C,0xD785,0xE51E,0xF497,0x8028,0x91A1,0xA33A,0xB2B3,
    0x4A44,0x5BCD,0x6956,0x78DF,0x0C60,0x1DE9,0x2F72,0x3EFB,
    0xD68D,0xC704,0xF59F,0xE416,0x90A9,0x8120,0xB3BB,0xA232,
    0x5AC5,0x4B4C,0x79D7,0x685E,0x1CE1,0x0D68,0x3FF3,0x2E7A,
    0xE70E,0xF687,0xC41C,0xD595,0xA12A,0xB0A3,0x8238,0x93B1,
    0x6B46,0x7ACF,0x4854,0x59DD,0x2D62,0x3CEB,0x0E70,0x1FF9,
    0xF78F,0xE606,0xD49D,0xC514,0xB1AB,0xA022,0x92B9,0x8330,
    0x7BC7,0x6A4E,0x58D5,0x495C,0x3DE3,0x2C6A,0x1EF1,0x0F78
  };
#else
  #error "no CRC method defined"
#endif

/* compute 16 bit CRC using the table */
uInt16 sysync_crc16(uInt16 crc,uInt8 b)
{
  int s, i;

  i = (b ^ crc) & 0xff;
  s = (crc >> 8) ^ crc16_table[i];
  return s & 0xffff;
} // sysync_crc16

#else

#if CRC_CCITT
/* compute 16 bit CCITT crc on the fly, doesn't use table */
/* use this one if you are tight on space. */
uInt16 sysync_crc16(uInt16 crc,uInt8 b)
{
  int s;

  /*  s = b ^ (crc & 0xff);*/
  s = (b ^ crc) & 0xff;
  s = s ^ (s << 4);
  s = (crc >> 8) ^ (s << 8) ^ (s << 3) ^ (s >> 4);

  return s & 0xffff;
}
#endif

#if CRC_CRC16
/* compute 16 bit CCR16 crc on the fly, doesn't use table */
/* use this one if you are tight on space. */

#error "this function not implemented ... "

#endif

#endif

// calc CRC over a block of bytes
uInt16 sysync_crc16_block(const void* dataP, uInt32 len, uInt16 crc)
{
  uInt32 i;
  uInt8 *p=(uInt8 *)dataP;

  for (i=0; i<len; i++) crc = sysync_crc16(crc,*(p++));
  return crc;
} // sysync_crc16_block

} // namespace sysync

/* eof */
