/* candidatearea.c generated by valac 0.48.9, the Vala compiler
 * generated from candidatearea.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2015 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2019 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <ibus.h>
#include <pango/pango.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#define TYPE_CANDIDATE_AREA (candidate_area_get_type ())
#define CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_AREA, CandidateArea))
#define CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_AREA, CandidateAreaClass))
#define IS_CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_AREA))
#define IS_CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_AREA))
#define CANDIDATE_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_AREA, CandidateAreaClass))

typedef struct _CandidateArea CandidateArea;
typedef struct _CandidateAreaClass CandidateAreaClass;
typedef struct _CandidateAreaPrivate CandidateAreaPrivate;

#define TYPE_THEMED_RGBA (themed_rgba_get_type ())
#define THEMED_RGBA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMED_RGBA, ThemedRGBA))
#define THEMED_RGBA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMED_RGBA, ThemedRGBAClass))
#define IS_THEMED_RGBA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMED_RGBA))
#define IS_THEMED_RGBA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMED_RGBA))
#define THEMED_RGBA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMED_RGBA, ThemedRGBAClass))

typedef struct _ThemedRGBA ThemedRGBA;
typedef struct _ThemedRGBAClass ThemedRGBAClass;
enum  {
	CANDIDATE_AREA_0_PROPERTY,
	CANDIDATE_AREA_NUM_PROPERTIES
};
static GParamSpec* candidate_area_properties[CANDIDATE_AREA_NUM_PROPERTIES];
#define _themed_rgba_unref0(var) ((var == NULL) ? NULL : (var = (themed_rgba_unref (var), NULL)))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_VSEPARATOR (vseparator_get_type ())
#define VSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VSEPARATOR, VSeparator))
#define VSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VSEPARATOR, VSeparatorClass))
#define IS_VSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VSEPARATOR))
#define IS_VSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VSEPARATOR))
#define VSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VSEPARATOR, VSeparatorClass))

typedef struct _VSeparator VSeparator;
typedef struct _VSeparatorClass VSeparatorClass;

#define TYPE_HSEPARATOR (hseparator_get_type ())
#define HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HSEPARATOR, HSeparator))
#define HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HSEPARATOR, HSeparatorClass))
#define IS_HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HSEPARATOR))
#define IS_HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HSEPARATOR))
#define HSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HSEPARATOR, HSeparatorClass))

typedef struct _HSeparator HSeparator;
typedef struct _HSeparatorClass HSeparatorClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
enum  {
	CANDIDATE_AREA_CANDIDATE_CLICKED_SIGNAL,
	CANDIDATE_AREA_PAGE_UP_SIGNAL,
	CANDIDATE_AREA_PAGE_DOWN_SIGNAL,
	CANDIDATE_AREA_CURSOR_UP_SIGNAL,
	CANDIDATE_AREA_CURSOR_DOWN_SIGNAL,
	CANDIDATE_AREA_NUM_SIGNALS
};
static guint candidate_area_signals[CANDIDATE_AREA_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CandidateArea {
	GtkBox parent_instance;
	CandidateAreaPrivate * priv;
};

struct _CandidateAreaClass {
	GtkBoxClass parent_class;
};

struct _CandidateAreaPrivate {
	gboolean m_vertical;
	GtkLabel** m_labels;
	gint m_labels_length1;
	gint _m_labels_size_;
	GtkLabel** m_candidates;
	gint m_candidates_length1;
	gint _m_candidates_size_;
	GtkWidget** m_widgets;
	gint m_widgets_length1;
	gint _m_widgets_size_;
	IBusText** m_ibus_candidates;
	gint m_ibus_candidates_length1;
	gint _m_ibus_candidates_size_;
	guint m_focus_candidate;
	gboolean m_show_cursor;
	ThemedRGBA* m_rgba;
	PangoAttribute* m_language_attribute;
};

struct _Block1Data {
	int _ref_count_;
	CandidateArea* self;
	gint i;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gint index;
};

struct _Block3Data {
	int _ref_count_;
	CandidateArea* self;
	gint index;
};

static gint CandidateArea_private_offset;
static gpointer candidate_area_parent_class = NULL;

GType candidate_area_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CandidateArea, g_object_unref)
gpointer themed_rgba_ref (gpointer instance);
void themed_rgba_unref (gpointer instance);
GParamSpec* param_spec_themed_rgba (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void value_set_themed_rgba (GValue* value,
                            gpointer v_object);
void value_take_themed_rgba (GValue* value,
                             gpointer v_object);
gpointer value_get_themed_rgba (const GValue* value);
GType themed_rgba_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemedRGBA, themed_rgba_unref)
CandidateArea* candidate_area_new (gboolean vertical);
CandidateArea* candidate_area_construct (GType object_type,
                                         gboolean vertical);
void candidate_area_set_vertical (CandidateArea* self,
                                  gboolean vertical,
                                  gboolean force);
ThemedRGBA* themed_rgba_new (GtkWidget* widget);
ThemedRGBA* themed_rgba_construct (GType object_type,
                                   GtkWidget* widget);
gboolean candidate_area_candidate_scrolled (CandidateArea* self,
                                            GdkEventScroll* event);
gboolean candidate_area_get_vertical (CandidateArea* self);
static void candidate_area_recreate_ui (CandidateArea* self);
void candidate_area_set_candidates (CandidateArea* self,
                                    IBusText** candidates,
                                    gint candidates_length1,
                                    guint focus_candidate,
                                    gboolean show_cursor);
void candidate_area_set_labels (CandidateArea* self,
                                IBusText** labels,
                                gint labels_length1);
void candidate_area_set_language (CandidateArea* self,
                                  PangoAttribute* language_attribute);
static IBusText** _vala_array_dup1 (IBusText** self,
                             gint length);
PangoAttrList* get_pango_attr_list_from_ibus_text (IBusText* text);
GdkRGBA* themed_rgba_get_selected_fg (ThemedRGBA* self);
GdkRGBA* themed_rgba_get_selected_bg (ThemedRGBA* self);
static void __lambda8_ (CandidateArea* self,
                 GtkButton* b);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda9_ (CandidateArea* self,
                 GtkButton* b);
static void ___lambda9__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static gboolean _candidate_area_candidate_scrolled_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                     GdkEventScroll* event,
                                                                     gpointer self);
VSeparator* vseparator_new (void);
VSeparator* vseparator_construct (GType object_type);
GType vseparator_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VSeparator, g_object_unref)
HSeparator* hseparator_new (void);
HSeparator* hseparator_construct (GType object_type);
GType hseparator_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HSeparator, g_object_unref)
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _vala_array_add1 (GtkLabel** * array,
                       gint* length,
                       gint* size,
                       GtkLabel* value);
static void _vala_array_add2 (GtkLabel** * array,
                       gint* length,
                       gint* size,
                       GtkLabel* value);
static gboolean ______lambda10_ (Block2Data* _data2_,
                          GtkWidget* w,
                          GdkEventButton* e);
static gboolean _______lambda10__gtk_widget_button_press_event (GtkWidget* _sender,
                                                         GdkEventButton* event,
                                                         gpointer self);
static void _vala_array_add3 (GtkWidget** * array,
                       gint* length,
                       gint* size,
                       GtkWidget* value);
static gboolean ______lambda11_ (Block2Data* _data2_,
                          GtkWidget* w,
                          GdkEventButton* e);
static gboolean _______lambda11__gtk_widget_button_press_event (GtkWidget* _sender,
                                                         GdkEventButton* event,
                                                         gpointer self);
static void _vala_array_add4 (GtkWidget** * array,
                       gint* length,
                       gint* size,
                       GtkWidget* value);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _vala_array_add5 (GtkLabel** * array,
                       gint* length,
                       gint* size,
                       GtkLabel* value);
static void _vala_array_add6 (GtkLabel** * array,
                       gint* length,
                       gint* size,
                       GtkLabel* value);
static gboolean ______lambda12_ (Block3Data* _data3_,
                          GtkWidget* w,
                          GdkEventButton* e);
static gboolean _______lambda12__gtk_widget_button_press_event (GtkWidget* _sender,
                                                         GdkEventButton* event,
                                                         gpointer self);
static void _vala_array_add7 (GtkWidget** * array,
                       gint* length,
                       gint* size,
                       GtkWidget* value);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void candidate_area_finalize (GObject * obj);
static GType candidate_area_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const gchar* CANDIDATE_AREA_LABELS[16] = {"1.", "2.", "3.", "4.", "5.", "6.", "7.", "8.", "9.", "0.", "a.", "b.", "c.", "d.", "e.", "f."};
static const gchar* CANDIDATE_AREA_PREV_PAGE_ICONS[2] = {"go-previous", "go-up"};
static const gchar* CANDIDATE_AREA_NEXT_PAGE_ICONS[2] = {"go-next", "go-down"};

static inline gpointer
candidate_area_get_instance_private (CandidateArea* self)
{
	return G_STRUCT_MEMBER_P (self, CandidateArea_private_offset);
}

CandidateArea*
candidate_area_construct (GType object_type,
                          gboolean vertical)
{
	CandidateArea * self = NULL;
	ThemedRGBA* _tmp0_;
	self = (CandidateArea*) g_object_new (object_type, NULL);
	candidate_area_set_vertical (self, vertical, TRUE);
	_tmp0_ = themed_rgba_new ((GtkWidget*) self);
	_themed_rgba_unref0 (self->priv->m_rgba);
	self->priv->m_rgba = _tmp0_;
	return self;
}

CandidateArea*
candidate_area_new (gboolean vertical)
{
	return candidate_area_construct (TYPE_CANDIDATE_AREA, vertical);
}

gboolean
candidate_area_candidate_scrolled (CandidateArea* self,
                                   GdkEventScroll* event)
{
	GdkScrollDirection _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->direction;
	switch (_tmp0_) {
		case GDK_SCROLL_UP:
		{
			g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_CURSOR_UP_SIGNAL], 0);
			break;
		}
		case GDK_SCROLL_DOWN:
		{
			g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_CURSOR_DOWN_SIGNAL], 0);
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}

gboolean
candidate_area_get_vertical (CandidateArea* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->m_vertical;
	return result;
}

void
candidate_area_set_vertical (CandidateArea* self,
                             gboolean vertical,
                             gboolean force)
{
	gboolean _tmp0_ = FALSE;
	GtkOrientation _tmp1_ = 0;
	IBusText** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	if (!force) {
		_tmp0_ = self->priv->m_vertical == vertical;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->m_vertical = vertical;
	if (vertical) {
		_tmp1_ = GTK_ORIENTATION_VERTICAL;
	} else {
		_tmp1_ = GTK_ORIENTATION_HORIZONTAL;
	}
	gtk_orientable_set_orientation ((GtkOrientable*) self, _tmp1_);
	candidate_area_recreate_ui (self);
	_tmp2_ = self->priv->m_ibus_candidates;
	_tmp2__length1 = self->priv->m_ibus_candidates_length1;
	if (_tmp2__length1 > 0) {
		IBusText** _tmp3_;
		gint _tmp3__length1;
		IBusText** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = self->priv->m_ibus_candidates;
		_tmp3__length1 = self->priv->m_ibus_candidates_length1;
		self->priv->m_ibus_candidates = NULL;
		self->priv->m_ibus_candidates_length1 = 0;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _tmp3__length1;
		candidate_area_set_candidates (self, _tmp4_, (gint) _tmp3__length1, self->priv->m_focus_candidate, self->priv->m_show_cursor);
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
		gtk_widget_show_all ((GtkWidget*) self);
	}
}

void
candidate_area_set_labels (CandidateArea* self,
                           IBusText** labels,
                           gint labels_length1)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			GtkLabel** _tmp2_;
			gint _tmp2__length1;
			GtkLabel* _tmp3_;
			IBusText* _tmp4_;
			const gchar* _tmp5_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!(i < MIN (16, labels_length1))) {
				break;
			}
			_tmp2_ = self->priv->m_labels;
			_tmp2__length1 = self->priv->m_labels_length1;
			_tmp3_ = _tmp2_[i];
			_tmp4_ = labels[i];
			_tmp5_ = ibus_text_get_text (_tmp4_);
			gtk_label_set_text (_tmp3_, _tmp5_);
		}
	}
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			GtkLabel** _tmp8_;
			gint _tmp8__length1;
			GtkLabel* _tmp9_;
			const gchar* _tmp10_;
			if (!_tmp6_) {
				gint _tmp7_;
				_tmp7_ = i;
				i = _tmp7_ + 1;
			}
			_tmp6_ = FALSE;
			if (!(i < 16)) {
				break;
			}
			_tmp8_ = self->priv->m_labels;
			_tmp8__length1 = self->priv->m_labels_length1;
			_tmp9_ = _tmp8_[i];
			_tmp10_ = CANDIDATE_AREA_LABELS[i];
			gtk_label_set_text (_tmp9_, _tmp10_);
		}
	}
}

void
candidate_area_set_language (CandidateArea* self,
                             PangoAttribute* language_attribute)
{
	PangoAttribute* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language_attribute != NULL);
	_tmp0_ = pango_attribute_copy (language_attribute);
	_pango_attribute_destroy0 (self->priv->m_language_attribute);
	self->priv->m_language_attribute = _tmp0_;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static IBusText**
_vala_array_dup1 (IBusText** self,
                  gint length)
{
	if (length >= 0) {
		IBusText** result;
		gint i;
		result = g_new0 (IBusText*, length + 1);
		for (i = 0; i < length; i++) {
			IBusText* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
candidate_area_set_candidates (CandidateArea* self,
                               IBusText** candidates,
                               gint candidates_length1,
                               guint focus_candidate,
                               gboolean show_cursor)
{
	IBusText** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (candidates != NULL) ? _vala_array_dup1 (candidates, candidates_length1) : ((gpointer) candidates);
	_tmp0__length1 = candidates_length1;
	self->priv->m_ibus_candidates = (_vala_array_free (self->priv->m_ibus_candidates, self->priv->m_ibus_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_ibus_candidates = _tmp0_;
	self->priv->m_ibus_candidates_length1 = _tmp0__length1;
	self->priv->_m_ibus_candidates_size_ = self->priv->m_ibus_candidates_length1;
	self->priv->m_focus_candidate = focus_candidate;
	self->priv->m_show_cursor = show_cursor;
	_vala_assert (candidates_length1 <= 16, "candidates.length <= 16");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GtkLabel* label = NULL;
				GtkLabel** _tmp3_;
				gint _tmp3__length1;
				GtkLabel* _tmp4_;
				GtkLabel* _tmp5_;
				gboolean visible = FALSE;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 16)) {
					break;
				}
				_tmp3_ = self->priv->m_candidates;
				_tmp3__length1 = self->priv->m_candidates_length1;
				_tmp4_ = _tmp3_[i];
				_tmp5_ = _g_object_ref0 (_tmp4_);
				label = _tmp5_;
				visible = FALSE;
				if (i < candidates_length1) {
					PangoAttrList* attrs = NULL;
					IBusText* _tmp6_;
					PangoAttrList* _tmp7_;
					PangoAttrList* _tmp8_;
					PangoAttribute* _tmp9_;
					PangoAttribute* _tmp10_;
					gboolean _tmp11_ = FALSE;
					GtkLabel* _tmp48_;
					IBusText* _tmp49_;
					const gchar* _tmp50_;
					GtkLabel* _tmp51_;
					PangoAttrList* _tmp52_;
					_tmp6_ = candidates[i];
					_tmp7_ = get_pango_attr_list_from_ibus_text (_tmp6_);
					attrs = _tmp7_;
					_tmp8_ = attrs;
					_tmp9_ = self->priv->m_language_attribute;
					_tmp10_ = pango_attribute_copy (_tmp9_);
					pango_attr_list_change (_tmp8_, _tmp10_);
					if (((guint) i) == focus_candidate) {
						_tmp11_ = show_cursor;
					} else {
						_tmp11_ = FALSE;
					}
					if (_tmp11_) {
						PangoAttribute* pango_attr = NULL;
						ThemedRGBA* _tmp12_;
						GdkRGBA* _tmp13_;
						GdkRGBA* _tmp14_;
						ThemedRGBA* _tmp15_;
						GdkRGBA* _tmp16_;
						GdkRGBA* _tmp17_;
						ThemedRGBA* _tmp18_;
						GdkRGBA* _tmp19_;
						GdkRGBA* _tmp20_;
						PangoAttribute* _tmp21_;
						PangoAttribute* _tmp22_;
						PangoAttribute* _tmp23_;
						IBusText* _tmp24_;
						const gchar* _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
						PangoAttrList* _tmp28_;
						PangoAttribute* _tmp29_;
						ThemedRGBA* _tmp30_;
						GdkRGBA* _tmp31_;
						GdkRGBA* _tmp32_;
						ThemedRGBA* _tmp33_;
						GdkRGBA* _tmp34_;
						GdkRGBA* _tmp35_;
						ThemedRGBA* _tmp36_;
						GdkRGBA* _tmp37_;
						GdkRGBA* _tmp38_;
						PangoAttribute* _tmp39_;
						PangoAttribute* _tmp40_;
						PangoAttribute* _tmp41_;
						IBusText* _tmp42_;
						const gchar* _tmp43_;
						gint _tmp44_;
						gint _tmp45_;
						PangoAttrList* _tmp46_;
						PangoAttribute* _tmp47_;
						_tmp12_ = self->priv->m_rgba;
						_tmp13_ = themed_rgba_get_selected_fg (_tmp12_);
						_tmp14_ = _tmp13_;
						_tmp15_ = self->priv->m_rgba;
						_tmp16_ = themed_rgba_get_selected_fg (_tmp15_);
						_tmp17_ = _tmp16_;
						_tmp18_ = self->priv->m_rgba;
						_tmp19_ = themed_rgba_get_selected_fg (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = pango_attr_foreground_new ((guint16) ((*_tmp14_).red * G_MAXUINT16), (guint16) ((*_tmp17_).green * G_MAXUINT16), (guint16) ((*_tmp20_).blue * G_MAXUINT16));
						pango_attr = _tmp21_;
						_tmp22_ = pango_attr;
						_tmp22_->start_index = (guint) 0;
						_tmp23_ = pango_attr;
						_tmp24_ = candidates[i];
						_tmp25_ = ibus_text_get_text (_tmp24_);
						_tmp26_ = strlen (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp23_->end_index = (guint) _tmp27_;
						_tmp28_ = attrs;
						_tmp29_ = pango_attr;
						pango_attr = NULL;
						pango_attr_list_insert (_tmp28_, _tmp29_);
						_tmp30_ = self->priv->m_rgba;
						_tmp31_ = themed_rgba_get_selected_bg (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = self->priv->m_rgba;
						_tmp34_ = themed_rgba_get_selected_bg (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = self->priv->m_rgba;
						_tmp37_ = themed_rgba_get_selected_bg (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = pango_attr_background_new ((guint16) ((*_tmp32_).red * G_MAXUINT16), (guint16) ((*_tmp35_).green * G_MAXUINT16), (guint16) ((*_tmp38_).blue * G_MAXUINT16));
						_pango_attribute_destroy0 (pango_attr);
						pango_attr = _tmp39_;
						_tmp40_ = pango_attr;
						_tmp40_->start_index = (guint) 0;
						_tmp41_ = pango_attr;
						_tmp42_ = candidates[i];
						_tmp43_ = ibus_text_get_text (_tmp42_);
						_tmp44_ = strlen (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp41_->end_index = (guint) _tmp45_;
						_tmp46_ = attrs;
						_tmp47_ = pango_attr;
						pango_attr = NULL;
						pango_attr_list_insert (_tmp46_, _tmp47_);
						_pango_attribute_destroy0 (pango_attr);
					}
					_tmp48_ = label;
					_tmp49_ = candidates[i];
					_tmp50_ = ibus_text_get_text (_tmp49_);
					gtk_label_set_text (_tmp48_, _tmp50_);
					_tmp51_ = label;
					_tmp52_ = attrs;
					gtk_label_set_attributes (_tmp51_, _tmp52_);
					visible = TRUE;
					_pango_attr_list_unref0 (attrs);
				} else {
					GtkLabel* _tmp53_;
					GtkLabel* _tmp54_;
					PangoAttrList* _tmp55_;
					PangoAttrList* _tmp56_;
					_tmp53_ = label;
					gtk_label_set_text (_tmp53_, "");
					_tmp54_ = label;
					_tmp55_ = pango_attr_list_new ();
					_tmp56_ = _tmp55_;
					gtk_label_set_attributes (_tmp54_, _tmp56_);
					_pango_attr_list_unref0 (_tmp56_);
				}
				if (self->priv->m_vertical) {
					GtkWidget** _tmp57_;
					gint _tmp57__length1;
					GtkWidget* _tmp58_;
					GtkWidget** _tmp59_;
					gint _tmp59__length1;
					GtkWidget* _tmp60_;
					_tmp57_ = self->priv->m_widgets;
					_tmp57__length1 = self->priv->m_widgets_length1;
					_tmp58_ = _tmp57_[i * 2];
					gtk_widget_set_visible (_tmp58_, visible);
					_tmp59_ = self->priv->m_widgets;
					_tmp59__length1 = self->priv->m_widgets_length1;
					_tmp60_ = _tmp59_[(i * 2) + 1];
					gtk_widget_set_visible (_tmp60_, visible);
				} else {
					GtkWidget** _tmp61_;
					gint _tmp61__length1;
					GtkWidget* _tmp62_;
					_tmp61_ = self->priv->m_widgets;
					_tmp61__length1 = self->priv->m_widgets_length1;
					_tmp62_ = _tmp61_[i];
					gtk_widget_set_visible (_tmp62_, visible);
				}
				_g_object_unref0 (label);
			}
		}
	}
}

static void
__lambda8_ (CandidateArea* self,
            GtkButton* b)
{
	g_return_if_fail (b != NULL);
	g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_PAGE_UP_SIGNAL], 0);
}

static void
___lambda8__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda8_ ((CandidateArea*) self, _sender);
}

static void
__lambda9_ (CandidateArea* self,
            GtkButton* b)
{
	g_return_if_fail (b != NULL);
	g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_PAGE_DOWN_SIGNAL], 0);
}

static void
___lambda9__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda9_ ((CandidateArea*) self, _sender);
}

static gboolean
_candidate_area_candidate_scrolled_gtk_widget_scroll_event (GtkWidget* _sender,
                                                            GdkEventScroll* event,
                                                            gpointer self)
{
	gboolean result;
	result = candidate_area_candidate_scrolled ((CandidateArea*) self, event);
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CandidateArea* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CandidateArea* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_vala_array_add1 (GtkLabel** * array,
                  gint* length,
                  gint* size,
                  GtkLabel* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (GtkLabel** * array,
                  gint* length,
                  gint* size,
                  GtkLabel* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
______lambda10_ (Block2Data* _data2_,
                 GtkWidget* w,
                 GdkEventButton* e)
{
	Block1Data* _data1_;
	CandidateArea* self;
	GdkModifierType _tmp0_;
	gboolean result = FALSE;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e->state;
	g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_CANDIDATE_CLICKED_SIGNAL], 0, (guint) _data1_->i, e->button, (guint) _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
_______lambda10__gtk_widget_button_press_event (GtkWidget* _sender,
                                                GdkEventButton* event,
                                                gpointer self)
{
	gboolean result;
	result = ______lambda10_ (self, _sender, event);
	return result;
}

static void
_vala_array_add3 (GtkWidget** * array,
                  gint* length,
                  gint* size,
                  GtkWidget* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
______lambda11_ (Block2Data* _data2_,
                 GtkWidget* w,
                 GdkEventButton* e)
{
	Block1Data* _data1_;
	CandidateArea* self;
	GdkModifierType _tmp0_;
	gboolean result = FALSE;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e->state;
	g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_CANDIDATE_CLICKED_SIGNAL], 0, (guint) _data2_->index, e->button, (guint) _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
_______lambda11__gtk_widget_button_press_event (GtkWidget* _sender,
                                                GdkEventButton* event,
                                                gpointer self)
{
	gboolean result;
	result = ______lambda11_ (self, _sender, event);
	return result;
}

static void
_vala_array_add4 (GtkWidget** * array,
                  gint* length,
                  gint* size,
                  GtkWidget* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		CandidateArea* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_vala_array_add5 (GtkLabel** * array,
                  gint* length,
                  gint* size,
                  GtkLabel* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (GtkLabel** * array,
                  gint* length,
                  gint* size,
                  GtkLabel* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
______lambda12_ (Block3Data* _data3_,
                 GtkWidget* w,
                 GdkEventButton* e)
{
	CandidateArea* self;
	GdkModifierType _tmp0_;
	gboolean result = FALSE;
	self = _data3_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e->state;
	g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_CANDIDATE_CLICKED_SIGNAL], 0, (guint) _data3_->index, e->button, (guint) _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
_______lambda12__gtk_widget_button_press_event (GtkWidget* _sender,
                                                GdkEventButton* event,
                                                gpointer self)
{
	gboolean result;
	result = ______lambda12_ (self, _sender, event);
	return result;
}

static void
_vala_array_add7 (GtkWidget** * array,
                  gint* length,
                  gint* size,
                  GtkWidget* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
candidate_area_recreate_ui (CandidateArea* self)
{
	GList* _tmp0_;
	GtkButton* prev_button = NULL;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkOrientation _tmp6_;
	GtkOrientation _tmp7_;
	const gchar* _tmp8_;
	GtkImage* _tmp9_;
	GtkImage* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* next_button = NULL;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkOrientation _tmp15_;
	GtkOrientation _tmp16_;
	const gchar* _tmp17_;
	GtkImage* _tmp18_;
	GtkImage* _tmp19_;
	GtkButton* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* w = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp1_;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = w;
				gtk_widget_destroy (_tmp2_);
				_g_object_unref0 (w);
			}
		}
		(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
	}
	_tmp3_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp3_);
	prev_button = _tmp3_;
	_tmp4_ = prev_button;
	g_signal_connect_object (_tmp4_, "clicked", (GCallback) ___lambda8__gtk_button_clicked, self, 0);
	_tmp5_ = prev_button;
	_tmp6_ = gtk_orientable_get_orientation ((GtkOrientable*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = CANDIDATE_AREA_PREV_PAGE_ICONS[_tmp7_];
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp8_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	gtk_button_set_image (_tmp5_, (GtkWidget*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = prev_button;
	gtk_button_set_relief (_tmp11_, GTK_RELIEF_NONE);
	_tmp12_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp12_);
	next_button = _tmp12_;
	_tmp13_ = next_button;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) ___lambda9__gtk_button_clicked, self, 0);
	_tmp14_ = next_button;
	_tmp15_ = gtk_orientable_get_orientation ((GtkOrientable*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = CANDIDATE_AREA_NEXT_PAGE_ICONS[_tmp16_];
	_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp17_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gtk_button_set_image (_tmp14_, (GtkWidget*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = next_button;
	gtk_button_set_relief (_tmp20_, GTK_RELIEF_NONE);
	if (self->priv->m_vertical) {
		GtkEventBox* container_ebox = NULL;
		GtkEventBox* _tmp21_;
		GtkEventBox* _tmp22_;
		GtkEventBox* _tmp23_;
		GtkEventBox* _tmp24_;
		GtkBox* vbox = NULL;
		GtkBox* _tmp25_;
		GtkEventBox* _tmp26_;
		GtkBox* _tmp27_;
		GtkBox* candidates_hbox = NULL;
		GtkBox* _tmp28_;
		GtkBox* _tmp29_;
		GtkBox* _tmp30_;
		GtkBox* labels_vbox = NULL;
		GtkBox* _tmp31_;
		GtkBox* _tmp32_;
		GtkBox* candidates_vbox = NULL;
		GtkBox* _tmp33_;
		GtkBox* _tmp34_;
		GtkBox* _tmp35_;
		GtkBox* _tmp36_;
		GtkBox* _tmp37_;
		VSeparator* _tmp38_;
		VSeparator* _tmp39_;
		GtkBox* _tmp40_;
		GtkBox* _tmp41_;
		GtkBox* _tmp42_;
		HSeparator* _tmp43_;
		HSeparator* _tmp44_;
		GtkBox* buttons_hbox = NULL;
		GtkBox* _tmp45_;
		GtkLabel* state_label = NULL;
		GtkLabel* _tmp46_;
		GtkLabel* _tmp47_;
		GtkBox* _tmp48_;
		GtkLabel* _tmp49_;
		GtkBox* _tmp50_;
		GtkButton* _tmp51_;
		GtkBox* _tmp52_;
		GtkButton* _tmp53_;
		GtkBox* _tmp54_;
		GtkBox* _tmp55_;
		GtkLabel** _tmp56_;
		GtkLabel** _tmp57_;
		GtkWidget** _tmp58_;
		_tmp21_ = (GtkEventBox*) gtk_event_box_new ();
		g_object_ref_sink (_tmp21_);
		container_ebox = _tmp21_;
		_tmp22_ = container_ebox;
		gtk_widget_add_events ((GtkWidget*) _tmp22_, (gint) GDK_SCROLL_MASK);
		_tmp23_ = container_ebox;
		g_signal_connect_object ((GtkWidget*) _tmp23_, "scroll-event", (GCallback) _candidate_area_candidate_scrolled_gtk_widget_scroll_event, self, 0);
		_tmp24_ = container_ebox;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp24_);
		_tmp25_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp25_);
		vbox = _tmp25_;
		_tmp26_ = container_ebox;
		_tmp27_ = vbox;
		gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
		_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp28_);
		candidates_hbox = _tmp28_;
		_tmp29_ = vbox;
		_tmp30_ = candidates_hbox;
		gtk_box_pack_start (_tmp29_, (GtkWidget*) _tmp30_, FALSE, FALSE, (guint) 0);
		_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp31_);
		labels_vbox = _tmp31_;
		_tmp32_ = labels_vbox;
		gtk_box_set_homogeneous (_tmp32_, TRUE);
		_tmp33_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp33_);
		candidates_vbox = _tmp33_;
		_tmp34_ = candidates_vbox;
		gtk_box_set_homogeneous (_tmp34_, TRUE);
		_tmp35_ = candidates_hbox;
		_tmp36_ = labels_vbox;
		gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 4);
		_tmp37_ = candidates_hbox;
		_tmp38_ = vseparator_new ();
		g_object_ref_sink (_tmp38_);
		_tmp39_ = _tmp38_;
		gtk_box_pack_start (_tmp37_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp39_);
		_tmp40_ = candidates_hbox;
		_tmp41_ = candidates_vbox;
		gtk_box_pack_start (_tmp40_, (GtkWidget*) _tmp41_, TRUE, TRUE, (guint) 4);
		_tmp42_ = vbox;
		_tmp43_ = hseparator_new ();
		g_object_ref_sink (_tmp43_);
		_tmp44_ = _tmp43_;
		gtk_box_pack_start (_tmp42_, (GtkWidget*) _tmp44_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp44_);
		_tmp45_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp45_);
		buttons_hbox = _tmp45_;
		_tmp46_ = (GtkLabel*) gtk_label_new (NULL);
		g_object_ref_sink (_tmp46_);
		state_label = _tmp46_;
		_tmp47_ = state_label;
		gtk_widget_set_size_request ((GtkWidget*) _tmp47_, 20, -1);
		_tmp48_ = buttons_hbox;
		_tmp49_ = state_label;
		gtk_box_pack_start (_tmp48_, (GtkWidget*) _tmp49_, TRUE, TRUE, (guint) 0);
		_tmp50_ = buttons_hbox;
		_tmp51_ = prev_button;
		gtk_box_pack_start (_tmp50_, (GtkWidget*) _tmp51_, FALSE, FALSE, (guint) 0);
		_tmp52_ = buttons_hbox;
		_tmp53_ = next_button;
		gtk_box_pack_start (_tmp52_, (GtkWidget*) _tmp53_, FALSE, FALSE, (guint) 0);
		_tmp54_ = vbox;
		_tmp55_ = buttons_hbox;
		gtk_box_pack_start (_tmp54_, (GtkWidget*) _tmp55_, FALSE, FALSE, (guint) 0);
		_tmp56_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_labels = _tmp56_;
		self->priv->m_labels_length1 = 0;
		self->priv->_m_labels_size_ = self->priv->m_labels_length1;
		_tmp57_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_candidates = _tmp57_;
		self->priv->m_candidates_length1 = 0;
		self->priv->_m_candidates_size_ = self->priv->m_candidates_length1;
		_tmp58_ = g_new0 (GtkWidget*, 0 + 1);
		self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_widgets = _tmp58_;
		self->priv->m_widgets_length1 = 0;
		self->priv->_m_widgets_size_ = self->priv->m_widgets_length1;
		{
			Block1Data* _data1_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_data1_->i = 0;
			{
				gboolean _tmp59_ = FALSE;
				_tmp59_ = TRUE;
				while (TRUE) {
					Block2Data* _data2_;
					GtkLabel* label = NULL;
					const gchar* _tmp61_;
					GtkLabel* _tmp62_;
					GtkLabel* _tmp63_;
					GtkLabel* _tmp64_;
					GtkLabel* _tmp65_;
					GtkLabel* _tmp66_;
					GtkLabel* _tmp67_;
					GtkLabel* candidate = NULL;
					GtkLabel* _tmp68_;
					GtkLabel* _tmp69_;
					GtkLabel* _tmp70_;
					GtkLabel* _tmp71_;
					GtkLabel* _tmp72_;
					GtkLabel* _tmp73_;
					GtkLabel* _tmp74_;
					GtkLabel* _tmp75_;
					GtkLabel* _tmp76_;
					GtkLabel* _tmp77_;
					GtkEventBox* label_ebox = NULL;
					GtkEventBox* _tmp78_;
					GtkEventBox* _tmp79_;
					GtkEventBox* _tmp80_;
					GtkEventBox* _tmp81_;
					GtkLabel* _tmp82_;
					GtkBox* _tmp83_;
					GtkEventBox* _tmp84_;
					GtkEventBox* _tmp85_;
					GtkWidget* _tmp86_;
					GtkEventBox* candidate_ebox = NULL;
					GtkEventBox* _tmp87_;
					GtkEventBox* _tmp88_;
					GtkEventBox* _tmp89_;
					GtkEventBox* _tmp90_;
					GtkLabel* _tmp91_;
					GtkBox* _tmp92_;
					GtkEventBox* _tmp93_;
					GtkEventBox* _tmp94_;
					GtkWidget* _tmp95_;
					_data2_ = g_slice_new0 (Block2Data);
					_data2_->_ref_count_ = 1;
					_data2_->_data1_ = block1_data_ref (_data1_);
					if (!_tmp59_) {
						gint _tmp60_;
						_tmp60_ = _data1_->i;
						_data1_->i = _tmp60_ + 1;
					}
					_tmp59_ = FALSE;
					if (!(_data1_->i < 16)) {
						block2_data_unref (_data2_);
						_data2_ = NULL;
						break;
					}
					_tmp61_ = CANDIDATE_AREA_LABELS[_data1_->i];
					_tmp62_ = (GtkLabel*) gtk_label_new (_tmp61_);
					g_object_ref_sink (_tmp62_);
					label = _tmp62_;
					_tmp63_ = label;
					gtk_widget_set_halign ((GtkWidget*) _tmp63_, GTK_ALIGN_START);
					_tmp64_ = label;
					gtk_widget_set_valign ((GtkWidget*) _tmp64_, GTK_ALIGN_CENTER);
					_tmp65_ = label;
					gtk_widget_show ((GtkWidget*) _tmp65_);
					_tmp66_ = label;
					_tmp67_ = _g_object_ref0 (_tmp66_);
					_vala_array_add1 (&self->priv->m_labels, &self->priv->m_labels_length1, &self->priv->_m_labels_size_, _tmp67_);
					_tmp68_ = (GtkLabel*) gtk_label_new ("test");
					g_object_ref_sink (_tmp68_);
					candidate = _tmp68_;
					_tmp69_ = candidate;
					gtk_widget_set_halign ((GtkWidget*) _tmp69_, GTK_ALIGN_START);
					_tmp70_ = candidate;
					gtk_widget_set_valign ((GtkWidget*) _tmp70_, GTK_ALIGN_CENTER);
					_tmp71_ = candidate;
					gtk_widget_show ((GtkWidget*) _tmp71_);
					_tmp72_ = candidate;
					_tmp73_ = _g_object_ref0 (_tmp72_);
					_vala_array_add2 (&self->priv->m_candidates, &self->priv->m_candidates_length1, &self->priv->_m_candidates_size_, _tmp73_);
					_tmp74_ = label;
					gtk_widget_set_margin_start ((GtkWidget*) _tmp74_, 8);
					_tmp75_ = label;
					gtk_widget_set_margin_end ((GtkWidget*) _tmp75_, 8);
					_tmp76_ = candidate;
					gtk_widget_set_margin_start ((GtkWidget*) _tmp76_, 8);
					_tmp77_ = candidate;
					gtk_widget_set_margin_end ((GtkWidget*) _tmp77_, 8);
					_data2_->index = _data1_->i;
					_tmp78_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp78_);
					label_ebox = _tmp78_;
					_tmp79_ = label_ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp79_, TRUE);
					_tmp80_ = label_ebox;
					g_signal_connect_data ((GtkWidget*) _tmp80_, "button-press-event", (GCallback) _______lambda10__gtk_widget_button_press_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp81_ = label_ebox;
					_tmp82_ = label;
					gtk_container_add ((GtkContainer*) _tmp81_, (GtkWidget*) _tmp82_);
					_tmp83_ = labels_vbox;
					_tmp84_ = label_ebox;
					gtk_box_pack_start (_tmp83_, (GtkWidget*) _tmp84_, FALSE, FALSE, (guint) 2);
					_tmp85_ = label_ebox;
					_tmp86_ = _g_object_ref0 ((GtkWidget*) _tmp85_);
					_vala_array_add3 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp86_);
					_tmp87_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp87_);
					candidate_ebox = _tmp87_;
					_tmp88_ = candidate_ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp88_, TRUE);
					_tmp89_ = candidate_ebox;
					g_signal_connect_data ((GtkWidget*) _tmp89_, "button-press-event", (GCallback) _______lambda11__gtk_widget_button_press_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp90_ = candidate_ebox;
					_tmp91_ = candidate;
					gtk_container_add ((GtkContainer*) _tmp90_, (GtkWidget*) _tmp91_);
					_tmp92_ = candidates_vbox;
					_tmp93_ = candidate_ebox;
					gtk_box_pack_start (_tmp92_, (GtkWidget*) _tmp93_, FALSE, FALSE, (guint) 2);
					_tmp94_ = candidate_ebox;
					_tmp95_ = _g_object_ref0 ((GtkWidget*) _tmp94_);
					_vala_array_add4 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp95_);
					_g_object_unref0 (candidate_ebox);
					_g_object_unref0 (label_ebox);
					_g_object_unref0 (candidate);
					_g_object_unref0 (label);
					block2_data_unref (_data2_);
					_data2_ = NULL;
				}
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
		_g_object_unref0 (state_label);
		_g_object_unref0 (buttons_hbox);
		_g_object_unref0 (candidates_vbox);
		_g_object_unref0 (labels_vbox);
		_g_object_unref0 (candidates_hbox);
		_g_object_unref0 (vbox);
		_g_object_unref0 (container_ebox);
	} else {
		GtkEventBox* container_ebox = NULL;
		GtkEventBox* _tmp96_;
		GtkEventBox* _tmp97_;
		GtkEventBox* _tmp98_;
		GtkEventBox* _tmp99_;
		GtkBox* hbox = NULL;
		GtkBox* _tmp100_;
		GtkEventBox* _tmp101_;
		GtkBox* _tmp102_;
		GtkLabel** _tmp103_;
		GtkLabel** _tmp104_;
		GtkWidget** _tmp105_;
		GtkBox* _tmp136_;
		VSeparator* _tmp137_;
		VSeparator* _tmp138_;
		GtkBox* _tmp139_;
		GtkButton* _tmp140_;
		GtkBox* _tmp141_;
		GtkButton* _tmp142_;
		_tmp96_ = (GtkEventBox*) gtk_event_box_new ();
		g_object_ref_sink (_tmp96_);
		container_ebox = _tmp96_;
		_tmp97_ = container_ebox;
		gtk_widget_add_events ((GtkWidget*) _tmp97_, (gint) GDK_SCROLL_MASK);
		_tmp98_ = container_ebox;
		g_signal_connect_object ((GtkWidget*) _tmp98_, "scroll-event", (GCallback) _candidate_area_candidate_scrolled_gtk_widget_scroll_event, self, 0);
		_tmp99_ = container_ebox;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp99_);
		_tmp100_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp100_);
		hbox = _tmp100_;
		_tmp101_ = container_ebox;
		_tmp102_ = hbox;
		gtk_container_add ((GtkContainer*) _tmp101_, (GtkWidget*) _tmp102_);
		_tmp103_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_labels = _tmp103_;
		self->priv->m_labels_length1 = 0;
		self->priv->_m_labels_size_ = self->priv->m_labels_length1;
		_tmp104_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_candidates = _tmp104_;
		self->priv->m_candidates_length1 = 0;
		self->priv->_m_candidates_size_ = self->priv->m_candidates_length1;
		_tmp105_ = g_new0 (GtkWidget*, 0 + 1);
		self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_widgets = _tmp105_;
		self->priv->m_widgets_length1 = 0;
		self->priv->_m_widgets_size_ = self->priv->m_widgets_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp106_ = FALSE;
				_tmp106_ = TRUE;
				while (TRUE) {
					Block3Data* _data3_;
					GtkLabel* label = NULL;
					const gchar* _tmp108_;
					GtkLabel* _tmp109_;
					GtkLabel* _tmp110_;
					GtkLabel* _tmp111_;
					GtkLabel* _tmp112_;
					GtkLabel* _tmp113_;
					GtkLabel* _tmp114_;
					GtkLabel* candidate = NULL;
					GtkLabel* _tmp115_;
					GtkLabel* _tmp116_;
					GtkLabel* _tmp117_;
					GtkLabel* _tmp118_;
					GtkLabel* _tmp119_;
					GtkLabel* _tmp120_;
					GtkBox* candidate_hbox = NULL;
					GtkBox* _tmp121_;
					GtkBox* _tmp122_;
					GtkBox* _tmp123_;
					GtkLabel* _tmp124_;
					GtkBox* _tmp125_;
					GtkLabel* _tmp126_;
					GtkEventBox* ebox = NULL;
					GtkEventBox* _tmp127_;
					GtkEventBox* _tmp128_;
					GtkEventBox* _tmp129_;
					GtkEventBox* _tmp130_;
					GtkBox* _tmp131_;
					GtkBox* _tmp132_;
					GtkEventBox* _tmp133_;
					GtkEventBox* _tmp134_;
					GtkWidget* _tmp135_;
					_data3_ = g_slice_new0 (Block3Data);
					_data3_->_ref_count_ = 1;
					_data3_->self = g_object_ref (self);
					if (!_tmp106_) {
						gint _tmp107_;
						_tmp107_ = i;
						i = _tmp107_ + 1;
					}
					_tmp106_ = FALSE;
					if (!(i < 16)) {
						block3_data_unref (_data3_);
						_data3_ = NULL;
						break;
					}
					_tmp108_ = CANDIDATE_AREA_LABELS[i];
					_tmp109_ = (GtkLabel*) gtk_label_new (_tmp108_);
					g_object_ref_sink (_tmp109_);
					label = _tmp109_;
					_tmp110_ = label;
					gtk_widget_set_halign ((GtkWidget*) _tmp110_, GTK_ALIGN_START);
					_tmp111_ = label;
					gtk_widget_set_valign ((GtkWidget*) _tmp111_, GTK_ALIGN_CENTER);
					_tmp112_ = label;
					gtk_widget_show ((GtkWidget*) _tmp112_);
					_tmp113_ = label;
					_tmp114_ = _g_object_ref0 (_tmp113_);
					_vala_array_add5 (&self->priv->m_labels, &self->priv->m_labels_length1, &self->priv->_m_labels_size_, _tmp114_);
					_tmp115_ = (GtkLabel*) gtk_label_new ("test");
					g_object_ref_sink (_tmp115_);
					candidate = _tmp115_;
					_tmp116_ = candidate;
					gtk_widget_set_halign ((GtkWidget*) _tmp116_, GTK_ALIGN_START);
					_tmp117_ = candidate;
					gtk_widget_set_valign ((GtkWidget*) _tmp117_, GTK_ALIGN_CENTER);
					_tmp118_ = candidate;
					gtk_widget_show ((GtkWidget*) _tmp118_);
					_tmp119_ = candidate;
					_tmp120_ = _g_object_ref0 (_tmp119_);
					_vala_array_add6 (&self->priv->m_candidates, &self->priv->m_candidates_length1, &self->priv->_m_candidates_size_, _tmp120_);
					_tmp121_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
					g_object_ref_sink (_tmp121_);
					candidate_hbox = _tmp121_;
					_tmp122_ = candidate_hbox;
					gtk_widget_show ((GtkWidget*) _tmp122_);
					_tmp123_ = candidate_hbox;
					_tmp124_ = label;
					gtk_box_pack_start (_tmp123_, (GtkWidget*) _tmp124_, FALSE, FALSE, (guint) 2);
					_tmp125_ = candidate_hbox;
					_tmp126_ = candidate;
					gtk_box_pack_start (_tmp125_, (GtkWidget*) _tmp126_, FALSE, FALSE, (guint) 2);
					_data3_->index = i;
					_tmp127_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp127_);
					ebox = _tmp127_;
					_tmp128_ = ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp128_, TRUE);
					_tmp129_ = ebox;
					g_signal_connect_data ((GtkWidget*) _tmp129_, "button-press-event", (GCallback) _______lambda12__gtk_widget_button_press_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
					_tmp130_ = ebox;
					_tmp131_ = candidate_hbox;
					gtk_container_add ((GtkContainer*) _tmp130_, (GtkWidget*) _tmp131_);
					_tmp132_ = hbox;
					_tmp133_ = ebox;
					gtk_box_pack_start (_tmp132_, (GtkWidget*) _tmp133_, FALSE, FALSE, (guint) 4);
					_tmp134_ = ebox;
					_tmp135_ = _g_object_ref0 ((GtkWidget*) _tmp134_);
					_vala_array_add7 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp135_);
					_g_object_unref0 (ebox);
					_g_object_unref0 (candidate_hbox);
					_g_object_unref0 (candidate);
					_g_object_unref0 (label);
					block3_data_unref (_data3_);
					_data3_ = NULL;
				}
			}
		}
		_tmp136_ = hbox;
		_tmp137_ = vseparator_new ();
		g_object_ref_sink (_tmp137_);
		_tmp138_ = _tmp137_;
		gtk_box_pack_start (_tmp136_, (GtkWidget*) _tmp138_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp138_);
		_tmp139_ = hbox;
		_tmp140_ = prev_button;
		gtk_box_pack_start (_tmp139_, (GtkWidget*) _tmp140_, FALSE, FALSE, (guint) 0);
		_tmp141_ = hbox;
		_tmp142_ = next_button;
		gtk_box_pack_start (_tmp141_, (GtkWidget*) _tmp142_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (hbox);
		_g_object_unref0 (container_ebox);
	}
	_g_object_unref0 (next_button);
	_g_object_unref0 (prev_button);
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}

static void
candidate_area_class_init (CandidateAreaClass * klass,
                           gpointer klass_data)
{
	candidate_area_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CandidateArea_private_offset);
	G_OBJECT_CLASS (klass)->finalize = candidate_area_finalize;
	candidate_area_signals[CANDIDATE_AREA_CANDIDATE_CLICKED_SIGNAL] = g_signal_new ("candidate-clicked", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
	candidate_area_signals[CANDIDATE_AREA_PAGE_UP_SIGNAL] = g_signal_new ("page-up", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_area_signals[CANDIDATE_AREA_PAGE_DOWN_SIGNAL] = g_signal_new ("page-down", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_area_signals[CANDIDATE_AREA_CURSOR_UP_SIGNAL] = g_signal_new ("cursor-up", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_area_signals[CANDIDATE_AREA_CURSOR_DOWN_SIGNAL] = g_signal_new ("cursor-down", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
candidate_area_instance_init (CandidateArea * self,
                              gpointer klass)
{
	self->priv = candidate_area_get_instance_private (self);
}

static void
candidate_area_finalize (GObject * obj)
{
	CandidateArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CANDIDATE_AREA, CandidateArea);
	self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_ibus_candidates = (_vala_array_free (self->priv->m_ibus_candidates, self->priv->m_ibus_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	_themed_rgba_unref0 (self->priv->m_rgba);
	_pango_attribute_destroy0 (self->priv->m_language_attribute);
	G_OBJECT_CLASS (candidate_area_parent_class)->finalize (obj);
}

static GType
candidate_area_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CandidateAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) candidate_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CandidateArea), 0, (GInstanceInitFunc) candidate_area_instance_init, NULL };
	GType candidate_area_type_id;
	candidate_area_type_id = g_type_register_static (gtk_box_get_type (), "CandidateArea", &g_define_type_info, 0);
	CandidateArea_private_offset = g_type_add_instance_private (candidate_area_type_id, sizeof (CandidateAreaPrivate));
	return candidate_area_type_id;
}

GType
candidate_area_get_type (void)
{
	static volatile gsize candidate_area_type_id__volatile = 0;
	if (g_once_init_enter (&candidate_area_type_id__volatile)) {
		GType candidate_area_type_id;
		candidate_area_type_id = candidate_area_get_type_once ();
		g_once_init_leave (&candidate_area_type_id__volatile, candidate_area_type_id);
	}
	return candidate_area_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

