// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/resultstore/v2/resultstore_upload.proto

package resultstore

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The operation for the request (e.g. Create(), Update(), etc.)
type UploadRequest_UploadOperation int32

const (
	// Unspecified
	UploadRequest_UPLOAD_OPERATION_UNSPECIFIED UploadRequest_UploadOperation = 0
	// Create the given resources.
	// For more information, check the Create APIs.
	UploadRequest_CREATE UploadRequest_UploadOperation = 1
	// Applies a standard update to the resource identified by the given
	// proto's name. For more information, see the Update APIs.
	// UploadBatch does not support arbitrary field masks. The list of allowed
	// field masks can be found below.
	UploadRequest_UPDATE UploadRequest_UploadOperation = 2
	// Applies an merge update to the resource identified by the given
	// proto's name. For more information, see the Merge APIs.
	// Currently, only the "files" and "file_processing_errors" fields are
	// supported by this operation.
	UploadRequest_MERGE UploadRequest_UploadOperation = 3
	// Declares the resource with the given name as finalized and immutable by
	// the uploader. Only supported for Invocation, Target, ConfiguredTarget.
	// There must be no operation on child resources after parent resource is
	// Finalized. If there is a Finalize of Invocation, it must be the final
	// UploadRequest. For more information, see the Finalize APIs.
	// An empty resource should be provided below.
	UploadRequest_FINALIZE UploadRequest_UploadOperation = 4
)

var UploadRequest_UploadOperation_name = map[int32]string{
	0: "UPLOAD_OPERATION_UNSPECIFIED",
	1: "CREATE",
	2: "UPDATE",
	3: "MERGE",
	4: "FINALIZE",
}

var UploadRequest_UploadOperation_value = map[string]int32{
	"UPLOAD_OPERATION_UNSPECIFIED": 0,
	"CREATE":                       1,
	"UPDATE":                       2,
	"MERGE":                        3,
	"FINALIZE":                     4,
}

func (x UploadRequest_UploadOperation) String() string {
	return proto.EnumName(UploadRequest_UploadOperation_name, int32(x))
}

func (UploadRequest_UploadOperation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{28, 0}
}

// Request passed into CreateInvocation
type CreateInvocationRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID. If set, invocation_id must also be provided.
	// Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The invocation ID. It is optional, but strongly recommended.
	//
	// If left empty then a new unique ID will be assigned by the server. If
	// populated, a RFC 4122-compliant v4 UUID is preferred, but v3 or v5 UUIDs
	// are allowed too.
	InvocationId string `protobuf:"bytes,2,opt,name=invocation_id,json=invocationId,proto3" json:"invocation_id,omitempty"`
	// The invocation to create.  Its name field will be ignored, since the name
	// will be derived from the id field above and assigned by the server.
	Invocation *Invocation `protobuf:"bytes,3,opt,name=invocation,proto3" json:"invocation,omitempty"`
	// This is a token to authorize upload access to this invocation. It must be
	// set to a RFC 4122-compliant v3, v4, or v5 UUID. Once this is set in
	// CreateInvocation, all other upload RPCs for that Invocation and any of its
	// child resources must also include the exact same token, or they will be
	// rejected. The generated token should be unique to this invocation, and it
	// should be kept secret.
	//
	// The purpose of this field is to prevent other users and tools from
	// clobbering your upload intentionally or accidentally. The standard way of
	// using this token is to create a second v4 UUID when the invocation_id is
	// created, and storing them together during the upload. Essentially, this is
	// a "password" to the invocation.
	AuthorizationToken string `protobuf:"bytes,4,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// By default, Invocations are auto-finalized if they are not modified for 24
	// hours. If you need auto-finalize to happen sooner, set this field to the
	// time you'd like auto-finalize to occur.
	AutoFinalizeTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=auto_finalize_time,json=autoFinalizeTime,proto3" json:"auto_finalize_time,omitempty"`
	// Client provided unique token for batch upload to ensure data integrity and
	// to provide a way to resume batch upload in case of a distributed failure on
	// the client side. The standard uploading client is presumed to have many
	// machines uploading to ResultStore, and that any given machine could process
	// any given Invocation at any time. This field is used to coordinate between
	// the client's machines, resolve concurrency issues, and enforce "exactly
	// once" semantics on each batch within the upload.
	//
	// The typical usage of the resume_token is that it should contain a "key"
	// indicating to the client where it is in the upload process, so that the
	// client can use it to resume the upload by reconstructing the state of
	// upload from the point where it was interrupted.
	//
	// If this matches the previously uploaded resume_token, then this request
	// will silently do nothing, making CreateInvocation idempotent.
	// If this token is provided, all further upload RPCs must be done through
	// UploadBatch. This token must not be combined with request_id.
	// Must be web safe Base64 encoded bytes.
	InitialResumeToken string `protobuf:"bytes,7,opt,name=initial_resume_token,json=initialResumeToken,proto3" json:"initial_resume_token,omitempty"`
	// Client-specific data used to resume batch upload if an error occurs and
	// retry is needed. This serves a role closely related to resume_token, as
	// both fields may be used to provide state required to restore a Batch
	// Upload, but they differ in two important aspects:
	//  - it is not compared to previous values, and as such does not provide
	//    concurrency control;
	//  - it allows for a larger payload, since the contents are never
	//    inspected/compared;
	// The size of the message must be within 1 MiB. Too large requests will be
	// rejected.
	UploaderState        []byte   `protobuf:"bytes,8,opt,name=uploader_state,json=uploaderState,proto3" json:"uploader_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateInvocationRequest) Reset()         { *m = CreateInvocationRequest{} }
func (m *CreateInvocationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInvocationRequest) ProtoMessage()    {}
func (*CreateInvocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{0}
}

func (m *CreateInvocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInvocationRequest.Unmarshal(m, b)
}
func (m *CreateInvocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInvocationRequest.Marshal(b, m, deterministic)
}
func (m *CreateInvocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInvocationRequest.Merge(m, src)
}
func (m *CreateInvocationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInvocationRequest.Size(m)
}
func (m *CreateInvocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInvocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInvocationRequest proto.InternalMessageInfo

func (m *CreateInvocationRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateInvocationRequest) GetInvocationId() string {
	if m != nil {
		return m.InvocationId
	}
	return ""
}

func (m *CreateInvocationRequest) GetInvocation() *Invocation {
	if m != nil {
		return m.Invocation
	}
	return nil
}

func (m *CreateInvocationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *CreateInvocationRequest) GetAutoFinalizeTime() *timestamp.Timestamp {
	if m != nil {
		return m.AutoFinalizeTime
	}
	return nil
}

func (m *CreateInvocationRequest) GetInitialResumeToken() string {
	if m != nil {
		return m.InitialResumeToken
	}
	return ""
}

func (m *CreateInvocationRequest) GetUploaderState() []byte {
	if m != nil {
		return m.UploaderState
	}
	return nil
}

// Request passed into UpdateInvocation
type UpdateInvocationRequest struct {
	// Contains the name and the fields of the invocation to be updated.  The
	// name format must be: invocations/${INVOCATION_ID}
	Invocation *Invocation `protobuf:"bytes,3,opt,name=invocation,proto3" json:"invocation,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateInvocationRequest) Reset()         { *m = UpdateInvocationRequest{} }
func (m *UpdateInvocationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInvocationRequest) ProtoMessage()    {}
func (*UpdateInvocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{1}
}

func (m *UpdateInvocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInvocationRequest.Unmarshal(m, b)
}
func (m *UpdateInvocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInvocationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateInvocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInvocationRequest.Merge(m, src)
}
func (m *UpdateInvocationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInvocationRequest.Size(m)
}
func (m *UpdateInvocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInvocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInvocationRequest proto.InternalMessageInfo

func (m *UpdateInvocationRequest) GetInvocation() *Invocation {
	if m != nil {
		return m.Invocation
	}
	return nil
}

func (m *UpdateInvocationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInvocationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into MergeInvocation
type MergeInvocationRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Contains the name and the fields of the invocation to be merged.  The
	// name format must be: invocations/${INVOCATION_ID}
	Invocation *Invocation `protobuf:"bytes,3,opt,name=invocation,proto3" json:"invocation,omitempty"`
	// Indicates which fields to merge.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeInvocationRequest) Reset()         { *m = MergeInvocationRequest{} }
func (m *MergeInvocationRequest) String() string { return proto.CompactTextString(m) }
func (*MergeInvocationRequest) ProtoMessage()    {}
func (*MergeInvocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{2}
}

func (m *MergeInvocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MergeInvocationRequest.Unmarshal(m, b)
}
func (m *MergeInvocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MergeInvocationRequest.Marshal(b, m, deterministic)
}
func (m *MergeInvocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeInvocationRequest.Merge(m, src)
}
func (m *MergeInvocationRequest) XXX_Size() int {
	return xxx_messageInfo_MergeInvocationRequest.Size(m)
}
func (m *MergeInvocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeInvocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeInvocationRequest proto.InternalMessageInfo

func (m *MergeInvocationRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *MergeInvocationRequest) GetInvocation() *Invocation {
	if m != nil {
		return m.Invocation
	}
	return nil
}

func (m *MergeInvocationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *MergeInvocationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into TouchInvocation
type TouchInvocationRequest struct {
	// The name of the invocation.  Its format must be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,2,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TouchInvocationRequest) Reset()         { *m = TouchInvocationRequest{} }
func (m *TouchInvocationRequest) String() string { return proto.CompactTextString(m) }
func (*TouchInvocationRequest) ProtoMessage()    {}
func (*TouchInvocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{3}
}

func (m *TouchInvocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TouchInvocationRequest.Unmarshal(m, b)
}
func (m *TouchInvocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TouchInvocationRequest.Marshal(b, m, deterministic)
}
func (m *TouchInvocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TouchInvocationRequest.Merge(m, src)
}
func (m *TouchInvocationRequest) XXX_Size() int {
	return xxx_messageInfo_TouchInvocationRequest.Size(m)
}
func (m *TouchInvocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TouchInvocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TouchInvocationRequest proto.InternalMessageInfo

func (m *TouchInvocationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TouchInvocationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Response returned from TouchInvocation
type TouchInvocationResponse struct {
	// The name of the invocation.  Its format will be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Invocation.
	Id                   *Invocation_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TouchInvocationResponse) Reset()         { *m = TouchInvocationResponse{} }
func (m *TouchInvocationResponse) String() string { return proto.CompactTextString(m) }
func (*TouchInvocationResponse) ProtoMessage()    {}
func (*TouchInvocationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{4}
}

func (m *TouchInvocationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TouchInvocationResponse.Unmarshal(m, b)
}
func (m *TouchInvocationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TouchInvocationResponse.Marshal(b, m, deterministic)
}
func (m *TouchInvocationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TouchInvocationResponse.Merge(m, src)
}
func (m *TouchInvocationResponse) XXX_Size() int {
	return xxx_messageInfo_TouchInvocationResponse.Size(m)
}
func (m *TouchInvocationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TouchInvocationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TouchInvocationResponse proto.InternalMessageInfo

func (m *TouchInvocationResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TouchInvocationResponse) GetId() *Invocation_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

// Request passed into DeleteInvocation
type DeleteInvocationRequest struct {
	// The name of the invocation.  Its format must be:
	// invocations/${INVOCATION_ID}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInvocationRequest) Reset()         { *m = DeleteInvocationRequest{} }
func (m *DeleteInvocationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInvocationRequest) ProtoMessage()    {}
func (*DeleteInvocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{5}
}

func (m *DeleteInvocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInvocationRequest.Unmarshal(m, b)
}
func (m *DeleteInvocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInvocationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteInvocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInvocationRequest.Merge(m, src)
}
func (m *DeleteInvocationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInvocationRequest.Size(m)
}
func (m *DeleteInvocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInvocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInvocationRequest proto.InternalMessageInfo

func (m *DeleteInvocationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request passed into FinalizeInvocation
type FinalizeInvocationRequest struct {
	// The name of the invocation.  Its format must be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeInvocationRequest) Reset()         { *m = FinalizeInvocationRequest{} }
func (m *FinalizeInvocationRequest) String() string { return proto.CompactTextString(m) }
func (*FinalizeInvocationRequest) ProtoMessage()    {}
func (*FinalizeInvocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{6}
}

func (m *FinalizeInvocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeInvocationRequest.Unmarshal(m, b)
}
func (m *FinalizeInvocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeInvocationRequest.Marshal(b, m, deterministic)
}
func (m *FinalizeInvocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeInvocationRequest.Merge(m, src)
}
func (m *FinalizeInvocationRequest) XXX_Size() int {
	return xxx_messageInfo_FinalizeInvocationRequest.Size(m)
}
func (m *FinalizeInvocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeInvocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeInvocationRequest proto.InternalMessageInfo

func (m *FinalizeInvocationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinalizeInvocationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Response returned from FinalizeInvocation
type FinalizeInvocationResponse struct {
	// The name of the invocation.  Its format will be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Invocation.
	Id                   *Invocation_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FinalizeInvocationResponse) Reset()         { *m = FinalizeInvocationResponse{} }
func (m *FinalizeInvocationResponse) String() string { return proto.CompactTextString(m) }
func (*FinalizeInvocationResponse) ProtoMessage()    {}
func (*FinalizeInvocationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{7}
}

func (m *FinalizeInvocationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeInvocationResponse.Unmarshal(m, b)
}
func (m *FinalizeInvocationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeInvocationResponse.Marshal(b, m, deterministic)
}
func (m *FinalizeInvocationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeInvocationResponse.Merge(m, src)
}
func (m *FinalizeInvocationResponse) XXX_Size() int {
	return xxx_messageInfo_FinalizeInvocationResponse.Size(m)
}
func (m *FinalizeInvocationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeInvocationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeInvocationResponse proto.InternalMessageInfo

func (m *FinalizeInvocationResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinalizeInvocationResponse) GetId() *Invocation_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

// Request passed into CreateTarget
type CreateTargetRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent invocation in which the target is created.
	// Its format must be invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The target identifier.  It can be any string up to 1024 Unicode characters
	// long except for the reserved id '-'.
	TargetId string `protobuf:"bytes,3,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// The target to create.  Its name field will be ignored, since the name will
	// be derived from the id field above and assigned by the server.
	Target *Target `protobuf:"bytes,4,opt,name=target,proto3" json:"target,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTargetRequest) Reset()         { *m = CreateTargetRequest{} }
func (m *CreateTargetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTargetRequest) ProtoMessage()    {}
func (*CreateTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{8}
}

func (m *CreateTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTargetRequest.Unmarshal(m, b)
}
func (m *CreateTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTargetRequest.Marshal(b, m, deterministic)
}
func (m *CreateTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTargetRequest.Merge(m, src)
}
func (m *CreateTargetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTargetRequest.Size(m)
}
func (m *CreateTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTargetRequest proto.InternalMessageInfo

func (m *CreateTargetRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateTargetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTargetRequest) GetTargetId() string {
	if m != nil {
		return m.TargetId
	}
	return ""
}

func (m *CreateTargetRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CreateTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateTarget
type UpdateTargetRequest struct {
	// Contains the name and the fields of the target to be updated.  The name
	// format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Target *Target `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Update operation will become a Create operation if the
	// Target is NOT_FOUND.
	CreateIfNotFound     bool     `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateTargetRequest) Reset()         { *m = UpdateTargetRequest{} }
func (m *UpdateTargetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTargetRequest) ProtoMessage()    {}
func (*UpdateTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{9}
}

func (m *UpdateTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTargetRequest.Unmarshal(m, b)
}
func (m *UpdateTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTargetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTargetRequest.Merge(m, src)
}
func (m *UpdateTargetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTargetRequest.Size(m)
}
func (m *UpdateTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTargetRequest proto.InternalMessageInfo

func (m *UpdateTargetRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *UpdateTargetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *UpdateTargetRequest) GetCreateIfNotFound() bool {
	if m != nil {
		return m.CreateIfNotFound
	}
	return false
}

// Request passed into MergeTarget
type MergeTargetRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Contains the name and the fields of the target to be merged.  The name
	// format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Target *Target `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Indicates which fields to merge.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Merge operation will become a Create operation if the
	// Target is NOT_FOUND.
	CreateIfNotFound     bool     `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeTargetRequest) Reset()         { *m = MergeTargetRequest{} }
func (m *MergeTargetRequest) String() string { return proto.CompactTextString(m) }
func (*MergeTargetRequest) ProtoMessage()    {}
func (*MergeTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{10}
}

func (m *MergeTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MergeTargetRequest.Unmarshal(m, b)
}
func (m *MergeTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MergeTargetRequest.Marshal(b, m, deterministic)
}
func (m *MergeTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeTargetRequest.Merge(m, src)
}
func (m *MergeTargetRequest) XXX_Size() int {
	return xxx_messageInfo_MergeTargetRequest.Size(m)
}
func (m *MergeTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeTargetRequest proto.InternalMessageInfo

func (m *MergeTargetRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *MergeTargetRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *MergeTargetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *MergeTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *MergeTargetRequest) GetCreateIfNotFound() bool {
	if m != nil {
		return m.CreateIfNotFound
	}
	return false
}

// Request passed into FinalizeTarget
type FinalizeTargetRequest struct {
	// The name of the target.  Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeTargetRequest) Reset()         { *m = FinalizeTargetRequest{} }
func (m *FinalizeTargetRequest) String() string { return proto.CompactTextString(m) }
func (*FinalizeTargetRequest) ProtoMessage()    {}
func (*FinalizeTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{11}
}

func (m *FinalizeTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeTargetRequest.Unmarshal(m, b)
}
func (m *FinalizeTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeTargetRequest.Marshal(b, m, deterministic)
}
func (m *FinalizeTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeTargetRequest.Merge(m, src)
}
func (m *FinalizeTargetRequest) XXX_Size() int {
	return xxx_messageInfo_FinalizeTargetRequest.Size(m)
}
func (m *FinalizeTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeTargetRequest proto.InternalMessageInfo

func (m *FinalizeTargetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinalizeTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Response returned from FinalizeTarget
type FinalizeTargetResponse struct {
	// The name of the target.  Its format will be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Target.
	Id                   *Target_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *FinalizeTargetResponse) Reset()         { *m = FinalizeTargetResponse{} }
func (m *FinalizeTargetResponse) String() string { return proto.CompactTextString(m) }
func (*FinalizeTargetResponse) ProtoMessage()    {}
func (*FinalizeTargetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{12}
}

func (m *FinalizeTargetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeTargetResponse.Unmarshal(m, b)
}
func (m *FinalizeTargetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeTargetResponse.Marshal(b, m, deterministic)
}
func (m *FinalizeTargetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeTargetResponse.Merge(m, src)
}
func (m *FinalizeTargetResponse) XXX_Size() int {
	return xxx_messageInfo_FinalizeTargetResponse.Size(m)
}
func (m *FinalizeTargetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeTargetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeTargetResponse proto.InternalMessageInfo

func (m *FinalizeTargetResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinalizeTargetResponse) GetId() *Target_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

// Request passed into CreateConfiguredTarget
type CreateConfiguredTargetRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent target in which the configured target is created.
	// Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The configuration identifier. This must match the ID of an existing
	// Configuration under this Invocation. Cannot be the reserved id '-'.
	ConfigId string `protobuf:"bytes,3,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// The configured target to create. Its name field will be ignored, since the
	// name will be derived from the id field above and assigned by the server.
	ConfiguredTarget *ConfiguredTarget `protobuf:"bytes,4,opt,name=configured_target,json=configuredTarget,proto3" json:"configured_target,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateConfiguredTargetRequest) Reset()         { *m = CreateConfiguredTargetRequest{} }
func (m *CreateConfiguredTargetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateConfiguredTargetRequest) ProtoMessage()    {}
func (*CreateConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{13}
}

func (m *CreateConfiguredTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateConfiguredTargetRequest.Unmarshal(m, b)
}
func (m *CreateConfiguredTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateConfiguredTargetRequest.Marshal(b, m, deterministic)
}
func (m *CreateConfiguredTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateConfiguredTargetRequest.Merge(m, src)
}
func (m *CreateConfiguredTargetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateConfiguredTargetRequest.Size(m)
}
func (m *CreateConfiguredTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateConfiguredTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateConfiguredTargetRequest proto.InternalMessageInfo

func (m *CreateConfiguredTargetRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateConfiguredTargetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateConfiguredTargetRequest) GetConfigId() string {
	if m != nil {
		return m.ConfigId
	}
	return ""
}

func (m *CreateConfiguredTargetRequest) GetConfiguredTarget() *ConfiguredTarget {
	if m != nil {
		return m.ConfiguredTarget
	}
	return nil
}

func (m *CreateConfiguredTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateConfiguredTarget
type UpdateConfiguredTargetRequest struct {
	// Contains the name and the fields of the configured target to be updated.
	// The name format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}
	ConfiguredTarget *ConfiguredTarget `protobuf:"bytes,3,opt,name=configured_target,json=configuredTarget,proto3" json:"configured_target,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Update operation will become a Create operation if the
	// ConfiguredTarget is NOT_FOUND.
	CreateIfNotFound     bool     `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateConfiguredTargetRequest) Reset()         { *m = UpdateConfiguredTargetRequest{} }
func (m *UpdateConfiguredTargetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateConfiguredTargetRequest) ProtoMessage()    {}
func (*UpdateConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{14}
}

func (m *UpdateConfiguredTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConfiguredTargetRequest.Unmarshal(m, b)
}
func (m *UpdateConfiguredTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConfiguredTargetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateConfiguredTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConfiguredTargetRequest.Merge(m, src)
}
func (m *UpdateConfiguredTargetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateConfiguredTargetRequest.Size(m)
}
func (m *UpdateConfiguredTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConfiguredTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConfiguredTargetRequest proto.InternalMessageInfo

func (m *UpdateConfiguredTargetRequest) GetConfiguredTarget() *ConfiguredTarget {
	if m != nil {
		return m.ConfiguredTarget
	}
	return nil
}

func (m *UpdateConfiguredTargetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateConfiguredTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *UpdateConfiguredTargetRequest) GetCreateIfNotFound() bool {
	if m != nil {
		return m.CreateIfNotFound
	}
	return false
}

// Request passed into MergeConfiguredTarget
type MergeConfiguredTargetRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Contains the name and the fields of the configured target to be merged.
	// The name format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}
	ConfiguredTarget *ConfiguredTarget `protobuf:"bytes,3,opt,name=configured_target,json=configuredTarget,proto3" json:"configured_target,omitempty"`
	// Indicates which fields to merge.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Merge operation will become a Create operation if the
	// ConfiguredTarget is NOT_FOUND.
	CreateIfNotFound     bool     `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeConfiguredTargetRequest) Reset()         { *m = MergeConfiguredTargetRequest{} }
func (m *MergeConfiguredTargetRequest) String() string { return proto.CompactTextString(m) }
func (*MergeConfiguredTargetRequest) ProtoMessage()    {}
func (*MergeConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{15}
}

func (m *MergeConfiguredTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MergeConfiguredTargetRequest.Unmarshal(m, b)
}
func (m *MergeConfiguredTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MergeConfiguredTargetRequest.Marshal(b, m, deterministic)
}
func (m *MergeConfiguredTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeConfiguredTargetRequest.Merge(m, src)
}
func (m *MergeConfiguredTargetRequest) XXX_Size() int {
	return xxx_messageInfo_MergeConfiguredTargetRequest.Size(m)
}
func (m *MergeConfiguredTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeConfiguredTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeConfiguredTargetRequest proto.InternalMessageInfo

func (m *MergeConfiguredTargetRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *MergeConfiguredTargetRequest) GetConfiguredTarget() *ConfiguredTarget {
	if m != nil {
		return m.ConfiguredTarget
	}
	return nil
}

func (m *MergeConfiguredTargetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *MergeConfiguredTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *MergeConfiguredTargetRequest) GetCreateIfNotFound() bool {
	if m != nil {
		return m.CreateIfNotFound
	}
	return false
}

// Request passed into FinalizeConfiguredTarget
type FinalizeConfiguredTargetRequest struct {
	// The name of the configured target. Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeConfiguredTargetRequest) Reset()         { *m = FinalizeConfiguredTargetRequest{} }
func (m *FinalizeConfiguredTargetRequest) String() string { return proto.CompactTextString(m) }
func (*FinalizeConfiguredTargetRequest) ProtoMessage()    {}
func (*FinalizeConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{16}
}

func (m *FinalizeConfiguredTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeConfiguredTargetRequest.Unmarshal(m, b)
}
func (m *FinalizeConfiguredTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeConfiguredTargetRequest.Marshal(b, m, deterministic)
}
func (m *FinalizeConfiguredTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeConfiguredTargetRequest.Merge(m, src)
}
func (m *FinalizeConfiguredTargetRequest) XXX_Size() int {
	return xxx_messageInfo_FinalizeConfiguredTargetRequest.Size(m)
}
func (m *FinalizeConfiguredTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeConfiguredTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeConfiguredTargetRequest proto.InternalMessageInfo

func (m *FinalizeConfiguredTargetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinalizeConfiguredTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Response returned from FinalizeConfiguredTarget
type FinalizeConfiguredTargetResponse struct {
	// The name of the configured target. Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the ConfiguredTarget.
	Id                   *ConfiguredTarget_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FinalizeConfiguredTargetResponse) Reset()         { *m = FinalizeConfiguredTargetResponse{} }
func (m *FinalizeConfiguredTargetResponse) String() string { return proto.CompactTextString(m) }
func (*FinalizeConfiguredTargetResponse) ProtoMessage()    {}
func (*FinalizeConfiguredTargetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{17}
}

func (m *FinalizeConfiguredTargetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeConfiguredTargetResponse.Unmarshal(m, b)
}
func (m *FinalizeConfiguredTargetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeConfiguredTargetResponse.Marshal(b, m, deterministic)
}
func (m *FinalizeConfiguredTargetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeConfiguredTargetResponse.Merge(m, src)
}
func (m *FinalizeConfiguredTargetResponse) XXX_Size() int {
	return xxx_messageInfo_FinalizeConfiguredTargetResponse.Size(m)
}
func (m *FinalizeConfiguredTargetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeConfiguredTargetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeConfiguredTargetResponse proto.InternalMessageInfo

func (m *FinalizeConfiguredTargetResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinalizeConfiguredTargetResponse) GetId() *ConfiguredTarget_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

// Request passed into CreateAction
type CreateActionRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent configured target in which the action is created.
	// Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The action identifier. It can be any string up to 512 Unicode characters
	// long, except for the reserved id '-'.
	//
	// Recommended IDs for Test Actions:
	// "test": For a single test action.
	// "test_shard0_run0_attempt0" ... "test_shard9_run9_attempt9": For tests with
	//  shard/run/attempts.
	//
	// Recommended IDs for Build Actions:
	// "build": If you only have a single build action.
	ActionId string `protobuf:"bytes,3,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// The action to create.  Its name field will be ignored, since the
	// name will be derived from the id field above and assigned by the server.
	Action *Action `protobuf:"bytes,4,opt,name=action,proto3" json:"action,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateActionRequest) Reset()         { *m = CreateActionRequest{} }
func (m *CreateActionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateActionRequest) ProtoMessage()    {}
func (*CreateActionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{18}
}

func (m *CreateActionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateActionRequest.Unmarshal(m, b)
}
func (m *CreateActionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateActionRequest.Marshal(b, m, deterministic)
}
func (m *CreateActionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateActionRequest.Merge(m, src)
}
func (m *CreateActionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateActionRequest.Size(m)
}
func (m *CreateActionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateActionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateActionRequest proto.InternalMessageInfo

func (m *CreateActionRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateActionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateActionRequest) GetActionId() string {
	if m != nil {
		return m.ActionId
	}
	return ""
}

func (m *CreateActionRequest) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *CreateActionRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateAction
type UpdateActionRequest struct {
	// Contains the name and the fields of the action to be updated.  The
	// name format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}/actions/${url_encode(ACTION_ID)}
	Action *Action `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Update operation will become a Create operation if the
	// Action is NOT_FOUND.
	CreateIfNotFound     bool     `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateActionRequest) Reset()         { *m = UpdateActionRequest{} }
func (m *UpdateActionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateActionRequest) ProtoMessage()    {}
func (*UpdateActionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{19}
}

func (m *UpdateActionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateActionRequest.Unmarshal(m, b)
}
func (m *UpdateActionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateActionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateActionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateActionRequest.Merge(m, src)
}
func (m *UpdateActionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateActionRequest.Size(m)
}
func (m *UpdateActionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateActionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateActionRequest proto.InternalMessageInfo

func (m *UpdateActionRequest) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *UpdateActionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateActionRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *UpdateActionRequest) GetCreateIfNotFound() bool {
	if m != nil {
		return m.CreateIfNotFound
	}
	return false
}

// Request passed into MergeAction
type MergeActionRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Contains the name and the fields of the action to be merged.  The
	// name format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}/actions/${url_encode(ACTION_ID)}
	Action *Action `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// Indicates which fields to merge.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Merge operation will become a Create operation if the
	// Action is NOT_FOUND.
	CreateIfNotFound     bool     `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeActionRequest) Reset()         { *m = MergeActionRequest{} }
func (m *MergeActionRequest) String() string { return proto.CompactTextString(m) }
func (*MergeActionRequest) ProtoMessage()    {}
func (*MergeActionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{20}
}

func (m *MergeActionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MergeActionRequest.Unmarshal(m, b)
}
func (m *MergeActionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MergeActionRequest.Marshal(b, m, deterministic)
}
func (m *MergeActionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeActionRequest.Merge(m, src)
}
func (m *MergeActionRequest) XXX_Size() int {
	return xxx_messageInfo_MergeActionRequest.Size(m)
}
func (m *MergeActionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeActionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeActionRequest proto.InternalMessageInfo

func (m *MergeActionRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *MergeActionRequest) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *MergeActionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *MergeActionRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *MergeActionRequest) GetCreateIfNotFound() bool {
	if m != nil {
		return m.CreateIfNotFound
	}
	return false
}

// Request passed into CreateConfiguration
type CreateConfigurationRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent invocation in which the configuration is created.
	// Its format must be invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The configuration identifier. It can be any string up to 256 Unicode
	// characters long. The configuration ID of "default" should be preferred for
	// the default configuration in a single-config invocation. Cannot be the
	// reserved id '-'.
	ConfigId string `protobuf:"bytes,3,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// The configuration to create. Its name field will be ignored, since the name
	// will be derived from the id field above and assigned by the server.
	Configuration *Configuration `protobuf:"bytes,4,opt,name=configuration,proto3" json:"configuration,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateConfigurationRequest) Reset()         { *m = CreateConfigurationRequest{} }
func (m *CreateConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateConfigurationRequest) ProtoMessage()    {}
func (*CreateConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{21}
}

func (m *CreateConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateConfigurationRequest.Unmarshal(m, b)
}
func (m *CreateConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateConfigurationRequest.Marshal(b, m, deterministic)
}
func (m *CreateConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateConfigurationRequest.Merge(m, src)
}
func (m *CreateConfigurationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateConfigurationRequest.Size(m)
}
func (m *CreateConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateConfigurationRequest proto.InternalMessageInfo

func (m *CreateConfigurationRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateConfigurationRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateConfigurationRequest) GetConfigId() string {
	if m != nil {
		return m.ConfigId
	}
	return ""
}

func (m *CreateConfigurationRequest) GetConfiguration() *Configuration {
	if m != nil {
		return m.Configuration
	}
	return nil
}

func (m *CreateConfigurationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateConfiguration
type UpdateConfigurationRequest struct {
	// Contains the name and fields of the configuration to be updated. The name
	// format must be:
	// invocations/${INVOCATION_ID}/configs/${url_encode(CONFIG_ID)}
	Configuration *Configuration `protobuf:"bytes,3,opt,name=configuration,proto3" json:"configuration,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Update operation will become a Create operation if the
	// Configuration is NOT_FOUND.
	CreateIfNotFound     bool     `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateConfigurationRequest) Reset()         { *m = UpdateConfigurationRequest{} }
func (m *UpdateConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateConfigurationRequest) ProtoMessage()    {}
func (*UpdateConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{22}
}

func (m *UpdateConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConfigurationRequest.Unmarshal(m, b)
}
func (m *UpdateConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConfigurationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConfigurationRequest.Merge(m, src)
}
func (m *UpdateConfigurationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateConfigurationRequest.Size(m)
}
func (m *UpdateConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConfigurationRequest proto.InternalMessageInfo

func (m *UpdateConfigurationRequest) GetConfiguration() *Configuration {
	if m != nil {
		return m.Configuration
	}
	return nil
}

func (m *UpdateConfigurationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateConfigurationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *UpdateConfigurationRequest) GetCreateIfNotFound() bool {
	if m != nil {
		return m.CreateIfNotFound
	}
	return false
}

// Request passed into CreateFileSet
type CreateFileSetRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent invocation in which the file set is created.
	// Its format must be invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The file set identifier. It can be any string up to 256 Unicode characters
	// long.
	FileSetId string `protobuf:"bytes,3,opt,name=file_set_id,json=fileSetId,proto3" json:"file_set_id,omitempty"`
	// The file set to create. Its name field will be ignored, since the name will
	// be derived from the id field above and assigned by the server.
	FileSet *FileSet `protobuf:"bytes,4,opt,name=file_set,json=fileSet,proto3" json:"file_set,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFileSetRequest) Reset()         { *m = CreateFileSetRequest{} }
func (m *CreateFileSetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFileSetRequest) ProtoMessage()    {}
func (*CreateFileSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{23}
}

func (m *CreateFileSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFileSetRequest.Unmarshal(m, b)
}
func (m *CreateFileSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFileSetRequest.Marshal(b, m, deterministic)
}
func (m *CreateFileSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFileSetRequest.Merge(m, src)
}
func (m *CreateFileSetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFileSetRequest.Size(m)
}
func (m *CreateFileSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFileSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFileSetRequest proto.InternalMessageInfo

func (m *CreateFileSetRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateFileSetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateFileSetRequest) GetFileSetId() string {
	if m != nil {
		return m.FileSetId
	}
	return ""
}

func (m *CreateFileSetRequest) GetFileSet() *FileSet {
	if m != nil {
		return m.FileSet
	}
	return nil
}

func (m *CreateFileSetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateFileSet
type UpdateFileSetRequest struct {
	// Contains the name and fields of the file set to be updated. The name format
	// must be: invocations/${INVOCATION_ID}/fileSets/${url_encode(FILE_SET_ID)}
	FileSet *FileSet `protobuf:"bytes,1,opt,name=file_set,json=fileSet,proto3" json:"file_set,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Update operation will become a Create operation if the
	// FileSet is NOT_FOUND.
	CreateIfNotFound     bool     `protobuf:"varint,4,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateFileSetRequest) Reset()         { *m = UpdateFileSetRequest{} }
func (m *UpdateFileSetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFileSetRequest) ProtoMessage()    {}
func (*UpdateFileSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{24}
}

func (m *UpdateFileSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFileSetRequest.Unmarshal(m, b)
}
func (m *UpdateFileSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFileSetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFileSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFileSetRequest.Merge(m, src)
}
func (m *UpdateFileSetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFileSetRequest.Size(m)
}
func (m *UpdateFileSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFileSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFileSetRequest proto.InternalMessageInfo

func (m *UpdateFileSetRequest) GetFileSet() *FileSet {
	if m != nil {
		return m.FileSet
	}
	return nil
}

func (m *UpdateFileSetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateFileSetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *UpdateFileSetRequest) GetCreateIfNotFound() bool {
	if m != nil {
		return m.CreateIfNotFound
	}
	return false
}

// Request passed into MergeFileSet
type MergeFileSetRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Contains the name and fields of the file set to be merged. The name
	// format must be:
	// invocations/${INVOCATION_ID}/fileSets/${url_encode(FILE_SET_ID)}
	FileSet *FileSet `protobuf:"bytes,2,opt,name=file_set,json=fileSet,proto3" json:"file_set,omitempty"`
	// Indicates which fields to merge.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,4,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Merge operation will become a Create operation if the
	// FileSet is NOT_FOUND.
	CreateIfNotFound     bool     `protobuf:"varint,5,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeFileSetRequest) Reset()         { *m = MergeFileSetRequest{} }
func (m *MergeFileSetRequest) String() string { return proto.CompactTextString(m) }
func (*MergeFileSetRequest) ProtoMessage()    {}
func (*MergeFileSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{25}
}

func (m *MergeFileSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MergeFileSetRequest.Unmarshal(m, b)
}
func (m *MergeFileSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MergeFileSetRequest.Marshal(b, m, deterministic)
}
func (m *MergeFileSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeFileSetRequest.Merge(m, src)
}
func (m *MergeFileSetRequest) XXX_Size() int {
	return xxx_messageInfo_MergeFileSetRequest.Size(m)
}
func (m *MergeFileSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeFileSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeFileSetRequest proto.InternalMessageInfo

func (m *MergeFileSetRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *MergeFileSetRequest) GetFileSet() *FileSet {
	if m != nil {
		return m.FileSet
	}
	return nil
}

func (m *MergeFileSetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *MergeFileSetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *MergeFileSetRequest) GetCreateIfNotFound() bool {
	if m != nil {
		return m.CreateIfNotFound
	}
	return false
}

// Request passed into UploadBatch
type UploadBatchRequest struct {
	// Required. The name of the invocation being modified.
	// The name format must be: invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A UUID that must match the value provided in CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,2,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// Required. The token of this batch, that will be committed in this UploadBatchRequest.
	// If this matches the previously uploaded resume_token, then this request
	// will silently do nothing.
	// See CreateInvocationRequest.initial_resume_token for more information.
	// Must be web safe Base64 encoded bytes.
	NextResumeToken string `protobuf:"bytes,3,opt,name=next_resume_token,json=nextResumeToken,proto3" json:"next_resume_token,omitempty"`
	// Required. The token of the previous batch that was committed in a UploadBatchRequest.
	// This will be checked after next_resume_token match is checked. If this does
	// not match the previously uploaded resume_token, a 409 Conflict (HTTPS) or
	// ABORTED (gRPC ) error code indicating a concurrency
	// failure will be returned, and that the user should call
	// GetInvocationUploadMetadata to fetch the current resume_token to
	// reconstruct the state of the upload to resume it.
	// See CreateInvocationRequest.initial_resume_token for more information.
	// Must be web safe Base64 encoded bytes.
	ResumeToken string `protobuf:"bytes,4,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// Client-specific data used to resume batch upload if an error occurs and
	// retry is needed. This serves a role closely related to resume_token, as
	// both fields may be used to provide state required to restore a Batch
	// Upload, but they differ in two important aspects:
	//  - it is not compared to previous values, and as such does not provide
	//    concurrency control;
	//  - it allows for a larger payload, since the contents are never
	//    inspected/compared;
	// The size of the message must be within 1 MiB. Too large requests will be
	// rejected.
	UploaderState []byte `protobuf:"bytes,6,opt,name=uploader_state,json=uploaderState,proto3" json:"uploader_state,omitempty"`
	// The individual upload requests for this batch.
	// The recommend total size for a batch is 10 MiB. Too large requests may be
	// rejected.
	// This field may be empty, allowing this RPC to be used like TouchInvocation.
	UploadRequests       []*UploadRequest `protobuf:"bytes,5,rep,name=upload_requests,json=uploadRequests,proto3" json:"upload_requests,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *UploadBatchRequest) Reset()         { *m = UploadBatchRequest{} }
func (m *UploadBatchRequest) String() string { return proto.CompactTextString(m) }
func (*UploadBatchRequest) ProtoMessage()    {}
func (*UploadBatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{26}
}

func (m *UploadBatchRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UploadBatchRequest.Unmarshal(m, b)
}
func (m *UploadBatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UploadBatchRequest.Marshal(b, m, deterministic)
}
func (m *UploadBatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UploadBatchRequest.Merge(m, src)
}
func (m *UploadBatchRequest) XXX_Size() int {
	return xxx_messageInfo_UploadBatchRequest.Size(m)
}
func (m *UploadBatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UploadBatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UploadBatchRequest proto.InternalMessageInfo

func (m *UploadBatchRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *UploadBatchRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *UploadBatchRequest) GetNextResumeToken() string {
	if m != nil {
		return m.NextResumeToken
	}
	return ""
}

func (m *UploadBatchRequest) GetResumeToken() string {
	if m != nil {
		return m.ResumeToken
	}
	return ""
}

func (m *UploadBatchRequest) GetUploaderState() []byte {
	if m != nil {
		return m.UploaderState
	}
	return nil
}

func (m *UploadBatchRequest) GetUploadRequests() []*UploadRequest {
	if m != nil {
		return m.UploadRequests
	}
	return nil
}

// Response for UploadBatch
type UploadBatchResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UploadBatchResponse) Reset()         { *m = UploadBatchResponse{} }
func (m *UploadBatchResponse) String() string { return proto.CompactTextString(m) }
func (*UploadBatchResponse) ProtoMessage()    {}
func (*UploadBatchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{27}
}

func (m *UploadBatchResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UploadBatchResponse.Unmarshal(m, b)
}
func (m *UploadBatchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UploadBatchResponse.Marshal(b, m, deterministic)
}
func (m *UploadBatchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UploadBatchResponse.Merge(m, src)
}
func (m *UploadBatchResponse) XXX_Size() int {
	return xxx_messageInfo_UploadBatchResponse.Size(m)
}
func (m *UploadBatchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UploadBatchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UploadBatchResponse proto.InternalMessageInfo

// The individual upload requests for this batch.
type UploadRequest struct {
	// The resource ID components that identify the resource being uploaded.
	Id *UploadRequest_Id `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The operation for the request (e.g. Create(), Update(), etc.)
	UploadOperation UploadRequest_UploadOperation `protobuf:"varint,2,opt,name=upload_operation,json=uploadOperation,proto3,enum=google.devtools.resultstore.v2.UploadRequest_UploadOperation" json:"upload_operation,omitempty"`
	// Required for Update and Merge operations.
	// Ignored for Create and Finalize operations.
	// Masks the fields of the resource being uploaded. Provides support for a
	// more granular upload.
	// FieldMask must match one of the follow patterns, where * means any single
	// field name:
	// Invocation: [*, status_attributes.*, timing.*, invocation_attributes.*,
	// workspace_info.*].
	// Target: [*, status_attributes.*, timing.*].
	// Configuration: [*, status_attributes.*].
	// ConfiguredTarget: [*, status_attributes.*].
	// Action: [*, status_attributes.*, timing.*, test_action.test_suite,
	// test_action.infrastructure_failure_info].
	// FileSet: [*].
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If true then the Update, Merge operation will become a Create operation if
	// the resource is NOT_FOUND. Not supported for Invocation resource.
	CreateIfNotFound bool `protobuf:"varint,10,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	// The proto of the resource being uploaded.
	//
	// Types that are valid to be assigned to Resource:
	//	*UploadRequest_Invocation
	//	*UploadRequest_Target
	//	*UploadRequest_Configuration
	//	*UploadRequest_ConfiguredTarget
	//	*UploadRequest_Action
	//	*UploadRequest_FileSet
	Resource             isUploadRequest_Resource `protobuf_oneof:"resource"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *UploadRequest) Reset()         { *m = UploadRequest{} }
func (m *UploadRequest) String() string { return proto.CompactTextString(m) }
func (*UploadRequest) ProtoMessage()    {}
func (*UploadRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{28}
}

func (m *UploadRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UploadRequest.Unmarshal(m, b)
}
func (m *UploadRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UploadRequest.Marshal(b, m, deterministic)
}
func (m *UploadRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UploadRequest.Merge(m, src)
}
func (m *UploadRequest) XXX_Size() int {
	return xxx_messageInfo_UploadRequest.Size(m)
}
func (m *UploadRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UploadRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UploadRequest proto.InternalMessageInfo

func (m *UploadRequest) GetId() *UploadRequest_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *UploadRequest) GetUploadOperation() UploadRequest_UploadOperation {
	if m != nil {
		return m.UploadOperation
	}
	return UploadRequest_UPLOAD_OPERATION_UNSPECIFIED
}

func (m *UploadRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UploadRequest) GetCreateIfNotFound() bool {
	if m != nil {
		return m.CreateIfNotFound
	}
	return false
}

type isUploadRequest_Resource interface {
	isUploadRequest_Resource()
}

type UploadRequest_Invocation struct {
	Invocation *Invocation `protobuf:"bytes,4,opt,name=invocation,proto3,oneof"`
}

type UploadRequest_Target struct {
	Target *Target `protobuf:"bytes,5,opt,name=target,proto3,oneof"`
}

type UploadRequest_Configuration struct {
	Configuration *Configuration `protobuf:"bytes,6,opt,name=configuration,proto3,oneof"`
}

type UploadRequest_ConfiguredTarget struct {
	ConfiguredTarget *ConfiguredTarget `protobuf:"bytes,7,opt,name=configured_target,json=configuredTarget,proto3,oneof"`
}

type UploadRequest_Action struct {
	Action *Action `protobuf:"bytes,8,opt,name=action,proto3,oneof"`
}

type UploadRequest_FileSet struct {
	FileSet *FileSet `protobuf:"bytes,9,opt,name=file_set,json=fileSet,proto3,oneof"`
}

func (*UploadRequest_Invocation) isUploadRequest_Resource() {}

func (*UploadRequest_Target) isUploadRequest_Resource() {}

func (*UploadRequest_Configuration) isUploadRequest_Resource() {}

func (*UploadRequest_ConfiguredTarget) isUploadRequest_Resource() {}

func (*UploadRequest_Action) isUploadRequest_Resource() {}

func (*UploadRequest_FileSet) isUploadRequest_Resource() {}

func (m *UploadRequest) GetResource() isUploadRequest_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *UploadRequest) GetInvocation() *Invocation {
	if x, ok := m.GetResource().(*UploadRequest_Invocation); ok {
		return x.Invocation
	}
	return nil
}

func (m *UploadRequest) GetTarget() *Target {
	if x, ok := m.GetResource().(*UploadRequest_Target); ok {
		return x.Target
	}
	return nil
}

func (m *UploadRequest) GetConfiguration() *Configuration {
	if x, ok := m.GetResource().(*UploadRequest_Configuration); ok {
		return x.Configuration
	}
	return nil
}

func (m *UploadRequest) GetConfiguredTarget() *ConfiguredTarget {
	if x, ok := m.GetResource().(*UploadRequest_ConfiguredTarget); ok {
		return x.ConfiguredTarget
	}
	return nil
}

func (m *UploadRequest) GetAction() *Action {
	if x, ok := m.GetResource().(*UploadRequest_Action); ok {
		return x.Action
	}
	return nil
}

func (m *UploadRequest) GetFileSet() *FileSet {
	if x, ok := m.GetResource().(*UploadRequest_FileSet); ok {
		return x.FileSet
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*UploadRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*UploadRequest_Invocation)(nil),
		(*UploadRequest_Target)(nil),
		(*UploadRequest_Configuration)(nil),
		(*UploadRequest_ConfiguredTarget)(nil),
		(*UploadRequest_Action)(nil),
		(*UploadRequest_FileSet)(nil),
	}
}

// The resource ID components that identify the resource being uploaded.
type UploadRequest_Id struct {
	// Required for Target, ConfiguredTarget, or Action.
	// The Target ID.
	TargetId string `protobuf:"bytes,1,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Required for Configuration, ConfiguredTarget, or Action.
	// The Configuration ID.
	ConfigurationId string `protobuf:"bytes,2,opt,name=configuration_id,json=configurationId,proto3" json:"configuration_id,omitempty"`
	// Required for Action.
	// The Action ID.
	ActionId string `protobuf:"bytes,3,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// Required for FileSet.
	// The FileSet ID.
	FileSetId            string   `protobuf:"bytes,4,opt,name=file_set_id,json=fileSetId,proto3" json:"file_set_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UploadRequest_Id) Reset()         { *m = UploadRequest_Id{} }
func (m *UploadRequest_Id) String() string { return proto.CompactTextString(m) }
func (*UploadRequest_Id) ProtoMessage()    {}
func (*UploadRequest_Id) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{28, 0}
}

func (m *UploadRequest_Id) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UploadRequest_Id.Unmarshal(m, b)
}
func (m *UploadRequest_Id) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UploadRequest_Id.Marshal(b, m, deterministic)
}
func (m *UploadRequest_Id) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UploadRequest_Id.Merge(m, src)
}
func (m *UploadRequest_Id) XXX_Size() int {
	return xxx_messageInfo_UploadRequest_Id.Size(m)
}
func (m *UploadRequest_Id) XXX_DiscardUnknown() {
	xxx_messageInfo_UploadRequest_Id.DiscardUnknown(m)
}

var xxx_messageInfo_UploadRequest_Id proto.InternalMessageInfo

func (m *UploadRequest_Id) GetTargetId() string {
	if m != nil {
		return m.TargetId
	}
	return ""
}

func (m *UploadRequest_Id) GetConfigurationId() string {
	if m != nil {
		return m.ConfigurationId
	}
	return ""
}

func (m *UploadRequest_Id) GetActionId() string {
	if m != nil {
		return m.ActionId
	}
	return ""
}

func (m *UploadRequest_Id) GetFileSetId() string {
	if m != nil {
		return m.FileSetId
	}
	return ""
}

// Request passed into GetInvocationUploadMetadata
type GetInvocationUploadMetadataRequest struct {
	// Required
	// The name of the UploadMetadata being requested.
	// The name format must be: invocations/${INVOCATION_ID}/uploadMetadata
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. A UUID that must match the value provided in CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,2,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInvocationUploadMetadataRequest) Reset()         { *m = GetInvocationUploadMetadataRequest{} }
func (m *GetInvocationUploadMetadataRequest) String() string { return proto.CompactTextString(m) }
func (*GetInvocationUploadMetadataRequest) ProtoMessage()    {}
func (*GetInvocationUploadMetadataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{29}
}

func (m *GetInvocationUploadMetadataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInvocationUploadMetadataRequest.Unmarshal(m, b)
}
func (m *GetInvocationUploadMetadataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInvocationUploadMetadataRequest.Marshal(b, m, deterministic)
}
func (m *GetInvocationUploadMetadataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInvocationUploadMetadataRequest.Merge(m, src)
}
func (m *GetInvocationUploadMetadataRequest) XXX_Size() int {
	return xxx_messageInfo_GetInvocationUploadMetadataRequest.Size(m)
}
func (m *GetInvocationUploadMetadataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInvocationUploadMetadataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInvocationUploadMetadataRequest proto.InternalMessageInfo

func (m *GetInvocationUploadMetadataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetInvocationUploadMetadataRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.devtools.resultstore.v2.UploadRequest_UploadOperation", UploadRequest_UploadOperation_name, UploadRequest_UploadOperation_value)
	proto.RegisterType((*CreateInvocationRequest)(nil), "google.devtools.resultstore.v2.CreateInvocationRequest")
	proto.RegisterType((*UpdateInvocationRequest)(nil), "google.devtools.resultstore.v2.UpdateInvocationRequest")
	proto.RegisterType((*MergeInvocationRequest)(nil), "google.devtools.resultstore.v2.MergeInvocationRequest")
	proto.RegisterType((*TouchInvocationRequest)(nil), "google.devtools.resultstore.v2.TouchInvocationRequest")
	proto.RegisterType((*TouchInvocationResponse)(nil), "google.devtools.resultstore.v2.TouchInvocationResponse")
	proto.RegisterType((*DeleteInvocationRequest)(nil), "google.devtools.resultstore.v2.DeleteInvocationRequest")
	proto.RegisterType((*FinalizeInvocationRequest)(nil), "google.devtools.resultstore.v2.FinalizeInvocationRequest")
	proto.RegisterType((*FinalizeInvocationResponse)(nil), "google.devtools.resultstore.v2.FinalizeInvocationResponse")
	proto.RegisterType((*CreateTargetRequest)(nil), "google.devtools.resultstore.v2.CreateTargetRequest")
	proto.RegisterType((*UpdateTargetRequest)(nil), "google.devtools.resultstore.v2.UpdateTargetRequest")
	proto.RegisterType((*MergeTargetRequest)(nil), "google.devtools.resultstore.v2.MergeTargetRequest")
	proto.RegisterType((*FinalizeTargetRequest)(nil), "google.devtools.resultstore.v2.FinalizeTargetRequest")
	proto.RegisterType((*FinalizeTargetResponse)(nil), "google.devtools.resultstore.v2.FinalizeTargetResponse")
	proto.RegisterType((*CreateConfiguredTargetRequest)(nil), "google.devtools.resultstore.v2.CreateConfiguredTargetRequest")
	proto.RegisterType((*UpdateConfiguredTargetRequest)(nil), "google.devtools.resultstore.v2.UpdateConfiguredTargetRequest")
	proto.RegisterType((*MergeConfiguredTargetRequest)(nil), "google.devtools.resultstore.v2.MergeConfiguredTargetRequest")
	proto.RegisterType((*FinalizeConfiguredTargetRequest)(nil), "google.devtools.resultstore.v2.FinalizeConfiguredTargetRequest")
	proto.RegisterType((*FinalizeConfiguredTargetResponse)(nil), "google.devtools.resultstore.v2.FinalizeConfiguredTargetResponse")
	proto.RegisterType((*CreateActionRequest)(nil), "google.devtools.resultstore.v2.CreateActionRequest")
	proto.RegisterType((*UpdateActionRequest)(nil), "google.devtools.resultstore.v2.UpdateActionRequest")
	proto.RegisterType((*MergeActionRequest)(nil), "google.devtools.resultstore.v2.MergeActionRequest")
	proto.RegisterType((*CreateConfigurationRequest)(nil), "google.devtools.resultstore.v2.CreateConfigurationRequest")
	proto.RegisterType((*UpdateConfigurationRequest)(nil), "google.devtools.resultstore.v2.UpdateConfigurationRequest")
	proto.RegisterType((*CreateFileSetRequest)(nil), "google.devtools.resultstore.v2.CreateFileSetRequest")
	proto.RegisterType((*UpdateFileSetRequest)(nil), "google.devtools.resultstore.v2.UpdateFileSetRequest")
	proto.RegisterType((*MergeFileSetRequest)(nil), "google.devtools.resultstore.v2.MergeFileSetRequest")
	proto.RegisterType((*UploadBatchRequest)(nil), "google.devtools.resultstore.v2.UploadBatchRequest")
	proto.RegisterType((*UploadBatchResponse)(nil), "google.devtools.resultstore.v2.UploadBatchResponse")
	proto.RegisterType((*UploadRequest)(nil), "google.devtools.resultstore.v2.UploadRequest")
	proto.RegisterType((*UploadRequest_Id)(nil), "google.devtools.resultstore.v2.UploadRequest.Id")
	proto.RegisterType((*GetInvocationUploadMetadataRequest)(nil), "google.devtools.resultstore.v2.GetInvocationUploadMetadataRequest")
}

func init() {
	proto.RegisterFile("google/devtools/resultstore/v2/resultstore_upload.proto", fileDescriptor_3c379de3a2f884aa)
}

var fileDescriptor_3c379de3a2f884aa = []byte{
	// 2245 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x5a, 0x4f, 0x6c, 0xe4, 0x56,
	0x19, 0xcf, 0x9b, 0x49, 0xb2, 0xc9, 0x97, 0xa4, 0x99, 0x7d, 0xd9, 0x4d, 0x82, 0xf7, 0x4f, 0x53,
	0x47, 0x74, 0x37, 0xe9, 0x66, 0xbc, 0x4c, 0xb6, 0x09, 0x3b, 0x25, 0x6d, 0xfe, 0x4d, 0x36, 0xb3,
	0x6c, 0xb2, 0xe9, 0x24, 0xe1, 0x4f, 0xc5, 0x6a, 0xf0, 0x8e, 0xdf, 0x4c, 0xac, 0x9d, 0xb1, 0xa7,
	0x63, 0xcf, 0x2e, 0x6d, 0xd5, 0x0b, 0x88, 0x03, 0x17, 0x84, 0x84, 0x38, 0x81, 0xc4, 0xa9, 0x1c,
	0x58, 0x81, 0xb8, 0xa1, 0x0a, 0x71, 0x01, 0x2e, 0x70, 0xa4, 0x37, 0xc4, 0xa9, 0xe2, 0xc2, 0x05,
	0x09, 0xa4, 0xc2, 0x09, 0x09, 0xf9, 0xbd, 0x67, 0x8f, 0xed, 0xb1, 0xc7, 0xf6, 0xec, 0x80, 0xda,
	0x72, 0xb3, 0x9f, 0xdf, 0xf7, 0xde, 0xef, 0xfb, 0xff, 0xde, 0xf7, 0x19, 0xd6, 0x6b, 0xba, 0x5e,
	0xab, 0x13, 0x49, 0x21, 0x8f, 0x4d, 0x5d, 0xaf, 0x1b, 0x52, 0x8b, 0x18, 0xed, 0xba, 0x69, 0x98,
	0x7a, 0x8b, 0x48, 0x8f, 0x73, 0xee, 0xd7, 0x72, 0xbb, 0x59, 0xd7, 0x65, 0x25, 0xdb, 0x6c, 0xe9,
	0xa6, 0x8e, 0xaf, 0x32, 0xc2, 0xac, 0x4d, 0x98, 0x75, 0xcd, 0xcc, 0x3e, 0xce, 0x09, 0x97, 0xf9,
	0xc2, 0x72, 0x53, 0x95, 0x64, 0x4d, 0xd3, 0x4d, 0xd9, 0x54, 0x75, 0xcd, 0x60, 0xd4, 0xc2, 0x4b,
	0x11, 0xdb, 0xca, 0x15, 0x6b, 0x36, 0x9f, 0x9c, 0x8b, 0x98, 0x5c, 0xd1, 0xb5, 0xaa, 0x5a, 0x6b,
	0xb7, 0x64, 0x17, 0xcd, 0x5a, 0x4c, 0x1a, 0xa2, 0x94, 0x4d, 0xb9, 0x55, 0x23, 0x26, 0xa7, 0x5b,
	0x89, 0xa0, 0xab, 0xaa, 0x75, 0x52, 0x36, 0x9c, 0xe9, 0x52, 0xc4, 0x74, 0x55, 0x7b, 0xac, 0x57,
	0xdc, 0xb8, 0xa2, 0x18, 0xf7, 0x80, 0xb9, 0x15, 0x31, 0x99, 0x29, 0xa4, 0xdc, 0x20, 0xa6, 0xac,
	0xc8, 0xa6, 0xcc, 0xa9, 0x2e, 0x71, 0x2a, 0xfa, 0xf6, 0xb0, 0x5d, 0x95, 0x48, 0xa3, 0x69, 0xbe,
	0xc5, 0x3f, 0x2e, 0xf8, 0x3f, 0x56, 0x55, 0x52, 0x57, 0xca, 0x0d, 0xd9, 0x78, 0xc4, 0x67, 0x3c,
	0xef, 0x9f, 0x61, 0xaa, 0x0d, 0x62, 0x98, 0x72, 0xa3, 0xc9, 0x27, 0xcc, 0xb9, 0x34, 0x5b, 0xa9,
	0xab, 0x44, 0xe3, 0x70, 0xc5, 0x7f, 0xa7, 0x60, 0x6e, 0xa7, 0x45, 0x64, 0x93, 0x14, 0x1d, 0xb6,
	0x4b, 0xe4, 0xcd, 0x36, 0x31, 0x4c, 0x7c, 0x05, 0xa0, 0xc5, 0x1e, 0xcb, 0xaa, 0x32, 0x8f, 0x16,
	0xd0, 0xf5, 0xf1, 0xd2, 0x38, 0x1f, 0x29, 0x2a, 0x78, 0x11, 0xa6, 0x3a, 0xa2, 0xb2, 0x66, 0xa4,
	0xe8, 0x8c, 0xc9, 0xce, 0x60, 0x51, 0xc1, 0x77, 0x01, 0x3a, 0xef, 0xf3, 0xe9, 0x05, 0x74, 0x7d,
	0x22, 0xb7, 0x9c, 0xed, 0x6d, 0x87, 0x59, 0x17, 0x14, 0x17, 0x35, 0x96, 0x60, 0x46, 0x6e, 0x9b,
	0x67, 0x7a, 0x4b, 0x7d, 0x9b, 0xed, 0x69, 0xea, 0x8f, 0x88, 0x36, 0x3f, 0x4c, 0xb7, 0xc5, 0x9e,
	0x4f, 0x27, 0xd6, 0x17, 0xbc, 0x0f, 0xd6, 0xa8, 0x5e, 0xae, 0xaa, 0x9a, 0x5c, 0x57, 0xdf, 0x26,
	0x65, 0x4b, 0x2c, 0xf3, 0xa3, 0x14, 0x84, 0x60, 0x83, 0xb0, 0x65, 0x96, 0x3d, 0xb1, 0x65, 0x56,
	0xca, 0x58, 0x54, 0x7b, 0x9c, 0xc8, 0x1a, 0xc6, 0x37, 0xe1, 0x82, 0xaa, 0xa9, 0xa6, 0x2a, 0xd7,
	0xcb, 0x16, 0xd6, 0x06, 0xe1, 0x7b, 0x9f, 0x63, 0x7b, 0xf3, 0x6f, 0x25, 0xfa, 0x89, 0xed, 0xfd,
	0x59, 0x78, 0x8e, 0xa9, 0x9a, 0xb4, 0xca, 0x86, 0x29, 0x9b, 0x64, 0x7e, 0x6c, 0x01, 0x5d, 0x9f,
	0x2c, 0x4d, 0xd9, 0xa3, 0xc7, 0xd6, 0xa0, 0xf8, 0x01, 0x82, 0xb9, 0xd3, 0xa6, 0x12, 0x28, 0xff,
	0x41, 0xca, 0xee, 0x15, 0x98, 0x68, 0xd3, 0x6d, 0xa8, 0xd9, 0x50, 0x99, 0x05, 0xc9, 0x60, 0xcf,
	0xb2, 0xac, 0x03, 0xd9, 0x78, 0x54, 0x02, 0x36, 0xdd, 0x7a, 0x0e, 0x13, 0xfc, 0x48, 0x98, 0xe0,
	0xc5, 0xbf, 0x23, 0x98, 0x3d, 0x20, 0xad, 0x5a, 0x72, 0xa3, 0xfa, 0xe4, 0xf2, 0xfc, 0x00, 0x66,
	0x4f, 0xf4, 0x76, 0xe5, 0xac, 0x9b, 0x65, 0x0c, 0xc3, 0x9a, 0xdc, 0x20, 0x9c, 0x59, 0xfa, 0x1c,
	0xb6, 0x7c, 0x2a, 0x74, 0xf9, 0x3a, 0xcc, 0x75, 0x2d, 0x6f, 0x34, 0x75, 0xcd, 0x20, 0x81, 0xeb,
	0x6f, 0x40, 0x8a, 0x7b, 0xe4, 0x44, 0x6e, 0x25, 0xbe, 0xfc, 0xb2, 0x45, 0xa5, 0x94, 0x52, 0x15,
	0x71, 0x05, 0xe6, 0x76, 0x49, 0x9d, 0x04, 0x59, 0x65, 0xc0, 0x6e, 0xe2, 0xd7, 0xe1, 0x33, 0xb6,
	0xbb, 0x3c, 0x13, 0xfb, 0xe9, 0x50, 0xf6, 0x75, 0x10, 0x82, 0x76, 0xf8, 0xef, 0x49, 0xe0, 0x4f,
	0x08, 0x66, 0x58, 0x60, 0x3c, 0xa1, 0xe1, 0x3d, 0xa6, 0xfd, 0xce, 0xc2, 0x68, 0x53, 0x6e, 0x11,
	0xcd, 0xe4, 0xaa, 0xe4, 0x6f, 0xf8, 0x12, 0x8c, 0xb3, 0x34, 0x61, 0x51, 0x31, 0x36, 0xc7, 0xd8,
	0x40, 0x51, 0xc1, 0xaf, 0xc2, 0x28, 0x7b, 0xe6, 0x36, 0xfa, 0x62, 0x14, 0x5c, 0x0e, 0x89, 0x53,
	0x25, 0xb7, 0xd5, 0x7f, 0x20, 0x98, 0x61, 0x51, 0xc7, 0xcb, 0x5c, 0x07, 0x48, 0xba, 0x2f, 0x20,
	0xff, 0x53, 0x8f, 0xc3, 0x2b, 0x30, 0x53, 0xa1, 0x1a, 0x2a, 0xab, 0xd5, 0xb2, 0xa6, 0x9b, 0xe5,
	0xaa, 0xde, 0xd6, 0x14, 0x1a, 0xdf, 0xc7, 0x4a, 0x19, 0xf6, 0xa9, 0x58, 0x3d, 0xd4, 0xcd, 0x3d,
	0x6b, 0x5c, 0xfc, 0x5e, 0x0a, 0x30, 0x0d, 0x4a, 0x89, 0x14, 0xfa, 0xa9, 0x16, 0xc9, 0xd7, 0xe0,
	0xa2, 0x93, 0xe6, 0x3c, 0x42, 0x19, 0x88, 0xcf, 0xd6, 0x60, 0xd6, 0xbf, 0x7a, 0x0f, 0x7f, 0xbd,
	0xed, 0xf2, 0xd7, 0xa5, 0x78, 0x42, 0xb6, 0x7d, 0xf5, 0x5b, 0x29, 0xb8, 0xc2, 0x7c, 0x75, 0xc7,
	0x39, 0x22, 0x0e, 0xca, 0x6b, 0xd9, 0xa1, 0xd3, 0xe5, 0xb5, 0x6c, 0xa0, 0xa8, 0xe0, 0x07, 0x70,
	0xbe, 0xeb, 0x44, 0xca, 0xf5, 0x7b, 0x33, 0x0a, 0x7f, 0x17, 0xce, 0x4c, 0xc5, 0x37, 0x92, 0xdc,
	0xa9, 0x7f, 0x98, 0x82, 0x2b, 0xcc, 0xa9, 0xc3, 0xa4, 0x10, 0x88, 0x38, 0x3d, 0x30, 0xc4, 0x1f,
	0x6b, 0x53, 0x7f, 0x3f, 0x05, 0x97, 0xa9, 0xf7, 0xf7, 0x69, 0x22, 0xff, 0xcf, 0xb2, 0xab, 0xc2,
	0xf3, 0xb6, 0x23, 0x87, 0x49, 0x6f, 0x20, 0x01, 0xe3, 0x1d, 0x58, 0x08, 0xdf, 0xa7, 0x47, 0xe8,
	0xd8, 0x71, 0x85, 0x8e, 0xd5, 0xa4, 0xca, 0xe8, 0x4e, 0xf8, 0x5b, 0x95, 0x04, 0x07, 0xd6, 0x1e,
	0xa1, 0x83, 0x5d, 0x88, 0x5d, 0xa1, 0x83, 0x0d, 0xb0, 0xa4, 0xc2, 0x9e, 0xe3, 0x26, 0x7c, 0x0e,
	0x89, 0x53, 0x3d, 0x4b, 0xc2, 0xf7, 0x32, 0xd7, 0x01, 0x92, 0xee, 0x0b, 0xc8, 0x27, 0x23, 0xe1,
	0x27, 0x52, 0xe8, 0xa7, 0x5a, 0x24, 0xff, 0x44, 0x20, 0x78, 0x33, 0xa5, 0x3c, 0x18, 0x5b, 0x0f,
	0x4f, 0x93, 0xc7, 0x30, 0xe5, 0x29, 0xf6, 0x70, 0x89, 0xac, 0xc4, 0xf5, 0x53, 0x06, 0xd0, 0xbb,
	0x46, 0x72, 0x07, 0xf8, 0x6e, 0x0a, 0x04, 0x6f, 0x72, 0xf4, 0x30, 0xde, 0x05, 0x32, 0x3d, 0x00,
	0x90, 0x1f, 0x6b, 0x4b, 0xf8, 0x10, 0xc1, 0x05, 0x66, 0x09, 0x7b, 0x6a, 0x9d, 0x1c, 0x3f, 0xf3,
	0x51, 0xe9, 0x2a, 0x4c, 0xd8, 0x75, 0xb6, 0x8e, 0x15, 0x8c, 0x57, 0xd9, 0xda, 0x45, 0x05, 0x6f,
	0xc3, 0x98, 0xfd, 0x9d, 0x4b, 0xe2, 0x5a, 0x94, 0x70, 0x6d, 0x60, 0xe7, 0xf8, 0x2a, 0xc9, 0xb5,
	0xfe, 0x2f, 0x04, 0x17, 0x98, 0xd6, 0x7d, 0x4c, 0xba, 0xd1, 0xa0, 0x3e, 0xd1, 0xf8, 0xd4, 0x9b,
	0x1a, 0x84, 0x7a, 0xd3, 0x49, 0xd5, 0x3b, 0x1c, 0xa2, 0xde, 0x1f, 0xa4, 0x60, 0x86, 0xc6, 0xbe,
	0x64, 0xda, 0x75, 0xcb, 0x25, 0x35, 0x18, 0xb9, 0xa4, 0x07, 0x21, 0x97, 0xe1, 0xa4, 0x72, 0x19,
	0x09, 0x91, 0xcb, 0xd3, 0x14, 0xe0, 0x53, 0x5a, 0x81, 0xdb, 0x96, 0xcd, 0xca, 0x99, 0x2d, 0x96,
	0x8e, 0x55, 0x23, 0x8f, 0x55, 0x27, 0x2d, 0xd3, 0xe0, 0x65, 0x38, 0xaf, 0x91, 0x6f, 0x98, 0xde,
	0x2a, 0x21, 0xd3, 0xea, 0xb4, 0xf5, 0xc1, 0x5d, 0x22, 0x7c, 0x01, 0x26, 0x3d, 0xd3, 0x18, 0x93,
	0x13, 0xad, 0x9e, 0x55, 0xc4, 0xd1, 0x80, 0x2a, 0x22, 0xfe, 0x12, 0x4c, 0xf3, 0xba, 0x32, 0x57,
	0xa5, 0x31, 0x3f, 0xb2, 0x90, 0x8e, 0x13, 0xc0, 0x98, 0x2c, 0xb8, 0x18, 0x4a, 0x7c, 0x33, 0xfe,
	0x6a, 0x88, 0x17, 0xad, 0x53, 0x83, 0x4b, 0x58, 0xec, 0x0c, 0x26, 0x7e, 0x74, 0x0e, 0xa6, 0x3c,
	0x84, 0x78, 0x93, 0x9e, 0xc0, 0x50, 0xbc, 0xe3, 0xb0, 0x87, 0x94, 0x1f, 0xbf, 0xf0, 0x19, 0x64,
	0x38, 0x0b, 0x7a, 0x93, 0xf0, 0x20, 0x6c, 0x89, 0xf9, 0xb9, 0xdc, 0x46, 0xb2, 0xf5, 0xd8, 0xdb,
	0x7d, 0x7b, 0x91, 0x12, 0x97, 0x8c, 0x33, 0xf0, 0x6c, 0xf6, 0x19, 0x62, 0x6e, 0x10, 0x6c, 0x6e,
	0xf8, 0x9e, 0xa7, 0x9c, 0x39, 0x9c, 0xb4, 0x9c, 0xb9, 0x3f, 0xe4, 0x29, 0x68, 0x6e, 0x3a, 0xb5,
	0x88, 0x91, 0x24, 0xb5, 0x88, 0xfd, 0x21, 0xa7, 0x1a, 0x71, 0xea, 0xcf, 0x73, 0xa3, 0x7d, 0xe4,
	0xb9, 0xfd, 0x21, 0x7f, 0xa6, 0x2b, 0x07, 0x5d, 0x8e, 0xce, 0xf5, 0x77, 0x39, 0xda, 0x1f, 0x0a,
	0xb8, 0x1e, 0x6d, 0x3a, 0x87, 0xb2, 0xb1, 0x24, 0x87, 0x32, 0x8b, 0x73, 0x7e, 0x2c, 0xdb, 0x75,
	0x45, 0xb6, 0xf1, 0x44, 0x91, 0x6d, 0x7f, 0xc8, 0x89, 0x6d, 0xc2, 0x77, 0x10, 0xa4, 0x8a, 0x8a,
	0xb7, 0x9a, 0x87, 0x7c, 0xd5, 0xbc, 0x25, 0xc8, 0x78, 0xa4, 0xd3, 0x69, 0x8d, 0x4c, 0x7b, 0xc6,
	0xd9, 0x3a, 0xe1, 0x97, 0x04, 0x5f, 0x46, 0x1d, 0xf6, 0x65, 0x54, 0x51, 0x81, 0x69, 0x9f, 0xad,
	0xe3, 0x05, 0xb8, 0x7c, 0x7a, 0x74, 0xef, 0xfe, 0xd6, 0x6e, 0xf9, 0xfe, 0x51, 0xa1, 0xb4, 0x75,
	0x52, 0xbc, 0x7f, 0x58, 0x3e, 0x3d, 0x3c, 0x3e, 0x2a, 0xec, 0x14, 0xf7, 0x8a, 0x85, 0xdd, 0xcc,
	0x10, 0x06, 0x18, 0xdd, 0x29, 0x15, 0xb6, 0x4e, 0x0a, 0x19, 0x64, 0x3d, 0x9f, 0x1e, 0xed, 0x5a,
	0xcf, 0x29, 0x3c, 0x0e, 0x23, 0x07, 0x85, 0xd2, 0x9d, 0x42, 0x26, 0x8d, 0x27, 0x61, 0x6c, 0xaf,
	0x78, 0xb8, 0x75, 0xaf, 0xf8, 0x46, 0x21, 0x33, 0xbc, 0x0d, 0x30, 0xd6, 0x22, 0x86, 0xde, 0x6e,
	0x55, 0x88, 0xa8, 0x82, 0x78, 0x87, 0x98, 0x1d, 0xf3, 0x64, 0xdb, 0x1f, 0xf0, 0x56, 0xd6, 0x20,
	0xcb, 0xdd, 0xb9, 0x8f, 0x16, 0xe1, 0x7c, 0x89, 0xaa, 0xe3, 0xd8, 0x52, 0x07, 0xdb, 0x09, 0xff,
	0x08, 0x41, 0xc6, 0xdf, 0xad, 0xc2, 0xeb, 0x91, 0x16, 0x16, 0xdc, 0xdf, 0x12, 0x12, 0x38, 0xa2,
	0xb8, 0xf8, 0xcd, 0x0f, 0xfe, 0xf2, 0xfd, 0xd4, 0x15, 0x71, 0xda, 0xdb, 0x21, 0x34, 0xf2, 0x6e,
	0xff, 0xfc, 0x05, 0x82, 0x8c, 0xbf, 0x99, 0x13, 0x0d, 0x2f, 0xa4, 0xfd, 0x93, 0x08, 0xde, 0x3a,
	0x85, 0xf7, 0xb9, 0xdc, 0xa2, 0x05, 0xef, 0x1d, 0x57, 0x07, 0xd3, 0x92, 0xfe, 0x86, 0x0b, 0xaf,
	0xb4, 0xfc, 0xae, 0x07, 0xf2, 0x53, 0x04, 0xd3, 0xbe, 0x4e, 0x0d, 0x5e, 0x8b, 0xda, 0x38, 0xb8,
	0xb5, 0x93, 0x08, 0xf0, 0x2d, 0x0a, 0x38, 0x2b, 0x2e, 0xc5, 0x01, 0xdc, 0xb0, 0xf6, 0xcb, 0xa3,
	0x65, 0xfc, 0x33, 0x04, 0xd3, 0xbe, 0x2e, 0x48, 0x34, 0xda, 0xe0, 0xae, 0x8c, 0xb0, 0x9e, 0x98,
	0x8e, 0x67, 0xbf, 0x25, 0x0a, 0x7d, 0x51, 0xbc, 0x4a, 0xa1, 0x07, 0xe1, 0x35, 0x2d, 0x4a, 0x0b,
	0xef, 0xfb, 0x08, 0x70, 0x77, 0xdb, 0x02, 0xdf, 0x8e, 0x8e, 0x3c, 0x21, 0xcd, 0x14, 0x21, 0xdf,
	0x0f, 0x29, 0x07, 0x7e, 0x83, 0x02, 0x7f, 0x51, 0x7c, 0x21, 0x14, 0xb8, 0xdd, 0x28, 0xb5, 0xb0,
	0x7f, 0x1b, 0x41, 0xc6, 0xdf, 0x03, 0x8a, 0x36, 0xe6, 0x90, 0xae, 0x91, 0x30, 0xdb, 0x95, 0x5f,
	0x0b, 0x8d, 0xa6, 0xf9, 0x96, 0xb8, 0x40, 0x31, 0x09, 0xcb, 0xf3, 0x61, 0x98, 0xf0, 0x8f, 0x11,
	0x4c, 0xba, 0x1b, 0x31, 0x78, 0x35, 0x9e, 0xbf, 0x7b, 0xea, 0x53, 0x42, 0xcc, 0x54, 0x29, 0xe6,
	0x28, 0x9e, 0x1b, 0xa2, 0x48, 0xf1, 0xb0, 0x53, 0xa0, 0x0f, 0x11, 0xef, 0xf7, 0x1b, 0x79, 0x3b,
	0xa9, 0xfe, 0x04, 0xc1, 0xa4, 0xbb, 0x9b, 0x12, 0x8d, 0x30, 0xa0, 0xf7, 0x12, 0x1b, 0xe1, 0x6d,
	0x8a, 0x70, 0x35, 0xc7, 0x3c, 0x87, 0xff, 0x7b, 0xd0, 0x2d, 0x38, 0x1b, 0xa5, 0xa5, 0x56, 0x1b,
	0xe8, 0x7b, 0x08, 0x26, 0x5c, 0x1d, 0x10, 0x9c, 0x8b, 0xe5, 0xe8, 0xfd, 0xc1, 0xcc, 0x53, 0x98,
	0xb7, 0x44, 0x29, 0x3e, 0x4c, 0xc7, 0xcd, 0x7f, 0x89, 0xe0, 0x39, 0x6f, 0xe7, 0x00, 0xbf, 0x1c,
	0xd7, 0xee, 0xbd, 0x68, 0xd7, 0x92, 0x92, 0x71, 0x57, 0x59, 0xa3, 0xe8, 0x6f, 0x8a, 0x2f, 0x85,
	0x98, 0xa5, 0x1b, 0xb6, 0xdb, 0x69, 0xfe, 0x8c, 0x60, 0x36, 0xb8, 0x13, 0x81, 0x37, 0xe2, 0x99,
	0x6d, 0x48, 0x81, 0x55, 0x48, 0x7c, 0x8e, 0x12, 0x5f, 0xa7, 0x3c, 0x7c, 0x51, 0x5c, 0x0b, 0x35,
	0x65, 0x17, 0x17, 0x92, 0xff, 0xc8, 0x65, 0xe4, 0xbb, 0x8f, 0x74, 0xf8, 0x6f, 0x08, 0x66, 0x83,
	0x5b, 0x0c, 0x78, 0x23, 0x9e, 0xcd, 0x0f, 0x8e, 0xbd, 0x0a, 0x65, 0xef, 0x41, 0x6e, 0x9f, 0xb2,
	0xd7, 0xfd, 0x6f, 0x50, 0x2f, 0xa5, 0x75, 0x73, 0x6b, 0x29, 0x32, 0x80, 0xe1, 0x0f, 0x11, 0x5c,
	0x0c, 0xec, 0x1a, 0xe0, 0x2f, 0xc4, 0xf2, 0x9d, 0xc1, 0xb1, 0xfb, 0x55, 0xca, 0xee, 0xb1, 0x78,
	0x38, 0x30, 0x76, 0x1d, 0x77, 0xfb, 0x2b, 0x82, 0xf9, 0xb0, 0xba, 0x3b, 0x7e, 0x2d, 0xae, 0x07,
	0x85, 0xb1, 0xba, 0xd9, 0xff, 0x02, 0xdc, 0x19, 0xef, 0x52, 0xd6, 0x77, 0xc5, 0xd7, 0x22, 0x9d,
	0x31, 0x98, 0x51, 0xb7, 0x83, 0xfe, 0xda, 0xc9, 0x26, 0xec, 0x86, 0x10, 0x37, 0x9b, 0x78, 0x4a,
	0xc8, 0x42, 0xcc, 0xeb, 0x87, 0x78, 0x44, 0x91, 0xdf, 0x15, 0x37, 0x63, 0xb8, 0x60, 0x20, 0x76,
	0xfe, 0x53, 0x9d, 0x91, 0xb7, 0xaf, 0x31, 0xbf, 0x73, 0x72, 0x4d, 0x5c, 0xfc, 0x01, 0x65, 0xff,
	0xd8, 0xf8, 0xbf, 0x4c, 0xf1, 0xbf, 0x9e, 0xbb, 0x43, 0xf1, 0xf3, 0x1f, 0xfc, 0x92, 0x2a, 0xc0,
	0xe6, 0x81, 0x66, 0x22, 0xce, 0xc6, 0x6f, 0xed, 0x4c, 0xc4, 0xb9, 0x88, 0x97, 0x89, 0xfa, 0x63,
	0xe2, 0x2b, 0x94, 0x89, 0x92, 0x78, 0x30, 0x28, 0x26, 0x1c, 0xc7, 0xf9, 0x95, 0xd3, 0x32, 0xf2,
	0xdc, 0x8f, 0x71, 0x3e, 0x59, 0xa8, 0xf7, 0x1c, 0x94, 0x92, 0x5d, 0xc5, 0xed, 0xd3, 0x40, 0xcf,
	0xf3, 0x0a, 0x63, 0xc7, 0xc8, 0xfb, 0x2e, 0xed, 0xbf, 0x77, 0x7a, 0x42, 0x09, 0xd1, 0x87, 0xd7,
	0xd1, 0x93, 0xa2, 0xbf, 0x43, 0xd1, 0x6f, 0xe5, 0x6e, 0x7a, 0x82, 0x5a, 0xd8, 0x45, 0xc0, 0x66,
	0xc4, 0xd2, 0x81, 0x8f, 0x97, 0xf7, 0x10, 0x4c, 0x79, 0xaa, 0xd9, 0xf8, 0x56, 0x3c, 0x1d, 0x78,
	0xcb, 0xa3, 0x42, 0xdc, 0x9a, 0x80, 0xf8, 0x32, 0x45, 0x2e, 0x89, 0x8b, 0x3d, 0xe4, 0xce, 0xaf,
	0xea, 0x46, 0xde, 0xa9, 0x3c, 0xe0, 0x9f, 0x23, 0x98, 0xf2, 0x14, 0xa4, 0xa3, 0x71, 0x06, 0xd5,
	0xaf, 0xe3, 0xe3, 0x7c, 0x95, 0xe2, 0xfc, 0x7c, 0xee, 0x06, 0xc5, 0xe9, 0xfc, 0x09, 0x1b, 0x20,
	0x5c, 0x1b, 0xad, 0x25, 0xdd, 0x0e, 0xe0, 0xa7, 0x08, 0x26, 0xdd, 0x75, 0xe4, 0xe8, 0x78, 0x13,
	0x50, 0x75, 0x8e, 0x0f, 0x77, 0x83, 0xc2, 0x5d, 0x17, 0x73, 0x89, 0xe0, 0x3a, 0x0e, 0xf9, 0x53,
	0x04, 0x13, 0xae, 0x82, 0x65, 0x74, 0x58, 0xe9, 0x2e, 0x05, 0x0b, 0xab, 0x89, 0x68, 0x78, 0x8a,
	0xb2, 0xaf, 0x0d, 0xd7, 0x7a, 0x98, 0xc3, 0x43, 0x8b, 0x22, 0xcf, 0xaa, 0x91, 0x16, 0xd8, 0xdf,
	0x20, 0xb8, 0xd4, 0xa3, 0x9c, 0x82, 0xb7, 0xa3, 0x80, 0x44, 0xd7, 0x62, 0x84, 0x6c, 0x3c, 0x66,
	0x6c, 0x32, 0x51, 0xa2, 0x7c, 0x2c, 0xe1, 0x6b, 0x61, 0xa9, 0xb6, 0xed, 0x99, 0xff, 0xae, 0x70,
	0xf8, 0x87, 0x2d, 0xc1, 0xbd, 0x24, 0xdb, 0x4e, 0x6e, 0xaa, 0x46, 0xb6, 0xa2, 0x37, 0xfe, 0xb8,
	0x95, 0x3d, 0x33, 0xcd, 0xa6, 0x91, 0x97, 0xa4, 0x27, 0x4f, 0x9e, 0xf8, 0x3e, 0x4a, 0x72, 0xdb,
	0x3c, 0x93, 0x2a, 0x75, 0xbd, 0xad, 0xac, 0x34, 0xeb, 0xb2, 0x59, 0xd5, 0x5b, 0x8d, 0xed, 0x37,
	0x41, 0xac, 0xe8, 0x8d, 0x08, 0xd4, 0x47, 0xe8, 0x8d, 0x22, 0x9f, 0x51, 0xd3, 0xeb, 0xb2, 0x56,
	0xcb, 0xea, 0xad, 0x9a, 0x54, 0x23, 0x1a, 0xbd, 0x5c, 0x4a, 0x9d, 0x6d, 0xc2, 0xfe, 0xc2, 0x7e,
	0xc5, 0xf5, 0xfa, 0x70, 0x94, 0x52, 0xad, 0xfe, 0x27, 0x00, 0x00, 0xff, 0xff, 0xf3, 0x0c, 0x10,
	0x4d, 0x57, 0x2f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ResultStoreUploadClient is the client API for ResultStoreUpload service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResultStoreUploadClient interface {
	// Creates the given invocation.
	//
	// This is not an implicitly idempotent API, so a request id is required to
	// make it idempotent.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If an invocation with the same ID already exists.
	CreateInvocation(ctx context.Context, in *CreateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error)
	// Applies a standard update to the invocation identified by the given proto's
	// name.  For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths.  Fields that match the mask but aren't populated in the given
	// invocation are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	// - If no field mask was given.
	UpdateInvocation(ctx context.Context, in *UpdateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error)
	// Applies a merge update to the invocation identified by the given proto's
	// name.  For primitive and message fields, replaces them with the ones in
	// the given proto if they are covered under the field mask paths.  For
	// repeated fields, merges to them with the given ones if they are covered
	// under the field mask paths. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	// - If no field mask was given.
	MergeInvocation(ctx context.Context, in *MergeInvocationRequest, opts ...grpc.CallOption) (*Invocation, error)
	// Touches the invocation identified by the given proto's name.
	//
	// This is useful when you need to notify ResultStore that you haven't
	// abandoned the upload, since abandoned uploads will be automatically
	// finalized after a set period.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	TouchInvocation(ctx context.Context, in *TouchInvocationRequest, opts ...grpc.CallOption) (*TouchInvocationResponse, error)
	// Declares the invocation with the given name as finalized and immutable by
	// the user. It may still be mutated by post-processing. This is an implicitly
	// idempotent API.
	//
	// If an Invocation is not updated for 24 hours, some time after that
	// this will be called automatically.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	FinalizeInvocation(ctx context.Context, in *FinalizeInvocationRequest, opts ...grpc.CallOption) (*FinalizeInvocationResponse, error)
	// Deletes an immutable invocation (permanently)
	// Note: this does not delete indirect data, e.g. files stored in other
	// services.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is not finalized.  This can be retried until it is.
	DeleteInvocation(ctx context.Context, in *DeleteInvocationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates the given target under the given parent invocation. The given
	// target ID is URL encoded, converted to the full resource name, and assigned
	// to the target's name field. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no target ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	// - If a target with the same name already exists.
	CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Applies a standard update to the target identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	// - If the target or parent invocation is finalized.
	// - If no field mask was given.
	UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Applies a merge update to the target identified by the given proto's
	// name. For primitive and message fields, replaces them with the ones in the
	// given proto if they are covered under the field mask paths.  For repeated
	// fields, merges to them with the given ones if they are covered under the
	// field mask paths. This is not an implicitly idempotent API, so a request
	// id is required to make it idempotent.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	// - If the target or parent invocation is finalized.
	// - If no field mask was given.
	MergeTarget(ctx context.Context, in *MergeTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Declares the target with the given name as finalized and immutable by the
	// user. It may still be mutated by post-processing. This is an implicitly
	// idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	FinalizeTarget(ctx context.Context, in *FinalizeTargetRequest, opts ...grpc.CallOption) (*FinalizeTargetResponse, error)
	// Creates the given configured target under the given parent target.
	// The given configured target ID is URL encoded, converted to the full
	// resource name, and assigned to the configured target's name field.
	// This is not an implicitly idempotent API, so a request id is required
	// to make it idempotent.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no config ID is provided.
	// - If a configured target with the same ID already exists.
	// - If the parent target does not exist.
	// - If the parent target or invocation is finalized.
	CreateConfiguredTarget(ctx context.Context, in *CreateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error)
	// Applies a standard update to the configured target identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths. Fields that match the mask but aren't populated in the
	// given configured target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	UpdateConfiguredTarget(ctx context.Context, in *UpdateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error)
	// Applies a merge update to the configured target identified by the given
	// proto's name. For primitive and message fields, replaces them with the
	// ones in the given proto if they are covered under the field mask paths.
	// For repeated fields, merges to them with the given ones if they are
	// covered under the field mask paths. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	MergeConfiguredTarget(ctx context.Context, in *MergeConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error)
	// Declares the configured target with the given name as finalized and
	// immutable by the user. It may still be mutated by post-processing. This is
	// an implicitly idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	FinalizeConfiguredTarget(ctx context.Context, in *FinalizeConfiguredTargetRequest, opts ...grpc.CallOption) (*FinalizeConfiguredTargetResponse, error)
	// Creates the given action under the given configured target. The given
	// action ID is URL encoded, converted to the full resource name, and
	// assigned to the action's name field. This is not an implicitly
	// idempotent API, so a request id is required to make it idempotent.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no action ID provided.
	// - If the parent configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If an action  with the same name already exists.
	CreateAction(ctx context.Context, in *CreateActionRequest, opts ...grpc.CallOption) (*Action, error)
	// Applies a standard update to the action identified by the given
	// proto's name.  For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths.  Fields that match the mask but aren't populated in the
	// given action are cleared.  This is an implicitly idempotent API.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the action does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	UpdateAction(ctx context.Context, in *UpdateActionRequest, opts ...grpc.CallOption) (*Action, error)
	// Applies a merge update to the action identified by the given
	// proto's name.  For primitive and message fields, replaces them with the
	// ones in the given proto if they are covered under the field mask paths.
	// For repeated fields, merges to them with the given ones if they are
	// covered under the field mask paths. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the action does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	MergeAction(ctx context.Context, in *MergeActionRequest, opts ...grpc.CallOption) (*Action, error)
	// Creates the given configuration under the given parent invocation. The
	// given configuration ID is URL encoded, converted to the full resource name,
	// and assigned to the configuration's name field. The configuration ID of
	// "default" should be preferred for the default configuration in a
	// single-config invocation. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no configuration ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	// - If a configuration with the same name already exists.
	CreateConfiguration(ctx context.Context, in *CreateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error)
	// Applies a standard update to the configuration identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given field
	// mask paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configuration does not exist.
	// - If the parent invocation is finalized.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateConfiguration(ctx context.Context, in *UpdateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error)
	// Creates the given file set under the given parent invocation. The given
	// file set ID is URL encoded, converted to the full resource name, and
	// assigned to the file set's name field. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no file set ID is provided.
	// - If a file set with the same name already exists.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	CreateFileSet(ctx context.Context, in *CreateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error)
	// Applies a standard update to the file set identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the file set does not exist.
	// - If the parent invocation is finalized.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateFileSet(ctx context.Context, in *UpdateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error)
	// Applies a merge update to the file set identified by the given proto's
	// name. For primitive and message fields, updates them with the ones in the
	// given proto if they are covered under the field mask paths. For repeated
	// fields, merges to them with the given ones if they are covered under the
	// field mask paths. This is not an implicitly idempotent API, so a request
	// id is required to make it idempotent.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the file set does not exist.
	// - If the parent invocation is finalized.
	// - If a given field mask path is not valid.
	// - If no field mask was given.
	MergeFileSet(ctx context.Context, in *MergeFileSetRequest, opts ...grpc.CallOption) (*FileSet, error)
	// This is the RPC used for batch upload. It supports uploading multiple
	// resources for an invocation in a transaction safe manner.
	//
	// To use this RPC, the CreateInvocationRequest must have been provided a
	// resume_token.
	//
	// Combining batch upload with normal upload on a single Invocation is not
	// supported. If an Invocation is created with a resume_token, all further
	// calls must be through UploadBatch. If an Invocation is created without
	// resume_token normal upload, all further upload calls must be through normal
	// upload RPCs.
	UploadBatch(ctx context.Context, in *UploadBatchRequest, opts ...grpc.CallOption) (*UploadBatchResponse, error)
	// Provides a way to read the metadata for an invocation.
	// The UploadMetadata could still be retrieved by this RPC even the Invocation
	// has been finalized.
	// This API requires setting a response FieldMask via 'fields' URL query
	// parameter or X-Goog-FieldMask HTTP/gRPC header.
	//
	// An error will be reported in the following case:
	// - If the invocation does not exist.
	// - If no field mask was given.
	GetInvocationUploadMetadata(ctx context.Context, in *GetInvocationUploadMetadataRequest, opts ...grpc.CallOption) (*UploadMetadata, error)
}

type resultStoreUploadClient struct {
	cc grpc.ClientConnInterface
}

func NewResultStoreUploadClient(cc grpc.ClientConnInterface) ResultStoreUploadClient {
	return &resultStoreUploadClient{cc}
}

func (c *resultStoreUploadClient) CreateInvocation(ctx context.Context, in *CreateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error) {
	out := new(Invocation)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateInvocation(ctx context.Context, in *UpdateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error) {
	out := new(Invocation)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) MergeInvocation(ctx context.Context, in *MergeInvocationRequest, opts ...grpc.CallOption) (*Invocation, error) {
	out := new(Invocation)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/MergeInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) TouchInvocation(ctx context.Context, in *TouchInvocationRequest, opts ...grpc.CallOption) (*TouchInvocationResponse, error) {
	out := new(TouchInvocationResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/TouchInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) FinalizeInvocation(ctx context.Context, in *FinalizeInvocationRequest, opts ...grpc.CallOption) (*FinalizeInvocationResponse, error) {
	out := new(FinalizeInvocationResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) DeleteInvocation(ctx context.Context, in *DeleteInvocationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/DeleteInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) MergeTarget(ctx context.Context, in *MergeTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/MergeTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) FinalizeTarget(ctx context.Context, in *FinalizeTargetRequest, opts ...grpc.CallOption) (*FinalizeTargetResponse, error) {
	out := new(FinalizeTargetResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateConfiguredTarget(ctx context.Context, in *CreateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error) {
	out := new(ConfiguredTarget)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateConfiguredTarget(ctx context.Context, in *UpdateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error) {
	out := new(ConfiguredTarget)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) MergeConfiguredTarget(ctx context.Context, in *MergeConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error) {
	out := new(ConfiguredTarget)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/MergeConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) FinalizeConfiguredTarget(ctx context.Context, in *FinalizeConfiguredTargetRequest, opts ...grpc.CallOption) (*FinalizeConfiguredTargetResponse, error) {
	out := new(FinalizeConfiguredTargetResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateAction(ctx context.Context, in *CreateActionRequest, opts ...grpc.CallOption) (*Action, error) {
	out := new(Action)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateAction(ctx context.Context, in *UpdateActionRequest, opts ...grpc.CallOption) (*Action, error) {
	out := new(Action)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) MergeAction(ctx context.Context, in *MergeActionRequest, opts ...grpc.CallOption) (*Action, error) {
	out := new(Action)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/MergeAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateConfiguration(ctx context.Context, in *CreateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error) {
	out := new(Configuration)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateConfiguration(ctx context.Context, in *UpdateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error) {
	out := new(Configuration)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateFileSet(ctx context.Context, in *CreateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error) {
	out := new(FileSet)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateFileSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateFileSet(ctx context.Context, in *UpdateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error) {
	out := new(FileSet)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateFileSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) MergeFileSet(ctx context.Context, in *MergeFileSetRequest, opts ...grpc.CallOption) (*FileSet, error) {
	out := new(FileSet)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/MergeFileSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UploadBatch(ctx context.Context, in *UploadBatchRequest, opts ...grpc.CallOption) (*UploadBatchResponse, error) {
	out := new(UploadBatchResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UploadBatch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) GetInvocationUploadMetadata(ctx context.Context, in *GetInvocationUploadMetadataRequest, opts ...grpc.CallOption) (*UploadMetadata, error) {
	out := new(UploadMetadata)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/GetInvocationUploadMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResultStoreUploadServer is the server API for ResultStoreUpload service.
type ResultStoreUploadServer interface {
	// Creates the given invocation.
	//
	// This is not an implicitly idempotent API, so a request id is required to
	// make it idempotent.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If an invocation with the same ID already exists.
	CreateInvocation(context.Context, *CreateInvocationRequest) (*Invocation, error)
	// Applies a standard update to the invocation identified by the given proto's
	// name.  For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths.  Fields that match the mask but aren't populated in the given
	// invocation are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	// - If no field mask was given.
	UpdateInvocation(context.Context, *UpdateInvocationRequest) (*Invocation, error)
	// Applies a merge update to the invocation identified by the given proto's
	// name.  For primitive and message fields, replaces them with the ones in
	// the given proto if they are covered under the field mask paths.  For
	// repeated fields, merges to them with the given ones if they are covered
	// under the field mask paths. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	// - If no field mask was given.
	MergeInvocation(context.Context, *MergeInvocationRequest) (*Invocation, error)
	// Touches the invocation identified by the given proto's name.
	//
	// This is useful when you need to notify ResultStore that you haven't
	// abandoned the upload, since abandoned uploads will be automatically
	// finalized after a set period.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	TouchInvocation(context.Context, *TouchInvocationRequest) (*TouchInvocationResponse, error)
	// Declares the invocation with the given name as finalized and immutable by
	// the user. It may still be mutated by post-processing. This is an implicitly
	// idempotent API.
	//
	// If an Invocation is not updated for 24 hours, some time after that
	// this will be called automatically.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	FinalizeInvocation(context.Context, *FinalizeInvocationRequest) (*FinalizeInvocationResponse, error)
	// Deletes an immutable invocation (permanently)
	// Note: this does not delete indirect data, e.g. files stored in other
	// services.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is not finalized.  This can be retried until it is.
	DeleteInvocation(context.Context, *DeleteInvocationRequest) (*empty.Empty, error)
	// Creates the given target under the given parent invocation. The given
	// target ID is URL encoded, converted to the full resource name, and assigned
	// to the target's name field. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no target ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	// - If a target with the same name already exists.
	CreateTarget(context.Context, *CreateTargetRequest) (*Target, error)
	// Applies a standard update to the target identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	// - If the target or parent invocation is finalized.
	// - If no field mask was given.
	UpdateTarget(context.Context, *UpdateTargetRequest) (*Target, error)
	// Applies a merge update to the target identified by the given proto's
	// name. For primitive and message fields, replaces them with the ones in the
	// given proto if they are covered under the field mask paths.  For repeated
	// fields, merges to them with the given ones if they are covered under the
	// field mask paths. This is not an implicitly idempotent API, so a request
	// id is required to make it idempotent.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	// - If the target or parent invocation is finalized.
	// - If no field mask was given.
	MergeTarget(context.Context, *MergeTargetRequest) (*Target, error)
	// Declares the target with the given name as finalized and immutable by the
	// user. It may still be mutated by post-processing. This is an implicitly
	// idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	FinalizeTarget(context.Context, *FinalizeTargetRequest) (*FinalizeTargetResponse, error)
	// Creates the given configured target under the given parent target.
	// The given configured target ID is URL encoded, converted to the full
	// resource name, and assigned to the configured target's name field.
	// This is not an implicitly idempotent API, so a request id is required
	// to make it idempotent.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no config ID is provided.
	// - If a configured target with the same ID already exists.
	// - If the parent target does not exist.
	// - If the parent target or invocation is finalized.
	CreateConfiguredTarget(context.Context, *CreateConfiguredTargetRequest) (*ConfiguredTarget, error)
	// Applies a standard update to the configured target identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths. Fields that match the mask but aren't populated in the
	// given configured target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	UpdateConfiguredTarget(context.Context, *UpdateConfiguredTargetRequest) (*ConfiguredTarget, error)
	// Applies a merge update to the configured target identified by the given
	// proto's name. For primitive and message fields, replaces them with the
	// ones in the given proto if they are covered under the field mask paths.
	// For repeated fields, merges to them with the given ones if they are
	// covered under the field mask paths. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	MergeConfiguredTarget(context.Context, *MergeConfiguredTargetRequest) (*ConfiguredTarget, error)
	// Declares the configured target with the given name as finalized and
	// immutable by the user. It may still be mutated by post-processing. This is
	// an implicitly idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	FinalizeConfiguredTarget(context.Context, *FinalizeConfiguredTargetRequest) (*FinalizeConfiguredTargetResponse, error)
	// Creates the given action under the given configured target. The given
	// action ID is URL encoded, converted to the full resource name, and
	// assigned to the action's name field. This is not an implicitly
	// idempotent API, so a request id is required to make it idempotent.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no action ID provided.
	// - If the parent configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If an action  with the same name already exists.
	CreateAction(context.Context, *CreateActionRequest) (*Action, error)
	// Applies a standard update to the action identified by the given
	// proto's name.  For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths.  Fields that match the mask but aren't populated in the
	// given action are cleared.  This is an implicitly idempotent API.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the action does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	UpdateAction(context.Context, *UpdateActionRequest) (*Action, error)
	// Applies a merge update to the action identified by the given
	// proto's name.  For primitive and message fields, replaces them with the
	// ones in the given proto if they are covered under the field mask paths.
	// For repeated fields, merges to them with the given ones if they are
	// covered under the field mask paths. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the action does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	MergeAction(context.Context, *MergeActionRequest) (*Action, error)
	// Creates the given configuration under the given parent invocation. The
	// given configuration ID is URL encoded, converted to the full resource name,
	// and assigned to the configuration's name field. The configuration ID of
	// "default" should be preferred for the default configuration in a
	// single-config invocation. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no configuration ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	// - If a configuration with the same name already exists.
	CreateConfiguration(context.Context, *CreateConfigurationRequest) (*Configuration, error)
	// Applies a standard update to the configuration identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given field
	// mask paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configuration does not exist.
	// - If the parent invocation is finalized.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateConfiguration(context.Context, *UpdateConfigurationRequest) (*Configuration, error)
	// Creates the given file set under the given parent invocation. The given
	// file set ID is URL encoded, converted to the full resource name, and
	// assigned to the file set's name field. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no file set ID is provided.
	// - If a file set with the same name already exists.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	CreateFileSet(context.Context, *CreateFileSetRequest) (*FileSet, error)
	// Applies a standard update to the file set identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the file set does not exist.
	// - If the parent invocation is finalized.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateFileSet(context.Context, *UpdateFileSetRequest) (*FileSet, error)
	// Applies a merge update to the file set identified by the given proto's
	// name. For primitive and message fields, updates them with the ones in the
	// given proto if they are covered under the field mask paths. For repeated
	// fields, merges to them with the given ones if they are covered under the
	// field mask paths. This is not an implicitly idempotent API, so a request
	// id is required to make it idempotent.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the file set does not exist.
	// - If the parent invocation is finalized.
	// - If a given field mask path is not valid.
	// - If no field mask was given.
	MergeFileSet(context.Context, *MergeFileSetRequest) (*FileSet, error)
	// This is the RPC used for batch upload. It supports uploading multiple
	// resources for an invocation in a transaction safe manner.
	//
	// To use this RPC, the CreateInvocationRequest must have been provided a
	// resume_token.
	//
	// Combining batch upload with normal upload on a single Invocation is not
	// supported. If an Invocation is created with a resume_token, all further
	// calls must be through UploadBatch. If an Invocation is created without
	// resume_token normal upload, all further upload calls must be through normal
	// upload RPCs.
	UploadBatch(context.Context, *UploadBatchRequest) (*UploadBatchResponse, error)
	// Provides a way to read the metadata for an invocation.
	// The UploadMetadata could still be retrieved by this RPC even the Invocation
	// has been finalized.
	// This API requires setting a response FieldMask via 'fields' URL query
	// parameter or X-Goog-FieldMask HTTP/gRPC header.
	//
	// An error will be reported in the following case:
	// - If the invocation does not exist.
	// - If no field mask was given.
	GetInvocationUploadMetadata(context.Context, *GetInvocationUploadMetadataRequest) (*UploadMetadata, error)
}

// UnimplementedResultStoreUploadServer can be embedded to have forward compatible implementations.
type UnimplementedResultStoreUploadServer struct {
}

func (*UnimplementedResultStoreUploadServer) CreateInvocation(ctx context.Context, req *CreateInvocationRequest) (*Invocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateInvocation(ctx context.Context, req *UpdateInvocationRequest) (*Invocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) MergeInvocation(ctx context.Context, req *MergeInvocationRequest) (*Invocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) TouchInvocation(ctx context.Context, req *TouchInvocationRequest) (*TouchInvocationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TouchInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) FinalizeInvocation(ctx context.Context, req *FinalizeInvocationRequest) (*FinalizeInvocationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) DeleteInvocation(ctx context.Context, req *DeleteInvocationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) CreateTarget(ctx context.Context, req *CreateTargetRequest) (*Target, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateTarget(ctx context.Context, req *UpdateTargetRequest) (*Target, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) MergeTarget(ctx context.Context, req *MergeTargetRequest) (*Target, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) FinalizeTarget(ctx context.Context, req *FinalizeTargetRequest) (*FinalizeTargetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) CreateConfiguredTarget(ctx context.Context, req *CreateConfiguredTargetRequest) (*ConfiguredTarget, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConfiguredTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateConfiguredTarget(ctx context.Context, req *UpdateConfiguredTargetRequest) (*ConfiguredTarget, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConfiguredTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) MergeConfiguredTarget(ctx context.Context, req *MergeConfiguredTargetRequest) (*ConfiguredTarget, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeConfiguredTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) FinalizeConfiguredTarget(ctx context.Context, req *FinalizeConfiguredTargetRequest) (*FinalizeConfiguredTargetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeConfiguredTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) CreateAction(ctx context.Context, req *CreateActionRequest) (*Action, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAction not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateAction(ctx context.Context, req *UpdateActionRequest) (*Action, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAction not implemented")
}
func (*UnimplementedResultStoreUploadServer) MergeAction(ctx context.Context, req *MergeActionRequest) (*Action, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeAction not implemented")
}
func (*UnimplementedResultStoreUploadServer) CreateConfiguration(ctx context.Context, req *CreateConfigurationRequest) (*Configuration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConfiguration not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateConfiguration(ctx context.Context, req *UpdateConfigurationRequest) (*Configuration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConfiguration not implemented")
}
func (*UnimplementedResultStoreUploadServer) CreateFileSet(ctx context.Context, req *CreateFileSetRequest) (*FileSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFileSet not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateFileSet(ctx context.Context, req *UpdateFileSetRequest) (*FileSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFileSet not implemented")
}
func (*UnimplementedResultStoreUploadServer) MergeFileSet(ctx context.Context, req *MergeFileSetRequest) (*FileSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeFileSet not implemented")
}
func (*UnimplementedResultStoreUploadServer) UploadBatch(ctx context.Context, req *UploadBatchRequest) (*UploadBatchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UploadBatch not implemented")
}
func (*UnimplementedResultStoreUploadServer) GetInvocationUploadMetadata(ctx context.Context, req *GetInvocationUploadMetadataRequest) (*UploadMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInvocationUploadMetadata not implemented")
}

func RegisterResultStoreUploadServer(s *grpc.Server, srv ResultStoreUploadServer) {
	s.RegisterService(&_ResultStoreUpload_serviceDesc, srv)
}

func _ResultStoreUpload_CreateInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateInvocation(ctx, req.(*CreateInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateInvocation(ctx, req.(*UpdateInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_MergeInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).MergeInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/MergeInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).MergeInvocation(ctx, req.(*MergeInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_TouchInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TouchInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).TouchInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/TouchInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).TouchInvocation(ctx, req.(*TouchInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_FinalizeInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).FinalizeInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).FinalizeInvocation(ctx, req.(*FinalizeInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_DeleteInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).DeleteInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/DeleteInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).DeleteInvocation(ctx, req.(*DeleteInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateTarget(ctx, req.(*CreateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateTarget(ctx, req.(*UpdateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_MergeTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).MergeTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/MergeTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).MergeTarget(ctx, req.(*MergeTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_FinalizeTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).FinalizeTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).FinalizeTarget(ctx, req.(*FinalizeTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateConfiguredTarget(ctx, req.(*CreateConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateConfiguredTarget(ctx, req.(*UpdateConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_MergeConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).MergeConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/MergeConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).MergeConfiguredTarget(ctx, req.(*MergeConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_FinalizeConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).FinalizeConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).FinalizeConfiguredTarget(ctx, req.(*FinalizeConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateAction(ctx, req.(*CreateActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateAction(ctx, req.(*UpdateActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_MergeAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).MergeAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/MergeAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).MergeAction(ctx, req.(*MergeActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateConfiguration(ctx, req.(*CreateConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateConfiguration(ctx, req.(*UpdateConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateFileSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFileSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateFileSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateFileSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateFileSet(ctx, req.(*CreateFileSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateFileSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFileSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateFileSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateFileSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateFileSet(ctx, req.(*UpdateFileSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_MergeFileSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeFileSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).MergeFileSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/MergeFileSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).MergeFileSet(ctx, req.(*MergeFileSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UploadBatch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadBatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UploadBatch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UploadBatch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UploadBatch(ctx, req.(*UploadBatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_GetInvocationUploadMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInvocationUploadMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).GetInvocationUploadMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/GetInvocationUploadMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).GetInvocationUploadMetadata(ctx, req.(*GetInvocationUploadMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResultStoreUpload_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.resultstore.v2.ResultStoreUpload",
	HandlerType: (*ResultStoreUploadServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateInvocation",
			Handler:    _ResultStoreUpload_CreateInvocation_Handler,
		},
		{
			MethodName: "UpdateInvocation",
			Handler:    _ResultStoreUpload_UpdateInvocation_Handler,
		},
		{
			MethodName: "MergeInvocation",
			Handler:    _ResultStoreUpload_MergeInvocation_Handler,
		},
		{
			MethodName: "TouchInvocation",
			Handler:    _ResultStoreUpload_TouchInvocation_Handler,
		},
		{
			MethodName: "FinalizeInvocation",
			Handler:    _ResultStoreUpload_FinalizeInvocation_Handler,
		},
		{
			MethodName: "DeleteInvocation",
			Handler:    _ResultStoreUpload_DeleteInvocation_Handler,
		},
		{
			MethodName: "CreateTarget",
			Handler:    _ResultStoreUpload_CreateTarget_Handler,
		},
		{
			MethodName: "UpdateTarget",
			Handler:    _ResultStoreUpload_UpdateTarget_Handler,
		},
		{
			MethodName: "MergeTarget",
			Handler:    _ResultStoreUpload_MergeTarget_Handler,
		},
		{
			MethodName: "FinalizeTarget",
			Handler:    _ResultStoreUpload_FinalizeTarget_Handler,
		},
		{
			MethodName: "CreateConfiguredTarget",
			Handler:    _ResultStoreUpload_CreateConfiguredTarget_Handler,
		},
		{
			MethodName: "UpdateConfiguredTarget",
			Handler:    _ResultStoreUpload_UpdateConfiguredTarget_Handler,
		},
		{
			MethodName: "MergeConfiguredTarget",
			Handler:    _ResultStoreUpload_MergeConfiguredTarget_Handler,
		},
		{
			MethodName: "FinalizeConfiguredTarget",
			Handler:    _ResultStoreUpload_FinalizeConfiguredTarget_Handler,
		},
		{
			MethodName: "CreateAction",
			Handler:    _ResultStoreUpload_CreateAction_Handler,
		},
		{
			MethodName: "UpdateAction",
			Handler:    _ResultStoreUpload_UpdateAction_Handler,
		},
		{
			MethodName: "MergeAction",
			Handler:    _ResultStoreUpload_MergeAction_Handler,
		},
		{
			MethodName: "CreateConfiguration",
			Handler:    _ResultStoreUpload_CreateConfiguration_Handler,
		},
		{
			MethodName: "UpdateConfiguration",
			Handler:    _ResultStoreUpload_UpdateConfiguration_Handler,
		},
		{
			MethodName: "CreateFileSet",
			Handler:    _ResultStoreUpload_CreateFileSet_Handler,
		},
		{
			MethodName: "UpdateFileSet",
			Handler:    _ResultStoreUpload_UpdateFileSet_Handler,
		},
		{
			MethodName: "MergeFileSet",
			Handler:    _ResultStoreUpload_MergeFileSet_Handler,
		},
		{
			MethodName: "UploadBatch",
			Handler:    _ResultStoreUpload_UploadBatch_Handler,
		},
		{
			MethodName: "GetInvocationUploadMetadata",
			Handler:    _ResultStoreUpload_GetInvocationUploadMetadata_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/resultstore/v2/resultstore_upload.proto",
}
