// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/connection/v1beta1/connection.proto

package connection

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Supported Cloud SQL database types.
type CloudSqlProperties_DatabaseType int32

const (
	// Unspecified database type.
	CloudSqlProperties_DATABASE_TYPE_UNSPECIFIED CloudSqlProperties_DatabaseType = 0
	// Cloud SQL for PostgreSQL.
	CloudSqlProperties_POSTGRES CloudSqlProperties_DatabaseType = 1
	// Cloud SQL for MySQL.
	CloudSqlProperties_MYSQL CloudSqlProperties_DatabaseType = 2
)

var CloudSqlProperties_DatabaseType_name = map[int32]string{
	0: "DATABASE_TYPE_UNSPECIFIED",
	1: "POSTGRES",
	2: "MYSQL",
}

var CloudSqlProperties_DatabaseType_value = map[string]int32{
	"DATABASE_TYPE_UNSPECIFIED": 0,
	"POSTGRES":                  1,
	"MYSQL":                     2,
}

func (x CloudSqlProperties_DatabaseType) String() string {
	return proto.EnumName(CloudSqlProperties_DatabaseType_name, int32(x))
}

func (CloudSqlProperties_DatabaseType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{9, 0}
}

// The request for [ConnectionService.CreateConnection][google.cloud.bigquery.connection.v1beta1.ConnectionService.CreateConnection].
type CreateConnectionRequest struct {
	// Required. Parent resource name.
	// Must be in the format `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Connection id that should be assigned to the created connection.
	ConnectionId string `protobuf:"bytes,2,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	// Required. Connection to create.
	Connection           *Connection `protobuf:"bytes,3,opt,name=connection,proto3" json:"connection,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateConnectionRequest) Reset()         { *m = CreateConnectionRequest{} }
func (m *CreateConnectionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateConnectionRequest) ProtoMessage()    {}
func (*CreateConnectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{0}
}

func (m *CreateConnectionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateConnectionRequest.Unmarshal(m, b)
}
func (m *CreateConnectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateConnectionRequest.Marshal(b, m, deterministic)
}
func (m *CreateConnectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateConnectionRequest.Merge(m, src)
}
func (m *CreateConnectionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateConnectionRequest.Size(m)
}
func (m *CreateConnectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateConnectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateConnectionRequest proto.InternalMessageInfo

func (m *CreateConnectionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateConnectionRequest) GetConnectionId() string {
	if m != nil {
		return m.ConnectionId
	}
	return ""
}

func (m *CreateConnectionRequest) GetConnection() *Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

// The request for [ConnectionService.GetConnection][google.cloud.bigquery.connection.v1beta1.ConnectionService.GetConnection].
type GetConnectionRequest struct {
	// Required. Name of the requested connection, for example:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetConnectionRequest) Reset()         { *m = GetConnectionRequest{} }
func (m *GetConnectionRequest) String() string { return proto.CompactTextString(m) }
func (*GetConnectionRequest) ProtoMessage()    {}
func (*GetConnectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{1}
}

func (m *GetConnectionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetConnectionRequest.Unmarshal(m, b)
}
func (m *GetConnectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetConnectionRequest.Marshal(b, m, deterministic)
}
func (m *GetConnectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetConnectionRequest.Merge(m, src)
}
func (m *GetConnectionRequest) XXX_Size() int {
	return xxx_messageInfo_GetConnectionRequest.Size(m)
}
func (m *GetConnectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetConnectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetConnectionRequest proto.InternalMessageInfo

func (m *GetConnectionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [ConnectionService.ListConnections][google.cloud.bigquery.connection.v1beta1.ConnectionService.ListConnections].
type ListConnectionsRequest struct {
	// Required. Parent resource name.
	// Must be in the form: `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Maximum number of results per page.
	MaxResults *wrappers.UInt32Value `protobuf:"bytes,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Page token.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListConnectionsRequest) Reset()         { *m = ListConnectionsRequest{} }
func (m *ListConnectionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListConnectionsRequest) ProtoMessage()    {}
func (*ListConnectionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{2}
}

func (m *ListConnectionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListConnectionsRequest.Unmarshal(m, b)
}
func (m *ListConnectionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListConnectionsRequest.Marshal(b, m, deterministic)
}
func (m *ListConnectionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListConnectionsRequest.Merge(m, src)
}
func (m *ListConnectionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListConnectionsRequest.Size(m)
}
func (m *ListConnectionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListConnectionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListConnectionsRequest proto.InternalMessageInfo

func (m *ListConnectionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListConnectionsRequest) GetMaxResults() *wrappers.UInt32Value {
	if m != nil {
		return m.MaxResults
	}
	return nil
}

func (m *ListConnectionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for [ConnectionService.ListConnections][google.cloud.bigquery.connection.v1beta1.ConnectionService.ListConnections].
type ListConnectionsResponse struct {
	// Next page token.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// List of connections.
	Connections          []*Connection `protobuf:"bytes,2,rep,name=connections,proto3" json:"connections,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ListConnectionsResponse) Reset()         { *m = ListConnectionsResponse{} }
func (m *ListConnectionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListConnectionsResponse) ProtoMessage()    {}
func (*ListConnectionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{3}
}

func (m *ListConnectionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListConnectionsResponse.Unmarshal(m, b)
}
func (m *ListConnectionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListConnectionsResponse.Marshal(b, m, deterministic)
}
func (m *ListConnectionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListConnectionsResponse.Merge(m, src)
}
func (m *ListConnectionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListConnectionsResponse.Size(m)
}
func (m *ListConnectionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListConnectionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListConnectionsResponse proto.InternalMessageInfo

func (m *ListConnectionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListConnectionsResponse) GetConnections() []*Connection {
	if m != nil {
		return m.Connections
	}
	return nil
}

// The request for [ConnectionService.UpdateConnection][google.cloud.bigquery.connection.v1beta1.ConnectionService.UpdateConnection].
type UpdateConnectionRequest struct {
	// Required. Name of the connection to update, for example:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Connection containing the updated fields.
	Connection *Connection `protobuf:"bytes,2,opt,name=connection,proto3" json:"connection,omitempty"`
	// Required. Update mask for the connection fields to be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateConnectionRequest) Reset()         { *m = UpdateConnectionRequest{} }
func (m *UpdateConnectionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateConnectionRequest) ProtoMessage()    {}
func (*UpdateConnectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{4}
}

func (m *UpdateConnectionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConnectionRequest.Unmarshal(m, b)
}
func (m *UpdateConnectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConnectionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateConnectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConnectionRequest.Merge(m, src)
}
func (m *UpdateConnectionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateConnectionRequest.Size(m)
}
func (m *UpdateConnectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConnectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConnectionRequest proto.InternalMessageInfo

func (m *UpdateConnectionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateConnectionRequest) GetConnection() *Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

func (m *UpdateConnectionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request for [ConnectionService.UpdateConnectionCredential][google.cloud.bigquery.connection.v1beta1.ConnectionService.UpdateConnectionCredential].
type UpdateConnectionCredentialRequest struct {
	// Required. Name of the connection, for example:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}/credential`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Credential to use with the connection.
	Credential           *ConnectionCredential `protobuf:"bytes,2,opt,name=credential,proto3" json:"credential,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateConnectionCredentialRequest) Reset()         { *m = UpdateConnectionCredentialRequest{} }
func (m *UpdateConnectionCredentialRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateConnectionCredentialRequest) ProtoMessage()    {}
func (*UpdateConnectionCredentialRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{5}
}

func (m *UpdateConnectionCredentialRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConnectionCredentialRequest.Unmarshal(m, b)
}
func (m *UpdateConnectionCredentialRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConnectionCredentialRequest.Marshal(b, m, deterministic)
}
func (m *UpdateConnectionCredentialRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConnectionCredentialRequest.Merge(m, src)
}
func (m *UpdateConnectionCredentialRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateConnectionCredentialRequest.Size(m)
}
func (m *UpdateConnectionCredentialRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConnectionCredentialRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConnectionCredentialRequest proto.InternalMessageInfo

func (m *UpdateConnectionCredentialRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateConnectionCredentialRequest) GetCredential() *ConnectionCredential {
	if m != nil {
		return m.Credential
	}
	return nil
}

// The request for [ConnectionService.DeleteConnectionRequest][].
type DeleteConnectionRequest struct {
	// Required. Name of the deleted connection, for example:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteConnectionRequest) Reset()         { *m = DeleteConnectionRequest{} }
func (m *DeleteConnectionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteConnectionRequest) ProtoMessage()    {}
func (*DeleteConnectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{6}
}

func (m *DeleteConnectionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteConnectionRequest.Unmarshal(m, b)
}
func (m *DeleteConnectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteConnectionRequest.Marshal(b, m, deterministic)
}
func (m *DeleteConnectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteConnectionRequest.Merge(m, src)
}
func (m *DeleteConnectionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteConnectionRequest.Size(m)
}
func (m *DeleteConnectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteConnectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteConnectionRequest proto.InternalMessageInfo

func (m *DeleteConnectionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Configuration parameters to establish connection with an external data
// source, except the credential attributes.
type Connection struct {
	// The resource name of the connection in the form of:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User provided display name for the connection.
	FriendlyName string `protobuf:"bytes,2,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// User provided description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Properties specific to the underlying data source.
	//
	// Types that are valid to be assigned to Properties:
	//	*Connection_CloudSql
	Properties isConnection_Properties `protobuf_oneof:"properties"`
	// Output only. The creation timestamp of the connection.
	CreationTime int64 `protobuf:"varint,5,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Output only. The last update timestamp of the connection.
	LastModifiedTime int64 `protobuf:"varint,6,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// Output only. True, if credential is configured for this connection.
	HasCredential        bool     `protobuf:"varint,7,opt,name=has_credential,json=hasCredential,proto3" json:"has_credential,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Connection) Reset()         { *m = Connection{} }
func (m *Connection) String() string { return proto.CompactTextString(m) }
func (*Connection) ProtoMessage()    {}
func (*Connection) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{7}
}

func (m *Connection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Connection.Unmarshal(m, b)
}
func (m *Connection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Connection.Marshal(b, m, deterministic)
}
func (m *Connection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connection.Merge(m, src)
}
func (m *Connection) XXX_Size() int {
	return xxx_messageInfo_Connection.Size(m)
}
func (m *Connection) XXX_DiscardUnknown() {
	xxx_messageInfo_Connection.DiscardUnknown(m)
}

var xxx_messageInfo_Connection proto.InternalMessageInfo

func (m *Connection) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Connection) GetFriendlyName() string {
	if m != nil {
		return m.FriendlyName
	}
	return ""
}

func (m *Connection) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type isConnection_Properties interface {
	isConnection_Properties()
}

type Connection_CloudSql struct {
	CloudSql *CloudSqlProperties `protobuf:"bytes,4,opt,name=cloud_sql,json=cloudSql,proto3,oneof"`
}

func (*Connection_CloudSql) isConnection_Properties() {}

func (m *Connection) GetProperties() isConnection_Properties {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *Connection) GetCloudSql() *CloudSqlProperties {
	if x, ok := m.GetProperties().(*Connection_CloudSql); ok {
		return x.CloudSql
	}
	return nil
}

func (m *Connection) GetCreationTime() int64 {
	if m != nil {
		return m.CreationTime
	}
	return 0
}

func (m *Connection) GetLastModifiedTime() int64 {
	if m != nil {
		return m.LastModifiedTime
	}
	return 0
}

func (m *Connection) GetHasCredential() bool {
	if m != nil {
		return m.HasCredential
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Connection) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Connection_CloudSql)(nil),
	}
}

// Credential to use with a connection.
type ConnectionCredential struct {
	// Credential specific to the underlying data source.
	//
	// Types that are valid to be assigned to Credential:
	//	*ConnectionCredential_CloudSql
	Credential           isConnectionCredential_Credential `protobuf_oneof:"credential"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ConnectionCredential) Reset()         { *m = ConnectionCredential{} }
func (m *ConnectionCredential) String() string { return proto.CompactTextString(m) }
func (*ConnectionCredential) ProtoMessage()    {}
func (*ConnectionCredential) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{8}
}

func (m *ConnectionCredential) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConnectionCredential.Unmarshal(m, b)
}
func (m *ConnectionCredential) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConnectionCredential.Marshal(b, m, deterministic)
}
func (m *ConnectionCredential) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectionCredential.Merge(m, src)
}
func (m *ConnectionCredential) XXX_Size() int {
	return xxx_messageInfo_ConnectionCredential.Size(m)
}
func (m *ConnectionCredential) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectionCredential.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectionCredential proto.InternalMessageInfo

type isConnectionCredential_Credential interface {
	isConnectionCredential_Credential()
}

type ConnectionCredential_CloudSql struct {
	CloudSql *CloudSqlCredential `protobuf:"bytes,1,opt,name=cloud_sql,json=cloudSql,proto3,oneof"`
}

func (*ConnectionCredential_CloudSql) isConnectionCredential_Credential() {}

func (m *ConnectionCredential) GetCredential() isConnectionCredential_Credential {
	if m != nil {
		return m.Credential
	}
	return nil
}

func (m *ConnectionCredential) GetCloudSql() *CloudSqlCredential {
	if x, ok := m.GetCredential().(*ConnectionCredential_CloudSql); ok {
		return x.CloudSql
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ConnectionCredential) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ConnectionCredential_CloudSql)(nil),
	}
}

// Connection properties specific to the Cloud SQL.
type CloudSqlProperties struct {
	// Cloud SQL instance ID in the form `project:location:instance`.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Database name.
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// Type of the Cloud SQL database.
	Type CloudSqlProperties_DatabaseType `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.bigquery.connection.v1beta1.CloudSqlProperties_DatabaseType" json:"type,omitempty"`
	// Input only. Cloud SQL credential.
	Credential           *CloudSqlCredential `protobuf:"bytes,4,opt,name=credential,proto3" json:"credential,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CloudSqlProperties) Reset()         { *m = CloudSqlProperties{} }
func (m *CloudSqlProperties) String() string { return proto.CompactTextString(m) }
func (*CloudSqlProperties) ProtoMessage()    {}
func (*CloudSqlProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{9}
}

func (m *CloudSqlProperties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudSqlProperties.Unmarshal(m, b)
}
func (m *CloudSqlProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudSqlProperties.Marshal(b, m, deterministic)
}
func (m *CloudSqlProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudSqlProperties.Merge(m, src)
}
func (m *CloudSqlProperties) XXX_Size() int {
	return xxx_messageInfo_CloudSqlProperties.Size(m)
}
func (m *CloudSqlProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudSqlProperties.DiscardUnknown(m)
}

var xxx_messageInfo_CloudSqlProperties proto.InternalMessageInfo

func (m *CloudSqlProperties) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CloudSqlProperties) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *CloudSqlProperties) GetType() CloudSqlProperties_DatabaseType {
	if m != nil {
		return m.Type
	}
	return CloudSqlProperties_DATABASE_TYPE_UNSPECIFIED
}

func (m *CloudSqlProperties) GetCredential() *CloudSqlCredential {
	if m != nil {
		return m.Credential
	}
	return nil
}

// Credential info for the Cloud SQL.
type CloudSqlCredential struct {
	// The username for the credential.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// The password for the credential.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudSqlCredential) Reset()         { *m = CloudSqlCredential{} }
func (m *CloudSqlCredential) String() string { return proto.CompactTextString(m) }
func (*CloudSqlCredential) ProtoMessage()    {}
func (*CloudSqlCredential) Descriptor() ([]byte, []int) {
	return fileDescriptor_57d65490f51d0d62, []int{10}
}

func (m *CloudSqlCredential) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudSqlCredential.Unmarshal(m, b)
}
func (m *CloudSqlCredential) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudSqlCredential.Marshal(b, m, deterministic)
}
func (m *CloudSqlCredential) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudSqlCredential.Merge(m, src)
}
func (m *CloudSqlCredential) XXX_Size() int {
	return xxx_messageInfo_CloudSqlCredential.Size(m)
}
func (m *CloudSqlCredential) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudSqlCredential.DiscardUnknown(m)
}

var xxx_messageInfo_CloudSqlCredential proto.InternalMessageInfo

func (m *CloudSqlCredential) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *CloudSqlCredential) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.bigquery.connection.v1beta1.CloudSqlProperties_DatabaseType", CloudSqlProperties_DatabaseType_name, CloudSqlProperties_DatabaseType_value)
	proto.RegisterType((*CreateConnectionRequest)(nil), "google.cloud.bigquery.connection.v1beta1.CreateConnectionRequest")
	proto.RegisterType((*GetConnectionRequest)(nil), "google.cloud.bigquery.connection.v1beta1.GetConnectionRequest")
	proto.RegisterType((*ListConnectionsRequest)(nil), "google.cloud.bigquery.connection.v1beta1.ListConnectionsRequest")
	proto.RegisterType((*ListConnectionsResponse)(nil), "google.cloud.bigquery.connection.v1beta1.ListConnectionsResponse")
	proto.RegisterType((*UpdateConnectionRequest)(nil), "google.cloud.bigquery.connection.v1beta1.UpdateConnectionRequest")
	proto.RegisterType((*UpdateConnectionCredentialRequest)(nil), "google.cloud.bigquery.connection.v1beta1.UpdateConnectionCredentialRequest")
	proto.RegisterType((*DeleteConnectionRequest)(nil), "google.cloud.bigquery.connection.v1beta1.DeleteConnectionRequest")
	proto.RegisterType((*Connection)(nil), "google.cloud.bigquery.connection.v1beta1.Connection")
	proto.RegisterType((*ConnectionCredential)(nil), "google.cloud.bigquery.connection.v1beta1.ConnectionCredential")
	proto.RegisterType((*CloudSqlProperties)(nil), "google.cloud.bigquery.connection.v1beta1.CloudSqlProperties")
	proto.RegisterType((*CloudSqlCredential)(nil), "google.cloud.bigquery.connection.v1beta1.CloudSqlCredential")
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/connection/v1beta1/connection.proto", fileDescriptor_57d65490f51d0d62)
}

var fileDescriptor_57d65490f51d0d62 = []byte{
	// 1446 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x4b, 0x6f, 0x1b, 0x55,
	0x14, 0xee, 0x38, 0x69, 0x49, 0x8e, 0x9d, 0xc6, 0x5c, 0x95, 0x26, 0x75, 0x5b, 0x9a, 0x4e, 0x25,
	0xe4, 0x5a, 0x61, 0x46, 0x71, 0x2b, 0x24, 0xc2, 0xab, 0xe3, 0xc4, 0x4d, 0x4d, 0x93, 0xe2, 0x8e,
	0xdd, 0xa2, 0x82, 0x90, 0xb9, 0x1e, 0xdf, 0x38, 0xd3, 0xce, 0x2b, 0x73, 0xaf, 0x93, 0x46, 0x51,
	0x10, 0xf0, 0x17, 0xd8, 0xc0, 0x92, 0x2d, 0x12, 0x2c, 0xf8, 0x01, 0xfd, 0x01, 0x5d, 0x21, 0xd8,
	0x20, 0xb3, 0x29, 0x12, 0x0b, 0x60, 0xcb, 0x02, 0x89, 0x15, 0x9a, 0x3b, 0x4f, 0xdb, 0x09, 0x75,
	0x9c, 0xb0, 0x4a, 0xe6, 0xbc, 0xbf, 0xf3, 0x9a, 0x33, 0x86, 0xd7, 0xdb, 0xb6, 0xdd, 0x36, 0x88,
	0xac, 0x19, 0x76, 0xa7, 0x25, 0x37, 0xf5, 0xf6, 0x66, 0x87, 0xb8, 0x3b, 0xb2, 0x66, 0x5b, 0x16,
	0xd1, 0x98, 0x6e, 0x5b, 0xf2, 0xd6, 0x42, 0x93, 0x30, 0xbc, 0x90, 0x20, 0x49, 0x8e, 0x6b, 0x33,
	0x1b, 0xe5, 0x7d, 0x55, 0x89, 0xab, 0x4a, 0xa1, 0xaa, 0x94, 0x90, 0x0b, 0x54, 0x73, 0x17, 0x02,
	0x27, 0xd8, 0xd1, 0x65, 0x6c, 0x59, 0x36, 0xc3, 0x1e, 0x9b, 0xfa, 0x76, 0x72, 0x33, 0x09, 0xae,
	0x66, 0xe8, 0xc4, 0x62, 0x01, 0xe3, 0x52, 0x82, 0xb1, 0xae, 0x13, 0xa3, 0xd5, 0x68, 0x92, 0x0d,
	0xbc, 0xa5, 0xdb, 0x6e, 0x20, 0x70, 0x2e, 0x21, 0xe0, 0x12, 0x6a, 0x77, 0x5c, 0x8d, 0x04, 0xac,
	0x97, 0x03, 0x96, 0x8e, 0x4d, 0x79, 0x6b, 0xc1, 0xfb, 0xd3, 0x70, 0x6c, 0x43, 0xd7, 0x76, 0x02,
	0x7e, 0xae, 0x97, 0xdf, 0xc3, 0x3b, 0x1f, 0xf0, 0xf8, 0x53, 0xb3, 0xb3, 0x2e, 0x13, 0xd3, 0x61,
	0x21, 0x73, 0xae, 0x9f, 0xe9, 0x47, 0x66, 0x62, 0xfa, 0xa8, 0xcf, 0x75, 0x24, 0xb1, 0xed, 0x62,
	0xc7, 0x21, 0x6e, 0x80, 0x57, 0xfc, 0x55, 0x80, 0x99, 0x25, 0x97, 0x60, 0x46, 0x96, 0xa2, 0x54,
	0xa9, 0x64, 0xb3, 0x43, 0x28, 0x43, 0x0a, 0x9c, 0x72, 0xb0, 0x4b, 0x2c, 0x36, 0x2b, 0xcc, 0x09,
	0xf9, 0xc9, 0xd2, 0xd5, 0x67, 0x4a, 0xea, 0x1f, 0xe5, 0x0a, 0x5c, 0x36, 0x6c, 0x2d, 0x48, 0x9a,
	0x6f, 0x1d, 0x3b, 0x3a, 0x95, 0x34, 0xdb, 0x94, 0x57, 0x03, 0x86, 0x1a, 0x28, 0xa2, 0x3c, 0x4c,
	0xc5, 0x25, 0x68, 0xe8, 0xad, 0xd9, 0x14, 0xb7, 0x34, 0xf6, 0x4c, 0x11, 0xd4, 0x4c, 0xcc, 0xa9,
	0xb4, 0xd0, 0x03, 0x80, 0xf8, 0x79, 0x76, 0x6c, 0x4e, 0xc8, 0xa7, 0x8b, 0xd7, 0xa5, 0x61, 0xab,
	0x2a, 0xc5, 0xd1, 0x7b, 0xc6, 0x53, 0x6a, 0xc2, 0x98, 0xf8, 0x31, 0x9c, 0x59, 0x21, 0x6c, 0x10,
	0xdf, 0x2d, 0x18, 0xb7, 0xb0, 0x49, 0x02, 0x74, 0xd7, 0x39, 0x3a, 0x09, 0xe6, 0x43, 0x37, 0x09,
	0x2f, 0x7d, 0x30, 0x13, 0xa6, 0xb8, 0x05, 0xf1, 0x89, 0x00, 0x67, 0x57, 0x75, 0x9a, 0xf0, 0x41,
	0x8f, 0x31, 0x89, 0x25, 0x48, 0x9b, 0xf8, 0x71, 0xc3, 0x25, 0xb4, 0x63, 0x30, 0xca, 0x53, 0x98,
	0x2e, 0x5e, 0x08, 0x73, 0x13, 0x56, 0x56, 0xba, 0x57, 0xb1, 0xd8, 0xb5, 0xe2, 0x7d, 0x6c, 0x74,
	0x48, 0x90, 0x03, 0x13, 0x3f, 0x56, 0x7d, 0x25, 0x74, 0x11, 0xc0, 0xc1, 0x6d, 0xd2, 0x60, 0xf6,
	0x23, 0xe2, 0xa7, 0x77, 0x52, 0x9d, 0xf4, 0x28, 0x75, 0x8f, 0x20, 0x7e, 0x25, 0xc0, 0xcc, 0x00,
	0x00, 0xea, 0xd8, 0x16, 0x25, 0xe8, 0x15, 0x98, 0xb6, 0xc8, 0x63, 0xd6, 0x48, 0xe8, 0x73, 0x28,
	0xea, 0x94, 0x47, 0xae, 0x86, 0x36, 0xd0, 0x7d, 0x48, 0xc7, 0x29, 0xf3, 0xc2, 0x1c, 0x1b, 0xb5,
	0x84, 0x6a, 0xd2, 0x90, 0xf8, 0x69, 0x0a, 0x66, 0xee, 0x39, 0xad, 0x7d, 0x5b, 0xf4, 0xd8, 0x4a,
	0xd8, 0xd7, 0x7f, 0xa9, 0x63, 0xec, 0x3f, 0x74, 0x03, 0xd2, 0x1d, 0x1e, 0x3f, 0x1f, 0xcc, 0xa0,
	0xb7, 0x73, 0x03, 0xf5, 0xbb, 0xe9, 0xcd, 0xee, 0x1a, 0xa6, 0x8f, 0x02, 0x0b, 0xbe, 0x8e, 0x47,
	0x10, 0xbf, 0x16, 0xe0, 0x72, 0x7f, 0x0a, 0x96, 0x5c, 0xd2, 0x22, 0x16, 0xd3, 0xb1, 0x11, 0x26,
	0x63, 0xa6, 0x27, 0x19, 0xdc, 0x88, 0x8f, 0x4d, 0x03, 0xd0, 0x22, 0xe9, 0x00, 0xdb, 0xdb, 0xa3,
	0x60, 0x8b, 0x7d, 0x86, 0x28, 0x23, 0x82, 0xa8, 0xc1, 0xcc, 0x32, 0x31, 0xc8, 0xff, 0x5a, 0x25,
	0xf1, 0x87, 0x31, 0x80, 0x98, 0x88, 0x50, 0xd2, 0x70, 0x00, 0xf6, 0x0a, 0x4c, 0xad, 0xbb, 0x3a,
	0xb1, 0x5a, 0xc6, 0x4e, 0x83, 0x33, 0xf9, 0xca, 0x51, 0x33, 0x21, 0xf1, 0x8e, 0x27, 0x34, 0x07,
	0xe9, 0x16, 0xa1, 0x9a, 0xab, 0x3b, 0xd1, 0xba, 0x99, 0x54, 0x93, 0x24, 0xf4, 0x21, 0x4c, 0xf2,
	0xcc, 0x34, 0xe8, 0xa6, 0x31, 0x3b, 0xce, 0x53, 0xf6, 0xe6, 0x21, 0x52, 0xe6, 0x49, 0xd4, 0x36,
	0x8d, 0xaa, 0x6b, 0x3b, 0xc4, 0x65, 0x3a, 0xa1, 0xb7, 0x4e, 0xa8, 0x13, 0x5a, 0x40, 0xe5, 0x6b,
	0xd1, 0x5b, 0xba, 0xde, 0x52, 0x64, 0xba, 0x49, 0x66, 0x4f, 0xce, 0x09, 0xf9, 0x31, 0x2f, 0xa7,
	0x63, 0x6a, 0x26, 0xe4, 0xd4, 0x75, 0x93, 0xa0, 0x05, 0x40, 0x06, 0xa6, 0xac, 0x61, 0xda, 0x2d,
	0x7d, 0x5d, 0x27, 0x2d, 0x5f, 0xfc, 0x54, 0x2c, 0x9e, 0xf5, 0xd8, 0x6b, 0x01, 0x97, 0xab, 0x14,
	0xe0, 0xf4, 0x06, 0xa6, 0x8d, 0x44, 0xc5, 0x5f, 0x98, 0x13, 0xf2, 0x13, 0xbe, 0xf8, 0xd4, 0x06,
	0xa6, 0x71, 0x15, 0x17, 0xe9, 0x9f, 0x8a, 0x73, 0xb8, 0x42, 0xa0, 0x1b, 0x8e, 0x6b, 0x3f, 0x24,
	0x1a, 0xa3, 0xf2, 0x6e, 0xf0, 0xdf, 0x9e, 0x1c, 0xed, 0x32, 0x79, 0x37, 0xfc, 0x77, 0x2f, 0xf1,
	0x8e, 0xa6, 0xf2, 0x6e, 0xfc, 0xb0, 0x57, 0xca, 0x00, 0x38, 0x51, 0x5e, 0xc4, 0xcf, 0x04, 0x38,
	0xb3, 0x5f, 0x87, 0xf5, 0x56, 0x40, 0x18, 0xb5, 0x02, 0xb1, 0xc1, 0x64, 0x05, 0xbc, 0x18, 0x12,
	0xbd, 0xfb, 0x4b, 0x0a, 0xd0, 0x60, 0xc9, 0xd0, 0x25, 0x48, 0xeb, 0x16, 0x65, 0xd8, 0xd2, 0x88,
	0xf7, 0xee, 0xf2, 0xbb, 0x0c, 0x42, 0x52, 0xa5, 0x85, 0x72, 0x30, 0xd1, 0xc2, 0x0c, 0x37, 0x31,
	0x0d, 0xdb, 0x2c, 0x7a, 0x46, 0x1f, 0xc1, 0x38, 0xdb, 0x71, 0x08, 0xef, 0xad, 0xd3, 0xc5, 0xca,
	0x51, 0x7a, 0x47, 0x5a, 0x0e, 0x8c, 0xd6, 0x77, 0x1c, 0xa2, 0x72, 0xb3, 0x08, 0xf7, 0xcc, 0xf4,
	0xf8, 0xd1, 0xd3, 0xe3, 0xf5, 0xc7, 0x78, 0xcf, 0x44, 0xdf, 0x84, 0x4c, 0xd2, 0x31, 0xba, 0x08,
	0xe7, 0x96, 0x95, 0xba, 0x52, 0x52, 0x6a, 0xe5, 0x46, 0xfd, 0x41, 0xb5, 0xdc, 0xb8, 0x77, 0xa7,
	0x56, 0x2d, 0x2f, 0x55, 0x6e, 0x56, 0xca, 0xcb, 0xd9, 0x13, 0x28, 0x03, 0x13, 0xd5, 0xf7, 0x6a,
	0xf5, 0x15, 0xb5, 0x5c, 0xcb, 0x0a, 0x68, 0x12, 0x4e, 0xae, 0x3d, 0xa8, 0xdd, 0x5d, 0xcd, 0xa6,
	0xc4, 0xd5, 0x38, 0xb9, 0x89, 0xf2, 0xe6, 0x60, 0xa2, 0x43, 0x89, 0x9b, 0x98, 0xdf, 0xe8, 0xd9,
	0xe3, 0x39, 0x98, 0xd2, 0x6d, 0xdb, 0x6d, 0x85, 0x79, 0x0d, 0x9f, 0x8b, 0x5f, 0x66, 0xe1, 0xc5,
	0xb8, 0x5f, 0x6a, 0xc4, 0xdd, 0xd2, 0x35, 0x82, 0xfe, 0x16, 0x20, 0xdb, 0x7f, 0xc7, 0x20, 0xe5,
	0x10, 0xf9, 0xd8, 0xff, 0x06, 0xca, 0x8d, 0xf4, 0x0a, 0x10, 0x1f, 0x76, 0x95, 0x4b, 0xfe, 0xcb,
	0x7b, 0x3e, 0x16, 0x9c, 0xef, 0xb9, 0x84, 0x3e, 0xff, 0xe9, 0xb7, 0x2f, 0x52, 0x25, 0xf1, 0x7a,
	0x74, 0xd2, 0xee, 0xfa, 0x0a, 0x6f, 0x45, 0xe3, 0x55, 0x48, 0x8c, 0x55, 0xa1, 0x67, 0x9c, 0x16,
	0x93, 0x6f, 0x97, 0xa7, 0x02, 0x4c, 0xf5, 0x9c, 0x37, 0xe8, 0x10, 0xab, 0x7d, 0xbf, 0xbb, 0x68,
	0x44, 0xcc, 0x4b, 0x5d, 0x85, 0x2f, 0x60, 0x0e, 0xec, 0x35, 0x94, 0x00, 0xe6, 0x51, 0x0f, 0x80,
	0xd5, 0xb3, 0x24, 0x0a, 0x7b, 0xe8, 0x0f, 0x01, 0xa6, 0xfb, 0xee, 0x10, 0x74, 0x63, 0xf8, 0x70,
	0xf6, 0xbf, 0xc1, 0x72, 0xca, 0x11, 0x2c, 0xf8, 0x47, 0x90, 0x78, 0xb7, 0xab, 0xa0, 0xa0, 0xa2,
	0x89, 0x5b, 0x6c, 0x10, 0xeb, 0xf0, 0x45, 0x44, 0x7f, 0x09, 0x90, 0xed, 0x7f, 0xa9, 0x1f, 0xa6,
	0x65, 0x0f, 0xb8, 0x89, 0x46, 0x2c, 0xdf, 0x7a, 0x57, 0x39, 0xef, 0x15, 0x2a, 0xd9, 0xb0, 0x89,
	0xab, 0xc5, 0x6f, 0xd7, 0xe2, 0x48, 0x55, 0xed, 0x69, 0xd7, 0xdf, 0x05, 0xc8, 0x1d, 0x7c, 0xca,
	0xa0, 0xdb, 0xa3, 0xe3, 0x1f, 0x38, 0x88, 0x72, 0x67, 0x07, 0x6e, 0xac, 0xb2, 0xf7, 0xf1, 0x24,
	0x92, 0xae, 0x32, 0xed, 0x63, 0x8d, 0x54, 0x38, 0xbe, 0xb5, 0xe2, 0x3b, 0x23, 0xe0, 0x93, 0x63,
	0x2b, 0x1e, 0xd4, 0x18, 0xcb, 0xf7, 0x02, 0x64, 0xfb, 0x4f, 0xa2, 0xc3, 0x14, 0xf8, 0x80, 0x73,
	0xea, 0x40, 0x58, 0xbd, 0x13, 0x58, 0x18, 0x6d, 0x02, 0xbf, 0x13, 0x20, 0xb3, 0x42, 0x58, 0x05,
	0x9b, 0x55, 0xfe, 0x19, 0x8a, 0xc4, 0xd0, 0x9b, 0x8e, 0x4d, 0x69, 0x8b, 0xaf, 0x8c, 0x88, 0x19,
	0x46, 0xf4, 0x52, 0x9f, 0x8c, 0xcf, 0x15, 0xb5, 0xae, 0x92, 0x0d, 0x3f, 0x85, 0xe7, 0x6d, 0x7e,
	0x57, 0xf9, 0x23, 0xf3, 0xae, 0x58, 0x8e, 0x83, 0x0b, 0x25, 0x86, 0x6c, 0xa6, 0x76, 0xc2, 0xff,
	0xa2, 0x50, 0x40, 0xdf, 0x0a, 0x90, 0xa9, 0xfd, 0x57, 0xc0, 0xb5, 0xe1, 0x03, 0x6e, 0x76, 0x95,
	0xe9, 0x28, 0x60, 0xff, 0x33, 0xfc, 0xc8, 0xf1, 0xd2, 0xbe, 0x78, 0x7f, 0x16, 0x00, 0xd5, 0x09,
	0xe5, 0x44, 0xe2, 0x9a, 0x3a, 0xa5, 0x7c, 0x1b, 0xe4, 0xfb, 0x22, 0x1a, 0x14, 0x09, 0x63, 0xbf,
	0x3a, 0x84, 0x64, 0xb0, 0xb5, 0xcc, 0xae, 0x72, 0x26, 0xc6, 0x13, 0x0b, 0x70, 0x50, 0x55, 0xf1,
	0xf6, 0xc8, 0xa0, 0xd8, 0x80, 0xcf, 0x45, 0xa1, 0x90, 0xfb, 0xe4, 0xa9, 0x72, 0xf9, 0xb9, 0xb7,
	0xe4, 0x8f, 0xca, 0xfb, 0x1b, 0x8c, 0x39, 0x74, 0x51, 0x96, 0xb7, 0xb7, 0xb7, 0xfb, 0x0f, 0x4d,
	0xdc, 0x61, 0x1b, 0xd1, 0x2f, 0x3f, 0xf3, 0xcf, 0x13, 0xe4, 0x33, 0xf4, 0xaa, 0x63, 0x60, 0xb6,
	0x6e, 0xbb, 0x66, 0xe9, 0x89, 0x00, 0xf3, 0x9a, 0x6d, 0x0e, 0x3d, 0x61, 0xa5, 0xe9, 0x78, 0xb8,
	0xaa, 0xde, 0x2c, 0x7d, 0xa0, 0x06, 0xaa, 0x6d, 0xdb, 0xc0, 0x56, 0x5b, 0xb2, 0xdd, 0xb6, 0xdc,
	0x26, 0x16, 0x9f, 0x33, 0x39, 0x0e, 0xe0, 0xf9, 0x3f, 0x50, 0xbd, 0x11, 0x93, 0xbe, 0x49, 0xe5,
	0x57, 0x7c, 0xa3, 0xfc, 0x08, 0x92, 0x4a, 0x7a, 0xfb, 0x2e, 0x8f, 0x27, 0xf6, 0x2d, 0xdd, 0x5f,
	0x28, 0x79, 0x5a, 0xcd, 0x53, 0xdc, 0xd3, 0xb5, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x8f, 0x11,
	0x29, 0x0b, 0x09, 0x13, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConnectionServiceClient is the client API for ConnectionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConnectionServiceClient interface {
	// Creates a new connection.
	CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Returns specified connection.
	GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Returns a list of connections in the given project.
	ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error)
	// Updates the specified connection. For security reasons, also resets
	// credential if connection properties are in the update field mask.
	UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Sets the credential for the specified connection.
	UpdateConnectionCredential(ctx context.Context, in *UpdateConnectionCredentialRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Deletes connection and associated credential.
	DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	//
	// Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type connectionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConnectionServiceClient(cc grpc.ClientConnInterface) ConnectionServiceClient {
	return &connectionServiceClient{cc}
}

func (c *connectionServiceClient) CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1beta1.ConnectionService/CreateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1beta1.ConnectionService/GetConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error) {
	out := new(ListConnectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1beta1.ConnectionService/ListConnections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1beta1.ConnectionService/UpdateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) UpdateConnectionCredential(ctx context.Context, in *UpdateConnectionCredentialRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1beta1.ConnectionService/UpdateConnectionCredential", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1beta1.ConnectionService/DeleteConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1beta1.ConnectionService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1beta1.ConnectionService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1beta1.ConnectionService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConnectionServiceServer is the server API for ConnectionService service.
type ConnectionServiceServer interface {
	// Creates a new connection.
	CreateConnection(context.Context, *CreateConnectionRequest) (*Connection, error)
	// Returns specified connection.
	GetConnection(context.Context, *GetConnectionRequest) (*Connection, error)
	// Returns a list of connections in the given project.
	ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error)
	// Updates the specified connection. For security reasons, also resets
	// credential if connection properties are in the update field mask.
	UpdateConnection(context.Context, *UpdateConnectionRequest) (*Connection, error)
	// Sets the credential for the specified connection.
	UpdateConnectionCredential(context.Context, *UpdateConnectionCredentialRequest) (*empty.Empty, error)
	// Deletes connection and associated credential.
	DeleteConnection(context.Context, *DeleteConnectionRequest) (*empty.Empty, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	//
	// Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedConnectionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConnectionServiceServer struct {
}

func (*UnimplementedConnectionServiceServer) CreateConnection(ctx context.Context, req *CreateConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) GetConnection(ctx context.Context, req *GetConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) ListConnections(ctx context.Context, req *ListConnectionsRequest) (*ListConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnections not implemented")
}
func (*UnimplementedConnectionServiceServer) UpdateConnection(ctx context.Context, req *UpdateConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) UpdateConnectionCredential(ctx context.Context, req *UpdateConnectionCredentialRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnectionCredential not implemented")
}
func (*UnimplementedConnectionServiceServer) DeleteConnection(ctx context.Context, req *DeleteConnectionRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedConnectionServiceServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedConnectionServiceServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterConnectionServiceServer(s *grpc.Server, srv ConnectionServiceServer) {
	s.RegisterService(&_ConnectionService_serviceDesc, srv)
}

func _ConnectionService_CreateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).CreateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1beta1.ConnectionService/CreateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).CreateConnection(ctx, req.(*CreateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_GetConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).GetConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1beta1.ConnectionService/GetConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).GetConnection(ctx, req.(*GetConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_ListConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).ListConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1beta1.ConnectionService/ListConnections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).ListConnections(ctx, req.(*ListConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_UpdateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).UpdateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1beta1.ConnectionService/UpdateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).UpdateConnection(ctx, req.(*UpdateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_UpdateConnectionCredential_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionCredentialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).UpdateConnectionCredential(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1beta1.ConnectionService/UpdateConnectionCredential",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).UpdateConnectionCredential(ctx, req.(*UpdateConnectionCredentialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_DeleteConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).DeleteConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1beta1.ConnectionService/DeleteConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).DeleteConnection(ctx, req.(*DeleteConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1beta1.ConnectionService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1beta1.ConnectionService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1beta1.ConnectionService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConnectionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.connection.v1beta1.ConnectionService",
	HandlerType: (*ConnectionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConnection",
			Handler:    _ConnectionService_CreateConnection_Handler,
		},
		{
			MethodName: "GetConnection",
			Handler:    _ConnectionService_GetConnection_Handler,
		},
		{
			MethodName: "ListConnections",
			Handler:    _ConnectionService_ListConnections_Handler,
		},
		{
			MethodName: "UpdateConnection",
			Handler:    _ConnectionService_UpdateConnection_Handler,
		},
		{
			MethodName: "UpdateConnectionCredential",
			Handler:    _ConnectionService_UpdateConnectionCredential_Handler,
		},
		{
			MethodName: "DeleteConnection",
			Handler:    _ConnectionService_DeleteConnection_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _ConnectionService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _ConnectionService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ConnectionService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/connection/v1beta1/connection.proto",
}
