// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Package streamingaead provides implementations of the streaming AEAD primitive.
//
// AEAD encryption assures the confidentiality and authenticity of the data.
// This primitive is CPA secure.
package streamingaead

import (
	"fmt"

	"github.com/tink-crypto/tink-go/v2/core/registry"
	"github.com/tink-crypto/tink-go/v2/internal/internalregistry"
)

func init() {
	if err := registry.RegisterKeyManager(new(aesGCMHKDFKeyManager)); err != nil {
		panic(fmt.Sprintf("streamingaead.init() failed: %v", err))
	}
	if err := internalregistry.AllowKeyDerivation(aesGCMHKDFTypeURL); err != nil {
		panic(fmt.Sprintf("streamingaead.init() failed: %v", err))
	}

	if err := registry.RegisterKeyManager(new(aesCTRHMACKeyManager)); err != nil {
		panic(fmt.Sprintf("streamingaead.init() failed: %v", err))
	}
}
