// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists the trials in your account. Specify an experiment name to limit the list
// to the trials that are part of that experiment. Specify a trial component name
// to limit the list to the trials that associated with that trial component. The
// list can be filtered to show only trials that were created in a specific time
// range. The list can be sorted by trial name or creation time.
func (c *Client) ListTrials(ctx context.Context, params *ListTrialsInput, optFns ...func(*Options)) (*ListTrialsOutput, error) {
	if params == nil {
		params = &ListTrialsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTrials", params, optFns, c.addOperationListTrialsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTrialsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTrialsInput struct {

	// A filter that returns only trials created after the specified time.
	CreatedAfter *time.Time

	// A filter that returns only trials created before the specified time.
	CreatedBefore *time.Time

	// A filter that returns only trials that are part of the specified experiment.
	ExperimentName *string

	// The maximum number of trials to return in the response. The default value is 10.
	MaxResults *int32

	// If the previous call to ListTrials didn't return the full set of trials, the
	// call returns a token for getting the next set of trials.
	NextToken *string

	// The property used to sort results. The default value is CreationTime .
	SortBy types.SortTrialsBy

	// The sort order. The default value is Descending .
	SortOrder types.SortOrder

	// A filter that returns only trials that are associated with the specified trial
	// component.
	TrialComponentName *string

	noSmithyDocumentSerde
}

type ListTrialsOutput struct {

	// A token for getting the next set of trials, if there are any.
	NextToken *string

	// A list of the summaries of your trials.
	TrialSummaries []types.TrialSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTrialsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListTrials{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListTrials{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTrials"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTrials(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTrialsPaginatorOptions is the paginator options for ListTrials
type ListTrialsPaginatorOptions struct {
	// The maximum number of trials to return in the response. The default value is 10.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTrialsPaginator is a paginator for ListTrials
type ListTrialsPaginator struct {
	options   ListTrialsPaginatorOptions
	client    ListTrialsAPIClient
	params    *ListTrialsInput
	nextToken *string
	firstPage bool
}

// NewListTrialsPaginator returns a new ListTrialsPaginator
func NewListTrialsPaginator(client ListTrialsAPIClient, params *ListTrialsInput, optFns ...func(*ListTrialsPaginatorOptions)) *ListTrialsPaginator {
	if params == nil {
		params = &ListTrialsInput{}
	}

	options := ListTrialsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTrialsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTrialsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTrials page.
func (p *ListTrialsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTrialsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTrials(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTrialsAPIClient is a client that implements the ListTrials operation.
type ListTrialsAPIClient interface {
	ListTrials(context.Context, *ListTrialsInput, ...func(*Options)) (*ListTrialsOutput, error)
}

var _ ListTrialsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTrials(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTrials",
	}
}
