// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfrontkeyvaluestore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfrontkeyvaluestore/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Puts or Deletes multiple key value pairs in a single, all-or-nothing operation.
func (c *Client) UpdateKeys(ctx context.Context, params *UpdateKeysInput, optFns ...func(*Options)) (*UpdateKeysOutput, error) {
	if params == nil {
		params = &UpdateKeysInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateKeys", params, optFns, c.addOperationUpdateKeysMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateKeysOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateKeysInput struct {

	// The current version (ETag) of the Key Value Store that you are updating keys
	// of, which you can get using DescribeKeyValueStore.
	//
	// This member is required.
	IfMatch *string

	// The Amazon Resource Name (ARN) of the Key Value Store.
	//
	// This member is required.
	KvsARN *string

	// List of keys to delete.
	Deletes []types.DeleteKeyRequestListItem

	// List of key value pairs to put.
	Puts []types.PutKeyRequestListItem

	noSmithyDocumentSerde
}

func (in *UpdateKeysInput) bindEndpointParams(p *EndpointParameters) {

	p.KvsARN = in.KvsARN

}

// Metadata information about a Key Value Store.
type UpdateKeysOutput struct {

	// The current version identifier of the Key Value Store after the successful
	// update.
	//
	// This member is required.
	ETag *string

	// Number of key value pairs in the Key Value Store after the successful update.
	//
	// This member is required.
	ItemCount *int32

	// Total size of the Key Value Store after the successful update, in bytes.
	//
	// This member is required.
	TotalSizeInBytes *int64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateKeysMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateKeys{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateKeys{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateKeys"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateKeysValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateKeys(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateKeys(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateKeys",
	}
}
