// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// This error is returned if you call AssociateDelegationSignerToDomain when the
// specified domain has reached the maximum number of DS records. You can't add any
// additional DS records unless you delete an existing one first.
type DnssecLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DnssecLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DnssecLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DnssecLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DnssecLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *DnssecLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of domains has exceeded the allowed threshold for the account.
type DomainLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DomainLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DomainLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DomainLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DomainLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *DomainLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request is already in progress for the domain.
type DuplicateRequest struct {
	Message *string

	ErrorCodeOverride *string

	RequestId *string

	noSmithyDocumentSerde
}

func (e *DuplicateRequest) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateRequest) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateRequest) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicateRequest"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateRequest) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested item is not acceptable. For example, for APIs that accept a
// domain name, the request might specify a domain name that doesn't belong to the
// account that submitted the request. For
// AcceptDomainTransferFromAnotherAwsAccount , the password might be invalid.
type InvalidInput struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInput) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInput) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInput) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInput"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInput) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of operations or jobs running exceeded the allowed threshold for the
// account.
type OperationLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OperationLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OperationLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *OperationLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The top-level domain does not support this operation.
type TLDRulesViolation struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TLDRulesViolation) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TLDRulesViolation) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TLDRulesViolation) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TLDRulesViolation"
	}
	return *e.ErrorCodeOverride
}
func (e *TLDRulesViolation) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Amazon Route 53 does not support this top-level domain (TLD).
type UnsupportedTLD struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedTLD) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedTLD) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedTLD) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedTLD"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedTLD) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
