/*
 * Copyright 2023 Siemens
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions.  No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */

/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice 
 * is preserved.
 * ====================================================
 */

/* Based on newlib/libm/mathfp/s_erf.c in Newlib.  */

#include "amdgcnmach.h"

v64df v64df_exp_aux (v64df, v64di);

static const double
tiny        = 1e-300,
half=  5.00000000000000000000e-01, /* 0x3FE00000, 0x00000000 */
one =  1.00000000000000000000e+00, /* 0x3FF00000, 0x00000000 */
two =  2.00000000000000000000e+00, /* 0x40000000, 0x00000000 */
/* c = (float)0.84506291151 */
erx =  8.45062911510467529297e-01, /* 0x3FEB0AC1, 0x60000000 */
/*
 * Coefficients for approximation to  erf on [0,0.84375]
 */
efx =  1.28379167095512586316e-01, /* 0x3FC06EBA, 0x8214DB69 */
efx8=  1.02703333676410069053e+00, /* 0x3FF06EBA, 0x8214DB69 */
pp0  =  1.28379167095512558561e-01, /* 0x3FC06EBA, 0x8214DB68 */
pp1  = -3.25042107247001499370e-01, /* 0xBFD4CD7D, 0x691CB913 */
pp2  = -2.84817495755985104766e-02, /* 0xBF9D2A51, 0xDBD7194F */
pp3  = -5.77027029648944159157e-03, /* 0xBF77A291, 0x236668E4 */
pp4  = -2.37630166566501626084e-05, /* 0xBEF8EAD6, 0x120016AC */
qq1  =  3.97917223959155352819e-01, /* 0x3FD97779, 0xCDDADC09 */
qq2  =  6.50222499887672944485e-02, /* 0x3FB0A54C, 0x5536CEBA */
qq3  =  5.08130628187576562776e-03, /* 0x3F74D022, 0xC4D36B0F */
qq4  =  1.32494738004321644526e-04, /* 0x3F215DC9, 0x221C1A10 */
qq5  = -3.96022827877536812320e-06, /* 0xBED09C43, 0x42A26120 */
/*
 * Coefficients for approximation to  erf  in [0.84375,1.25]
 */
pa0  = -2.36211856075265944077e-03, /* 0xBF6359B8, 0xBEF77538 */
pa1  =  4.14856118683748331666e-01, /* 0x3FDA8D00, 0xAD92B34D */
pa2  = -3.72207876035701323847e-01, /* 0xBFD7D240, 0xFBB8C3F1 */
pa3  =  3.18346619901161753674e-01, /* 0x3FD45FCA, 0x805120E4 */
pa4  = -1.10894694282396677476e-01, /* 0xBFBC6398, 0x3D3E28EC */
pa5  =  3.54783043256182359371e-02, /* 0x3FA22A36, 0x599795EB */
pa6  = -2.16637559486879084300e-03, /* 0xBF61BF38, 0x0A96073F */
qa1  =  1.06420880400844228286e-01, /* 0x3FBB3E66, 0x18EEE323 */
qa2  =  5.40397917702171048937e-01, /* 0x3FE14AF0, 0x92EB6F33 */
qa3  =  7.18286544141962662868e-02, /* 0x3FB2635C, 0xD99FE9A7 */
qa4  =  1.26171219808761642112e-01, /* 0x3FC02660, 0xE763351F */
qa5  =  1.36370839120290507362e-02, /* 0x3F8BEDC2, 0x6B51DD1C */
qa6  =  1.19844998467991074170e-02, /* 0x3F888B54, 0x5735151D */
/*
 * Coefficients for approximation to  erfc in [1.25,1/0.35]
 */
ra0  = -9.86494403484714822705e-03, /* 0xBF843412, 0x600D6435 */
ra1  = -6.93858572707181764372e-01, /* 0xBFE63416, 0xE4BA7360 */
ra2  = -1.05586262253232909814e+01, /* 0xC0251E04, 0x41B0E726 */
ra3  = -6.23753324503260060396e+01, /* 0xC04F300A, 0xE4CBA38D */
ra4  = -1.62396669462573470355e+02, /* 0xC0644CB1, 0x84282266 */
ra5  = -1.84605092906711035994e+02, /* 0xC067135C, 0xEBCCABB2 */
ra6  = -8.12874355063065934246e+01, /* 0xC0545265, 0x57E4D2F2 */
ra7  = -9.81432934416914548592e+00, /* 0xC023A0EF, 0xC69AC25C */
sa1  =  1.96512716674392571292e+01, /* 0x4033A6B9, 0xBD707687 */
sa2  =  1.37657754143519042600e+02, /* 0x4061350C, 0x526AE721 */
sa3  =  4.34565877475229228821e+02, /* 0x407B290D, 0xD58A1A71 */
sa4  =  6.45387271733267880336e+02, /* 0x40842B19, 0x21EC2868 */
sa5  =  4.29008140027567833386e+02, /* 0x407AD021, 0x57700314 */
sa6  =  1.08635005541779435134e+02, /* 0x405B28A3, 0xEE48AE2C */
sa7  =  6.57024977031928170135e+00, /* 0x401A47EF, 0x8E484A93 */
sa8  = -6.04244152148580987438e-02, /* 0xBFAEEFF2, 0xEE749A62 */
/*
 * Coefficients for approximation to  erfc in [1/.35,28]
 */
rb0  = -9.86494292470009928597e-03, /* 0xBF843412, 0x39E86F4A */
rb1  = -7.99283237680523006574e-01, /* 0xBFE993BA, 0x70C285DE */
rb2  = -1.77579549177547519889e+01, /* 0xC031C209, 0x555F995A */
rb3  = -1.60636384855821916062e+02, /* 0xC064145D, 0x43C5ED98 */
rb4  = -6.37566443368389627722e+02, /* 0xC083EC88, 0x1375F228 */
rb5  = -1.02509513161107724954e+03, /* 0xC0900461, 0x6A2E5992 */
rb6  = -4.83519191608651397019e+02, /* 0xC07E384E, 0x9BDC383F */
sb1  =  3.03380607434824582924e+01, /* 0x403E568B, 0x261D5190 */
sb2  =  3.25792512996573918826e+02, /* 0x40745CAE, 0x221B9F0A */
sb3  =  1.53672958608443695994e+03, /* 0x409802EB, 0x189D5118 */
sb4  =  3.19985821950859553908e+03, /* 0x40A8FFB7, 0x688C246A */
sb5  =  2.55305040643316442583e+03, /* 0x40A3F219, 0xCEDF3BE6 */
sb6  =  4.74528541206955367215e+02, /* 0x407DA874, 0xE79FE763 */
sb7  = -2.24409524465858183362e+01; /* 0xC03670E2, 0x42712D62 */

#if defined (__has_builtin) && __has_builtin (__builtin_gcn_fabsv)

DEF_VD_MATH_FUNC (v64df, erf, v64df x)
{
  FUNCTION_INIT (v64df);

  v64si hx;
  GET_HIGH_WORD (hx, x, NO_COND);
  v64si ix = hx & 0x7fffffff;

  VECTOR_IF (ix >= 0x7ff00000, cond)		/* erf(nan)=nan */
    v64si i = (hx >> 31) << 1;
    /* erf(+-inf)=+-1 */
    VECTOR_RETURN (__builtin_convertvector (1 - i, v64df) + one / x, cond);
  VECTOR_ENDIF

  VECTOR_IF (ix < 0x3feb0000, cond)			/* |x|<0.84375 */
    VECTOR_IF2 (ix < 0x3e300000, cond2, cond)		/* |x|<2**-28 */
      VECTOR_IF2 (ix < 0x00800000, cond3, cond2)	/* avoid underflow */
	VECTOR_RETURN (0.125*(8.0*x + efx8*x), cond3);
      VECTOR_ENDIF
      VECTOR_RETURN (x + efx*x, cond2);
    VECTOR_ENDIF

    v64df z = x*x;
    v64df r = pp0+z*(pp1+z*(pp2+z*(pp3+z*pp4)));
    v64df s = one+z*(qq1+z*(qq2+z*(qq3+z*(qq4+z*qq5))));
    v64df y = r/s;

    VECTOR_RETURN (x + x*y, cond);
  VECTOR_ENDIF

  VECTOR_IF (ix < 0x3ff40000, cond)	/* 0.84375 <= |x| < 1.25 */
    v64df s = __builtin_gcn_fabsv (x) - one;
    v64df P = pa0+s*(pa1+s*(pa2+s*(pa3+s*(pa4+s*(pa5+s*pa6)))));
    v64df Q = one+s*(qa1+s*(qa2+s*(qa3+s*(qa4+s*(qa5+s*qa6)))));
    VECTOR_IF2 (hx >= 0, cond2, cond)
      VECTOR_RETURN (erx + P/Q, cond2);
    VECTOR_ELSE2 (cond2, cond)
      VECTOR_RETURN (-erx - P/Q, cond2);
    VECTOR_ENDIF
  VECTOR_ENDIF

  VECTOR_IF (ix >= 0x40180000, cond)	/* inf>|x|>=6 */
    VECTOR_IF2 (hx >= 0, cond2, cond)
      VECTOR_RETURN (VECTOR_INIT (1.0 - tiny), cond2);
    VECTOR_ELSE2 (cond2, cond)
      VECTOR_RETURN (VECTOR_INIT (tiny - 1.0), cond2);
    VECTOR_ENDIF
  VECTOR_ENDIF

  x = __builtin_gcn_fabsv(x);
  v64df s = 1.0 / (x*x);
  v64df R, S;
  VECTOR_IF (ix < 0x4006DB6E, cond)	/* |x| < 1/0.35 */
    VECTOR_COND_MOVE (R, ra0+s*(ra1+s*(ra2+s*(ra3+s*(ra4+s*(
			 ra5+s*(ra6+s*ra7)))))), cond);
    VECTOR_COND_MOVE (S, one+s*(sa1+s*(sa2+s*(sa3+s*(sa4+s*(
			 sa5+s*(sa6+s*(sa7+s*sa8))))))), cond);
  VECTOR_ELSE (cond)			/* |x| >= 1/0.35 */
    VECTOR_COND_MOVE (R, rb0+s*(rb1+s*(rb2+s*(rb3+s*(rb4+s*(
			 rb5+s*rb6))))), cond);
    VECTOR_COND_MOVE (S, one+s*(sb1+s*(sb2+s*(sb3+s*(sb4+s*(
			 sb5+s*(sb6+s*sb7)))))), cond);
  VECTOR_ENDIF

  v64df z;
  SET_LOW_WORD (z, VECTOR_INIT(0), NO_COND);
  v64df r = v64df_exp_aux (-z*z - 0.5625, __mask)
            * v64df_exp_aux ((z-x)*(z+x) + R/S, __mask);
  VECTOR_RETURN (one - r/x, hx >= 0);
  VECTOR_RETURN (r/x - one, hx < 0);

  FUNCTION_RETURN;
}

DEF_VARIANTS (erf, df, df)

#endif
