#############################################################################
##
#W  mindeg.g             GAP 4 package AtlasRep                 Thomas Breuer
##
#Y  Copyright (C)  2007,   Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
##
##  This file contains the data concerning representations of minimal degree
##  for the groups that occur in the &ATLAS; of Group Representations.
##


#############################################################################
##
#V  MinimalRepresentationInfoData
##
BindGlobal( "MinimalRepresentationInfoData", rec() );

MinimalRepresentationInfoData.datalist:= [
# non-computed values
["2.B",["Characteristic",3],96256,"Jan05"],
["2.B",["Characteristic",5],96256,"Jan05"],
["2.B",["Characteristic",7],96256,"Jan05"],
["2.B",["Characteristic",11],96256,"HL89"],
["2.B",["Characteristic",13],96256,"Jan05"],
["2.B",["Characteristic",17],96256,"HL89"],
["2.B",["Characteristic",19],96256,"HL89"],
["2.B",["Characteristic",23],96256,"HL89"],
["2.B",["Characteristic",31],96256,"Jan05"],
["2.B",["Characteristic",47],96256,"Jan05"],
["2.Co1",["Characteristic",3],24,"Jan95"],
["2.Co1",["Characteristic",5],24,"Hen93"],
["2.Co1",["Characteristic",7],24,"HJLP"],
["2.Co1",["Characteristic",11],24,"HL89"],
["2.Co1",["Characteristic",13],24,"HL89"],
["2.Co1",["Characteristic",23],24,"HL89"],
["2.Fi22",["Characteristic",3],176,"Jan95"],
["2.Fi22",["Characteristic",5],352,"HW94"],
["2.Fi22",["Characteristic",7],352,"HL89"],
["2.Fi22",["Characteristic",11],352,"HL89"],
["2.Fi22",["Characteristic",13],352,"HL89"],
["2.Ru",["Characteristic",3],28,"His94"],
["2.Ru",["Characteristic",5],28,"HM95"],
["3.Fi22",["Characteristic",2],27,"Jan05"],
["3.Fi22",["Characteristic",5],351,"HW94"],
["3.Fi22",["Characteristic",7],351,"HL89"],
["3.Fi22",["Characteristic",11],351,"HL89"],
["3.Fi22",["Characteristic",13],351,"HL89"],
["3.Fi24'",["Characteristic",2],783,"Jan05"],
["3.Fi24'",["Characteristic",5],783,"Jan05"],
["3.Fi24'",["Characteristic",7],783,"Jan05"],
["3.Fi24'",["Characteristic",11],783,"HL89"],
["3.Fi24'",["Characteristic",13],783,"HL89"],
["3.Fi24'",["Characteristic",17],783,"HL89"],
["3.Fi24'",["Characteristic",23],783,"HL89"],
["3.Fi24'",["Characteristic",29],783,"HL89"],
["3.ON",["Characteristic",2],153,"JW98"],
["6.Fi22",["Characteristic",5],1728,"HW94"],
["6.Fi22",["Characteristic",7],1728,"HL89"],
["6.Fi22",["Characteristic",11],1728,"HL89"],
["6.Fi22",["Characteristic",13],1728,"HL89"],
["B",["Characteristic",2],4370,"Jan05"],
["B",["Characteristic",3],4371,"Jan05"],
["B",["Characteristic",5],4371,"Jan05"],
["B",["Characteristic",7],4371,"Jan05"],
["B",["Characteristic",11],4371,"HL89"],
["B",["Characteristic",13],4371,"HL89"],
["B",["Characteristic",17],4371,"HL89"],
["B",["Characteristic",19],4371,"Jan05"],
["B",["Characteristic",23],4371,"HL89"],
["B",["Characteristic",31],4371,"HL89"],
["B",["Characteristic",47],4371,"Jan05"],
["Co1",["Characteristic",2],24,"Jan05"],
["Co1",["Characteristic",3],276,"Jan95"],
["Co1",["Characteristic",5],276,"Jan05"],
["Co1",["Characteristic",7],276,"Jan05"],
["Co1",["Characteristic",11],276,"HL89"],
["Co1",["Characteristic",13],276,"HL89"],
["Co1",["Characteristic",23],276,"HL89"],
["Co2",["Characteristic",2],22,"MR99"],
["Co2",["Characteristic",2],22,"SW94"],
["Co2",["Characteristic",3],23,"Jan95"],
["Co2",["Characteristic",5],23,"HJLP"],
["Co3",["Characteristic",2],22,"SW97"],
["Co3",["Characteristic",3],22,"Jan95"],
["Co3",["Characteristic",5],23,"Mue98"],
["Fi22",["Characteristic",2],78,"Jan05"],
["Fi22",["Characteristic",3],77,"Jan95"],
["Fi22",["Characteristic",5],78,"HL94"],
["Fi22",["Characteristic",5],78,"HW94"],
["Fi22",["Characteristic",7],78,"HL89"],
["Fi22",["Characteristic",11],78,"HL89"],
["Fi22",["Characteristic",13],78,"HL89"],
["Fi23",["Characteristic",2],782,"Jan05"],
["Fi23",["Characteristic",3],253,"Jan95"],
["Fi23",["Characteristic",5],782,"HL94"],
["Fi23",["Characteristic",7],782,"HL89"],
["Fi23",["Characteristic",11],782,"HL89"],
["Fi23",["Characteristic",13],782,"HL89"],
["Fi23",["Characteristic",17],782,"HL89"],
["Fi23",["Characteristic",23],782,"HL89"],
["Fi24'",["Characteristic",2],3774,"Jan05"],
["Fi24'",["Characteristic",3],781,"Jan95"],
["Fi24'",["Characteristic",5],8671,"Jan05"],
["Fi24'",["Characteristic",7],8671,"Jan05"],
["Fi24'",["Characteristic",11],8671,"HL89"],
["Fi24'",["Characteristic",13],8671,"HL89"],
["Fi24'",["Characteristic",17],8671,"HL89"],
["Fi24'",["Characteristic",23],8671,"HL89"],
["Fi24'",["Characteristic",29],8671,"HL89"],
["HN",["Characteristic",2],132,"Jan05"],
["HN",["Characteristic",3],133,"Jan95"],
["HN",["Characteristic",5],133,"Jan05"],
["HN",["Characteristic",7],133,"HL89"],
["HN",["Characteristic",11],133,"HL89"],
["HN",["Characteristic",19],133,"HL89"],
["He",["Characteristic",3],51,"Jan95"],
["He",["Characteristic",7],50,"Ryb88"],
["J4",["Characteristic",2],112,"Jan05"],
["J4",["Characteristic",3],1333,"Jan95"],
["J4",["Characteristic",5],1333,"HL89"],
["J4",["Characteristic",7],1333,"HL89"],
["J4",["Characteristic",11],1333,"Jan05"],
["J4",["Characteristic",23],1333,"HL89"],
["J4",["Characteristic",29],1333,"HL89"],
["J4",["Characteristic",31],1333,"HL89"],
["J4",["Characteristic",37],1333,"HL89"],
["J4",["Characteristic",43],1333,"HL89"],
["L3(5).2","NrMovedPoints",62,"CCNPW85"],
["Ly",["Characteristic",2],2480,"Jan05"],
["Ly",["Characteristic",3],651,"Jan95"],
["Ly",["Characteristic",5],111,"MNP85"],
["Ly",["Characteristic",7],2480,"HL89"],
["Ly",["Characteristic",11],2480,"HL89"],
["Ly",["Characteristic",31],2480,"HL89"],
["Ly",["Characteristic",37],2480,"HL89"],
["Ly",["Characteristic",67],2480,"HL89"],
["M",["Characteristic",2],196882,"GS94"],
["M",["Characteristic",3],196882,"GS94"],
["M",["Characteristic",5],196883,"GS94"],
["M",["Characteristic",7],196883,"GS94"],
["M",["Characteristic",11],196883,"GS94"],
["M",["Characteristic",13],196883,"GS94"],
["M",["Characteristic",29],196883,"GS94"],
["M",["Characteristic",41],196883,"GS94"],
["M",["Characteristic",47],196883,"GS94"],
["M",["Characteristic",59],196883,"GS94"],
["M",["Characteristic",71],196883,"GS94"],
["O8+(3).S4","NrMovedPoints",3360,"CCNPW85"],
["O8-(3)","NrMovedPoints",1066,"CCNPW85"],
["O8-(3).2^2","NrMovedPoints",1066,"CCNPW85"],
["O8-(3).2_1","NrMovedPoints",1066,"CCNPW85"],
["O8-(3).2_3","NrMovedPoints",1066,"CCNPW85"],
["ON",["Characteristic",2],10944,"JW98"],
["ON",["Characteristic",3],154,"JW98"],
["ON",["Characteristic",7],406,"HHM99"],
["ON.2","NrMovedPoints",245520,"CCNPW85"],
["R(27)","NrMovedPoints",19684,"CCNPW85"],
["R(27).3","NrMovedPoints",19684,"CCNPW85"],
["Ru",["Characteristic",3],378,"His94"],
["Ru",["Characteristic",5],133,"HM95"],
["S4(4).4","NrMovedPoints",170,"CCNPW85"],
["Suz",["Characteristic",3],64,"JM97"],
["Th",["Characteristic",2],248,"Jan05"],
["Th",["Characteristic",3],248,"Jan95"],
["Th",["Characteristic",5],248,"Jan05"],
["Th",["Characteristic",7],248,"Jan05"],
["Th",["Characteristic",13],248,"HL89"],
["Th",["Characteristic",19],248,"HL89"],
["Th",["Characteristic",31],248,"HL89"],
["U3(8).(S3x3)","NrMovedPoints",513,"CCNPW85"],
["U3(8).3^2","NrMovedPoints",513,"CCNPW85"],
["U6(2).S3","NrMovedPoints",672,"CCNPW85"],

# computed values
["2.(2xF4(2)).2",["Characteristic",0],52,"computed (char. table)"],
["2.2E6(2)",["Characteristic",0],2432,"computed (char. table)"],
["2.2E6(2)",["Characteristic",11],2432,"computed (char. table)"],
["2.2E6(2)",["Characteristic",13],2432,"computed (char. table)"],
["2.2E6(2)",["Characteristic",17],2432,"computed (char. table)"],
["2.2E6(2)",["Characteristic",19],2432,"computed (char. table)"],
["2.2E6(2)",["Size",11],2432,"computed (char. table)"],
["2.2E6(2)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.2E6(2)",["Size",13],2432,"computed (char. table)"],
["2.2E6(2)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.2E6(2)",["Size",17],2432,"computed (char. table)"],
["2.2E6(2)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["2.2E6(2)",["Size",19],2432,"computed (char. table)"],
["2.2E6(2)",["Characteristic",19,"complete"],true,"computed (char. table)"],
["2.2E6(2).2",["Characteristic",0],2432,"computed (char. table)"],
["2.2E6(2).2",["Characteristic",11],2432,"computed (char. table)"],
["2.2E6(2).2",["Characteristic",13],2432,"computed (char. table)"],
["2.2E6(2).2",["Characteristic",17],2432,"computed (char. table)"],
["2.2E6(2).2",["Characteristic",19],2432,"computed (char. table)"],
["2.2E6(2).2",["Size",11],2432,"computed (char. table)"],
["2.2E6(2).2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.2E6(2).2",["Size",13],2432,"computed (char. table)"],
["2.2E6(2).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.2E6(2).2",["Size",17],2432,"computed (char. table)"],
["2.2E6(2).2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["2.2E6(2).2",["Size",19],2432,"computed (char. table)"],
["2.2E6(2).2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["2.A10",["Characteristic",0],16,"computed (char. table)"],
["2.A10",["Characteristic",3],16,"computed (char. table)"],
["2.A10",["Characteristic",5],8,"computed (char. table)"],
["2.A10",["Characteristic",7],16,"computed (char. table)"],
["2.A10",["Size",3],16,"computed (char. table)"],
["2.A10",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A10",["Size",5],8,"computed (char. table)"],
["2.A10",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A10",["Size",7],16,"computed (char. table)"],
["2.A10",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A10.2",["Characteristic",0],16,"computed (char. table)"],
["2.A10.2",["Characteristic",3],16,"computed (char. table)"],
["2.A10.2",["Characteristic",5],16,"computed (char. table)"],
["2.A10.2",["Characteristic",7],16,"computed (char. table)"],
["2.A10.2",["Size",3],32,"computed (char. table)"],
["2.A10.2",["Size",9],16,"computed (char. table)"],
["2.A10.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A10.2",["Size",5],16,"computed (char. table)"],
["2.A10.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A10.2",["Size",7],32,"computed (char. table)"],
["2.A10.2",["Size",49],16,"computed (char. table)"],
["2.A10.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A11",["Characteristic",0],16,"computed (char. table)"],
["2.A11",["Characteristic",3],16,"computed (char. table)"],
["2.A11",["Characteristic",5],16,"computed (char. table)"],
["2.A11",["Characteristic",7],16,"computed (char. table)"],
["2.A11",["Characteristic",11],16,"computed (char. table)"],
["2.A11",["Size",3],16,"computed (char. table)"],
["2.A11",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A11",["Size",5],16,"computed (char. table)"],
["2.A11",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A11",["Size",7],32,"computed (char. table)"],
["2.A11",["Size",49],16,"computed (char. table)"],
["2.A11",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A11",["Size",11],16,"computed (char. table)"],
["2.A11",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.A11.2",["Characteristic",0],32,"computed (char. table)"],
["2.A11.2",["Characteristic",3],32,"computed (char. table)"],
["2.A11.2",["Characteristic",5],32,"computed (char. table)"],
["2.A11.2",["Characteristic",7],32,"computed (char. table)"],
["2.A11.2",["Characteristic",11],16,"computed (char. table)"],
["2.A11.2",["Size",3],32,"computed (char. table)"],
["2.A11.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A11.2",["Size",5],32,"computed (char. table)"],
["2.A11.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A11.2",["Size",7],32,"computed (char. table)"],
["2.A11.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A11.2",["Size",11],16,"computed (char. table)"],
["2.A11.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.A12",["Characteristic",0],32,"computed (char. table)"],
["2.A12",["Characteristic",3],16,"computed (char. table)"],
["2.A12",["Characteristic",5],32,"computed (char. table)"],
["2.A12",["Characteristic",7],32,"computed (char. table)"],
["2.A12",["Characteristic",11],32,"computed (char. table)"],
["2.A12",["Size",3],16,"computed (char. table)"],
["2.A12",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A12",["Size",5],32,"computed (char. table)"],
["2.A12",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A12",["Size",7],32,"computed (char. table)"],
["2.A12",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A12",["Size",11],32,"computed (char. table)"],
["2.A12",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.A12.2",["Characteristic",0],32,"computed (char. table)"],
["2.A12.2",["Characteristic",3],32,"computed (char. table)"],
["2.A12.2",["Characteristic",5],32,"computed (char. table)"],
["2.A12.2",["Characteristic",7],32,"computed (char. table)"],
["2.A12.2",["Characteristic",11],32,"computed (char. table)"],
["2.A12.2",["Size",3],32,"computed (char. table)"],
["2.A12.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A12.2",["Size",5],32,"computed (char. table)"],
["2.A12.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A12.2",["Size",7],32,"computed (char. table)"],
["2.A12.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A12.2",["Size",11],32,"computed (char. table)"],
["2.A12.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.A13",["Characteristic",0],32,"computed (char. table)"],
["2.A13",["Characteristic",3],32,"computed (char. table)"],
["2.A13",["Characteristic",5],32,"computed (char. table)"],
["2.A13",["Characteristic",7],32,"computed (char. table)"],
["2.A13",["Characteristic",11],32,"computed (char. table)"],
["2.A13",["Characteristic",13],32,"computed (char. table)"],
["2.A13",["Size",3],32,"computed (char. table)"],
["2.A13",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A13",["Size",5],64,"computed (char. table)"],
["2.A13",["Size",25],32,"computed (char. table)"],
["2.A13",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A13",["Size",7],64,"computed (char. table)"],
["2.A13",["Size",49],32,"computed (char. table)"],
["2.A13",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A13",["Size",11],64,"computed (char. table)"],
["2.A13",["Size",121],32,"computed (char. table)"],
["2.A13",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.A13",["Size",13],32,"computed (char. table)"],
["2.A13",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.A13.2",["Characteristic",0],64,"computed (char. table)"],
["2.A13.2",["Characteristic",3],64,"computed (char. table)"],
["2.A13.2",["Characteristic",5],64,"computed (char. table)"],
["2.A13.2",["Characteristic",7],64,"computed (char. table)"],
["2.A13.2",["Characteristic",11],64,"computed (char. table)"],
["2.A13.2",["Characteristic",13],32,"computed (char. table)"],
["2.A13.2",["Size",3],64,"computed (char. table)"],
["2.A13.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A13.2",["Size",5],64,"computed (char. table)"],
["2.A13.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A13.2",["Size",7],64,"computed (char. table)"],
["2.A13.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A13.2",["Size",11],64,"computed (char. table)"],
["2.A13.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.A13.2",["Size",13],64,"computed (char. table)"],
["2.A13.2",["Size",169],32,"computed (char. table)"],
["2.A13.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.A14.2",["Characteristic",0],64,"computed (char. table)"],
["2.A5","NrMovedPoints",24,"computed (table of marks)"],
["2.A5",["Characteristic",0],2,"computed (char. table)"],
["2.A5",["Characteristic",3],2,"computed (char. table)"],
["2.A5",["Characteristic",5],2,"computed (char. table)"],
["2.A5",["Size",3],4,"computed (char. table)"],
["2.A5",["Size",9],2,"computed (char. table)"],
["2.A5",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A5",["Size",5],2,"computed (char. table)"],
["2.A5",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A5.2","NrMovedPoints",40,"computed (table of marks)"],
["2.A5.2",["Characteristic",0],4,"computed (char. table)"],
["2.A5.2",["Characteristic",3],4,"computed (char. table)"],
["2.A5.2",["Characteristic",5],2,"computed (char. table)"],
["2.A5.2",["Size",3],4,"computed (char. table)"],
["2.A5.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A5.2",["Size",5],4,"computed (char. table)"],
["2.A5.2",["Size",25],2,"computed (char. table)"],
["2.A5.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A6","NrMovedPoints",80,"computed (table of marks)"],
["2.A6",["Characteristic",0],4,"computed (char. table)"],
["2.A6",["Characteristic",3],2,"computed (char. table)"],
["2.A6",["Characteristic",5],4,"computed (char. table)"],
["2.A6",["Size",3],4,"computed (char. table)"],
["2.A6",["Size",9],2,"computed (char. table)"],
["2.A6",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A6",["Size",5],4,"computed (char. table)"],
["2.A6",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A6.2_1","NrMovedPoints",80,"computed (subgroup tables, known repres.)"],
["2.A6.2_1","NrMovedPoints",80,"computed (table of marks)"],
["2.A6.2_1",["Characteristic",0],4,"computed (char. table)"],
["2.A6.2_1",["Characteristic",3],4,"computed (char. table)"],
["2.A6.2_1",["Characteristic",5],4,"computed (char. table)"],
["2.A6.2_1",["Size",3],4,"computed (char. table)"],
["2.A6.2_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A6.2_1",["Size",5],8,"computed (char. table)"],
["2.A6.2_1",["Size",25],4,"computed (char. table)"],
["2.A6.2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A7","NrMovedPoints",240,"computed (table of marks)"],
["2.A7",["Characteristic",0],4,"computed (char. table)"],
["2.A7",["Characteristic",3],4,"computed (char. table)"],
["2.A7",["Characteristic",5],4,"computed (char. table)"],
["2.A7",["Characteristic",7],4,"computed (char. table)"],
["2.A7",["Size",3],8,"computed (char. table)"],
["2.A7",["Size",9],4,"computed (char. table)"],
["2.A7",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A7",["Size",5],8,"computed (char. table)"],
["2.A7",["Size",25],4,"computed (char. table)"],
["2.A7",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A7",["Size",7],4,"computed (char. table)"],
["2.A7",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A7.2",["Characteristic",0],8,"computed (char. table)"],
["2.A7.2",["Characteristic",3],8,"computed (char. table)"],
["2.A7.2",["Characteristic",5],8,"computed (char. table)"],
["2.A7.2",["Characteristic",7],4,"computed (char. table)"],
["2.A7.2",["Size",3],8,"computed (char. table)"],
["2.A7.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A7.2",["Size",5],8,"computed (char. table)"],
["2.A7.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A7.2",["Size",7],8,"computed (char. table)"],
["2.A7.2",["Size",49],4,"computed (char. table)"],
["2.A7.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A8","NrMovedPoints",240,"computed (subgroup tables, known repres.)"],
["2.A8","NrMovedPoints",240,"computed (table of marks)"],
["2.A8",["Characteristic",0],8,"computed (char. table)"],
["2.A8",["Characteristic",3],8,"computed (char. table)"],
["2.A8",["Characteristic",5],8,"computed (char. table)"],
["2.A8",["Characteristic",7],8,"computed (char. table)"],
["2.A8",["Size",3],8,"computed (char. table)"],
["2.A8",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A8",["Size",5],8,"computed (char. table)"],
["2.A8",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A8",["Size",7],8,"computed (char. table)"],
["2.A8",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A8.2",["Characteristic",0],8,"computed (char. table)"],
["2.A8.2",["Characteristic",3],8,"computed (char. table)"],
["2.A8.2",["Characteristic",5],8,"computed (char. table)"],
["2.A8.2",["Characteristic",7],8,"computed (char. table)"],
["2.A8.2",["Size",3],16,"computed (char. table)"],
["2.A8.2",["Size",9],8,"computed (char. table)"],
["2.A8.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A8.2",["Size",5],8,"computed (char. table)"],
["2.A8.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A8.2",["Size",7],16,"computed (char. table)"],
["2.A8.2",["Size",49],8,"computed (char. table)"],
["2.A8.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A9",["Characteristic",0],8,"computed (char. table)"],
["2.A9",["Characteristic",3],8,"computed (char. table)"],
["2.A9",["Characteristic",5],8,"computed (char. table)"],
["2.A9",["Characteristic",7],8,"computed (char. table)"],
["2.A9",["Size",3],8,"computed (char. table)"],
["2.A9",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A9",["Size",5],8,"computed (char. table)"],
["2.A9",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A9",["Size",7],8,"computed (char. table)"],
["2.A9",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.A9.2",["Characteristic",0],16,"computed (char. table)"],
["2.A9.2",["Characteristic",3],8,"computed (char. table)"],
["2.A9.2",["Characteristic",5],16,"computed (char. table)"],
["2.A9.2",["Characteristic",7],16,"computed (char. table)"],
["2.A9.2",["Size",3],16,"computed (char. table)"],
["2.A9.2",["Size",9],8,"computed (char. table)"],
["2.A9.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.A9.2",["Size",5],16,"computed (char. table)"],
["2.A9.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.A9.2",["Size",7],16,"computed (char. table)"],
["2.A9.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.B",["Characteristic",0],96256,"computed (char. table)"],
["2.B",["Characteristic",11],96256,"computed (char. table)"],
["2.B",["Characteristic",17],96256,"computed (char. table)"],
["2.B",["Characteristic",23],96256,"computed (char. table)"],
["2.Co1",["Characteristic",0],24,"computed (char. table)"],
["2.Co1",["Characteristic",7],24,"computed (char. table)"],
["2.Co1",["Characteristic",11],24,"computed (char. table)"],
["2.Co1",["Characteristic",13],24,"computed (char. table)"],
["2.Co1",["Characteristic",23],24,"computed (char. table)"],
["2.Co1",["Size",7],24,"computed (char. table)"],
["2.Co1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.Co1",["Size",11],24,"computed (char. table)"],
["2.Co1",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.Co1",["Size",13],24,"computed (char. table)"],
["2.Co1",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.Co1",["Size",23],24,"computed (char. table)"],
["2.Co1",["Characteristic",23,"complete"],true,"computed (char. table)"],
["2.F4(2)",["Characteristic",0],52,"computed (char. table)"],
["2.F4(2)",["Characteristic",5],52,"computed (char. table)"],
["2.F4(2)",["Characteristic",7],52,"computed (char. table)"],
["2.F4(2)",["Characteristic",13],52,"computed (char. table)"],
["2.F4(2)",["Characteristic",17],52,"computed (char. table)"],
["2.F4(2)",["Size",5],52,"computed (char. table)"],
["2.F4(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.F4(2)",["Size",7],52,"computed (char. table)"],
["2.F4(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.F4(2)",["Size",13],52,"computed (char. table)"],
["2.F4(2)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.F4(2)",["Size",17],52,"computed (char. table)"],
["2.F4(2)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["2.F4(2).2",["Characteristic",0],52,"computed (char. table)"],
["2.F4(2).2",["Characteristic",13],52,"computed (char. table)"],
["2.F4(2).2",["Size",13],104,"computed (char. table)"],
["2.F4(2).2",["Size",169],52,"computed (char. table)"],
["2.F4(2).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.Fi22",["Characteristic",0],352,"computed (char. table)"],
["2.Fi22",["Characteristic",3],176,"computed (char. table)"],
["2.Fi22",["Characteristic",5],352,"computed (char. table)"],
["2.Fi22",["Characteristic",7],352,"computed (char. table)"],
["2.Fi22",["Characteristic",11],352,"computed (char. table)"],
["2.Fi22",["Characteristic",13],352,"computed (char. table)"],
["2.Fi22",["Size",3],176,"computed (char. table)"],
["2.Fi22",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.Fi22",["Size",5],352,"computed (char. table)"],
["2.Fi22",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.Fi22",["Size",7],352,"computed (char. table)"],
["2.Fi22",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.Fi22",["Size",11],352,"computed (char. table)"],
["2.Fi22",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.Fi22",["Size",13],352,"computed (char. table)"],
["2.Fi22",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.Fi22.2",["Characteristic",0],352,"computed (char. table)"],
["2.Fi22.2",["Characteristic",3],352,"computed (char. table)"],
["2.Fi22.2",["Characteristic",5],352,"computed (char. table)"],
["2.Fi22.2",["Characteristic",7],352,"computed (char. table)"],
["2.Fi22.2",["Characteristic",11],352,"computed (char. table)"],
["2.Fi22.2",["Characteristic",13],352,"computed (char. table)"],
["2.Fi22.2",["Size",3],352,"computed (char. table)"],
["2.Fi22.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.Fi22.2",["Size",5],704,"computed (char. table)"],
["2.Fi22.2",["Size",25],352,"computed (char. table)"],
["2.Fi22.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.Fi22.2",["Size",7],352,"computed (char. table)"],
["2.Fi22.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.Fi22.2",["Size",11],704,"computed (char. table)"],
["2.Fi22.2",["Size",121],352,"computed (char. table)"],
["2.Fi22.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.Fi22.2",["Size",13],352,"computed (char. table)"],
["2.Fi22.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.G2(4)",["Characteristic",0],12,"computed (char. table)"],
["2.G2(4)",["Characteristic",3],12,"computed (char. table)"],
["2.G2(4)",["Characteristic",5],12,"computed (char. table)"],
["2.G2(4)",["Characteristic",7],12,"computed (char. table)"],
["2.G2(4)",["Characteristic",13],12,"computed (char. table)"],
["2.G2(4)",["Size",3],12,"computed (char. table)"],
["2.G2(4)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.G2(4)",["Size",5],12,"computed (char. table)"],
["2.G2(4)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.G2(4)",["Size",7],12,"computed (char. table)"],
["2.G2(4)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.G2(4)",["Size",13],12,"computed (char. table)"],
["2.G2(4)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.G2(4).2",["Characteristic",0],12,"computed (char. table)"],
["2.G2(4).2",["Characteristic",3],12,"computed (char. table)"],
["2.G2(4).2",["Characteristic",5],12,"computed (char. table)"],
["2.G2(4).2",["Characteristic",7],12,"computed (char. table)"],
["2.G2(4).2",["Characteristic",13],12,"computed (char. table)"],
["2.G2(4).2",["Size",3],24,"computed (char. table)"],
["2.G2(4).2",["Size",9],12,"computed (char. table)"],
["2.G2(4).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.G2(4).2",["Size",5],24,"computed (char. table)"],
["2.G2(4).2",["Size",25],12,"computed (char. table)"],
["2.G2(4).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.G2(4).2",["Size",7],12,"computed (char. table)"],
["2.G2(4).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.G2(4).2",["Size",13],24,"computed (char. table)"],
["2.G2(4).2",["Size",169],12,"computed (char. table)"],
["2.G2(4).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.HS",["Characteristic",0],56,"computed (char. table)"],
["2.HS",["Characteristic",3],56,"computed (char. table)"],
["2.HS",["Characteristic",5],28,"computed (char. table)"],
["2.HS",["Characteristic",7],56,"computed (char. table)"],
["2.HS",["Characteristic",11],56,"computed (char. table)"],
["2.HS",["Size",3],56,"computed (char. table)"],
["2.HS",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.HS",["Size",5],28,"computed (char. table)"],
["2.HS",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.HS",["Size",7],56,"computed (char. table)"],
["2.HS",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.HS",["Size",11],56,"computed (char. table)"],
["2.HS",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.HS.2",["Characteristic",0],56,"computed (char. table)"],
["2.HS.2",["Characteristic",3],56,"computed (char. table)"],
["2.HS.2",["Characteristic",5],56,"computed (char. table)"],
["2.HS.2",["Characteristic",7],56,"computed (char. table)"],
["2.HS.2",["Characteristic",11],56,"computed (char. table)"],
["2.HS.2",["Size",3],112,"computed (char. table)"],
["2.HS.2",["Size",9],56,"computed (char. table)"],
["2.HS.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.HS.2",["Size",5],56,"computed (char. table)"],
["2.HS.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.HS.2",["Size",7],112,"computed (char. table)"],
["2.HS.2",["Size",49],56,"computed (char. table)"],
["2.HS.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.HS.2",["Size",11],56,"computed (char. table)"],
["2.HS.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.J2","NrMovedPoints",200,"computed (factor table)"],
["2.J2",["Characteristic",0],6,"computed (char. table)"],
["2.J2",["Characteristic",3],6,"computed (char. table)"],
["2.J2",["Characteristic",5],6,"computed (char. table)"],
["2.J2",["Characteristic",7],6,"computed (char. table)"],
["2.J2",["Size",3],12,"computed (char. table)"],
["2.J2",["Size",9],6,"computed (char. table)"],
["2.J2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.J2",["Size",5],6,"computed (char. table)"],
["2.J2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.J2",["Size",7],12,"computed (char. table)"],
["2.J2",["Size",49],6,"computed (char. table)"],
["2.J2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.J2.2",["Characteristic",0],12,"computed (char. table)"],
["2.J2.2",["Characteristic",3],12,"computed (char. table)"],
["2.J2.2",["Characteristic",5],6,"computed (char. table)"],
["2.J2.2",["Characteristic",7],12,"computed (char. table)"],
["2.J2.2",["Size",3],12,"computed (char. table)"],
["2.J2.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.J2.2",["Size",5],12,"computed (char. table)"],
["2.J2.2",["Size",25],6,"computed (char. table)"],
["2.J2.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.J2.2",["Size",7],12,"computed (char. table)"],
["2.J2.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.L2(11)",["Characteristic",0],6,"computed (char. table)"],
["2.L2(11)",["Characteristic",3],6,"computed (char. table)"],
["2.L2(11)",["Characteristic",5],6,"computed (char. table)"],
["2.L2(11)",["Characteristic",11],2,"computed (char. table)"],
["2.L2(11)",["Size",3],6,"computed (char. table)"],
["2.L2(11)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(11)",["Size",5],6,"computed (char. table)"],
["2.L2(11)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.L2(11)",["Size",11],2,"computed (char. table)"],
["2.L2(11)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.L2(13)",["Characteristic",0],6,"computed (char. table)"],
["2.L2(13)",["Characteristic",3],6,"computed (char. table)"],
["2.L2(13)",["Characteristic",7],6,"computed (char. table)"],
["2.L2(13)",["Characteristic",13],2,"computed (char. table)"],
["2.L2(13)",["Size",3],6,"computed (char. table)"],
["2.L2(13)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(13)",["Size",7],12,"computed (char. table)"],
["2.L2(13)",["Size",49],6,"computed (char. table)"],
["2.L2(13)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.L2(13)",["Size",13],2,"computed (char. table)"],
["2.L2(13)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.L2(13).2",["Characteristic",0],12,"computed (char. table)"],
["2.L2(13).2",["Characteristic",3],12,"computed (char. table)"],
["2.L2(13).2",["Characteristic",7],12,"computed (char. table)"],
["2.L2(13).2",["Characteristic",13],2,"computed (char. table)"],
["2.L2(13).2",["Size",3],12,"computed (char. table)"],
["2.L2(13).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(13).2",["Size",7],12,"computed (char. table)"],
["2.L2(13).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.L2(13).2",["Size",13],4,"computed (char. table)"],
["2.L2(13).2",["Size",169],2,"computed (char. table)"],
["2.L2(13).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.L2(17)",["Characteristic",0],8,"computed (char. table)"],
["2.L2(17)",["Characteristic",3],8,"computed (char. table)"],
["2.L2(17)",["Characteristic",17],2,"computed (char. table)"],
["2.L2(17)",["Size",3],16,"computed (char. table)"],
["2.L2(17)",["Size",9],8,"computed (char. table)"],
["2.L2(17)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(17)",["Size",17],2,"computed (char. table)"],
["2.L2(17)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["2.L2(17).2",["Characteristic",0],16,"computed (char. table)"],
["2.L2(17).2",["Characteristic",3],16,"computed (char. table)"],
["2.L2(17).2",["Characteristic",17],2,"computed (char. table)"],
["2.L2(17).2",["Size",3],16,"computed (char. table)"],
["2.L2(17).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(17).2",["Size",17],4,"computed (char. table)"],
["2.L2(17).2",["Size",289],2,"computed (char. table)"],
["2.L2(17).2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["2.L2(19)",["Characteristic",0],10,"computed (char. table)"],
["2.L2(19)",["Characteristic",3],10,"computed (char. table)"],
["2.L2(19)",["Characteristic",5],10,"computed (char. table)"],
["2.L2(19)",["Characteristic",19],2,"computed (char. table)"],
["2.L2(19)",["Size",3],18,"computed (char. table)"],
["2.L2(19)",["Size",9],10,"computed (char. table)"],
["2.L2(19)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(19)",["Size",5],10,"computed (char. table)"],
["2.L2(19)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.L2(19)",["Size",19],2,"computed (char. table)"],
["2.L2(19)",["Characteristic",19,"complete"],true,"computed (char. table)"],
["2.L2(23)",["Characteristic",0],12,"computed (char. table)"],
["2.L2(23)",["Characteristic",3],12,"computed (char. table)"],
["2.L2(23)",["Characteristic",11],12,"computed (char. table)"],
["2.L2(23)",["Characteristic",23],2,"computed (char. table)"],
["2.L2(23)",["Size",3],12,"computed (char. table)"],
["2.L2(23)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(23)",["Size",11],24,"computed (char. table)"],
["2.L2(23)",["Size",121],12,"computed (char. table)"],
["2.L2(23)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.L2(23)",["Size",23],2,"computed (char. table)"],
["2.L2(23)",["Characteristic",23,"complete"],true,"computed (char. table)"],
["2.L2(25)",["Characteristic",0],12,"computed (char. table)"],
["2.L2(25)",["Characteristic",3],12,"computed (char. table)"],
["2.L2(25)",["Characteristic",5],2,"computed (char. table)"],
["2.L2(25)",["Characteristic",13],12,"computed (char. table)"],
["2.L2(25)",["Size",3],12,"computed (char. table)"],
["2.L2(25)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(25)",["Size",5],4,"computed (char. table)"],
["2.L2(25)",["Size",25],2,"computed (char. table)"],
["2.L2(25)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.L2(25)",["Size",13],12,"computed (char. table)"],
["2.L2(25)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.L2(27)",["Characteristic",0],14,"computed (char. table)"],
["2.L2(27)",["Characteristic",3],2,"computed (char. table)"],
["2.L2(27)",["Characteristic",7],14,"computed (char. table)"],
["2.L2(27)",["Characteristic",13],14,"computed (char. table)"],
["2.L2(27)",["Size",3],6,"computed (char. table)"],
["2.L2(27)",["Size",27],2,"computed (char. table)"],
["2.L2(27)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(27)",["Size",7],14,"computed (char. table)"],
["2.L2(27)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.L2(27)",["Size",13],14,"computed (char. table)"],
["2.L2(27)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.L2(29)",["Characteristic",0],14,"computed (char. table)"],
["2.L2(29)",["Characteristic",3],14,"computed (char. table)"],
["2.L2(29)",["Characteristic",5],14,"computed (char. table)"],
["2.L2(29)",["Characteristic",7],14,"computed (char. table)"],
["2.L2(29)",["Characteristic",29],2,"computed (char. table)"],
["2.L2(29)",["Size",3],28,"computed (char. table)"],
["2.L2(29)",["Size",9],14,"computed (char. table)"],
["2.L2(29)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(29)",["Size",5],14,"computed (char. table)"],
["2.L2(29)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.L2(29)",["Size",7],14,"computed (char. table)"],
["2.L2(29)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.L2(29)",["Size",29],2,"computed (char. table)"],
["2.L2(29)",["Characteristic",29,"complete"],true,"computed (char. table)"],
["2.L2(31)",["Characteristic",0],16,"computed (char. table)"],
["2.L2(31)",["Characteristic",3],16,"computed (char. table)"],
["2.L2(31)",["Characteristic",5],16,"computed (char. table)"],
["2.L2(31)",["Characteristic",31],2,"computed (char. table)"],
["2.L2(31)",["Size",3],32,"computed (char. table)"],
["2.L2(31)",["Size",9],16,"computed (char. table)"],
["2.L2(31)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(31)",["Size",5],16,"computed (char. table)"],
["2.L2(31)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.L2(31)",["Size",31],2,"computed (char. table)"],
["2.L2(31)",["Characteristic",31,"complete"],true,"computed (char. table)"],
["2.L2(49)",["Characteristic",0],24,"computed (char. table)"],
["2.L2(49)",["Characteristic",3],24,"computed (char. table)"],
["2.L2(49)",["Characteristic",5],24,"computed (char. table)"],
["2.L2(49)",["Size",3],24,"computed (char. table)"],
["2.L2(49)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L2(49)",["Size",5],24,"computed (char. table)"],
["2.L2(49)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.L3(2)",["Characteristic",0],4,"computed (char. table)"],
["2.L3(2)",["Characteristic",3],4,"computed (char. table)"],
["2.L3(2)",["Characteristic",7],2,"computed (char. table)"],
["2.L3(2)",["Size",3],8,"computed (char. table)"],
["2.L3(2)",["Size",9],4,"computed (char. table)"],
["2.L3(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L3(2)",["Size",7],2,"computed (char. table)"],
["2.L3(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.L3(2).2",["Characteristic",0],6,"computed (char. table)"],
["2.L3(2).2",["Characteristic",3],6,"computed (char. table)"],
["2.L3(2).2",["Characteristic",7],2,"computed (char. table)"],
["2.L3(2).2",["Size",3],8,"computed (char. table)"],
["2.L3(2).2",["Size",81],6,"computed (char. table)"],
["2.L3(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L3(2).2",["Size",7],4,"computed (char. table)"],
["2.L3(2).2",["Size",49],2,"computed (char. table)"],
["2.L3(2).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.L3(4)",["Characteristic",0],10,"computed (char. table)"],
["2.L3(4)",["Characteristic",3],6,"computed (char. table)"],
["2.L3(4)",["Characteristic",5],10,"computed (char. table)"],
["2.L3(4)",["Characteristic",7],10,"computed (char. table)"],
["2.L3(4)",["Size",3],6,"computed (char. table)"],
["2.L3(4)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L3(4)",["Size",5],20,"computed (char. table)"],
["2.L3(4)",["Size",25],10,"computed (char. table)"],
["2.L3(4)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.L3(4)",["Size",7],10,"computed (char. table)"],
["2.L3(4)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.L3(4).2_1",["Characteristic",0],20,"computed (char. table)"],
["2.L3(4).2_1",["Characteristic",3],6,"computed (char. table)"],
["2.L3(4).2_1",["Characteristic",5],20,"computed (char. table)"],
["2.L3(4).2_1",["Characteristic",7],10,"computed (char. table)"],
["2.L3(4).2_1",["Size",3],12,"computed (char. table)"],
["2.L3(4).2_1",["Size",9],6,"computed (char. table)"],
["2.L3(4).2_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.L3(4).2_1",["Size",5],20,"computed (char. table)"],
["2.L3(4).2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.L3(4).2_1",["Size",7],10,"computed (char. table)"],
["2.L3(4).2_1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.M12","NrMovedPoints",24,"computed (factor table)"],
["2.M12",["Characteristic",0],10,"computed (char. table)"],
["2.M12",["Characteristic",3],6,"computed (char. table)"],
["2.M12",["Characteristic",5],10,"computed (char. table)"],
["2.M12",["Characteristic",11],10,"computed (char. table)"],
["2.M12",["Size",3],6,"computed (char. table)"],
["2.M12",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.M12",["Size",5],12,"computed (char. table)"],
["2.M12",["Size",25],10,"computed (char. table)"],
["2.M12",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.M12",["Size",11],10,"computed (char. table)"],
["2.M12",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.M12.2",["Characteristic",0],10,"computed (char. table)"],
["2.M12.2",["Characteristic",3],10,"computed (char. table)"],
["2.M12.2",["Characteristic",5],10,"computed (char. table)"],
["2.M12.2",["Characteristic",11],10,"computed (char. table)"],
["2.M12.2",["Size",3],10,"computed (char. table)"],
["2.M12.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.M12.2",["Size",5],20,"computed (char. table)"],
["2.M12.2",["Size",25],10,"computed (char. table)"],
["2.M12.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.M12.2",["Size",11],10,"computed (char. table)"],
["2.M12.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.M22",["Characteristic",0],10,"computed (char. table)"],
["2.M22",["Characteristic",3],10,"computed (char. table)"],
["2.M22",["Characteristic",5],10,"computed (char. table)"],
["2.M22",["Characteristic",7],10,"computed (char. table)"],
["2.M22",["Characteristic",11],10,"computed (char. table)"],
["2.M22",["Size",3],20,"computed (char. table)"],
["2.M22",["Size",9],10,"computed (char. table)"],
["2.M22",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.M22",["Size",5],20,"computed (char. table)"],
["2.M22",["Size",25],10,"computed (char. table)"],
["2.M22",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.M22",["Size",7],10,"computed (char. table)"],
["2.M22",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.M22",["Size",11],10,"computed (char. table)"],
["2.M22",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.M22.2",["Characteristic",0],10,"computed (char. table)"],
["2.M22.2",["Characteristic",3],10,"computed (char. table)"],
["2.M22.2",["Characteristic",5],10,"computed (char. table)"],
["2.M22.2",["Characteristic",7],10,"computed (char. table)"],
["2.M22.2",["Characteristic",11],10,"computed (char. table)"],
["2.M22.2",["Size",3],20,"computed (char. table)"],
["2.M22.2",["Size",9],10,"computed (char. table)"],
["2.M22.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.M22.2",["Size",5],20,"computed (char. table)"],
["2.M22.2",["Size",25],10,"computed (char. table)"],
["2.M22.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.M22.2",["Size",7],10,"computed (char. table)"],
["2.M22.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.M22.2",["Size",11],10,"computed (char. table)"],
["2.M22.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.O7(3)",["Characteristic",0],520,"computed (char. table)"],
["2.O7(3)",["Characteristic",3],8,"computed (char. table)"],
["2.O7(3)",["Characteristic",5],520,"computed (char. table)"],
["2.O7(3)",["Characteristic",7],520,"computed (char. table)"],
["2.O7(3)",["Characteristic",13],520,"computed (char. table)"],
["2.O7(3)",["Size",3],8,"computed (char. table)"],
["2.O7(3)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.O7(3)",["Size",5],520,"computed (char. table)"],
["2.O7(3)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.O7(3)",["Size",7],520,"computed (char. table)"],
["2.O7(3)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.O7(3)",["Size",13],520,"computed (char. table)"],
["2.O7(3)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.O7(3).2",["Characteristic",0],520,"computed (char. table)"],
["2.O7(3).2",["Characteristic",3],8,"computed (char. table)"],
["2.O7(3).2",["Characteristic",5],520,"computed (char. table)"],
["2.O7(3).2",["Characteristic",7],520,"computed (char. table)"],
["2.O7(3).2",["Characteristic",13],520,"computed (char. table)"],
["2.O7(3).2",["Size",3],16,"computed (char. table)"],
["2.O7(3).2",["Size",9],8,"computed (char. table)"],
["2.O7(3).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.O7(3).2",["Size",5],1040,"computed (char. table)"],
["2.O7(3).2",["Size",25],520,"computed (char. table)"],
["2.O7(3).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.O7(3).2",["Size",7],520,"computed (char. table)"],
["2.O7(3).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.O7(3).2",["Size",13],1040,"computed (char. table)"],
["2.O7(3).2",["Size",169],520,"computed (char. table)"],
["2.O7(3).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.O8+(2)",["Characteristic",0],8,"computed (char. table)"],
["2.O8+(2)",["Characteristic",3],8,"computed (char. table)"],
["2.O8+(2)",["Characteristic",5],8,"computed (char. table)"],
["2.O8+(2)",["Characteristic",7],8,"computed (char. table)"],
["2.O8+(2)",["Size",3],8,"computed (char. table)"],
["2.O8+(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.O8+(2)",["Size",5],8,"computed (char. table)"],
["2.O8+(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.O8+(2)",["Size",7],8,"computed (char. table)"],
["2.O8+(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.O8+(2).2",["Characteristic",0],8,"computed (char. table)"],
["2.O8+(2).2",["Characteristic",3],8,"computed (char. table)"],
["2.O8+(2).2",["Characteristic",5],8,"computed (char. table)"],
["2.O8+(2).2",["Characteristic",7],8,"computed (char. table)"],
["2.O8+(2).2",["Size",3],8,"computed (char. table)"],
["2.O8+(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.O8+(2).2",["Size",5],8,"computed (char. table)"],
["2.O8+(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.O8+(2).2",["Size",7],8,"computed (char. table)"],
["2.O8+(2).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.Ru",["Characteristic",0],28,"computed (char. table)"],
["2.Ru",["Characteristic",3],28,"computed (char. table)"],
["2.Ru",["Characteristic",5],28,"computed (char. table)"],
["2.Ru",["Characteristic",7],28,"computed (char. table)"],
["2.Ru",["Characteristic",13],28,"computed (char. table)"],
["2.Ru",["Characteristic",29],28,"computed (char. table)"],
["2.Ru",["Size",3],56,"computed (char. table)"],
["2.Ru",["Size",9],28,"computed (char. table)"],
["2.Ru",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.Ru",["Size",5],28,"computed (char. table)"],
["2.Ru",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.Ru",["Size",7],56,"computed (char. table)"],
["2.Ru",["Size",49],28,"computed (char. table)"],
["2.Ru",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.Ru",["Size",13],28,"computed (char. table)"],
["2.Ru",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.Ru",["Size",29],28,"computed (char. table)"],
["2.Ru",["Characteristic",29,"complete"],true,"computed (char. table)"],
["2.S4(5)",["Characteristic",0],12,"computed (char. table)"],
["2.S4(5)",["Characteristic",3],12,"computed (char. table)"],
["2.S4(5)",["Characteristic",5],4,"computed (char. table)"],
["2.S4(5)",["Characteristic",13],12,"computed (char. table)"],
["2.S4(5)",["Size",3],24,"computed (char. table)"],
["2.S4(5)",["Size",9],12,"computed (char. table)"],
["2.S4(5)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.S4(5)",["Size",5],4,"computed (char. table)"],
["2.S4(5)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.S4(5)",["Size",13],24,"computed (char. table)"],
["2.S4(5)",["Size",169],12,"computed (char. table)"],
["2.S4(5)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.S6(2)","NrMovedPoints",240,"computed (subgroup tables, known repres.)"],
["2.S6(2)","NrMovedPoints",240,"computed (table of marks)"],
["2.S6(2)",["Characteristic",0],8,"computed (char. table)"],
["2.S6(2)",["Characteristic",3],8,"computed (char. table)"],
["2.S6(2)",["Characteristic",5],8,"computed (char. table)"],
["2.S6(2)",["Characteristic",7],8,"computed (char. table)"],
["2.S6(2)",["Size",3],8,"computed (char. table)"],
["2.S6(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.S6(2)",["Size",5],8,"computed (char. table)"],
["2.S6(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.S6(2)",["Size",7],8,"computed (char. table)"],
["2.S6(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.S6(3)",["Characteristic",0],14,"computed (char. table)"],
["2.S6(3)",["Characteristic",3],6,"computed (char. table)"],
["2.S6(3)",["Characteristic",5],14,"computed (char. table)"],
["2.S6(3)",["Characteristic",7],14,"computed (char. table)"],
["2.S6(3)",["Characteristic",13],14,"computed (char. table)"],
["2.S6(3)",["Size",3],6,"computed (char. table)"],
["2.S6(3)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.S6(3)",["Size",5],28,"computed (char. table)"],
["2.S6(3)",["Size",25],14,"computed (char. table)"],
["2.S6(3)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.S6(3)",["Size",7],14,"computed (char. table)"],
["2.S6(3)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.S6(3)",["Size",13],14,"computed (char. table)"],
["2.S6(3)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.S6(3).2",["Characteristic",0],28,"computed (char. table)"],
["2.S6(3).2",["Characteristic",3],6,"computed (char. table)"],
["2.S6(3).2",["Characteristic",5],28,"computed (char. table)"],
["2.S6(3).2",["Characteristic",7],28,"computed (char. table)"],
["2.S6(3).2",["Characteristic",13],28,"computed (char. table)"],
["2.S6(3).2",["Size",3],6,"computed (char. table)"],
["2.S6(3).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.S6(3).2",["Size",5],28,"computed (char. table)"],
["2.S6(3).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.S6(3).2",["Size",7],28,"computed (char. table)"],
["2.S6(3).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.S6(3).2",["Size",13],28,"computed (char. table)"],
["2.S6(3).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.Suz",["Characteristic",0],220,"computed (char. table)"],
["2.Suz",["Characteristic",3],12,"computed (char. table)"],
["2.Suz",["Characteristic",5],220,"computed (char. table)"],
["2.Suz",["Characteristic",7],220,"computed (char. table)"],
["2.Suz",["Characteristic",11],220,"computed (char. table)"],
["2.Suz",["Characteristic",13],220,"computed (char. table)"],
["2.Suz",["Size",3],12,"computed (char. table)"],
["2.Suz",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.Suz",["Size",5],220,"computed (char. table)"],
["2.Suz",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.Suz",["Size",7],220,"computed (char. table)"],
["2.Suz",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.Suz",["Size",11],220,"computed (char. table)"],
["2.Suz",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.Suz",["Size",13],220,"computed (char. table)"],
["2.Suz",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.Suz.2",["Characteristic",0],220,"computed (char. table)"],
["2.Suz.2",["Characteristic",3],12,"computed (char. table)"],
["2.Suz.2",["Characteristic",5],220,"computed (char. table)"],
["2.Suz.2",["Characteristic",7],220,"computed (char. table)"],
["2.Suz.2",["Characteristic",11],220,"computed (char. table)"],
["2.Suz.2",["Size",3],12,"computed (char. table)"],
["2.Suz.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.Suz.2",["Size",5],440,"computed (char. table)"],
["2.Suz.2",["Size",25],220,"computed (char. table)"],
["2.Suz.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.Suz.2",["Size",7],440,"computed (char. table)"],
["2.Suz.2",["Size",49],220,"computed (char. table)"],
["2.Suz.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.Suz.2",["Size",11],220,"computed (char. table)"],
["2.Suz.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2.Sz(8)",["Characteristic",0],40,"computed (char. table)"],
["2.Sz(8)",["Characteristic",5],8,"computed (char. table)"],
["2.Sz(8)",["Characteristic",7],40,"computed (char. table)"],
["2.Sz(8)",["Characteristic",13],16,"computed (char. table)"],
["2.Sz(8)",["Size",5],8,"computed (char. table)"],
["2.Sz(8)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.Sz(8)",["Size",7],40,"computed (char. table)"],
["2.Sz(8)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.Sz(8)",["Size",13],16,"computed (char. table)"],
["2.Sz(8)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2.U4(2)","NrMovedPoints",80,"computed (table of marks)"],
["2.U4(2)",["Characteristic",0],4,"computed (char. table)"],
["2.U4(2)",["Characteristic",3],4,"computed (char. table)"],
["2.U4(2)",["Characteristic",5],4,"computed (char. table)"],
["2.U4(2)",["Size",3],4,"computed (char. table)"],
["2.U4(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.U4(2)",["Size",5],8,"computed (char. table)"],
["2.U4(2)",["Size",25],4,"computed (char. table)"],
["2.U4(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.U4(2).2","NrMovedPoints",80,"computed (table of marks)"],
["2.U4(2).2",["Characteristic",0],8,"computed (char. table)"],
["2.U4(2).2",["Characteristic",3],4,"computed (char. table)"],
["2.U4(2).2",["Characteristic",5],8,"computed (char. table)"],
["2.U4(2).2",["Size",3],4,"computed (char. table)"],
["2.U4(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.U4(2).2",["Size",5],8,"computed (char. table)"],
["2.U4(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.U4(3).D8",["Characteristic",0],20,"computed (char. table)"],
["2.U6(2)",["Characteristic",0],56,"computed (char. table)"],
["2.U6(2)",["Characteristic",3],56,"computed (char. table)"],
["2.U6(2)",["Characteristic",5],56,"computed (char. table)"],
["2.U6(2)",["Characteristic",7],56,"computed (char. table)"],
["2.U6(2)",["Characteristic",11],56,"computed (char. table)"],
["2.U6(2)",["Size",3],56,"computed (char. table)"],
["2.U6(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2.U6(2)",["Size",5],56,"computed (char. table)"],
["2.U6(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2.U6(2)",["Size",7],56,"computed (char. table)"],
["2.U6(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2.U6(2)",["Size",11],56,"computed (char. table)"],
["2.U6(2)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2E6(2)",["Characteristic",0],1938,"computed (char. table)"],
["2E6(2)",["Characteristic",11],1938,"computed (char. table)"],
["2E6(2)",["Characteristic",13],1938,"computed (char. table)"],
["2E6(2)",["Characteristic",17],1938,"computed (char. table)"],
["2E6(2)",["Characteristic",19],1938,"computed (char. table)"],
["2E6(2)",["Size",11],1938,"computed (char. table)"],
["2E6(2)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2E6(2)",["Size",13],1938,"computed (char. table)"],
["2E6(2)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2E6(2)",["Size",17],1938,"computed (char. table)"],
["2E6(2)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["2E6(2)",["Size",19],1938,"computed (char. table)"],
["2E6(2)",["Characteristic",19,"complete"],true,"computed (char. table)"],
["2E6(2).2",["Characteristic",0],1938,"computed (char. table)"],
["2E6(2).2",["Characteristic",11],1938,"computed (char. table)"],
["2E6(2).2",["Characteristic",13],1938,"computed (char. table)"],
["2E6(2).2",["Characteristic",17],1938,"computed (char. table)"],
["2E6(2).2",["Characteristic",19],1938,"computed (char. table)"],
["2E6(2).2",["Size",11],1938,"computed (char. table)"],
["2E6(2).2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["2E6(2).2",["Size",13],1938,"computed (char. table)"],
["2E6(2).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2E6(2).2",["Size",17],1938,"computed (char. table)"],
["2E6(2).2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["2E6(2).2",["Size",19],1938,"computed (char. table)"],
["2E6(2).2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["2E6(2).3",["Characteristic",0],1938,"computed (char. table)"],
["2E6(2).S3",["Characteristic",0],1938,"computed (char. table)"],
["2F4(2)'","NrMovedPoints",1600,"computed (char. table)"],
["2F4(2)'","NrMovedPoints",1600,"computed (table of marks)"],
["2F4(2)'",["Characteristic",0],26,"computed (char. table)"],
["2F4(2)'",["Characteristic",2],26,"computed (char. table)"],
["2F4(2)'",["Characteristic",3],26,"computed (char. table)"],
["2F4(2)'",["Characteristic",5],26,"computed (char. table)"],
["2F4(2)'",["Characteristic",13],26,"computed (char. table)"],
["2F4(2)'",["Size",2],26,"computed (char. table)"],
["2F4(2)'",["Characteristic",2,"complete"],true,"computed (char. table)"],
["2F4(2)'",["Size",3],26,"computed (char. table)"],
["2F4(2)'",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2F4(2)'",["Size",5],27,"computed (char. table)"],
["2F4(2)'",["Size",25],26,"computed (char. table)"],
["2F4(2)'",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2F4(2)'",["Size",13],27,"computed (char. table)"],
["2F4(2)'",["Size",169],26,"computed (char. table)"],
["2F4(2)'",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2F4(2)'.2",["Characteristic",0],27,"computed (char. table)"],
["2F4(2)'.2",["Characteristic",2],26,"computed (char. table)"],
["2F4(2)'.2",["Characteristic",3],27,"computed (char. table)"],
["2F4(2)'.2",["Characteristic",5],27,"computed (char. table)"],
["2F4(2)'.2",["Characteristic",13],27,"computed (char. table)"],
["2F4(2)'.2",["Size",2],26,"computed (char. table)"],
["2F4(2)'.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["2F4(2)'.2",["Size",3],52,"computed (char. table)"],
["2F4(2)'.2",["Size",9],27,"computed (char. table)"],
["2F4(2)'.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2F4(2)'.2",["Size",5],27,"computed (char. table)"],
["2F4(2)'.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2F4(2)'.2",["Size",13],27,"computed (char. table)"],
["2F4(2)'.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2^(1+24).Co1",["Characteristic",0],98304,"computed (char. table)"],
["2^2.2E6(2).S3",["Characteristic",0],7296,"computed (char. table)"],
["2^2.L3(4).2_2","NrMovedPoints",224,"computed (table of marks)"],
["2^2.L3(4).2_2",["Characteristic",0],20,"computed (char. table)"],
["2^2.L3(4).2_2",["Characteristic",3],12,"computed (char. table)"],
["2^2.L3(4).2_2",["Characteristic",5],20,"computed (char. table)"],
["2^2.L3(4).2_2",["Characteristic",7],20,"computed (char. table)"],
["2^2.L3(4).2_2",["Size",3],12,"computed (char. table)"],
["2^2.L3(4).2_2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2^2.L3(4).2_2",["Size",5],40,"computed (char. table)"],
["2^2.L3(4).2_2",["Size",25],20,"computed (char. table)"],
["2^2.L3(4).2_2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2^2.L3(4).2_2",["Size",7],20,"computed (char. table)"],
["2^2.L3(4).2_2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2^2.Sz(8).3",["Characteristic",0],120,"computed (char. table)"],
["2^2.Sz(8).3",["Characteristic",3],120,"computed (char. table)"],
["2^2.Sz(8).3",["Characteristic",5],24,"computed (char. table)"],
["2^2.Sz(8).3",["Characteristic",7],120,"computed (char. table)"],
["2^2.Sz(8).3",["Characteristic",13],48,"computed (char. table)"],
["2^2.Sz(8).3",["Size",3],192,"computed (char. table)"],
["2^2.Sz(8).3",["Size",27],120,"computed (char. table)"],
["2^2.Sz(8).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["2^2.Sz(8).3",["Size",5],24,"computed (char. table)"],
["2^2.Sz(8).3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["2^2.Sz(8).3",["Size",7],120,"computed (char. table)"],
["2^2.Sz(8).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["2^2.Sz(8).3",["Size",13],48,"computed (char. table)"],
["2^2.Sz(8).3",["Characteristic",13,"complete"],true,"computed (char. table)"],
["2^4.A8","NrMovedPoints",30,"computed (table of marks)"],
["2^4.A8",["Characteristic",0],15,"computed (char. table)"],
["3.2E6(2)",["Characteristic",0],46683,"computed (char. table)"],
["3.2E6(2).2",["Characteristic",0],93366,"computed (char. table)"],
["3.A6","NrMovedPoints",18,"computed (factor table)"],
["3.A6",["Characteristic",0],3,"computed (char. table)"],
["3.A6",["Characteristic",2],3,"computed (char. table)"],
["3.A6",["Characteristic",5],3,"computed (char. table)"],
["3.A6",["Size",2],6,"computed (char. table)"],
["3.A6",["Size",4],3,"computed (char. table)"],
["3.A6",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.A6",["Size",5],6,"computed (char. table)"],
["3.A6",["Size",25],3,"computed (char. table)"],
["3.A6",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.A6.2_1","NrMovedPoints",18,"computed (subgroup tables, known repres.)"],
["3.A6.2_1",["Characteristic",0],6,"computed (char. table)"],
["3.A6.2_1",["Characteristic",2],6,"computed (char. table)"],
["3.A6.2_1",["Characteristic",5],6,"computed (char. table)"],
["3.A6.2_1",["Size",2],6,"computed (char. table)"],
["3.A6.2_1",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.A6.2_1",["Size",5],6,"computed (char. table)"],
["3.A6.2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.A7",["Characteristic",0],6,"computed (char. table)"],
["3.A7",["Characteristic",2],6,"computed (char. table)"],
["3.A7",["Characteristic",5],3,"computed (char. table)"],
["3.A7",["Characteristic",7],6,"computed (char. table)"],
["3.A7",["Size",2],12,"computed (char. table)"],
["3.A7",["Size",4],6,"computed (char. table)"],
["3.A7",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.A7",["Size",5],6,"computed (char. table)"],
["3.A7",["Size",25],3,"computed (char. table)"],
["3.A7",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.A7",["Size",7],6,"computed (char. table)"],
["3.A7",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.A7.2","NrMovedPoints",63,"computed (table of marks)"],
["3.A7.2",["Characteristic",0],12,"computed (char. table)"],
["3.A7.2",["Characteristic",2],12,"computed (char. table)"],
["3.A7.2",["Characteristic",5],6,"computed (char. table)"],
["3.A7.2",["Characteristic",7],12,"computed (char. table)"],
["3.A7.2",["Size",2],12,"computed (char. table)"],
["3.A7.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.A7.2",["Size",5],6,"computed (char. table)"],
["3.A7.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.A7.2",["Size",7],12,"computed (char. table)"],
["3.A7.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.Fi22",["Characteristic",0],351,"computed (char. table)"],
["3.Fi22",["Characteristic",2],27,"computed (char. table)"],
["3.Fi22",["Characteristic",5],351,"computed (char. table)"],
["3.Fi22",["Characteristic",7],351,"computed (char. table)"],
["3.Fi22",["Characteristic",11],351,"computed (char. table)"],
["3.Fi22",["Characteristic",13],351,"computed (char. table)"],
["3.Fi22",["Size",2],54,"computed (char. table)"],
["3.Fi22",["Size",4],27,"computed (char. table)"],
["3.Fi22",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.Fi22",["Size",5],702,"computed (char. table)"],
["3.Fi22",["Size",25],351,"computed (char. table)"],
["3.Fi22",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.Fi22",["Size",7],351,"computed (char. table)"],
["3.Fi22",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.Fi22",["Size",11],702,"computed (char. table)"],
["3.Fi22",["Size",121],351,"computed (char. table)"],
["3.Fi22",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.Fi22",["Size",13],351,"computed (char. table)"],
["3.Fi22",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3.Fi22.2",["Characteristic",0],702,"computed (char. table)"],
["3.Fi22.2",["Characteristic",2],54,"computed (char. table)"],
["3.Fi22.2",["Characteristic",5],702,"computed (char. table)"],
["3.Fi22.2",["Characteristic",7],702,"computed (char. table)"],
["3.Fi22.2",["Characteristic",11],702,"computed (char. table)"],
["3.Fi22.2",["Characteristic",13],702,"computed (char. table)"],
["3.Fi22.2",["Size",2],54,"computed (char. table)"],
["3.Fi22.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.Fi22.2",["Size",5],702,"computed (char. table)"],
["3.Fi22.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.Fi22.2",["Size",7],702,"computed (char. table)"],
["3.Fi22.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.Fi22.2",["Size",11],702,"computed (char. table)"],
["3.Fi22.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.Fi22.2",["Size",13],702,"computed (char. table)"],
["3.Fi22.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3.Fi24'","NrMovedPoints",920808,"computed (factor table)"],
["3.Fi24'",["Characteristic",0],783,"computed (char. table)"],
["3.Fi24'",["Characteristic",11],783,"computed (char. table)"],
["3.Fi24'",["Characteristic",23],783,"computed (char. table)"],
["3.Fi24'",["Size",23],1566,"computed (char. table)"],
["3.Fi24'",["Size",529],783,"computed (char. table)"],
["3.Fi24'",["Characteristic",23,"complete"],true,"computed (char. table)"],
["3.Fi24'.2","NrMovedPoints",920808,"computed (subgroup tables, known repres.)"],
["3.Fi24'.2",["Characteristic",0],1566,"computed (char. table)"],
["3.Fi24'.2",["Characteristic",11],1566,"computed (char. table)"],
["3.Fi24'.2",["Characteristic",13],1566,"computed (char. table)"],
["3.Fi24'.2",["Characteristic",23],1566,"computed (char. table)"],
["3.Fi24'.2",["Size",11],1566,"computed (char. table)"],
["3.Fi24'.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.Fi24'.2",["Size",13],1566,"computed (char. table)"],
["3.Fi24'.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3.Fi24'.2",["Size",23],1566,"computed (char. table)"],
["3.Fi24'.2",["Characteristic",23,"complete"],true,"computed (char. table)"],
["3.G2(3)",["Characteristic",0],27,"computed (char. table)"],
["3.G2(3)",["Characteristic",2],27,"computed (char. table)"],
["3.G2(3)",["Characteristic",7],27,"computed (char. table)"],
["3.G2(3)",["Characteristic",13],27,"computed (char. table)"],
["3.G2(3)",["Size",2],54,"computed (char. table)"],
["3.G2(3)",["Size",4],27,"computed (char. table)"],
["3.G2(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.G2(3)",["Size",7],27,"computed (char. table)"],
["3.G2(3)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.G2(3)",["Size",13],27,"computed (char. table)"],
["3.G2(3)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3.G2(3).2",["Characteristic",0],54,"computed (char. table)"],
["3.G2(3).2",["Characteristic",2],54,"computed (char. table)"],
["3.G2(3).2",["Characteristic",7],54,"computed (char. table)"],
["3.G2(3).2",["Characteristic",13],54,"computed (char. table)"],
["3.G2(3).2",["Size",2],54,"computed (char. table)"],
["3.G2(3).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.G2(3).2",["Size",7],54,"computed (char. table)"],
["3.G2(3).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.G2(3).2",["Size",13],54,"computed (char. table)"],
["3.G2(3).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3.J3",["Characteristic",0],18,"computed (char. table)"],
["3.J3",["Characteristic",2],9,"computed (char. table)"],
["3.J3",["Characteristic",5],18,"computed (char. table)"],
["3.J3",["Characteristic",17],18,"computed (char. table)"],
["3.J3",["Characteristic",19],18,"computed (char. table)"],
["3.J3",["Size",2],18,"computed (char. table)"],
["3.J3",["Size",4],9,"computed (char. table)"],
["3.J3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.J3",["Size",5],36,"computed (char. table)"],
["3.J3",["Size",25],18,"computed (char. table)"],
["3.J3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.J3",["Size",17],36,"computed (char. table)"],
["3.J3",["Size",289],18,"computed (char. table)"],
["3.J3",["Characteristic",17,"complete"],true,"computed (char. table)"],
["3.J3",["Size",19],18,"computed (char. table)"],
["3.J3",["Characteristic",19,"complete"],true,"computed (char. table)"],
["3.J3.2",["Characteristic",0],36,"computed (char. table)"],
["3.J3.2",["Characteristic",2],18,"computed (char. table)"],
["3.J3.2",["Characteristic",5],36,"computed (char. table)"],
["3.J3.2",["Characteristic",17],36,"computed (char. table)"],
["3.J3.2",["Characteristic",19],36,"computed (char. table)"],
["3.J3.2",["Size",2],18,"computed (char. table)"],
["3.J3.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.J3.2",["Size",5],36,"computed (char. table)"],
["3.J3.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.J3.2",["Size",17],36,"computed (char. table)"],
["3.J3.2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["3.J3.2",["Size",19],36,"computed (char. table)"],
["3.J3.2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["3.L3(4)","NrMovedPoints",63,"computed (table of marks)"],
["3.L3(4)",["Characteristic",0],15,"computed (char. table)"],
["3.L3(4)",["Characteristic",2],3,"computed (char. table)"],
["3.L3(4)",["Characteristic",5],15,"computed (char. table)"],
["3.L3(4)",["Characteristic",7],15,"computed (char. table)"],
["3.L3(4)",["Size",2],6,"computed (char. table)"],
["3.L3(4)",["Size",4],3,"computed (char. table)"],
["3.L3(4)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.L3(4)",["Size",5],30,"computed (char. table)"],
["3.L3(4)",["Size",25],15,"computed (char. table)"],
["3.L3(4)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.L3(4)",["Size",7],15,"computed (char. table)"],
["3.L3(4)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.L3(4).2_1",["Characteristic",0],15,"computed (char. table)"],
["3.L3(4).2_1",["Characteristic",2],6,"computed (char. table)"],
["3.L3(4).2_1",["Characteristic",5],15,"computed (char. table)"],
["3.L3(4).2_1",["Characteristic",7],15,"computed (char. table)"],
["3.L3(4).2_1",["Size",2],12,"computed (char. table)"],
["3.L3(4).2_1",["Size",4],6,"computed (char. table)"],
["3.L3(4).2_1",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.L3(4).2_1",["Size",5],30,"computed (char. table)"],
["3.L3(4).2_1",["Size",25],15,"computed (char. table)"],
["3.L3(4).2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.L3(4).2_1",["Size",7],15,"computed (char. table)"],
["3.L3(4).2_1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.L3(7)",["Characteristic",0],57,"computed (char. table)"],
["3.L3(7)",["Characteristic",2],57,"computed (char. table)"],
["3.L3(7)",["Characteristic",7],3,"computed (char. table)"],
["3.L3(7)",["Characteristic",19],57,"computed (char. table)"],
["3.L3(7)",["Size",2],114,"computed (char. table)"],
["3.L3(7)",["Size",4],57,"computed (char. table)"],
["3.L3(7)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.L3(7)",["Size",7],3,"computed (char. table)"],
["3.L3(7)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.L3(7)",["Size",19],57,"computed (char. table)"],
["3.L3(7)",["Characteristic",19,"complete"],true,"computed (char. table)"],
["3.L3(7).2",["Characteristic",0],114,"computed (char. table)"],
["3.L3(7).2",["Characteristic",2],114,"computed (char. table)"],
["3.L3(7).2",["Characteristic",7],6,"computed (char. table)"],
["3.L3(7).2",["Characteristic",19],114,"computed (char. table)"],
["3.L3(7).2",["Size",2],114,"computed (char. table)"],
["3.L3(7).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.L3(7).2",["Size",7],6,"computed (char. table)"],
["3.L3(7).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.L3(7).2",["Size",19],114,"computed (char. table)"],
["3.L3(7).2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["3.M22",["Characteristic",0],21,"computed (char. table)"],
["3.M22",["Characteristic",2],6,"computed (char. table)"],
["3.M22",["Characteristic",5],21,"computed (char. table)"],
["3.M22",["Characteristic",7],21,"computed (char. table)"],
["3.M22",["Characteristic",11],21,"computed (char. table)"],
["3.M22",["Size",2],12,"computed (char. table)"],
["3.M22",["Size",4],6,"computed (char. table)"],
["3.M22",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.M22",["Size",5],42,"computed (char. table)"],
["3.M22",["Size",25],21,"computed (char. table)"],
["3.M22",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.M22",["Size",7],21,"computed (char. table)"],
["3.M22",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.M22",["Size",11],42,"computed (char. table)"],
["3.M22",["Size",121],21,"computed (char. table)"],
["3.M22",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.M22.2",["Characteristic",0],42,"computed (char. table)"],
["3.M22.2",["Characteristic",2],12,"computed (char. table)"],
["3.M22.2",["Characteristic",5],42,"computed (char. table)"],
["3.M22.2",["Characteristic",7],42,"computed (char. table)"],
["3.M22.2",["Characteristic",11],42,"computed (char. table)"],
["3.M22.2",["Size",2],12,"computed (char. table)"],
["3.M22.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.M22.2",["Size",5],42,"computed (char. table)"],
["3.M22.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.M22.2",["Size",7],42,"computed (char. table)"],
["3.M22.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.M22.2",["Size",11],42,"computed (char. table)"],
["3.M22.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.McL",["Characteristic",0],126,"computed (char. table)"],
["3.McL",["Characteristic",2],126,"computed (char. table)"],
["3.McL",["Characteristic",5],45,"computed (char. table)"],
["3.McL",["Characteristic",7],126,"computed (char. table)"],
["3.McL",["Characteristic",11],126,"computed (char. table)"],
["3.McL",["Size",2],252,"computed (char. table)"],
["3.McL",["Size",4],126,"computed (char. table)"],
["3.McL",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.McL",["Size",5],90,"computed (char. table)"],
["3.McL",["Size",25],45,"computed (char. table)"],
["3.McL",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.McL",["Size",7],252,"computed (char. table)"],
["3.McL",["Size",49],126,"computed (char. table)"],
["3.McL",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.McL",["Size",11],252,"computed (char. table)"],
["3.McL",["Size",121],126,"computed (char. table)"],
["3.McL",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.McL.2",["Characteristic",0],252,"computed (char. table)"],
["3.McL.2",["Characteristic",2],252,"computed (char. table)"],
["3.McL.2",["Characteristic",5],90,"computed (char. table)"],
["3.McL.2",["Characteristic",7],252,"computed (char. table)"],
["3.McL.2",["Characteristic",11],252,"computed (char. table)"],
["3.McL.2",["Size",2],504,"computed (char. table)"],
["3.McL.2",["Size",4],252,"computed (char. table)"],
["3.McL.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.McL.2",["Size",5],90,"computed (char. table)"],
["3.McL.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.McL.2",["Size",7],504,"computed (char. table)"],
["3.McL.2",["Size",49],252,"computed (char. table)"],
["3.McL.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.McL.2",["Size",11],252,"computed (char. table)"],
["3.McL.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.O7(3)",["Characteristic",0],27,"computed (char. table)"],
["3.O7(3)",["Characteristic",2],27,"computed (char. table)"],
["3.O7(3)",["Characteristic",5],27,"computed (char. table)"],
["3.O7(3)",["Characteristic",7],27,"computed (char. table)"],
["3.O7(3)",["Characteristic",13],27,"computed (char. table)"],
["3.O7(3)",["Size",2],54,"computed (char. table)"],
["3.O7(3)",["Size",4],27,"computed (char. table)"],
["3.O7(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.O7(3)",["Size",5],54,"computed (char. table)"],
["3.O7(3)",["Size",25],27,"computed (char. table)"],
["3.O7(3)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.O7(3)",["Size",7],27,"computed (char. table)"],
["3.O7(3)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.O7(3)",["Size",13],27,"computed (char. table)"],
["3.O7(3)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3.O7(3).2",["Characteristic",0],54,"computed (char. table)"],
["3.O7(3).2",["Characteristic",2],54,"computed (char. table)"],
["3.O7(3).2",["Characteristic",5],54,"computed (char. table)"],
["3.O7(3).2",["Characteristic",7],54,"computed (char. table)"],
["3.O7(3).2",["Characteristic",13],54,"computed (char. table)"],
["3.O7(3).2",["Size",2],54,"computed (char. table)"],
["3.O7(3).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.O7(3).2",["Size",5],54,"computed (char. table)"],
["3.O7(3).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.O7(3).2",["Size",7],54,"computed (char. table)"],
["3.O7(3).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.O7(3).2",["Size",13],54,"computed (char. table)"],
["3.O7(3).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3.ON",["Characteristic",0],342,"computed (char. table)"],
["3.ON",["Characteristic",2],153,"computed (char. table)"],
["3.ON",["Characteristic",5],342,"computed (char. table)"],
["3.ON",["Characteristic",7],45,"computed (char. table)"],
["3.ON",["Characteristic",11],342,"computed (char. table)"],
["3.ON",["Characteristic",19],342,"computed (char. table)"],
["3.ON",["Characteristic",31],342,"computed (char. table)"],
["3.ON",["Size",2],306,"computed (char. table)"],
["3.ON",["Size",4],153,"computed (char. table)"],
["3.ON",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.ON",["Size",5],684,"computed (char. table)"],
["3.ON",["Size",25],342,"computed (char. table)"],
["3.ON",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.ON",["Size",7],45,"computed (char. table)"],
["3.ON",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.ON",["Size",11],684,"computed (char. table)"],
["3.ON",["Size",121],342,"computed (char. table)"],
["3.ON",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.ON",["Size",19],495,"computed (char. table)"],
["3.ON",["Size",361],342,"computed (char. table)"],
["3.ON",["Characteristic",19,"complete"],true,"computed (char. table)"],
["3.ON",["Size",31],342,"computed (char. table)"],
["3.ON",["Characteristic",31,"complete"],true,"computed (char. table)"],
["3.ON.2",["Characteristic",0],684,"computed (char. table)"],
["3.ON.2",["Characteristic",2],306,"computed (char. table)"],
["3.ON.2",["Characteristic",5],684,"computed (char. table)"],
["3.ON.2",["Characteristic",7],90,"computed (char. table)"],
["3.ON.2",["Characteristic",11],684,"computed (char. table)"],
["3.ON.2",["Characteristic",19],684,"computed (char. table)"],
["3.ON.2",["Characteristic",31],684,"computed (char. table)"],
["3.ON.2",["Size",2],306,"computed (char. table)"],
["3.ON.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.ON.2",["Size",5],684,"computed (char. table)"],
["3.ON.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.ON.2",["Size",7],90,"computed (char. table)"],
["3.ON.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.ON.2",["Size",11],684,"computed (char. table)"],
["3.ON.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.ON.2",["Size",19],990,"computed (char. table)"],
["3.ON.2",["Size",361],684,"computed (char. table)"],
["3.ON.2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["3.ON.2",["Size",31],684,"computed (char. table)"],
["3.ON.2",["Characteristic",31,"complete"],true,"computed (char. table)"],
["3.Suz","NrMovedPoints",5346,"computed (factor table)"],
["3.Suz",["Characteristic",0],66,"computed (char. table)"],
["3.Suz",["Characteristic",2],12,"computed (char. table)"],
["3.Suz",["Characteristic",5],66,"computed (char. table)"],
["3.Suz",["Characteristic",7],66,"computed (char. table)"],
["3.Suz",["Characteristic",11],66,"computed (char. table)"],
["3.Suz",["Characteristic",13],66,"computed (char. table)"],
["3.Suz",["Size",2],24,"computed (char. table)"],
["3.Suz",["Size",4],12,"computed (char. table)"],
["3.Suz",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.Suz",["Size",5],132,"computed (char. table)"],
["3.Suz",["Size",25],66,"computed (char. table)"],
["3.Suz",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.Suz",["Size",7],66,"computed (char. table)"],
["3.Suz",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.Suz",["Size",11],132,"computed (char. table)"],
["3.Suz",["Size",121],66,"computed (char. table)"],
["3.Suz",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.Suz",["Size",13],66,"computed (char. table)"],
["3.Suz",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3.Suz.2","NrMovedPoints",5346,"computed (subgroup tables, known repres.)"],
["3.Suz.2",["Characteristic",0],132,"computed (char. table)"],
["3.Suz.2",["Characteristic",2],24,"computed (char. table)"],
["3.Suz.2",["Characteristic",5],132,"computed (char. table)"],
["3.Suz.2",["Characteristic",7],132,"computed (char. table)"],
["3.Suz.2",["Characteristic",11],132,"computed (char. table)"],
["3.Suz.2",["Characteristic",13],132,"computed (char. table)"],
["3.Suz.2",["Size",2],24,"computed (char. table)"],
["3.Suz.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.Suz.2",["Size",5],132,"computed (char. table)"],
["3.Suz.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.Suz.2",["Size",7],132,"computed (char. table)"],
["3.Suz.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.Suz.2",["Size",11],132,"computed (char. table)"],
["3.Suz.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.Suz.2",["Size",13],132,"computed (char. table)"],
["3.Suz.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3.U3(11)",["Characteristic",0],111,"computed (char. table)"],
["3.U3(11)",["Characteristic",2],111,"computed (char. table)"],
["3.U3(11)",["Characteristic",5],111,"computed (char. table)"],
["3.U3(11)",["Characteristic",11],3,"computed (char. table)"],
["3.U3(11)",["Characteristic",37],111,"computed (char. table)"],
["3.U3(11)",["Size",2],222,"computed (char. table)"],
["3.U3(11)",["Size",4],111,"computed (char. table)"],
["3.U3(11)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.U3(11)",["Size",5],222,"computed (char. table)"],
["3.U3(11)",["Size",25],111,"computed (char. table)"],
["3.U3(11)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.U3(11)",["Size",11],6,"computed (char. table)"],
["3.U3(11)",["Size",121],3,"computed (char. table)"],
["3.U3(11)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.U3(11)",["Size",37],111,"computed (char. table)"],
["3.U3(11)",["Characteristic",37,"complete"],true,"computed (char. table)"],
["3.U3(11).2",["Characteristic",0],222,"computed (char. table)"],
["3.U3(11).2",["Characteristic",2],222,"computed (char. table)"],
["3.U3(11).2",["Characteristic",5],222,"computed (char. table)"],
["3.U3(11).2",["Characteristic",11],6,"computed (char. table)"],
["3.U3(11).2",["Characteristic",37],222,"computed (char. table)"],
["3.U3(11).2",["Size",2],222,"computed (char. table)"],
["3.U3(11).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.U3(11).2",["Size",5],222,"computed (char. table)"],
["3.U3(11).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.U3(11).2",["Size",11],6,"computed (char. table)"],
["3.U3(11).2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3.U3(11).2",["Size",37],222,"computed (char. table)"],
["3.U3(11).2",["Characteristic",37,"complete"],true,"computed (char. table)"],
["3.U3(8)",["Characteristic",0],57,"computed (char. table)"],
["3.U3(8)",["Characteristic",2],3,"computed (char. table)"],
["3.U3(8)",["Characteristic",7],57,"computed (char. table)"],
["3.U3(8)",["Characteristic",19],57,"computed (char. table)"],
["3.U3(8)",["Size",2],18,"computed (char. table)"],
["3.U3(8)",["Size",4],9,"computed (char. table)"],
["3.U3(8)",["Size",8],6,"computed (char. table)"],
["3.U3(8)",["Size",64],3,"computed (char. table)"],
["3.U3(8)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.U3(8)",["Size",7],171,"computed (char. table)"],
["3.U3(8)",["Size",343],57,"computed (char. table)"],
["3.U3(8)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.U3(8)",["Size",19],57,"computed (char. table)"],
["3.U3(8)",["Characteristic",19,"complete"],true,"computed (char. table)"],
["3.U6(2)",["Characteristic",0],21,"computed (char. table)"],
["3.U6(2)",["Characteristic",2],6,"computed (char. table)"],
["3.U6(2)",["Characteristic",5],21,"computed (char. table)"],
["3.U6(2)",["Characteristic",7],21,"computed (char. table)"],
["3.U6(2)",["Characteristic",11],21,"computed (char. table)"],
["3.U6(2)",["Size",2],12,"computed (char. table)"],
["3.U6(2)",["Size",4],6,"computed (char. table)"],
["3.U6(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3.U6(2)",["Size",5],42,"computed (char. table)"],
["3.U6(2)",["Size",25],21,"computed (char. table)"],
["3.U6(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["3.U6(2)",["Size",7],21,"computed (char. table)"],
["3.U6(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3.U6(2)",["Size",11],42,"computed (char. table)"],
["3.U6(2)",["Size",121],21,"computed (char. table)"],
["3.U6(2)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["3D4(2)","NrMovedPoints",819,"computed (table of marks)"],
["3D4(2)",["Characteristic",0],26,"computed (char. table)"],
["3D4(2)",["Characteristic",2],8,"computed (char. table)"],
["3D4(2)",["Characteristic",3],25,"computed (char. table)"],
["3D4(2)",["Characteristic",7],26,"computed (char. table)"],
["3D4(2)",["Characteristic",13],26,"computed (char. table)"],
["3D4(2)",["Size",2],24,"computed (char. table)"],
["3D4(2)",["Size",8],8,"computed (char. table)"],
["3D4(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3D4(2)",["Size",3],25,"computed (char. table)"],
["3D4(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["3D4(2)",["Size",7],26,"computed (char. table)"],
["3D4(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3D4(2)",["Size",13],26,"computed (char. table)"],
["3D4(2)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3D4(2).3",["Characteristic",0],26,"computed (char. table)"],
["3D4(2).3",["Characteristic",2],24,"computed (char. table)"],
["3D4(2).3",["Characteristic",3],25,"computed (char. table)"],
["3D4(2).3",["Characteristic",7],26,"computed (char. table)"],
["3D4(2).3",["Characteristic",13],26,"computed (char. table)"],
["3D4(2).3",["Size",2],24,"computed (char. table)"],
["3D4(2).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["3D4(2).3",["Size",3],25,"computed (char. table)"],
["3D4(2).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["3D4(2).3",["Size",7],26,"computed (char. table)"],
["3D4(2).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["3D4(2).3",["Size",13],26,"computed (char. table)"],
["3D4(2).3",["Characteristic",13,"complete"],true,"computed (char. table)"],
["3^2.U4(3).D8",["Characteristic",0],60,"computed (char. table)"],
["4.M22",["Characteristic",0],56,"computed (char. table)"],
["4.M22",["Characteristic",3],56,"computed (char. table)"],
["4.M22",["Characteristic",5],56,"computed (char. table)"],
["4.M22",["Characteristic",7],16,"computed (char. table)"],
["4.M22",["Characteristic",11],56,"computed (char. table)"],
["4.M22",["Size",3],112,"computed (char. table)"],
["4.M22",["Size",9],56,"computed (char. table)"],
["4.M22",["Characteristic",3,"complete"],true,"computed (char. table)"],
["4.M22",["Size",5],112,"computed (char. table)"],
["4.M22",["Size",25],56,"computed (char. table)"],
["4.M22",["Characteristic",5,"complete"],true,"computed (char. table)"],
["4.M22",["Size",7],32,"computed (char. table)"],
["4.M22",["Size",49],16,"computed (char. table)"],
["4.M22",["Characteristic",7,"complete"],true,"computed (char. table)"],
["4.M22",["Size",11],112,"computed (char. table)"],
["4.M22",["Size",121],56,"computed (char. table)"],
["4.M22",["Characteristic",11,"complete"],true,"computed (char. table)"],
["4.M22.2",["Characteristic",0],112,"computed (char. table)"],
["4.M22.2",["Characteristic",3],112,"computed (char. table)"],
["4.M22.2",["Characteristic",5],112,"computed (char. table)"],
["4.M22.2",["Characteristic",7],32,"computed (char. table)"],
["4.M22.2",["Characteristic",11],112,"computed (char. table)"],
["4.M22.2",["Size",3],112,"computed (char. table)"],
["4.M22.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["4.M22.2",["Size",5],224,"computed (char. table)"],
["4.M22.2",["Size",25],112,"computed (char. table)"],
["4.M22.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["4.M22.2",["Size",7],32,"computed (char. table)"],
["4.M22.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["4.M22.2",["Size",11],112,"computed (char. table)"],
["4.M22.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["41:40","NrMovedPoints",41,"computed (subgroup tables, known repres.)"],
["41:40",["Characteristic",0],40,"computed (char. table)"],
["41:40",["Characteristic",2],40,"computed (char. table)"],
["41:40",["Characteristic",5],40,"computed (char. table)"],
["41:40",["Size",2],40,"computed (char. table)"],
["41:40",["Characteristic",2,"complete"],true,"computed (char. table)"],
["41:40",["Size",5],40,"computed (char. table)"],
["41:40",["Characteristic",5,"complete"],true,"computed (char. table)"],
["41:40",["Characteristic",41,"complete"],true,"computed (char. table)"],
["4_1.L3(4)",["Characteristic",0],8,"computed (char. table)"],
["4_1.L3(4)",["Characteristic",3],8,"computed (char. table)"],
["4_1.L3(4)",["Characteristic",5],8,"computed (char. table)"],
["4_1.L3(4)",["Characteristic",7],8,"computed (char. table)"],
["4_1.L3(4)",["Size",3],16,"computed (char. table)"],
["4_1.L3(4)",["Size",9],8,"computed (char. table)"],
["4_1.L3(4)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["4_1.L3(4)",["Size",5],8,"computed (char. table)"],
["4_1.L3(4)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["4_1.L3(4)",["Size",7],16,"computed (char. table)"],
["4_1.L3(4)",["Size",49],8,"computed (char. table)"],
["4_1.L3(4)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["4_1.L3(4).2_1",["Characteristic",0],16,"computed (char. table)"],
["4_1.L3(4).2_1",["Characteristic",3],16,"computed (char. table)"],
["4_1.L3(4).2_1",["Characteristic",5],16,"computed (char. table)"],
["4_1.L3(4).2_1",["Characteristic",7],16,"computed (char. table)"],
["4_1.L3(4).2_1",["Size",3],16,"computed (char. table)"],
["4_1.L3(4).2_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["4_1.L3(4).2_1",["Size",5],16,"computed (char. table)"],
["4_1.L3(4).2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["4_1.L3(4).2_1",["Size",7],16,"computed (char. table)"],
["4_1.L3(4).2_1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["4_2.L3(4)",["Characteristic",0],20,"computed (char. table)"],
["4_2.L3(4)",["Characteristic",3],4,"computed (char. table)"],
["4_2.L3(4)",["Characteristic",5],20,"computed (char. table)"],
["4_2.L3(4)",["Characteristic",7],20,"computed (char. table)"],
["4_2.L3(4)",["Size",3],8,"computed (char. table)"],
["4_2.L3(4)",["Size",9],4,"computed (char. table)"],
["4_2.L3(4)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["4_2.L3(4)",["Size",5],20,"computed (char. table)"],
["4_2.L3(4)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["4_2.L3(4)",["Size",7],40,"computed (char. table)"],
["4_2.L3(4)",["Size",49],20,"computed (char. table)"],
["4_2.L3(4)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["4_2.L3(4).2_1",["Characteristic",0],40,"computed (char. table)"],
["4_2.L3(4).2_1",["Characteristic",3],8,"computed (char. table)"],
["4_2.L3(4).2_1",["Characteristic",5],40,"computed (char. table)"],
["4_2.L3(4).2_1",["Characteristic",7],40,"computed (char. table)"],
["4_2.L3(4).2_1",["Size",3],8,"computed (char. table)"],
["4_2.L3(4).2_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["4_2.L3(4).2_1",["Size",5],40,"computed (char. table)"],
["4_2.L3(4).2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["4_2.L3(4).2_1",["Size",7],40,"computed (char. table)"],
["4_2.L3(4).2_1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["6.L3(4)",["Characteristic",0],6,"computed (char. table)"],
["6.L3(4)",["Characteristic",5],6,"computed (char. table)"],
["6.L3(4)",["Characteristic",7],6,"computed (char. table)"],
["6.Suz",["Characteristic",0],12,"computed (char. table)"],
["6.Suz",["Characteristic",5],12,"computed (char. table)"],
["6.Suz",["Characteristic",7],12,"computed (char. table)"],
["6.Suz",["Characteristic",11],12,"computed (char. table)"],
["6.Suz",["Characteristic",13],12,"computed (char. table)"],
["7^(1+4):(3x2.S7)",["Characteristic",0],294,"computed (char. table)"],
["A10","NrMovedPoints",10,"computed (alternating group)"],
["A10","NrMovedPoints",10,"computed (char. table)"],
["A10","NrMovedPoints",10,"computed (subgroup tables)"],
["A10","NrMovedPoints",10,"computed (subgroup tables, known repres.)"],
["A10","NrMovedPoints",10,"computed (table of marks)"],
["A10",["Characteristic",0],9,"computed (char. table)"],
["A10",["Characteristic",2],8,"computed (char. table)"],
["A10",["Characteristic",3],9,"computed (char. table)"],
["A10",["Characteristic",5],8,"computed (char. table)"],
["A10",["Characteristic",7],9,"computed (char. table)"],
["A10",["Size",2],8,"computed (char. table)"],
["A10",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A10",["Size",3],9,"computed (char. table)"],
["A10",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A10",["Size",5],8,"computed (char. table)"],
["A10",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A10",["Size",7],9,"computed (char. table)"],
["A10",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A10.2","NrMovedPoints",10,"computed (subgroup tables)"],
["A10.2","NrMovedPoints",10,"computed (subgroup tables, known repres.)"],
["A10.2","NrMovedPoints",10,"computed (symmetric group)"],
["A10.2","NrMovedPoints",10,"computed (table of marks)"],
["A10.2",["Characteristic",0],9,"computed (char. table)"],
["A10.2",["Characteristic",2],8,"computed (char. table)"],
["A10.2",["Characteristic",3],9,"computed (char. table)"],
["A10.2",["Characteristic",5],8,"computed (char. table)"],
["A10.2",["Characteristic",7],9,"computed (char. table)"],
["A10.2",["Size",2],8,"computed (char. table)"],
["A10.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A10.2",["Size",3],9,"computed (char. table)"],
["A10.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A10.2",["Size",5],8,"computed (char. table)"],
["A10.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A10.2",["Size",7],9,"computed (char. table)"],
["A10.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A11","NrMovedPoints",11,"computed (alternating group)"],
["A11","NrMovedPoints",11,"computed (char. table)"],
["A11","NrMovedPoints",11,"computed (subgroup tables)"],
["A11","NrMovedPoints",11,"computed (subgroup tables, known repres.)"],
["A11","NrMovedPoints",11,"computed (table of marks)"],
["A11",["Characteristic",0],10,"computed (char. table)"],
["A11",["Characteristic",2],10,"computed (char. table)"],
["A11",["Characteristic",3],10,"computed (char. table)"],
["A11",["Characteristic",5],10,"computed (char. table)"],
["A11",["Characteristic",7],10,"computed (char. table)"],
["A11",["Characteristic",11],9,"computed (char. table)"],
["A11",["Size",2],10,"computed (char. table)"],
["A11",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A11",["Size",3],10,"computed (char. table)"],
["A11",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A11",["Size",5],10,"computed (char. table)"],
["A11",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A11",["Size",7],10,"computed (char. table)"],
["A11",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A11",["Size",11],9,"computed (char. table)"],
["A11",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A11.2","NrMovedPoints",11,"computed (subgroup tables)"],
["A11.2","NrMovedPoints",11,"computed (subgroup tables, known repres.)"],
["A11.2","NrMovedPoints",11,"computed (symmetric group)"],
["A11.2","NrMovedPoints",11,"computed (table of marks)"],
["A11.2",["Characteristic",0],10,"computed (char. table)"],
["A11.2",["Characteristic",2],10,"computed (char. table)"],
["A11.2",["Characteristic",3],10,"computed (char. table)"],
["A11.2",["Characteristic",5],10,"computed (char. table)"],
["A11.2",["Characteristic",7],10,"computed (char. table)"],
["A11.2",["Characteristic",11],9,"computed (char. table)"],
["A11.2",["Size",2],10,"computed (char. table)"],
["A11.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A11.2",["Size",3],10,"computed (char. table)"],
["A11.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A11.2",["Size",5],10,"computed (char. table)"],
["A11.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A11.2",["Size",7],10,"computed (char. table)"],
["A11.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A11.2",["Size",11],9,"computed (char. table)"],
["A11.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A12","NrMovedPoints",12,"computed (alternating group)"],
["A12","NrMovedPoints",12,"computed (subgroup tables)"],
["A12","NrMovedPoints",12,"computed (subgroup tables, known repres.)"],
["A12","NrMovedPoints",12,"computed (table of marks)"],
["A12",["Characteristic",0],11,"computed (char. table)"],
["A12",["Characteristic",2],10,"computed (char. table)"],
["A12",["Characteristic",3],10,"computed (char. table)"],
["A12",["Characteristic",5],11,"computed (char. table)"],
["A12",["Characteristic",7],11,"computed (char. table)"],
["A12",["Characteristic",11],11,"computed (char. table)"],
["A12",["Size",2],10,"computed (char. table)"],
["A12",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A12",["Size",3],10,"computed (char. table)"],
["A12",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A12",["Size",5],11,"computed (char. table)"],
["A12",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A12",["Size",7],11,"computed (char. table)"],
["A12",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A12",["Size",11],11,"computed (char. table)"],
["A12",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A12.2","NrMovedPoints",12,"computed (subgroup tables, known repres.)"],
["A12.2","NrMovedPoints",12,"computed (symmetric group)"],
["A12.2","NrMovedPoints",12,"computed (table of marks)"],
["A12.2",["Characteristic",0],11,"computed (char. table)"],
["A12.2",["Characteristic",2],10,"computed (char. table)"],
["A12.2",["Characteristic",3],10,"computed (char. table)"],
["A12.2",["Characteristic",5],11,"computed (char. table)"],
["A12.2",["Characteristic",7],11,"computed (char. table)"],
["A12.2",["Characteristic",11],11,"computed (char. table)"],
["A12.2",["Size",2],10,"computed (char. table)"],
["A12.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A12.2",["Size",3],10,"computed (char. table)"],
["A12.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A12.2",["Size",5],11,"computed (char. table)"],
["A12.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A12.2",["Size",7],11,"computed (char. table)"],
["A12.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A12.2",["Size",11],11,"computed (char. table)"],
["A12.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A13","NrMovedPoints",13,"computed (alternating group)"],
["A13","NrMovedPoints",13,"computed (subgroup tables, known repres.)"],
["A13","NrMovedPoints",13,"computed (table of marks)"],
["A13",["Characteristic",0],12,"computed (char. table)"],
["A13",["Characteristic",2],12,"computed (char. table)"],
["A13",["Characteristic",3],12,"computed (char. table)"],
["A13",["Characteristic",5],12,"computed (char. table)"],
["A13",["Characteristic",7],12,"computed (char. table)"],
["A13",["Characteristic",11],12,"computed (char. table)"],
["A13",["Characteristic",13],11,"computed (char. table)"],
["A13",["Size",2],12,"computed (char. table)"],
["A13",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A13",["Size",3],12,"computed (char. table)"],
["A13",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A13",["Size",5],12,"computed (char. table)"],
["A13",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A13",["Size",7],12,"computed (char. table)"],
["A13",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A13",["Size",11],12,"computed (char. table)"],
["A13",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A13",["Size",13],11,"computed (char. table)"],
["A13",["Characteristic",13,"complete"],true,"computed (char. table)"],
["A13.2","NrMovedPoints",13,"computed (subgroup tables)"],
["A13.2","NrMovedPoints",13,"computed (subgroup tables, known repres.)"],
["A13.2","NrMovedPoints",13,"computed (symmetric group)"],
["A13.2",["Characteristic",0],12,"computed (char. table)"],
["A13.2",["Characteristic",2],12,"computed (char. table)"],
["A13.2",["Characteristic",3],12,"computed (char. table)"],
["A13.2",["Characteristic",5],12,"computed (char. table)"],
["A13.2",["Characteristic",7],12,"computed (char. table)"],
["A13.2",["Characteristic",11],12,"computed (char. table)"],
["A13.2",["Characteristic",13],11,"computed (char. table)"],
["A13.2",["Size",2],12,"computed (char. table)"],
["A13.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A13.2",["Size",3],12,"computed (char. table)"],
["A13.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A13.2",["Size",5],12,"computed (char. table)"],
["A13.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A13.2",["Size",7],12,"computed (char. table)"],
["A13.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A13.2",["Size",11],12,"computed (char. table)"],
["A13.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A13.2",["Size",13],11,"computed (char. table)"],
["A13.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["A14","NrMovedPoints",14,"computed (alternating group)"],
["A14","NrMovedPoints",14,"computed (char. table)"],
["A14",["Characteristic",0],13,"computed (char. table)"],
["A14",["Characteristic",2],12,"computed (char. table)"],
["A14",["Characteristic",3],13,"computed (char. table)"],
["A14",["Characteristic",5],13,"computed (char. table)"],
["A14",["Characteristic",7],12,"computed (char. table)"],
["A14",["Characteristic",11],13,"computed (char. table)"],
["A14",["Characteristic",13],13,"computed (char. table)"],
["A14",["Size",2],12,"computed (char. table)"],
["A14",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A14",["Size",3],13,"computed (char. table)"],
["A14",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A14",["Size",5],13,"computed (char. table)"],
["A14",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A14",["Size",7],12,"computed (char. table)"],
["A14",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A14",["Size",11],13,"computed (char. table)"],
["A14",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A14",["Size",13],13,"computed (char. table)"],
["A14",["Characteristic",13,"complete"],true,"computed (char. table)"],
["A14.2","NrMovedPoints",14,"computed (subgroup tables)"],
["A14.2","NrMovedPoints",14,"computed (subgroup tables, known repres.)"],
["A14.2","NrMovedPoints",14,"computed (symmetric group)"],
["A14.2",["Characteristic",0],13,"computed (char. table)"],
["A14.2",["Characteristic",2],12,"computed (char. table)"],
["A14.2",["Characteristic",3],13,"computed (char. table)"],
["A14.2",["Characteristic",5],13,"computed (char. table)"],
["A14.2",["Characteristic",7],12,"computed (char. table)"],
["A14.2",["Characteristic",11],13,"computed (char. table)"],
["A14.2",["Characteristic",13],13,"computed (char. table)"],
["A14.2",["Size",2],12,"computed (char. table)"],
["A14.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A14.2",["Size",3],13,"computed (char. table)"],
["A14.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A14.2",["Size",5],13,"computed (char. table)"],
["A14.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A14.2",["Size",7],12,"computed (char. table)"],
["A14.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A14.2",["Size",11],13,"computed (char. table)"],
["A14.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A14.2",["Size",13],13,"computed (char. table)"],
["A14.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["A15","NrMovedPoints",15,"computed (alternating group)"],
["A15",["Characteristic",0],14,"computed (char. table)"],
["A15.2","NrMovedPoints",15,"computed (subgroup tables, known repres.)"],
["A15.2","NrMovedPoints",15,"computed (symmetric group)"],
["A15.2",["Characteristic",0],14,"computed (char. table)"],
["A15.2",["Characteristic",2],14,"computed (char. table)"],
["A15.2",["Characteristic",3],13,"computed (char. table)"],
["A15.2",["Characteristic",5],13,"computed (char. table)"],
["A15.2",["Characteristic",7],14,"computed (char. table)"],
["A15.2",["Characteristic",11],14,"computed (char. table)"],
["A15.2",["Characteristic",13],14,"computed (char. table)"],
["A15.2",["Size",2],14,"computed (char. table)"],
["A15.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A15.2",["Size",3],13,"computed (char. table)"],
["A15.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A15.2",["Size",5],13,"computed (char. table)"],
["A15.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A15.2",["Size",7],14,"computed (char. table)"],
["A15.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A15.2",["Size",11],14,"computed (char. table)"],
["A15.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A15.2",["Size",13],14,"computed (char. table)"],
["A15.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["A16","NrMovedPoints",16,"computed (alternating group)"],
["A16",["Characteristic",0],15,"computed (char. table)"],
["A16.2","NrMovedPoints",16,"computed (subgroup tables, known repres.)"],
["A16.2","NrMovedPoints",16,"computed (symmetric group)"],
["A16.2",["Characteristic",0],15,"computed (char. table)"],
["A16.2",["Characteristic",2],14,"computed (char. table)"],
["A16.2",["Characteristic",3],15,"computed (char. table)"],
["A16.2",["Characteristic",5],15,"computed (char. table)"],
["A16.2",["Characteristic",7],15,"computed (char. table)"],
["A16.2",["Characteristic",11],15,"computed (char. table)"],
["A16.2",["Characteristic",13],15,"computed (char. table)"],
["A16.2",["Size",2],14,"computed (char. table)"],
["A16.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A16.2",["Size",3],15,"computed (char. table)"],
["A16.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A16.2",["Size",5],15,"computed (char. table)"],
["A16.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A16.2",["Size",7],15,"computed (char. table)"],
["A16.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A16.2",["Size",11],15,"computed (char. table)"],
["A16.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A16.2",["Size",13],15,"computed (char. table)"],
["A16.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["A17","NrMovedPoints",17,"computed (alternating group)"],
["A17","NrMovedPoints",17,"computed (subgroup tables, known repres.)"],
["A17",["Characteristic",0],16,"computed (char. table)"],
["A17.2","NrMovedPoints",17,"computed (subgroup tables, known repres.)"],
["A17.2","NrMovedPoints",17,"computed (symmetric group)"],
["A17.2",["Characteristic",0],16,"computed (char. table)"],
["A17.2",["Characteristic",2],16,"computed (char. table)"],
["A17.2",["Characteristic",3],16,"computed (char. table)"],
["A17.2",["Characteristic",5],16,"computed (char. table)"],
["A17.2",["Characteristic",7],16,"computed (char. table)"],
["A17.2",["Characteristic",11],16,"computed (char. table)"],
["A17.2",["Characteristic",13],16,"computed (char. table)"],
["A17.2",["Characteristic",17],15,"computed (char. table)"],
["A17.2",["Size",2],16,"computed (char. table)"],
["A17.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A17.2",["Size",3],16,"computed (char. table)"],
["A17.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A17.2",["Size",5],16,"computed (char. table)"],
["A17.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A17.2",["Size",7],16,"computed (char. table)"],
["A17.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A17.2",["Size",11],16,"computed (char. table)"],
["A17.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["A17.2",["Size",13],16,"computed (char. table)"],
["A17.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["A17.2",["Size",17],15,"computed (char. table)"],
["A17.2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["A18","NrMovedPoints",18,"computed (alternating group)"],
["A18",["Characteristic",0],17,"computed (char. table)"],
["A18.2","NrMovedPoints",18,"computed (subgroup tables, known repres.)"],
["A18.2","NrMovedPoints",18,"computed (symmetric group)"],
["A18.2",["Characteristic",0],17,"computed (char. table)"],
["A19","NrMovedPoints",19,"computed (alternating group)"],
["A19.2","NrMovedPoints",19,"computed (symmetric group)"],
["A20","NrMovedPoints",20,"computed (alternating group)"],
["A20.2","NrMovedPoints",20,"computed (symmetric group)"],
["A21","NrMovedPoints",21,"computed (alternating group)"],
["A21.2","NrMovedPoints",21,"computed (symmetric group)"],
["A22","NrMovedPoints",22,"computed (alternating group)"],
["A22.2","NrMovedPoints",22,"computed (symmetric group)"],
["A23","NrMovedPoints",23,"computed (alternating group)"],
["A23.2","NrMovedPoints",23,"computed (symmetric group)"],
["A5","NrMovedPoints",5,"computed (alternating group)"],
["A5","NrMovedPoints",5,"computed (char. table)"],
["A5","NrMovedPoints",5,"computed (subgroup tables)"],
["A5","NrMovedPoints",5,"computed (subgroup tables, known repres.)"],
["A5","NrMovedPoints",5,"computed (table of marks)"],
["A5",["Characteristic",0],3,"computed (char. table)"],
["A5",["Characteristic",2],2,"computed (char. table)"],
["A5",["Characteristic",3],3,"computed (char. table)"],
["A5",["Characteristic",5],3,"computed (char. table)"],
["A5",["Size",2],4,"computed (char. table)"],
["A5",["Size",4],2,"computed (char. table)"],
["A5",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A5",["Size",3],4,"computed (char. table)"],
["A5",["Size",9],3,"computed (char. table)"],
["A5",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A5",["Size",5],3,"computed (char. table)"],
["A5",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A5.2","NrMovedPoints",5,"computed (char. table)"],
["A5.2","NrMovedPoints",5,"computed (subgroup tables)"],
["A5.2","NrMovedPoints",5,"computed (subgroup tables, known repres.)"],
["A5.2","NrMovedPoints",5,"computed (symmetric group)"],
["A5.2","NrMovedPoints",5,"computed (table of marks)"],
["A5.2",["Characteristic",0],4,"computed (char. table)"],
["A5.2",["Characteristic",2],4,"computed (char. table)"],
["A5.2",["Characteristic",3],4,"computed (char. table)"],
["A5.2",["Characteristic",5],3,"computed (char. table)"],
["A5.2",["Size",2],4,"computed (char. table)"],
["A5.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A5.2",["Size",3],4,"computed (char. table)"],
["A5.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A5.2",["Size",5],3,"computed (char. table)"],
["A5.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A6","NrMovedPoints",6,"computed (alternating group)"],
["A6","NrMovedPoints",6,"computed (char. table)"],
["A6","NrMovedPoints",6,"computed (table of marks)"],
["A6",["Characteristic",0],5,"computed (char. table)"],
["A6",["Characteristic",2],4,"computed (char. table)"],
["A6",["Characteristic",3],3,"computed (char. table)"],
["A6",["Characteristic",5],5,"computed (char. table)"],
["A6",["Size",2],4,"computed (char. table)"],
["A6",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A6",["Size",3],4,"computed (char. table)"],
["A6",["Size",9],3,"computed (char. table)"],
["A6",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A6",["Size",5],5,"computed (char. table)"],
["A6",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A6.2^2","NrMovedPoints",10,"computed (subgroup tables)"],
["A6.2^2","NrMovedPoints",10,"computed (subgroup tables, known repres.)"],
["A6.2^2","NrMovedPoints",10,"computed (table of marks)"],
["A6.2^2",["Characteristic",0],9,"computed (char. table)"],
["A6.2^2",["Characteristic",2],8,"computed (char. table)"],
["A6.2^2",["Characteristic",3],6,"computed (char. table)"],
["A6.2^2",["Characteristic",5],8,"computed (char. table)"],
["A6.2^2",["Size",2],8,"computed (char. table)"],
["A6.2^2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A6.2^2",["Size",3],6,"computed (char. table)"],
["A6.2^2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A6.2^2",["Size",5],8,"computed (char. table)"],
["A6.2^2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A6.2_1","NrMovedPoints",6,"computed (char. table)"],
["A6.2_1","NrMovedPoints",6,"computed (subgroup tables)"],
["A6.2_1","NrMovedPoints",6,"computed (subgroup tables, known repres.)"],
["A6.2_1","NrMovedPoints",6,"computed (table of marks)"],
["A6.2_1",["Characteristic",0],5,"computed (char. table)"],
["A6.2_1",["Characteristic",2],4,"computed (char. table)"],
["A6.2_1",["Characteristic",3],4,"computed (char. table)"],
["A6.2_1",["Characteristic",5],5,"computed (char. table)"],
["A6.2_1",["Size",2],4,"computed (char. table)"],
["A6.2_1",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A6.2_1",["Size",3],4,"computed (char. table)"],
["A6.2_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A6.2_1",["Size",5],5,"computed (char. table)"],
["A6.2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A6.2_2","NrMovedPoints",10,"computed (table of marks)"],
["A6.2_2",["Characteristic",0],8,"computed (char. table)"],
["A6.2_2",["Characteristic",2],8,"computed (char. table)"],
["A6.2_2",["Characteristic",3],3,"computed (char. table)"],
["A6.2_2",["Characteristic",5],8,"computed (char. table)"],
["A6.2_2",["Size",2],8,"computed (char. table)"],
["A6.2_2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A6.2_2",["Size",3],6,"computed (char. table)"],
["A6.2_2",["Size",9],3,"computed (char. table)"],
["A6.2_2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A6.2_2",["Size",5],8,"computed (char. table)"],
["A6.2_2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A6.2_3","NrMovedPoints",10,"computed (table of marks)"],
["A6.2_3",["Characteristic",0],9,"computed (char. table)"],
["A6.2_3",["Characteristic",2],8,"computed (char. table)"],
["A6.2_3",["Characteristic",3],4,"computed (char. table)"],
["A6.2_3",["Characteristic",5],8,"computed (char. table)"],
["A6.2_3",["Size",2],8,"computed (char. table)"],
["A6.2_3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A6.2_3",["Size",3],4,"computed (char. table)"],
["A6.2_3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A6.2_3",["Size",5],8,"computed (char. table)"],
["A6.2_3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A7","NrMovedPoints",7,"computed (alternating group)"],
["A7","NrMovedPoints",7,"computed (char. table)"],
["A7","NrMovedPoints",7,"computed (subgroup tables)"],
["A7","NrMovedPoints",7,"computed (subgroup tables, known repres.)"],
["A7","NrMovedPoints",7,"computed (table of marks)"],
["A7",["Characteristic",0],6,"computed (char. table)"],
["A7",["Characteristic",2],4,"computed (char. table)"],
["A7",["Characteristic",3],6,"computed (char. table)"],
["A7",["Characteristic",5],6,"computed (char. table)"],
["A7",["Characteristic",7],5,"computed (char. table)"],
["A7",["Size",2],4,"computed (char. table)"],
["A7",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A7",["Size",3],6,"computed (char. table)"],
["A7",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A7",["Size",5],6,"computed (char. table)"],
["A7",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A7",["Size",7],5,"computed (char. table)"],
["A7",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A7.2","NrMovedPoints",7,"computed (char. table)"],
["A7.2","NrMovedPoints",7,"computed (subgroup tables)"],
["A7.2","NrMovedPoints",7,"computed (subgroup tables, known repres.)"],
["A7.2","NrMovedPoints",7,"computed (symmetric group)"],
["A7.2","NrMovedPoints",7,"computed (table of marks)"],
["A7.2",["Characteristic",0],6,"computed (char. table)"],
["A7.2",["Characteristic",2],6,"computed (char. table)"],
["A7.2",["Characteristic",3],6,"computed (char. table)"],
["A7.2",["Characteristic",5],6,"computed (char. table)"],
["A7.2",["Characteristic",7],5,"computed (char. table)"],
["A7.2",["Size",2],6,"computed (char. table)"],
["A7.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A7.2",["Size",3],6,"computed (char. table)"],
["A7.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A7.2",["Size",5],6,"computed (char. table)"],
["A7.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A7.2",["Size",7],5,"computed (char. table)"],
["A7.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A8","NrMovedPoints",8,"computed (alternating group)"],
["A8","NrMovedPoints",8,"computed (char. table)"],
["A8","NrMovedPoints",8,"computed (subgroup tables)"],
["A8","NrMovedPoints",8,"computed (subgroup tables, known repres.)"],
["A8","NrMovedPoints",8,"computed (table of marks)"],
["A8",["Characteristic",0],7,"computed (char. table)"],
["A8",["Characteristic",2],4,"computed (char. table)"],
["A8",["Characteristic",3],7,"computed (char. table)"],
["A8",["Characteristic",5],7,"computed (char. table)"],
["A8",["Characteristic",7],7,"computed (char. table)"],
["A8",["Size",2],4,"computed (char. table)"],
["A8",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A8",["Size",3],7,"computed (char. table)"],
["A8",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A8",["Size",5],7,"computed (char. table)"],
["A8",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A8",["Size",7],7,"computed (char. table)"],
["A8",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A8.2","NrMovedPoints",8,"computed (subgroup tables)"],
["A8.2","NrMovedPoints",8,"computed (subgroup tables, known repres.)"],
["A8.2","NrMovedPoints",8,"computed (symmetric group)"],
["A8.2","NrMovedPoints",8,"computed (table of marks)"],
["A8.2",["Characteristic",0],7,"computed (char. table)"],
["A8.2",["Characteristic",2],6,"computed (char. table)"],
["A8.2",["Characteristic",3],7,"computed (char. table)"],
["A8.2",["Characteristic",5],7,"computed (char. table)"],
["A8.2",["Characteristic",7],7,"computed (char. table)"],
["A8.2",["Size",2],6,"computed (char. table)"],
["A8.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A8.2",["Size",3],7,"computed (char. table)"],
["A8.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A8.2",["Size",5],7,"computed (char. table)"],
["A8.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A8.2",["Size",7],7,"computed (char. table)"],
["A8.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A9","NrMovedPoints",9,"computed (alternating group)"],
["A9","NrMovedPoints",9,"computed (char. table)"],
["A9","NrMovedPoints",9,"computed (subgroup tables)"],
["A9","NrMovedPoints",9,"computed (subgroup tables, known repres.)"],
["A9","NrMovedPoints",9,"computed (table of marks)"],
["A9",["Characteristic",0],8,"computed (char. table)"],
["A9",["Characteristic",2],8,"computed (char. table)"],
["A9",["Characteristic",3],7,"computed (char. table)"],
["A9",["Characteristic",5],8,"computed (char. table)"],
["A9",["Characteristic",7],8,"computed (char. table)"],
["A9",["Size",2],8,"computed (char. table)"],
["A9",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A9",["Size",3],7,"computed (char. table)"],
["A9",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A9",["Size",5],8,"computed (char. table)"],
["A9",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A9",["Size",7],8,"computed (char. table)"],
["A9",["Characteristic",7,"complete"],true,"computed (char. table)"],
["A9.2","NrMovedPoints",9,"computed (char. table)"],
["A9.2","NrMovedPoints",9,"computed (subgroup tables)"],
["A9.2","NrMovedPoints",9,"computed (subgroup tables, known repres.)"],
["A9.2","NrMovedPoints",9,"computed (symmetric group)"],
["A9.2","NrMovedPoints",9,"computed (table of marks)"],
["A9.2",["Characteristic",0],8,"computed (char. table)"],
["A9.2",["Characteristic",2],8,"computed (char. table)"],
["A9.2",["Characteristic",3],7,"computed (char. table)"],
["A9.2",["Characteristic",5],8,"computed (char. table)"],
["A9.2",["Characteristic",7],8,"computed (char. table)"],
["A9.2",["Size",2],8,"computed (char. table)"],
["A9.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["A9.2",["Size",3],7,"computed (char. table)"],
["A9.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["A9.2",["Size",5],8,"computed (char. table)"],
["A9.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["A9.2",["Size",7],8,"computed (char. table)"],
["A9.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["B","NrMovedPoints",13571955000,"computed (char. table)"],
["B",["Characteristic",0],4371,"computed (char. table)"],
["B",["Characteristic",11],4371,"computed (char. table)"],
["B",["Characteristic",13],4371,"computed (char. table)"],
["B",["Characteristic",17],4371,"computed (char. table)"],
["B",["Characteristic",23],4371,"computed (char. table)"],
["B",["Characteristic",31],4371,"computed (char. table)"],
["Co1","NrMovedPoints",98280,"computed (char. table)"],
["Co1",["Characteristic",0],276,"computed (char. table)"],
["Co1",["Characteristic",7],276,"computed (char. table)"],
["Co1",["Characteristic",11],276,"computed (char. table)"],
["Co1",["Characteristic",13],276,"computed (char. table)"],
["Co1",["Characteristic",23],276,"computed (char. table)"],
["Co1",["Size",7],276,"computed (char. table)"],
["Co1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Co1",["Size",11],276,"computed (char. table)"],
["Co1",["Characteristic",11,"complete"],true,"computed (char. table)"],
["Co1",["Size",13],276,"computed (char. table)"],
["Co1",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Co1",["Size",23],276,"computed (char. table)"],
["Co1",["Characteristic",23,"complete"],true,"computed (char. table)"],
["Co2","NrMovedPoints",2300,"computed (char. table)"],
["Co2",["Characteristic",0],23,"computed (char. table)"],
["Co2",["Characteristic",2],22,"computed (char. table)"],
["Co2",["Characteristic",3],23,"computed (char. table)"],
["Co2",["Characteristic",5],23,"computed (char. table)"],
["Co2",["Characteristic",7],23,"computed (char. table)"],
["Co2",["Characteristic",11],23,"computed (char. table)"],
["Co2",["Characteristic",23],23,"computed (char. table)"],
["Co2",["Size",2],22,"computed (char. table)"],
["Co2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Co2",["Size",3],23,"computed (char. table)"],
["Co2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Co2",["Size",5],23,"computed (char. table)"],
["Co2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Co2",["Size",7],23,"computed (char. table)"],
["Co2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Co2",["Size",11],23,"computed (char. table)"],
["Co2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["Co2",["Size",23],23,"computed (char. table)"],
["Co2",["Characteristic",23,"complete"],true,"computed (char. table)"],
["Co3","NrMovedPoints",276,"computed (char. table)"],
["Co3","NrMovedPoints",276,"computed (table of marks)"],
["Co3",["Characteristic",0],23,"computed (char. table)"],
["Co3",["Characteristic",2],22,"computed (char. table)"],
["Co3",["Characteristic",3],22,"computed (char. table)"],
["Co3",["Characteristic",5],23,"computed (char. table)"],
["Co3",["Characteristic",7],23,"computed (char. table)"],
["Co3",["Characteristic",11],23,"computed (char. table)"],
["Co3",["Characteristic",23],23,"computed (char. table)"],
["Co3",["Size",2],22,"computed (char. table)"],
["Co3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Co3",["Size",3],22,"computed (char. table)"],
["Co3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Co3",["Size",5],23,"computed (char. table)"],
["Co3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Co3",["Size",7],23,"computed (char. table)"],
["Co3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Co3",["Size",11],23,"computed (char. table)"],
["Co3",["Characteristic",11,"complete"],true,"computed (char. table)"],
["Co3",["Size",23],23,"computed (char. table)"],
["Co3",["Characteristic",23,"complete"],true,"computed (char. table)"],
["E6(2)",["Characteristic",0],2482,"computed (char. table)"],
["F4(2)","NrMovedPoints",69615,"computed (char. table)"],
["F4(2)",["Characteristic",0],833,"computed (char. table)"],
["F4(2)",["Characteristic",5],833,"computed (char. table)"],
["F4(2)",["Characteristic",7],833,"computed (char. table)"],
["F4(2)",["Characteristic",13],833,"computed (char. table)"],
["F4(2)",["Characteristic",17],833,"computed (char. table)"],
["F4(2)",["Size",5],833,"computed (char. table)"],
["F4(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["F4(2)",["Size",7],833,"computed (char. table)"],
["F4(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["F4(2)",["Size",13],833,"computed (char. table)"],
["F4(2)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["F4(2)",["Size",17],833,"computed (char. table)"],
["F4(2)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["F4(2).2",["Characteristic",0],833,"computed (char. table)"],
["F4(2).2",["Characteristic",13],833,"computed (char. table)"],
["F4(2).2",["Characteristic",17],833,"computed (char. table)"],
["F4(2).2",["Size",13],833,"computed (char. table)"],
["F4(2).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["F4(2).2",["Size",17],833,"computed (char. table)"],
["F4(2).2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["Fi22","NrMovedPoints",3510,"computed (char. table)"],
["Fi22",["Characteristic",0],78,"computed (char. table)"],
["Fi22",["Characteristic",2],78,"computed (char. table)"],
["Fi22",["Characteristic",3],77,"computed (char. table)"],
["Fi22",["Characteristic",5],78,"computed (char. table)"],
["Fi22",["Characteristic",7],78,"computed (char. table)"],
["Fi22",["Characteristic",11],78,"computed (char. table)"],
["Fi22",["Characteristic",13],78,"computed (char. table)"],
["Fi22",["Size",2],78,"computed (char. table)"],
["Fi22",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Fi22",["Size",3],77,"computed (char. table)"],
["Fi22",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Fi22",["Size",5],78,"computed (char. table)"],
["Fi22",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Fi22",["Size",7],78,"computed (char. table)"],
["Fi22",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Fi22",["Size",11],78,"computed (char. table)"],
["Fi22",["Characteristic",11,"complete"],true,"computed (char. table)"],
["Fi22",["Size",13],78,"computed (char. table)"],
["Fi22",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Fi22.2","NrMovedPoints",3510,"computed (subgroup tables)"],
["Fi22.2","NrMovedPoints",3510,"computed (subgroup tables, known repres.)"],
["Fi22.2",["Characteristic",0],78,"computed (char. table)"],
["Fi22.2",["Characteristic",2],78,"computed (char. table)"],
["Fi22.2",["Characteristic",3],77,"computed (char. table)"],
["Fi22.2",["Characteristic",5],78,"computed (char. table)"],
["Fi22.2",["Characteristic",7],78,"computed (char. table)"],
["Fi22.2",["Characteristic",11],78,"computed (char. table)"],
["Fi22.2",["Characteristic",13],78,"computed (char. table)"],
["Fi22.2",["Size",2],78,"computed (char. table)"],
["Fi22.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Fi22.2",["Size",3],77,"computed (char. table)"],
["Fi22.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Fi22.2",["Size",5],78,"computed (char. table)"],
["Fi22.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Fi22.2",["Size",7],78,"computed (char. table)"],
["Fi22.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Fi22.2",["Size",11],78,"computed (char. table)"],
["Fi22.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["Fi22.2",["Size",13],78,"computed (char. table)"],
["Fi22.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Fi23","NrMovedPoints",31671,"computed (char. table)"],
["Fi23",["Characteristic",0],782,"computed (char. table)"],
["Fi23",["Characteristic",2],782,"computed (char. table)"],
["Fi23",["Characteristic",5],782,"computed (char. table)"],
["Fi23",["Characteristic",7],782,"computed (char. table)"],
["Fi23",["Characteristic",11],782,"computed (char. table)"],
["Fi23",["Characteristic",13],782,"computed (char. table)"],
["Fi23",["Characteristic",17],782,"computed (char. table)"],
["Fi23",["Characteristic",23],782,"computed (char. table)"],
["Fi23",["Size",2],782,"computed (char. table)"],
["Fi23",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Fi23",["Size",5],782,"computed (char. table)"],
["Fi23",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Fi23",["Size",7],782,"computed (char. table)"],
["Fi23",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Fi23",["Size",11],782,"computed (char. table)"],
["Fi23",["Characteristic",11,"complete"],true,"computed (char. table)"],
["Fi23",["Size",13],782,"computed (char. table)"],
["Fi23",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Fi23",["Size",23],782,"computed (char. table)"],
["Fi23",["Characteristic",23,"complete"],true,"computed (char. table)"],
["Fi24'","NrMovedPoints",306936,"computed (char. table)"],
["Fi24'",["Characteristic",0],8671,"computed (char. table)"],
["Fi24'",["Characteristic",11],8671,"computed (char. table)"],
["Fi24'",["Characteristic",17],8671,"computed (char. table)"],
["Fi24'",["Characteristic",23],8671,"computed (char. table)"],
["Fi24'",["Characteristic",29],8671,"computed (char. table)"],
["Fi24'",["Size",23],8671,"computed (char. table)"],
["Fi24'",["Characteristic",23,"complete"],true,"computed (char. table)"],
["Fi24'",["Size",29],8671,"computed (char. table)"],
["Fi24'",["Characteristic",29,"complete"],true,"computed (char. table)"],
["Fi24'.2","NrMovedPoints",306936,"computed (subgroup tables)"],
["Fi24'.2","NrMovedPoints",306936,"computed (subgroup tables, known repres.)"],
["Fi24'.2",["Characteristic",0],8671,"computed (char. table)"],
["Fi24'.2",["Characteristic",11],8671,"computed (char. table)"],
["Fi24'.2",["Characteristic",13],8671,"computed (char. table)"],
["Fi24'.2",["Characteristic",17],8671,"computed (char. table)"],
["Fi24'.2",["Characteristic",23],8671,"computed (char. table)"],
["Fi24'.2",["Characteristic",29],8671,"computed (char. table)"],
["Fi24'.2",["Size",11],8671,"computed (char. table)"],
["Fi24'.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["Fi24'.2",["Size",13],8671,"computed (char. table)"],
["Fi24'.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Fi24'.2",["Size",23],8671,"computed (char. table)"],
["Fi24'.2",["Characteristic",23,"complete"],true,"computed (char. table)"],
["Fi24'.2",["Size",29],8671,"computed (char. table)"],
["Fi24'.2",["Characteristic",29,"complete"],true,"computed (char. table)"],
["G2(3)","NrMovedPoints",351,"computed (char. table)"],
["G2(3)","NrMovedPoints",351,"computed (table of marks)"],
["G2(3)",["Characteristic",0],14,"computed (char. table)"],
["G2(3)",["Characteristic",2],14,"computed (char. table)"],
["G2(3)",["Characteristic",3],7,"computed (char. table)"],
["G2(3)",["Characteristic",7],14,"computed (char. table)"],
["G2(3)",["Characteristic",13],14,"computed (char. table)"],
["G2(3)",["Size",2],14,"computed (char. table)"],
["G2(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["G2(3)",["Size",3],7,"computed (char. table)"],
["G2(3)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["G2(3)",["Size",7],14,"computed (char. table)"],
["G2(3)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["G2(3)",["Size",13],14,"computed (char. table)"],
["G2(3)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["G2(3).2","NrMovedPoints",702,"computed (table of marks)"],
["G2(3).2",["Characteristic",0],14,"computed (char. table)"],
["G2(3).2",["Characteristic",2],14,"computed (char. table)"],
["G2(3).2",["Characteristic",3],14,"computed (char. table)"],
["G2(3).2",["Characteristic",7],14,"computed (char. table)"],
["G2(3).2",["Characteristic",13],14,"computed (char. table)"],
["G2(3).2",["Size",2],14,"computed (char. table)"],
["G2(3).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["G2(3).2",["Size",3],14,"computed (char. table)"],
["G2(3).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["G2(3).2",["Size",7],14,"computed (char. table)"],
["G2(3).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["G2(3).2",["Size",13],14,"computed (char. table)"],
["G2(3).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["G2(4)","NrMovedPoints",416,"computed (char. table)"],
["G2(4)","NrMovedPoints",416,"computed (table of marks)"],
["G2(4)",["Characteristic",0],65,"computed (char. table)"],
["G2(4)",["Characteristic",2],6,"computed (char. table)"],
["G2(4)",["Characteristic",3],64,"computed (char. table)"],
["G2(4)",["Characteristic",5],65,"computed (char. table)"],
["G2(4)",["Characteristic",7],65,"computed (char. table)"],
["G2(4)",["Characteristic",13],65,"computed (char. table)"],
["G2(4)",["Size",2],12,"computed (char. table)"],
["G2(4)",["Size",4],6,"computed (char. table)"],
["G2(4)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["G2(4)",["Size",3],64,"computed (char. table)"],
["G2(4)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["G2(4)",["Size",5],65,"computed (char. table)"],
["G2(4)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["G2(4)",["Size",7],65,"computed (char. table)"],
["G2(4)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["G2(4)",["Size",13],65,"computed (char. table)"],
["G2(4)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["G2(4).2","NrMovedPoints",416,"computed (subgroup tables)"],
["G2(4).2",["Characteristic",0],65,"computed (char. table)"],
["G2(4).2",["Characteristic",2],12,"computed (char. table)"],
["G2(4).2",["Characteristic",3],64,"computed (char. table)"],
["G2(4).2",["Characteristic",5],65,"computed (char. table)"],
["G2(4).2",["Characteristic",7],65,"computed (char. table)"],
["G2(4).2",["Characteristic",13],65,"computed (char. table)"],
["G2(4).2",["Size",2],12,"computed (char. table)"],
["G2(4).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["G2(4).2",["Size",3],64,"computed (char. table)"],
["G2(4).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["G2(4).2",["Size",5],65,"computed (char. table)"],
["G2(4).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["G2(4).2",["Size",7],65,"computed (char. table)"],
["G2(4).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["G2(4).2",["Size",13],65,"computed (char. table)"],
["G2(4).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["G2(5)","NrMovedPoints",3906,"computed (char. table)"],
["G2(5)",["Characteristic",0],124,"computed (char. table)"],
["G2(5)",["Characteristic",2],124,"computed (char. table)"],
["G2(5)",["Characteristic",3],124,"computed (char. table)"],
["G2(5)",["Characteristic",5],7,"computed (char. table)"],
["G2(5)",["Characteristic",7],124,"computed (char. table)"],
["G2(5)",["Characteristic",31],124,"computed (char. table)"],
["G2(5)",["Size",2],124,"computed (char. table)"],
["G2(5)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["G2(5)",["Size",3],124,"computed (char. table)"],
["G2(5)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["G2(5)",["Size",5],7,"computed (char. table)"],
["G2(5)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["G2(5)",["Size",7],124,"computed (char. table)"],
["G2(5)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["G2(5)",["Size",31],124,"computed (char. table)"],
["G2(5)",["Characteristic",31,"complete"],true,"computed (char. table)"],
["HN","NrMovedPoints",1140000,"computed (char. table)"],
["HN",["Characteristic",0],133,"computed (char. table)"],
["HN",["Characteristic",2],132,"computed (char. table)"],
["HN",["Characteristic",5],133,"computed (char. table)"],
["HN",["Characteristic",7],133,"computed (char. table)"],
["HN",["Characteristic",11],133,"computed (char. table)"],
["HN",["Characteristic",19],133,"computed (char. table)"],
["HN",["Size",2],264,"computed (char. table)"],
["HN",["Size",4],132,"computed (char. table)"],
["HN",["Characteristic",2,"complete"],true,"computed (char. table)"],
["HN",["Size",5],133,"computed (char. table)"],
["HN",["Characteristic",5,"complete"],true,"computed (char. table)"],
["HN",["Size",7],266,"computed (char. table)"],
["HN",["Size",49],133,"computed (char. table)"],
["HN",["Characteristic",7,"complete"],true,"computed (char. table)"],
["HN",["Size",11],133,"computed (char. table)"],
["HN",["Characteristic",11,"complete"],true,"computed (char. table)"],
["HN",["Size",19],133,"computed (char. table)"],
["HN",["Characteristic",19,"complete"],true,"computed (char. table)"],
["HN.2","NrMovedPoints",1140000,"computed (subgroup tables)"],
["HN.2",["Characteristic",0],266,"computed (char. table)"],
["HN.2",["Characteristic",2],264,"computed (char. table)"],
["HN.2",["Characteristic",5],133,"computed (char. table)"],
["HN.2",["Characteristic",7],266,"computed (char. table)"],
["HN.2",["Characteristic",11],266,"computed (char. table)"],
["HN.2",["Characteristic",19],266,"computed (char. table)"],
["HN.2",["Size",2],264,"computed (char. table)"],
["HN.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["HN.2",["Size",5],133,"computed (char. table)"],
["HN.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["HN.2",["Size",7],266,"computed (char. table)"],
["HN.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["HN.2",["Size",11],266,"computed (char. table)"],
["HN.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["HN.2",["Size",19],266,"computed (char. table)"],
["HN.2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["HS","NrMovedPoints",100,"computed (char. table)"],
["HS","NrMovedPoints",100,"computed (table of marks)"],
["HS",["Characteristic",0],22,"computed (char. table)"],
["HS",["Characteristic",2],20,"computed (char. table)"],
["HS",["Characteristic",3],22,"computed (char. table)"],
["HS",["Characteristic",5],21,"computed (char. table)"],
["HS",["Characteristic",7],22,"computed (char. table)"],
["HS",["Characteristic",11],22,"computed (char. table)"],
["HS",["Size",2],20,"computed (char. table)"],
["HS",["Characteristic",2,"complete"],true,"computed (char. table)"],
["HS",["Size",3],22,"computed (char. table)"],
["HS",["Characteristic",3,"complete"],true,"computed (char. table)"],
["HS",["Size",5],21,"computed (char. table)"],
["HS",["Characteristic",5,"complete"],true,"computed (char. table)"],
["HS",["Size",7],22,"computed (char. table)"],
["HS",["Characteristic",7,"complete"],true,"computed (char. table)"],
["HS",["Size",11],22,"computed (char. table)"],
["HS",["Characteristic",11,"complete"],true,"computed (char. table)"],
["HS.2","NrMovedPoints",100,"computed (subgroup tables)"],
["HS.2","NrMovedPoints",100,"computed (subgroup tables, known repres.)"],
["HS.2",["Characteristic",0],22,"computed (char. table)"],
["HS.2",["Characteristic",2],20,"computed (char. table)"],
["HS.2",["Characteristic",3],22,"computed (char. table)"],
["HS.2",["Characteristic",5],21,"computed (char. table)"],
["HS.2",["Characteristic",7],22,"computed (char. table)"],
["HS.2",["Characteristic",11],22,"computed (char. table)"],
["HS.2",["Size",2],20,"computed (char. table)"],
["HS.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["HS.2",["Size",3],22,"computed (char. table)"],
["HS.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["HS.2",["Size",5],21,"computed (char. table)"],
["HS.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["HS.2",["Size",7],22,"computed (char. table)"],
["HS.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["HS.2",["Size",11],22,"computed (char. table)"],
["HS.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["He","NrMovedPoints",2058,"computed (char. table)"],
["He","NrMovedPoints",2058,"computed (table of marks)"],
["He",["Characteristic",0],51,"computed (char. table)"],
["He",["Characteristic",2],51,"computed (char. table)"],
["He",["Characteristic",3],51,"computed (char. table)"],
["He",["Characteristic",5],51,"computed (char. table)"],
["He",["Characteristic",7],50,"computed (char. table)"],
["He",["Characteristic",17],51,"computed (char. table)"],
["He",["Size",2],51,"computed (char. table)"],
["He",["Characteristic",2,"complete"],true,"computed (char. table)"],
["He",["Size",3],102,"computed (char. table)"],
["He",["Size",9],51,"computed (char. table)"],
["He",["Characteristic",3,"complete"],true,"computed (char. table)"],
["He",["Size",5],102,"computed (char. table)"],
["He",["Size",25],51,"computed (char. table)"],
["He",["Characteristic",5,"complete"],true,"computed (char. table)"],
["He",["Size",7],50,"computed (char. table)"],
["He",["Characteristic",7,"complete"],true,"computed (char. table)"],
["He",["Size",17],102,"computed (char. table)"],
["He",["Size",289],51,"computed (char. table)"],
["He",["Characteristic",17,"complete"],true,"computed (char. table)"],
["He.2","NrMovedPoints",2058,"computed (subgroup tables)"],
["He.2","NrMovedPoints",2058,"computed (subgroup tables, known repres.)"],
["He.2",["Characteristic",0],102,"computed (char. table)"],
["He.2",["Characteristic",2],102,"computed (char. table)"],
["He.2",["Characteristic",3],102,"computed (char. table)"],
["He.2",["Characteristic",5],102,"computed (char. table)"],
["He.2",["Characteristic",7],50,"computed (char. table)"],
["He.2",["Characteristic",17],102,"computed (char. table)"],
["He.2",["Size",2],102,"computed (char. table)"],
["He.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["He.2",["Size",3],102,"computed (char. table)"],
["He.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["He.2",["Size",5],102,"computed (char. table)"],
["He.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["He.2",["Size",7],50,"computed (char. table)"],
["He.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["He.2",["Size",17],102,"computed (char. table)"],
["He.2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["Isoclinic(2.A14.2)",["Characteristic",0],64,"computed (char. table)"],
["Isoclinic(2.A5.2)","NrMovedPoints",48,"computed (table of marks)"],
["Isoclinic(2.A5.2)",["Characteristic",0],4,"computed (char. table)"],
["Isoclinic(2.A5.2)",["Characteristic",3],4,"computed (char. table)"],
["Isoclinic(2.A5.2)",["Characteristic",5],2,"computed (char. table)"],
["Isoclinic(2.A5.2)",["Size",3],4,"computed (char. table)"],
["Isoclinic(2.A5.2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Isoclinic(2.A5.2)",["Size",5],4,"computed (char. table)"],
["Isoclinic(2.A5.2)",["Size",25],2,"computed (char. table)"],
["Isoclinic(2.A5.2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Isoclinic(2.A7.2)","NrMovedPoints",240,"computed (table of marks)"],
["Isoclinic(2.A7.2)",["Characteristic",0],8,"computed (char. table)"],
["Isoclinic(2.A7.2)",["Characteristic",3],8,"computed (char. table)"],
["Isoclinic(2.A7.2)",["Characteristic",5],8,"computed (char. table)"],
["Isoclinic(2.A7.2)",["Characteristic",7],4,"computed (char. table)"],
["Isoclinic(2.A7.2)",["Size",3],8,"computed (char. table)"],
["Isoclinic(2.A7.2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Isoclinic(2.A7.2)",["Size",5],8,"computed (char. table)"],
["Isoclinic(2.A7.2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Isoclinic(2.A7.2)",["Size",7],4,"computed (char. table)"],
["Isoclinic(2.A7.2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Isoclinic(2.A8.2)","NrMovedPoints",240,"computed (table of marks)"],
["Isoclinic(2.A8.2)",["Characteristic",0],8,"computed (char. table)"],
["Isoclinic(2.A8.2)",["Characteristic",3],8,"computed (char. table)"],
["Isoclinic(2.A8.2)",["Characteristic",5],8,"computed (char. table)"],
["Isoclinic(2.A8.2)",["Characteristic",7],8,"computed (char. table)"],
["Isoclinic(2.A8.2)",["Size",3],8,"computed (char. table)"],
["Isoclinic(2.A8.2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Isoclinic(2.A8.2)",["Size",5],8,"computed (char. table)"],
["Isoclinic(2.A8.2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Isoclinic(2.A8.2)",["Size",7],8,"computed (char. table)"],
["Isoclinic(2.A8.2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Characteristic",0],12,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Characteristic",3],12,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Characteristic",5],12,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Characteristic",7],12,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Characteristic",13],12,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Size",3],12,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Size",5],24,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Size",25],12,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Size",7],24,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Size",49],12,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Size",13],24,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Size",169],12,"computed (char. table)"],
["Isoclinic(2.G2(4).2)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Characteristic",0],12,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Characteristic",3],12,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Characteristic",5],6,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Characteristic",7],12,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Size",3],12,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Size",5],12,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Size",25],6,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Size",7],12,"computed (char. table)"],
["Isoclinic(2.J2.2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Characteristic",0],18,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Characteristic",3],18,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Characteristic",5],18,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Characteristic",19],2,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Size",3],18,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Size",5],20,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Size",25],18,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Size",19],2,"computed (char. table)"],
["Isoclinic(2.L2(19).2)",["Characteristic",19,"complete"],true,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Characteristic",0],22,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Characteristic",3],22,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Characteristic",11],22,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Characteristic",23],2,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Size",3],24,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Size",81],22,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Size",11],24,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Size",14641],22,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Size",23],2,"computed (char. table)"],
["Isoclinic(2.L2(23).2)",["Characteristic",23,"complete"],true,"computed (char. table)"],
["Isoclinic(2.L3(2).2)",["Characteristic",0],6,"computed (char. table)"],
["Isoclinic(2.L3(2).2)",["Characteristic",3],6,"computed (char. table)"],
["Isoclinic(2.L3(2).2)",["Characteristic",7],2,"computed (char. table)"],
["Isoclinic(2.L3(2).2)",["Size",3],8,"computed (char. table)"],
["Isoclinic(2.L3(2).2)",["Size",81],6,"computed (char. table)"],
["Isoclinic(2.L3(2).2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Isoclinic(2.L3(2).2)",["Size",7],2,"computed (char. table)"],
["Isoclinic(2.L3(2).2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["J1","NrMovedPoints",266,"computed (char. table)"],
["J1","NrMovedPoints",266,"computed (table of marks)"],
["J1",["Characteristic",0],56,"computed (char. table)"],
["J1",["Characteristic",2],20,"computed (char. table)"],
["J1",["Characteristic",3],56,"computed (char. table)"],
["J1",["Characteristic",5],56,"computed (char. table)"],
["J1",["Characteristic",7],31,"computed (char. table)"],
["J1",["Characteristic",11],7,"computed (char. table)"],
["J1",["Characteristic",19],22,"computed (char. table)"],
["J1",["Size",2],20,"computed (char. table)"],
["J1",["Characteristic",2,"complete"],true,"computed (char. table)"],
["J1",["Size",3],76,"computed (char. table)"],
["J1",["Size",9],56,"computed (char. table)"],
["J1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["J1",["Size",5],56,"computed (char. table)"],
["J1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["J1",["Size",7],31,"computed (char. table)"],
["J1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["J1",["Size",11],7,"computed (char. table)"],
["J1",["Characteristic",11,"complete"],true,"computed (char. table)"],
["J1",["Size",19],22,"computed (char. table)"],
["J1",["Characteristic",19,"complete"],true,"computed (char. table)"],
["J2","NrMovedPoints",100,"computed (char. table)"],
["J2","NrMovedPoints",100,"computed (table of marks)"],
["J2",["Characteristic",0],14,"computed (char. table)"],
["J2",["Characteristic",2],6,"computed (char. table)"],
["J2",["Characteristic",3],13,"computed (char. table)"],
["J2",["Characteristic",5],14,"computed (char. table)"],
["J2",["Characteristic",7],14,"computed (char. table)"],
["J2",["Size",2],12,"computed (char. table)"],
["J2",["Size",4],6,"computed (char. table)"],
["J2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["J2",["Size",3],26,"computed (char. table)"],
["J2",["Size",9],13,"computed (char. table)"],
["J2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["J2",["Size",5],14,"computed (char. table)"],
["J2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["J2",["Size",7],28,"computed (char. table)"],
["J2",["Size",49],14,"computed (char. table)"],
["J2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["J2.2","NrMovedPoints",100,"computed (char. table)"],
["J2.2","NrMovedPoints",100,"computed (subgroup tables)"],
["J2.2","NrMovedPoints",100,"computed (subgroup tables, known repres.)"],
["J2.2","NrMovedPoints",100,"computed (table of marks)"],
["J2.2",["Characteristic",0],28,"computed (char. table)"],
["J2.2",["Characteristic",2],12,"computed (char. table)"],
["J2.2",["Characteristic",3],26,"computed (char. table)"],
["J2.2",["Characteristic",5],14,"computed (char. table)"],
["J2.2",["Characteristic",7],28,"computed (char. table)"],
["J2.2",["Size",2],12,"computed (char. table)"],
["J2.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["J2.2",["Size",3],26,"computed (char. table)"],
["J2.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["J2.2",["Size",5],14,"computed (char. table)"],
["J2.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["J2.2",["Size",7],28,"computed (char. table)"],
["J2.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["J3","NrMovedPoints",6156,"computed (char. table)"],
["J3","NrMovedPoints",6156,"computed (table of marks)"],
["J3",["Characteristic",0],85,"computed (char. table)"],
["J3",["Characteristic",2],78,"computed (char. table)"],
["J3",["Characteristic",3],18,"computed (char. table)"],
["J3",["Characteristic",5],85,"computed (char. table)"],
["J3",["Characteristic",17],85,"computed (char. table)"],
["J3",["Characteristic",19],85,"computed (char. table)"],
["J3",["Size",2],80,"computed (char. table)"],
["J3",["Size",4],78,"computed (char. table)"],
["J3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["J3",["Size",3],36,"computed (char. table)"],
["J3",["Size",9],18,"computed (char. table)"],
["J3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["J3",["Size",5],85,"computed (char. table)"],
["J3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["J3",["Size",17],85,"computed (char. table)"],
["J3",["Characteristic",17,"complete"],true,"computed (char. table)"],
["J3",["Size",19],85,"computed (char. table)"],
["J3",["Characteristic",19,"complete"],true,"computed (char. table)"],
["J3.2","NrMovedPoints",6156,"computed (char. table)"],
["J3.2","NrMovedPoints",6156,"computed (subgroup tables)"],
["J3.2","NrMovedPoints",6156,"computed (subgroup tables, known repres.)"],
["J3.2","NrMovedPoints",6156,"computed (table of marks)"],
["J3.2",["Characteristic",0],170,"computed (char. table)"],
["J3.2",["Characteristic",2],80,"computed (char. table)"],
["J3.2",["Characteristic",3],36,"computed (char. table)"],
["J3.2",["Characteristic",5],170,"computed (char. table)"],
["J3.2",["Characteristic",17],170,"computed (char. table)"],
["J3.2",["Characteristic",19],85,"computed (char. table)"],
["J3.2",["Size",2],80,"computed (char. table)"],
["J3.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["J3.2",["Size",3],36,"computed (char. table)"],
["J3.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["J3.2",["Size",5],170,"computed (char. table)"],
["J3.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["J3.2",["Size",17],170,"computed (char. table)"],
["J3.2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["J3.2",["Size",19],85,"computed (char. table)"],
["J3.2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["J4","NrMovedPoints",173067389,"computed (char. table)"],
["J4",["Characteristic",0],1333,"computed (char. table)"],
["J4",["Characteristic",5],1333,"computed (char. table)"],
["J4",["Characteristic",7],1333,"computed (char. table)"],
["J4",["Characteristic",37],1333,"computed (char. table)"],
["J4",["Size",5],2666,"computed (char. table)"],
["J4",["Size",25],1333,"computed (char. table)"],
["J4",["Characteristic",5,"complete"],true,"computed (char. table)"],
["J4",["Size",7],1333,"computed (char. table)"],
["J4",["Characteristic",7,"complete"],true,"computed (char. table)"],
["J4",["Size",37],1333,"computed (char. table)"],
["J4",["Characteristic",37,"complete"],true,"computed (char. table)"],
["L2(101)","NrMovedPoints",102,"computed (PSL(2,q))"],
["L2(101)","NrMovedPoints",102,"computed (table of marks)"],
["L2(101)",["Characteristic",0],51,"computed (char. table)"],
["L2(103)","NrMovedPoints",104,"computed (PSL(2,q))"],
["L2(103)","NrMovedPoints",104,"computed (table of marks)"],
["L2(103)",["Characteristic",0],51,"computed (char. table)"],
["L2(107)","NrMovedPoints",108,"computed (PSL(2,q))"],
["L2(107)","NrMovedPoints",108,"computed (table of marks)"],
["L2(107)",["Characteristic",0],53,"computed (char. table)"],
["L2(109)","NrMovedPoints",110,"computed (PSL(2,q))"],
["L2(109)","NrMovedPoints",110,"computed (table of marks)"],
["L2(109)",["Characteristic",0],55,"computed (char. table)"],
["L2(11)","NrMovedPoints",11,"computed (PSL(2,q))"],
["L2(11)","NrMovedPoints",11,"computed (char. table)"],
["L2(11)","NrMovedPoints",11,"computed (subgroup tables)"],
["L2(11)","NrMovedPoints",11,"computed (subgroup tables, known repres.)"],
["L2(11)","NrMovedPoints",11,"computed (table of marks)"],
["L2(11)",["Characteristic",0],5,"computed (char. table)"],
["L2(11)",["Characteristic",2],5,"computed (char. table)"],
["L2(11)",["Characteristic",3],5,"computed (char. table)"],
["L2(11)",["Characteristic",5],5,"computed (char. table)"],
["L2(11)",["Characteristic",11],3,"computed (char. table)"],
["L2(11)",["Size",2],10,"computed (char. table)"],
["L2(11)",["Size",4],5,"computed (char. table)"],
["L2(11)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(11)",["Size",3],5,"computed (char. table)"],
["L2(11)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(11)",["Size",5],5,"computed (char. table)"],
["L2(11)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(11)",["Size",11],3,"computed (char. table)"],
["L2(11)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["L2(11).2","NrMovedPoints",12,"computed (char. table)"],
["L2(11).2","NrMovedPoints",12,"computed (table of marks)"],
["L2(11).2",["Characteristic",0],10,"computed (char. table)"],
["L2(11).2",["Characteristic",2],10,"computed (char. table)"],
["L2(11).2",["Characteristic",3],10,"computed (char. table)"],
["L2(11).2",["Characteristic",5],10,"computed (char. table)"],
["L2(11).2",["Characteristic",11],3,"computed (char. table)"],
["L2(11).2",["Size",2],10,"computed (char. table)"],
["L2(11).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(11).2",["Size",3],10,"computed (char. table)"],
["L2(11).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(11).2",["Size",5],10,"computed (char. table)"],
["L2(11).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(11).2",["Size",11],3,"computed (char. table)"],
["L2(11).2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["L2(113)","NrMovedPoints",114,"computed (PSL(2,q))"],
["L2(113)","NrMovedPoints",114,"computed (table of marks)"],
["L2(113)",["Characteristic",0],57,"computed (char. table)"],
["L2(127)","NrMovedPoints",128,"computed (PSL(2,q))"],
["L2(128)","NrMovedPoints",129,"computed (PSL(2,q))"],
["L2(13)","NrMovedPoints",14,"computed (PSL(2,q))"],
["L2(13)","NrMovedPoints",14,"computed (char. table)"],
["L2(13)","NrMovedPoints",14,"computed (table of marks)"],
["L2(13)",["Characteristic",0],7,"computed (char. table)"],
["L2(13)",["Characteristic",2],6,"computed (char. table)"],
["L2(13)",["Characteristic",3],7,"computed (char. table)"],
["L2(13)",["Characteristic",7],7,"computed (char. table)"],
["L2(13)",["Characteristic",13],3,"computed (char. table)"],
["L2(13)",["Size",2],12,"computed (char. table)"],
["L2(13)",["Size",4],6,"computed (char. table)"],
["L2(13)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(13)",["Size",3],7,"computed (char. table)"],
["L2(13)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(13)",["Size",7],12,"computed (char. table)"],
["L2(13)",["Size",49],7,"computed (char. table)"],
["L2(13)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L2(13)",["Size",13],3,"computed (char. table)"],
["L2(13)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L2(13).2","NrMovedPoints",14,"computed (subgroup tables, known repres.)"],
["L2(13).2","NrMovedPoints",14,"computed (table of marks)"],
["L2(13).2",["Characteristic",0],12,"computed (char. table)"],
["L2(13).2",["Characteristic",2],12,"computed (char. table)"],
["L2(13).2",["Characteristic",3],12,"computed (char. table)"],
["L2(13).2",["Characteristic",7],12,"computed (char. table)"],
["L2(13).2",["Characteristic",13],3,"computed (char. table)"],
["L2(13).2",["Size",2],12,"computed (char. table)"],
["L2(13).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(13).2",["Size",3],13,"computed (char. table)"],
["L2(13).2",["Size",27],12,"computed (char. table)"],
["L2(13).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(13).2",["Size",7],12,"computed (char. table)"],
["L2(13).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L2(13).2",["Size",13],3,"computed (char. table)"],
["L2(13).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L2(131)","NrMovedPoints",132,"computed (PSL(2,q))"],
["L2(137)","NrMovedPoints",138,"computed (PSL(2,q))"],
["L2(139)","NrMovedPoints",140,"computed (PSL(2,q))"],
["L2(149)","NrMovedPoints",150,"computed (PSL(2,q))"],
["L2(151)","NrMovedPoints",152,"computed (PSL(2,q))"],
["L2(157)","NrMovedPoints",158,"computed (PSL(2,q))"],
["L2(16)","NrMovedPoints",17,"computed (PSL(2,q))"],
["L2(16)","NrMovedPoints",17,"computed (subgroup tables, known repres.)"],
["L2(16)","NrMovedPoints",17,"computed (table of marks)"],
["L2(16)",["Characteristic",0],15,"computed (char. table)"],
["L2(16)",["Characteristic",2],2,"computed (char. table)"],
["L2(16)",["Characteristic",3],15,"computed (char. table)"],
["L2(16)",["Characteristic",5],15,"computed (char. table)"],
["L2(16)",["Characteristic",17],15,"computed (char. table)"],
["L2(16)",["Size",2],8,"computed (char. table)"],
["L2(16)",["Size",4],4,"computed (char. table)"],
["L2(16)",["Size",16],2,"computed (char. table)"],
["L2(16)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(16)",["Size",3],16,"computed (char. table)"],
["L2(16)",["Size",6561],15,"computed (char. table)"],
["L2(16)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(16)",["Size",5],16,"computed (char. table)"],
["L2(16)",["Size",390625],15,"computed (char. table)"],
["L2(16)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(16)",["Size",17],15,"computed (char. table)"],
["L2(16)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["L2(16).2","NrMovedPoints",17,"computed (table of marks)"],
["L2(16).2",["Characteristic",0],16,"computed (char. table)"],
["L2(16).2",["Characteristic",2],4,"computed (char. table)"],
["L2(16).2",["Characteristic",3],16,"computed (char. table)"],
["L2(16).2",["Characteristic",5],16,"computed (char. table)"],
["L2(16).2",["Characteristic",17],15,"computed (char. table)"],
["L2(16).2",["Size",2],8,"computed (char. table)"],
["L2(16).2",["Size",4],4,"computed (char. table)"],
["L2(16).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(16).2",["Size",3],16,"computed (char. table)"],
["L2(16).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(16).2",["Size",5],16,"computed (char. table)"],
["L2(16).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(16).2",["Size",17],15,"computed (char. table)"],
["L2(16).2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["L2(16).4","NrMovedPoints",17,"computed (table of marks)"],
["L2(16).4",["Characteristic",0],16,"computed (char. table)"],
["L2(16).4",["Characteristic",2],8,"computed (char. table)"],
["L2(16).4",["Characteristic",3],16,"computed (char. table)"],
["L2(16).4",["Characteristic",5],16,"computed (char. table)"],
["L2(16).4",["Characteristic",17],15,"computed (char. table)"],
["L2(16).4",["Size",2],8,"computed (char. table)"],
["L2(16).4",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(16).4",["Size",3],16,"computed (char. table)"],
["L2(16).4",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(16).4",["Size",5],16,"computed (char. table)"],
["L2(16).4",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(16).4",["Size",17],15,"computed (char. table)"],
["L2(16).4",["Characteristic",17,"complete"],true,"computed (char. table)"],
["L2(163)","NrMovedPoints",164,"computed (PSL(2,q))"],
["L2(167)","NrMovedPoints",168,"computed (PSL(2,q))"],
["L2(17)","NrMovedPoints",18,"computed (PSL(2,q))"],
["L2(17)","NrMovedPoints",18,"computed (table of marks)"],
["L2(17)",["Characteristic",0],9,"computed (char. table)"],
["L2(17)",["Characteristic",2],8,"computed (char. table)"],
["L2(17)",["Characteristic",3],9,"computed (char. table)"],
["L2(17)",["Characteristic",17],3,"computed (char. table)"],
["L2(17)",["Size",2],8,"computed (char. table)"],
["L2(17)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(17)",["Size",3],16,"computed (char. table)"],
["L2(17)",["Size",9],9,"computed (char. table)"],
["L2(17)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(17)",["Size",17],3,"computed (char. table)"],
["L2(17)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["L2(17).2","NrMovedPoints",18,"computed (subgroup tables)"],
["L2(17).2","NrMovedPoints",18,"computed (subgroup tables, known repres.)"],
["L2(17).2",["Characteristic",0],16,"computed (char. table)"],
["L2(17).2",["Characteristic",2],16,"computed (char. table)"],
["L2(17).2",["Characteristic",3],16,"computed (char. table)"],
["L2(17).2",["Characteristic",17],3,"computed (char. table)"],
["L2(17).2",["Size",2],16,"computed (char. table)"],
["L2(17).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(17).2",["Size",3],16,"computed (char. table)"],
["L2(17).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(17).2",["Size",17],3,"computed (char. table)"],
["L2(17).2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["L2(173)","NrMovedPoints",174,"computed (PSL(2,q))"],
["L2(179)","NrMovedPoints",180,"computed (PSL(2,q))"],
["L2(181)","NrMovedPoints",182,"computed (PSL(2,q))"],
["L2(19)","NrMovedPoints",20,"computed (PSL(2,q))"],
["L2(19)","NrMovedPoints",20,"computed (table of marks)"],
["L2(19)",["Characteristic",0],9,"computed (char. table)"],
["L2(19)",["Characteristic",2],9,"computed (char. table)"],
["L2(19)",["Characteristic",3],9,"computed (char. table)"],
["L2(19)",["Characteristic",5],9,"computed (char. table)"],
["L2(19)",["Characteristic",19],3,"computed (char. table)"],
["L2(19)",["Size",2],18,"computed (char. table)"],
["L2(19)",["Size",4],9,"computed (char. table)"],
["L2(19)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(19)",["Size",3],18,"computed (char. table)"],
["L2(19)",["Size",9],9,"computed (char. table)"],
["L2(19)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(19)",["Size",5],9,"computed (char. table)"],
["L2(19)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(19)",["Size",19],3,"computed (char. table)"],
["L2(19)",["Characteristic",19,"complete"],true,"computed (char. table)"],
["L2(19).2","NrMovedPoints",20,"computed (subgroup tables)"],
["L2(19).2","NrMovedPoints",20,"computed (subgroup tables, known repres.)"],
["L2(19).2",["Characteristic",0],18,"computed (char. table)"],
["L2(19).2",["Characteristic",2],18,"computed (char. table)"],
["L2(19).2",["Characteristic",3],18,"computed (char. table)"],
["L2(19).2",["Characteristic",5],18,"computed (char. table)"],
["L2(19).2",["Characteristic",19],3,"computed (char. table)"],
["L2(19).2",["Size",2],18,"computed (char. table)"],
["L2(19).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(19).2",["Size",3],18,"computed (char. table)"],
["L2(19).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(19).2",["Size",5],18,"computed (char. table)"],
["L2(19).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(19).2",["Size",19],3,"computed (char. table)"],
["L2(19).2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["L2(191)","NrMovedPoints",192,"computed (PSL(2,q))"],
["L2(193)","NrMovedPoints",194,"computed (PSL(2,q))"],
["L2(197)","NrMovedPoints",198,"computed (PSL(2,q))"],
["L2(199)","NrMovedPoints",200,"computed (PSL(2,q))"],
["L2(211)","NrMovedPoints",212,"computed (PSL(2,q))"],
["L2(223)","NrMovedPoints",224,"computed (PSL(2,q))"],
["L2(227)","NrMovedPoints",228,"computed (PSL(2,q))"],
["L2(229)","NrMovedPoints",230,"computed (PSL(2,q))"],
["L2(23)","NrMovedPoints",24,"computed (PSL(2,q))"],
["L2(23)","NrMovedPoints",24,"computed (table of marks)"],
["L2(23)",["Characteristic",0],11,"computed (char. table)"],
["L2(23)",["Characteristic",2],11,"computed (char. table)"],
["L2(23)",["Characteristic",3],11,"computed (char. table)"],
["L2(23)",["Characteristic",11],11,"computed (char. table)"],
["L2(23)",["Characteristic",23],3,"computed (char. table)"],
["L2(23)",["Size",2],11,"computed (char. table)"],
["L2(23)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(23)",["Size",3],11,"computed (char. table)"],
["L2(23)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(23)",["Size",11],22,"computed (char. table)"],
["L2(23)",["Size",121],11,"computed (char. table)"],
["L2(23)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["L2(23)",["Size",23],3,"computed (char. table)"],
["L2(23)",["Characteristic",23,"complete"],true,"computed (char. table)"],
["L2(23).2",["Characteristic",0],22,"computed (char. table)"],
["L2(23).2",["Characteristic",2],22,"computed (char. table)"],
["L2(23).2",["Characteristic",3],22,"computed (char. table)"],
["L2(23).2",["Characteristic",11],22,"computed (char. table)"],
["L2(23).2",["Characteristic",23],3,"computed (char. table)"],
["L2(23).2",["Size",2],22,"computed (char. table)"],
["L2(23).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(23).2",["Size",3],22,"computed (char. table)"],
["L2(23).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(23).2",["Size",11],22,"computed (char. table)"],
["L2(23).2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["L2(23).2",["Size",23],3,"computed (char. table)"],
["L2(23).2",["Characteristic",23,"complete"],true,"computed (char. table)"],
["L2(233)","NrMovedPoints",234,"computed (PSL(2,q))"],
["L2(239)","NrMovedPoints",240,"computed (PSL(2,q))"],
["L2(241)","NrMovedPoints",242,"computed (PSL(2,q))"],
["L2(25)","NrMovedPoints",26,"computed (PSL(2,q))"],
["L2(25)","NrMovedPoints",26,"computed (table of marks)"],
["L2(25)",["Characteristic",0],13,"computed (char. table)"],
["L2(25)",["Characteristic",2],12,"computed (char. table)"],
["L2(25)",["Characteristic",3],13,"computed (char. table)"],
["L2(25)",["Characteristic",5],3,"computed (char. table)"],
["L2(25)",["Characteristic",13],13,"computed (char. table)"],
["L2(25)",["Size",2],12,"computed (char. table)"],
["L2(25)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(25)",["Size",3],13,"computed (char. table)"],
["L2(25)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(25)",["Size",5],4,"computed (char. table)"],
["L2(25)",["Size",25],3,"computed (char. table)"],
["L2(25)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(25)",["Size",13],13,"computed (char. table)"],
["L2(25)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L2(25).2_1",["Characteristic",0],24,"computed (char. table)"],
["L2(25).2_1",["Characteristic",2],24,"computed (char. table)"],
["L2(25).2_1",["Characteristic",3],24,"computed (char. table)"],
["L2(25).2_1",["Characteristic",5],3,"computed (char. table)"],
["L2(25).2_1",["Characteristic",13],24,"computed (char. table)"],
["L2(25).2_1",["Size",2],24,"computed (char. table)"],
["L2(25).2_1",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(25).2_1",["Size",3],25,"computed (char. table)"],
["L2(25).2_1",["Size",27],24,"computed (char. table)"],
["L2(25).2_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(25).2_1",["Size",5],6,"computed (char. table)"],
["L2(25).2_1",["Size",25],3,"computed (char. table)"],
["L2(25).2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(25).2_1",["Size",13],24,"computed (char. table)"],
["L2(25).2_1",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L2(25).2_2","NrMovedPoints",26,"computed (subgroup tables)"],
["L2(25).2_2","NrMovedPoints",26,"computed (table of marks)"],
["L2(25).2_2",["Characteristic",0],13,"computed (char. table)"],
["L2(25).2_2",["Characteristic",2],12,"computed (char. table)"],
["L2(25).2_2",["Characteristic",3],13,"computed (char. table)"],
["L2(25).2_2",["Characteristic",5],4,"computed (char. table)"],
["L2(25).2_2",["Characteristic",13],13,"computed (char. table)"],
["L2(25).2_2",["Size",2],12,"computed (char. table)"],
["L2(25).2_2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(25).2_2",["Size",3],13,"computed (char. table)"],
["L2(25).2_2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(25).2_2",["Size",5],4,"computed (char. table)"],
["L2(25).2_2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(25).2_2",["Size",13],13,"computed (char. table)"],
["L2(25).2_2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L2(25).2_3",["Characteristic",0],25,"computed (char. table)"],
["L2(25).2_3",["Characteristic",2],24,"computed (char. table)"],
["L2(25).2_3",["Characteristic",3],25,"computed (char. table)"],
["L2(25).2_3",["Characteristic",5],4,"computed (char. table)"],
["L2(25).2_3",["Characteristic",13],24,"computed (char. table)"],
["L2(25).2_3",["Size",2],24,"computed (char. table)"],
["L2(25).2_3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(25).2_3",["Size",3],25,"computed (char. table)"],
["L2(25).2_3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(25).2_3",["Size",5],6,"computed (char. table)"],
["L2(25).2_3",["Size",25],4,"computed (char. table)"],
["L2(25).2_3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(25).2_3",["Size",13],24,"computed (char. table)"],
["L2(25).2_3",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L2(27)","NrMovedPoints",28,"computed (PSL(2,q))"],
["L2(27)","NrMovedPoints",28,"computed (table of marks)"],
["L2(27)",["Characteristic",0],13,"computed (char. table)"],
["L2(27)",["Characteristic",2],13,"computed (char. table)"],
["L2(27)",["Characteristic",3],3,"computed (char. table)"],
["L2(27)",["Characteristic",7],13,"computed (char. table)"],
["L2(27)",["Characteristic",13],13,"computed (char. table)"],
["L2(27)",["Size",2],26,"computed (char. table)"],
["L2(27)",["Size",4],13,"computed (char. table)"],
["L2(27)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(27)",["Size",3],9,"computed (char. table)"],
["L2(27)",["Size",27],3,"computed (char. table)"],
["L2(27)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(27)",["Size",7],13,"computed (char. table)"],
["L2(27)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L2(27)",["Size",13],13,"computed (char. table)"],
["L2(27)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L2(27).2",["Characteristic",0],26,"computed (char. table)"],
["L2(27).2",["Characteristic",2],26,"computed (char. table)"],
["L2(27).2",["Characteristic",3],3,"computed (char. table)"],
["L2(27).2",["Characteristic",7],26,"computed (char. table)"],
["L2(27).2",["Characteristic",13],26,"computed (char. table)"],
["L2(27).2",["Size",2],26,"computed (char. table)"],
["L2(27).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(27).2",["Size",3],9,"computed (char. table)"],
["L2(27).2",["Size",27],3,"computed (char. table)"],
["L2(27).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(27).2",["Size",7],26,"computed (char. table)"],
["L2(27).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L2(27).2",["Size",13],26,"computed (char. table)"],
["L2(27).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L2(27).3",["Characteristic",0],13,"computed (char. table)"],
["L2(27).3",["Characteristic",2],13,"computed (char. table)"],
["L2(27).3",["Characteristic",3],9,"computed (char. table)"],
["L2(27).3",["Characteristic",7],13,"computed (char. table)"],
["L2(27).3",["Characteristic",13],13,"computed (char. table)"],
["L2(27).3",["Size",2],26,"computed (char. table)"],
["L2(27).3",["Size",4],13,"computed (char. table)"],
["L2(27).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(27).3",["Size",3],9,"computed (char. table)"],
["L2(27).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(27).3",["Size",7],13,"computed (char. table)"],
["L2(27).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L2(27).3",["Size",13],13,"computed (char. table)"],
["L2(27).3",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L2(27).6",["Characteristic",0],26,"computed (char. table)"],
["L2(27).6",["Characteristic",2],26,"computed (char. table)"],
["L2(27).6",["Characteristic",3],9,"computed (char. table)"],
["L2(27).6",["Characteristic",7],26,"computed (char. table)"],
["L2(27).6",["Characteristic",13],26,"computed (char. table)"],
["L2(27).6",["Size",2],26,"computed (char. table)"],
["L2(27).6",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(27).6",["Size",3],9,"computed (char. table)"],
["L2(27).6",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(27).6",["Size",7],26,"computed (char. table)"],
["L2(27).6",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L2(27).6",["Size",13],26,"computed (char. table)"],
["L2(27).6",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L2(29)","NrMovedPoints",30,"computed (PSL(2,q))"],
["L2(29)","NrMovedPoints",30,"computed (table of marks)"],
["L2(29)",["Characteristic",0],15,"computed (char. table)"],
["L2(29)",["Characteristic",2],14,"computed (char. table)"],
["L2(29)",["Characteristic",3],15,"computed (char. table)"],
["L2(29)",["Characteristic",5],15,"computed (char. table)"],
["L2(29)",["Characteristic",7],15,"computed (char. table)"],
["L2(29)",["Characteristic",29],3,"computed (char. table)"],
["L2(29)",["Size",2],28,"computed (char. table)"],
["L2(29)",["Size",4],14,"computed (char. table)"],
["L2(29)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(29)",["Size",3],28,"computed (char. table)"],
["L2(29)",["Size",9],15,"computed (char. table)"],
["L2(29)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(29)",["Size",5],15,"computed (char. table)"],
["L2(29)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(29)",["Size",7],15,"computed (char. table)"],
["L2(29)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L2(29)",["Size",29],3,"computed (char. table)"],
["L2(29)",["Characteristic",29,"complete"],true,"computed (char. table)"],
["L2(29).2","NrMovedPoints",30,"computed (subgroup tables)"],
["L2(29).2",["Characteristic",0],28,"computed (char. table)"],
["L2(29).2",["Characteristic",2],28,"computed (char. table)"],
["L2(29).2",["Characteristic",3],28,"computed (char. table)"],
["L2(29).2",["Characteristic",5],28,"computed (char. table)"],
["L2(29).2",["Characteristic",7],28,"computed (char. table)"],
["L2(29).2",["Characteristic",29],3,"computed (char. table)"],
["L2(29).2",["Size",2],28,"computed (char. table)"],
["L2(29).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(29).2",["Size",3],28,"computed (char. table)"],
["L2(29).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(29).2",["Size",5],28,"computed (char. table)"],
["L2(29).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(29).2",["Size",7],28,"computed (char. table)"],
["L2(29).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L2(29).2",["Size",29],3,"computed (char. table)"],
["L2(29).2",["Characteristic",29,"complete"],true,"computed (char. table)"],
["L2(31)","NrMovedPoints",32,"computed (PSL(2,q))"],
["L2(31)","NrMovedPoints",32,"computed (table of marks)"],
["L2(31)",["Characteristic",0],15,"computed (char. table)"],
["L2(31)",["Characteristic",2],15,"computed (char. table)"],
["L2(31)",["Characteristic",3],15,"computed (char. table)"],
["L2(31)",["Characteristic",5],15,"computed (char. table)"],
["L2(31)",["Characteristic",31],3,"computed (char. table)"],
["L2(31)",["Size",2],15,"computed (char. table)"],
["L2(31)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(31)",["Size",3],30,"computed (char. table)"],
["L2(31)",["Size",9],15,"computed (char. table)"],
["L2(31)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(31)",["Size",5],15,"computed (char. table)"],
["L2(31)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(31)",["Size",31],3,"computed (char. table)"],
["L2(31)",["Characteristic",31,"complete"],true,"computed (char. table)"],
["L2(31).2",["Characteristic",0],30,"computed (char. table)"],
["L2(31).2",["Characteristic",2],30,"computed (char. table)"],
["L2(31).2",["Characteristic",3],30,"computed (char. table)"],
["L2(31).2",["Characteristic",5],30,"computed (char. table)"],
["L2(31).2",["Characteristic",31],3,"computed (char. table)"],
["L2(31).2",["Size",2],30,"computed (char. table)"],
["L2(31).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(31).2",["Size",3],30,"computed (char. table)"],
["L2(31).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(31).2",["Size",5],30,"computed (char. table)"],
["L2(31).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(31).2",["Size",31],3,"computed (char. table)"],
["L2(31).2",["Characteristic",31,"complete"],true,"computed (char. table)"],
["L2(32)","NrMovedPoints",33,"computed (PSL(2,q))"],
["L2(32)","NrMovedPoints",33,"computed (table of marks)"],
["L2(32)",["Characteristic",0],31,"computed (char. table)"],
["L2(32)",["Characteristic",2],2,"computed (char. table)"],
["L2(32)",["Characteristic",3],31,"computed (char. table)"],
["L2(32)",["Characteristic",11],31,"computed (char. table)"],
["L2(32)",["Characteristic",31],31,"computed (char. table)"],
["L2(32)",["Size",2],10,"computed (char. table)"],
["L2(32)",["Size",32],2,"computed (char. table)"],
["L2(32)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(32)",["Size",3],31,"computed (char. table)"],
["L2(32)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(32)",["Size",11],31,"computed (char. table)"],
["L2(32)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["L2(32)",["Size",31],31,"computed (char. table)"],
["L2(32)",["Characteristic",31,"complete"],true,"computed (char. table)"],
["L2(32).5","NrMovedPoints",33,"computed (subgroup tables, known repres.)"],
["L2(32).5",["Characteristic",0],31,"computed (char. table)"],
["L2(32).5",["Characteristic",2],10,"computed (char. table)"],
["L2(32).5",["Characteristic",3],31,"computed (char. table)"],
["L2(32).5",["Characteristic",5],31,"computed (char. table)"],
["L2(32).5",["Characteristic",11],31,"computed (char. table)"],
["L2(32).5",["Characteristic",31],31,"computed (char. table)"],
["L2(32).5",["Size",2],10,"computed (char. table)"],
["L2(32).5",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(32).5",["Size",3],31,"computed (char. table)"],
["L2(32).5",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(32).5",["Size",5],31,"computed (char. table)"],
["L2(32).5",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(32).5",["Size",11],31,"computed (char. table)"],
["L2(32).5",["Characteristic",11,"complete"],true,"computed (char. table)"],
["L2(32).5",["Size",31],31,"computed (char. table)"],
["L2(32).5",["Characteristic",31,"complete"],true,"computed (char. table)"],
["L2(37)","NrMovedPoints",38,"computed (PSL(2,q))"],
["L2(37)","NrMovedPoints",38,"computed (table of marks)"],
["L2(37)",["Characteristic",0],19,"computed (char. table)"],
["L2(41)","NrMovedPoints",42,"computed (PSL(2,q))"],
["L2(41)","NrMovedPoints",42,"computed (table of marks)"],
["L2(41)",["Characteristic",0],21,"computed (char. table)"],
["L2(43)","NrMovedPoints",44,"computed (PSL(2,q))"],
["L2(43)","NrMovedPoints",44,"computed (table of marks)"],
["L2(43)",["Characteristic",0],21,"computed (char. table)"],
["L2(47)","NrMovedPoints",48,"computed (PSL(2,q))"],
["L2(47)","NrMovedPoints",48,"computed (table of marks)"],
["L2(47)",["Characteristic",0],23,"computed (char. table)"],
["L2(49)","NrMovedPoints",50,"computed (PSL(2,q))"],
["L2(49)","NrMovedPoints",50,"computed (table of marks)"],
["L2(49)",["Characteristic",0],25,"computed (char. table)"],
["L2(49)",["Characteristic",2],24,"computed (char. table)"],
["L2(49)",["Characteristic",3],25,"computed (char. table)"],
["L2(49)",["Characteristic",5],25,"computed (char. table)"],
["L2(49)",["Size",2],24,"computed (char. table)"],
["L2(49)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(49)",["Size",3],25,"computed (char. table)"],
["L2(49)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(49)",["Size",5],25,"computed (char. table)"],
["L2(49)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(53)","NrMovedPoints",54,"computed (PSL(2,q))"],
["L2(53)","NrMovedPoints",54,"computed (table of marks)"],
["L2(53)",["Characteristic",0],27,"computed (char. table)"],
["L2(59)","NrMovedPoints",60,"computed (PSL(2,q))"],
["L2(59)","NrMovedPoints",60,"computed (table of marks)"],
["L2(59)",["Characteristic",0],29,"computed (char. table)"],
["L2(61)","NrMovedPoints",62,"computed (PSL(2,q))"],
["L2(61)","NrMovedPoints",62,"computed (table of marks)"],
["L2(61)",["Characteristic",0],31,"computed (char. table)"],
["L2(64)","NrMovedPoints",65,"computed (PSL(2,q))"],
["L2(64)","NrMovedPoints",65,"computed (table of marks)"],
["L2(64)",["Characteristic",0],63,"computed (char. table)"],
["L2(67)","NrMovedPoints",68,"computed (PSL(2,q))"],
["L2(67)","NrMovedPoints",68,"computed (table of marks)"],
["L2(67)",["Characteristic",0],33,"computed (char. table)"],
["L2(71)","NrMovedPoints",72,"computed (PSL(2,q))"],
["L2(71)","NrMovedPoints",72,"computed (table of marks)"],
["L2(71)",["Characteristic",0],35,"computed (char. table)"],
["L2(73)","NrMovedPoints",74,"computed (PSL(2,q))"],
["L2(73)","NrMovedPoints",74,"computed (table of marks)"],
["L2(73)",["Characteristic",0],37,"computed (char. table)"],
["L2(79)","NrMovedPoints",80,"computed (PSL(2,q))"],
["L2(79)","NrMovedPoints",80,"computed (table of marks)"],
["L2(79)",["Characteristic",0],39,"computed (char. table)"],
["L2(8)","NrMovedPoints",9,"computed (PSL(2,q))"],
["L2(8)","NrMovedPoints",9,"computed (table of marks)"],
["L2(8)",["Characteristic",0],7,"computed (char. table)"],
["L2(8)",["Characteristic",2],2,"computed (char. table)"],
["L2(8)",["Characteristic",3],7,"computed (char. table)"],
["L2(8)",["Characteristic",7],7,"computed (char. table)"],
["L2(8)",["Size",2],6,"computed (char. table)"],
["L2(8)",["Size",8],2,"computed (char. table)"],
["L2(8)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(8)",["Size",3],7,"computed (char. table)"],
["L2(8)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(8)",["Size",7],7,"computed (char. table)"],
["L2(8)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L2(8).3","NrMovedPoints",9,"computed (subgroup tables)"],
["L2(8).3","NrMovedPoints",9,"computed (subgroup tables, known repres.)"],
["L2(8).3","NrMovedPoints",9,"computed (table of marks)"],
["L2(8).3",["Characteristic",0],7,"computed (char. table)"],
["L2(8).3",["Characteristic",2],6,"computed (char. table)"],
["L2(8).3",["Characteristic",3],7,"computed (char. table)"],
["L2(8).3",["Characteristic",7],7,"computed (char. table)"],
["L2(8).3",["Size",2],6,"computed (char. table)"],
["L2(8).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(8).3",["Size",3],7,"computed (char. table)"],
["L2(8).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L2(8).3",["Size",7],7,"computed (char. table)"],
["L2(8).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L2(81)","NrMovedPoints",82,"computed (PSL(2,q))"],
["L2(81)","NrMovedPoints",82,"computed (table of marks)"],
["L2(81)",["Characteristic",0],41,"computed (char. table)"],
["L2(81)",["Characteristic",2],40,"computed (char. table)"],
["L2(81)",["Characteristic",5],41,"computed (char. table)"],
["L2(81)",["Characteristic",41],41,"computed (char. table)"],
["L2(81)",["Size",2],40,"computed (char. table)"],
["L2(81)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L2(81)",["Size",5],41,"computed (char. table)"],
["L2(81)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L2(81)",["Size",41],41,"computed (char. table)"],
["L2(81)",["Characteristic",41,"complete"],true,"computed (char. table)"],
["L2(83)","NrMovedPoints",84,"computed (PSL(2,q))"],
["L2(83)","NrMovedPoints",84,"computed (table of marks)"],
["L2(83)",["Characteristic",0],41,"computed (char. table)"],
["L2(89)","NrMovedPoints",90,"computed (PSL(2,q))"],
["L2(89)","NrMovedPoints",90,"computed (table of marks)"],
["L2(89)",["Characteristic",0],45,"computed (char. table)"],
["L2(97)","NrMovedPoints",98,"computed (PSL(2,q))"],
["L2(97)","NrMovedPoints",98,"computed (table of marks)"],
["L2(97)",["Characteristic",0],49,"computed (char. table)"],
["L3(11)","NrMovedPoints",133,"computed (table of marks)"],
["L3(11)",["Characteristic",0],132,"computed (char. table)"],
["L3(2)","NrMovedPoints",7,"computed (char. table)"],
["L3(2)","NrMovedPoints",7,"computed (subgroup tables)"],
["L3(2)","NrMovedPoints",7,"computed (subgroup tables, known repres.)"],
["L3(2)","NrMovedPoints",7,"computed (table of marks)"],
["L3(2)",["Characteristic",0],3,"computed (char. table)"],
["L3(2)",["Characteristic",2],3,"computed (char. table)"],
["L3(2)",["Characteristic",3],3,"computed (char. table)"],
["L3(2)",["Characteristic",7],3,"computed (char. table)"],
["L3(2)",["Size",2],3,"computed (char. table)"],
["L3(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(2)",["Size",3],6,"computed (char. table)"],
["L3(2)",["Size",9],3,"computed (char. table)"],
["L3(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(2)",["Size",7],3,"computed (char. table)"],
["L3(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(2).2","NrMovedPoints",8,"computed (table of marks)"],
["L3(2).2",["Characteristic",0],6,"computed (char. table)"],
["L3(2).2",["Characteristic",2],6,"computed (char. table)"],
["L3(2).2",["Characteristic",3],6,"computed (char. table)"],
["L3(2).2",["Characteristic",7],3,"computed (char. table)"],
["L3(2).2",["Size",2],6,"computed (char. table)"],
["L3(2).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(2).2",["Size",3],6,"computed (char. table)"],
["L3(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(2).2",["Size",7],3,"computed (char. table)"],
["L3(2).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(3)","NrMovedPoints",13,"computed (subgroup tables)"],
["L3(3)","NrMovedPoints",13,"computed (subgroup tables, known repres.)"],
["L3(3)","NrMovedPoints",13,"computed (table of marks)"],
["L3(3)",["Characteristic",0],12,"computed (char. table)"],
["L3(3)",["Characteristic",2],12,"computed (char. table)"],
["L3(3)",["Characteristic",3],3,"computed (char. table)"],
["L3(3)",["Characteristic",13],11,"computed (char. table)"],
["L3(3)",["Size",2],12,"computed (char. table)"],
["L3(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(3)",["Size",3],3,"computed (char. table)"],
["L3(3)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(3)",["Size",13],11,"computed (char. table)"],
["L3(3)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L3(3).2","NrMovedPoints",26,"computed (table of marks)"],
["L3(3).2",["Characteristic",0],12,"computed (char. table)"],
["L3(3).2",["Characteristic",2],12,"computed (char. table)"],
["L3(3).2",["Characteristic",3],6,"computed (char. table)"],
["L3(3).2",["Characteristic",13],11,"computed (char. table)"],
["L3(3).2",["Size",2],12,"computed (char. table)"],
["L3(3).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(3).2",["Size",3],6,"computed (char. table)"],
["L3(3).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(3).2",["Size",13],11,"computed (char. table)"],
["L3(3).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L3(4)","NrMovedPoints",21,"computed (table of marks)"],
["L3(4)",["Characteristic",0],20,"computed (char. table)"],
["L3(4)",["Characteristic",2],8,"computed (char. table)"],
["L3(4)",["Characteristic",3],15,"computed (char. table)"],
["L3(4)",["Characteristic",5],20,"computed (char. table)"],
["L3(4)",["Characteristic",7],19,"computed (char. table)"],
["L3(4)",["Size",2],9,"computed (char. table)"],
["L3(4)",["Size",4],8,"computed (char. table)"],
["L3(4)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(4)",["Size",3],15,"computed (char. table)"],
["L3(4)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(4)",["Size",5],20,"computed (char. table)"],
["L3(4)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(4)",["Size",7],19,"computed (char. table)"],
["L3(4)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(4).2^2","NrMovedPoints",42,"computed (table of marks)"],
["L3(4).2^2",["Characteristic",0],20,"computed (char. table)"],
["L3(4).2^2",["Characteristic",2],16,"computed (char. table)"],
["L3(4).2^2",["Characteristic",3],15,"computed (char. table)"],
["L3(4).2^2",["Characteristic",5],20,"computed (char. table)"],
["L3(4).2^2",["Characteristic",7],19,"computed (char. table)"],
["L3(4).2^2",["Size",2],16,"computed (char. table)"],
["L3(4).2^2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(4).2^2",["Size",3],15,"computed (char. table)"],
["L3(4).2^2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(4).2^2",["Size",5],20,"computed (char. table)"],
["L3(4).2^2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(4).2^2",["Size",7],19,"computed (char. table)"],
["L3(4).2^2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(4).2_1","NrMovedPoints",42,"computed (table of marks)"],
["L3(4).2_1",["Characteristic",0],20,"computed (char. table)"],
["L3(4).2_1",["Characteristic",2],16,"computed (char. table)"],
["L3(4).2_1",["Characteristic",3],15,"computed (char. table)"],
["L3(4).2_1",["Characteristic",5],20,"computed (char. table)"],
["L3(4).2_1",["Characteristic",7],19,"computed (char. table)"],
["L3(4).2_1",["Size",2],16,"computed (char. table)"],
["L3(4).2_1",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(4).2_1",["Size",3],15,"computed (char. table)"],
["L3(4).2_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(4).2_1",["Size",5],20,"computed (char. table)"],
["L3(4).2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(4).2_1",["Size",7],19,"computed (char. table)"],
["L3(4).2_1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(4).2_2","NrMovedPoints",21,"computed (subgroup tables)"],
["L3(4).2_2","NrMovedPoints",21,"computed (table of marks)"],
["L3(4).2_2",["Characteristic",0],20,"computed (char. table)"],
["L3(4).2_2",["Characteristic",2],9,"computed (char. table)"],
["L3(4).2_2",["Characteristic",3],15,"computed (char. table)"],
["L3(4).2_2",["Characteristic",5],20,"computed (char. table)"],
["L3(4).2_2",["Characteristic",7],19,"computed (char. table)"],
["L3(4).2_2",["Size",2],9,"computed (char. table)"],
["L3(4).2_2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(4).2_2",["Size",3],15,"computed (char. table)"],
["L3(4).2_2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(4).2_2",["Size",5],20,"computed (char. table)"],
["L3(4).2_2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(4).2_2",["Size",7],19,"computed (char. table)"],
["L3(4).2_2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(4).2_3","NrMovedPoints",42,"computed (table of marks)"],
["L3(4).2_3",["Characteristic",0],20,"computed (char. table)"],
["L3(4).2_3",["Characteristic",2],8,"computed (char. table)"],
["L3(4).2_3",["Characteristic",3],15,"computed (char. table)"],
["L3(4).2_3",["Characteristic",5],20,"computed (char. table)"],
["L3(4).2_3",["Characteristic",7],19,"computed (char. table)"],
["L3(4).2_3",["Size",2],16,"computed (char. table)"],
["L3(4).2_3",["Size",4],8,"computed (char. table)"],
["L3(4).2_3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(4).2_3",["Size",3],15,"computed (char. table)"],
["L3(4).2_3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(4).2_3",["Size",5],20,"computed (char. table)"],
["L3(4).2_3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(4).2_3",["Size",7],19,"computed (char. table)"],
["L3(4).2_3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(4).3","NrMovedPoints",21,"computed (table of marks)"],
["L3(4).3",["Characteristic",0],20,"computed (char. table)"],
["L3(4).3",["Characteristic",2],8,"computed (char. table)"],
["L3(4).3",["Characteristic",3],19,"computed (char. table)"],
["L3(4).3",["Characteristic",5],20,"computed (char. table)"],
["L3(4).3",["Characteristic",7],19,"computed (char. table)"],
["L3(4).3",["Size",2],9,"computed (char. table)"],
["L3(4).3",["Size",4],8,"computed (char. table)"],
["L3(4).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(4).3",["Size",3],19,"computed (char. table)"],
["L3(4).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(4).3",["Size",5],20,"computed (char. table)"],
["L3(4).3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(4).3",["Size",7],19,"computed (char. table)"],
["L3(4).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(4).6","NrMovedPoints",42,"computed (table of marks)"],
["L3(4).6",["Characteristic",0],20,"computed (char. table)"],
["L3(4).6",["Characteristic",2],16,"computed (char. table)"],
["L3(4).6",["Characteristic",3],19,"computed (char. table)"],
["L3(4).6",["Characteristic",5],20,"computed (char. table)"],
["L3(4).6",["Characteristic",7],19,"computed (char. table)"],
["L3(4).6",["Size",2],16,"computed (char. table)"],
["L3(4).6",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(4).6",["Size",3],19,"computed (char. table)"],
["L3(4).6",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(4).6",["Size",5],20,"computed (char. table)"],
["L3(4).6",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(4).6",["Size",7],19,"computed (char. table)"],
["L3(4).6",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(4).D12","NrMovedPoints",42,"computed (table of marks)"],
["L3(4).D12",["Characteristic",0],20,"computed (char. table)"],
["L3(4).D12",["Characteristic",2],16,"computed (char. table)"],
["L3(4).D12",["Characteristic",3],19,"computed (char. table)"],
["L3(4).D12",["Characteristic",5],20,"computed (char. table)"],
["L3(4).D12",["Characteristic",7],19,"computed (char. table)"],
["L3(4).D12",["Size",2],16,"computed (char. table)"],
["L3(4).D12",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(4).D12",["Size",3],19,"computed (char. table)"],
["L3(4).D12",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(4).D12",["Size",5],20,"computed (char. table)"],
["L3(4).D12",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(4).D12",["Size",7],19,"computed (char. table)"],
["L3(4).D12",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(5)","NrMovedPoints",31,"computed (subgroup tables)"],
["L3(5)","NrMovedPoints",31,"computed (subgroup tables, known repres.)"],
["L3(5)","NrMovedPoints",31,"computed (table of marks)"],
["L3(5)",["Characteristic",0],30,"computed (char. table)"],
["L3(5)",["Characteristic",2],30,"computed (char. table)"],
["L3(5)",["Characteristic",3],30,"computed (char. table)"],
["L3(5)",["Characteristic",5],3,"computed (char. table)"],
["L3(5)",["Characteristic",31],29,"computed (char. table)"],
["L3(5)",["Size",2],30,"computed (char. table)"],
["L3(5)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(5)",["Size",3],30,"computed (char. table)"],
["L3(5)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(5)",["Size",5],3,"computed (char. table)"],
["L3(5)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(5)",["Size",31],29,"computed (char. table)"],
["L3(5)",["Characteristic",31,"complete"],true,"computed (char. table)"],
["L3(5).2",["Characteristic",0],30,"computed (char. table)"],
["L3(5).2",["Characteristic",2],30,"computed (char. table)"],
["L3(5).2",["Characteristic",3],30,"computed (char. table)"],
["L3(5).2",["Characteristic",5],6,"computed (char. table)"],
["L3(5).2",["Characteristic",31],29,"computed (char. table)"],
["L3(5).2",["Size",2],30,"computed (char. table)"],
["L3(5).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(5).2",["Size",3],31,"computed (char. table)"],
["L3(5).2",["Size",9],30,"computed (char. table)"],
["L3(5).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(5).2",["Size",5],6,"computed (char. table)"],
["L3(5).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(5).2",["Size",31],29,"computed (char. table)"],
["L3(5).2",["Characteristic",31,"complete"],true,"computed (char. table)"],
["L3(7)","NrMovedPoints",57,"computed (char. table)"],
["L3(7)","NrMovedPoints",57,"computed (table of marks)"],
["L3(7)",["Characteristic",0],56,"computed (char. table)"],
["L3(7)",["Characteristic",2],56,"computed (char. table)"],
["L3(7)",["Characteristic",3],55,"computed (char. table)"],
["L3(7)",["Characteristic",7],8,"computed (char. table)"],
["L3(7)",["Characteristic",19],55,"computed (char. table)"],
["L3(7)",["Size",2],56,"computed (char. table)"],
["L3(7)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(7)",["Size",3],55,"computed (char. table)"],
["L3(7)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(7)",["Size",7],8,"computed (char. table)"],
["L3(7)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(7)",["Size",19],55,"computed (char. table)"],
["L3(7)",["Characteristic",19,"complete"],true,"computed (char. table)"],
["L3(7).2",["Characteristic",0],56,"computed (char. table)"],
["L3(7).2",["Characteristic",2],56,"computed (char. table)"],
["L3(7).2",["Characteristic",3],55,"computed (char. table)"],
["L3(7).2",["Characteristic",7],8,"computed (char. table)"],
["L3(7).2",["Characteristic",19],55,"computed (char. table)"],
["L3(7).2",["Size",2],56,"computed (char. table)"],
["L3(7).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(7).2",["Size",3],55,"computed (char. table)"],
["L3(7).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(7).2",["Size",7],8,"computed (char. table)"],
["L3(7).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(7).2",["Size",19],55,"computed (char. table)"],
["L3(7).2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["L3(7).3",["Characteristic",0],56,"computed (char. table)"],
["L3(7).3",["Characteristic",2],56,"computed (char. table)"],
["L3(7).3",["Characteristic",3],55,"computed (char. table)"],
["L3(7).3",["Characteristic",7],8,"computed (char. table)"],
["L3(7).3",["Characteristic",19],55,"computed (char. table)"],
["L3(7).3",["Size",2],56,"computed (char. table)"],
["L3(7).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(7).3",["Size",3],55,"computed (char. table)"],
["L3(7).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(7).3",["Size",7],8,"computed (char. table)"],
["L3(7).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(7).3",["Size",19],55,"computed (char. table)"],
["L3(7).3",["Characteristic",19,"complete"],true,"computed (char. table)"],
["L3(8)","NrMovedPoints",73,"computed (subgroup tables, known repres.)"],
["L3(8)","NrMovedPoints",73,"computed (table of marks)"],
["L3(8)",["Characteristic",0],72,"computed (char. table)"],
["L3(8)",["Characteristic",2],3,"computed (char. table)"],
["L3(8)",["Characteristic",3],72,"computed (char. table)"],
["L3(8)",["Characteristic",7],72,"computed (char. table)"],
["L3(8)",["Characteristic",73],71,"computed (char. table)"],
["L3(8)",["Size",2],9,"computed (char. table)"],
["L3(8)",["Size",8],3,"computed (char. table)"],
["L3(8)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(8)",["Size",3],72,"computed (char. table)"],
["L3(8)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(8)",["Size",7],72,"computed (char. table)"],
["L3(8)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(8)",["Size",73],71,"computed (char. table)"],
["L3(8)",["Characteristic",73,"complete"],true,"computed (char. table)"],
["L3(8).2",["Characteristic",0],72,"computed (char. table)"],
["L3(8).2",["Characteristic",2],6,"computed (char. table)"],
["L3(8).2",["Characteristic",3],72,"computed (char. table)"],
["L3(8).2",["Characteristic",7],72,"computed (char. table)"],
["L3(8).2",["Characteristic",73],71,"computed (char. table)"],
["L3(8).2",["Size",2],18,"computed (char. table)"],
["L3(8).2",["Size",8],6,"computed (char. table)"],
["L3(8).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(8).2",["Size",3],144,"computed (char. table)"],
["L3(8).2",["Size",9],72,"computed (char. table)"],
["L3(8).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(8).2",["Size",7],72,"computed (char. table)"],
["L3(8).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(8).2",["Size",73],71,"computed (char. table)"],
["L3(8).2",["Characteristic",73,"complete"],true,"computed (char. table)"],
["L3(8).3","NrMovedPoints",73,"computed (subgroup tables, known repres.)"],
["L3(8).3",["Characteristic",0],72,"computed (char. table)"],
["L3(8).3",["Characteristic",2],9,"computed (char. table)"],
["L3(8).3",["Characteristic",3],72,"computed (char. table)"],
["L3(8).3",["Characteristic",7],72,"computed (char. table)"],
["L3(8).3",["Characteristic",73],71,"computed (char. table)"],
["L3(8).3",["Size",2],9,"computed (char. table)"],
["L3(8).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(8).3",["Size",3],72,"computed (char. table)"],
["L3(8).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(8).3",["Size",7],72,"computed (char. table)"],
["L3(8).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(8).3",["Size",73],71,"computed (char. table)"],
["L3(8).3",["Characteristic",73,"complete"],true,"computed (char. table)"],
["L3(8).6",["Characteristic",0],72,"computed (char. table)"],
["L3(8).6",["Characteristic",2],18,"computed (char. table)"],
["L3(8).6",["Characteristic",3],72,"computed (char. table)"],
["L3(8).6",["Characteristic",7],72,"computed (char. table)"],
["L3(8).6",["Characteristic",73],71,"computed (char. table)"],
["L3(8).6",["Size",2],18,"computed (char. table)"],
["L3(8).6",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(8).6",["Size",3],144,"computed (char. table)"],
["L3(8).6",["Size",9],72,"computed (char. table)"],
["L3(8).6",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(8).6",["Size",7],72,"computed (char. table)"],
["L3(8).6",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(8).6",["Size",73],71,"computed (char. table)"],
["L3(8).6",["Characteristic",73,"complete"],true,"computed (char. table)"],
["L3(9)","NrMovedPoints",91,"computed (table of marks)"],
["L3(9)",["Characteristic",0],90,"computed (char. table)"],
["L3(9)",["Characteristic",2],90,"computed (char. table)"],
["L3(9)",["Characteristic",3],3,"computed (char. table)"],
["L3(9)",["Characteristic",5],90,"computed (char. table)"],
["L3(9)",["Characteristic",7],89,"computed (char. table)"],
["L3(9)",["Characteristic",13],89,"computed (char. table)"],
["L3(9)",["Size",2],90,"computed (char. table)"],
["L3(9)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(9)",["Size",3],6,"computed (char. table)"],
["L3(9)",["Size",9],3,"computed (char. table)"],
["L3(9)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(9)",["Size",5],90,"computed (char. table)"],
["L3(9)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(9)",["Size",7],89,"computed (char. table)"],
["L3(9)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(9)",["Size",13],89,"computed (char. table)"],
["L3(9)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L3(9).2_1",["Characteristic",0],90,"computed (char. table)"],
["L3(9).2_1",["Characteristic",2],90,"computed (char. table)"],
["L3(9).2_1",["Characteristic",3],6,"computed (char. table)"],
["L3(9).2_1",["Characteristic",5],90,"computed (char. table)"],
["L3(9).2_1",["Characteristic",7],89,"computed (char. table)"],
["L3(9).2_1",["Characteristic",13],89,"computed (char. table)"],
["L3(9).2_1",["Size",2],90,"computed (char. table)"],
["L3(9).2_1",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(9).2_1",["Size",3],12,"computed (char. table)"],
["L3(9).2_1",["Size",9],6,"computed (char. table)"],
["L3(9).2_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(9).2_1",["Size",5],90,"computed (char. table)"],
["L3(9).2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(9).2_1",["Size",7],89,"computed (char. table)"],
["L3(9).2_1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(9).2_1",["Size",13],89,"computed (char. table)"],
["L3(9).2_1",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L3(9).2_2",["Characteristic",0],90,"computed (char. table)"],
["L3(9).2_2",["Characteristic",2],90,"computed (char. table)"],
["L3(9).2_2",["Characteristic",3],6,"computed (char. table)"],
["L3(9).2_2",["Characteristic",5],90,"computed (char. table)"],
["L3(9).2_2",["Characteristic",7],89,"computed (char. table)"],
["L3(9).2_2",["Characteristic",13],89,"computed (char. table)"],
["L3(9).2_2",["Size",2],90,"computed (char. table)"],
["L3(9).2_2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(9).2_2",["Size",3],6,"computed (char. table)"],
["L3(9).2_2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(9).2_2",["Size",5],90,"computed (char. table)"],
["L3(9).2_2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(9).2_2",["Size",7],89,"computed (char. table)"],
["L3(9).2_2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(9).2_2",["Size",13],89,"computed (char. table)"],
["L3(9).2_2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L3(9).2_3",["Characteristic",0],90,"computed (char. table)"],
["L3(9).2_3",["Characteristic",2],90,"computed (char. table)"],
["L3(9).2_3",["Characteristic",3],6,"computed (char. table)"],
["L3(9).2_3",["Characteristic",5],90,"computed (char. table)"],
["L3(9).2_3",["Characteristic",7],89,"computed (char. table)"],
["L3(9).2_3",["Characteristic",13],89,"computed (char. table)"],
["L3(9).2_3",["Size",2],90,"computed (char. table)"],
["L3(9).2_3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L3(9).2_3",["Size",3],12,"computed (char. table)"],
["L3(9).2_3",["Size",9],6,"computed (char. table)"],
["L3(9).2_3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L3(9).2_3",["Size",5],90,"computed (char. table)"],
["L3(9).2_3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L3(9).2_3",["Size",7],89,"computed (char. table)"],
["L3(9).2_3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L3(9).2_3",["Size",13],89,"computed (char. table)"],
["L3(9).2_3",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L4(3)","NrMovedPoints",40,"computed (table of marks)"],
["L4(3)",["Characteristic",0],26,"computed (char. table)"],
["L4(3)",["Characteristic",2],26,"computed (char. table)"],
["L4(3)",["Characteristic",3],6,"computed (char. table)"],
["L4(3)",["Characteristic",5],26,"computed (char. table)"],
["L4(3)",["Characteristic",13],26,"computed (char. table)"],
["L4(3)",["Size",2],26,"computed (char. table)"],
["L4(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L4(3)",["Size",3],6,"computed (char. table)"],
["L4(3)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L4(3)",["Size",5],26,"computed (char. table)"],
["L4(3)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L4(3)",["Size",13],26,"computed (char. table)"],
["L4(3)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L4(3).2_1",["Characteristic",0],39,"computed (char. table)"],
["L4(3).2_1",["Characteristic",2],38,"computed (char. table)"],
["L4(3).2_1",["Characteristic",3],6,"computed (char. table)"],
["L4(3).2_1",["Characteristic",5],38,"computed (char. table)"],
["L4(3).2_1",["Characteristic",13],39,"computed (char. table)"],
["L4(3).2_1",["Size",2],38,"computed (char. table)"],
["L4(3).2_1",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L4(3).2_1",["Size",3],6,"computed (char. table)"],
["L4(3).2_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L4(3).2_1",["Size",5],38,"computed (char. table)"],
["L4(3).2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L4(3).2_1",["Size",13],39,"computed (char. table)"],
["L4(3).2_1",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L4(3).2_2",["Characteristic",0],26,"computed (char. table)"],
["L4(3).2_2",["Characteristic",2],26,"computed (char. table)"],
["L4(3).2_2",["Characteristic",3],6,"computed (char. table)"],
["L4(3).2_2",["Characteristic",5],26,"computed (char. table)"],
["L4(3).2_2",["Characteristic",13],26,"computed (char. table)"],
["L4(3).2_2",["Size",2],26,"computed (char. table)"],
["L4(3).2_2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L4(3).2_2",["Size",3],6,"computed (char. table)"],
["L4(3).2_2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L4(3).2_2",["Size",5],26,"computed (char. table)"],
["L4(3).2_2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L4(3).2_2",["Size",13],26,"computed (char. table)"],
["L4(3).2_2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L4(3).2_3",["Characteristic",0],39,"computed (char. table)"],
["L4(3).2_3",["Characteristic",2],38,"computed (char. table)"],
["L4(3).2_3",["Characteristic",3],6,"computed (char. table)"],
["L4(3).2_3",["Characteristic",5],38,"computed (char. table)"],
["L4(3).2_3",["Characteristic",13],39,"computed (char. table)"],
["L4(3).2_3",["Size",2],38,"computed (char. table)"],
["L4(3).2_3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L4(3).2_3",["Size",3],12,"computed (char. table)"],
["L4(3).2_3",["Size",9],6,"computed (char. table)"],
["L4(3).2_3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L4(3).2_3",["Size",5],38,"computed (char. table)"],
["L4(3).2_3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L4(3).2_3",["Size",13],39,"computed (char. table)"],
["L4(3).2_3",["Characteristic",13,"complete"],true,"computed (char. table)"],
["L4(4)",["Characteristic",0],84,"computed (char. table)"],
["L4(4)",["Characteristic",3],84,"computed (char. table)"],
["L4(4)",["Characteristic",5],83,"computed (char. table)"],
["L4(4)",["Characteristic",7],84,"computed (char. table)"],
["L4(4)",["Characteristic",17],83,"computed (char. table)"],
["L4(4)",["Size",3],84,"computed (char. table)"],
["L4(4)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L4(4)",["Size",5],83,"computed (char. table)"],
["L4(4)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L4(4)",["Size",7],84,"computed (char. table)"],
["L4(4)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L4(4)",["Size",17],83,"computed (char. table)"],
["L4(4)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["L4(5)",["Characteristic",0],155,"computed (char. table)"],
["L5(2)","NrMovedPoints",31,"computed (subgroup tables)"],
["L5(2)","NrMovedPoints",31,"computed (subgroup tables, known repres.)"],
["L5(2)","NrMovedPoints",31,"computed (table of marks)"],
["L5(2)",["Characteristic",0],30,"computed (char. table)"],
["L5(2)",["Characteristic",2],5,"computed (char. table)"],
["L5(2)",["Characteristic",3],30,"computed (char. table)"],
["L5(2)",["Characteristic",5],30,"computed (char. table)"],
["L5(2)",["Characteristic",7],30,"computed (char. table)"],
["L5(2)",["Characteristic",31],29,"computed (char. table)"],
["L5(2)",["Size",2],5,"computed (char. table)"],
["L5(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L5(2)",["Size",3],30,"computed (char. table)"],
["L5(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L5(2)",["Size",5],30,"computed (char. table)"],
["L5(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L5(2)",["Size",7],30,"computed (char. table)"],
["L5(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L5(2)",["Size",31],29,"computed (char. table)"],
["L5(2)",["Characteristic",31,"complete"],true,"computed (char. table)"],
["L5(2).2",["Characteristic",0],30,"computed (char. table)"],
["L5(2).2",["Characteristic",2],10,"computed (char. table)"],
["L5(2).2",["Characteristic",3],30,"computed (char. table)"],
["L5(2).2",["Characteristic",5],30,"computed (char. table)"],
["L5(2).2",["Characteristic",7],30,"computed (char. table)"],
["L5(2).2",["Characteristic",31],29,"computed (char. table)"],
["L5(2).2",["Size",2],10,"computed (char. table)"],
["L5(2).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["L5(2).2",["Size",3],60,"computed (char. table)"],
["L5(2).2",["Size",9],30,"computed (char. table)"],
["L5(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L5(2).2",["Size",5],60,"computed (char. table)"],
["L5(2).2",["Size",25],30,"computed (char. table)"],
["L5(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L5(2).2",["Size",7],30,"computed (char. table)"],
["L5(2).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L5(2).2",["Size",31],29,"computed (char. table)"],
["L5(2).2",["Characteristic",31,"complete"],true,"computed (char. table)"],
["L5(3)",["Characteristic",0],120,"computed (char. table)"],
["L6(2)",["Characteristic",0],62,"computed (char. table)"],
["L6(2)",["Characteristic",3],61,"computed (char. table)"],
["L6(2)",["Characteristic",5],62,"computed (char. table)"],
["L6(2)",["Characteristic",7],61,"computed (char. table)"],
["L6(2)",["Characteristic",31],62,"computed (char. table)"],
["L6(2)",["Size",3],61,"computed (char. table)"],
["L6(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L6(2)",["Size",5],62,"computed (char. table)"],
["L6(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L6(2)",["Size",7],61,"computed (char. table)"],
["L6(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["L6(2)",["Size",31],62,"computed (char. table)"],
["L6(2)",["Characteristic",31,"complete"],true,"computed (char. table)"],
["L6(2).2",["Characteristic",0],62,"computed (char. table)"],
["L6(2).2",["Characteristic",3],61,"computed (char. table)"],
["L6(2).2",["Characteristic",5],62,"computed (char. table)"],
["L6(2).2",["Characteristic",31],62,"computed (char. table)"],
["L6(2).2",["Size",3],61,"computed (char. table)"],
["L6(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["L6(2).2",["Size",5],62,"computed (char. table)"],
["L6(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["L6(2).2",["Size",31],62,"computed (char. table)"],
["L6(2).2",["Characteristic",31,"complete"],true,"computed (char. table)"],
["L7(2)","NrMovedPoints",127,"computed (subgroup tables)"],
["L7(2)","NrMovedPoints",127,"computed (subgroup tables, known repres.)"],
["L7(2)",["Characteristic",0],126,"computed (char. table)"],
["L7(2).2",["Characteristic",0],126,"computed (char. table)"],
["Ly","NrMovedPoints",8835156,"computed (char. table)"],
["Ly",["Characteristic",0],2480,"computed (char. table)"],
["Ly",["Characteristic",7],2480,"computed (char. table)"],
["Ly",["Characteristic",11],2480,"computed (char. table)"],
["Ly",["Characteristic",31],2480,"computed (char. table)"],
["Ly",["Characteristic",37],2480,"computed (char. table)"],
["Ly",["Characteristic",67],2480,"computed (char. table)"],
["Ly",["Size",37],2480,"computed (char. table)"],
["Ly",["Characteristic",37,"complete"],true,"computed (char. table)"],
["Ly",["Size",67],2480,"computed (char. table)"],
["Ly",["Characteristic",67,"complete"],true,"computed (char. table)"],
["M","NrMovedPoints",97239461142009186000,"computed (char. table)"],
["M",["Characteristic",0],196883,"computed (char. table)"],
["M",["Characteristic",17],196883,"computed (char. table)"],
["M",["Characteristic",19],196883,"computed (char. table)"],
["M",["Characteristic",23],196883,"computed (char. table)"],
["M",["Characteristic",31],196883,"computed (char. table)"],
["M11","NrMovedPoints",11,"computed (char. table)"],
["M11","NrMovedPoints",11,"computed (subgroup tables)"],
["M11","NrMovedPoints",11,"computed (subgroup tables, known repres.)"],
["M11","NrMovedPoints",11,"computed (table of marks)"],
["M11",["Characteristic",0],10,"computed (char. table)"],
["M11",["Characteristic",2],10,"computed (char. table)"],
["M11",["Characteristic",3],5,"computed (char. table)"],
["M11",["Characteristic",5],10,"computed (char. table)"],
["M11",["Characteristic",11],9,"computed (char. table)"],
["M11",["Size",2],10,"computed (char. table)"],
["M11",["Characteristic",2,"complete"],true,"computed (char. table)"],
["M11",["Size",3],5,"computed (char. table)"],
["M11",["Characteristic",3,"complete"],true,"computed (char. table)"],
["M11",["Size",5],10,"computed (char. table)"],
["M11",["Characteristic",5,"complete"],true,"computed (char. table)"],
["M11",["Size",11],9,"computed (char. table)"],
["M11",["Characteristic",11,"complete"],true,"computed (char. table)"],
["M12","NrMovedPoints",12,"computed (char. table)"],
["M12","NrMovedPoints",12,"computed (subgroup tables)"],
["M12","NrMovedPoints",12,"computed (subgroup tables, known repres.)"],
["M12","NrMovedPoints",12,"computed (table of marks)"],
["M12",["Characteristic",0],11,"computed (char. table)"],
["M12",["Characteristic",2],10,"computed (char. table)"],
["M12",["Characteristic",3],10,"computed (char. table)"],
["M12",["Characteristic",5],11,"computed (char. table)"],
["M12",["Characteristic",11],11,"computed (char. table)"],
["M12",["Size",2],10,"computed (char. table)"],
["M12",["Characteristic",2,"complete"],true,"computed (char. table)"],
["M12",["Size",3],10,"computed (char. table)"],
["M12",["Characteristic",3,"complete"],true,"computed (char. table)"],
["M12",["Size",5],11,"computed (char. table)"],
["M12",["Characteristic",5,"complete"],true,"computed (char. table)"],
["M12",["Size",11],11,"computed (char. table)"],
["M12",["Characteristic",11,"complete"],true,"computed (char. table)"],
["M12.2","NrMovedPoints",24,"computed (char. table)"],
["M12.2","NrMovedPoints",24,"computed (table of marks)"],
["M12.2",["Characteristic",0],22,"computed (char. table)"],
["M12.2",["Characteristic",2],10,"computed (char. table)"],
["M12.2",["Characteristic",3],20,"computed (char. table)"],
["M12.2",["Characteristic",5],22,"computed (char. table)"],
["M12.2",["Characteristic",11],16,"computed (char. table)"],
["M12.2",["Size",2],10,"computed (char. table)"],
["M12.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["M12.2",["Size",3],20,"computed (char. table)"],
["M12.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["M12.2",["Size",5],22,"computed (char. table)"],
["M12.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["M12.2",["Size",11],16,"computed (char. table)"],
["M12.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["M22","NrMovedPoints",22,"computed (char. table)"],
["M22","NrMovedPoints",22,"computed (table of marks)"],
["M22",["Characteristic",0],21,"computed (char. table)"],
["M22",["Characteristic",2],10,"computed (char. table)"],
["M22",["Characteristic",3],21,"computed (char. table)"],
["M22",["Characteristic",5],21,"computed (char. table)"],
["M22",["Characteristic",7],21,"computed (char. table)"],
["M22",["Characteristic",11],20,"computed (char. table)"],
["M22",["Size",2],10,"computed (char. table)"],
["M22",["Characteristic",2,"complete"],true,"computed (char. table)"],
["M22",["Size",3],21,"computed (char. table)"],
["M22",["Characteristic",3,"complete"],true,"computed (char. table)"],
["M22",["Size",5],21,"computed (char. table)"],
["M22",["Characteristic",5,"complete"],true,"computed (char. table)"],
["M22",["Size",7],21,"computed (char. table)"],
["M22",["Characteristic",7,"complete"],true,"computed (char. table)"],
["M22",["Size",11],20,"computed (char. table)"],
["M22",["Characteristic",11,"complete"],true,"computed (char. table)"],
["M22.2","NrMovedPoints",22,"computed (char. table)"],
["M22.2","NrMovedPoints",22,"computed (subgroup tables)"],
["M22.2","NrMovedPoints",22,"computed (subgroup tables, known repres.)"],
["M22.2","NrMovedPoints",22,"computed (table of marks)"],
["M22.2",["Characteristic",0],21,"computed (char. table)"],
["M22.2",["Characteristic",2],10,"computed (char. table)"],
["M22.2",["Characteristic",3],21,"computed (char. table)"],
["M22.2",["Characteristic",5],21,"computed (char. table)"],
["M22.2",["Characteristic",7],21,"computed (char. table)"],
["M22.2",["Characteristic",11],20,"computed (char. table)"],
["M22.2",["Size",2],10,"computed (char. table)"],
["M22.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["M22.2",["Size",3],21,"computed (char. table)"],
["M22.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["M22.2",["Size",5],21,"computed (char. table)"],
["M22.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["M22.2",["Size",7],21,"computed (char. table)"],
["M22.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["M22.2",["Size",11],20,"computed (char. table)"],
["M22.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["M23","NrMovedPoints",23,"computed (char. table)"],
["M23","NrMovedPoints",23,"computed (subgroup tables)"],
["M23","NrMovedPoints",23,"computed (subgroup tables, known repres.)"],
["M23","NrMovedPoints",23,"computed (table of marks)"],
["M23",["Characteristic",0],22,"computed (char. table)"],
["M23",["Characteristic",2],11,"computed (char. table)"],
["M23",["Characteristic",3],22,"computed (char. table)"],
["M23",["Characteristic",5],22,"computed (char. table)"],
["M23",["Characteristic",7],22,"computed (char. table)"],
["M23",["Characteristic",11],22,"computed (char. table)"],
["M23",["Characteristic",23],21,"computed (char. table)"],
["M23",["Size",2],11,"computed (char. table)"],
["M23",["Characteristic",2,"complete"],true,"computed (char. table)"],
["M23",["Size",3],22,"computed (char. table)"],
["M23",["Characteristic",3,"complete"],true,"computed (char. table)"],
["M23",["Size",5],22,"computed (char. table)"],
["M23",["Characteristic",5,"complete"],true,"computed (char. table)"],
["M23",["Size",7],22,"computed (char. table)"],
["M23",["Characteristic",7,"complete"],true,"computed (char. table)"],
["M23",["Size",11],22,"computed (char. table)"],
["M23",["Characteristic",11,"complete"],true,"computed (char. table)"],
["M23",["Size",23],21,"computed (char. table)"],
["M23",["Characteristic",23,"complete"],true,"computed (char. table)"],
["M24","NrMovedPoints",24,"computed (char. table)"],
["M24","NrMovedPoints",24,"computed (subgroup tables)"],
["M24","NrMovedPoints",24,"computed (subgroup tables, known repres.)"],
["M24","NrMovedPoints",24,"computed (table of marks)"],
["M24",["Characteristic",0],23,"computed (char. table)"],
["M24",["Characteristic",2],11,"computed (char. table)"],
["M24",["Characteristic",3],22,"computed (char. table)"],
["M24",["Characteristic",5],23,"computed (char. table)"],
["M24",["Characteristic",7],23,"computed (char. table)"],
["M24",["Characteristic",11],23,"computed (char. table)"],
["M24",["Characteristic",23],23,"computed (char. table)"],
["M24",["Size",2],11,"computed (char. table)"],
["M24",["Characteristic",2,"complete"],true,"computed (char. table)"],
["M24",["Size",3],22,"computed (char. table)"],
["M24",["Characteristic",3,"complete"],true,"computed (char. table)"],
["M24",["Size",5],23,"computed (char. table)"],
["M24",["Characteristic",5,"complete"],true,"computed (char. table)"],
["M24",["Size",7],23,"computed (char. table)"],
["M24",["Characteristic",7,"complete"],true,"computed (char. table)"],
["M24",["Size",11],23,"computed (char. table)"],
["M24",["Characteristic",11,"complete"],true,"computed (char. table)"],
["M24",["Size",23],23,"computed (char. table)"],
["M24",["Characteristic",23,"complete"],true,"computed (char. table)"],
["McL","NrMovedPoints",275,"computed (char. table)"],
["McL","NrMovedPoints",275,"computed (table of marks)"],
["McL",["Characteristic",0],22,"computed (char. table)"],
["McL",["Characteristic",2],22,"computed (char. table)"],
["McL",["Characteristic",3],21,"computed (char. table)"],
["McL",["Characteristic",5],21,"computed (char. table)"],
["McL",["Characteristic",7],22,"computed (char. table)"],
["McL",["Characteristic",11],22,"computed (char. table)"],
["McL",["Size",2],22,"computed (char. table)"],
["McL",["Characteristic",2,"complete"],true,"computed (char. table)"],
["McL",["Size",3],21,"computed (char. table)"],
["McL",["Characteristic",3,"complete"],true,"computed (char. table)"],
["McL",["Size",5],21,"computed (char. table)"],
["McL",["Characteristic",5,"complete"],true,"computed (char. table)"],
["McL",["Size",7],22,"computed (char. table)"],
["McL",["Characteristic",7,"complete"],true,"computed (char. table)"],
["McL",["Size",11],22,"computed (char. table)"],
["McL",["Characteristic",11,"complete"],true,"computed (char. table)"],
["McL.2","NrMovedPoints",275,"computed (char. table)"],
["McL.2","NrMovedPoints",275,"computed (subgroup tables)"],
["McL.2","NrMovedPoints",275,"computed (subgroup tables, known repres.)"],
["McL.2","NrMovedPoints",275,"computed (table of marks)"],
["McL.2",["Characteristic",0],22,"computed (char. table)"],
["McL.2",["Characteristic",2],22,"computed (char. table)"],
["McL.2",["Characteristic",3],21,"computed (char. table)"],
["McL.2",["Characteristic",5],21,"computed (char. table)"],
["McL.2",["Characteristic",7],22,"computed (char. table)"],
["McL.2",["Characteristic",11],22,"computed (char. table)"],
["McL.2",["Size",2],22,"computed (char. table)"],
["McL.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["McL.2",["Size",3],21,"computed (char. table)"],
["McL.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["McL.2",["Size",5],21,"computed (char. table)"],
["McL.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["McL.2",["Size",7],22,"computed (char. table)"],
["McL.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["McL.2",["Size",11],22,"computed (char. table)"],
["McL.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["O10+(2)","NrMovedPoints",496,"computed (char. table)"],
["O10+(2)",["Characteristic",0],155,"computed (char. table)"],
["O10+(2)",["Characteristic",3],155,"computed (char. table)"],
["O10+(2)",["Characteristic",5],155,"computed (char. table)"],
["O10+(2)",["Characteristic",7],155,"computed (char. table)"],
["O10+(2)",["Characteristic",17],155,"computed (char. table)"],
["O10+(2)",["Characteristic",31],155,"computed (char. table)"],
["O10+(2)",["Size",3],155,"computed (char. table)"],
["O10+(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O10+(2)",["Size",5],155,"computed (char. table)"],
["O10+(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O10+(2)",["Size",7],155,"computed (char. table)"],
["O10+(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O10+(2)",["Size",17],155,"computed (char. table)"],
["O10+(2)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["O10+(2)",["Size",31],155,"computed (char. table)"],
["O10+(2)",["Characteristic",31,"complete"],true,"computed (char. table)"],
["O10+(2).2","NrMovedPoints",496,"computed (subgroup tables, known repres.)"],
["O10+(2).2",["Characteristic",0],155,"computed (char. table)"],
["O10+(2).2",["Characteristic",3],155,"computed (char. table)"],
["O10+(2).2",["Characteristic",5],155,"computed (char. table)"],
["O10+(2).2",["Characteristic",7],155,"computed (char. table)"],
["O10+(2).2",["Characteristic",17],155,"computed (char. table)"],
["O10+(2).2",["Characteristic",31],155,"computed (char. table)"],
["O10+(2).2",["Size",3],155,"computed (char. table)"],
["O10+(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O10+(2).2",["Size",5],155,"computed (char. table)"],
["O10+(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O10+(2).2",["Size",7],155,"computed (char. table)"],
["O10+(2).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O10+(2).2",["Size",17],155,"computed (char. table)"],
["O10+(2).2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["O10+(2).2",["Size",31],155,"computed (char. table)"],
["O10+(2).2",["Characteristic",31,"complete"],true,"computed (char. table)"],
["O10-(2)","NrMovedPoints",495,"computed (char. table)"],
["O10-(2)",["Characteristic",0],154,"computed (char. table)"],
["O10-(2)",["Characteristic",3],153,"computed (char. table)"],
["O10-(2)",["Characteristic",5],153,"computed (char. table)"],
["O10-(2)",["Characteristic",7],154,"computed (char. table)"],
["O10-(2)",["Characteristic",11],154,"computed (char. table)"],
["O10-(2)",["Characteristic",17],154,"computed (char. table)"],
["O10-(2)",["Size",3],153,"computed (char. table)"],
["O10-(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O10-(2)",["Size",5],153,"computed (char. table)"],
["O10-(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O10-(2)",["Size",7],154,"computed (char. table)"],
["O10-(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O10-(2)",["Size",11],154,"computed (char. table)"],
["O10-(2)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["O10-(2)",["Size",17],154,"computed (char. table)"],
["O10-(2)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["O10-(2).2","NrMovedPoints",495,"computed (subgroup tables, known repres.)"],
["O10-(2).2",["Characteristic",0],154,"computed (char. table)"],
["O10-(2).2",["Characteristic",3],153,"computed (char. table)"],
["O10-(2).2",["Characteristic",5],153,"computed (char. table)"],
["O10-(2).2",["Characteristic",7],154,"computed (char. table)"],
["O10-(2).2",["Characteristic",11],154,"computed (char. table)"],
["O10-(2).2",["Characteristic",17],154,"computed (char. table)"],
["O10-(2).2",["Size",3],153,"computed (char. table)"],
["O10-(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O10-(2).2",["Size",5],153,"computed (char. table)"],
["O10-(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O10-(2).2",["Size",7],154,"computed (char. table)"],
["O10-(2).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O10-(2).2",["Size",11],154,"computed (char. table)"],
["O10-(2).2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["O10-(2).2",["Size",17],154,"computed (char. table)"],
["O10-(2).2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["O7(3)","NrMovedPoints",351,"computed (char. table)"],
["O7(3)","NrMovedPoints",351,"computed (subgroup tables)"],
["O7(3)","NrMovedPoints",351,"computed (subgroup tables, known repres.)"],
["O7(3)",["Characteristic",0],78,"computed (char. table)"],
["O7(3)",["Characteristic",2],78,"computed (char. table)"],
["O7(3)",["Characteristic",3],7,"computed (char. table)"],
["O7(3)",["Characteristic",5],78,"computed (char. table)"],
["O7(3)",["Characteristic",7],78,"computed (char. table)"],
["O7(3)",["Characteristic",13],78,"computed (char. table)"],
["O7(3)",["Size",2],78,"computed (char. table)"],
["O7(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["O7(3)",["Size",3],7,"computed (char. table)"],
["O7(3)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O7(3)",["Size",5],78,"computed (char. table)"],
["O7(3)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O7(3)",["Size",7],78,"computed (char. table)"],
["O7(3)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O7(3)",["Size",13],78,"computed (char. table)"],
["O7(3)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["O7(3).2","NrMovedPoints",351,"computed (subgroup tables, known repres.)"],
["O7(3).2",["Characteristic",0],78,"computed (char. table)"],
["O7(3).2",["Characteristic",2],78,"computed (char. table)"],
["O7(3).2",["Characteristic",3],7,"computed (char. table)"],
["O7(3).2",["Characteristic",5],78,"computed (char. table)"],
["O7(3).2",["Characteristic",7],78,"computed (char. table)"],
["O7(3).2",["Characteristic",13],78,"computed (char. table)"],
["O7(3).2",["Size",2],78,"computed (char. table)"],
["O7(3).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["O7(3).2",["Size",3],7,"computed (char. table)"],
["O7(3).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O7(3).2",["Size",5],78,"computed (char. table)"],
["O7(3).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O7(3).2",["Size",7],78,"computed (char. table)"],
["O7(3).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O7(3).2",["Size",13],78,"computed (char. table)"],
["O7(3).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["O8+(2)","NrMovedPoints",120,"computed (table of marks)"],
["O8+(2)",["Characteristic",0],28,"computed (char. table)"],
["O8+(2)",["Characteristic",2],8,"computed (char. table)"],
["O8+(2)",["Characteristic",3],28,"computed (char. table)"],
["O8+(2)",["Characteristic",5],28,"computed (char. table)"],
["O8+(2)",["Characteristic",7],28,"computed (char. table)"],
["O8+(2)",["Size",2],8,"computed (char. table)"],
["O8+(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["O8+(2)",["Size",3],28,"computed (char. table)"],
["O8+(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O8+(2)",["Size",5],28,"computed (char. table)"],
["O8+(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O8+(2)",["Size",7],28,"computed (char. table)"],
["O8+(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O8+(2).2","NrMovedPoints",120,"computed (subgroup tables)"],
["O8+(2).2",["Characteristic",0],28,"computed (char. table)"],
["O8+(2).2",["Characteristic",2],8,"computed (char. table)"],
["O8+(2).2",["Characteristic",3],28,"computed (char. table)"],
["O8+(2).2",["Characteristic",5],28,"computed (char. table)"],
["O8+(2).2",["Characteristic",7],28,"computed (char. table)"],
["O8+(2).2",["Size",2],8,"computed (char. table)"],
["O8+(2).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["O8+(2).2",["Size",3],28,"computed (char. table)"],
["O8+(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O8+(2).2",["Size",5],28,"computed (char. table)"],
["O8+(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O8+(2).2",["Size",7],28,"computed (char. table)"],
["O8+(2).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O8+(2).3",["Characteristic",0],28,"computed (char. table)"],
["O8+(2).3",["Characteristic",2],24,"computed (char. table)"],
["O8+(2).3",["Characteristic",3],28,"computed (char. table)"],
["O8+(2).3",["Characteristic",5],28,"computed (char. table)"],
["O8+(2).3",["Characteristic",7],28,"computed (char. table)"],
["O8+(2).3",["Size",2],24,"computed (char. table)"],
["O8+(2).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["O8+(2).3",["Size",3],28,"computed (char. table)"],
["O8+(2).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O8+(2).3",["Size",5],28,"computed (char. table)"],
["O8+(2).3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O8+(2).3",["Size",7],28,"computed (char. table)"],
["O8+(2).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O8+(3)","NrMovedPoints",1080,"computed (char. table)"],
["O8+(3)",["Characteristic",0],260,"computed (char. table)"],
["O8+(3)",["Characteristic",2],260,"computed (char. table)"],
["O8+(3)",["Characteristic",5],260,"computed (char. table)"],
["O8+(3)",["Characteristic",7],260,"computed (char. table)"],
["O8+(3)",["Characteristic",13],260,"computed (char. table)"],
["O8+(3)",["Size",2],260,"computed (char. table)"],
["O8+(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["O8+(3)",["Size",5],260,"computed (char. table)"],
["O8+(3)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O8+(3)",["Size",7],260,"computed (char. table)"],
["O8+(3)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O8+(3)",["Size",13],260,"computed (char. table)"],
["O8+(3)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["O8+(3).S4",["Characteristic",0],300,"computed (char. table)"],
["O8+(3).S4",["Characteristic",2],298,"computed (char. table)"],
["O8+(3).S4",["Characteristic",5],300,"computed (char. table)"],
["O8+(3).S4",["Characteristic",7],299,"computed (char. table)"],
["O8+(3).S4",["Characteristic",13],300,"computed (char. table)"],
["O8+(3).S4",["Size",2],298,"computed (char. table)"],
["O8+(3).S4",["Characteristic",2,"complete"],true,"computed (char. table)"],
["O8+(3).S4",["Size",5],300,"computed (char. table)"],
["O8+(3).S4",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O8+(3).S4",["Size",7],299,"computed (char. table)"],
["O8+(3).S4",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O8+(3).S4",["Size",13],300,"computed (char. table)"],
["O8+(3).S4",["Characteristic",13,"complete"],true,"computed (char. table)"],
["O8-(2)","NrMovedPoints",119,"computed (char. table)"],
["O8-(2)","NrMovedPoints",119,"computed (table of marks)"],
["O8-(2)",["Characteristic",0],34,"computed (char. table)"],
["O8-(2)",["Characteristic",2],8,"computed (char. table)"],
["O8-(2)",["Characteristic",3],34,"computed (char. table)"],
["O8-(2)",["Characteristic",5],34,"computed (char. table)"],
["O8-(2)",["Characteristic",7],33,"computed (char. table)"],
["O8-(2)",["Characteristic",17],34,"computed (char. table)"],
["O8-(2)",["Size",2],8,"computed (char. table)"],
["O8-(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["O8-(2)",["Size",3],34,"computed (char. table)"],
["O8-(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O8-(2)",["Size",5],34,"computed (char. table)"],
["O8-(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O8-(2)",["Size",7],33,"computed (char. table)"],
["O8-(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O8-(2)",["Size",17],34,"computed (char. table)"],
["O8-(2)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["O8-(2).2","NrMovedPoints",119,"computed (subgroup tables, known repres.)"],
["O8-(2).2",["Characteristic",0],34,"computed (char. table)"],
["O8-(2).2",["Characteristic",2],8,"computed (char. table)"],
["O8-(2).2",["Characteristic",3],34,"computed (char. table)"],
["O8-(2).2",["Characteristic",5],34,"computed (char. table)"],
["O8-(2).2",["Characteristic",7],33,"computed (char. table)"],
["O8-(2).2",["Characteristic",17],34,"computed (char. table)"],
["O8-(2).2",["Size",2],8,"computed (char. table)"],
["O8-(2).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["O8-(2).2",["Size",3],34,"computed (char. table)"],
["O8-(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["O8-(2).2",["Size",5],34,"computed (char. table)"],
["O8-(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O8-(2).2",["Size",7],33,"computed (char. table)"],
["O8-(2).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["O8-(2).2",["Size",17],34,"computed (char. table)"],
["O8-(2).2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["O8-(3)",["Characteristic",0],246,"computed (char. table)"],
["O8-(3)",["Characteristic",2],246,"computed (char. table)"],
["O8-(3)",["Characteristic",5],246,"computed (char. table)"],
["O8-(3)",["Characteristic",7],246,"computed (char. table)"],
["O8-(3)",["Characteristic",13],245,"computed (char. table)"],
["O8-(3)",["Characteristic",41],246,"computed (char. table)"],
["O8-(3)",["Size",2],246,"computed (char. table)"],
["O8-(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["O8-(3)",["Size",5],246,"computed (char. table)"],
["O8-(3)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["O8-(3)",["Size",41],246,"computed (char. table)"],
["O8-(3)",["Characteristic",41,"complete"],true,"computed (char. table)"],
["O8-(3).2_1","NrMovedPoints",1066,"computed (subgroup tables, known repres.)"],
["O8-(3).2_1",["Characteristic",0],246,"computed (char. table)"],
["O9(3)",["Characteristic",0],780,"computed (char. table)"],
["ON","NrMovedPoints",122760,"computed (char. table)"],
["ON",["Characteristic",0],10944,"computed (char. table)"],
["ON",["Characteristic",2],10944,"computed (char. table)"],
["ON",["Characteristic",3],154,"computed (char. table)"],
["ON",["Characteristic",5],10943,"computed (char. table)"],
["ON",["Characteristic",7],406,"computed (char. table)"],
["ON",["Characteristic",11],10787,"computed (char. table)"],
["ON",["Characteristic",19],10944,"computed (char. table)"],
["ON",["Characteristic",31],1869,"computed (char. table)"],
["ON",["Size",2],10944,"computed (char. table)"],
["ON",["Characteristic",2,"complete"],true,"computed (char. table)"],
["ON",["Size",3],154,"computed (char. table)"],
["ON",["Characteristic",3,"complete"],true,"computed (char. table)"],
["ON",["Size",5],10943,"computed (char. table)"],
["ON",["Characteristic",5,"complete"],true,"computed (char. table)"],
["ON",["Size",7],406,"computed (char. table)"],
["ON",["Characteristic",7,"complete"],true,"computed (char. table)"],
["ON",["Size",11],10787,"computed (char. table)"],
["ON",["Characteristic",11,"complete"],true,"computed (char. table)"],
["ON",["Size",19],10944,"computed (char. table)"],
["ON",["Characteristic",19,"complete"],true,"computed (char. table)"],
["ON",["Size",31],1869,"computed (char. table)"],
["ON",["Characteristic",31,"complete"],true,"computed (char. table)"],
["ON.2",["Characteristic",0],10944,"computed (char. table)"],
["ON.2",["Characteristic",2],10944,"computed (char. table)"],
["ON.2",["Characteristic",5],10943,"computed (char. table)"],
["ON.2",["Characteristic",7],406,"computed (char. table)"],
["ON.2",["Characteristic",11],10787,"computed (char. table)"],
["ON.2",["Characteristic",19],10944,"computed (char. table)"],
["ON.2",["Characteristic",31],1869,"computed (char. table)"],
["ON.2",["Size",2],10944,"computed (char. table)"],
["ON.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["ON.2",["Size",5],10943,"computed (char. table)"],
["ON.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["ON.2",["Size",7],406,"computed (char. table)"],
["ON.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["ON.2",["Size",11],10787,"computed (char. table)"],
["ON.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["ON.2",["Size",19],10944,"computed (char. table)"],
["ON.2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["ON.2",["Size",31],1869,"computed (char. table)"],
["ON.2",["Characteristic",31,"complete"],true,"computed (char. table)"],
["R(27)",["Characteristic",0],703,"computed (char. table)"],
["R(27)",["Characteristic",2],702,"computed (char. table)"],
["R(27)",["Characteristic",3],7,"computed (char. table)"],
["R(27)",["Characteristic",7],703,"computed (char. table)"],
["R(27)",["Characteristic",13],703,"computed (char. table)"],
["R(27)",["Characteristic",19],703,"computed (char. table)"],
["R(27)",["Characteristic",37],703,"computed (char. table)"],
["R(27)",["Size",2],702,"computed (char. table)"],
["R(27)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["R(27)",["Size",3],21,"computed (char. table)"],
["R(27)",["Size",27],7,"computed (char. table)"],
["R(27)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["R(27)",["Size",7],703,"computed (char. table)"],
["R(27)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["R(27)",["Size",37],703,"computed (char. table)"],
["R(27)",["Characteristic",37,"complete"],true,"computed (char. table)"],
["R(27).3","NrMovedPoints",19684,"computed (subgroup tables, known repres.)"],
["R(27).3",["Characteristic",0],703,"computed (char. table)"],
["R(27).3",["Characteristic",2],702,"computed (char. table)"],
["R(27).3",["Characteristic",3],21,"computed (char. table)"],
["R(27).3",["Characteristic",7],703,"computed (char. table)"],
["R(27).3",["Characteristic",13],703,"computed (char. table)"],
["R(27).3",["Characteristic",19],703,"computed (char. table)"],
["R(27).3",["Characteristic",37],703,"computed (char. table)"],
["R(27).3",["Size",2],702,"computed (char. table)"],
["R(27).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["R(27).3",["Size",3],21,"computed (char. table)"],
["R(27).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["R(27).3",["Size",7],703,"computed (char. table)"],
["R(27).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["R(27).3",["Size",37],703,"computed (char. table)"],
["R(27).3",["Characteristic",37,"complete"],true,"computed (char. table)"],
["Ru","NrMovedPoints",4060,"computed (char. table)"],
["Ru",["Characteristic",0],378,"computed (char. table)"],
["Ru",["Characteristic",2],28,"computed (char. table)"],
["Ru",["Characteristic",3],378,"computed (char. table)"],
["Ru",["Characteristic",5],133,"computed (char. table)"],
["Ru",["Characteristic",7],378,"computed (char. table)"],
["Ru",["Characteristic",13],378,"computed (char. table)"],
["Ru",["Characteristic",29],378,"computed (char. table)"],
["Ru",["Size",2],28,"computed (char. table)"],
["Ru",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Ru",["Size",3],406,"computed (char. table)"],
["Ru",["Size",9],378,"computed (char. table)"],
["Ru",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Ru",["Size",5],133,"computed (char. table)"],
["Ru",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Ru",["Size",7],406,"computed (char. table)"],
["Ru",["Size",49],378,"computed (char. table)"],
["Ru",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Ru",["Size",13],378,"computed (char. table)"],
["Ru",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Ru",["Size",29],378,"computed (char. table)"],
["Ru",["Characteristic",29,"complete"],true,"computed (char. table)"],
["S10(2)","NrMovedPoints",496,"computed (subgroup tables)"],
["S10(2)","NrMovedPoints",496,"computed (subgroup tables, known repres.)"],
["S10(2)",["Characteristic",0],155,"computed (char. table)"],
["S10(2)",["Characteristic",5],155,"computed (char. table)"],
["S10(2)",["Characteristic",7],155,"computed (char. table)"],
["S10(2)",["Characteristic",11],155,"computed (char. table)"],
["S10(2)",["Characteristic",17],155,"computed (char. table)"],
["S10(2)",["Characteristic",31],155,"computed (char. table)"],
["S10(2)",["Size",5],155,"computed (char. table)"],
["S10(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["S10(2)",["Size",7],155,"computed (char. table)"],
["S10(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["S10(2)",["Size",11],155,"computed (char. table)"],
["S10(2)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["S10(2)",["Size",17],155,"computed (char. table)"],
["S10(2)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["S10(2)",["Size",31],155,"computed (char. table)"],
["S10(2)",["Characteristic",31,"complete"],true,"computed (char. table)"],
["S4(4)","NrMovedPoints",85,"computed (table of marks)"],
["S4(4)",["Characteristic",0],18,"computed (char. table)"],
["S4(4)",["Characteristic",2],4,"computed (char. table)"],
["S4(4)",["Characteristic",3],18,"computed (char. table)"],
["S4(4)",["Characteristic",5],18,"computed (char. table)"],
["S4(4)",["Characteristic",17],18,"computed (char. table)"],
["S4(4)",["Size",2],8,"computed (char. table)"],
["S4(4)",["Size",4],4,"computed (char. table)"],
["S4(4)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["S4(4)",["Size",3],18,"computed (char. table)"],
["S4(4)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["S4(4)",["Size",5],18,"computed (char. table)"],
["S4(4)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["S4(4)",["Size",17],18,"computed (char. table)"],
["S4(4)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["S4(4).2","NrMovedPoints",85,"computed (table of marks)"],
["S4(4).2",["Characteristic",0],18,"computed (char. table)"],
["S4(4).2",["Characteristic",2],8,"computed (char. table)"],
["S4(4).2",["Characteristic",3],18,"computed (char. table)"],
["S4(4).2",["Characteristic",5],18,"computed (char. table)"],
["S4(4).2",["Characteristic",17],18,"computed (char. table)"],
["S4(4).2",["Size",2],8,"computed (char. table)"],
["S4(4).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["S4(4).2",["Size",3],34,"computed (char. table)"],
["S4(4).2",["Size",9],18,"computed (char. table)"],
["S4(4).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["S4(4).2",["Size",5],18,"computed (char. table)"],
["S4(4).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["S4(4).2",["Size",17],18,"computed (char. table)"],
["S4(4).2",["Characteristic",17,"complete"],true,"computed (char. table)"],
["S4(4).4",["Characteristic",0],18,"computed (char. table)"],
["S4(4).4",["Characteristic",2],16,"computed (char. table)"],
["S4(4).4",["Characteristic",3],18,"computed (char. table)"],
["S4(4).4",["Characteristic",5],18,"computed (char. table)"],
["S4(4).4",["Characteristic",17],18,"computed (char. table)"],
["S4(4).4",["Size",2],16,"computed (char. table)"],
["S4(4).4",["Characteristic",2,"complete"],true,"computed (char. table)"],
["S4(4).4",["Size",3],36,"computed (char. table)"],
["S4(4).4",["Size",9],18,"computed (char. table)"],
["S4(4).4",["Characteristic",3,"complete"],true,"computed (char. table)"],
["S4(4).4",["Size",5],18,"computed (char. table)"],
["S4(4).4",["Characteristic",5,"complete"],true,"computed (char. table)"],
["S4(4).4",["Size",17],18,"computed (char. table)"],
["S4(4).4",["Characteristic",17,"complete"],true,"computed (char. table)"],
["S4(5)","NrMovedPoints",156,"computed (table of marks)"],
["S4(5)",["Characteristic",0],13,"computed (char. table)"],
["S4(5)",["Characteristic",2],12,"computed (char. table)"],
["S4(5)",["Characteristic",3],13,"computed (char. table)"],
["S4(5)",["Characteristic",5],5,"computed (char. table)"],
["S4(5)",["Characteristic",13],13,"computed (char. table)"],
["S4(5)",["Size",2],24,"computed (char. table)"],
["S4(5)",["Size",4],12,"computed (char. table)"],
["S4(5)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["S4(5)",["Size",3],26,"computed (char. table)"],
["S4(5)",["Size",9],13,"computed (char. table)"],
["S4(5)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["S4(5)",["Size",5],5,"computed (char. table)"],
["S4(5)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["S4(5)",["Size",13],26,"computed (char. table)"],
["S4(5)",["Size",169],13,"computed (char. table)"],
["S4(5)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["S4(5).2",["Characteristic",0],26,"computed (char. table)"],
["S4(5).2",["Characteristic",2],24,"computed (char. table)"],
["S4(5).2",["Characteristic",3],26,"computed (char. table)"],
["S4(5).2",["Characteristic",5],5,"computed (char. table)"],
["S4(5).2",["Characteristic",13],26,"computed (char. table)"],
["S4(5).2",["Size",2],24,"computed (char. table)"],
["S4(5).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["S4(5).2",["Size",3],26,"computed (char. table)"],
["S4(5).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["S4(5).2",["Size",5],5,"computed (char. table)"],
["S4(5).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["S4(5).2",["Size",13],26,"computed (char. table)"],
["S4(5).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["S4(7)",["Characteristic",0],25,"computed (char. table)"],
["S4(7).2",["Characteristic",0],50,"computed (char. table)"],
["S4(9)",["Characteristic",0],41,"computed (char. table)"],
["S6(2)","NrMovedPoints",28,"computed (char. table)"],
["S6(2)","NrMovedPoints",28,"computed (subgroup tables)"],
["S6(2)","NrMovedPoints",28,"computed (subgroup tables, known repres.)"],
["S6(2)","NrMovedPoints",28,"computed (table of marks)"],
["S6(2)",["Characteristic",0],7,"computed (char. table)"],
["S6(2)",["Characteristic",2],6,"computed (char. table)"],
["S6(2)",["Characteristic",3],7,"computed (char. table)"],
["S6(2)",["Characteristic",5],7,"computed (char. table)"],
["S6(2)",["Characteristic",7],7,"computed (char. table)"],
["S6(2)",["Size",2],6,"computed (char. table)"],
["S6(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["S6(2)",["Size",3],7,"computed (char. table)"],
["S6(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["S6(2)",["Size",5],7,"computed (char. table)"],
["S6(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["S6(2)",["Size",7],7,"computed (char. table)"],
["S6(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["S6(3)","NrMovedPoints",364,"computed (char. table)"],
["S6(3)",["Characteristic",0],13,"computed (char. table)"],
["S6(3)",["Characteristic",2],13,"computed (char. table)"],
["S6(3)",["Characteristic",3],13,"computed (char. table)"],
["S6(3)",["Characteristic",5],13,"computed (char. table)"],
["S6(3)",["Characteristic",7],13,"computed (char. table)"],
["S6(3)",["Characteristic",13],13,"computed (char. table)"],
["S6(3)",["Size",2],26,"computed (char. table)"],
["S6(3)",["Size",4],13,"computed (char. table)"],
["S6(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["S6(3)",["Size",3],13,"computed (char. table)"],
["S6(3)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["S6(3)",["Size",5],26,"computed (char. table)"],
["S6(3)",["Size",25],13,"computed (char. table)"],
["S6(3)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["S6(3)",["Size",7],13,"computed (char. table)"],
["S6(3)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["S6(3)",["Size",13],13,"computed (char. table)"],
["S6(3)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["S6(3).2","NrMovedPoints",364,"computed (char. table)"],
["S6(3).2","NrMovedPoints",364,"computed (subgroup tables)"],
["S6(3).2","NrMovedPoints",364,"computed (subgroup tables, known repres.)"],
["S6(3).2",["Characteristic",0],26,"computed (char. table)"],
["S6(3).2",["Characteristic",2],26,"computed (char. table)"],
["S6(3).2",["Characteristic",3],13,"computed (char. table)"],
["S6(3).2",["Characteristic",5],26,"computed (char. table)"],
["S6(3).2",["Characteristic",7],26,"computed (char. table)"],
["S6(3).2",["Characteristic",13],26,"computed (char. table)"],
["S6(3).2",["Size",2],26,"computed (char. table)"],
["S6(3).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["S6(3).2",["Size",3],13,"computed (char. table)"],
["S6(3).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["S6(3).2",["Size",5],26,"computed (char. table)"],
["S6(3).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["S6(3).2",["Size",7],26,"computed (char. table)"],
["S6(3).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["S6(3).2",["Size",13],26,"computed (char. table)"],
["S6(3).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["S6(5)",["Characteristic",0],63,"computed (char. table)"],
["S8(2)","NrMovedPoints",120,"computed (char. table)"],
["S8(2)","NrMovedPoints",120,"computed (subgroup tables)"],
["S8(2)","NrMovedPoints",120,"computed (subgroup tables, known repres.)"],
["S8(2)",["Characteristic",0],35,"computed (char. table)"],
["S8(2)",["Characteristic",2],8,"computed (char. table)"],
["S8(2)",["Characteristic",3],35,"computed (char. table)"],
["S8(2)",["Characteristic",5],35,"computed (char. table)"],
["S8(2)",["Characteristic",7],35,"computed (char. table)"],
["S8(2)",["Characteristic",17],35,"computed (char. table)"],
["S8(2)",["Size",2],8,"computed (char. table)"],
["S8(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["S8(2)",["Size",3],35,"computed (char. table)"],
["S8(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["S8(2)",["Size",5],35,"computed (char. table)"],
["S8(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["S8(2)",["Size",7],35,"computed (char. table)"],
["S8(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["S8(2)",["Size",17],35,"computed (char. table)"],
["S8(2)",["Characteristic",17,"complete"],true,"computed (char. table)"],
["S8(3)",["Characteristic",0],41,"computed (char. table)"],
["Suz","NrMovedPoints",1782,"computed (char. table)"],
["Suz",["Characteristic",0],143,"computed (char. table)"],
["Suz",["Characteristic",2],110,"computed (char. table)"],
["Suz",["Characteristic",3],64,"computed (char. table)"],
["Suz",["Characteristic",5],143,"computed (char. table)"],
["Suz",["Characteristic",7],143,"computed (char. table)"],
["Suz",["Characteristic",11],143,"computed (char. table)"],
["Suz",["Characteristic",13],143,"computed (char. table)"],
["Suz",["Size",2],142,"computed (char. table)"],
["Suz",["Size",4],110,"computed (char. table)"],
["Suz",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Suz",["Size",3],64,"computed (char. table)"],
["Suz",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Suz",["Size",5],143,"computed (char. table)"],
["Suz",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Suz",["Size",7],143,"computed (char. table)"],
["Suz",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Suz",["Size",11],143,"computed (char. table)"],
["Suz",["Characteristic",11,"complete"],true,"computed (char. table)"],
["Suz",["Size",13],143,"computed (char. table)"],
["Suz",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Suz.2","NrMovedPoints",1782,"computed (char. table)"],
["Suz.2","NrMovedPoints",1782,"computed (subgroup tables)"],
["Suz.2","NrMovedPoints",1782,"computed (subgroup tables, known repres.)"],
["Suz.2",["Characteristic",0],143,"computed (char. table)"],
["Suz.2",["Characteristic",2],142,"computed (char. table)"],
["Suz.2",["Characteristic",3],64,"computed (char. table)"],
["Suz.2",["Characteristic",5],143,"computed (char. table)"],
["Suz.2",["Characteristic",7],143,"computed (char. table)"],
["Suz.2",["Characteristic",11],143,"computed (char. table)"],
["Suz.2",["Characteristic",13],143,"computed (char. table)"],
["Suz.2",["Size",2],142,"computed (char. table)"],
["Suz.2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Suz.2",["Size",3],64,"computed (char. table)"],
["Suz.2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Suz.2",["Size",5],143,"computed (char. table)"],
["Suz.2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Suz.2",["Size",7],143,"computed (char. table)"],
["Suz.2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Suz.2",["Size",11],143,"computed (char. table)"],
["Suz.2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["Suz.2",["Size",13],143,"computed (char. table)"],
["Suz.2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Sz(32)","NrMovedPoints",1025,"computed (char. table)"],
["Sz(32)","NrMovedPoints",1025,"computed (table of marks)"],
["Sz(32)",["Characteristic",0],124,"computed (char. table)"],
["Sz(32)",["Characteristic",2],4,"computed (char. table)"],
["Sz(32)",["Characteristic",5],124,"computed (char. table)"],
["Sz(32)",["Characteristic",31],124,"computed (char. table)"],
["Sz(32)",["Characteristic",41],124,"computed (char. table)"],
["Sz(32)",["Size",2],20,"computed (char. table)"],
["Sz(32)",["Size",32],4,"computed (char. table)"],
["Sz(32)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Sz(32)",["Size",5],124,"computed (char. table)"],
["Sz(32)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Sz(32)",["Size",31],248,"computed (char. table)"],
["Sz(32)",["Size",961],124,"computed (char. table)"],
["Sz(32)",["Characteristic",31,"complete"],true,"computed (char. table)"],
["Sz(32)",["Size",41],124,"computed (char. table)"],
["Sz(32)",["Characteristic",41,"complete"],true,"computed (char. table)"],
["Sz(32).5","NrMovedPoints",1025,"computed (subgroup tables, known repres.)"],
["Sz(32).5",["Characteristic",0],124,"computed (char. table)"],
["Sz(32).5",["Characteristic",2],20,"computed (char. table)"],
["Sz(32).5",["Characteristic",5],124,"computed (char. table)"],
["Sz(32).5",["Characteristic",31],124,"computed (char. table)"],
["Sz(32).5",["Characteristic",41],124,"computed (char. table)"],
["Sz(32).5",["Size",2],20,"computed (char. table)"],
["Sz(32).5",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Sz(32).5",["Size",5],124,"computed (char. table)"],
["Sz(32).5",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Sz(32).5",["Size",31],248,"computed (char. table)"],
["Sz(32).5",["Size",961],124,"computed (char. table)"],
["Sz(32).5",["Characteristic",31,"complete"],true,"computed (char. table)"],
["Sz(32).5",["Size",41],124,"computed (char. table)"],
["Sz(32).5",["Characteristic",41,"complete"],true,"computed (char. table)"],
["Sz(8)","NrMovedPoints",65,"computed (char. table)"],
["Sz(8)","NrMovedPoints",65,"computed (table of marks)"],
["Sz(8)",["Characteristic",0],14,"computed (char. table)"],
["Sz(8)",["Characteristic",2],4,"computed (char. table)"],
["Sz(8)",["Characteristic",5],14,"computed (char. table)"],
["Sz(8)",["Characteristic",7],14,"computed (char. table)"],
["Sz(8)",["Characteristic",13],14,"computed (char. table)"],
["Sz(8)",["Size",2],12,"computed (char. table)"],
["Sz(8)",["Size",8],4,"computed (char. table)"],
["Sz(8)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Sz(8)",["Size",5],14,"computed (char. table)"],
["Sz(8)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Sz(8)",["Size",7],28,"computed (char. table)"],
["Sz(8)",["Size",49],14,"computed (char. table)"],
["Sz(8)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Sz(8)",["Size",13],14,"computed (char. table)"],
["Sz(8)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Sz(8).3","NrMovedPoints",65,"computed (char. table)"],
["Sz(8).3","NrMovedPoints",65,"computed (subgroup tables)"],
["Sz(8).3","NrMovedPoints",65,"computed (subgroup tables, known repres.)"],
["Sz(8).3",["Characteristic",0],14,"computed (char. table)"],
["Sz(8).3",["Characteristic",2],12,"computed (char. table)"],
["Sz(8).3",["Characteristic",3],14,"computed (char. table)"],
["Sz(8).3",["Characteristic",5],14,"computed (char. table)"],
["Sz(8).3",["Characteristic",7],14,"computed (char. table)"],
["Sz(8).3",["Characteristic",13],14,"computed (char. table)"],
["Sz(8).3",["Size",2],12,"computed (char. table)"],
["Sz(8).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["Sz(8).3",["Size",3],28,"computed (char. table)"],
["Sz(8).3",["Size",9],14,"computed (char. table)"],
["Sz(8).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["Sz(8).3",["Size",5],14,"computed (char. table)"],
["Sz(8).3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["Sz(8).3",["Size",7],28,"computed (char. table)"],
["Sz(8).3",["Size",49],14,"computed (char. table)"],
["Sz(8).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["Sz(8).3",["Size",13],14,"computed (char. table)"],
["Sz(8).3",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Th","NrMovedPoints",143127000,"computed (char. table)"],
["Th",["Characteristic",0],248,"computed (char. table)"],
["Th",["Characteristic",13],248,"computed (char. table)"],
["Th",["Characteristic",19],248,"computed (char. table)"],
["Th",["Characteristic",31],248,"computed (char. table)"],
["Th",["Size",13],248,"computed (char. table)"],
["Th",["Characteristic",13,"complete"],true,"computed (char. table)"],
["Th",["Size",19],248,"computed (char. table)"],
["Th",["Characteristic",19,"complete"],true,"computed (char. table)"],
["Th",["Size",31],248,"computed (char. table)"],
["Th",["Characteristic",31,"complete"],true,"computed (char. table)"],
["U3(11)","NrMovedPoints",1332,"computed (table of marks)"],
["U3(11)",["Characteristic",0],110,"computed (char. table)"],
["U3(11)",["Characteristic",2],110,"computed (char. table)"],
["U3(11)",["Characteristic",3],110,"computed (char. table)"],
["U3(11)",["Characteristic",5],110,"computed (char. table)"],
["U3(11)",["Characteristic",11],8,"computed (char. table)"],
["U3(11)",["Characteristic",37],110,"computed (char. table)"],
["U3(11)",["Size",2],110,"computed (char. table)"],
["U3(11)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(11)",["Size",3],110,"computed (char. table)"],
["U3(11)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(11)",["Size",5],110,"computed (char. table)"],
["U3(11)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U3(11)",["Size",11],8,"computed (char. table)"],
["U3(11)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["U3(11)",["Size",37],110,"computed (char. table)"],
["U3(11)",["Characteristic",37,"complete"],true,"computed (char. table)"],
["U3(11).2","NrMovedPoints",1332,"computed (subgroup tables, known repres.)"],
["U3(11).2",["Characteristic",0],110,"computed (char. table)"],
["U3(11).2",["Characteristic",2],110,"computed (char. table)"],
["U3(11).2",["Characteristic",3],110,"computed (char. table)"],
["U3(11).2",["Characteristic",5],110,"computed (char. table)"],
["U3(11).2",["Characteristic",11],8,"computed (char. table)"],
["U3(11).2",["Characteristic",37],110,"computed (char. table)"],
["U3(11).2",["Size",2],110,"computed (char. table)"],
["U3(11).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(11).2",["Size",3],110,"computed (char. table)"],
["U3(11).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(11).2",["Size",5],110,"computed (char. table)"],
["U3(11).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U3(11).2",["Size",11],8,"computed (char. table)"],
["U3(11).2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["U3(11).2",["Size",37],110,"computed (char. table)"],
["U3(11).2",["Characteristic",37,"complete"],true,"computed (char. table)"],
["U3(3)","NrMovedPoints",28,"computed (table of marks)"],
["U3(3)",["Characteristic",0],6,"computed (char. table)"],
["U3(3)",["Characteristic",2],6,"computed (char. table)"],
["U3(3)",["Characteristic",3],3,"computed (char. table)"],
["U3(3)",["Characteristic",7],6,"computed (char. table)"],
["U3(3)",["Size",2],6,"computed (char. table)"],
["U3(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(3)",["Size",3],6,"computed (char. table)"],
["U3(3)",["Size",9],3,"computed (char. table)"],
["U3(3)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(3)",["Size",7],6,"computed (char. table)"],
["U3(3)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(3).2","NrMovedPoints",28,"computed (char. table)"],
["U3(3).2","NrMovedPoints",28,"computed (subgroup tables)"],
["U3(3).2","NrMovedPoints",28,"computed (table of marks)"],
["U3(3).2",["Characteristic",0],6,"computed (char. table)"],
["U3(3).2",["Characteristic",2],6,"computed (char. table)"],
["U3(3).2",["Characteristic",3],6,"computed (char. table)"],
["U3(3).2",["Characteristic",7],6,"computed (char. table)"],
["U3(3).2",["Size",2],6,"computed (char. table)"],
["U3(3).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(3).2",["Size",3],6,"computed (char. table)"],
["U3(3).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(3).2",["Size",7],6,"computed (char. table)"],
["U3(3).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(4)","NrMovedPoints",65,"computed (table of marks)"],
["U3(4)",["Characteristic",0],12,"computed (char. table)"],
["U3(4)",["Characteristic",2],3,"computed (char. table)"],
["U3(4)",["Characteristic",3],12,"computed (char. table)"],
["U3(4)",["Characteristic",5],12,"computed (char. table)"],
["U3(4)",["Characteristic",13],12,"computed (char. table)"],
["U3(4)",["Size",2],12,"computed (char. table)"],
["U3(4)",["Size",4],6,"computed (char. table)"],
["U3(4)",["Size",16],3,"computed (char. table)"],
["U3(4)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(4)",["Size",3],12,"computed (char. table)"],
["U3(4)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(4)",["Size",5],12,"computed (char. table)"],
["U3(4)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U3(4)",["Size",13],12,"computed (char. table)"],
["U3(4)",["Characteristic",13,"complete"],true,"computed (char. table)"],
["U3(4).2","NrMovedPoints",65,"computed (subgroup tables, known repres.)"],
["U3(4).2","NrMovedPoints",65,"computed (table of marks)"],
["U3(4).2",["Characteristic",0],12,"computed (char. table)"],
["U3(4).2",["Characteristic",2],6,"computed (char. table)"],
["U3(4).2",["Characteristic",3],12,"computed (char. table)"],
["U3(4).2",["Characteristic",5],12,"computed (char. table)"],
["U3(4).2",["Characteristic",13],12,"computed (char. table)"],
["U3(4).2",["Size",2],12,"computed (char. table)"],
["U3(4).2",["Size",4],6,"computed (char. table)"],
["U3(4).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(4).2",["Size",3],24,"computed (char. table)"],
["U3(4).2",["Size",9],12,"computed (char. table)"],
["U3(4).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(4).2",["Size",5],12,"computed (char. table)"],
["U3(4).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U3(4).2",["Size",13],12,"computed (char. table)"],
["U3(4).2",["Characteristic",13,"complete"],true,"computed (char. table)"],
["U3(4).4","NrMovedPoints",65,"computed (subgroup tables, known repres.)"],
["U3(4).4",["Characteristic",0],12,"computed (char. table)"],
["U3(4).4",["Characteristic",2],12,"computed (char. table)"],
["U3(4).4",["Characteristic",3],12,"computed (char. table)"],
["U3(4).4",["Characteristic",5],12,"computed (char. table)"],
["U3(4).4",["Characteristic",13],12,"computed (char. table)"],
["U3(4).4",["Size",2],12,"computed (char. table)"],
["U3(4).4",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(4).4",["Size",3],24,"computed (char. table)"],
["U3(4).4",["Size",9],12,"computed (char. table)"],
["U3(4).4",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(4).4",["Size",5],12,"computed (char. table)"],
["U3(4).4",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U3(4).4",["Size",13],12,"computed (char. table)"],
["U3(4).4",["Characteristic",13,"complete"],true,"computed (char. table)"],
["U3(5)","NrMovedPoints",50,"computed (table of marks)"],
["U3(5)",["Characteristic",0],20,"computed (char. table)"],
["U3(5)",["Characteristic",2],20,"computed (char. table)"],
["U3(5)",["Characteristic",3],20,"computed (char. table)"],
["U3(5)",["Characteristic",5],8,"computed (char. table)"],
["U3(5)",["Characteristic",7],20,"computed (char. table)"],
["U3(5)",["Size",2],20,"computed (char. table)"],
["U3(5)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(5)",["Size",3],20,"computed (char. table)"],
["U3(5)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(5)",["Size",5],8,"computed (char. table)"],
["U3(5)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U3(5)",["Size",7],20,"computed (char. table)"],
["U3(5)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(5).2","NrMovedPoints",50,"computed (subgroup tables)"],
["U3(5).2","NrMovedPoints",50,"computed (subgroup tables, known repres.)"],
["U3(5).2","NrMovedPoints",50,"computed (table of marks)"],
["U3(5).2",["Characteristic",0],20,"computed (char. table)"],
["U3(5).2",["Characteristic",2],20,"computed (char. table)"],
["U3(5).2",["Characteristic",3],20,"computed (char. table)"],
["U3(5).2",["Characteristic",5],8,"computed (char. table)"],
["U3(5).2",["Characteristic",7],20,"computed (char. table)"],
["U3(5).2",["Size",2],20,"computed (char. table)"],
["U3(5).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(5).2",["Size",3],20,"computed (char. table)"],
["U3(5).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(5).2",["Size",5],8,"computed (char. table)"],
["U3(5).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U3(5).2",["Size",7],20,"computed (char. table)"],
["U3(5).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(5).3","NrMovedPoints",126,"computed (table of marks)"],
["U3(5).3",["Characteristic",0],20,"computed (char. table)"],
["U3(5).3",["Characteristic",2],20,"computed (char. table)"],
["U3(5).3",["Characteristic",3],20,"computed (char. table)"],
["U3(5).3",["Characteristic",5],8,"computed (char. table)"],
["U3(5).3",["Characteristic",7],20,"computed (char. table)"],
["U3(5).3",["Size",2],20,"computed (char. table)"],
["U3(5).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(5).3",["Size",3],20,"computed (char. table)"],
["U3(5).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(5).3",["Size",5],8,"computed (char. table)"],
["U3(5).3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U3(5).3",["Size",7],20,"computed (char. table)"],
["U3(5).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(7)","NrMovedPoints",344,"computed (table of marks)"],
["U3(7)",["Characteristic",0],42,"computed (char. table)"],
["U3(7)",["Characteristic",2],42,"computed (char. table)"],
["U3(7)",["Characteristic",3],42,"computed (char. table)"],
["U3(7)",["Characteristic",7],3,"computed (char. table)"],
["U3(7)",["Characteristic",43],42,"computed (char. table)"],
["U3(7)",["Size",2],42,"computed (char. table)"],
["U3(7)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(7)",["Size",3],42,"computed (char. table)"],
["U3(7)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(7)",["Size",7],6,"computed (char. table)"],
["U3(7)",["Size",49],3,"computed (char. table)"],
["U3(7)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(7)",["Size",43],42,"computed (char. table)"],
["U3(7)",["Characteristic",43,"complete"],true,"computed (char. table)"],
["U3(8)","NrMovedPoints",513,"computed (table of marks)"],
["U3(8)",["Characteristic",0],56,"computed (char. table)"],
["U3(8)",["Characteristic",2],8,"computed (char. table)"],
["U3(8)",["Characteristic",3],56,"computed (char. table)"],
["U3(8)",["Characteristic",7],56,"computed (char. table)"],
["U3(8)",["Characteristic",19],56,"computed (char. table)"],
["U3(8)",["Size",2],24,"computed (char. table)"],
["U3(8)",["Size",8],8,"computed (char. table)"],
["U3(8)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(8)",["Size",3],56,"computed (char. table)"],
["U3(8)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(8)",["Size",7],56,"computed (char. table)"],
["U3(8)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(8)",["Size",19],56,"computed (char. table)"],
["U3(8)",["Characteristic",19,"complete"],true,"computed (char. table)"],
["U3(8).2","NrMovedPoints",513,"computed (subgroup tables, known repres.)"],
["U3(8).2",["Characteristic",0],56,"computed (char. table)"],
["U3(8).2",["Characteristic",2],8,"computed (char. table)"],
["U3(8).2",["Characteristic",3],56,"computed (char. table)"],
["U3(8).2",["Characteristic",7],56,"computed (char. table)"],
["U3(8).2",["Characteristic",19],56,"computed (char. table)"],
["U3(8).2",["Size",2],24,"computed (char. table)"],
["U3(8).2",["Size",8],8,"computed (char. table)"],
["U3(8).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(8).2",["Size",3],56,"computed (char. table)"],
["U3(8).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(8).2",["Size",7],112,"computed (char. table)"],
["U3(8).2",["Size",49],56,"computed (char. table)"],
["U3(8).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(8).2",["Size",19],56,"computed (char. table)"],
["U3(8).2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["U3(8).3_1","NrMovedPoints",513,"computed (subgroup tables, known repres.)"],
["U3(8).3_1",["Characteristic",0],56,"computed (char. table)"],
["U3(8).3_1",["Characteristic",2],24,"computed (char. table)"],
["U3(8).3_1",["Characteristic",3],56,"computed (char. table)"],
["U3(8).3_1",["Characteristic",7],56,"computed (char. table)"],
["U3(8).3_1",["Characteristic",19],56,"computed (char. table)"],
["U3(8).3_1",["Size",2],24,"computed (char. table)"],
["U3(8).3_1",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(8).3_1",["Size",3],56,"computed (char. table)"],
["U3(8).3_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(8).3_1",["Size",7],56,"computed (char. table)"],
["U3(8).3_1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(8).3_1",["Size",19],56,"computed (char. table)"],
["U3(8).3_1",["Characteristic",19,"complete"],true,"computed (char. table)"],
["U3(8).3_2","NrMovedPoints",513,"computed (subgroup tables, known repres.)"],
["U3(8).3_2",["Characteristic",0],56,"computed (char. table)"],
["U3(8).3_2",["Characteristic",2],8,"computed (char. table)"],
["U3(8).3_2",["Characteristic",3],56,"computed (char. table)"],
["U3(8).3_2",["Characteristic",7],56,"computed (char. table)"],
["U3(8).3_2",["Characteristic",19],56,"computed (char. table)"],
["U3(8).3_2",["Size",2],24,"computed (char. table)"],
["U3(8).3_2",["Size",8],8,"computed (char. table)"],
["U3(8).3_2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(8).3_2",["Size",3],56,"computed (char. table)"],
["U3(8).3_2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(8).3_2",["Size",7],56,"computed (char. table)"],
["U3(8).3_2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(8).3_2",["Size",19],56,"computed (char. table)"],
["U3(8).3_2",["Characteristic",19,"complete"],true,"computed (char. table)"],
["U3(8).3_3","NrMovedPoints",513,"computed (subgroup tables, known repres.)"],
["U3(8).3_3",["Characteristic",0],56,"computed (char. table)"],
["U3(8).3_3",["Characteristic",2],24,"computed (char. table)"],
["U3(8).3_3",["Characteristic",3],56,"computed (char. table)"],
["U3(8).3_3",["Characteristic",7],56,"computed (char. table)"],
["U3(8).3_3",["Characteristic",19],56,"computed (char. table)"],
["U3(8).3_3",["Size",2],24,"computed (char. table)"],
["U3(8).3_3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(8).3_3",["Size",3],56,"computed (char. table)"],
["U3(8).3_3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(8).3_3",["Size",7],56,"computed (char. table)"],
["U3(8).3_3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(8).3_3",["Size",19],56,"computed (char. table)"],
["U3(8).3_3",["Characteristic",19,"complete"],true,"computed (char. table)"],
["U3(8).6","NrMovedPoints",513,"computed (subgroup tables, known repres.)"],
["U3(8).6",["Characteristic",0],56,"computed (char. table)"],
["U3(8).6",["Characteristic",2],24,"computed (char. table)"],
["U3(8).6",["Characteristic",3],56,"computed (char. table)"],
["U3(8).6",["Characteristic",7],56,"computed (char. table)"],
["U3(8).6",["Characteristic",19],56,"computed (char. table)"],
["U3(8).6",["Size",2],24,"computed (char. table)"],
["U3(8).6",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(8).6",["Size",3],56,"computed (char. table)"],
["U3(8).6",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(8).6",["Size",7],112,"computed (char. table)"],
["U3(8).6",["Size",49],56,"computed (char. table)"],
["U3(8).6",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(8).6",["Size",19],56,"computed (char. table)"],
["U3(8).6",["Characteristic",19,"complete"],true,"computed (char. table)"],
["U3(8).S3","NrMovedPoints",513,"computed (subgroup tables, known repres.)"],
["U3(8).S3",["Characteristic",0],56,"computed (char. table)"],
["U3(8).S3",["Characteristic",2],8,"computed (char. table)"],
["U3(8).S3",["Characteristic",3],56,"computed (char. table)"],
["U3(8).S3",["Characteristic",7],56,"computed (char. table)"],
["U3(8).S3",["Characteristic",19],56,"computed (char. table)"],
["U3(8).S3",["Size",2],24,"computed (char. table)"],
["U3(8).S3",["Size",8],8,"computed (char. table)"],
["U3(8).S3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(8).S3",["Size",3],56,"computed (char. table)"],
["U3(8).S3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(8).S3",["Size",7],112,"computed (char. table)"],
["U3(8).S3",["Size",49],56,"computed (char. table)"],
["U3(8).S3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U3(8).S3",["Size",19],56,"computed (char. table)"],
["U3(8).S3",["Characteristic",19,"complete"],true,"computed (char. table)"],
["U3(9)","NrMovedPoints",730,"computed (table of marks)"],
["U3(9)",["Characteristic",0],72,"computed (char. table)"],
["U3(9)",["Characteristic",2],72,"computed (char. table)"],
["U3(9)",["Characteristic",3],3,"computed (char. table)"],
["U3(9)",["Characteristic",5],72,"computed (char. table)"],
["U3(9)",["Characteristic",73],72,"computed (char. table)"],
["U3(9)",["Size",2],72,"computed (char. table)"],
["U3(9)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U3(9)",["Size",3],12,"computed (char. table)"],
["U3(9)",["Size",9],6,"computed (char. table)"],
["U3(9)",["Size",81],3,"computed (char. table)"],
["U3(9)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U3(9)",["Size",73],72,"computed (char. table)"],
["U3(9)",["Characteristic",73,"complete"],true,"computed (char. table)"],
["U4(2)","NrMovedPoints",27,"computed (subgroup tables)"],
["U4(2)","NrMovedPoints",27,"computed (subgroup tables, known repres.)"],
["U4(2)","NrMovedPoints",27,"computed (table of marks)"],
["U4(2)",["Characteristic",0],5,"computed (char. table)"],
["U4(2)",["Characteristic",2],4,"computed (char. table)"],
["U4(2)",["Characteristic",3],5,"computed (char. table)"],
["U4(2)",["Characteristic",5],5,"computed (char. table)"],
["U4(2)",["Size",2],6,"computed (char. table)"],
["U4(2)",["Size",4],4,"computed (char. table)"],
["U4(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U4(2)",["Size",3],5,"computed (char. table)"],
["U4(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U4(2)",["Size",5],6,"computed (char. table)"],
["U4(2)",["Size",25],5,"computed (char. table)"],
["U4(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U4(2).2","NrMovedPoints",27,"computed (subgroup tables)"],
["U4(2).2","NrMovedPoints",27,"computed (subgroup tables, known repres.)"],
["U4(2).2","NrMovedPoints",27,"computed (table of marks)"],
["U4(2).2",["Characteristic",0],6,"computed (char. table)"],
["U4(2).2",["Characteristic",2],6,"computed (char. table)"],
["U4(2).2",["Characteristic",3],5,"computed (char. table)"],
["U4(2).2",["Characteristic",5],6,"computed (char. table)"],
["U4(2).2",["Size",2],6,"computed (char. table)"],
["U4(2).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U4(2).2",["Size",3],5,"computed (char. table)"],
["U4(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U4(2).2",["Size",5],6,"computed (char. table)"],
["U4(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U4(3)","NrMovedPoints",112,"computed (char. table)"],
["U4(3)","NrMovedPoints",112,"computed (table of marks)"],
["U4(3)",["Characteristic",0],21,"computed (char. table)"],
["U4(3)",["Characteristic",2],20,"computed (char. table)"],
["U4(3)",["Characteristic",3],15,"computed (char. table)"],
["U4(3)",["Characteristic",5],21,"computed (char. table)"],
["U4(3)",["Characteristic",7],21,"computed (char. table)"],
["U4(3)",["Size",2],20,"computed (char. table)"],
["U4(3)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U4(3)",["Size",3],15,"computed (char. table)"],
["U4(3)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U4(3)",["Size",5],21,"computed (char. table)"],
["U4(3)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U4(3)",["Size",7],21,"computed (char. table)"],
["U4(3)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U4(3).2_1","NrMovedPoints",112,"computed (table of marks)"],
["U4(3).2_1",["Characteristic",0],21,"computed (char. table)"],
["U4(3).2_1",["Characteristic",2],20,"computed (char. table)"],
["U4(3).2_1",["Characteristic",3],15,"computed (char. table)"],
["U4(3).2_1",["Characteristic",5],21,"computed (char. table)"],
["U4(3).2_1",["Characteristic",7],21,"computed (char. table)"],
["U4(3).2_1",["Size",2],20,"computed (char. table)"],
["U4(3).2_1",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U4(3).2_1",["Size",3],15,"computed (char. table)"],
["U4(3).2_1",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U4(3).2_1",["Size",5],21,"computed (char. table)"],
["U4(3).2_1",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U4(3).2_1",["Size",7],21,"computed (char. table)"],
["U4(3).2_1",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U4(3).2_2",["Characteristic",0],21,"computed (char. table)"],
["U4(3).2_2",["Characteristic",2],20,"computed (char. table)"],
["U4(3).2_2",["Characteristic",3],15,"computed (char. table)"],
["U4(3).2_2",["Characteristic",5],21,"computed (char. table)"],
["U4(3).2_2",["Characteristic",7],21,"computed (char. table)"],
["U4(3).2_2",["Size",2],20,"computed (char. table)"],
["U4(3).2_2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U4(3).2_2",["Size",3],15,"computed (char. table)"],
["U4(3).2_2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U4(3).2_2",["Size",5],21,"computed (char. table)"],
["U4(3).2_2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U4(3).2_2",["Size",7],21,"computed (char. table)"],
["U4(3).2_2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U4(3).2_3","NrMovedPoints",112,"computed (subgroup tables)"],
["U4(3).2_3","NrMovedPoints",112,"computed (table of marks)"],
["U4(3).2_3",["Characteristic",0],21,"computed (char. table)"],
["U4(3).2_3",["Characteristic",2],20,"computed (char. table)"],
["U4(3).2_3",["Characteristic",3],15,"computed (char. table)"],
["U4(3).2_3",["Characteristic",5],21,"computed (char. table)"],
["U4(3).2_3",["Characteristic",7],21,"computed (char. table)"],
["U4(3).2_3",["Size",2],20,"computed (char. table)"],
["U4(3).2_3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U4(3).2_3",["Size",3],15,"computed (char. table)"],
["U4(3).2_3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U4(3).2_3",["Size",5],21,"computed (char. table)"],
["U4(3).2_3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U4(3).2_3",["Size",7],21,"computed (char. table)"],
["U4(3).2_3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U4(3).4",["Characteristic",0],21,"computed (char. table)"],
["U4(3).4",["Characteristic",2],20,"computed (char. table)"],
["U4(3).4",["Characteristic",3],15,"computed (char. table)"],
["U4(3).4",["Characteristic",5],21,"computed (char. table)"],
["U4(3).4",["Characteristic",7],21,"computed (char. table)"],
["U4(3).4",["Size",2],20,"computed (char. table)"],
["U4(3).4",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U4(3).4",["Size",3],15,"computed (char. table)"],
["U4(3).4",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U4(3).4",["Size",5],21,"computed (char. table)"],
["U4(3).4",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U4(3).4",["Size",7],21,"computed (char. table)"],
["U4(3).4",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U4(3).D8","NrMovedPoints",112,"computed (subgroup tables, known repres.)"],
["U4(3).D8",["Characteristic",0],21,"computed (char. table)"],
["U4(3).D8",["Characteristic",2],20,"computed (char. table)"],
["U4(3).D8",["Characteristic",3],15,"computed (char. table)"],
["U4(3).D8",["Characteristic",5],21,"computed (char. table)"],
["U4(3).D8",["Characteristic",7],21,"computed (char. table)"],
["U4(3).D8",["Size",2],20,"computed (char. table)"],
["U4(3).D8",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U4(3).D8",["Size",3],15,"computed (char. table)"],
["U4(3).D8",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U4(3).D8",["Size",5],21,"computed (char. table)"],
["U4(3).D8",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U4(3).D8",["Size",7],21,"computed (char. table)"],
["U4(3).D8",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U4(4)",["Characteristic",0],51,"computed (char. table)"],
["U4(5)",["Characteristic",0],104,"computed (char. table)"],
["U5(2)","NrMovedPoints",165,"computed (char. table)"],
["U5(2)","NrMovedPoints",165,"computed (table of marks)"],
["U5(2)",["Characteristic",0],10,"computed (char. table)"],
["U5(2)",["Characteristic",2],5,"computed (char. table)"],
["U5(2)",["Characteristic",3],10,"computed (char. table)"],
["U5(2)",["Characteristic",5],10,"computed (char. table)"],
["U5(2)",["Characteristic",11],10,"computed (char. table)"],
["U5(2)",["Size",2],10,"computed (char. table)"],
["U5(2)",["Size",4],5,"computed (char. table)"],
["U5(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U5(2)",["Size",3],10,"computed (char. table)"],
["U5(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U5(2)",["Size",5],10,"computed (char. table)"],
["U5(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U5(2)",["Size",11],10,"computed (char. table)"],
["U5(2)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["U5(2).2","NrMovedPoints",165,"computed (subgroup tables, known repres.)"],
["U5(2).2",["Characteristic",0],10,"computed (char. table)"],
["U5(2).2",["Characteristic",2],10,"computed (char. table)"],
["U5(2).2",["Characteristic",3],10,"computed (char. table)"],
["U5(2).2",["Characteristic",5],10,"computed (char. table)"],
["U5(2).2",["Characteristic",11],10,"computed (char. table)"],
["U5(2).2",["Size",2],10,"computed (char. table)"],
["U5(2).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U5(2).2",["Size",3],10,"computed (char. table)"],
["U5(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U5(2).2",["Size",5],20,"computed (char. table)"],
["U5(2).2",["Size",25],10,"computed (char. table)"],
["U5(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U5(2).2",["Size",11],10,"computed (char. table)"],
["U5(2).2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["U5(4)",["Characteristic",0],204,"computed (char. table)"],
["U6(2)","NrMovedPoints",672,"computed (char. table)"],
["U6(2)",["Characteristic",0],22,"computed (char. table)"],
["U6(2)",["Characteristic",2],20,"computed (char. table)"],
["U6(2)",["Characteristic",3],21,"computed (char. table)"],
["U6(2)",["Characteristic",5],22,"computed (char. table)"],
["U6(2)",["Characteristic",7],22,"computed (char. table)"],
["U6(2)",["Characteristic",11],22,"computed (char. table)"],
["U6(2)",["Size",2],20,"computed (char. table)"],
["U6(2)",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U6(2)",["Size",3],21,"computed (char. table)"],
["U6(2)",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U6(2)",["Size",5],22,"computed (char. table)"],
["U6(2)",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U6(2)",["Size",7],22,"computed (char. table)"],
["U6(2)",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U6(2)",["Size",11],22,"computed (char. table)"],
["U6(2)",["Characteristic",11,"complete"],true,"computed (char. table)"],
["U6(2).2","NrMovedPoints",672,"computed (subgroup tables)"],
["U6(2).2","NrMovedPoints",672,"computed (subgroup tables, known repres.)"],
["U6(2).2",["Characteristic",0],22,"computed (char. table)"],
["U6(2).2",["Characteristic",2],20,"computed (char. table)"],
["U6(2).2",["Characteristic",3],21,"computed (char. table)"],
["U6(2).2",["Characteristic",5],22,"computed (char. table)"],
["U6(2).2",["Characteristic",7],22,"computed (char. table)"],
["U6(2).2",["Characteristic",11],22,"computed (char. table)"],
["U6(2).2",["Size",2],20,"computed (char. table)"],
["U6(2).2",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U6(2).2",["Size",3],21,"computed (char. table)"],
["U6(2).2",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U6(2).2",["Size",5],22,"computed (char. table)"],
["U6(2).2",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U6(2).2",["Size",7],22,"computed (char. table)"],
["U6(2).2",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U6(2).2",["Size",11],22,"computed (char. table)"],
["U6(2).2",["Characteristic",11,"complete"],true,"computed (char. table)"],
["U6(2).3",["Characteristic",0],22,"computed (char. table)"],
["U6(2).3",["Characteristic",2],20,"computed (char. table)"],
["U6(2).3",["Characteristic",3],21,"computed (char. table)"],
["U6(2).3",["Characteristic",5],22,"computed (char. table)"],
["U6(2).3",["Characteristic",7],22,"computed (char. table)"],
["U6(2).3",["Characteristic",11],22,"computed (char. table)"],
["U6(2).3",["Size",2],20,"computed (char. table)"],
["U6(2).3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U6(2).3",["Size",3],21,"computed (char. table)"],
["U6(2).3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U6(2).3",["Size",5],22,"computed (char. table)"],
["U6(2).3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U6(2).3",["Size",7],22,"computed (char. table)"],
["U6(2).3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U6(2).3",["Size",11],22,"computed (char. table)"],
["U6(2).3",["Characteristic",11,"complete"],true,"computed (char. table)"],
["U6(2).S3",["Characteristic",0],22,"computed (char. table)"],
["U6(2).S3",["Characteristic",2],20,"computed (char. table)"],
["U6(2).S3",["Characteristic",3],21,"computed (char. table)"],
["U6(2).S3",["Characteristic",5],22,"computed (char. table)"],
["U6(2).S3",["Characteristic",7],22,"computed (char. table)"],
["U6(2).S3",["Characteristic",11],22,"computed (char. table)"],
["U6(2).S3",["Size",2],20,"computed (char. table)"],
["U6(2).S3",["Characteristic",2,"complete"],true,"computed (char. table)"],
["U6(2).S3",["Size",3],21,"computed (char. table)"],
["U6(2).S3",["Characteristic",3,"complete"],true,"computed (char. table)"],
["U6(2).S3",["Size",5],22,"computed (char. table)"],
["U6(2).S3",["Characteristic",5,"complete"],true,"computed (char. table)"],
["U6(2).S3",["Size",7],22,"computed (char. table)"],
["U6(2).S3",["Characteristic",7,"complete"],true,"computed (char. table)"],
["U6(2).S3",["Size",11],22,"computed (char. table)"],
["U6(2).S3",["Characteristic",11,"complete"],true,"computed (char. table)"],
["W(F4)","NrMovedPoints",24,"computed (table of marks)"],
["W(F4)",["Characteristic",0],4,"computed (char. table)"],
["W(F4)",["Characteristic",3],4,"computed (char. table)"],
["W(F4)",["Size",3],4,"computed (char. table)"],
["W(F4)",["Characteristic",3,"complete"],true,"computed (char. table)"],
];;

for entry in MinimalRepresentationInfoData.datalist do
  CallFuncList( SetMinimalRepresentationInfo, entry );
od;

#############################################################################
##
#E

