.\"
.\" $Id: cvtfun.man,v 1.1.1.1 2000/01/16 05:07:58 ura Exp $
.\"

.\" FreeWnn is a network-extensible Kana-to-Kanji conversion system.
.\" This file is part of FreeWnn.
.\" 
.\" Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
.\" Copyright 1991, 1992 by Massachusetts Institute of Technology
.\"
.\" Author: OMRON SOFTWARE Co., Ltd. <freewnn@rd.kyoto.omronsoft.co.jp>
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2, or (at your option)
.\" any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with GNU Emacs; see the file COPYING.  If not, write to the
.\" Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" Commentary:
.\"
.\" Change log:
.\"
.\" Last modified date: 8,Feb.1999
.\"

.TH CVTFUN 4 "Release 5" "X Version 11"
.SH NAME
cvt_fun_tbl \- Function key conversion table of Input Manager of the X
Window System Version 11 (xwnmo(1X))
.SH SYNOPSIS
.B /usr/local/lib/wnn/cvt_fun_tbl
(Default)
.SH DESCRIPTION
Converts a function key code(\fIKeySym\fP) generated by \fIXLookupString()\fP
to a one-byte character(\fIWnn code\fP) according to preset data.
.PP
.TP 8
.B Coding format:
[ \fIKeySym-entry\fP <space_character> \fPWnn-code\fP ]
.PP
Lines that start with a semicolon (;) are comments.
.TP 8
.B Code notation:
0??             ---> Octal
.br
0x?? or 0X??    ---> Hexadecimal
.br
??              ---> Decimal
.SH EXAMPLE
Kanji           0x81
.br
Left            0x82
.br
Up              0x83
.br
Right           0x84
.br
Down            0x92
.br
F1              0x91
.br
F2              0x90
.br
F3              0x93
.SH NOTES
Codes converted according to this table will be evaluated by \fI2A_CTRL\fP
(default), which is an alphanumeric-phonetic conversion automation table. 
After which, they are evaluated by \fIuumkey\fP.
.SH "SEE ALSO"
xwnmo(1X), 2A_CTRL(4_JT), uumkey(4_JT), cvt_xim_tbl(4X), cvt_meta_tbl(4X)
.SH COPYRIGHT
Copyright 1991, 1992 by OMRON Corporation
.br
Copyright 1991, 1992 by Massachusetts Institute of Technology
.SH AUTHOR
Seiji Kuwari (OMRON Corporation)
